function chanlist = NDS2_GetChannels(server, chan_type, gps)
%NDS2_GetChannels  Get a list of channels from a LIGO NDS server
%  This function returns a cell array of structures containing information
%  about the channels of which the NDS2 server is aware.
%
%  Usage:
%
%    chanlist = NDS2_GetChannels(server[, chan_type[, gps]])
%
%  Where:
%
%    server   is a string with the NDS2 server ip address and port ('<ip-addr>:<port>')
%    chantype is the channel type string of the requested channels.
%    gps      request channels available at te specified GPS time
%    chanlist is a Matlab cell-array containing channel information
%             name           Channel name
%             channel_type   Channel type string, e.g. 'online', 'raw'.
%             rate           Sample rate
%             data_type      Data type, e.g. 'int_2', 'int_4', 'real_4', 'complex_8'
%             signal_gain    Online signal gain
%             signal_offset  Online signal offset
%             signal_slope   Online signal slope
%             signal_units   Online Signal unit string
%    namelist is a list of channel names and types, e.g. 
%             {'H1:LSC-DARM_ERR,online' 'H2:LSC-DARM_ERR'}
%    start    is the GPS start time of the requested data
%    duration is the number of seconds to fetch.
%
% See also NDS_GetChannels, NDS_GetData, NDS2_GetData.
