dnl -*- m4 -*-
dnl----------------------------------------------------------------------
dnl This is a common set of macros to be used in the configuration of
dnl	the GDS software
dnl----------------------------------------------------------------------

dnl ---------------------------------------------------------------------
 
AC_DEFUN([AC_NDS2C_PROG_CC],
[ AC_PROG_CC
if test "${GCC}" = "yes"
then
  touch ,t.c
  ac_dmt_default_cc_includes="`${CC} -v ,t.c 2>&1 | \
        sed -n -e '/\#include/,/End of search list\./p' | \
        egrep '^ '`"
  rm ,t.c
fi
SENDS_CC_FLAVOR="generic"
case $CC in
gcc|*/gcc) SENDS_CC_FLAVOR="gnu";;
cc|*/cc)
    case "`$CC -V 2>&1`" in
    *Sun\ C\ *)
      SENDS_CC_FLAVOR="SunPRO"
      ;;
    esac
    ;;
esac
AM_CONDITIONAL([SENDS_CC_SUNPRO],[test x$SENDS_CC_FLAVOR = xSunPRO])
])
 
dnl ---------------------------------------------------------------------
 
AC_DEFUN([AC_NDS2C_PROG_CXX],
[ AC_PROG_CXX
if test "${GXX}" = "yes"
then
  touch ,t.cc
  ac_dmt_default_cxx_includes="`${CXX} -v ,t.cc 2>&1 | \
        sed -n -e '/\#include/,/End of search list\./p' | \
        egrep '^ '`"
  rm ,t.cc
fi
SENDS_CXX_FLAVOR="generic"
case $CXX in
gcc|*/gcc|g++|*/g++) SENDS_CXX_FLAVOR="gnu";;
CC|*/CC)
    case "`$CXX -V 2>&1`" in
    *Sun\ C++*)
      SENDS_CXX_FLAVOR="SunPRO"
      ;;
    esac
    ;;
esac
AC_SYS_LARGEFILE
AM_CONDITIONAL([SENDS_CXX_SUNPRO],[test x$SENDS_CXX_FLAVOR = xSunPRO])
])

dnl======================================================================
dnl NDS2_CHECK_BITW
dnl   Check bit width
dnl======================================================================

AC_DEFUN([AC_NDS2C_CHECK_BITW],
[
  dnl ===================================================================
  dnl  Test 32/64-bit architecture
  dnl ===================================================================
bit_size=
AC_ARG_ENABLE(64bit,
	      AC_HELP_STRING([--enable-64bit], [64-bit compilation]),
	      [bit_size="-m64"]
)
AC_ARG_ENABLE(32bit,
	      AC_HELP_STRING([--enable-32bit], [32-bit compilation]),
	      [bit_size="-m32"]
)
  CXXFLAGS="$CXXFLAGS $bit_size"
  CFLAGS="$CFLAGS $bit_size"
  LDFLAGS="$LDFLAGS $bit_size"
])

dnl======================================================================
dnl SENDS_CHECK_SSL
dnl   Check if OpenSSL is installed
dnl======================================================================

AC_DEFUN([AC_NDS2C_CHECK_SSL],
[
have_ssl=
PKG_CHECK_MODULES(OPENSSL, openssl, have_ssl="yes", have_ssl="no")
if test "${have_ssl}" = "yes"
then
ssllibs="$OPENSSL_LIBS"
sslcflags="$OPENSSL_CFLAGS"
fi
if test "${have_ssl}" = "no"
then
ssllibs="-lssl"
sslcflags=""
fi
AC_SUBST(ssllibs)
AC_SUBST(sslcflags)
])

dnl======================================================================
dnl SENDS_CHECK_SASL
dnl   Check if OpenSSL is installed
dnl======================================================================

AC_DEFUN([AC_NDS2C_CHECK_SASL],
[
_tmp_search_dirs="/usr /usr/local /opt/local /sw"
sasllibs=
saslcflags=
have_sasl=no
enab_gss=no
AC_MSG_CHECKING([for request SASL emulation with GSSAPI])
AC_ARG_WITH(gssapi, 
	    AC_HELP_STRING([--with-gssapi@<:@=DIR@:>@],
			   [gssapi library location @<:@GSSAPI/lib@:>@]) )
case "$with_gssapi" in
"no"|"")
  with_gssapi="no"
  ;;
"yes")
  find_gssapi_include="$find_gssapi_include ${_tmp_search_dirs}"
  for gssapi_inc in $find_gssapi_include; do
    if test -d "$gssapi_inc/include/gssapi"
    then
      saslcflags="$saslcflags -DHAVE_GSSAPI=1 -I${gssapi_inc}/include"
      with_gssapi="${gssapi_inc}"
      break
    elif test -d "$gssapi_inc/include/gssglue/gssapi"
    then
      saslcflags="$saslcflags -DHAVE_GSSAPI=1 -I${gssapi_inc}/include/gssglue"
      with_gssapi="${gssapi_inc}"
      break
    fi
  done
  for gssapilib in gssapi_krb5 gssglue
  do
    AC_CHECK_LIB([$gssapilib],
	         [gss_init_sec_context],
                 [sasllibs="-l${gssapilib} ${sasllibs}" ; break; ])
  done
  ;;
*)
  saslcflags="$saslcflags -DHAVE_GSSAPI=1 -I${with_gssapi}/include"
  sasllibs="-L${with_gssapi}/lib -lgssapi_krb5 ${sasllibs}"
  ;;
esac
AC_MSG_RESULT( [ ${with_gssapi} ] )
AC_MSG_CHECKING([for user specified sasl library])
AC_ARG_WITH(sasl, 
	    AC_HELP_STRING([--with-sasl@<:@=DIR@:>@],
			   [sasl2 library location @<:@SASL/lib@:>@]
			   ) )
AC_MSG_RESULT( [ ${with_sasl} ] )
case "$with_sasl" in
"no")
    ;;
"yes"|"")
    AC_CHECK_LIB(sasl2, sasl_client_new, [have_sasl=yes], [have_sasl=no])
    if test "${have_sasl}" != "no"
    then
        saslcflags="${saslcflags} -DHAVE_SASL=1"
        sasllibs="-lsasl2 ${sasllibs}"
    else
        AC_CHECK_LIB(sasl, sasl_client_new, [have_sasl=yes], [have_sasl=no])
        if test x${have_sasl} = xyes
        then
            saslcflags="${saslcflags} -DHAVE_SASL=1"
            sasllibs="-lsasl ${sasllibs}"
        fi
    fi
    if test "$have_sasl" != "no"
    then
       have_sasl="no"
       find_sasl_include="$find_sasl_include ${_tmp_search_dirs}"
       for sasl_inc in $find_sasl_include; do
       	   if test -d "$sasl_inc/include/sasl"
	   then
              saslcflags="$saslcflags -I$sasl_inc/include"
	      have_sasl="yes"
	      break
	   fi
       done
    elif test x$enab_gss != xdisable
    then
	saslcflags="$gsscflg"
	sasllibs="$gsslib"
    fi
   ;;
*)
    saslcflags="${saslcflags} -DHAVE_SASL=1 -I${with_sasl}/include"
    sasllibs="-L${with_sasl}/lib -lsasl2 ${sasllibs}"
    have_sasl="yes"
    ;;
esac
AC_SUBST(sasllibs)
AC_SUBST(saslcflags)
AS_IF([test "x$have_sasl" = xyes -a "x$with_gssapi" != xno],
      [AC_MSG_ERROR([--with-sasl and --with-gssapi are mutually exclusive])])
])

dnl======================================================================
dnl SENDS_CHECK_METAIO
dnl   Check if METAIO is installed
dnl======================================================================

AC_DEFUN([AC_NDS2C_CHECK_METAIO],
[
have_metaio=
PKG_CHECK_MODULES(METAIO, libmetaio, have_metaio="yes", have_metaio="no")
if test "${have_metaio}" = "yes"
then
metaiolibs="$METAIO_LIBS"
metaiocflags="$METAIO_CFLAGS"
fi
if test "${have_metaio}" = "no"
then
metaiolibs="-lmetaio"
metaiocflags=""
fi
AM_CONDITIONAL([require_metaio], [test "$have_metaio" = no])
AC_SUBST(metaiolibs)
AC_SUBST(metaiocflags)
])

dnl======================================================================
dnl SENDS_BUILD_TYPE
dnl   Check build type: online, offline, ...
dnl======================================================================

AC_DEFUN([AC_NDS2C_BUILD_TYPE],
[
echo $ECHO_N "checking for SENDSBUILD ... $ECHO_C"
if test "x$buildtype" = "x"
then
  buildtype="$SENDSBUILD"
fi
case "x$buildtype" in
x)
  echo "not specified default: offline $ECHO_C"
  buildtype=offline
  ;;
xonline)
  echo "$buildtype"
  ;;
xoffline)
  echo "$buildtype"
  ;;
*)
  echo "$buildtype $ECHO_C"
  echo "SENDSBUILD must be specified as online or offline - Aborting"
  exit 1
  ;;
esac

AM_CONDITIONAL([online], [test "$buildtype" = "online"])
AM_CONDITIONAL([offline], [test "$buildtype" = "offline"])
])

dnl======================================================================
dnl SENDS_CHECK_POSIX
dnl	
dnl======================================================================

AC_DEFUN([AC_NDS2C_CHECK_POSIX],
[
posixflags="-D_POSIX_C_SOURCE=200112L"
unix98flags="-D_XOPEN_SOURCE=500"
case "${host}" in
*linux*) unix98flags="-D_XOPEN_SOURCE=600" ;;
esac
])

dnl======================================================================
dnl AC_NDS2C_FINISH - Things to be done at the very end for SENDS
dnl======================================================================
 
AC_DEFUN([AC_NDS2C_FINISH],
[
  dnl ===================================================================
  dnl  Setup $architecture
  dnl ===================================================================
architecture=
case "${host}" in
*linux*) architecture="linux" ;;
*solaris*) architecture="solaris" ;;
esac
AC_SUBST(architecture)
  dnl ===================================================================
  dnl  Setup $syslibs
  dnl ===================================================================
syslibs=
case "${host}" in
*linux*) syslibs= ;;
*solaris*) syslibs="-lrt" ;;
esac
AC_SUBST(syslibs)
  dnl ===================================================================
  dnl  Setup $sysmtlibs
  dnl ===================================================================
sysmtlibs=
case "${host}" in
*linux*) sysmtlibs="-lpthread" ;;
*solaris*) sysmtlibs="-lrt -lpthread" ;;
esac
AC_SUBST(sysmtlibs)
  dnl ===================================================================
  dnl  Setup $netlib
  dnl ===================================================================
netlib=
case "${host}" in
*linux*) netlib="" ;;
*solaris*) netlib="-lnsl -lsocket" ;;
esac
AC_SUBST(netlib)
  dnl ===================================================================
  dnl  Setup $readlinelibs
  dnl ===================================================================
readlinelibs=
case "${host}" in
*linux*) readlinelibs="-lreadline -ltermcap" ;;
*solaris*) readlinelibs="-lreadline -ltermcap" ;;
esac
AC_SUBST(readlinelibs)
  dnl ===================================================================
  dnl  Specify warning message level
  dnl ===================================================================
case "$SENDS_CC_FLAVOR" in
gnu)
  AM_CFLAGS="$AM_CFLAGS $posixflags $unix98flags"
  CFLAGS="$CFLAGS -pipe -fPIC -Wall"
  ;;
SunPRO)
  CFLAGS="$CFLAGS -v -KPIC -xc99=none"
  ;;
esac
case "$SENDS_CXX_FLAVOR" in
gnu)
  AM_CXXFLAGS="$AM_CXXFLAGS $posixflags $unix98flags"
  CXXFLAGS="$CXXFLAGS -pipe -fPIC -Wall -Woverloaded-virtual"
  ;;
SunPRO)
  CXXFLAGS="$CXXFLAGS -KPIC"
  ;;
esac
  dnl ===================================================================
  dnl  Writing config files
  dnl ===================================================================
  dnl AC_CONFIG_FILES(config/PConfig.h:config/PConfig.in)
])
