#ifndef NCO_CRT_H /* Contents have not yet been inserted in current source file */
#define NCO_CRT_H


#include        <stdlib.h>
#include        <stdio.h>
#include        <math.h>

/* Personal headers */
#include "nco.h" /* netCDF Operator (NCO) definitions */
#include "nco_mmr.h"     /* Memory management */
#include "nco_omp.h"     /* OpenMP utilities */
#include "nco_rgr.h"     /* Regridding */
#include "nco_sld.h"     /* Swath-Like Data */
#include "nco_sng_utl.h" /* String utilities */
#include "nco_ply.h"    /* poly sct stuff */


/* Dimension of points */

#define DSIGMA (1.0e-14)

/* define minimium area in AreaSign (cross-product) */
#define DAREA  1.0e-28  

#define VP_MAX    1000            /* Max # of pts in polygon */

#define ARC_MIN_LENGTH (1.0e-20)


/* if true then longitude 0-360 */
/* we need this to convert 3D back to 2D */
#define IS_LON_360 (1)

#define NBR_CRT (2)
#define DEBUG_CRT (1)


#ifdef __cplusplus
/* Use C-bindings so C++-compiled and C-compiled libraries are compatible */
extern "C" {
#endif /* !__cplusplus */





/*---------------------------------------------------------------------
Function prototypes.
---------------------------------------------------------------------*/

int    nco_crt_intersect(poly_sct *P, poly_sct *Q, poly_sct *R, int *r);

char    nco_crt_seg_int(double *a, double *b, double *c, double *d, double *p, double *q);
char    nco_crt_parallel_int(double *a, double *b, double *c, double *d, double *p, double *q);
int	nco_crt_cross_sgn(double *a, double *b, double *c);
nco_bool  nco_crt_between(double *a, double *b, double *c);

double  nco_crt_dot(double *a, double *b);
void    nco_crt_sub_vec(double *a, double *b, double *c);
void    nco_crt_adi(double *p, double *a);

void nco_crt_add_pnt(double **R, int *r, double *P);

nco_bool  nco_crt_linear(double *a, double *b, double *c);

nco_bool  nco_crt_left_on(double *a, double *b, double *c);
nco_bool  nco_crt_left(double *a, double *b, double *c);

const char * nco_poly_vrl_flg_sng_get(poly_vrl_flg_enm in);

void
nco_crt_set_domain(double lon_min, double lon_max, double lat_min, double lat_max);


nco_bool            /* O [flg] True if point in inside (or on boundary ) of polygon */
nco_crt_pnt_in_poly(
int crn_nbr,
double x_in,
double y_in,
double *lcl_dp_x,
double *lcl_dp_y);

int             /* O [nbr] returns number of points of pl_out that are inside pl_in */
nco_crt_poly_in_poly(
poly_sct *pl_in,
poly_sct *pl_out);


/*-------------------------------------------------------------------*/



#ifdef __cplusplus
} /* end extern "C" */
#endif /* !__cplusplus */

#endif /* NCO_CRT_H */
