# Glossary

| napari term        | description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | synonym/closely related term                                                |
|--------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------|
| canvas             | The canvas in the center of napari viewer contains the visual display of the data passed to napari, including images, points, shapes, and other supported data types.                                                                                                                                                                                                                                                                                                                                                                                                                        |                                                                             |
| channel            | A channel is an image where each pixel only contains its intensity value (i.e. grayscale image). In fluorescence microscopy, each channel corresponds to a range of wavelengths. An RGB image from digital camera consists of 3 channels - red, green, blue (RGB). In napari, an image dimension that is not spatial or temporal can be considered as channels, and is typically represented as individual [image layer](https://napari.org/stable/howtos/layers/image.html). See also [this wiki page](https://en.wikipedia.org/wiki/Channel_(digital_image)) for specific examples.       | raster band in geoscience                                                   |
| colormap           | A colormap represents the value of each pixel as a particular color. In fluorescence microscopy, the colormap can be selected to mirror the color of the collected wavelength. In other applications, colormaps can be used to provide the visual representation of the measured signal. There are many different types of colormaps available, see [choosing colormaps in matplotlib](https://matplotlib.org/stable/tutorials/colors/colormaps.html).                                                                                                                                                                                                                                                                                                                                                                    | look up table, LUT                                                          |
| event              | Events and connections are a way to tell napari "If this event occurs, then call this function". [Hooking up your own events](https://napari.org/stable/howtos/connecting_events.html).                                                                                                                                                                                                                                                                                               |                                                                             |
| hook               | Hooks are places in napari where plugins can offer extended functionality. See the [napari hook specification reference](https://napari.org/stable/plugins/npe1.html#hook-specification-reference) in the [napari plugin documentation](https://napari.org/stable/plugins/index.html).                                                                                                                                                                                                                                                                                               |                                                                             |
| hook specification | A function signature that defines the application programming interface (API) that a plugin developer must adhere to when writing the function that napari promises to call somewhere in the napari codebase. See also [napari hook specifications](https://napari.org/stable/plugins/npe1.html#hook-specification-reference).                                                                                                                                                                                                                                                                             |                                                                             |
| keybinding         | The specific key or key combination that when pressed causes some function to occur. For example, command/control + C triggers "copy" in many operating systems. You can make your own custom keybindings, see this page on [hooking up your own events](https://napari.org/stable/howtos/connecting_events.html).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyboard short cut                                                          |
| mousebinding       | The specific mouse move, click, or drag event that causes some function to occur. You can make your own custom mousebindings, see this page on [hooking up your own events](https://napari.org/stable/howtos/connecting_events.html).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | mouse short cut                                                             |
| layer              | Layers are the viewable objects that can be added to napari viewer. Currently napari supports the following layers: [image](https://napari.org/stable/howtos/layers/image.html), [labels](https://napari.org/stable/howtos/layers/labels.html), [points](https://napari.org/stable/howtos/layers/points.html), [shapes](https://napari.org/stable/howtos/layers/shapes.html), [surface](https://napari.org/stable/howtos/layers/surface.html), [tracks](https://napari.org/stable/howtos/layers/tracks.html), [vectors](https://napari.org/stable/howtos/layers/vectors.html). |                                                                             |
| label              | A label is a region of an integer image where the pixels are the same unique value. It is implemented in napari in the [labels layer](https://napari.org/stable/howtos/layers/labels.html) where each label represents a unique object, feature or classification.                                                                                                                                                                                                                                                                                                                         |                                                                             |
| point              | A point is defined by the coordinate in space. The [points layer](https://napari.org/stable/howtos/layers/points.html)  allows you to display an NxD array of N points in D coordinates.                                                                                                                                                                                                                                                                                                                                                                                                       |                                                                             |
| shape              | Shapes are visual representations of N points in D coordinates. Shapes can be used as a visualization tool to indicate region of interest (ROI) or for downstream operations. In napari, the [shapes layer](https://napari.org/stable/howtos/layers/shapes.html) is a viewable object that permits visualization of the following supported shapes: rectangle, ellipses, polygons, paths, and lines.                                                                                                                                                                                                                 | [area selection tools in ImageJ](https://imagej.nih.gov/ij/docs/tools.html) |
| surface            | A surface comprises a set of triangles (typically in three dimensions) that are connected by their common edges or corners to form the mesh. See [napari surface layer tutorial](https://napari.org/stable/howtos/layers/surface.html) for current implementation and [this wiki page](https://en.wikipedia.org/wiki/Surface_triangulation) for additional information.                                                                                                                                                                                                                    |                                                                             |
| track              | A track describes object trajectories along the time dimension. The [tracks layer](https://napari.org/stable/howtos/layers/tracks.html) defines a track by the list containing object coordinates and the time point, with each track assigned a unique track ID.                                                                                                                                                                                                                                                                                                                              |                                                                             |
| vector             | A vector is a line defined by its start and end positions in space. The [vectors layer](https://napari.org/stable/howtos/layers/vectors.html) renders lines onto the canvas, with input data format as Nx2xD numpy array representing N vectors in D dimensions.                                                                                                                                                                                                                                                                                                                               |                                                                             |
| widget             | A small, composable graphical user interface component that can extend user's ability to interact with layers and other napari functions. A widget could be a simple one parameter/control (e.g. a button) or a collection of multiple controls with data output.                                                                                                                                                                                                                                                                                                                                                                                                              | [dialog in ImageJ](https://imagej.net/scripting/generic-dialog)             |
| dock widget        | A widget that can be attached (docked) to the main napari viewer at a specified position.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                                             |
| plugin             | A napari plugin is a specialized Python package that extends napari's functionality. Examples of extended functionality include: additional file i/o support, image analysis, and other utilities. Plugin developers specify this functionality through a combination of Python entry points and a specialized manifest file. Plugins for napari can be found at [napari hub](https://www.napari-hub.org/). For a guide on how to make your own custom plugin, see [creating a napari plugin](https://napari.org/stable/plugins/index.html).                                                                                                                                                                                 |                                                                             |
