#
#script to prepare database against which TPCH variant queries will be fired.
#

CREATE TABLE REGION(R_REGIONKEY INT(11) NOT NULL,
                    R_NAME CHAR(25) COLLATE ASCII_BIN NOT NULL,
                    R_COMMENT VARCHAR(152) COLLATE ASCII_BIN DEFAULT NULL,
                    PRIMARY KEY(R_REGIONKEY));

CREATE TABLE NATION(N_NATIONKEY INT(11) NOT NULL,
                    N_NAME CHAR(25) COLLATE ASCII_BIN NOT NULL,
                    N_REGIONKEY INT(11) NOT NULL,
                    N_COMMENT VARCHAR(152) COLLATE ASCII_BIN DEFAULT NULL,
                    PRIMARY KEY(N_NATIONKEY), KEY NATION_FK1(N_REGIONKEY),
                    CONSTRAINT NATION_FK1 FOREIGN KEY(N_REGIONKEY)
                        REFERENCES REGION(R_REGIONKEY));

CREATE TABLE CUSTOMER(C_CUSTKEY INT(11) NOT NULL,
                      C_NAME VARCHAR(25) COLLATE ASCII_BIN NOT NULL,
                      C_ADDRESS VARCHAR(40) COLLATE ASCII_BIN NOT NULL,
                      C_NATIONKEY INT(11) NOT NULL,
                      C_PHONE CHAR(15) COLLATE ASCII_BIN NOT NULL,
                      C_ACCTBAL DECIMAL(15, 2) NOT NULL,
                      C_MKTSEGMENT CHAR(10) COLLATE ASCII_BIN NOT NULL,
                      C_COMMENT VARCHAR(117) COLLATE ASCII_BIN NOT NULL,
                      PRIMARY KEY(C_CUSTKEY), KEY CUSTOMER_FK1(C_NATIONKEY),
                      CONSTRAINT CUSTOMER_FK1 FOREIGN KEY(C_NATIONKEY)
                          REFERENCES NATION(N_NATIONKEY));

CREATE TABLE PART(P_PARTKEY INT(11) NOT NULL,
                  P_NAME VARCHAR(55) COLLATE ASCII_BIN NOT NULL,
                  P_MFGR CHAR(25) COLLATE ASCII_BIN NOT NULL,
                  P_BRAND CHAR(10) COLLATE ASCII_BIN NOT NULL,
                  P_TYPE VARCHAR(25) COLLATE ASCII_BIN NOT NULL,
                  P_SIZE INT(11) NOT NULL,
                  P_CONTAINER CHAR(10) COLLATE ASCII_BIN NOT NULL,
                  P_RETAILPRICE DECIMAL(15, 2) NOT NULL,
                  P_COMMENT VARCHAR(23) COLLATE ASCII_BIN NOT NULL,
                  PRIMARY KEY(P_PARTKEY));

CREATE TABLE SUPPLIER(S_SUPPKEY INT(11) NOT NULL,
                      S_NAME CHAR(25) COLLATE ASCII_BIN NOT NULL,
                      S_ADDRESS VARCHAR(40) COLLATE ASCII_BIN NOT NULL,
                      S_NATIONKEY INT(11) NOT NULL,
                      S_PHONE CHAR(15) COLLATE ASCII_BIN NOT NULL,
                      S_ACCTBAL DECIMAL(15, 2) NOT NULL,
                      S_COMMENT VARCHAR(101) COLLATE ASCII_BIN NOT NULL,
                      PRIMARY KEY(S_SUPPKEY), KEY SUPPLIER_FK1(S_NATIONKEY),
                      CONSTRAINT SUPPLIER_FK1 FOREIGN KEY(S_NATIONKEY)
                          REFERENCES NATION(N_NATIONKEY));

CREATE TABLE PARTSUPP(PS_PARTKEY INT(11) NOT NULL, PS_SUPPKEY INT(11) NOT NULL,
                      PS_AVAILQTY INT(11) NOT NULL,
                      PS_SUPPLYCOST DECIMAL(15, 2) NOT NULL,
                      PS_COMMENT VARCHAR(199) COLLATE ASCII_BIN NOT NULL,
                      PRIMARY KEY(PS_PARTKEY, PS_SUPPKEY),
                      KEY PARTSUPP_FK1(PS_SUPPKEY),
                      CONSTRAINT PARTSUPP_FK1 FOREIGN KEY(PS_SUPPKEY)
                          REFERENCES SUPPLIER(S_SUPPKEY),
                      CONSTRAINT PARTSUPP_FK2 FOREIGN KEY(PS_PARTKEY)
                          REFERENCES PART(P_PARTKEY));

CREATE TABLE ORDERS(O_ORDERKEY INT(11) NOT NULL, O_CUSTKEY INT(11) NOT NULL,
                    O_ORDERSTATUS CHAR(1) COLLATE ASCII_BIN NOT NULL,
                    O_TOTALPRICE DECIMAL(15, 2) NOT NULL,
                    O_ORDERDATE DATE NOT NULL,
                    O_ORDERPRIORITY CHAR(15) COLLATE ASCII_BIN NOT NULL,
                    O_CLERK CHAR(15) COLLATE ASCII_BIN NOT NULL,
                    O_SHIPPRIORITY INT(11) NOT NULL,
                    O_COMMENT VARCHAR(79) COLLATE ASCII_BIN NOT NULL,
                    PRIMARY KEY(O_ORDERKEY), KEY ORDERS_FK1(O_CUSTKEY),
                    CONSTRAINT ORDERS_FK1 FOREIGN KEY(O_CUSTKEY)
                        REFERENCES CUSTOMER(C_CUSTKEY));

CREATE TABLE LINEITEM(L_ORDERKEY INT(11) NOT NULL, L_PARTKEY INT(11) NOT NULL,
                      L_SUPPKEY INT(11) NOT NULL, L_LINENUMBER INT(11) NOT NULL,
                      L_QUANTITY DECIMAL(15, 2) NOT NULL,
                      L_EXTENDEDPRICE DECIMAL(15, 2) NOT NULL,
                      L_DISCOUNT DECIMAL(15, 2) NOT NULL,
                      L_TAX DECIMAL(15, 2) NOT NULL,
                      L_RETURNFLAG CHAR(1) COLLATE ASCII_BIN NOT NULL,
                      L_LINESTATUS CHAR(1) COLLATE ASCII_BIN NOT NULL,
                      L_SHIPDATE DATE NOT NULL, L_COMMITDATE DATE NOT NULL,
                      L_RECEIPTDATE DATE NOT NULL,
                      L_SHIPINSTRUCT CHAR(25) COLLATE ASCII_BIN NOT NULL,
                      L_SHIPMODE CHAR(10) COLLATE ASCII_BIN NOT NULL,
                      L_COMMENT VARCHAR(44) COLLATE ASCII_BIN NOT NULL,
                      PRIMARY KEY(L_ORDERKEY, L_LINENUMBER),
                      KEY LINEITEM_FK2(L_PARTKEY, L_SUPPKEY),
                      CONSTRAINT LINEITEM_FK1 FOREIGN KEY(L_ORDERKEY)
                          REFERENCES ORDERS(O_ORDERKEY),
                      CONSTRAINT LINEITEM_FK2 FOREIGN KEY(L_PARTKEY, L_SUPPKEY)
                          REFERENCES PARTSUPP(PS_PARTKEY, PS_SUPPKEY));

INSERT INTO REGION VALUES(
    0, 'AFRICA',
    'LAR DEPOSITS. BLITHELY FINAL PACKAGES CAJOLE. REGULAR WATERS ARE FINAL REQUESTS. REGULAR ACCOUNTS ARE ACCORDING TO '),
    (1, 'AMERICA', 'HS USE IRONIC, EVEN REQUESTS. S'),
    (2, 'ASIA', 'GES. THINLY EVEN PINTO BEANS CA'),
    (3, 'EUROPE', 'LY FINAL COURTS CAJOLE FURIOUSLY FINAL EXCUSE'),
    (4, 'MIDDLE EAST',
     'UICKLY SPECIAL ACCOUNTS CAJOLE CAREFULLY BLITHELY CLOSE REQUESTS. CAREFULLY FINAL ASYMPTOTES HAGGLE FURIOUSL');

INSERT INTO NATION
    VALUES(8, 'INDIA', 2,
           'SS EXCUSES CAJOLE SLYLY ACROSS THE PACKAGES. DEPOSITS PRINT AROUN'),
    (9, 'INDONESIA', 2,
     ' SLYLY EXPRESS ASYMPTOTES. REGULAR DEPOSITS HAGGLE SLYLY. CAREFULLY IRONIC HOCKEY PLAYERS SLEEP BLITHELY. CAREFULL'),
    (12, 'JAPAN', 2, 'OUSLY. FINAL, EXPRESS GIFTS CAJOLE A'),
    (18, 'CHINA', 2,
     'C DEPENDENCIES. FURIOUSLY EXPRESS NOTORNIS SLEEP SLYLY REGULAR ACCOUNTS. IDEAS SLEEP. DEPOS'),
    (21, 'VIETNAM', 2, 'HELY ENTICINGLY EXPRESS ACCOUNTS. EVEN, FINAL ');

INSERT INTO CUSTOMER VALUES(28, 'CUSTOMER#000000028',
                            'IVYG0DAQ,THA8X2WPWA9M2529M', 8, '18-774-241-1462',
                            1007.18, 'FURNITURE',
                            ' ALONG THE REGULAR DEPOSITS. FURIOUSLY FINAL PAC'),
    (96, 'CUSTOMER#000000096', 'VWLORMXHRR', 8, '18-422-845-1202', 6323.92,
     'AUTOMOBILE',
     'PRESS REQUESTS BELIEVE FURIOUSLY. CAREFULLY FINAL INSTRUCTIONS SNOOZE CAREFULLY. '),
    (152, 'CUSTOMER#000000152', 'PDRLLSKSCKLH4LR19GMUZNK', 8, '18-585-850-3926',
     1215.18, 'BUILDING',
     'OUSLY IRONIC ACCOUNTS. FURIOUSLY EVEN ACCOUNTS ACCORD'),
    (162, 'CUSTOMER#000000162', 'JE398SXZT2QUKXFJD7PONPYQFLFTTH', 8,
     '18-131-101-2267', 6268.99, 'BUILDING',
     'ACCOUNTS ALONG THE DOGGEDLY SPECIAL ASYMPTOTES BOOST BLITHELY DURING THE QUICKLY REGULAR THEODOLITES. SLYLY '),
    (214, 'CUSTOMER#000000214', 'MPCWHCLRBCIM7AEKS9TRM09BY', 8,
     '18-180-678-6165', 1526.59, 'BUILDING',
     'GROW. FLUFFILY REGULAR PINTO BEANS ACCORDING TO THE REGULAR ACCOUNTS AFFIX QUICKLY PE'),
    (316, 'CUSTOMER#000000316', 'ZE DN3AQJAG', 8, '18-171-394-5011', 4571.78,
     'BUILDING',
     'EGULAR IDEAS CAJOLE AROUND THE IRONIC, PENDING DEPOSITS. FURIOUSLY PENDING DOLPHINS SERVE BLITHELY REGULAR '),
    (382, 'CUSTOMER#000000382', 'UDGAMAMK5JNSYKA,ZPFR5W5ZRFATDUYE', 8,
     '18-942-650-6657', 6269.42, 'AUTOMOBILE',
     '. BLITHELY EXPRESS NOTORNIS ACCORDING TO THE BLITHELY EVEN REQUESTS ARE NEVER FINA'),
    (492, 'CUSTOMER#000000492', 'JEXAGMLUUHOELYFAKX,HJCAP1B1GKNYOYHQLYX', 8,
     '18-686-244-1077', 8635.18, 'AUTOMOBILE',
     'GLE FURIOUSLY FURIOUSLY FINAL PACKAGES. CAREFULLY BOLD PINTO BEANS PROMISE QUICKLY ALONGSIDE OF THE CLOSE'),
    (574, 'CUSTOMER#000000574', 'RATVLDMP070', 8, '18-676-218-1058', 9787.56,
     'FURNITURE',
     'AL PINTO BEANS. CAREFULLY IRONIC FOXES CAJOLE IDLY FINALLY EXPRESS THEODOLITES. FLUFF'),
    (590, 'CUSTOMER#000000590', '4SHHHAZWHYRXJVZ0KRGJW9ILKU,55IUT', 8,
     '18-734-215-6394', 3993.54, 'BUILDING',
     'ES. REGULAR DEPENDENCIES CAJOLE FURIOUSLY BLITHELY REGULAR IDEAS. REGULAR DEPENDENCIES CAJOLE CAREFULLY A'),
    (620, 'CUSTOMER#000000620', '3ZTW9KQQKGNSIMM,I1 6G2F,U2PM5LHLSEE8ZK1K', 8,
     '18-466-916-8135', 5795.15, 'AUTOMOBILE',
     'RUCTIONS BOOST FURIOUSLY AMONG THE SLYLY FINAL DOLPHINS. REGULAR, REGULAR IDEAS W'),
    (688, 'CUSTOMER#000000688', '2QBXK8WIRYWMZTSDM JS7GXWCB6Y71SWA,F1EUXK', 8,
     '18-210-546-2836', 3354.47, 'HOUSEHOLD',
     ' USE ALONGSIDE OF THE IRONIC, PENDING FOXES. FINAL PACKAGES USE. IRONIC, UNUSUAL DEPENDENCIES HAGGLE'),
    (750, 'CUSTOMER#000000750', '5OYNRAJJGJJBAXTI RKXVB2LX4C6U', 8,
     '18-235-587-1274', 269.90, 'BUILDING',
     'S. REGULAR, REGULAR DEPOSITS SLEEP CAREFULLY BLITHELY BOL'),
    (752, 'CUSTOMER#000000752', 'KTDEACPUECPDPLT99KWZRNH9OIXUXPW', 8,
     '18-924-993-6038', 8363.66, 'BUILDING',
     'MONG THE IRONIC, FINAL WATERS. REGULAR DEPOSITS ABOVE THE FLUFFILY IRONIC INSTRUCTIONS'),
    (770, 'CUSTOMER#000000770', 'IJWJR6TJBJZBKIEOUH2D', 8, '18-856-112-5677',
     2066.79, 'AUTOMOBILE', 'DOLITES HAGGLE EXPRESS, EXPRESS REQUESTS. FURIOU'),
    (780, 'CUSTOMER#000000780', 'CMXCDZGEUKCWP1', 8, '18-844-576-7345', 9874.12,
     'FURNITURE',
     ', FINAL PACKAGES USE SLYLY REGULAR DEPOSITS. SLYLY IRONIC INSTRUCTIONS NAG CAREFUL'),
    (858, 'CUSTOMER#000000858', '8QSQHQ,FC378KIPPBTNMAL 0BPAWO', 8,
     '18-509-453-8977', -829.37, 'BUILDING',
     ', SPECIAL ACCOUNTS. IRONIC, PENDING REQUESTS MIGHT CAJOLE FLU'),
    (880, 'CUSTOMER#000000880', 'OGWHMUUFA1QB69PAOYAAOB0RJBDSVPAQ552E5Q,', 8,
     '18-763-990-8618', -77.63, 'FURNITURE',
     'REGULAR REQUESTS. REGULAR DEPOSITS AR'),
    (966, 'CUSTOMER#000000966', 'V9C8SR8WK7WED', 8, '18-539-933-5176', 1283.26,
     'BUILDING',
     'TS. REGULAR ACCOUNTS CAJOLE ABOUT THE IDEAS. SLYLY UNUSUAL IDEA'),
    (1004, 'CUSTOMER#000001004', 'MBANGEJOY2TGXD60V2DEO AJJOM3ZD,JP', 8,
     '18-676-152-4849', 1512.46, 'BUILDING',
     'AINST THE IDEAS NAG FLUFFILY ACCORDING TO '),
    (1022, 'CUSTOMER#000001022', 'LP,9H6E6MQWLSWYYR2Y', 8, '18-733-553-2195',
     9605.83, 'AUTOMOBILE',
     'ENDING PACKAGES. DEPENDENCIES ALONG THE SLYLY PENDING DEPENDENCIES WAKE CAREFU'),
    (1030, 'CUSTOMER#000001030', 'XPT1BIB5H9O', 8, '18-759-877-1870', 6359.27,
     'HOUSEHOLD',
     'DING TO THE SLYLY UNUSUAL ACCOUNTS. EVEN REQUESTS AMONG THE EVENLY'),
    (1036, 'CUSTOMER#000001036', 'FXUJGJ8DOFO6OKRH', 8, '18-791-577-7691',
     1766.23, 'BUILDING', 'INS SLEEP. SLYLY EXPRESS PLATELETS CAJOL'),
    (1060, 'CUSTOMER#000001060', 'AWJKU6JJJOVGAKPOAJJC', 8, '18-290-794-6133',
     2840.59, 'HOUSEHOLD',
     'TER THE BOLD, REGULAR IDEAS! DEPOSITS EAT. DARINGLY UNUSUAL THEODOLITES SLEEP ALONGSIDE OF THE REGULAR, FINA'),
    (1086, 'CUSTOMER#000001086', 'ECMZRONTO2NI2TBV,K', 8, '18-399-482-6815',
     9726.83, 'FURNITURE',
     'YMPTOTES CAJOLE ENTICINGLY FURIOUSLY SILENT IDEAS. FURIOUSLY PENDING PACKAGES ARE AL'),
    (1104, 'CUSTOMER#000001104', ',T,D8FLNMIECPA', 8, '18-644-507-8095',
     1230.47, 'AUTOMOBILE',
     'AGES HAGGLE. SLYLY IRONIC FOXES ARE IDLY AMONG THE FURIOUSLY FINAL PEARLS. SLYLY UNUSUAL REQUES'),
    (1126, 'CUSTOMER#000001126', '8J BZLWBOPQYSAWPGHRL4IK4ROBVB', 8,
     '18-898-994-6389', 3905.97, 'AUTOMOBILE',
     'SE CAREFULLY ASYMPTOTES. UNUSUAL ACCOUNTS USE SLYLY DEPOSITS; SLYLY REGULAR PI'),
    (1170, 'CUSTOMER#000001170', 'BNHSSVCV36VSHEHUAC APFJ', 8,
     '18-670-628-8499', 2070.73, 'HOUSEHOLD',
     'RONIC INSTRUCTIONS. EXPRESS PINTO BEANS POACH BLITHELY. QUICKLY IRONIC ACCOUNTS N'),
    (1224, 'CUSTOMER#000001224', 'PWOWGZKSBOFJQ7PY4HJPDJOSO2,', 8,
     '18-794-312-9970', 8124.15, 'HOUSEHOLD',
     ' FURIOUSLY REGULAR ACCOUNTS. SLYLY REGULAR '),
    (1248, 'CUSTOMER#000001248', 'F0X68BITSL', 8, '18-692-669-1536', 6539.15,
     'AUTOMOBILE',
     'THEODOLITES FOR THE UNUSUAL DEPOSITS CAJOLE FLUFFILY FINAL PATTERNS. CAREF'),
    (1384, 'CUSTOMER#000001384', 'BQI5HATY6PHM8MYRTKSLVU4IXAUG', 8,
     '18-788-299-9227', 1534.38, 'HOUSEHOLD',
     'TES. REGULARLY PENDING THEODOLITES CAJOLE EVEN SHEAVES. STEALTHY, IRONIC IDEAS ARE FURIOUSLY ABOVE THE EVEN P'),
    (1398, 'CUSTOMER#000001398', 'K1RQQ6EXC3WCVCCGIJA4SAEQXTK2,HG1', 8,
     '18-377-181-4654', 7004.90, 'HOUSEHOLD',
     'THE BLITHELY SILENT DINOS. EVEN, SPECIAL HOCKEY PLA');

INSERT INTO ORDERS VALUES(
    24929, 316, 'O', 96283.19, '1996-10-01', '4-NOT SPECIFIED',
    'CLERK#000000121', 0,
    ' REQUESTS ALONGSIDE OF THE SLYLY SILENT PACKAGES AFFIX BLITHELY ABOU'),
    (26465, 382, 'O', 171749.91, '1997-02-13', '2-HIGH', 'CLERK#000000533', 0,
     'ESS REQUESTS BOOST IRONIC, EVEN ACC'),
    (26817, 770, 'O', 149767.42, '1998-04-15', '2-HIGH', 'CLERK#000000074', 0,
     'LAR IDEAS HAGGLE ABOUT THE BLITHELY REG'),
    (28261, 880, 'F', 102540.94, '1992-12-06', '3-MEDIUM', 'CLERK#000000046', 0,
     'LY REGULAR DOLPHINS. EXPRESS COURTS'),
    (28419, 1030, 'F', 44179.17, '1994-11-01', '5-LOW', 'CLERK#000000852', 0,
     ' DEPOSITS NAG AFTER THE CAREFUL'),
    (28545, 770, 'O', 129999.08, '1995-08-24', '2-HIGH', 'CLERK#000000044', 0,
     'S HANG AGAINST THE CAREFULLY EVEN REQUESTS'),
    (29031, 214, 'O', 50196.51, '1997-10-21', '3-MEDIUM', 'CLERK#000000846', 0,
     ' USE BLITHELY SLYLY REGULAR DEPENDENCIES'),
    (29505, 28, 'F', 236557.05, '1992-12-28', '3-MEDIUM', 'CLERK#000000939', 0,
     'DING TO THE FINAL PACKAGES INTEGRATE CAREFULL'),
    (29767, 214, 'F', 238383.62, '1995-02-06', '2-HIGH', 'CLERK#000000844', 0,
     'OLD EXCUSES. CAREFULLY EXPRESS DEPOSITS SLEE'),
    (30789, 316, 'F', 172863.89, '1994-06-27', '4-NOT SPECIFIED',
     'CLERK#000000678', 0, 'S POACH PERMANENTLY DOGGEDL'),
    (30791, 880, 'O', 119792.73, '1997-10-14', '2-HIGH', 'CLERK#000000367', 0,
     'ST ABOVE THE MULTIPLIERS. PACKAGES PLAY EXPRESS DEPOSITS. QUICKLY B'),
    (31303, 880, 'P', 178304.32, '1995-03-21', '5-LOW', 'CLERK#000000081', 0,
     'EXPRESS REQUESTS DOZE CAREFULLY AMONG THE RUTHLESS REQUESTS.'),
    (31845, 152, 'F', 55594.62, '1992-10-23', '5-LOW', 'CLERK#000000697', 0,
     'ACCOUNTS. COURTS PRINT BLITHELY IRONIC ACCOUNTS. SILENT DEPENDEN'),
    (32129, 214, 'O', 379837.62, '1995-07-03', '1-URGENT', 'CLERK#000000395', 0,
     'RING ACCOUNTS SERVE S'),
    (33863, 1036, 'F', 150295.00, '1993-03-08', '1-URGENT', 'CLERK#000000944',
     0, ' INTEGRATE. PACKAGES AFTER T'),
    (35457, 1126, 'F', 245338.12, '1994-12-08', '5-LOW', 'CLERK#000000648', 0,
     'URIOUSLY IRONIC PACKAGES ARE QUICKLY BLITHELY IRONIC PINTO BEAN'),
    (35459, 770, 'O', 111382.78, '1997-04-12', '5-LOW', 'CLERK#000000878', 0,
     'PACKAGES SLEEP SLYLY AMONG THE BLITHELY IRONIC SOMAS. FINAL THEO'),
    (37217, 1030, 'O', 45608.13, '1997-09-06', '1-URGENT', 'CLERK#000000784', 0,
     'AS. STEALTHILY PENDING FR'),
    (37569, 1126, 'F', 137428.62, '1994-06-10', '3-MEDIUM', 'CLERK#000000709',
     0, 'RE BLITHELY ACCORDING TO THE SILENT PACKAGES. IRONIC'),
    (38147, 1384, 'F', 161631.40, '1992-01-13', '2-HIGH', 'CLERK#000000835', 0,
     'FURIOUSLY UNUSUAL DEPENDE'),
    (38149, 1126, 'O', 21595.69, '1998-01-25', '4-NOT SPECIFIED',
     'CLERK#000000744', 0,
     'ROUND THE SPECIAL, SILENT DEPOSITS. CAREFULLY IRONIC INSTRUCT'),
    (38247, 382, 'O', 46010.30, '1997-09-05', '1-URGENT', 'CLERK#000000597', 0,
     'P FURIOUSLY ALONG THE SLYLY ENTICING THEODOLITE');

INSERT INTO PART VALUES(61, 'LIGHT TAN LINEN TOMATO PEACH', 'MANUFACTURER#5',
                        'BRAND#54', 'SMALL BURNISHED NICKEL', 18, 'WRAP DRUM',
                        961.06, 'ES. BLITHELY EN'),
    (89, 'GHOST LACE LEMON SIENNA SADDLE', 'MANUFACTURER#5', 'BRAND#53',
     'STANDARD BURNISHED STEEL', 7, 'MED JAR', 989.08, 'Y FINAL PINTO '),
    (211, 'TURQUOISE FOREST ORCHID CREAM BLUE', 'MANUFACTURER#3', 'BRAND#32',
     'MEDIUM ANODIZED NICKEL', 43, 'LG PKG', 1111.21, 'S CAJOLE '),
    (233, 'SEASHELL TOMATO RED LEMON SADDLE', 'MANUFACTURER#3', 'BRAND#34',
     'MEDIUM ANODIZED BRASS', 25, 'SM PACK', 1133.23, 'ULLY IRONIC'),
    (257, 'BLUE GAINSBORO MAROON GREEN BURNISHED', 'MANUFACTURER#4', 'BRAND#41',
     'ECONOMY POLISHED COPPER', 11, 'SM JAR', 1157.25, 'RIOUSLY FINAL FOXES'),
    (409, 'SMOKE FOREST METALLIC SADDLE HOT', 'MANUFACTURER#4', 'BRAND#44',
     'SMALL PLATED NICKEL', 40, 'MED CASE', 1309.40, 'USLY ABOVE'),
    (607, 'DARK SIENNA THISTLE SANDY MAROON', 'MANUFACTURER#5', 'BRAND#54',
     'MEDIUM POLISHED TIN', 13, 'MED JAR', 1507.60, 'CTIONS WAKE QU'),
    (839, 'CORNFLOWER WHITE PAPAYA VIOLET NAVAJO', 'MANUFACTURER#2', 'BRAND#25',
     'LARGE BRUSHED NICKEL', 19, 'JUMBO CAN', 1739.83, 'GGLE A'),
    (881, 'BISQUE FROSTED KHAKI LINEN ROYAL', 'MANUFACTURER#2', 'BRAND#21',
     'LARGE BRUSHED BRASS', 12, 'MED PACK', 1781.88, 'ULLY FOR '),
    (1009, 'SANDY GHOST STEEL CORNSILK PALE', 'MANUFACTURER#4', 'BRAND#42',
     'MEDIUM BURNISHED NICKEL', 47, 'SM JAR', 910.00, 'AGAINS'),
    (1033, 'DRAB CHIFFON LACE PLUM WHITE', 'MANUFACTURER#1', 'BRAND#12',
     'MEDIUM PLATED BRASS', 23, 'MED JAR', 934.03, 'CAJOLE BL'),
    (1103, 'MIDNIGHT CHOCOLATE SLATE ROSY LACE', 'MANUFACTURER#5', 'BRAND#53',
     'ECONOMY ANODIZED BRASS', 35, 'LG DRUM', 1004.10, 'LYLY. CAREFULLY '),
    (1201, 'INDIAN LAVENDER CORNFLOWER METALLIC LAWN', 'MANUFACTURER#5',
     'BRAND#54', 'LARGE POLISHED COPPER', 21, 'JUMBO DRUM', 1102.20, 'TO BEAN'),
    (1237, 'CORAL ROSE PUFF CHIFFON GREEN', 'MANUFACTURER#2', 'BRAND#25',
     'STANDARD ANODIZED BRASS', 10, 'MED DRUM', 1138.23, 'CCOUNT'),
    (1277, 'GREY FLORAL CREAM PURPLE GREEN', 'MANUFACTURER#3', 'BRAND#31',
     'PROMO BURNISHED STEEL', 48, 'JUMBO DRUM', 1178.27, 'PINTO BEANS CAJOL'),
    (1433, 'GHOST STEEL BEIGE PUFF CORAL', 'MANUFACTURER#1', 'BRAND#15',
     'ECONOMY ANODIZED BRASS', 26, 'JUMBO PKG', 1334.43, 'DOLPHINS ARE '),
    (1499, 'SMOKE GREY ROSY PAPAYA BLUSH', 'MANUFACTURER#3', 'BRAND#32',
     'LARGE ANODIZED STEEL', 14, 'LG PKG', 1400.49, 'EXCUSES. REGUL'),
    (1571, 'GREY SANDY CORNFLOWER DODGER SKY', 'MANUFACTURER#5', 'BRAND#52',
     'STANDARD ANODIZED BRASS', 22, 'MED BOX', 1472.57,
     'UCTIONS. FINALLY REGUL'),
    (1579, 'SLATE MINT WHITE PINK BURNISHED', 'MANUFACTURER#2', 'BRAND#24',
     'LARGE PLATED STEEL', 25, 'JUMBO BAG', 1480.57, ' EXPRESS ACCOU'),
    (1697, 'MIDNIGHT MOCCASIN BLUSH ROYAL BLACK', 'MANUFACTURER#3', 'BRAND#35',
     'LARGE BURNISHED STEEL', 44, 'WRAP BOX', 1598.69, 'FURIOUSLY BOLD DEPOSI'),
    (1871, 'MEDIUM GAINSBORO LACE SLATE FROSTED', 'MANUFACTURER#1', 'BRAND#14',
     'SMALL ANODIZED BRASS', 21, 'JUMBO JAR', 1772.87, 'ROSS THE REGUL'),
    (1979, 'TOMATO FOREST PALE MOCCASIN MAGENTA', 'MANUFACTURER#5', 'BRAND#52',
     'SMALL POLISHED COPPER', 50, 'SM PKG', 1880.97, 'ES. BLITHEL');

INSERT INTO SUPPLIER VALUES(
    11, 'SUPPLIER#000000011', 'JFWTS,LZRV, M,9C', 18, '28-613-996-1505',
    3393.08,
    'Y IRONIC PACKAGES. SLYLY IRONIC ACCOUNTS AFFIX FURIOUSLY; IRONICALLY UNUSUAL EXCUSES ACROSS THE FLU'),
    (12, 'SUPPLIER#000000012', 'ALIW  Q0HYD', 8, '18-179-925-7181', 1432.69,
     'AL PACKAGES NAG ALONGSIDE OF THE BOLD INSTRUCTIONS. EXPRESS, DARING ACCOUNTS'),
    (15, 'SUPPLIER#000000015', 'OLXVBNBFVZRQGOKR1T,IE', 8, '18-453-357-6394',
     308.56,
     ' ACROSS THE FURIOUSLY REGULAR PLATELETS WAKE EVEN DEPOSITS. QUICKLY EXPRESS SHE'),
    (23, 'SUPPLIER#000000023', 'SSETUGTCXC096QLD7 2TL5CREEES3ZK', 9,
     '19-559-422-5776', 5926.41,
     'GES COULD HAVE TO ARE IRONIC DEPOSITS. REGULAR, EVEN REQUEST'),
    (26, 'SUPPLIER#000000026', 'IV,MHZAX6Z939UZFNKQ09M0A1 MBFH7', 21,
     '31-758-894-4436', 21.18,
     ' IDEAS POACH CAREFULLY AFTER THE BLITHELY BOLD ASYMPTOTES. FURIOUSLY PENDING THEODOLI'),
    (27, 'SUPPLIER#000000027', 'LC4CJKWNHUR6L4XIPZOBK4NLHKFTG', 18,
     '28-708-999-2028', 1887.62,
     'S ACCORDING TO THE QUICKLY REGULAR HOCKEY PLAYE'),
    (35, 'SUPPLIER#000000035', 'QYMMGXXJVVQ5OUABCXVVSU,4EF GU0QC6', 21,
     '31-720-790-5245', 4381.41,
     ' IRONIC DEPOSITS! FINAL, BOLD PLATELETS HAGGLE QUICKLY QUICKLY PENDIN'),
    (39, 'SUPPLIER#000000039', 'ZM, NSYPEPWR1YAFHAC91QJFCIJJEU5EH', 8,
     '18-851-856-5633', 6115.65,
     'LE SLYLY REQUESTS. SPECIAL PACKAGES SHALL ARE BLITHELY. SLYLY UNUSUAL PACKAGES SLEEP '),
    (41, 'SUPPLIER#000000041', 'G 1FKHR435 WMKFMYT', 18, '28-739-447-2525',
     6942.67, 'ODOLITES BOOST ACROSS THE FURIOUSLY REGULAR FO'),
    (43, 'SUPPLIER#000000043', 'Z5MLUAOTUEEKY5V22VNNA4D87AO6JF2LVMYNLX8H', 12,
     '22-421-568-4862', 7773.41, 'UNTS. UNUSUAL, FINAL ASYMPTOTES '),
    (45, 'SUPPLIER#000000045', 'LCKNSA8XGTIO0WYSB7HKORH RNZRG1', 9,
     '19-189-635-8862', 2944.23,
     'IOUSLY ACCORDING TO THE IRONIC, SILENT ACCOUNTS.'),
    (50, 'SUPPLIER#000000050', 'RGOBQSMMYZ0ERRPHCGS', 9, '19-561-560-7437',
     4515.87,
     'WARHORSES. IRONIC, REGULAR ACCOUNTS DETECT SLYLY AFTER THE QUICKLY F'),
    (51, 'SUPPLIER#000000051', 'RDKBXB01POIKJOWRIJ62UM8O4', 9,
     '19-475-537-1368', 7241.40,
     'GES NAG AT THE BLITHELY BUSY INSTRUCTIONS. FLUFFY PACKAGES WAKE QUICKLY. EVEN, IRONIC IDEAS BOOST B'),
    (54, 'SUPPLIER#000000054', 'J1S,WXB5PG', 12, '22-966-435-7200', 2733.69,
     'BLITHELY PENDING DOLPHINS. QUICKLY REGULAR THEODOLITES HAGGLE SLYLY'),
    (60, 'SUPPLIER#000000060', 'CB08NTDTARO47WMNBCYXU', 8, '18-550-360-2464',
     4515.80, 'THELY EXPRESS IDEAS USE BLITHELY '),
    (61, 'SUPPLIER#000000061', 'OZ0M1QBR9I', 8, '18-396-489-9719', 6096.58,
     'S THE SLYLY REGULAR IDEAS SHALL '),
    (68, 'SUPPLIER#000000068', 'UE6N50WH2CWE4PPGTGLMAT,IBGYYLDOOB3XQWTGB', 21,
     '31-267-327-4328', 5119.38,
     'INAL REQUESTS. RUTHLESSLY IRONIC PACKAGES CAJOLE'),
    (72, 'SUPPLIER#000000072', 'MKPAJOJTAWK2ALQV4 ZEBJ3PH3WFYQY AM8RGQ1', 18,
     '28-113-898-6643', 7014.50,
     ' THEODOLITES SUBLATE FURIOUSLY ABOUT THE REGULARLY E'),
    (75, 'SUPPLIER#000000075', '7F3GN4RP1LIVII', 18, '28-716-704-8686', -224.84,
     'EANS. EVEN, SILENT PACKAGES C'),
    (80, 'SUPPLIER#000000080', 'CJ2MHSEJ13RIL2WJ3D5I6HRO30,ZINUXHQN', 21,
     '31-646-289-1906', -40.45,
     'ACKAGES. BLITHELY BOLD REQUESTS WAKE QUICKLY. CAREFULLY REGULAR FOXES ARE SLYLY INSTRUCTIONS. CAREF'),
    (81, 'SUPPLIER#000000081', 'SLLACBHGPKMVA,GF3SAYV12E0', 12,
     '22-535-310-6971', 166.32,
     'OOST CAREFULLY QUICKLY REGULAR PACKAGES. CAREFULLY FINAL EXCUSES SLEEP BLITHELY SLYLY PENDI'),
    (82, 'SUPPLIER#000000082', 'WYTKA7ZPF15T1ACNLT3', 18, '28-177-572-9691',
     -724.31, 'XPRESS MULTIPLIERS WAKE FURIOUSLY EVEN FOXES. FURIOUSLY IRO'),
    (89, 'SUPPLIER#000000089', 'FHTZZCSORHUD1', 9, '19-259-876-1014', 1638.02,
     'EN INSTRUCTIONS ACROSS THE SLYLY IRONIC REQUESTS ENGAGE'),
    (96, 'SUPPLIER#000000096', 'LBXP3WIIPYE O2WZME1I9IJX,XTT1MP', 12,
     '22-888-654-7193', 3437.24,
     'EFULLY UNUSUAL EXCUSES WAKE FLUFFILY REGULAR THEODO'),
    (98, 'SUPPLIER#000000098', 'OGHN8DPXB5Q', 21, '31-914-775-1978', 5873.07,
     'ESIAS USE SLYLY UNDER THE IRONIC FOXES. RE'),
    (99, 'SUPPLIER#000000099', '4SXKTHG28NZRTT0,MNVF9H', 18, '28-272-909-1617',
     3671.34, 'NIC DEPENDENCIES DAZZLE FLU'),
    (100, 'SUPPLIER#000000100', 'RILN LI8ZVW22L2SLBCX ECP4FL', 21,
     '31-351-324-5062', 3191.70,
     'ES. REGULAR INSTRUCTIONS SLEEP CAREFULLY. SLYLY IRONIC PACKAGES ACROSS THE FOXES BOOST ');

INSERT INTO PARTSUPP VALUES(
    61, 12, 4762, 633.74,
    'FINAL THEODOLITES HAGGLE. FLUFFILY EXPRESS IDEAS ABOUT THE SILENT THEODOLITES CAJOLE IDEAS; FLUFFILY SPECIAL INSTRUCTIONS ARE ACCORDIN'),
    (89, 15, 8599, 776.53,
     'RESS PACKAGES USE FURIOUSLY. FURIOUSLY REGULAR PACKAGES THRASH BLITHELY ABOUT THE SLYLY PE'),
    (211, 12, 4572, 475.68,
     'OLITES HAGGLE SLYLY ACCORDING TO THE REGULAR, EVEN'),
    (211, 39, 6045, 856.97,
     ' IRONIC MULTIPLIERS SLEEP. FURIOUSLY EXPRESS REQUESTS WAKE QUICKLY. REGULAR DEPENDENCIES ALONG THE DINOS SLEEP AFTER THE EPITAPHS. QUIETLY UNUSUAL DEPOSITS HAGGLE BLITH'),
    (233, 15, 3009, 767.62,
     'SES. IRONIC IDEAS USE FLUFFILY. FLUFFILY FLUFFY ACCOUNTS BOOST FURIOUSLY. IRONIC PACKAGES CAJOLE CAREFULLY BLI'),
    (257, 39, 6401, 510.53,
     'AL INSTRUCTIONS DETECT CAREFULLY FINAL REQUESTS. ACCOUNTS KINDLE SLYLY QUICKLY UNUSUAL THEODOLITES. FURIOUSLY BOLD DEPOSITS ABOUT THE CAREFULLY UNUSU'),
    (409, 39, 8770, 539.70,
     'LLY CAREFULLY PENDING PACKAGES. BOLD, REGULAR DINOS LOSE FLUFFIL'),
    (607, 39, 672, 141.55,
     'AL ACCOUNTS SLEEP ABOVE THE FURIOUSLY UNUSUAL DEPOSITS. SPECIAL DEPOSITS DOUBT BLITHELY. PACKAGES ACCORDING TO THE ASYMPTOTES SLEEP QUICKLY ABOVE THE SLYLY FINAL ACCOUNTS. BLITHELY UNUSU'),
    (839, 39, 8733, 836.50,
     'ECIAL DEPOSITS. QUICKLY EVEN DEPOSITS HAGGLE UNUSUAL ACCOUNTS; CAREFULLY BOLD ACCOUNTS ACCORDING TO THE BOLD REQUESTS HAGGLE RUTHLESSLY ABOVE THE BLITHELY BOLD ACCOUNTS. FURIOUSLY EVEN AC'),
    (881, 15, 9524, 636.63,
     'EFULLY ABOUT THE SPECIAL, SPECIAL IDEAS. CAREFULLY IRONIC REQUESTS DOUBT SLYLY'),
    (1009, 15, 7031, 707.71,
     'REQUESTS USE SLOWLY! SLYLY FINAL ASYMPTOTES SLEEP CAREFULLY CAREFULLY FINAL PACKAGES. SLYLY FINA'),
    (1033, 39, 9315, 386.36,
     'YLY UNUSUAL ACCOUNTS. REGULAR, EVEN GROUCHES SLEEP CAREFULLY QUICK'),
    (1103, 12, 6587, 661.49,
     'FINAL INSTRUCTIONS. RUTHLESSLY IRONIC IDEAS ARE SLYLY BLITHELY PENDING FOXES. CAREFULLY IRONIC DEPOSITS HAGGLE BLITHELY. EVEN, SPECIAL'),
    (1201, 39, 4340, 59.91,
     'L WARTHOGS. REGULAR INSTRUCTIONS SHOULD HAVE TO WAKE QUICKLY QUICKLY BOLD THEODOLITES? IRO'),
    (1237, 12, 7650, 352.30,
     'PINTO BEANS. CAREFULLY EVEN COURTS ARE SLYLY REGULAR ACCOUNTS. CAREFULLY BLITHE DEPOSITS BOOS'),
    (1277, 15, 6316, 102.08,
     ' FINAL THEODOLITES. IRONIC ACCOUNTS DO CAJOLE AFTER T'),
    (1433, 12, 7924, 361.96,
     'EXCUSES SHALL WAKE ACROSS THE PERMANENTLY SPECIAL DEPENDENCIES. FURIOUSLY PENDING ACCOUNTS SNOOZE SLYLY ACROSS '),
    (1499, 39, 2565, 144.32,
     'NAL DEPENDENCIES DETECT QUICKLY ABOUT THE FLUFFILY IDLE INSTRUCTIONS. EXPRESS, SPECIAL REQUESTS AGAINST'),
    (1571, 12, 7273, 718.56,
     'N INSTRUCTIONS SLEEP FLUFFILY AFTER THE PACKAGES. CAREFULLY FINAL IDEAS WAKE SLYLY. ASYMPTOT'),
    (1579, 60, 6175, 299.08,
     'S. FURIOUSLY FINAL DEPOSITS AT THE BOLD REQUESTS AFFIX FLUFFILY AT THE BLITHELY IRONIC IDEAS. FURIOUSLY EVEN DEPOSITS WAKE CAREFULLY; REQUESTS CAJOLE STEALTHILY. EVEN, EXPRESS'),
    (1697, 39, 4240, 120.72,
     'E FURIOUSLY HOCKEY PLAYERS: SLYLY REGULAR EPITAPHS USE ACROSS THE CAREFULLY EVEN ACCOUNTS. FINAL TIRESIAS SLEEP BLITHELY BLITHELY FINAL IDEAS. REGULAR ACCOUNTS ARE CAREFULLY. STEALTH'),
    (1871, 15, 9101, 357.87,
     'ST FURIOUSLY ABOUT THE CAREFULLY IRONIC REQUESTS. FINAL, IRONI'),
    (1979, 12, 7458, 712.56,
     'RLY SPECIAL REQUESTS USE ABOUT THE PENDING DEPOSITS. DOLPHINS AFFIX BLITHELY EVEN THEODOLITES. CAR');

INSERT INTO LINEITEM VALUES(24929, 211, 12, 9, 59.00, 45235.50, 0.04, 0.03, 'R',
                            '0', '1999-06-18', '1999-05-29', '2000-06-24',
                            'DELIVER IN COURIER', 'SHIP', 'SUPPLIED FURIOUSLY'),
    (26465, 1103, 12, 9, 89.00, 4500.50, 0.02, 0.05, 'R', '0', '2000-06-18',
     '2000-05-29', '2001-06-24', 'DELIVER IN PERSON', 'MINI SHIP', 'FURIOUSLY'),
    (26817, 1579, 60, 4, 42.00, 62183.94, 0.00, 0.08, 'R', 'O', '1998-06-17',
     '1998-05-30', '1998-06-19', 'DELIVER IN PERSON', 'SHIP',
     'TES. FURIOUSLY IRONIC ACCO'),
    (28261, 1237, 12, 4, 47.00, 3000.00, 0.01, 0.06, 'R', '0', '1999-05-18',
     '1999-04-29', '2000-06-24', 'DELIVER IN PERSON', 'MINI SHIP', 'FURIOUSLY'),
    (28261, 1433, 12, 5, 51.00, 3900.00, 0.00, 0.07, 'R', '0', '1999-03-18',
     '1999-03-29', '2000-05-24', 'DELIVER IN PERSON', 'MINI SHIP', 'FURIOUSLY'),
    (28419, 1571, 12, 1, 31.00, 2000.00, 0.00, 0.08, 'N', '0', '1999-02-18',
     '1999-02-28', '2000-03-24', 'DELIVER IN PERSON', 'MINI SHIP', 'FURIOUSLY'),
    (28545, 61, 12, 5, 50.00, 5235.50, 0.00, 0.08, 'R', '0', '1998-06-18',
     '1998-05-29', '1999-06-24', 'DELIVER IN PERSON', 'MINI SHIP',
     'SUPPLIED HAPPILY'),
    (29031, 1979, 12, 3, 41.00, 2700.00, 0.00, 0.05, 'R', '0', '1999-01-18',
     '1999-01-28', '2000-02-24', 'DELIVER IN SHIP', 'MINI SHIP', 'FURIOUSLY'),
    (29505, 89, 15, 4, 46.00, 3000.00, 0.00, 0.06, 'R', '0', '1998-01-18',
     '1998-01-28', '1999-02-24', 'DELIVER IN MINI SHIP', 'MINI SHIP',
     'FURIOUSLY'),
    (29767, 233, 15, 3, 41.00, 2900.00, 0.00, 0.05, 'N', '0', '1998-02-18',
     '1998-02-28', '1999-03-24', 'DELIVER IN PERSON', 'SHIP', 'HAPPILY'),
    (30789, 881, 15, 4, 46.00, 3100.00, 0.10, 0.04, 'R', '0', '1998-03-18',
     '1998-03-28', '1999-04-24', 'DELIVER IN SHIP', 'SHIP', 'HAPPILY'),
    (30791, 1009, 15, 5, 47.00, 3500.00, 0.10, 0.05, 'N', '0', '1998-04-18',
     '1998-04-28', '1999-05-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (31303, 1277, 15, 6, 49.00, 3900.00, 0.00, 0.06, 'R', '0', '1998-05-18',
     '1998-05-28', '1999-06-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (31845, 1871, 15, 3, 39.00, 2900.00, 0.00, 0.07, 'R', '0', '1998-06-18',
     '1998-06-28', '1999-07-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (32129, 211, 39, 2, 49.00, 3900.00, 0.00, 0.08, 'R', '0', '1998-07-18',
     '1998-07-28', '1999-08-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (33863, 257, 39, 3, 50.00, 4000.00, 0.00, 0.06, 'N', '0', '1998-08-18',
     '1998-08-28', '1999-09-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (35457, 409, 39, 4, 51.00, 4100.00, 0.00, 0.06, 'N', '0', '1998-09-18',
     '1998-09-28', '1999-10-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (35459, 607, 39, 4, 52.00, 4400.00, 0.00, 0.07, 'R', '0', '1998-10-18',
     '1998-10-28', '1999-11-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (37217, 839, 39, 4, 55.00, 4670.00, 0.00, 0.08, 'N', '0', '1998-11-18',
     '1998-11-28', '1999-12-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (37569, 1033, 39, 5, 57.00, 4870.00, 0.00, 0.07, 'R', '0', '1998-12-18',
     '1998-12-28', '1999-12-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (38147, 1201, 39, 6, 59.00, 4970.00, 0.00, 0.06, 'N', '0', '1997-12-18',
     '1997-12-28', '1998-12-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (38149, 1499, 39, 2, 34.00, 4980.00, 0.00, 0.05, 'R', '0', '1997-11-18',
     '1997-11-28', '1998-11-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY'),
    (38247, 1697, 39, 1, 24.00, 3980.00, 0.00, 0.02, 'N', '0', '1997-10-18',
     '1997-10-28', '1998-10-24', 'DELIVER IN PERSON', 'PERSON', 'HAPPILY');

ALTER TABLE REGION SECONDARY_ENGINE RAPID;
ALTER TABLE REGION SECONDARY_LOAD;
ALTER TABLE NATION SECONDARY_ENGINE RAPID;
ALTER TABLE NATION SECONDARY_LOAD;
ALTER TABLE CUSTOMER SECONDARY_ENGINE RAPID;
ALTER TABLE CUSTOMER SECONDARY_LOAD;
ALTER TABLE ORDERS SECONDARY_ENGINE RAPID;
ALTER TABLE ORDERS SECONDARY_LOAD;
ALTER TABLE PART SECONDARY_ENGINE RAPID;
ALTER TABLE PART SECONDARY_LOAD;
ALTER TABLE SUPPLIER SECONDARY_ENGINE RAPID;
ALTER TABLE SUPPLIER SECONDARY_LOAD;
ALTER TABLE PARTSUPP SECONDARY_ENGINE RAPID;
ALTER TABLE PARTSUPP SECONDARY_LOAD;
ALTER TABLE LINEITEM SECONDARY_ENGINE RAPID;
ALTER TABLE LINEITEM SECONDARY_LOAD;

ANALYZE TABLE REGION UPDATE HISTOGRAM ON R_REGIONKEY
    WITH 1024 BUCKETS;
ANALYZE TABLE NATION UPDATE HISTOGRAM ON N_NATIONKEY, N_REGIONKEY
    WITH 1024 BUCKETS;    
ANALYZE TABLE LINEITEM UPDATE HISTOGRAM ON L_SUPPKEY, L_ORDERKEY, L_SHIPDATE,
    L_PARTKEY, L_LINENUMBER, L_RECEIPTDATE, L_QUANTITY, L_COMMITDATE,
    L_RETURNFLAG WITH 1024 BUCKETS;
ANALYZE TABLE CUSTOMER UPDATE HISTOGRAM ON C_CUSTKEY,
    C_NATIONKEY WITH 1024 BUCKETS;
ANALYZE TABLE ORDERS UPDATE HISTOGRAM ON O_ORDERKEY, O_ORDERDATE, O_CUSTKEY,
    O_ORDERPRIORITY WITH 1024 BUCKETS;
ANALYZE TABLE PARTSUPP UPDATE HISTOGRAM ON PS_SUPPKEY,
    PS_PARTKEY WITH 1024 BUCKETS;
ANALYZE TABLE SUPPLIER UPDATE HISTOGRAM ON S_NATIONKEY,
    S_SUPPKEY WITH 1024 BUCKETS;
ANALYZE TABLE PART UPDATE HISTOGRAM ON P_PARTKEY, P_BRAND, P_CONTAINER, P_SIZE,
    P_TYPE WITH 1024 BUCKETS;
