/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/dtl/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojox/string/tokenize","dojo/_base/json","dojo/dom","dojo/_base/xhr","dojox/string/Builder","dojo/_base/Deferred"],function(_1,_2,_3,_4,_5,_6,_7,_8){_1.experimental("dojox.dtl");var dd=_2.getObject("dojox.dtl",true);dd._base={};dd.TOKEN_BLOCK=-1;dd.TOKEN_VAR=-2;dd.TOKEN_COMMENT=-3;dd.TOKEN_TEXT=3;dd._Context=_2.extend(function(_9){if(_9){_2._mixin(this,_9);if(_9.get){this._getter=_9.get;delete this.get;}}},{push:function(){var _a=this;var _b=_2.delegate(this);_b.pop=function(){return _a;};return _b;},pop:function(){throw new Error("pop() called on empty Context");},get:function(_c,_d){var n=this._normalize;if(this._getter){var _e=this._getter(_c);if(_e!==undefined){return n(_e);}}if(this[_c]!==undefined){return n(this[_c]);}return _d;},_normalize:function(_f){if(_f instanceof Date){_f.year=_f.getFullYear();_f.month=_f.getMonth()+1;_f.day=_f.getDate();_f.date=_f.year+"-"+("0"+_f.month).slice(-2)+"-"+("0"+_f.day).slice(-2);_f.hour=_f.getHours();_f.minute=_f.getMinutes();_f.second=_f.getSeconds();_f.microsecond=_f.getMilliseconds();}return _f;},update:function(_10){var _11=this.push();if(_10){_2._mixin(this,_10);}return _11;}});var _12=/("(?:[^"\\]*(?:\\.[^"\\]*)*)"|'(?:[^'\\]*(?:\\.[^'\\]*)*)'|[^\s]+)/g;var _13=/\s+/g;var _14=function(_15,_16){_15=_15||_13;if(!(_15 instanceof RegExp)){_15=new RegExp(_15,"g");}if(!_15.global){throw new Error("You must use a globally flagged RegExp with split "+_15);}_15.exec("");var _17,_18=[],_19=0,i=0;while((_17=_15.exec(this))){_18.push(this.slice(_19,_15.lastIndex-_17[0].length));_19=_15.lastIndex;if(_16&&(++i>_16-1)){break;}}_18.push(this.slice(_19));return _18;};dd.Token=function(_1a,_1b){this.token_type=_1a;this.contents=new String(_2.trim(_1b));this.contents.split=_14;this.split=function(){return String.prototype.split.apply(this.contents,arguments);};};dd.Token.prototype.split_contents=function(_1c){var bit,_1d=[],i=0;_1c=_1c||999;while(i++<_1c&&(bit=_12.exec(this.contents))){bit=bit[0];if(bit.charAt(0)=="\""&&bit.slice(-1)=="\""){_1d.push("\""+bit.slice(1,-1).replace("\\\"","\"").replace("\\\\","\\")+"\"");}else{if(bit.charAt(0)=="'"&&bit.slice(-1)=="'"){_1d.push("'"+bit.slice(1,-1).replace("\\'","'").replace("\\\\","\\")+"'");}else{_1d.push(bit);}}}return _1d;};var ddt=dd.text={_get:function(_1e,_1f,_20){var _21=dd.register.get(_1e,_1f.toLowerCase(),_20);if(!_21){if(!_20){throw new Error("No tag found for "+_1f);}return null;}var fn=_21[1];var _22=_21[2];var _23;if(fn.indexOf(":")!=-1){_23=fn.split(":");fn=_23.pop();}var mod=_22;if(/\./.test(_22)){_22=_22.replace(/\./g,"/");}require([_22],function(){});var _24=_2.getObject(mod);return _24[fn||_1f]||_24[_1f+"_"]||_24[fn+"_"];},getTag:function(_25,_26){return ddt._get("tag",_25,_26);},getFilter:function(_27,_28){return ddt._get("filter",_27,_28);},getTemplate:function(_29){return new dd.Template(ddt.getTemplateString(_29));},getTemplateString:function(_2a){return _6._getText(_2a.toString())||"";},_resolveLazy:function(_2b,_2c,_2d){if(_2c){if(_2d){return _2d.fromJson(_6._getText(_2b))||{};}else{return dd.text.getTemplateString(_2b);}}else{return _6.get({handleAs:_2d?"json":"text",url:_2b});}},_resolveTemplateArg:function(arg,_2e){if(ddt._isTemplate(arg)){if(!_2e){var d=new _8();d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2e);},_isTemplate:function(arg){return (arg===undefined)||(typeof arg=="string"&&(arg.match(/^\s*[<{]/)||arg.indexOf(" ")!=-1));},_resolveContextArg:function(arg,_2f){if(arg.constructor==Object){if(!_2f){var d=new _8;d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2f,true);},_re:/(?:\{\{\s*(.+?)\s*\}\}|\{%\s*(load\s*)?(.+?)\s*%\})/g,tokenize:function(str){return _3(str,ddt._re,ddt._parseDelims);},_parseDelims:function(_30,_31,tag){if(_30){return [dd.TOKEN_VAR,_30];}else{if(_31){var _32=_2.trim(tag).split(/\s+/g);for(var i=0,_33;_33=_32[i];i++){if(/\./.test(_33)){_33=_33.replace(/\./g,"/");}require([_33]);}}else{return [dd.TOKEN_BLOCK,tag];}}}};dd.Template=_2.extend(function(_34,_35){var str=_35?_34:ddt._resolveTemplateArg(_34,true)||"";var _36=ddt.tokenize(str);var _37=new dd._Parser(_36);this.nodelist=_37.parse();},{update:function(_38,_39){return ddt._resolveContextArg(_39).addCallback(this,function(_3a){var _3b=this.render(new dd._Context(_3a));if(_38.forEach){_38.forEach(function(_3c){_3c.innerHTML=_3b;});}else{_5.byId(_38).innerHTML=_3b;}return this;});},render:function(_3d,_3e){_3e=_3e||this.getBuffer();_3d=_3d||new dd._Context({});return this.nodelist.render(_3d,_3e)+"";},getBuffer:function(){return new _7();}});var _3f=/\{\{\s*(.+?)\s*\}\}/g;dd.quickFilter=function(str){if(!str){return new dd._NodeList();}if(str.indexOf("{%")==-1){return new dd._QuickNodeList(_3(str,_3f,function(_40){return new dd._Filter(_40);}));}};dd._QuickNodeList=_2.extend(function(_41){this.contents=_41;},{render:function(_42,_43){for(var i=0,l=this.contents.length;i<l;i++){if(this.contents[i].resolve){_43=_43.concat(this.contents[i].resolve(_42));}else{_43=_43.concat(this.contents[i]);}}return _43;},dummyRender:function(_44){return this.render(_44,dd.Template.prototype.getBuffer()).toString();},clone:function(_45){return this;}});dd._Filter=_2.extend(function(_46){if(!_46){throw new Error("Filter must be called with variable name");}this.contents=_46;var _47=this._cache[_46];if(_47){this.key=_47[0];this.filters=_47[1];}else{this.filters=[];_3(_46,this._re,this._tokenize,this);this._cache[_46]=[this.key,this.filters];}},{_cache:{},_re:/(?:^_\("([^\\"]*(?:\\.[^\\"])*)"\)|^"([^\\"]*(?:\\.[^\\"]*)*)"|^([a-zA-Z0-9_.]+)|\|(\w+)(?::(?:_\("([^\\"]*(?:\\.[^\\"])*)"\)|"([^\\"]*(?:\\.[^\\"]*)*)"|([a-zA-Z0-9_.]+)|'([^\\']*(?:\\.[^\\']*)*)'))?|^'([^\\']*(?:\\.[^\\']*)*)')/g,_values:{0:"\"",1:"\"",2:"",8:"\""},_args:{4:"\"",5:"\"",6:"",7:"'"},_tokenize:function(){var pos,arg;for(var i=0,has=[];i<arguments.length;i++){has[i]=(arguments[i]!==undefined&&typeof arguments[i]=="string"&&arguments[i]);}if(!this.key){for(pos in this._values){if(has[pos]){this.key=this._values[pos]+arguments[pos]+this._values[pos];break;}}}else{for(pos in this._args){if(has[pos]){var _48=arguments[pos];if(this._args[pos]=="'"){_48=_48.replace(/\\'/g,"'");}else{if(this._args[pos]=="\""){_48=_48.replace(/\\"/g,"\"");}}arg=[!this._args[pos],_48];break;}}var fn=ddt.getFilter(arguments[3]);if(!_2.isFunction(fn)){throw new Error(arguments[3]+" is not registered as a filter");}this.filters.push([fn,arg]);}},getExpression:function(){return this.contents;},resolve:function(_49){if(this.key===undefined){return "";}var str=this.resolvePath(this.key,_49);for(var i=0,_4a;_4a=this.filters[i];i++){if(_4a[1]){if(_4a[1][0]){str=_4a[0](str,this.resolvePath(_4a[1][1],_49));}else{str=_4a[0](str,_4a[1][1]);}}else{str=_4a[0](str);}}return str;},resolvePath:function(_4b,_4c){var _4d,_4e;var _4f=_4b.charAt(0);var _50=_4b.slice(-1);if(!isNaN(parseInt(_4f))){_4d=(_4b.indexOf(".")==-1)?parseInt(_4b):parseFloat(_4b);}else{if(_4f=="\""&&_4f==_50){_4d=_4b.slice(1,-1);}else{if(_4b=="true"){return true;}if(_4b=="false"){return false;}if(_4b=="null"||_4b=="None"){return null;}_4e=_4b.split(".");_4d=_4c.get(_4e[0]);if(_2.isFunction(_4d)){var _51=_4c.getThis&&_4c.getThis();if(_4d.alters_data){_4d="";}else{if(_51){_4d=_4d.call(_51);}else{_4d="";}}}for(var i=1;i<_4e.length;i++){var _52=_4e[i];if(_4d){var _53=_4d;if(_2.isObject(_4d)&&_52=="items"&&_4d[_52]===undefined){var _54=[];for(var key in _4d){_54.push([key,_4d[key]]);}_4d=_54;continue;}if(_4d.get&&_2.isFunction(_4d.get)&&_4d.get.safe){_4d=_4d.get(_52);}else{if(_4d[_52]===undefined){_4d=_4d[_52];break;}else{_4d=_4d[_52];}}if(_2.isFunction(_4d)){if(_4d.alters_data){_4d="";}else{_4d=_4d.call(_53);}}else{if(_4d instanceof Date){_4d=dd._Context.prototype._normalize(_4d);}}}else{return "";}}}}return _4d;}});dd._TextNode=dd._Node=_2.extend(function(obj){this.contents=obj;},{set:function(_55){this.contents=_55;return this;},render:function(_56,_57){return _57.concat(this.contents);},isEmpty:function(){return !_2.trim(this.contents);},clone:function(){return this;}});dd._NodeList=_2.extend(function(_58){this.contents=_58||[];this.last="";},{push:function(_59){this.contents.push(_59);return this;},concat:function(_5a){this.contents=this.contents.concat(_5a);return this;},render:function(_5b,_5c){for(var i=0;i<this.contents.length;i++){_5c=this.contents[i].render(_5b,_5c);if(!_5c){throw new Error("Template must return buffer");}}return _5c;},dummyRender:function(_5d){return this.render(_5d,dd.Template.prototype.getBuffer()).toString();},unrender:function(){return arguments[1];},clone:function(){return this;},rtrim:function(){while(1){i=this.contents.length-1;if(this.contents[i] instanceof dd._TextNode&&this.contents[i].isEmpty()){this.contents.pop();}else{break;}}return this;}});dd._VarNode=_2.extend(function(str){this.contents=new dd._Filter(str);},{render:function(_5e,_5f){var str=this.contents.resolve(_5e)||"";if(!str.safe){str=dd._base.escape(""+str);}return _5f.concat(str);}});dd._noOpNode=new function(){this.render=this.unrender=function(){return arguments[1];};this.clone=function(){return this;};};dd._Parser=_2.extend(function(_60){this.contents=_60;},{i:0,parse:function(_61){var _62={},_63;_61=_61||[];for(var i=0;i<_61.length;i++){_62[_61[i]]=true;}var _64=new dd._NodeList();while(this.i<this.contents.length){_63=this.contents[this.i++];if(typeof _63=="string"){_64.push(new dd._TextNode(_63));}else{var _65=_63[0];var _66=_63[1];if(_65==dd.TOKEN_VAR){_64.push(new dd._VarNode(_66));}else{if(_65==dd.TOKEN_BLOCK){if(_62[_66]){--this.i;return _64;}var cmd=_66.split(/\s+/g);if(cmd.length){cmd=cmd[0];var fn=ddt.getTag(cmd);if(fn){_64.push(fn(this,new dd.Token(_65,_66)));}}}}}}if(_61.length){throw new Error("Could not find closing tag(s): "+_61.toString());}this.contents.length=0;return _64;},next_token:function(){var _67=this.contents[this.i++];return new dd.Token(_67[0],_67[1]);},delete_first_token:function(){this.i++;},skip_past:function(_68){while(this.i<this.contents.length){var _69=this.contents[this.i++];if(_69[0]==dd.TOKEN_BLOCK&&_69[1]==_68){return;}}throw new Error("Unclosed tag found when looking for "+_68);},create_variable_node:function(_6a){return new dd._VarNode(_6a);},create_text_node:function(_6b){return new dd._TextNode(_6b||"");},getTemplate:function(_6c){return new dd.Template(_6c);}});dd.register={_registry:{attributes:[],tags:[],filters:[]},get:function(_6d,_6e){var _6f=dd.register._registry[_6d+"s"];for(var i=0,_70;_70=_6f[i];i++){if(typeof _70[0]=="string"){if(_70[0]==_6e){return _70;}}else{if(_6e.match(_70[0])){return _70;}}}},getAttributeTags:function(){var _71=[];var _72=dd.register._registry.attributes;for(var i=0,_73;_73=_72[i];i++){if(_73.length==3){_71.push(_73);}else{var fn=_2.getObject(_73[1]);if(fn&&_2.isFunction(fn)){_73.push(fn);_71.push(_73);}}}return _71;},_any:function(_74,_75,_76){for(var _77 in _76){for(var i=0,fn;fn=_76[_77][i];i++){var key=fn;if(_2.isArray(fn)){key=fn[0];fn=fn[1];}if(typeof key=="string"){if(key.substr(0,5)=="attr:"){var _78=fn;if(_78.substr(0,5)=="attr:"){_78=_78.slice(5);}dd.register._registry.attributes.push([_78.toLowerCase(),_75+"."+_77+"."+_78]);}key=key.toLowerCase();}dd.register._registry[_74].push([key,fn,_75+"."+_77]);}}},tags:function(_79,_7a){dd.register._any("tags",_79,_7a);},filters:function(_7b,_7c){dd.register._any("filters",_7b,_7c);}};var _7d=/&/g;var _7e=/</g;var _7f=/>/g;var _80=/'/g;var _81=/"/g;dd._base.escape=function(_82){return dd.mark_safe(_82.replace(_7d,"&amp;").replace(_7e,"&lt;").replace(_7f,"&gt;").replace(_81,"&quot;").replace(_80,"&#39;"));};dd._base.safe=function(_83){if(typeof _83=="string"){_83=new String(_83);}if(typeof _83=="object"){_83.safe=true;}return _83;};dd.mark_safe=dd._base.safe;dd.register.tags("dojox.dtl.tag",{"date":["now"],"logic":["if","for","ifequal","ifnotequal"],"loader":["extends","block","include","load","ssi"],"misc":["comment","debug","filter","firstof","spaceless","templatetag","widthratio","with"],"loop":["cycle","ifchanged","regroup"]});dd.register.filters("dojox.dtl.filter",{"dates":["date","time","timesince","timeuntil"],"htmlstrings":["linebreaks","linebreaksbr","removetags","striptags"],"integers":["add","get_digit"],"lists":["dictsort","dictsortreversed","first","join","length","length_is","random","slice","unordered_list"],"logic":["default","default_if_none","divisibleby","yesno"],"misc":["filesizeformat","pluralize","phone2numeric","pprint"],"strings":["addslashes","capfirst","center","cut","fix_ampersands","floatformat","iriencode","linenumbers","ljust","lower","make_list","rjust","slugify","stringformat","title","truncatewords","truncatewords_html","upper","urlencode","urlize","urlizetrunc","wordcount","wordwrap"]});dd.register.filters("dojox.dtl",{"_base":["escape","safe"]});return dd;});},"dojox/string/tokenize":function(){define(["dojo/_base/lang","dojo/_base/sniff"],function(_84,has){var _85=_84.getObject("dojox.string",true).tokenize;_85=function(str,re,_86,_87){var _88=[];var _89,_8a,_8b=0;while(_89=re.exec(str)){_8a=str.slice(_8b,re.lastIndex-_89[0].length);if(_8a.length){_88.push(_8a);}if(_86){if(has("opera")){var _8c=_89.slice(0);while(_8c.length<_89.length){_8c.push(null);}_89=_8c;}var _8d=_86.apply(_87,_89.slice(1).concat(_88.length));if(typeof _8d!="undefined"){_88.push(_8d);}}_8b=re.lastIndex;}_8a=str.slice(_8b);if(_8a.length){_88.push(_8a);}return _88;};return _85;});},"dojox/string/Builder":function(){define(["dojo/_base/lang"],function(_8e){_8e.getObject("string",true,dojox).Builder=function(str){var b="";this.length=0;this.append=function(s){if(arguments.length>1){var tmp="",l=arguments.length;switch(l){case 9:tmp=""+arguments[8]+tmp;case 8:tmp=""+arguments[7]+tmp;case 7:tmp=""+arguments[6]+tmp;case 6:tmp=""+arguments[5]+tmp;case 5:tmp=""+arguments[4]+tmp;case 4:tmp=""+arguments[3]+tmp;case 3:tmp=""+arguments[2]+tmp;case 2:b+=""+arguments[0]+arguments[1]+tmp;break;default:var i=0;while(i<arguments.length){tmp+=arguments[i++];}b+=tmp;}}else{b+=s;}this.length=b.length;return this;};this.concat=function(s){return this.append.apply(this,arguments);};this.appendArray=function(_8f){return this.append.apply(this,_8f);};this.clear=function(){b="";this.length=0;return this;};this.replace=function(_90,_91){b=b.replace(_90,_91);this.length=b.length;return this;};this.remove=function(_92,len){if(len===undefined){len=b.length;}if(len==0){return this;}b=b.substr(0,_92)+b.substr(_92+len);this.length=b.length;return this;};this.insert=function(_93,str){if(_93==0){b=str+b;}else{b=b.slice(0,_93)+str+b.slice(_93);}this.length=b.length;return this;};this.toString=function(){return b;};if(str){this.append(str);}};return dojox.string.Builder;});},"dojox/dtl/Context":function(){define(["dojo/_base/lang","./_base"],function(_94,dd){dd.Context=_94.extend(function(_95){this._this={};dd._Context.call(this,_95);},dd._Context.prototype,{getKeys:function(){var _96=[];for(var key in this){if(this.hasOwnProperty(key)&&key!="_this"){_96.push(key);}}return _96;},extend:function(obj){return _94.delegate(this,obj);},filter:function(_97){var _98=new dd.Context();var _99=[];var i,arg;if(_97 instanceof dd.Context){_99=_97.getKeys();}else{if(typeof _97=="object"){for(var key in _97){_99.push(key);}}else{for(i=0;arg=arguments[i];i++){if(typeof arg=="string"){_99.push(arg);}}}}for(i=0,key;key=_99[i];i++){_98[key]=this[key];}return _98;},setThis:function(_9a){this._this=_9a;},getThis:function(){return this._this;},hasKey:function(key){if(this._getter){var got=this._getter(key);if(typeof got!="undefined"){return true;}}if(typeof this[key]!="undefined"){return true;}return false;}});return dd.Context;});},"dojox/dtl/tag/logic":function(){define(["dojo/_base/lang","../_base"],function(_9b,dd){_9b.getObject("dojox.dtl.tag.logic",true);var ddt=dd.text;var _9c=dd.tag.logic;_9c.IfNode=_9b.extend(function(_9d,_9e,_9f,_a0){this.bools=_9d;this.trues=_9e;this.falses=_9f;this.type=_a0;},{render:function(_a1,_a2){var i,_a3,_a4,_a5,_a6;if(this.type=="or"){for(i=0;_a3=this.bools[i];i++){_a4=_a3[0];_a5=_a3[1];_a6=_a5.resolve(_a1);if((_a6&&!_a4)||(_a4&&!_a6)){if(this.falses){_a2=this.falses.unrender(_a1,_a2);}return (this.trues)?this.trues.render(_a1,_a2,this):_a2;}}if(this.trues){_a2=this.trues.unrender(_a1,_a2);}return (this.falses)?this.falses.render(_a1,_a2,this):_a2;}else{for(i=0;_a3=this.bools[i];i++){_a4=_a3[0];_a5=_a3[1];_a6=_a5.resolve(_a1);if(_a6==_a4){if(this.trues){_a2=this.trues.unrender(_a1,_a2);}return (this.falses)?this.falses.render(_a1,_a2,this):_a2;}}if(this.falses){_a2=this.falses.unrender(_a1,_a2);}return (this.trues)?this.trues.render(_a1,_a2,this):_a2;}return _a2;},unrender:function(_a7,_a8){_a8=(this.trues)?this.trues.unrender(_a7,_a8):_a8;_a8=(this.falses)?this.falses.unrender(_a7,_a8):_a8;return _a8;},clone:function(_a9){var _aa=(this.trues)?this.trues.clone(_a9):null;var _ab=(this.falses)?this.falses.clone(_a9):null;return new this.constructor(this.bools,_aa,_ab,this.type);}});_9c.IfEqualNode=_9b.extend(function(_ac,_ad,_ae,_af,_b0){this.var1=new dd._Filter(_ac);this.var2=new dd._Filter(_ad);this.trues=_ae;this.falses=_af;this.negate=_b0;},{render:function(_b1,_b2){var _b3=this.var1.resolve(_b1);var _b4=this.var2.resolve(_b1);_b3=(typeof _b3!="undefined")?_b3:"";_b4=(typeof _b3!="undefined")?_b4:"";if((this.negate&&_b3!=_b4)||(!this.negate&&_b3==_b4)){if(this.falses){_b2=this.falses.unrender(_b1,_b2,this);}return (this.trues)?this.trues.render(_b1,_b2,this):_b2;}if(this.trues){_b2=this.trues.unrender(_b1,_b2,this);}return (this.falses)?this.falses.render(_b1,_b2,this):_b2;},unrender:function(_b5,_b6){return _9c.IfNode.prototype.unrender.call(this,_b5,_b6);},clone:function(_b7){var _b8=this.trues?this.trues.clone(_b7):null;var _b9=this.falses?this.falses.clone(_b7):null;return new this.constructor(this.var1.getExpression(),this.var2.getExpression(),_b8,_b9,this.negate);}});_9c.ForNode=_9b.extend(function(_ba,_bb,_bc,_bd){this.assign=_ba;this.loop=new dd._Filter(_bb);this.reversed=_bc;this.nodelist=_bd;this.pool=[];},{render:function(_be,_bf){var i,j,k;var _c0=false;var _c1=this.assign;for(k=0;k<_c1.length;k++){if(typeof _be[_c1[k]]!="undefined"){_c0=true;_be=_be.push();break;}}if(!_c0&&_be.forloop){_c0=true;_be=_be.push();}var _c2=this.loop.resolve(_be)||[];for(i=_c2.length;i<this.pool.length;i++){this.pool[i].unrender(_be,_bf,this);}if(this.reversed){_c2=_c2.slice(0).reverse();}var _c3=_9b.isObject(_c2)&&!_9b.isArrayLike(_c2);var _c4=[];if(_c3){for(var key in _c2){_c4.push(_c2[key]);}}else{_c4=_c2;}var _c5=_be.forloop={parentloop:_be.get("forloop",{})};var j=0;for(i=0;i<_c4.length;i++){var _c6=_c4[i];_c5.counter0=j;_c5.counter=j+1;_c5.revcounter0=_c4.length-j-1;_c5.revcounter=_c4.length-j;_c5.first=!j;_c5.last=(j==_c4.length-1);if(_c1.length>1&&_9b.isArrayLike(_c6)){if(!_c0){_c0=true;_be=_be.push();}var _c7={};for(k=0;k<_c6.length&&k<_c1.length;k++){_c7[_c1[k]]=_c6[k];}_9b.mixin(_be,_c7);}else{_be[_c1[0]]=_c6;}if(j+1>this.pool.length){this.pool.push(this.nodelist.clone(_bf));}_bf=this.pool[j++].render(_be,_bf,this);}delete _be.forloop;if(_c0){_be=_be.pop();}else{for(k=0;k<_c1.length;k++){delete _be[_c1[k]];}}return _bf;},unrender:function(_c8,_c9){for(var i=0,_ca;_ca=this.pool[i];i++){_c9=_ca.unrender(_c8,_c9);}return _c9;},clone:function(_cb){return new this.constructor(this.assign,this.loop.getExpression(),this.reversed,this.nodelist.clone(_cb));}});_9b.mixin(_9c,{if_:function(_cc,_cd){var i,_ce,_cf,_d0=[],_d1=_cd.contents.split();_d1.shift();_cd=_d1.join(" ");_d1=_cd.split(" and ");if(_d1.length==1){_cf="or";_d1=_cd.split(" or ");}else{_cf="and";for(i=0;i<_d1.length;i++){if(_d1[i].indexOf(" or ")!=-1){throw new Error("'if' tags can't mix 'and' and 'or'");}}}for(i=0;_ce=_d1[i];i++){var not=false;if(_ce.indexOf("not ")==0){_ce=_ce.slice(4);not=true;}_d0.push([not,new dd._Filter(_ce)]);}var _d2=_cc.parse(["else","endif"]);var _d3=false;var _cd=_cc.next_token();if(_cd.contents=="else"){_d3=_cc.parse(["endif"]);_cc.next_token();}return new _9c.IfNode(_d0,_d2,_d3,_cf);},_ifequal:function(_d4,_d5,_d6){var _d7=_d5.split_contents();if(_d7.length!=3){throw new Error(_d7[0]+" takes two arguments");}var end="end"+_d7[0];var _d8=_d4.parse(["else",end]);var _d9=false;var _d5=_d4.next_token();if(_d5.contents=="else"){_d9=_d4.parse([end]);_d4.next_token();}return new _9c.IfEqualNode(_d7[1],_d7[2],_d8,_d9,_d6);},ifequal:function(_da,_db){return _9c._ifequal(_da,_db);},ifnotequal:function(_dc,_dd){return _9c._ifequal(_dc,_dd,true);},for_:function(_de,_df){var _e0=_df.contents.split();if(_e0.length<4){throw new Error("'for' statements should have at least four words: "+_df.contents);}var _e1=_e0[_e0.length-1]=="reversed";var _e2=(_e1)?-3:-2;if(_e0[_e0.length+_e2]!="in"){throw new Error("'for' tag received an invalid argument: "+_df.contents);}var _e3=_e0.slice(1,_e2).join(" ").split(/ *, */);for(var i=0;i<_e3.length;i++){if(!_e3[i]||_e3[i].indexOf(" ")!=-1){throw new Error("'for' tag received an invalid argument: "+_df.contents);}}var _e4=_de.parse(["endfor"]);_de.next_token();return new _9c.ForNode(_e3,_e0[_e0.length+_e2+1],_e1,_e4);}});return dojox.dtl.tag.logic;});},"dojox/dtl/tag/loop":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/json","../_base","dojox/string/tokenize"],function(_e5,_e6,_e7,dd,_e8){_e5.getObject("dojox.dtl.tag.loop",true);var _e9=dd.tag.loop;_e9.CycleNode=_e5.extend(function(_ea,_eb,_ec,_ed){this.cyclevars=_ea;this.name=_eb;this.contents=_ec;this.shared=_ed||{counter:-1,map:{}};},{render:function(_ee,_ef){if(_ee.forloop&&!_ee.forloop.counter0){this.shared.counter=-1;}++this.shared.counter;var _f0=this.cyclevars[this.shared.counter%this.cyclevars.length];var map=this.shared.map;if(!map[_f0]){map[_f0]=new dd._Filter(_f0);}_f0=map[_f0].resolve(_ee,_ef);if(this.name){_ee[this.name]=_f0;}this.contents.set(_f0);return this.contents.render(_ee,_ef);},unrender:function(_f1,_f2){return this.contents.unrender(_f1,_f2);},clone:function(_f3){return new this.constructor(this.cyclevars,this.name,this.contents.clone(_f3),this.shared);}});_e9.IfChangedNode=_e5.extend(function(_f4,_f5,_f6){this.nodes=_f4;this._vars=_f5;this.shared=_f6||{last:null,counter:0};this.vars=_e6.map(_f5,function(_f7){return new dojox.dtl._Filter(_f7);});},{render:function(_f8,_f9){if(_f8.forloop){if(_f8.forloop.counter<=this.shared.counter){this.shared.last=null;}this.shared.counter=_f8.forloop.counter;}var _fa;if(this.vars.length){_fa=_e7.toJson(_e6.map(this.vars,function(_fb){return _fb.resolve(_f8);}));}else{_fa=this.nodes.dummyRender(_f8,_f9);}if(_fa!=this.shared.last){var _fc=(this.shared.last===null);this.shared.last=_fa;_f8=_f8.push();_f8.ifchanged={firstloop:_fc};_f9=this.nodes.render(_f8,_f9);_f8=_f8.pop();}else{_f9=this.nodes.unrender(_f8,_f9);}return _f9;},unrender:function(_fd,_fe){return this.nodes.unrender(_fd,_fe);},clone:function(_ff){return new this.constructor(this.nodes.clone(_ff),this._vars,this.shared);}});_e9.RegroupNode=_e5.extend(function(_100,key,_101){this._expression=_100;this.expression=new dd._Filter(_100);this.key=key;this.alias=_101;},{_push:function(_102,_103,_104){if(_104.length){_102.push({grouper:_103,list:_104});}},render:function(_105,_106){_105[this.alias]=[];var list=this.expression.resolve(_105);if(list){var last=null;var _107=[];for(var i=0;i<list.length;i++){var id=list[i][this.key];if(last!==id){this._push(_105[this.alias],last,_107);last=id;_107=[list[i]];}else{_107.push(list[i]);}}this._push(_105[this.alias],last,_107);}return _106;},unrender:function(_108,_109){return _109;},clone:function(_10a,_10b){return this;}});_e5.mixin(_e9,{cycle:function(_10c,_10d){var args=_10d.split_contents();if(args.length<2){throw new Error("'cycle' tag requires at least two arguments");}if(args[1].indexOf(",")!=-1){var vars=args[1].split(",");args=[args[0]];for(var i=0;i<vars.length;i++){args.push("\""+vars[i]+"\"");}}if(args.length==2){var name=args[args.length-1];if(!_10c._namedCycleNodes){throw new Error("No named cycles in template: '"+name+"' is not defined");}if(!_10c._namedCycleNodes[name]){throw new Error("Named cycle '"+name+"' does not exist");}return _10c._namedCycleNodes[name];}if(args.length>4&&args[args.length-2]=="as"){var name=args[args.length-1];var node=new _e9.CycleNode(args.slice(1,args.length-2),name,_10c.create_text_node());if(!_10c._namedCycleNodes){_10c._namedCycleNodes={};}_10c._namedCycleNodes[name]=node;}else{node=new _e9.CycleNode(args.slice(1),null,_10c.create_text_node());}return node;},ifchanged:function(_10e,_10f){var _110=_10f.contents.split();var _111=_10e.parse(["endifchanged"]);_10e.delete_first_token();return new _e9.IfChangedNode(_111,_110.slice(1));},regroup:function(_112,_113){var _114=_e8(_113.contents,/(\s+)/g,function(_115){return _115;});if(_114.length<11||_114[_114.length-3]!="as"||_114[_114.length-7]!="by"){throw new Error("Expected the format: regroup list by key as newList");}var _116=_114.slice(2,-8).join("");var key=_114[_114.length-5];var _117=_114[_114.length-1];return new _e9.RegroupNode(_116,key,_117);}});return dojox.dtl.tag.loop;});},"dojox/dtl/tag/date":function(){define(["dojo/_base/lang","../_base","../utils/date"],function(lang,dd,ddud){lang.getObject("dojox.dtl.tag.date",true);dojox.dtl.tag.date.NowNode=function(_118,node){this._format=_118;this.format=new ddud.DateFormat(_118);this.contents=node;};lang.extend(dd.tag.date.NowNode,{render:function(_119,_11a){this.contents.set(this.format.format(new Date()));return this.contents.render(_119,_11a);},unrender:function(_11b,_11c){return this.contents.unrender(_11b,_11c);},clone:function(_11d){return new this.constructor(this._format,this.contents.clone(_11d));}});dojox.dtl.tag.date.now=function(_11e,_11f){var _120=_11f.split_contents();if(_120.length!=2){throw new Error("'now' statement takes one argument");}return new dojox.dtl.tag.date.NowNode(_120[1].slice(1,-1),_11e.create_text_node());};return dojox.dtl.tag.date;});},"dojox/dtl/utils/date":function(){define(["dojo/_base/lang","dojox/date/php","../_base"],function(lang,ddp,dd){lang.getObject("dojox.dtl.utils.date",true);dd.utils.date.DateFormat=ddp.DateFormat;lang.extend(dd.utils.date.DateFormat,ddp.DateFormat.prototype,{f:function(){return (!this.date.getMinutes())?this.g():this.g()+":"+this.i();},N:function(){return dojox.dtl.utils.date._months_ap[this.date.getMonth()];},P:function(){if(!this.date.getMinutes()&&!this.date.getHours()){return "midnight";}if(!this.date.getMinutes()&&this.date.getHours()==12){return "noon";}return this.f()+" "+this.a();}});lang.mixin(dojox.dtl.utils.date,{format:function(date,_121){var df=new dojox.dtl.utils.date.DateFormat(_121);return df.format(date);},timesince:function(d,now){if(!(d instanceof Date)){d=new Date(d.year,d.month,d.day);}if(!now){now=new Date();}var _122=Math.abs(now.getTime()-d.getTime());for(var i=0,_123;_123=dojox.dtl.utils.date._chunks[i];i++){var _124=Math.floor(_122/_123[0]);if(_124){break;}}return _124+" "+_123[1](_124);},_chunks:[[60*60*24*365*1000,function(n){return (n==1)?"year":"years";}],[60*60*24*30*1000,function(n){return (n==1)?"month":"months";}],[60*60*24*7*1000,function(n){return (n==1)?"week":"weeks";}],[60*60*24*1000,function(n){return (n==1)?"day":"days";}],[60*60*1000,function(n){return (n==1)?"hour":"hours";}],[60*1000,function(n){return (n==1)?"minute":"minutes";}]],_months_ap:["Jan.","Feb.","March","April","May","June","July","Aug.","Sept.","Oct.","Nov.","Dec."]});return dojox.dtl.utils.date;});},"dojox/date/php":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/date","dojox/string/tokenize"],function(dojo,_125,_126,dxst){dojo.getObject("date.php",true,dojox);dojox.date.php.format=function(date,_127){var df=new dojox.date.php.DateFormat(_127);return df.format(date);};dojox.date.php.DateFormat=function(_128){if(!this.regex){var keys=[];for(var key in this.constructor.prototype){if(dojo.isString(key)&&key.length==1&&dojo.isFunction(this[key])){keys.push(key);}}this.constructor.prototype.regex=new RegExp("(?:(\\\\.)|(["+keys.join("")+"]))","g");}var _129=[];this.tokens=dxst(_128,this.regex,function(_12a,_12b,i){if(_12b){_129.push([i,_12b]);return _12b;}if(_12a){return _12a.charAt(1);}});this.replacements=_129;};dojo.extend(dojox.date.php.DateFormat,{weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdays_3:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],months_3:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],monthdays:[31,28,31,30,31,30,31,31,30,31,30,31],format:function(date){this.date=date;for(var i=0,_12c;_12c=this.replacements[i];i++){this.tokens[_12c[0]]=this[_12c[1]]();}return this.tokens.join("");},d:function(){var j=this.j();return (j.length==1)?"0"+j:j;},D:function(){return this.weekdays_3[this.date.getDay()];},j:function(){return this.date.getDate()+"";},l:function(){return this.weekdays[this.date.getDay()];},N:function(){var w=this.w();return (!w)?7:w;},S:function(){switch(this.date.getDate()){case 11:case 12:case 13:return "th";case 1:case 21:case 31:return "st";case 2:case 22:return "nd";case 3:case 23:return "rd";default:return "th";}},w:function(){return this.date.getDay()+"";},z:function(){var _12d=this.date.getTime()-new Date(this.date.getFullYear(),0,1).getTime();return Math.floor(_12d/86400000)+"";},W:function(){var week;var _12e=new Date(this.date.getFullYear(),0,1).getDay()+1;var w=this.date.getDay()+1;var z=parseInt(this.z());if(z<=(8-_12e)&&_12e>4){var _12f=new Date(this.date.getFullYear()-1,this.date.getMonth(),this.date.getDate());if(_12e==5||(_12e==6&&_126.isLeapYear(_12f))){week=53;}else{week=52;}}else{var i;if(Boolean(this.L())){i=366;}else{i=365;}if((i-z)<(4-w)){week=1;}else{var j=z+(7-w)+(_12e-1);week=Math.ceil(j/7);if(_12e>4){--week;}}}return week;},F:function(){return this.months[this.date.getMonth()];},m:function(){var n=this.n();return (n.length==1)?"0"+n:n;},M:function(){return this.months_3[this.date.getMonth()];},n:function(){return this.date.getMonth()+1+"";},t:function(){return (Boolean(this.L())&&this.date.getMonth()==1)?29:this.monthdays[this.getMonth()];},L:function(){return (_126.isLeapYear(this.date))?"1":"0";},o:function(){},Y:function(){return this.date.getFullYear()+"";},y:function(){return this.Y().slice(-2);},a:function(){return this.date.getHours()>=12?"pm":"am";},b:function(){return this.a().toUpperCase();},B:function(){var off=this.date.getTimezoneOffset()+60;var secs=(this.date.getHours()*3600)+(this.date.getMinutes()*60)+this.getSeconds()+(off*60);var beat=Math.abs(Math.floor(secs/86.4)%1000)+"";while(beat.length<2){beat="0"+beat;}return beat;},g:function(){return (this.date.getHours()%12||12)+"";},G:function(){return this.date.getHours()+"";},h:function(){var g=this.g();return (g.length==1)?"0"+g:g;},H:function(){var G=this.G();return (G.length==1)?"0"+G:G;},i:function(){var mins=this.date.getMinutes()+"";return (mins.length==1)?"0"+mins:mins;},s:function(){var secs=this.date.getSeconds()+"";return (secs.length==1)?"0"+secs:secs;},e:function(){return _126.getTimezoneName(this.date);},I:function(){},O:function(){var off=Math.abs(this.date.getTimezoneOffset());var _130=Math.floor(off/60)+"";var mins=(off%60)+"";if(_130.length==1){_130="0"+_130;}if(mins.length==1){_130="0"+mins;}return ((this.date.getTimezoneOffset()<0)?"+":"-")+_130+mins;},P:function(){var O=this.O();return O.substring(0,2)+":"+O.substring(2,4);},T:function(){return this.e().substring(0,3);},Z:function(){return this.date.getTimezoneOffset()*-60;},c:function(){return this.Y()+"-"+this.m()+"-"+this.d()+"T"+this.h()+":"+this.i()+":"+this.s()+this.P();},r:function(){return this.D()+", "+this.d()+" "+this.M()+" "+this.Y()+" "+this.H()+":"+this.i()+":"+this.s()+" "+this.O();},U:function(){return Math.floor(this.date.getTime()/1000);}});return dojox.date.php;});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_131){var _132=_131.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_132==1&&date.isLeapYear(_131)){return 29;}return days[_132];};date.isLeapYear=function(_133){var year=_133.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_134){var str=_134.toString();var tz="";var _135;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_135=str.match(pat))){tz=_135[1];}else{str=_134.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_135=str.match(pat))){tz=_135[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_136,_137,_138){_136=new Date(+_136);_137=new Date(+(_137||new Date()));if(_138=="date"){_136.setHours(0,0,0,0);_137.setHours(0,0,0,0);}else{if(_138=="time"){_136.setFullYear(0,0,0);_137.setFullYear(0,0,0);}}if(_136>_137){return 1;}if(_136<_137){return -1;}return 0;};date.add=function(date,_139,_13a){var sum=new Date(+date);var _13b=false;var _13c="Date";switch(_139){case "day":break;case "weekday":var days,_13d;var mod=_13a%5;if(!mod){days=(_13a>0)?5:-5;_13d=(_13a>0)?((_13a-5)/5):((_13a+5)/5);}else{days=mod;_13d=parseInt(_13a/5);}var strt=date.getDay();var adj=0;if(strt==6&&_13a>0){adj=1;}else{if(strt==0&&_13a<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_13a>0)?2:-2;}_13a=(7*_13d)+days+adj;break;case "year":_13c="FullYear";_13b=true;break;case "week":_13a*=7;break;case "quarter":_13a*=3;case "month":_13b=true;_13c="Month";break;default:_13c="UTC"+_139.charAt(0).toUpperCase()+_139.substring(1)+"s";}if(_13c){sum["set"+_13c](sum["get"+_13c]()+_13a);}if(_13b&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_13e,_13f,_140){_13f=_13f||new Date();_140=_140||"day";var _141=_13f.getFullYear()-_13e.getFullYear();var _142=1;switch(_140){case "quarter":var m1=_13e.getMonth();var m2=_13f.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_141*4);_142=q2-q1;break;case "weekday":var days=Math.round(date.difference(_13e,_13f,"day"));var _143=parseInt(date.difference(_13e,_13f,"week"));var mod=days%7;if(mod==0){days=_143*5;}else{var adj=0;var aDay=_13e.getDay();var bDay=_13f.getDay();_143=parseInt(days/7);mod=days%7;var _144=new Date(_13e);_144.setDate(_144.getDate()+(_143*7));var _145=_144.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_145+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_145+mod)<0:adj=2;}}}days+=adj;days-=(_143*2);}_142=days;break;case "year":_142=_141;break;case "month":_142=(_13f.getMonth()-_13e.getMonth())+(_141*12);break;case "week":_142=parseInt(date.difference(_13e,_13f,"day")/7);break;case "day":_142/=24;case "hour":_142/=60;case "minute":_142/=60;case "second":_142/=1000;case "millisecond":_142*=_13f.getTime()-_13e.getTime();}return Math.round(_142);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dojox/dtl/tag/loader":function(){define(["dojo/_base/lang","../_base","dojo/_base/array","dojo/_base/connect"],function(lang,dd,_146,_147){lang.getObject("dojox.dtl.tag.loader",true);var ddtl=dd.tag.loader;ddtl.BlockNode=lang.extend(function(name,_148){this.name=name;this.nodelist=_148;},{"super":function(){if(this.parent){var html=this.parent.nodelist.dummyRender(this.context,null,true);if(typeof html=="string"){html=new String(html);}html.safe=true;return html;}return "";},render:function(_149,_14a){var name=this.name;var _14b=this.nodelist;var _14c;if(_14a.blocks){var _14d=_14a.blocks[name];if(_14d){_14c=_14d.parent;_14b=_14d.nodelist;_14d.used=true;}}this.rendered=_14b;_149=_149.push();this.context=_149;this.parent=null;if(_14b!=this.nodelist){this.parent=this;}_149.block=this;if(_14a.getParent){var _14e=_14a.getParent();var _14f=_147.connect(_14a,"onSetParent",function(node,up,root){if(up&&root){_14a.setParent(_14e);}});}_14a=_14b.render(_149,_14a,this);_14f&&_147.disconnect(_14f);_149=_149.pop();return _14a;},unrender:function(_150,_151){return this.rendered.unrender(_150,_151);},clone:function(_152){return new this.constructor(this.name,this.nodelist.clone(_152));},toString:function(){return "dojox.dtl.tag.loader.BlockNode";}});ddtl.ExtendsNode=lang.extend(function(_153,_154,_155,_156,key){this.getTemplate=_153;this.nodelist=_154;this.shared=_155;this.parent=_156;this.key=key;},{parents:{},getParent:function(_157){var _158=this.parent;if(!_158){var _159;_158=this.parent=_157.get(this.key,false);if(!_158){throw new Error("extends tag used a variable that did not resolve");}if(typeof _158=="object"){var url=_158.url||_158.templatePath;if(_158.shared){this.shared=true;}if(url){_158=this.parent=url.toString();}else{if(_158.templateString){_159=_158.templateString;_158=this.parent=" ";}else{_158=this.parent=this.parent.toString();}}}if(_158&&_158.indexOf("shared:")===0){this.shared=true;_158=this.parent=_158.substring(7,_158.length);}}if(!_158){throw new Error("Invalid template name in 'extends' tag.");}if(_158.render){return _158;}if(this.parents[_158]){return this.parents[_158];}this.parent=this.getTemplate(_159||dojox.dtl.text.getTemplateString(_158));if(this.shared){this.parents[_158]=this.parent;}return this.parent;},render:function(_15a,_15b){var _15c=this.getParent(_15a);_15c.blocks=_15c.blocks||{};_15b.blocks=_15b.blocks||{};for(var i=0,node;node=this.nodelist.contents[i];i++){if(node instanceof dojox.dtl.tag.loader.BlockNode){var old=_15c.blocks[node.name];if(old&&old.nodelist!=node.nodelist){_15b=old.nodelist.unrender(_15a,_15b);}_15c.blocks[node.name]=_15b.blocks[node.name]={shared:this.shared,nodelist:node.nodelist,used:false};}}this.rendered=_15c;return _15c.nodelist.render(_15a,_15b,this);},unrender:function(_15d,_15e){return this.rendered.unrender(_15d,_15e,this);},toString:function(){return "dojox.dtl.block.ExtendsNode";}});ddtl.IncludeNode=lang.extend(function(path,_15f,_160,text,_161){this._path=path;this.constant=_15f;this.path=(_15f)?path:new dd._Filter(path);this.getTemplate=_160;this.text=text;this.parsed=(arguments.length==5)?_161:true;},{_cache:[{},{}],render:function(_162,_163){var _164=((this.constant)?this.path:this.path.resolve(_162)).toString();var _165=Number(this.parsed);var _166=false;if(_164!=this.last){_166=true;if(this.last){_163=this.unrender(_162,_163);}this.last=_164;}var _167=this._cache[_165];if(_165){if(!_167[_164]){_167[_164]=dd.text._resolveTemplateArg(_164,true);}if(_166){var _168=this.getTemplate(_167[_164]);this.rendered=_168.nodelist;}return this.rendered.render(_162,_163,this);}else{if(this.text instanceof dd._TextNode){if(_166){this.rendered=this.text;this.rendered.set(dd.text._resolveTemplateArg(_164,true));}return this.rendered.render(_162,_163);}else{if(!_167[_164]){var _169=[];var div=document.createElement("div");div.innerHTML=dd.text._resolveTemplateArg(_164,true);var _16a=div.childNodes;while(_16a.length){var _16b=div.removeChild(_16a[0]);_169.push(_16b);}_167[_164]=_169;}if(_166){this.nodelist=[];var _16c=true;for(var i=0,_16d;_16d=_167[_164][i];i++){this.nodelist.push(_16d.cloneNode(true));}}for(var i=0,node;node=this.nodelist[i];i++){_163=_163.concat(node);}}}return _163;},unrender:function(_16e,_16f){if(this.rendered){_16f=this.rendered.unrender(_16e,_16f);}if(this.nodelist){for(var i=0,node;node=this.nodelist[i];i++){_16f=_16f.remove(node);}}return _16f;},clone:function(_170){return new this.constructor(this._path,this.constant,this.getTemplate,this.text.clone(_170),this.parsed);}});lang.mixin(ddtl,{block:function(_171,_172){var _173=_172.contents.split();var name=_173[1];_171._blocks=_171._blocks||{};_171._blocks[name]=_171._blocks[name]||[];_171._blocks[name].push(name);var _174=_171.parse(["endblock","endblock "+name]).rtrim();_171.next_token();return new dojox.dtl.tag.loader.BlockNode(name,_174);},extends_:function(_175,_176){var _177=_176.contents.split();var _178=false;var _179=null;var key=null;if(_177[1].charAt(0)=="\""||_177[1].charAt(0)=="'"){_179=_177[1].substring(1,_177[1].length-1);}else{key=_177[1];}if(_179&&_179.indexOf("shared:")==0){_178=true;_179=_179.substring(7,_179.length);}var _17a=_175.parse();return new dojox.dtl.tag.loader.ExtendsNode(_175.getTemplate,_17a,_178,_179,key);},include:function(_17b,_17c){var _17d=_17c.contents.split();if(_17d.length!=2){throw new Error(_17d[0]+" tag takes one argument: the name of the template to be included");}var path=_17d[1];var _17e=false;if((path.charAt(0)=="\""||path.slice(-1)=="'")&&path.charAt(0)==path.slice(-1)){path=path.slice(1,-1);_17e=true;}return new ddtl.IncludeNode(path,_17e,_17b.getTemplate,_17b.create_text_node());},ssi:function(_17f,_180){var _181=_180.contents.split();var _182=false;if(_181.length==3){_182=(_181.pop()=="parsed");if(!_182){throw new Error("Second (optional) argument to ssi tag must be 'parsed'");}}var node=ddtl.include(_17f,new dd.Token(_180.token_type,_181.join(" ")));node.parsed=_182;return node;}});return dojox.dtl.tag.loader;});},"dojox/dtl/tag/misc":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/connect","../_base"],function(lang,_183,_184,dd){lang.getObject("dojox.dtl.tag.misc",true);var ddtm=dd.tag.misc;ddtm.DebugNode=lang.extend(function(text){this.text=text;},{render:function(_185,_186){var keys=_185.getKeys();var _187=[];var only={};for(var i=0,key;key=keys[i];i++){only[key]=_185[key];_187+="["+key+": "+typeof _185[key]+"]\n";}return this.text.set(_187).render(_185,_186,this);},unrender:function(_188,_189){return _189;},clone:function(_18a){return new this.constructor(this.text.clone(_18a));},toString:function(){return "ddtm.DebugNode";}});ddtm.FilterNode=lang.extend(function(_18b,_18c){this._varnode=_18b;this._nodelist=_18c;},{render:function(_18d,_18e){var _18f=this._nodelist.render(_18d,new dojox.string.Builder());_18d=_18d.update({"var":_18f.toString()});var _190=this._varnode.render(_18d,_18e);_18d=_18d.pop();return _18e;},unrender:function(_191,_192){return _192;},clone:function(_193){return new this.constructor(this._expression,this._nodelist.clone(_193));}});ddtm.FirstOfNode=lang.extend(function(vars,text){this._vars=vars;this.vars=_183.map(vars,function(item){return new dojox.dtl._Filter(item);});this.contents=text;},{render:function(_194,_195){for(var i=0,item;item=this.vars[i];i++){var _196=item.resolve(_194);if(typeof _196!="undefined"){if(_196===null){_196="null";}this.contents.set(_196);return this.contents.render(_194,_195);}}return this.contents.unrender(_194,_195);},unrender:function(_197,_198){return this.contents.unrender(_197,_198);},clone:function(_199){return new this.constructor(this._vars,this.contents.clone(_199));}});ddtm.SpacelessNode=lang.extend(function(_19a,text){this.nodelist=_19a;this.contents=text;},{render:function(_19b,_19c){if(_19c.getParent){var _19d=[_184.connect(_19c,"onAddNodeComplete",this,"_watch"),_184.connect(_19c,"onSetParent",this,"_watchParent")];_19c=this.nodelist.render(_19b,_19c);_184.disconnect(_19d[0]);_184.disconnect(_19d[1]);}else{var _19e=this.nodelist.dummyRender(_19b);this.contents.set(_19e.replace(/>\s+</g,"><"));_19c=this.contents.render(_19b,_19c);}return _19c;},unrender:function(_19f,_1a0){return this.nodelist.unrender(_19f,_1a0);},clone:function(_1a1){return new this.constructor(this.nodelist.clone(_1a1),this.contents.clone(_1a1));},_isEmpty:function(node){return (node.nodeType==3&&!node.data.match(/[^\s\n]/));},_watch:function(node){if(this._isEmpty(node)){var _1a2=false;if(node.parentNode.firstChild==node){node.parentNode.removeChild(node);}}else{var _1a3=node.parentNode.childNodes;if(node.nodeType==1&&_1a3.length>2){for(var i=2,_1a4;_1a4=_1a3[i];i++){if(_1a3[i-2].nodeType==1&&this._isEmpty(_1a3[i-1])){node.parentNode.removeChild(_1a3[i-1]);return;}}}}},_watchParent:function(node){var _1a5=node.childNodes;if(_1a5.length){while(node.childNodes.length){var last=node.childNodes[node.childNodes.length-1];if(!this._isEmpty(last)){return;}node.removeChild(last);}}}});ddtm.TemplateTagNode=lang.extend(function(tag,text){this.tag=tag;this.contents=text;},{mapping:{openblock:"{%",closeblock:"%}",openvariable:"{{",closevariable:"}}",openbrace:"{",closebrace:"}",opencomment:"{#",closecomment:"#}"},render:function(_1a6,_1a7){this.contents.set(this.mapping[this.tag]);return this.contents.render(_1a6,_1a7);},unrender:function(_1a8,_1a9){return this.contents.unrender(_1a8,_1a9);},clone:function(_1aa){return new this.constructor(this.tag,this.contents.clone(_1aa));}});ddtm.WidthRatioNode=lang.extend(function(_1ab,max,_1ac,text){this.current=new dd._Filter(_1ab);this.max=new dd._Filter(max);this.width=_1ac;this.contents=text;},{render:function(_1ad,_1ae){var _1af=+this.current.resolve(_1ad);var max=+this.max.resolve(_1ad);if(typeof _1af!="number"||typeof max!="number"||!max){this.contents.set("");}else{this.contents.set(""+Math.round((_1af/max)*this.width));}return this.contents.render(_1ad,_1ae);},unrender:function(_1b0,_1b1){return this.contents.unrender(_1b0,_1b1);},clone:function(_1b2){return new this.constructor(this.current.getExpression(),this.max.getExpression(),this.width,this.contents.clone(_1b2));}});ddtm.WithNode=lang.extend(function(_1b3,_1b4,_1b5){this.target=new dd._Filter(_1b3);this.alias=_1b4;this.nodelist=_1b5;},{render:function(_1b6,_1b7){var _1b8=this.target.resolve(_1b6);_1b6=_1b6.push();_1b6[this.alias]=_1b8;_1b7=this.nodelist.render(_1b6,_1b7);_1b6=_1b6.pop();return _1b7;},unrender:function(_1b9,_1ba){return _1ba;},clone:function(_1bb){return new this.constructor(this.target.getExpression(),this.alias,this.nodelist.clone(_1bb));}});lang.mixin(ddtm,{comment:function(_1bc,_1bd){_1bc.skip_past("endcomment");return dd._noOpNode;},debug:function(_1be,_1bf){return new ddtm.DebugNode(_1be.create_text_node());},filter:function(_1c0,_1c1){var rest=_1c1.contents.split(null,1)[1];var _1c2=_1c0.create_variable_node("var|"+rest);var _1c3=_1c0.parse(["endfilter"]);_1c0.next_token();return new ddtm.FilterNode(_1c2,_1c3);},firstof:function(_1c4,_1c5){var _1c6=_1c5.split_contents().slice(1);if(!_1c6.length){throw new Error("'firstof' statement requires at least one argument");}return new ddtm.FirstOfNode(_1c6,_1c4.create_text_node());},spaceless:function(_1c7,_1c8){var _1c9=_1c7.parse(["endspaceless"]);_1c7.delete_first_token();return new ddtm.SpacelessNode(_1c9,_1c7.create_text_node());},templatetag:function(_1ca,_1cb){var _1cc=_1cb.contents.split();if(_1cc.length!=2){throw new Error("'templatetag' statement takes one argument");}var tag=_1cc[1];var _1cd=ddtm.TemplateTagNode.prototype.mapping;if(!_1cd[tag]){var keys=[];for(var key in _1cd){keys.push(key);}throw new Error("Invalid templatetag argument: '"+tag+"'. Must be one of: "+keys.join(", "));}return new ddtm.TemplateTagNode(tag,_1ca.create_text_node());},widthratio:function(_1ce,_1cf){var _1d0=_1cf.contents.split();if(_1d0.length!=4){throw new Error("widthratio takes three arguments");}var _1d1=+_1d0[3];if(typeof _1d1!="number"){throw new Error("widthratio final argument must be an integer");}return new ddtm.WidthRatioNode(_1d0[1],_1d0[2],_1d1,_1ce.create_text_node());},with_:function(_1d2,_1d3){var _1d4=_1d3.split_contents();if(_1d4.length!=4||_1d4[2]!="as"){throw new Error("do_width expected format as 'with value as name'");}var _1d5=_1d2.parse(["endwith"]);_1d2.next_token();return new ddtm.WithNode(_1d4[1],_1d4[3],_1d5);}});return dojox.dtl.tag.misc;});},"dojox/dtl/ext-dojo/NodeList":function(){define(["dojo/_base/lang","dojo/query","../_base"],function(lang,_1d6,dd){var nl=lang.getObject("dojox.dtl.ext-dojo.NodeList",true);var _1d7=_1d6.NodeList;lang.extend(_1d7,{dtl:function(_1d8,_1d9){var d=dd,self=this;var _1da=function(_1db,_1dc){var _1dd=_1db.render(new d._Context(_1dc));self.forEach(function(node){node.innerHTML=_1dd;});};d.text._resolveTemplateArg(_1d8).addCallback(function(_1de){_1d8=new d.Template(_1de);d.text._resolveContextArg(_1d9).addCallback(function(_1df){_1da(_1d8,_1df);});});return this;}});return _1d7;});}}});define("dojox/dtl",["./dtl/_base"],function(_1e0){return _1e0;});