/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */
#line 24 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/mysql-5.6.44-release-export-14508947_gpl/sql/sql_yacc.yy" /* yacc.c:339  */

/*
Note: YYTHD is passed as an argument to yyparse(), and subsequently to yylex().
*/
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)
#define YYCSCL  YYTHD->variables.character_set_client

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "rpl_slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_instr.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "opt_explain_traditional.h"
#include "opt_explain_json.h"
#include "lex_token.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

using std::min;
using std::max;

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(YYTHD, (char*) (A));            \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    MY_ATTRIBUTE ((__unused__))
  #endif
</pre>
  This usage of MY_ATTRIBUTE is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef MY_ATTRIBUTE
#define MY_ATTRIBUTE(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param thd thread handler
*/

void case_stmt_action_case(THD *thd)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp->m_parser_data.new_cont_backpatch();

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  pctx->push_label(thd, EMPTY_STR, sp->instructions());
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

bool case_stmt_action_then(THD *thd, LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp_instr_jump *i =
    new (thd->mem_root) sp_instr_jump(sp->instructions(), pctx);

  if (!i || sp->add_instr(thd, i))
    return true;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->m_parser_data.add_backpatch_entry(i, pctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  if (simple)
    pctx->pop_case_expr_id();

  sp->m_parser_data.do_cont_backpatch(sp->instructions());
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (pctx && tmp->var == Sys_autocommit_ptr)
    sp->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

#ifdef HAVE_REPLICATION
  if (lex->uses_stored_routines() &&
      ((tmp->var == Sys_gtid_next_ptr
#ifdef HAVE_GTID_NEXT_LIST
       || tmp->var == Sys_gtid_next_list_ptr
#endif
       ) ||
       Sys_gtid_purged_ptr == tmp->var))
  {
    my_error(ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION, MYF(0),
             tmp->var->name.str);
    return TRUE;
  }
#endif

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd                thread handler
  @param trigger_field_name the NEW-row field name
  @param expr_item          the value expression being assigned
  @param expr_query         the value expression query

  @return error status (true if error, false otherwise).
*/

static bool set_trigger_new_row(THD *thd,
                                LEX_STRING trigger_field_name,
                                Item *expr_item,
                                LEX_STRING expr_query)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  DBUG_ASSERT(expr_item);
  DBUG_ASSERT(sp->m_trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (sp->m_trg_chistics.event == TRG_EVENT_INSERT ||
               sp->m_trg_chistics.event == TRG_EVENT_UPDATE));

  Item_trigger_field *trg_fld=
    new (thd->mem_root) Item_trigger_field(lex->current_context(),
                                           Item_trigger_field::NEW_ROW,
                                           trigger_field_name.str,
                                           UPDATE_ACL, false);

  if (!trg_fld)
    return true;

  sp_instr_set_trigger_field *i=
    new (thd->mem_root)
      sp_instr_set_trigger_field(sp->instructions(),
                                 lex,
                                 trigger_field_name,
                                 trg_fld, expr_item,
                                 expr_query);

  if (!i)
    return true;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  sp->m_cur_instr_trig_field_items.link_in_list(trg_fld,
                                                &trg_fld->next_trg_field);

  return sp->add_instr(thd, i);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param thd              The current thread.
  @param name             The SP variable name.
  @param spv              The SP variable (optional).
  @param query_start_ptr  Start of the SQL-statement query string (optional).
  @param start_in_q       Start position of the SP variable name in the query.
  @param end_in_q         End position of the SP variable name in the query.

  @remark If spv is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal* create_item_for_sp_var(THD *thd,
                                            LEX_STRING name,
                                            sp_variable *spv,
                                            const char *query_start_ptr,
                                            const char *start_in_q,
                                            const char *end_in_q)
{
  LEX *lex= thd->lex;
  uint spv_pos_in_query= 0;
  uint spv_len_in_query= 0;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* If necessary, look for the variable. */
  if (pctx && !spv)
    spv= pctx->find_variable(name, false);

  if (!spv)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(pctx && spv);

  if (query_start_ptr)
  {
    /* Position and length of the SP variable name in the query. */
    spv_pos_in_query= start_in_q - query_start_ptr;
    spv_len_in_query= end_in_q - start_in_q;
  }

  Item_splocal *item=
    new (thd->mem_root) Item_splocal(
      name, spv->offset, spv->type, spv_pos_in_query, spv_len_in_query);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->proc_analyse)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "SELECT ... PROCEDURE ANALYSE()");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}

/**
  Make a new string allocated on THD's mem-root.

  @param thd        thread handler.
  @param start_ptr  start of the new string.
  @param end_ptr    end of the new string.

  @return LEX_STRING object, containing a pointer to a newly
  constructed/allocated string, and its length. The pointer is NULL
  in case of out-of-memory error.
*/
static LEX_STRING make_string(THD *thd,
                              const char *start_ptr,
                              const char *end_ptr)
{
  LEX_STRING s;

  s.length= end_ptr - start_ptr;
  s.str= (char *) thd->alloc(s.length + 1);

  if (s.str)
    strmake(s.str, start_ptr, s.length);

  return s;
}

/*
  The start is either lip->ptr, if there was no lookahead, lip->tok_start
  otherwise.
*/
#define YY_TOKEN_START \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_start())

/*
   The end is either lip->ptr, if there was no lookahead,
   or lip->tok_end otherwise.
*/

#define YY_TOKEN_END \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_end())

/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  @see sp_create_assignment_instr

  @param thd        Thread context
  @param option_ptr Option-value-expression start pointer
*/

static void sp_create_assignment_lex(THD *thd, const char *option_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return;
  }

  LEX *old_lex= lex;
  sp->reset_lex(thd);
  lex= thd->lex;

  /* Set new LEX as if we at start of set rule. */
  mysql_init_select(lex);
  lex->sql_command= SQLCOM_SET_OPTION;
  lex->var_list.empty();
  lex->one_shot_set= 0;
  lex->autocommit= 0;

  /*
    It's a SET statement within SP. It will be either translated
    into one or more sp_instr_stmt instructions, or it will be
    sp_instr_set / sp_instr_set_trigger_field instructions.
    In any case, position of SP-variable can not be determined
    reliably. So, we set the start pointer of the current statement
    to NULL.
  */
  sp->m_parser_data.set_current_stmt_start_ptr(NULL);
  sp->m_parser_data.set_option_start_ptr(option_ptr);

  /* Inherit from outer lex. */
  lex->option_type= old_lex->option_type;
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param expr_end_ptr  Option-value-expression end pointer

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, const char *expr_end_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return false;
  }

  if (!lex->var_list.is_empty())
  {
    /* Extract expression string. */

    const char *expr_start_ptr= sp->m_parser_data.get_option_start_ptr();

    LEX_STRING expr;
    expr.str= (char *) expr_start_ptr;
    expr.length= expr_end_ptr - expr_start_ptr;

    /* Construct SET-statement query. */

    LEX_STRING set_stmt_query;

    set_stmt_query.length= expr.length + 3;
    set_stmt_query.str= (char *) thd->alloc(set_stmt_query.length + 1);

    if (!set_stmt_query.str)
      return true;

    strmake(strmake(set_stmt_query.str, "SET", 3),
            expr.str, expr.length);

    /*
      We have assignment to user or system variable or option setting, so we
      should construct sp_instr_stmt for it.
    */

    sp_instr_stmt *i=
      new (thd->mem_root)
        sp_instr_stmt(sp->instructions(), lex, set_stmt_query);

    if (!i || sp->add_instr(thd, i))
      return true;
  }

  /* Remember option_type of the currently parsed LEX. */
  enum_var_type inner_option_type= lex->option_type;

  if (sp->restore_lex(thd))
    return true;

  /* Copy option_type to outer lex in case it has changed. */
  thd->lex->option_type= inner_option_type;

  return false;
}

/**
  Compare a LEX_USER against the current user as defined by the exact user and
  host used during authentication.

  @param user A pointer to a user which needs to be matched against the
              current.

  @see SET PASSWORD rules

  @retval true The specified user is the authorized user
  @retval false The user doesn't match
*/

bool match_authorized_user(Security_context *ctx, LEX_USER *user)
{
  if(user->user.str && my_strcasecmp(system_charset_info,
                                     ctx->priv_user,
                                     user->user.str) == 0)
  {
    /*
      users match; let's compare hosts.
      1. first compare with the host we actually authorized,
      2. then see if we match the host mask of the priv_host
    */
    if (user->host.str && my_strcasecmp(system_charset_info,
                                        user->host.str,
                                        ctx->priv_host) == 0)
    {
      /* specified user exactly match the authorized user */
      return true;
    }
  }
  return false;
}



#line 1017 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/dist_GPL/sql/sql_yacc.cc" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "sql_yacc.h".  */
#ifndef YY_MYSQL_EXPORT_HOME2_PB2_BUILD_SB_2_33225745_1552635831_74_DIST_GPL_SQL_SQL_YACC_H_INCLUDED
# define YY_MYSQL_EXPORT_HOME2_PB2_BUILD_SB_2_33225745_1552635831_74_DIST_GPL_SQL_SQL_YACC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int MYSQLdebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ABORT_SYM = 258,
    ACCESSIBLE_SYM = 259,
    ACTION = 260,
    ADD = 261,
    ADDDATE_SYM = 262,
    AFTER_SYM = 263,
    AGAINST = 264,
    AGGREGATE_SYM = 265,
    ALGORITHM_SYM = 266,
    ALL = 267,
    ALTER = 268,
    ANALYSE_SYM = 269,
    ANALYZE_SYM = 270,
    AND_AND_SYM = 271,
    AND_SYM = 272,
    ANY_SYM = 273,
    AS = 274,
    ASC = 275,
    ASCII_SYM = 276,
    ASENSITIVE_SYM = 277,
    AT_SYM = 278,
    AUTOEXTEND_SIZE_SYM = 279,
    AUTO_INC = 280,
    AVG_ROW_LENGTH = 281,
    AVG_SYM = 282,
    BACKUP_SYM = 283,
    BEFORE_SYM = 284,
    BEGIN_SYM = 285,
    BETWEEN_SYM = 286,
    BIGINT = 287,
    BINARY = 288,
    BINLOG_SYM = 289,
    BIN_NUM = 290,
    BIT_AND = 291,
    BIT_OR = 292,
    BIT_SYM = 293,
    BIT_XOR = 294,
    BLOB_SYM = 295,
    BLOCK_SYM = 296,
    BOOLEAN_SYM = 297,
    BOOL_SYM = 298,
    BOTH = 299,
    BTREE_SYM = 300,
    BY = 301,
    BYTE_SYM = 302,
    CACHE_SYM = 303,
    CALL_SYM = 304,
    CASCADE = 305,
    CASCADED = 306,
    CASE_SYM = 307,
    CAST_SYM = 308,
    CATALOG_NAME_SYM = 309,
    CHAIN_SYM = 310,
    CHANGE = 311,
    CHANGED = 312,
    CHARSET = 313,
    CHAR_SYM = 314,
    CHECKSUM_SYM = 315,
    CHECK_SYM = 316,
    CIPHER_SYM = 317,
    CLASS_ORIGIN_SYM = 318,
    CLIENT_SYM = 319,
    CLOSE_SYM = 320,
    COALESCE = 321,
    CODE_SYM = 322,
    COLLATE_SYM = 323,
    COLLATION_SYM = 324,
    COLUMNS = 325,
    COLUMN_SYM = 326,
    COLUMN_FORMAT_SYM = 327,
    COLUMN_NAME_SYM = 328,
    COMMENT_SYM = 329,
    COMMITTED_SYM = 330,
    COMMIT_SYM = 331,
    COMPACT_SYM = 332,
    COMPLETION_SYM = 333,
    COMPRESSED_SYM = 334,
    CONCURRENT = 335,
    CONDITION_SYM = 336,
    CONNECTION_SYM = 337,
    CONSISTENT_SYM = 338,
    CONSTRAINT = 339,
    CONSTRAINT_CATALOG_SYM = 340,
    CONSTRAINT_NAME_SYM = 341,
    CONSTRAINT_SCHEMA_SYM = 342,
    CONTAINS_SYM = 343,
    CONTEXT_SYM = 344,
    CONTINUE_SYM = 345,
    CONVERT_SYM = 346,
    COUNT_SYM = 347,
    CPU_SYM = 348,
    CREATE = 349,
    CROSS = 350,
    CUBE_SYM = 351,
    CURDATE = 352,
    CURRENT_SYM = 353,
    CURRENT_USER = 354,
    CURSOR_SYM = 355,
    CURSOR_NAME_SYM = 356,
    CURTIME = 357,
    DATABASE = 358,
    DATABASES = 359,
    DATAFILE_SYM = 360,
    DATA_SYM = 361,
    DATETIME = 362,
    DATE_ADD_INTERVAL = 363,
    DATE_SUB_INTERVAL = 364,
    DATE_SYM = 365,
    DAY_HOUR_SYM = 366,
    DAY_MICROSECOND_SYM = 367,
    DAY_MINUTE_SYM = 368,
    DAY_SECOND_SYM = 369,
    DAY_SYM = 370,
    DEALLOCATE_SYM = 371,
    DECIMAL_NUM = 372,
    DECIMAL_SYM = 373,
    DECLARE_SYM = 374,
    DEFAULT = 375,
    DEFAULT_AUTH_SYM = 376,
    DEFINER_SYM = 377,
    DELAYED_SYM = 378,
    DELAY_KEY_WRITE_SYM = 379,
    DELETE_SYM = 380,
    DESC = 381,
    DESCRIBE = 382,
    DES_KEY_FILE = 383,
    DETERMINISTIC_SYM = 384,
    DIAGNOSTICS_SYM = 385,
    DIRECTORY_SYM = 386,
    DISABLE_SYM = 387,
    DISCARD = 388,
    DISK_SYM = 389,
    DISTINCT = 390,
    DIV_SYM = 391,
    DOUBLE_SYM = 392,
    DO_SYM = 393,
    DROP = 394,
    DUAL_SYM = 395,
    DUMPFILE = 396,
    DUPLICATE_SYM = 397,
    DYNAMIC_SYM = 398,
    EACH_SYM = 399,
    ELSE = 400,
    ELSEIF_SYM = 401,
    ENABLE_SYM = 402,
    ENCLOSED = 403,
    END = 404,
    ENDS_SYM = 405,
    END_OF_INPUT = 406,
    ENGINES_SYM = 407,
    ENGINE_SYM = 408,
    ENUM = 409,
    EQ = 410,
    EQUAL_SYM = 411,
    ERROR_SYM = 412,
    ERRORS = 413,
    ESCAPED = 414,
    ESCAPE_SYM = 415,
    EVENTS_SYM = 416,
    EVENT_SYM = 417,
    EVERY_SYM = 418,
    EXCHANGE_SYM = 419,
    EXECUTE_SYM = 420,
    EXISTS = 421,
    EXIT_SYM = 422,
    EXPANSION_SYM = 423,
    EXPIRE_SYM = 424,
    EXPORT_SYM = 425,
    EXTENDED_SYM = 426,
    EXTENT_SIZE_SYM = 427,
    EXTRACT_SYM = 428,
    FALSE_SYM = 429,
    FAST_SYM = 430,
    FAULTS_SYM = 431,
    FETCH_SYM = 432,
    FILE_SYM = 433,
    FIRST_SYM = 434,
    FIXED_SYM = 435,
    FLOAT_NUM = 436,
    FLOAT_SYM = 437,
    FLUSH_SYM = 438,
    FORCE_SYM = 439,
    FOREIGN = 440,
    FOR_SYM = 441,
    FORMAT_SYM = 442,
    FOUND_SYM = 443,
    FROM = 444,
    FULL = 445,
    FULLTEXT_SYM = 446,
    FUNCTION_SYM = 447,
    GE = 448,
    GENERAL = 449,
    GEOMETRYCOLLECTION = 450,
    GEOMETRY_SYM = 451,
    GET_FORMAT = 452,
    GET_SYM = 453,
    GLOBAL_SYM = 454,
    GRANT = 455,
    GRANTS = 456,
    GROUP_SYM = 457,
    GROUP_CONCAT_SYM = 458,
    GT_SYM = 459,
    HANDLER_SYM = 460,
    HASH_SYM = 461,
    HAVING = 462,
    HELP_SYM = 463,
    HEX_NUM = 464,
    HIGH_PRIORITY = 465,
    HOST_SYM = 466,
    HOSTS_SYM = 467,
    HOUR_MICROSECOND_SYM = 468,
    HOUR_MINUTE_SYM = 469,
    HOUR_SECOND_SYM = 470,
    HOUR_SYM = 471,
    IDENT = 472,
    IDENTIFIED_SYM = 473,
    IDENT_QUOTED = 474,
    IF = 475,
    IGNORE_SYM = 476,
    IGNORE_SERVER_IDS_SYM = 477,
    IMPORT = 478,
    INDEXES = 479,
    INDEX_SYM = 480,
    INFILE = 481,
    INITIAL_SIZE_SYM = 482,
    INNER_SYM = 483,
    INOUT_SYM = 484,
    INSENSITIVE_SYM = 485,
    INSERT = 486,
    INSERT_METHOD = 487,
    INSTALL_SYM = 488,
    INTERVAL_SYM = 489,
    INTO = 490,
    INT_SYM = 491,
    INVOKER_SYM = 492,
    IN_SYM = 493,
    IO_AFTER_GTIDS = 494,
    IO_BEFORE_GTIDS = 495,
    IO_SYM = 496,
    IPC_SYM = 497,
    IS = 498,
    ISOLATION = 499,
    ISSUER_SYM = 500,
    ITERATE_SYM = 501,
    JOIN_SYM = 502,
    KEYS = 503,
    KEY_BLOCK_SIZE = 504,
    KEY_SYM = 505,
    KILL_SYM = 506,
    LANGUAGE_SYM = 507,
    LAST_SYM = 508,
    LE = 509,
    LEADING = 510,
    LEAVES = 511,
    LEAVE_SYM = 512,
    LEFT = 513,
    LESS_SYM = 514,
    LEVEL_SYM = 515,
    LEX_HOSTNAME = 516,
    LIKE = 517,
    LIMIT = 518,
    LINEAR_SYM = 519,
    LINES = 520,
    LINESTRING = 521,
    LIST_SYM = 522,
    LOAD = 523,
    LOCAL_SYM = 524,
    LOCATOR_SYM = 525,
    LOCKS_SYM = 526,
    LOCK_SYM = 527,
    LOGFILE_SYM = 528,
    LOGS_SYM = 529,
    LONGBLOB = 530,
    LONGTEXT = 531,
    LONG_NUM = 532,
    LONG_SYM = 533,
    LOOP_SYM = 534,
    LOW_PRIORITY = 535,
    LT = 536,
    MASTER_AUTO_POSITION_SYM = 537,
    MASTER_BIND_SYM = 538,
    MASTER_CONNECT_RETRY_SYM = 539,
    MASTER_DELAY_SYM = 540,
    MASTER_HOST_SYM = 541,
    MASTER_LOG_FILE_SYM = 542,
    MASTER_LOG_POS_SYM = 543,
    MASTER_PASSWORD_SYM = 544,
    MASTER_PORT_SYM = 545,
    MASTER_RETRY_COUNT_SYM = 546,
    MASTER_SERVER_ID_SYM = 547,
    MASTER_SSL_CAPATH_SYM = 548,
    MASTER_SSL_CA_SYM = 549,
    MASTER_SSL_CERT_SYM = 550,
    MASTER_SSL_CIPHER_SYM = 551,
    MASTER_SSL_CRL_SYM = 552,
    MASTER_SSL_CRLPATH_SYM = 553,
    MASTER_SSL_KEY_SYM = 554,
    MASTER_SSL_SYM = 555,
    MASTER_SSL_VERIFY_SERVER_CERT_SYM = 556,
    MASTER_SYM = 557,
    MASTER_USER_SYM = 558,
    MASTER_HEARTBEAT_PERIOD_SYM = 559,
    MATCH = 560,
    MAX_CONNECTIONS_PER_HOUR = 561,
    MAX_QUERIES_PER_HOUR = 562,
    MAX_ROWS = 563,
    MAX_SIZE_SYM = 564,
    MAX_SYM = 565,
    MAX_UPDATES_PER_HOUR = 566,
    MAX_USER_CONNECTIONS_SYM = 567,
    MAX_VALUE_SYM = 568,
    MEDIUMBLOB = 569,
    MEDIUMINT = 570,
    MEDIUMTEXT = 571,
    MEDIUM_SYM = 572,
    MEMORY_SYM = 573,
    MERGE_SYM = 574,
    MESSAGE_TEXT_SYM = 575,
    MICROSECOND_SYM = 576,
    MIGRATE_SYM = 577,
    MINUTE_MICROSECOND_SYM = 578,
    MINUTE_SECOND_SYM = 579,
    MINUTE_SYM = 580,
    MIN_ROWS = 581,
    MIN_SYM = 582,
    MODE_SYM = 583,
    MODIFIES_SYM = 584,
    MODIFY_SYM = 585,
    MOD_SYM = 586,
    MONTH_SYM = 587,
    MULTILINESTRING = 588,
    MULTIPOINT = 589,
    MULTIPOLYGON = 590,
    MUTEX_SYM = 591,
    MYSQL_ERRNO_SYM = 592,
    NAMES_SYM = 593,
    NAME_SYM = 594,
    NATIONAL_SYM = 595,
    NATURAL = 596,
    NCHAR_STRING = 597,
    NCHAR_SYM = 598,
    NDBCLUSTER_SYM = 599,
    NE = 600,
    NEG = 601,
    NEW_SYM = 602,
    NEXT_SYM = 603,
    NODEGROUP_SYM = 604,
    NONE_SYM = 605,
    NOT2_SYM = 606,
    NOT_SYM = 607,
    NOW_SYM = 608,
    NO_SYM = 609,
    NO_WAIT_SYM = 610,
    NO_WRITE_TO_BINLOG = 611,
    NULL_SYM = 612,
    NUM = 613,
    NUMBER_SYM = 614,
    NUMERIC_SYM = 615,
    NVARCHAR_SYM = 616,
    OFFSET_SYM = 617,
    OLD_PASSWORD = 618,
    ON = 619,
    ONE_SYM = 620,
    ONLY_SYM = 621,
    OPEN_SYM = 622,
    OPTIMIZE = 623,
    OPTIONS_SYM = 624,
    OPTION = 625,
    OPTIONALLY = 626,
    OR2_SYM = 627,
    ORDER_SYM = 628,
    OR_OR_SYM = 629,
    OR_SYM = 630,
    OUTER = 631,
    OUTFILE = 632,
    OUT_SYM = 633,
    OWNER_SYM = 634,
    PACK_KEYS_SYM = 635,
    PAGE_SYM = 636,
    PARAM_MARKER = 637,
    PARSER_SYM = 638,
    PARTIAL = 639,
    PARTITION_SYM = 640,
    PARTITIONS_SYM = 641,
    PARTITIONING_SYM = 642,
    PASSWORD = 643,
    PHASE_SYM = 644,
    PLUGIN_DIR_SYM = 645,
    PLUGIN_SYM = 646,
    PLUGINS_SYM = 647,
    POINT_SYM = 648,
    POLYGON = 649,
    PORT_SYM = 650,
    POSITION_SYM = 651,
    PRECISION = 652,
    PREPARE_SYM = 653,
    PRESERVE_SYM = 654,
    PREV_SYM = 655,
    PRIMARY_SYM = 656,
    PRIVILEGES = 657,
    PROCEDURE_SYM = 658,
    PROCESS = 659,
    PROCESSLIST_SYM = 660,
    PROFILE_SYM = 661,
    PROFILES_SYM = 662,
    PROXY_SYM = 663,
    PURGE = 664,
    QUARTER_SYM = 665,
    QUERY_SYM = 666,
    QUICK = 667,
    RANGE_SYM = 668,
    READS_SYM = 669,
    READ_ONLY_SYM = 670,
    READ_SYM = 671,
    READ_WRITE_SYM = 672,
    REAL = 673,
    REBUILD_SYM = 674,
    RECOVER_SYM = 675,
    REDOFILE_SYM = 676,
    REDO_BUFFER_SIZE_SYM = 677,
    REDUNDANT_SYM = 678,
    REFERENCES = 679,
    REGEXP = 680,
    RELAY = 681,
    RELAYLOG_SYM = 682,
    RELAY_LOG_FILE_SYM = 683,
    RELAY_LOG_POS_SYM = 684,
    RELAY_THREAD = 685,
    RELEASE_SYM = 686,
    RELOAD = 687,
    REMOVE_SYM = 688,
    RENAME = 689,
    REORGANIZE_SYM = 690,
    REPAIR = 691,
    REPEATABLE_SYM = 692,
    REPEAT_SYM = 693,
    REPLACE = 694,
    REPLICATION = 695,
    REQUIRE_SYM = 696,
    RESET_SYM = 697,
    RESIGNAL_SYM = 698,
    RESOURCES = 699,
    RESTORE_SYM = 700,
    RESTRICT = 701,
    RESUME_SYM = 702,
    RETURNED_SQLSTATE_SYM = 703,
    RETURNS_SYM = 704,
    RETURN_SYM = 705,
    REVERSE_SYM = 706,
    REVOKE = 707,
    RIGHT = 708,
    ROLLBACK_SYM = 709,
    ROLLUP_SYM = 710,
    ROUTINE_SYM = 711,
    ROWS_SYM = 712,
    ROW_FORMAT_SYM = 713,
    ROW_SYM = 714,
    ROW_COUNT_SYM = 715,
    RTREE_SYM = 716,
    SAVEPOINT_SYM = 717,
    SCHEDULE_SYM = 718,
    SCHEMA_NAME_SYM = 719,
    SECOND_MICROSECOND_SYM = 720,
    SECOND_SYM = 721,
    SECURITY_SYM = 722,
    SELECT_SYM = 723,
    SENSITIVE_SYM = 724,
    SEPARATOR_SYM = 725,
    SERIALIZABLE_SYM = 726,
    SERIAL_SYM = 727,
    SESSION_SYM = 728,
    SERVER_SYM = 729,
    SERVER_OPTIONS = 730,
    SET = 731,
    SET_VAR = 732,
    SHARE_SYM = 733,
    SHIFT_LEFT = 734,
    SHIFT_RIGHT = 735,
    SHOW = 736,
    SHUTDOWN = 737,
    SIGNAL_SYM = 738,
    SIGNED_SYM = 739,
    SIMPLE_SYM = 740,
    SLAVE = 741,
    SLOW = 742,
    SMALLINT = 743,
    SNAPSHOT_SYM = 744,
    SOCKET_SYM = 745,
    SONAME_SYM = 746,
    SOUNDS_SYM = 747,
    SOURCE_SYM = 748,
    SPATIAL_SYM = 749,
    SPECIFIC_SYM = 750,
    SQLEXCEPTION_SYM = 751,
    SQLSTATE_SYM = 752,
    SQLWARNING_SYM = 753,
    SQL_AFTER_GTIDS = 754,
    SQL_AFTER_MTS_GAPS = 755,
    SQL_BEFORE_GTIDS = 756,
    SQL_BIG_RESULT = 757,
    SQL_BUFFER_RESULT = 758,
    SQL_CACHE_SYM = 759,
    SQL_CALC_FOUND_ROWS = 760,
    SQL_NO_CACHE_SYM = 761,
    SQL_SMALL_RESULT = 762,
    SQL_SYM = 763,
    SQL_THREAD = 764,
    SSL_SYM = 765,
    STARTING = 766,
    STARTS_SYM = 767,
    START_SYM = 768,
    STATS_AUTO_RECALC_SYM = 769,
    STATS_PERSISTENT_SYM = 770,
    STATS_SAMPLE_PAGES_SYM = 771,
    STATUS_SYM = 772,
    STDDEV_SAMP_SYM = 773,
    STD_SYM = 774,
    STOP_SYM = 775,
    STORAGE_SYM = 776,
    STRAIGHT_JOIN = 777,
    STRING_SYM = 778,
    SUBCLASS_ORIGIN_SYM = 779,
    SUBDATE_SYM = 780,
    SUBJECT_SYM = 781,
    SUBPARTITIONS_SYM = 782,
    SUBPARTITION_SYM = 783,
    SUBSTRING = 784,
    SUM_SYM = 785,
    SUPER_SYM = 786,
    SUSPEND_SYM = 787,
    SWAPS_SYM = 788,
    SWITCHES_SYM = 789,
    SYSDATE = 790,
    TABLES = 791,
    TABLESPACE = 792,
    TABLE_REF_PRIORITY = 793,
    TABLE_SYM = 794,
    TABLE_CHECKSUM_SYM = 795,
    TABLE_NAME_SYM = 796,
    TEMPORARY = 797,
    TEMPTABLE_SYM = 798,
    TERMINATED = 799,
    TEXT_STRING = 800,
    TEXT_SYM = 801,
    THAN_SYM = 802,
    THEN_SYM = 803,
    TIMESTAMP = 804,
    TIMESTAMP_ADD = 805,
    TIMESTAMP_DIFF = 806,
    TIME_SYM = 807,
    TINYBLOB = 808,
    TINYINT = 809,
    TINYTEXT = 810,
    TO_SYM = 811,
    TRAILING = 812,
    TRANSACTION_SYM = 813,
    TRIGGERS_SYM = 814,
    TRIGGER_SYM = 815,
    TRIM = 816,
    TRUE_SYM = 817,
    TRUNCATE_SYM = 818,
    TYPES_SYM = 819,
    TYPE_SYM = 820,
    UDF_RETURNS_SYM = 821,
    ULONGLONG_NUM = 822,
    UNCOMMITTED_SYM = 823,
    UNDEFINED_SYM = 824,
    UNDERSCORE_CHARSET = 825,
    UNDOFILE_SYM = 826,
    UNDO_BUFFER_SIZE_SYM = 827,
    UNDO_SYM = 828,
    UNICODE_SYM = 829,
    UNINSTALL_SYM = 830,
    UNION_SYM = 831,
    UNIQUE_SYM = 832,
    UNKNOWN_SYM = 833,
    UNLOCK_SYM = 834,
    UNSIGNED = 835,
    UNTIL_SYM = 836,
    UPDATE_SYM = 837,
    UPGRADE_SYM = 838,
    USAGE = 839,
    USER = 840,
    USE_FRM = 841,
    USE_SYM = 842,
    USING = 843,
    UTC_DATE_SYM = 844,
    UTC_TIMESTAMP_SYM = 845,
    UTC_TIME_SYM = 846,
    VALUES = 847,
    VALUE_SYM = 848,
    VARBINARY = 849,
    VARCHAR = 850,
    VARIABLES = 851,
    VARIANCE_SYM = 852,
    VARYING = 853,
    VAR_SAMP_SYM = 854,
    VIEW_SYM = 855,
    WAIT_SYM = 856,
    WARNINGS = 857,
    WEEK_SYM = 858,
    WEIGHT_STRING_SYM = 859,
    WHEN_SYM = 860,
    WHERE = 861,
    WHILE_SYM = 862,
    WITH = 863,
    WITH_CUBE_SYM = 864,
    WITH_ROLLUP_SYM = 865,
    WORK_SYM = 866,
    WRAPPER_SYM = 867,
    WRITE_SYM = 868,
    X509_SYM = 869,
    XA_SYM = 870,
    XML_SYM = 871,
    XOR = 872,
    YEAR_MONTH_SYM = 873,
    YEAR_SYM = 874,
    ZEROFILL = 875
  };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYSE_SYM 269
#define ANALYZE_SYM 270
#define AND_AND_SYM 271
#define AND_SYM 272
#define ANY_SYM 273
#define AS 274
#define ASC 275
#define ASCII_SYM 276
#define ASENSITIVE_SYM 277
#define AT_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_FORMAT_SYM 327
#define COLUMN_NAME_SYM 328
#define COMMENT_SYM 329
#define COMMITTED_SYM 330
#define COMMIT_SYM 331
#define COMPACT_SYM 332
#define COMPLETION_SYM 333
#define COMPRESSED_SYM 334
#define CONCURRENT 335
#define CONDITION_SYM 336
#define CONNECTION_SYM 337
#define CONSISTENT_SYM 338
#define CONSTRAINT 339
#define CONSTRAINT_CATALOG_SYM 340
#define CONSTRAINT_NAME_SYM 341
#define CONSTRAINT_SCHEMA_SYM 342
#define CONTAINS_SYM 343
#define CONTEXT_SYM 344
#define CONTINUE_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_SYM 353
#define CURRENT_USER 354
#define CURSOR_SYM 355
#define CURSOR_NAME_SYM 356
#define CURTIME 357
#define DATABASE 358
#define DATABASES 359
#define DATAFILE_SYM 360
#define DATA_SYM 361
#define DATETIME 362
#define DATE_ADD_INTERVAL 363
#define DATE_SUB_INTERVAL 364
#define DATE_SYM 365
#define DAY_HOUR_SYM 366
#define DAY_MICROSECOND_SYM 367
#define DAY_MINUTE_SYM 368
#define DAY_SECOND_SYM 369
#define DAY_SYM 370
#define DEALLOCATE_SYM 371
#define DECIMAL_NUM 372
#define DECIMAL_SYM 373
#define DECLARE_SYM 374
#define DEFAULT 375
#define DEFAULT_AUTH_SYM 376
#define DEFINER_SYM 377
#define DELAYED_SYM 378
#define DELAY_KEY_WRITE_SYM 379
#define DELETE_SYM 380
#define DESC 381
#define DESCRIBE 382
#define DES_KEY_FILE 383
#define DETERMINISTIC_SYM 384
#define DIAGNOSTICS_SYM 385
#define DIRECTORY_SYM 386
#define DISABLE_SYM 387
#define DISCARD 388
#define DISK_SYM 389
#define DISTINCT 390
#define DIV_SYM 391
#define DOUBLE_SYM 392
#define DO_SYM 393
#define DROP 394
#define DUAL_SYM 395
#define DUMPFILE 396
#define DUPLICATE_SYM 397
#define DYNAMIC_SYM 398
#define EACH_SYM 399
#define ELSE 400
#define ELSEIF_SYM 401
#define ENABLE_SYM 402
#define ENCLOSED 403
#define END 404
#define ENDS_SYM 405
#define END_OF_INPUT 406
#define ENGINES_SYM 407
#define ENGINE_SYM 408
#define ENUM 409
#define EQ 410
#define EQUAL_SYM 411
#define ERROR_SYM 412
#define ERRORS 413
#define ESCAPED 414
#define ESCAPE_SYM 415
#define EVENTS_SYM 416
#define EVENT_SYM 417
#define EVERY_SYM 418
#define EXCHANGE_SYM 419
#define EXECUTE_SYM 420
#define EXISTS 421
#define EXIT_SYM 422
#define EXPANSION_SYM 423
#define EXPIRE_SYM 424
#define EXPORT_SYM 425
#define EXTENDED_SYM 426
#define EXTENT_SIZE_SYM 427
#define EXTRACT_SYM 428
#define FALSE_SYM 429
#define FAST_SYM 430
#define FAULTS_SYM 431
#define FETCH_SYM 432
#define FILE_SYM 433
#define FIRST_SYM 434
#define FIXED_SYM 435
#define FLOAT_NUM 436
#define FLOAT_SYM 437
#define FLUSH_SYM 438
#define FORCE_SYM 439
#define FOREIGN 440
#define FOR_SYM 441
#define FORMAT_SYM 442
#define FOUND_SYM 443
#define FROM 444
#define FULL 445
#define FULLTEXT_SYM 446
#define FUNCTION_SYM 447
#define GE 448
#define GENERAL 449
#define GEOMETRYCOLLECTION 450
#define GEOMETRY_SYM 451
#define GET_FORMAT 452
#define GET_SYM 453
#define GLOBAL_SYM 454
#define GRANT 455
#define GRANTS 456
#define GROUP_SYM 457
#define GROUP_CONCAT_SYM 458
#define GT_SYM 459
#define HANDLER_SYM 460
#define HASH_SYM 461
#define HAVING 462
#define HELP_SYM 463
#define HEX_NUM 464
#define HIGH_PRIORITY 465
#define HOST_SYM 466
#define HOSTS_SYM 467
#define HOUR_MICROSECOND_SYM 468
#define HOUR_MINUTE_SYM 469
#define HOUR_SECOND_SYM 470
#define HOUR_SYM 471
#define IDENT 472
#define IDENTIFIED_SYM 473
#define IDENT_QUOTED 474
#define IF 475
#define IGNORE_SYM 476
#define IGNORE_SERVER_IDS_SYM 477
#define IMPORT 478
#define INDEXES 479
#define INDEX_SYM 480
#define INFILE 481
#define INITIAL_SIZE_SYM 482
#define INNER_SYM 483
#define INOUT_SYM 484
#define INSENSITIVE_SYM 485
#define INSERT 486
#define INSERT_METHOD 487
#define INSTALL_SYM 488
#define INTERVAL_SYM 489
#define INTO 490
#define INT_SYM 491
#define INVOKER_SYM 492
#define IN_SYM 493
#define IO_AFTER_GTIDS 494
#define IO_BEFORE_GTIDS 495
#define IO_SYM 496
#define IPC_SYM 497
#define IS 498
#define ISOLATION 499
#define ISSUER_SYM 500
#define ITERATE_SYM 501
#define JOIN_SYM 502
#define KEYS 503
#define KEY_BLOCK_SIZE 504
#define KEY_SYM 505
#define KILL_SYM 506
#define LANGUAGE_SYM 507
#define LAST_SYM 508
#define LE 509
#define LEADING 510
#define LEAVES 511
#define LEAVE_SYM 512
#define LEFT 513
#define LESS_SYM 514
#define LEVEL_SYM 515
#define LEX_HOSTNAME 516
#define LIKE 517
#define LIMIT 518
#define LINEAR_SYM 519
#define LINES 520
#define LINESTRING 521
#define LIST_SYM 522
#define LOAD 523
#define LOCAL_SYM 524
#define LOCATOR_SYM 525
#define LOCKS_SYM 526
#define LOCK_SYM 527
#define LOGFILE_SYM 528
#define LOGS_SYM 529
#define LONGBLOB 530
#define LONGTEXT 531
#define LONG_NUM 532
#define LONG_SYM 533
#define LOOP_SYM 534
#define LOW_PRIORITY 535
#define LT 536
#define MASTER_AUTO_POSITION_SYM 537
#define MASTER_BIND_SYM 538
#define MASTER_CONNECT_RETRY_SYM 539
#define MASTER_DELAY_SYM 540
#define MASTER_HOST_SYM 541
#define MASTER_LOG_FILE_SYM 542
#define MASTER_LOG_POS_SYM 543
#define MASTER_PASSWORD_SYM 544
#define MASTER_PORT_SYM 545
#define MASTER_RETRY_COUNT_SYM 546
#define MASTER_SERVER_ID_SYM 547
#define MASTER_SSL_CAPATH_SYM 548
#define MASTER_SSL_CA_SYM 549
#define MASTER_SSL_CERT_SYM 550
#define MASTER_SSL_CIPHER_SYM 551
#define MASTER_SSL_CRL_SYM 552
#define MASTER_SSL_CRLPATH_SYM 553
#define MASTER_SSL_KEY_SYM 554
#define MASTER_SSL_SYM 555
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 556
#define MASTER_SYM 557
#define MASTER_USER_SYM 558
#define MASTER_HEARTBEAT_PERIOD_SYM 559
#define MATCH 560
#define MAX_CONNECTIONS_PER_HOUR 561
#define MAX_QUERIES_PER_HOUR 562
#define MAX_ROWS 563
#define MAX_SIZE_SYM 564
#define MAX_SYM 565
#define MAX_UPDATES_PER_HOUR 566
#define MAX_USER_CONNECTIONS_SYM 567
#define MAX_VALUE_SYM 568
#define MEDIUMBLOB 569
#define MEDIUMINT 570
#define MEDIUMTEXT 571
#define MEDIUM_SYM 572
#define MEMORY_SYM 573
#define MERGE_SYM 574
#define MESSAGE_TEXT_SYM 575
#define MICROSECOND_SYM 576
#define MIGRATE_SYM 577
#define MINUTE_MICROSECOND_SYM 578
#define MINUTE_SECOND_SYM 579
#define MINUTE_SYM 580
#define MIN_ROWS 581
#define MIN_SYM 582
#define MODE_SYM 583
#define MODIFIES_SYM 584
#define MODIFY_SYM 585
#define MOD_SYM 586
#define MONTH_SYM 587
#define MULTILINESTRING 588
#define MULTIPOINT 589
#define MULTIPOLYGON 590
#define MUTEX_SYM 591
#define MYSQL_ERRNO_SYM 592
#define NAMES_SYM 593
#define NAME_SYM 594
#define NATIONAL_SYM 595
#define NATURAL 596
#define NCHAR_STRING 597
#define NCHAR_SYM 598
#define NDBCLUSTER_SYM 599
#define NE 600
#define NEG 601
#define NEW_SYM 602
#define NEXT_SYM 603
#define NODEGROUP_SYM 604
#define NONE_SYM 605
#define NOT2_SYM 606
#define NOT_SYM 607
#define NOW_SYM 608
#define NO_SYM 609
#define NO_WAIT_SYM 610
#define NO_WRITE_TO_BINLOG 611
#define NULL_SYM 612
#define NUM 613
#define NUMBER_SYM 614
#define NUMERIC_SYM 615
#define NVARCHAR_SYM 616
#define OFFSET_SYM 617
#define OLD_PASSWORD 618
#define ON 619
#define ONE_SYM 620
#define ONLY_SYM 621
#define OPEN_SYM 622
#define OPTIMIZE 623
#define OPTIONS_SYM 624
#define OPTION 625
#define OPTIONALLY 626
#define OR2_SYM 627
#define ORDER_SYM 628
#define OR_OR_SYM 629
#define OR_SYM 630
#define OUTER 631
#define OUTFILE 632
#define OUT_SYM 633
#define OWNER_SYM 634
#define PACK_KEYS_SYM 635
#define PAGE_SYM 636
#define PARAM_MARKER 637
#define PARSER_SYM 638
#define PARTIAL 639
#define PARTITION_SYM 640
#define PARTITIONS_SYM 641
#define PARTITIONING_SYM 642
#define PASSWORD 643
#define PHASE_SYM 644
#define PLUGIN_DIR_SYM 645
#define PLUGIN_SYM 646
#define PLUGINS_SYM 647
#define POINT_SYM 648
#define POLYGON 649
#define PORT_SYM 650
#define POSITION_SYM 651
#define PRECISION 652
#define PREPARE_SYM 653
#define PRESERVE_SYM 654
#define PREV_SYM 655
#define PRIMARY_SYM 656
#define PRIVILEGES 657
#define PROCEDURE_SYM 658
#define PROCESS 659
#define PROCESSLIST_SYM 660
#define PROFILE_SYM 661
#define PROFILES_SYM 662
#define PROXY_SYM 663
#define PURGE 664
#define QUARTER_SYM 665
#define QUERY_SYM 666
#define QUICK 667
#define RANGE_SYM 668
#define READS_SYM 669
#define READ_ONLY_SYM 670
#define READ_SYM 671
#define READ_WRITE_SYM 672
#define REAL 673
#define REBUILD_SYM 674
#define RECOVER_SYM 675
#define REDOFILE_SYM 676
#define REDO_BUFFER_SIZE_SYM 677
#define REDUNDANT_SYM 678
#define REFERENCES 679
#define REGEXP 680
#define RELAY 681
#define RELAYLOG_SYM 682
#define RELAY_LOG_FILE_SYM 683
#define RELAY_LOG_POS_SYM 684
#define RELAY_THREAD 685
#define RELEASE_SYM 686
#define RELOAD 687
#define REMOVE_SYM 688
#define RENAME 689
#define REORGANIZE_SYM 690
#define REPAIR 691
#define REPEATABLE_SYM 692
#define REPEAT_SYM 693
#define REPLACE 694
#define REPLICATION 695
#define REQUIRE_SYM 696
#define RESET_SYM 697
#define RESIGNAL_SYM 698
#define RESOURCES 699
#define RESTORE_SYM 700
#define RESTRICT 701
#define RESUME_SYM 702
#define RETURNED_SQLSTATE_SYM 703
#define RETURNS_SYM 704
#define RETURN_SYM 705
#define REVERSE_SYM 706
#define REVOKE 707
#define RIGHT 708
#define ROLLBACK_SYM 709
#define ROLLUP_SYM 710
#define ROUTINE_SYM 711
#define ROWS_SYM 712
#define ROW_FORMAT_SYM 713
#define ROW_SYM 714
#define ROW_COUNT_SYM 715
#define RTREE_SYM 716
#define SAVEPOINT_SYM 717
#define SCHEDULE_SYM 718
#define SCHEMA_NAME_SYM 719
#define SECOND_MICROSECOND_SYM 720
#define SECOND_SYM 721
#define SECURITY_SYM 722
#define SELECT_SYM 723
#define SENSITIVE_SYM 724
#define SEPARATOR_SYM 725
#define SERIALIZABLE_SYM 726
#define SERIAL_SYM 727
#define SESSION_SYM 728
#define SERVER_SYM 729
#define SERVER_OPTIONS 730
#define SET 731
#define SET_VAR 732
#define SHARE_SYM 733
#define SHIFT_LEFT 734
#define SHIFT_RIGHT 735
#define SHOW 736
#define SHUTDOWN 737
#define SIGNAL_SYM 738
#define SIGNED_SYM 739
#define SIMPLE_SYM 740
#define SLAVE 741
#define SLOW 742
#define SMALLINT 743
#define SNAPSHOT_SYM 744
#define SOCKET_SYM 745
#define SONAME_SYM 746
#define SOUNDS_SYM 747
#define SOURCE_SYM 748
#define SPATIAL_SYM 749
#define SPECIFIC_SYM 750
#define SQLEXCEPTION_SYM 751
#define SQLSTATE_SYM 752
#define SQLWARNING_SYM 753
#define SQL_AFTER_GTIDS 754
#define SQL_AFTER_MTS_GAPS 755
#define SQL_BEFORE_GTIDS 756
#define SQL_BIG_RESULT 757
#define SQL_BUFFER_RESULT 758
#define SQL_CACHE_SYM 759
#define SQL_CALC_FOUND_ROWS 760
#define SQL_NO_CACHE_SYM 761
#define SQL_SMALL_RESULT 762
#define SQL_SYM 763
#define SQL_THREAD 764
#define SSL_SYM 765
#define STARTING 766
#define STARTS_SYM 767
#define START_SYM 768
#define STATS_AUTO_RECALC_SYM 769
#define STATS_PERSISTENT_SYM 770
#define STATS_SAMPLE_PAGES_SYM 771
#define STATUS_SYM 772
#define STDDEV_SAMP_SYM 773
#define STD_SYM 774
#define STOP_SYM 775
#define STORAGE_SYM 776
#define STRAIGHT_JOIN 777
#define STRING_SYM 778
#define SUBCLASS_ORIGIN_SYM 779
#define SUBDATE_SYM 780
#define SUBJECT_SYM 781
#define SUBPARTITIONS_SYM 782
#define SUBPARTITION_SYM 783
#define SUBSTRING 784
#define SUM_SYM 785
#define SUPER_SYM 786
#define SUSPEND_SYM 787
#define SWAPS_SYM 788
#define SWITCHES_SYM 789
#define SYSDATE 790
#define TABLES 791
#define TABLESPACE 792
#define TABLE_REF_PRIORITY 793
#define TABLE_SYM 794
#define TABLE_CHECKSUM_SYM 795
#define TABLE_NAME_SYM 796
#define TEMPORARY 797
#define TEMPTABLE_SYM 798
#define TERMINATED 799
#define TEXT_STRING 800
#define TEXT_SYM 801
#define THAN_SYM 802
#define THEN_SYM 803
#define TIMESTAMP 804
#define TIMESTAMP_ADD 805
#define TIMESTAMP_DIFF 806
#define TIME_SYM 807
#define TINYBLOB 808
#define TINYINT 809
#define TINYTEXT 810
#define TO_SYM 811
#define TRAILING 812
#define TRANSACTION_SYM 813
#define TRIGGERS_SYM 814
#define TRIGGER_SYM 815
#define TRIM 816
#define TRUE_SYM 817
#define TRUNCATE_SYM 818
#define TYPES_SYM 819
#define TYPE_SYM 820
#define UDF_RETURNS_SYM 821
#define ULONGLONG_NUM 822
#define UNCOMMITTED_SYM 823
#define UNDEFINED_SYM 824
#define UNDERSCORE_CHARSET 825
#define UNDOFILE_SYM 826
#define UNDO_BUFFER_SIZE_SYM 827
#define UNDO_SYM 828
#define UNICODE_SYM 829
#define UNINSTALL_SYM 830
#define UNION_SYM 831
#define UNIQUE_SYM 832
#define UNKNOWN_SYM 833
#define UNLOCK_SYM 834
#define UNSIGNED 835
#define UNTIL_SYM 836
#define UPDATE_SYM 837
#define UPGRADE_SYM 838
#define USAGE 839
#define USER 840
#define USE_FRM 841
#define USE_SYM 842
#define USING 843
#define UTC_DATE_SYM 844
#define UTC_TIMESTAMP_SYM 845
#define UTC_TIME_SYM 846
#define VALUES 847
#define VALUE_SYM 848
#define VARBINARY 849
#define VARCHAR 850
#define VARIABLES 851
#define VARIANCE_SYM 852
#define VARYING 853
#define VAR_SAMP_SYM 854
#define VIEW_SYM 855
#define WAIT_SYM 856
#define WARNINGS 857
#define WEEK_SYM 858
#define WEIGHT_STRING_SYM 859
#define WHEN_SYM 860
#define WHERE 861
#define WHILE_SYM 862
#define WITH 863
#define WITH_CUBE_SYM 864
#define WITH_ROLLUP_SYM 865
#define WORK_SYM 866
#define WRAPPER_SYM 867
#define WRITE_SYM 868
#define X509_SYM 869
#define XA_SYM 870
#define XML_SYM 871
#define XOR 872
#define YEAR_MONTH_SYM 873
#define YEAR_SYM 874
#define ZEROFILL 875

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 968 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/mysql-5.6.44-release-export-14508947_gpl/sql/sql_yacc.yy" /* yacc.c:355  */

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_ha_read_modes ha_read_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  const CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  bool is_not_empty;

#line 2355 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/dist_GPL/sql/sql_yacc.cc" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int MYSQLparse (class THD *YYTHD);

#endif /* !YY_MYSQL_EXPORT_HOME2_PB2_BUILD_SB_2_33225745_1552635831_74_DIST_GPL_SQL_SQL_YACC_H_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1026 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/mysql-5.6.44-release-export-14508947_gpl/sql/sql_yacc.yy" /* yacc.c:358  */

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);

#line 2374 "/export/home2/pb2/build/sb_2-33225745-1552635831.74/dist_GPL/sql/sql_yacc.cc" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  597
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   55554

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  640
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  953
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2671
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4531

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   875

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   633,     2,     2,     2,   627,   622,     2,
     630,   631,   625,   624,   632,   623,   638,   626,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   639,   636,
       2,     2,     2,     2,   637,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   628,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   634,   621,   635,   629,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1969,  1969,  1982,  1981,  2006,  2013,  2015,  2019,  2020,
    2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2076,  2080,  2090,  2091,  2095,  2115,  2122,  2133,  2132,
    2143,  2145,  2149,  2150,  2154,  2167,  2166,  2186,  2185,  2203,
    2204,  2208,  2212,  2216,  2220,  2225,  2229,  2233,  2238,  2251,
    2256,  2260,  2264,  2268,  2272,  2276,  2281,  2285,  2290,  2321,
    2326,  2333,  2336,  2338,  2339,  2343,  2357,  2361,  2377,  2381,
    2394,  2393,  2439,  2444,  2438,  2451,  2456,  2449,  2463,  2468,
    2461,  2474,  2473,  2486,  2485,  2493,  2497,  2501,  2505,  2512,
    2530,  2531,  2535,  2539,  2543,  2547,  2551,  2556,  2560,  2568,
    2567,  2599,  2598,  2605,  2612,  2613,  2619,  2625,  2635,  2641,
    2647,  2649,  2656,  2657,  2661,  2667,  2676,  2677,  2685,  2685,
    2740,  2741,  2742,  2743,  2744,  2745,  2746,  2747,  2748,  2749,
    2750,  2751,  2752,  2757,  2771,  2785,  2804,  2805,  2809,  2810,
    2815,  2817,  2819,  2821,  2823,  2825,  2827,  2833,  2834,  2835,
    2839,  2843,  2851,  2850,  2863,  2865,  2868,  2870,  2874,  2878,
    2885,  2887,  2891,  2892,  2897,  2916,  2946,  2948,  2952,  2953,
    2957,  2986,  2987,  2988,  2989,  2993,  2994,  2998,  2999,  3004,
    3007,  3034,  3033,  3117,  3134,  3133,  3208,  3207,  3280,  3281,
    3286,  3288,  3293,  3316,  3327,  3331,  3353,  3354,  3358,  3362,
    3375,  3381,  3387,  3396,  3411,  3437,  3443,  3444,  3450,  3453,
    3457,  3465,  3485,  3487,  3505,  3511,  3513,  3515,  3517,  3519,
    3521,  3523,  3525,  3527,  3529,  3531,  3533,  3538,  3554,  3570,
    3571,  3576,  3582,  3591,  3597,  3606,  3614,  3643,  3652,  3654,
    3663,  3668,  3674,  3683,  3691,  3693,  3695,  3697,  3699,  3701,
    3703,  3705,  3707,  3709,  3711,  3713,  3715,  3720,  3740,  3764,
    3766,  3765,  3772,  3773,  3774,  3775,  3776,  3777,  3778,  3779,
    3780,  3781,  3782,  3783,  3784,  3789,  3788,  3799,  3799,  3856,
    3855,  3912,  3912,  3934,  3993,  4043,  4068,  4067,  4093,  4116,
    4118,  4119,  4123,  4141,  4162,  4171,  4207,  4162,  4236,  4238,
    4239,  4243,  4244,  4249,  4260,  4248,  4311,  4310,  4324,  4325,
    4329,  4330,  4335,  4344,  4334,  4393,  4402,  4392,  4446,  4459,
    4464,  4463,  4501,  4502,  4507,  4506,  4540,  4540,  4559,  4558,
    4608,  4625,  4634,  4624,  4688,  4697,  4687,  4737,  4739,  4744,
    4746,  4748,  4765,  4770,  4776,  4783,  4784,  4792,  4798,  4807,
    4813,  4819,  4820,  4824,  4824,  4829,  4830,  4831,  4835,  4836,
    4837,  4840,  4842,  4846,  4847,  4848,  4852,  4853,  4854,  4855,
    4856,  4857,  4858,  4859,  4862,  4864,  4868,  4869,  4870,  4874,
    4875,  4876,  4877,  4878,  4881,  4883,  4887,  4888,  4889,  4893,
    4894,  4895,  4896,  4897,  4898,  4899,  4902,  4904,  4908,  4909,
    4910,  4914,  4915,  4916,  4921,  4929,  4937,  4945,  4957,  4969,
    4974,  4979,  4987,  4995,  5003,  5011,  5019,  5027,  5035,  5048,
    5061,  5075,  5080,  5093,  5094,  5145,  5146,  5149,  5164,  5182,
    5187,  5185,  5192,  5194,  5193,  5197,  5196,  5202,  5239,  5240,
    5245,  5244,  5263,  5282,  5281,  5298,  5302,  5310,  5309,  5312,
    5314,  5316,  5318,  5323,  5324,  5330,  5331,  5348,  5349,  5353,
    5354,  5358,  5377,  5387,  5398,  5407,  5408,  5424,  5426,  5425,
    5430,  5428,  5439,  5440,  5444,  5462,  5478,  5479,  5495,  5510,
    5532,  5533,  5538,  5537,  5561,  5577,  5596,  5595,  5610,  5609,
    5626,  5648,  5652,  5681,  5693,  5694,  5699,  5710,  5698,  5735,
    5736,  5740,  5753,  5774,  5787,  5813,  5814,  5819,  5818,  5855,
    5868,  5869,  5873,  5874,  5878,  5880,  5886,  5888,  5890,  5892,
    5894,  5896,  5906,  5921,  5905,  5935,  5936,  5940,  5941,  5945,
    5946,  5950,  5951,  5955,  5956,  5960,  5961,  5965,  5969,  5970,
    5973,  5975,  5979,  5980,  5984,  5985,  5986,  5990,  5995,  6000,
    6005,  6010,  6015,  6020,  6025,  6040,  6046,  6061,  6066,  6081,
    6087,  6105,  6110,  6115,  6120,  6125,  6131,  6130,  6156,  6157,
    6158,  6163,  6168,  6173,  6175,  6177,  6179,  6185,  6193,  6211,
    6228,  6254,  6272,  6273,  6274,  6275,  6276,  6277,  6281,  6282,
    6283,  6287,  6288,  6292,  6293,  6294,  6295,  6300,  6307,  6308,
    6312,  6313,  6317,  6318,  6325,  6330,  6336,  6342,  6348,  6367,
    6373,  6375,  6379,  6383,  6384,  6388,  6393,  6392,  6415,  6416,
    6417,  6418,  6423,  6427,  6432,  6437,  6441,  6446,  6451,  6457,
    6462,  6468,  6472,  6477,  6482,  6500,  6502,  6504,  6520,  6522,
    6527,  6532,  6544,  6549,  6554,  6559,  6561,  6563,  6565,  6567,
    6569,  6571,  6573,  6576,  6575,  6580,  6579,  6583,  6585,  6594,
    6595,  6596,  6602,  6603,  6604,  6605,  6606,  6610,  6614,  6615,
    6619,  6620,  6624,  6625,  6626,  6627,  6628,  6632,  6633,  6634,
    6635,  6636,  6640,  6645,  6647,  6653,  6654,  6656,  6661,  6671,
    6672,  6676,  6677,  6678,  6686,  6687,  6691,  6692,  6696,  6697,
    6698,  6702,  6703,  6704,  6705,  6708,  6709,  6713,  6714,  6718,
    6719,  6723,  6724,  6728,  6729,  6730,  6731,  6732,  6733,  6739,
    6745,  6751,  6757,  6758,  6771,  6777,  6783,  6789,  6794,  6799,
    6808,  6829,  6837,  6838,  6843,  6844,  6848,  6856,  6860,  6861,
    6865,  6866,  6870,  6879,  6883,  6884,  6888,  6896,  6897,  6901,
    6902,  6906,  6907,  6912,  6913,  6917,  6924,  6933,  6938,  6946,
    6947,  6948,  6949,  6950,  6951,  6956,  6964,  6965,  6970,  6969,
    6982,  6983,  6987,  6990,  6991,  6992,  6993,  6997,  7005,  7012,
    7013,  7017,  7027,  7028,  7032,  7033,  7036,  7038,  7042,  7054,
    7055,  7059,  7066,  7079,  7080,  7082,  7084,  7090,  7095,  7101,
    7107,  7114,  7124,  7125,  7126,  7127,  7128,  7132,  7136,  7137,
    7141,  7142,  7146,  7147,  7151,  7152,  7153,  7157,  7158,  7162,
    7166,  7179,  7191,  7192,  7196,  7197,  7201,  7202,  7206,  7207,
    7211,  7212,  7216,  7217,  7221,  7222,  7226,  7227,  7231,  7233,
    7237,  7238,  7242,  7246,  7247,  7260,  7261,  7262,  7266,  7267,
    7271,  7277,  7291,  7292,  7296,  7297,  7301,  7302,  7310,  7309,
    7355,  7354,  7368,  7380,  7379,  7398,  7397,  7416,  7415,  7434,
    7428,  7448,  7447,  7480,  7485,  7490,  7495,  7500,  7507,  7514,
    7519,  7527,  7528,  7529,  7530,  7534,  7535,  7547,  7548,  7552,
    7553,  7556,  7558,  7566,  7574,  7576,  7578,  7579,  7587,  7588,
    7592,  7601,  7599,  7613,  7627,  7626,  7640,  7638,  7652,  7659,
    7670,  7671,  7699,  7706,  7710,  7715,  7714,  7730,  7732,  7737,
    7745,  7744,  7760,  7764,  7763,  7775,  7776,  7780,  7795,  7796,
    7800,  7809,  7813,  7818,  7824,  7823,  7834,  7843,  7833,  7858,
    7867,  7876,  7885,  7894,  7900,  7906,  7915,  7924,  7952,  7973,
    7983,  7987,  7992,  7993,  7996,  7998,  7999,  8000,  8001,  8004,
    8009,  8020,  8025,  8036,  8037,  8041,  8042,  8046,  8047,  8048,
    8052,  8053,  8058,  8066,  8067,  8068,  8069,  8074,  8073,  8102,
    8112,  8129,  8132,  8139,  8143,  8150,  8154,  8158,  8165,  8170,
    8173,  8180,  8183,  8190,  8193,  8200,  8203,  8211,  8214,  8221,
    8225,  8232,  8236,  8243,  8244,  8269,  8270,  8271,  8276,  8281,
    8289,  8288,  8300,  8301,  8302,  8307,  8306,  8328,  8329,  8333,
    8334,  8338,  8339,  8340,  8345,  8344,  8366,  8375,  8374,  8401,
    8402,  8406,  8407,  8411,  8412,  8413,  8414,  8415,  8416,  8421,
    8420,  8442,  8443,  8444,  8449,  8448,  8454,  8461,  8466,  8474,
    8475,  8479,  8493,  8492,  8505,  8506,  8510,  8511,  8515,  8525,
    8535,  8536,  8541,  8540,  8551,  8552,  8556,  8557,  8561,  8571,
    8582,  8581,  8589,  8589,  8600,  8601,  8606,  8607,  8616,  8625,
    8626,  8630,  8635,  8640,  8645,  8650,  8649,  8669,  8677,  8669,
    8684,  8685,  8686,  8687,  8688,  8692,  8699,  8706,  8708,  8719,
    8720,  8724,  8725,  8753,  8783,  8785,  8794,  8807,  8808,  8809,
    8824,  8831,  8856,  8862,  8868,  8869,  8870,  8871,  8872,  8876,
    8877,  8882,  8933,  8940,  8983,  8989,  8995,  9001,  9007,  9013,
    9019,  9025,  9029,  9035,  9041,  9047,  9053,  9059,  9063,  9069,
    9079,  9085,  9093,  9099,  9109,  9115,  9124,  9134,  9140,  9150,
    9156,  9165,  9169,  9175,  9181,  9187,  9193,  9199,  9205,  9211,
    9217,  9223,  9229,  9235,  9241,  9247,  9253,  9257,  9258,  9262,
    9263,  9267,  9268,  9272,  9273,  9277,  9278,  9279,  9280,  9281,
    9282,  9286,  9287,  9291,  9292,  9293,  9294,  9295,  9296,  9308,
    9309,  9310,  9311,  9312,  9318,  9322,  9328,  9334,  9340,  9346,
    9348,  9355,  9362,  9368,  9409,  9418,  9425,  9433,  9439,  9446,
    9452,  9466,  9473,  9489,  9495,  9501,  9509,  9515,  9521,  9527,
    9533,  9548,  9560,  9566,  9572,  9578,  9584,  9590,  9596,  9602,
    9608,  9614,  9620,  9626,  9632,  9638,  9644,  9650,  9656,  9664,
    9685,  9692,  9698,  9705,  9712,  9719,  9726,  9732,  9738,  9743,
    9749,  9756,  9762,  9768,  9774,  9780,  9786,  9804,  9810,  9816,
    9823,  9830,  9845,  9851,  9857,  9863,  9869,  9876,  9882,  9888,
    9894,  9900,  9906,  9914,  9927,  9933,  9939,  9945,  9951,  9959,
    9965,  9977,  9983,  9989,  9997, 10007, 10013, 10029, 10035, 10042,
   10049, 10056, 10063, 10070, 10074, 10094, 10093, 10166, 10206, 10208,
   10213, 10214, 10218, 10219, 10223, 10224, 10228, 10235, 10243, 10269,
   10275, 10281, 10287, 10293, 10299, 10308, 10315, 10317, 10314, 10324,
   10335, 10341, 10347, 10353, 10359, 10365, 10371, 10377, 10383, 10390,
   10389, 10409, 10408, 10423, 10434, 10442, 10458, 10459, 10464, 10469,
   10472, 10475, 10474, 10491, 10493, 10499, 10498, 10515, 10517, 10519,
   10521, 10523, 10525, 10527, 10529, 10531, 10533, 10535, 10540, 10541,
   10545, 10552, 10560, 10561, 10565, 10572, 10580, 10581, 10585, 10586,
   10590, 10598, 10609, 10610, 10619, 10630, 10631, 10637, 10638, 10658,
   10660, 10664, 10662, 10679, 10677, 10695, 10693, 10700, 10709, 10707,
   10725, 10724, 10734, 10745, 10743, 10762, 10761, 10772, 10783, 10784,
   10785, 10793, 10794, 10798, 10813, 10813, 10828, 10868, 10941, 10952,
   10957, 10949, 10976, 10996, 11004, 10996, 11013, 11012, 11035, 11052,
   11035, 11059, 11063, 11089, 11090, 11095, 11098, 11099, 11100, 11104,
   11105, 11110, 11109, 11115, 11114, 11122, 11123, 11126, 11128, 11128,
   11132, 11132, 11137, 11138, 11142, 11144, 11149, 11150, 11154, 11165,
   11178, 11179, 11180, 11181, 11182, 11183, 11184, 11185, 11186, 11187,
   11188, 11189, 11193, 11194, 11195, 11196, 11197, 11198, 11199, 11200,
   11201, 11205, 11206, 11207, 11208, 11211, 11213, 11214, 11218, 11219,
   11227, 11229, 11233, 11235, 11234, 11248, 11251, 11250, 11265, 11271,
   11286, 11288, 11292, 11294, 11299, 11300, 11320, 11351, 11355, 11356,
   11360, 11373, 11375, 11380, 11379, 11414, 11416, 11421, 11422, 11423,
   11428, 11434, 11438, 11439, 11443, 11450, 11457, 11464, 11474, 11501,
   11505, 11511, 11517, 11527, 11531, 11541, 11542, 11543, 11544, 11545,
   11546, 11550, 11551, 11552, 11553, 11554, 11558, 11559, 11560, 11561,
   11562, 11566, 11567, 11568, 11569, 11573, 11578, 11579, 11582, 11585,
   11584, 11618, 11619, 11623, 11631, 11644, 11644, 11654, 11655, 11659,
   11678, 11718, 11717, 11730, 11738, 11729, 11740, 11752, 11764, 11763,
   11781, 11780, 11791, 11792, 11791, 11808, 11815, 11836, 11857, 11869,
   11874, 11873, 11883, 11889, 11896, 11901, 11906, 11916, 11917, 11921,
   11932, 11945, 11946, 11950, 11961, 11962, 11966, 11967, 11970, 11972,
   11975, 11976, 11977, 11981, 11982, 11990, 11998, 11989, 12008, 12015,
   12007, 12025, 12037, 12038, 12051, 12055, 12056, 12072, 12073, 12077,
   12086, 12087, 12088, 12090, 12089, 12100, 12101, 12105, 12106, 12108,
   12107, 12111, 12110, 12116, 12117, 12121, 12122, 12126, 12136, 12137,
   12141, 12142, 12147, 12146, 12160, 12161, 12165, 12170, 12178, 12179,
   12187, 12189, 12189, 12197, 12205, 12196, 12227, 12228, 12232, 12240,
   12241, 12245, 12255, 12256, 12263, 12262, 12278, 12277, 12291, 12290,
   12302, 12301, 12315, 12316, 12320, 12333, 12349, 12350, 12354, 12355,
   12359, 12360, 12361, 12366, 12365, 12387, 12389, 12392, 12394, 12397,
   12398, 12401, 12405, 12409, 12413, 12417, 12421, 12425, 12429, 12433,
   12441, 12444, 12454, 12453, 12468, 12475, 12483, 12491, 12499, 12507,
   12515, 12522, 12524, 12526, 12535, 12539, 12544, 12543, 12549, 12548,
   12553, 12562, 12569, 12574, 12576, 12578, 12580, 12582, 12590, 12601,
   12609, 12611, 12619, 12626, 12633, 12643, 12650, 12656, 12665, 12673,
   12677, 12681, 12688, 12695, 12701, 12708, 12715, 12720, 12725, 12733,
   12735, 12737, 12742, 12743, 12746, 12748, 12752, 12753, 12757, 12758,
   12762, 12763, 12767, 12768, 12772, 12773, 12776, 12778, 12785, 12796,
   12795, 12811, 12810, 12817, 12818, 12819, 12820, 12821, 12825, 12826,
   12831, 12835, 12841, 12847, 12869, 12870, 12871, 12886, 12885, 12898,
   12907, 12897, 12909, 12913, 12914, 12926, 12925, 12947, 12948, 12953,
   12955, 12957, 12959, 12961, 12963, 12965, 12967, 12969, 12971, 12973,
   12975, 12977, 12982, 12983, 12988, 12987, 12997, 12998, 13002, 13002,
   13004, 13005, 13009, 13010, 13015, 13014, 13025, 13029, 13033, 13045,
   13055, 13056, 13057, 13063, 13075, 13087, 13097, 13107, 13074, 13115,
   13116, 13120, 13121, 13125, 13126, 13138, 13142, 13143, 13144, 13147,
   13149, 13153, 13154, 13158, 13163, 13170, 13175, 13182, 13184, 13188,
   13189, 13193, 13198, 13206, 13207, 13210, 13212, 13220, 13222, 13226,
   13227, 13228, 13232, 13234, 13239, 13240, 13249, 13250, 13254, 13255,
   13259, 13279, 13303, 13315, 13326, 13345, 13353, 13365, 13380, 13401,
   13402, 13403, 13412, 13413, 13414, 13415, 13430, 13436, 13442, 13448,
   13454, 13485, 13518, 13528, 13538, 13544, 13553, 13565, 13571, 13577,
   13593, 13594, 13598, 13607, 13623, 13627, 13678, 13682, 13700, 13704,
   13784, 13809, 13840, 13841, 13857, 13867, 13871, 13877, 13883, 13893,
   13899, 13908, 13918, 13919, 13949, 13962, 13978, 13994, 14011, 14012,
   14023, 14024, 14035, 14036, 14037, 14041, 14068, 14101, 14116, 14117,
   14118, 14119, 14120, 14121, 14122, 14123, 14124, 14125, 14126, 14127,
   14128, 14129, 14130, 14131, 14132, 14133, 14134, 14135, 14136, 14137,
   14138, 14139, 14140, 14141, 14142, 14143, 14144, 14145, 14146, 14147,
   14148, 14149, 14150, 14151, 14152, 14153, 14154, 14155, 14156, 14157,
   14158, 14159, 14160, 14161, 14162, 14163, 14164, 14165, 14175, 14176,
   14177, 14178, 14179, 14180, 14181, 14182, 14183, 14184, 14185, 14186,
   14187, 14188, 14189, 14190, 14191, 14192, 14193, 14194, 14195, 14196,
   14197, 14198, 14199, 14200, 14201, 14202, 14203, 14204, 14205, 14206,
   14207, 14208, 14209, 14210, 14211, 14212, 14213, 14214, 14215, 14216,
   14217, 14218, 14219, 14224, 14225, 14226, 14227, 14228, 14229, 14230,
   14231, 14232, 14233, 14234, 14235, 14236, 14237, 14238, 14239, 14240,
   14241, 14242, 14243, 14244, 14245, 14246, 14247, 14248, 14249, 14250,
   14251, 14252, 14253, 14254, 14255, 14256, 14257, 14258, 14259, 14260,
   14261, 14262, 14263, 14264, 14265, 14266, 14267, 14268, 14269, 14270,
   14271, 14272, 14273, 14274, 14275, 14276, 14277, 14278, 14279, 14280,
   14281, 14282, 14283, 14284, 14285, 14286, 14287, 14288, 14289, 14290,
   14291, 14292, 14293, 14294, 14295, 14296, 14297, 14298, 14299, 14300,
   14301, 14302, 14303, 14304, 14305, 14306, 14307, 14308, 14309, 14310,
   14311, 14312, 14313, 14314, 14315, 14316, 14317, 14318, 14319, 14320,
   14321, 14322, 14323, 14324, 14325, 14326, 14327, 14328, 14329, 14330,
   14331, 14332, 14333, 14334, 14335, 14336, 14337, 14338, 14339, 14340,
   14341, 14342, 14343, 14344, 14345, 14346, 14347, 14348, 14349, 14350,
   14351, 14352, 14353, 14354, 14355, 14356, 14357, 14358, 14359, 14360,
   14361, 14362, 14363, 14364, 14365, 14366, 14367, 14368, 14369, 14370,
   14371, 14372, 14373, 14374, 14375, 14376, 14377, 14378, 14379, 14380,
   14381, 14382, 14383, 14384, 14385, 14386, 14387, 14388, 14389, 14390,
   14391, 14392, 14393, 14394, 14395, 14396, 14397, 14398, 14399, 14400,
   14401, 14402, 14403, 14404, 14405, 14406, 14407, 14408, 14409, 14410,
   14411, 14412, 14413, 14414, 14415, 14416, 14417, 14418, 14419, 14420,
   14421, 14422, 14423, 14424, 14425, 14426, 14427, 14428, 14429, 14430,
   14431, 14432, 14433, 14434, 14435, 14436, 14437, 14438, 14439, 14440,
   14441, 14442, 14443, 14444, 14445, 14446, 14447, 14448, 14449, 14450,
   14451, 14452, 14453, 14454, 14455, 14456, 14457, 14458, 14459, 14460,
   14461, 14462, 14463, 14464, 14465, 14466, 14467, 14468, 14469, 14470,
   14471, 14472, 14473, 14474, 14475, 14476, 14477, 14478, 14479, 14491,
   14490, 14510, 14509, 14516, 14515, 14525, 14524, 14535, 14534, 14540,
   14548, 14550, 14555, 14555, 14564, 14563, 14577, 14576, 14581, 14585,
   14586, 14587, 14591, 14592, 14593, 14594, 14598, 14599, 14600, 14601,
   14606, 14632, 14631, 14731, 14743, 14742, 14763, 14779, 14792, 14814,
   14849, 14891, 14919, 14965, 14979, 14980, 14981, 14982, 14986, 15004,
   15022, 15023, 15027, 15028, 15029, 15030, 15034, 15035, 15053, 15067,
   15068, 15069, 15075, 15081, 15093, 15092, 15108, 15109, 15113, 15114,
   15118, 15131, 15132, 15133, 15138, 15143, 15142, 15162, 15178, 15195,
   15194, 15233, 15234, 15238, 15239, 15243, 15244, 15245, 15246, 15248,
   15247, 15261, 15262, 15263, 15264, 15265, 15271, 15271, 15276, 15281,
   15291, 15301, 15305, 15314, 15314, 15319, 15325, 15336, 15347, 15355,
   15357, 15361, 15368, 15375, 15377, 15381, 15382, 15387, 15386, 15390,
   15389, 15393, 15392, 15396, 15395, 15398, 15399, 15400, 15401, 15402,
   15403, 15404, 15405, 15406, 15407, 15408, 15409, 15410, 15411, 15412,
   15413, 15414, 15415, 15416, 15417, 15418, 15419, 15420, 15421, 15422,
   15423, 15427, 15428, 15432, 15433, 15437, 15447, 15457, 15470, 15485,
   15498, 15511, 15523, 15528, 15536, 15541, 15549, 15567, 15587, 15599,
   15612, 15621, 15625, 15629, 15630, 15634, 15661, 15663, 15667, 15671,
   15675, 15682, 15683, 15687, 15688, 15692, 15693, 15697, 15698, 15704,
   15710, 15716, 15726, 15725, 15735, 15736, 15741, 15742, 15743, 15748,
   15749, 15750, 15754, 15755, 15759, 15771, 15780, 15790, 15799, 15813,
   15814, 15819, 15818, 15834, 15835, 15836, 15840, 15841, 15845, 15845,
   15869, 15870, 15874, 15875, 15876, 15880, 15884, 15891, 15894, 15892,
   15908, 15915, 15936, 15962, 15964, 15968, 15969, 15973, 15974, 15982,
   15983, 15984, 15985, 15991, 15997, 16007, 16009, 16011, 16016, 16017,
   16018, 16019, 16020, 16024, 16025, 16026, 16027, 16028, 16029, 16039,
   16040, 16045, 16058, 16071, 16073, 16075, 16080, 16085, 16087, 16089,
   16095, 16096, 16098, 16104, 16103, 16121, 16122, 16126, 16131, 16139,
   16139, 16165, 16164, 16181, 16185, 16190, 16195, 16194, 16206, 16207,
   16209, 16211, 16229, 16235, 16240, 16222, 16303, 16321, 16346, 16378,
   16383, 16391, 16414, 16342, 16480, 16500, 16513, 16523, 16479, 16544,
   16548, 16552, 16556, 16560, 16564, 16571, 16578, 16585, 16595, 16596,
   16600, 16601, 16602, 16606, 16607, 16612, 16614, 16613, 16619, 16620,
   16624, 16634
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYSE_SYM", "ANALYZE_SYM",
  "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASCII_SYM",
  "ASENSITIVE_SYM", "AT_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC",
  "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM",
  "BETWEEN_SYM", "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND",
  "BIT_OR", "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM",
  "BOOL_SYM", "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM",
  "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET",
  "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM",
  "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COLUMN_FORMAT_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFAULT_AUTH_SYM",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPIRE_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM",
  "FORMAT_SYM", "FOUND_SYM", "FROM", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION", "GEOMETRY_SYM",
  "GET_FORMAT", "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING",
  "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM",
  "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM",
  "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM",
  "INSERT", "INSERT_METHOD", "INSTALL_SYM", "INTERVAL_SYM", "INTO",
  "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS",
  "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM",
  "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM",
  "LANGUAGE_SYM", "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM",
  "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_AUTO_POSITION_SYM", "MASTER_BIND_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_DELAY_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_RETRY_COUNT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH", "MAX_CONNECTIONS_PER_HOUR",
  "MAX_QUERIES_PER_HOUR", "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM",
  "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "OPEN_SYM",
  "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARAM_MARKER", "PARSER_SYM",
  "PARTIAL", "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM",
  "PASSWORD", "PHASE_SYM", "PLUGIN_DIR_SYM", "PLUGIN_SYM", "PLUGINS_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNED_SQLSTATE_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_AFTER_GTIDS", "SQL_AFTER_MTS_GAPS",
  "SQL_BEFORE_GTIDS", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM",
  "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR",
  "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'",
  "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'",
  "'}'", "';'", "'@'", "'.'", "':'", "$accept", "query", "$@1",
  "opt_end_of_input", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "$@2",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "$@3",
  "change", "$@4", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "master_file_def", "create", "$@5", "$@6", "$@7",
  "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "$@20", "sp_handler_type",
  "sp_hcond_list", "sp_hcond_element", "sp_cond", "sqlstate", "opt_value",
  "sp_hcond", "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "get_diagnostics", "which_area",
  "diagnostics_information", "statement_information",
  "statement_information_item", "simple_target_specification",
  "statement_information_item_name", "condition_number",
  "condition_information", "condition_information_item",
  "condition_information_item_name", "sp_decl_idents", "sp_opt_default",
  "$@21", "sp_proc_stmt", "sp_proc_stmt_if", "$@22",
  "sp_proc_stmt_statement", "$@23", "sp_proc_stmt_return", "$@24",
  "sp_proc_stmt_unlabeled", "$@25", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@26", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@27", "$@28", "$@29", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@30", "$@31", "searched_case_stmt", "$@32",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@33", "$@34", "searched_when_clause", "$@35",
  "$@36", "else_clause_opt", "sp_labeled_control", "$@37", "sp_opt_label",
  "sp_labeled_block", "$@38", "sp_unlabeled_block", "$@39",
  "sp_block_content", "$@40", "sp_unlabeled_control", "$@41", "$@42",
  "$@43", "$@44", "trg_action_time", "trg_event",
  "change_tablespace_access", "change_tablespace_info", "tablespace_info",
  "opt_logfile_group_name", "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@45", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "ts_wait", "size_number", "create2", "create2a", "$@46",
  "create3", "$@47", "$@48", "opt_create_partitioning", "opt_partitioning",
  "partitioning", "$@49", "have_partitioning", "partition_entry", "$@50",
  "partition", "part_type_def", "$@51", "opt_linear", "opt_key_algo",
  "part_field_list", "part_field_item_list", "part_field_item",
  "part_column_list", "part_func", "sub_part_func", "opt_num_parts",
  "opt_sub_part", "$@52", "$@53", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@54", "part_name",
  "opt_part_values", "$@55", "$@56", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@57", "$@58",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@59", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@60", "$@61", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@62", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@63", "type", "$@64", "$@65",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "type_datetime_precision",
  "func_datetime_precision", "field_options", "field_opt_list",
  "field_option", "field_length", "opt_field_length", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@66", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@67", "$@68", "$@69", "$@70", "$@71", "$@72",
  "$@73", "alter_user_list", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "$@74", "$@75", "$@76", "remove_partitioning",
  "all_or_alt_part_name_list", "add_partition_rule", "$@77",
  "add_part_extra", "reorg_partition_rule", "$@78", "reorg_parts_rule",
  "$@79", "alt_part_name_list", "alt_part_name_item", "alter_list",
  "add_column", "alter_list_item", "$@80", "$@81", "$@82",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@83", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_connection_opts",
  "slave_user_name_opt", "slave_user_pass_opt", "slave_plugin_auth_opt",
  "slave_plugin_dir_opt", "opt_slave_thread_option_list",
  "slave_thread_option_list", "slave_thread_option", "slave_until",
  "slave_until_opts", "checksum", "$@84", "opt_checksum_type", "repair",
  "$@85", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@86", "binlog_base64_event", "check", "$@87",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@88", "opt_no_write_to_binlog", "rename", "$@89", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@90",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@91",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@92", "cache_keys_spec", "$@93",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@94",
  "select_part2", "$@95", "$@96", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@97", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@98", "$@99", "$@100",
  "variable", "$@101", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@102", "gorder_list",
  "in_sum_expr", "$@103", "cast_type", "opt_expr_list", "expr_list",
  "ident_list_arg", "ident_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "$@104", "$@105", "$@106", "$@107", "$@108", "$@109",
  "$@110", "normal_join", "opt_use_partition", "use_partition",
  "table_factor", "$@111", "select_derived_union", "$@112", "$@113",
  "select_init2_derived", "select_part2_derived", "$@114", "$@115",
  "select_derived", "$@116", "select_derived2", "$@117", "$@118",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@119",
  "$@120", "index_hints_list", "opt_index_hints_list", "$@121",
  "opt_key_definition", "$@122", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@123", "having_clause", "$@124", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@125", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_analyse_clause", "$@126",
  "opt_procedure_analyse_params", "procedure_analyse_param",
  "select_var_list_init", "$@127", "select_var_list", "select_var_ident",
  "into", "$@128", "into_destination", "$@129", "$@130", "do", "$@131",
  "drop", "$@132", "$@133", "$@134", "$@135", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "drop_ts_options_list",
  "drop_ts_options", "drop_ts_option", "insert", "$@136", "$@137",
  "replace", "$@138", "$@139", "insert_lock_option", "replace_lock_option",
  "insert2", "insert_table", "insert_field_spec", "$@140", "fields",
  "insert_values", "$@141", "$@142", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "no_braces", "$@143",
  "opt_values", "values", "expr_or_default", "opt_insert_update", "$@144",
  "update", "$@145", "$@146", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@147", "single_multi", "$@148", "$@149", "$@150", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@151", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@152", "show_param",
  "$@153", "$@154", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@155", "$@156", "explanable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@157", "flush_options", "$@158", "$@159", "opt_flush_lock",
  "$@160", "flush_options_list", "flush_option", "opt_table_list", "reset",
  "$@161", "reset_options", "reset_option", "$@162", "slave_reset_options",
  "purge", "$@163", "purge_options", "purge_option", "kill", "kill_option",
  "use", "load", "$@164", "$@165", "$@166", "$@167", "data_or_xml",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_xml_rows_identified_by", "opt_ignore_lines",
  "lines_or_rows", "opt_field_or_var_spec", "fields_or_vars",
  "field_or_var", "opt_load_data_set_spec", "load_data_set_list",
  "load_data_set_elem", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys_nonewline", "TEXT_STRING_sys", "TEXT_STRING_literal",
  "TEXT_STRING_filesystem", "ident", "label_ident", "ident_or_text",
  "user", "keyword", "keyword_sp", "set", "$@168",
  "start_option_value_list", "$@169", "$@170", "$@171",
  "start_option_value_list_following_option_type", "$@172",
  "option_value_list_continued", "option_value_list", "$@173", "$@174",
  "option_value", "$@175", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "$@176", "$@177",
  "internal_variable_name", "transaction_characteristics",
  "transaction_access_mode", "isolation_level",
  "transaction_access_mode_types", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "$@178", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "$@179",
  "handler", "$@180", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "$@181", "handler_rkey_mode", "revoke", "$@182",
  "revoke_command", "grant", "$@183", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@184", "$@185", "$@186", "$@187", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@188", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@189",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@190",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@191", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@192",
  "view_list_opt", "view_list", "view_select", "$@193", "view_select_aux",
  "$@194", "create_view_select_paren", "create_view_select", "$@195",
  "view_check_option", "trigger_tail", "$@196", "$@197", "$@198",
  "udf_tail", "sf_tail", "$@199", "$@200", "$@201", "$@202", "$@203",
  "sp_tail", "$@204", "$@205", "$@206", "$@207", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@208", "opt_migrate", "install", "uninstall", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   124,    38,    45,    43,    42,    47,    37,    94,   126,
      40,    41,    44,    33,   123,   125,    59,    64,    46,    58
};
# endif

#define YYPACT_NINF -3878

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-3878)))

#define YYTABLE_NINF -2611

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
    4742,  2499,   116, -3878,  -136,   193, 47579,   809,  1492,  1492,
    -157,  3184, -3878, -3878, -3878, -3878, -3878,  3094, -3878, 47579,
     116,   912, -3878, 23646, -3878, -3878,   725,   202,   211,  1492,
     116, -3878, 47579, -3878,   714,  1535,   116, -3878, -3878, 41449,
   -3878,  -157, 47579, -3878, -3878, -3878, 41449,  1131,   704,   699,
     940, -3878, -3878, 47579,  2061,   956,  1415,  1299, -3878, -3878,
    1064, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, 24262, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878,  1395, 47579,  1440, 47579, -3878,
    1303, 47579, 39610, 47579, -3878,  1066,  1459, -3878, -3878,  1525,
   -3878, -3878,  1492,  -157, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878,  1189, -3878, -3878,  1186, -3878, -3878, -3878, -3878, -3878,
    1729,  1619, -3878,  1631, 39610, -3878, 47579, -3878, -3878, -3878,
     255, -3878,  1354, -3878,  1383,  1685,  1707,  1714,   106, 11133,
    1762,  1762,  1762, 47579,  1747,  1762,  1762, 47579, -3878,  1762,
   -3878,  1762,  1492, -3878, -3878, -3878,  1804, -3878, 47579,  1635,
     156,   -89, 39610,  1662, 47579, -3878, -3878, 11133, -3878,  1780,
   -3878, -3878, -3878,  1492,  1973,  1835,   969, 47579, -3878, -3878,
    1492,  1010,   887,  1442, -3878, -3878,  1561, -3878, -3878,   179,
   -3878, -3878, -3878,  2597, 26110,  5330,  1561,   -31,  -124,   -31,
   -3878, -3878, 47579,  1492,  1761, -3878, -3878,   316,   316,   316,
   -3878,   316, -3878,   316, -3878,   956,  1416, -3878, -3878,  1413,
   47579,   813,  1899,  1114, -3878, -3878,  1445,   879, -3878,  1506,
   36545, -3878, 47579, -3878, -3878, -3878, -3878,  1741, -3878, -3878,
   -3878,  1811, -3878, 36545, 23646, 47579,  1600, -3878, -3878, -3878,
   23646,  1505, 47579, -3878, 23646, 23646,   919,   801,  1443, 47579,
   47579,  1960, -3878,  2109, 36545,  1738, -3878,   322,  1108,  1525,
    2142, -3878,  1619, -3878, 47579, 47579, 47579, -3878, -3878, -3878,
   42062,   106,  1540,  1550,  1564, 15571, -3878,  1587,  1595,  1606,
   11133,  1611,  1615,  1629,  1637,  1639,  1641,  1645,  1653,  1671,
    1671,  1677,  1680,  1683,  1687,  -123,  1689, -3878,  1705,  1708,
    1716, -3878, -3878,  1719,  1724,  1730,  1742, -3878,  1752,  1772,
    1774, 11767,  1799,  1801, -3878, 20557,  1812,  1817,  1825,  1841,
    1847,  1857,  1860,  1862,  1879, -3878, -3878, 11133,  1677, -3878,
   -3878,  1886, -3878,  1897,  1903,  1909,  1912,  1932,  1940,  1951,
    1955,  1975,  1988,  1990,  1995,  2004,  2009,  2013,  2022,  2028,
    1677, -3878,   554,  2032,  2059,   587,  2062, -3878,  2065, -3878,
     319,  2068,  1671,  1677,  1677,  2073,  2077,  2085,  2089,  2104,
    2111, 15571, 15571, 15571, 11133, -3878, 47579, -3878, 47579, -3878,
     237,  2521, -3878,  2435, 15571,   941, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  1559,  1718, -3878, -3878, -3878, -3878, -3878,
   -3878,  2117,  1706,  2149, 47579, 47579, 47579,  1913, 47579, 47579,
   39610,   738, 47579, 36545, -3878,  1762,  1836,  3154, 29185,  3603,
   -3878,   151, -3878, -3878, 47579, -3878, -3878, -3878, -3878,  2147,
    1943,   237,  2217,   244, 23646, -3878,    99, -3878,  -202, -3878,
   -3878,  2103, -3878, -3878, 36545, 23646, -3878, -3878, -3878, 21175,
   -3878, -3878,  2447, -3878,  1928, -3878, -3878,  1718,  3501, -3878,
    3721,  2042,   801,  2007, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878,  2045,  2597, -3878, -3878,   210,  2198,
    2127,   380,   408, 34093,   991,   708,   118, 26725, 34706,  2150,
   -3878, -3878, -3878,   807,  2633, -3878,   624,  2168,  1381,   624,
   37158,  2538,   230, -3878,   130, -3878,  2631, -3878, -3878, -3878,
   -3878,  2289,  2282, -3878, -3878,   348,  1837, -3878,  2663, -3878,
      53, -3878,  2308,  2538,   624,   230, -3878,  2555,  2679,   139,
    -115, -3878, -3878, -3878, -3878,  2202, -3878,   804,  2753, -3878,
    2211, -3878, -3878, 23646, -3878, -3878,  2147, -3878, -3878, -3878,
    2212, -3878,  2482,  2316, -3878, -3878,    90, -3878,  2219,     9,
    2704, -3878, 39610,  1396, 37771, -3878, -3878, -3878,  2736,  2751,
    1671,  2224, -3878, -3878, -3878,  2856, -3878, -3878,  2235,  2762,
    2762,  2762,  2866, -3878, -3878, -3878,  2243,  2489, -3878, -3878,
    2412,  2280, -3878,  1600, 23646,  2643,  2250, -3878, -3878,  2501,
   11133, -3878, -3878,  4092,   262, -3878, -3878,   266, -3878,  2832,
    2467, -3878, -3878, -3878, -3878,  2733, -3878, -3878,  2856,  2795,
    2762,  2685,  2273, -3878, -3878, -3878, -3878, -3878, -3878,   242,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878,  1579, -3878, -3878,
   -3878, -3878, -3878,  1600, -3878, 23646, -3878, -3878, -3878, 23646,
   -3878,  2279, -3878,  2274, -3878, 11133, 11133,  1295,  2845,  2905,
    2905,  2905,   237,  2313, 11133, 11133, 11133, 11133, 11133, 11133,
   11133,  1348,  2290, -3878, -3878,   -69, -3878,  2292, 11133, 11133,
   -3878, 11133, 11133, 24878, -3878,  3874, 11133, 11133,   372,  2785,
   11133, 11133, 11133, 11133,  3495, 11133, 11133, 24878,  2916,  2294,
   -3878,  2291,  1428, 11133, 11133,  1521, 11133, 11133, 11133, 11133,
   11133, -3878, -3878, 11133, 11133, 11133, 11133, 15571, 11133, 11133,
   11133, 11133, 11133, 11133,  2301, 11133,  2905,  2905, 11133, 11133,
    1640, -3878, -3878, 11133,  2718,  2718, -3878, 11133,  7963, 11133,
   -3878, -3878, -3878,  2302, -3878, -3878, -3878, 24878,  2905,  2905,
   11133, 11133, 11133,  2845,  2845,  2845,   294,  2307,  1051, 11133,
   27340,  2305, -3878, -3878, -3878, -3878, 11133, 11133, 11133, -3878,
   15571, -3878, -3878,  2094, -3878, -3878, -3878, 12401, 15571, 15571,
    2309, 15571, 15571, 15571, 15571, 15571,  2687, 15571, 15571, 16205,
   16839, 15571, 15571, 15571, 15571,   983,  2845, 39610, 15571, 11133,
   -3878, -3878, 47579, -3878, -3878, -3878,  2312, 23646,   738, -3878,
   -3878, -3878, -3878, -3878, -3878,  2315,   738, -3878,  2802, -3878,
   -3878,  2324, 23646, -3878,  2320, -3878,  2688, -3878,  2690,  2691,
    2692, -3878, -3878, -3878,  2929,  2706, -3878,  2710, -3878, -3878,
    2357, -3878, -3878, 17473, 39610, -3878,  2358, -3878,  2839, -3878,
    2593,  2547,  1548, -3878, -3878, -3878, -3878, -3878,  2634, -3878,
   -3878,  2483, -3878,  2657, -3878, -3878,   154, -3878,    80, -3878,
   -3878, -3878, -3878, -3878, -3878,  2659,  2394, -3878, -3878, -3878,
   47579, -3878, 48192, -3878, 21175,  -136, -3878, -3878, -3878,  2760,
      89,  2398, -3878, 23646, -3878,   108,   108,  2646,  1017, 39610,
   -3878, -3878,   194,  2401,  2484,  2410, -3878,  2493, 23646, 23646,
   -3878, -3878, -3878,  2660, -3878,  3039,   887, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
    2422,  2900,  2593,  2700, -3878,  2703, -3878, 47579, -3878,  1739,
   -3878, -3878, -3878,  2438, -3878, 11133, -3878, -3878, 47579, -3878,
   -3878, -3878, -3878, -3878,  3003, 11133, -3878, 36545,  1485,   943,
     169,   807, -3878, -3878, -3878, -3878, -3878, 47579, 42675,  2444,
   -3878,  2844,  -136, 11133, -3878,  2452,  1619, 47579, 47579, 47579,
   23646, 47579, 23646, -3878,    38,    38, -3878, 35319, -3878, -3878,
   -3878, -3878,   624, 47579, 47579,   624, 36545, -3878,   230, 47579,
     624, -3878,  2846,  2554, -3878, -3878, -3878,  2913, -3878, -3878,
    2904,  2460, -3878,  2844, -3878, -3878,   230, -3878, -3878, 23646,
   -3878, -3878,   230, -3878,   230,   230,   624,   624,  2512,   -31,
   -3878, -3878,  2606,  -124, -3878,  1288,   316,  2707, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,   815, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878,   174, -3878, -3878, -3878,  2084,  2975, -3878, 39610,
    1060,   633,   797,  1060,  1247,  -136,  1217, -3878,  1217, -3878,
   36545,  2938,  3523,  2745,   253, 23646, -3878,  2490, 43288, 23646,
   -3878, -3878, -3878,   195,  2498,  2492,   237,  2976,  2977,  2978,
    2982,  2983,  2984,  2985,  2989,  2993,  2994,  3000,  3011,  3013,
    3016,  3017,  3020,  3021,  3023,  3024,  3026,  3031,  3040,  3046,
    3049,  2526, -3878, -3878, -3878, -3878, 23646, -3878, -3878, -3878,
   -3878,  2627, -3878, -3878, -3878, -3878,  2141, -3878, -3878, -3878,
     188,  1282,  2599,  2543,   110, 36545,  3022, 47579, 47579,  1619,
   47579, 47579, -3878, -3878,   974,  2851,  2852,  2853,  2580, -3878,
    2660, -3878,   927, 47579,  3029, 31028, -3878,   374,   947, -3878,
    2905,  2588, -3878,  2591,  2594,  2598, 11133,    48,   314,  1150,
    1166,  1331,  1219,   439,   328, -3878,  2600,  2605, -3878,  2601,
   -3878, -3878,   444,   471,  1240,  1269,  2602,  2613, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  3034, -3878,
     498,  1379, -3878, -3878, -3878, -3878,  2614, -3878, -3878,  1292,
     525,   605,   341,  2626,   678,  1508,  1536,  2607, 24878, 47579,
    2905,  2622,  1300,  1307,  2905,  2629,   688,  1320,  1571,  1574,
    1589,  1352,  1368,   788,  1620,  2755,  1449,   822,   843,  1465,
     876,   924, -3878,  1471,  2632,  2635,   953,   288,  2905,  2636,
     362,  2619,  2625,  1481,  9231,  9865, 10499,  1145,   982, -3878,
    2640, -3878,  2291,  2641,  2642,   364,   336,  1483, -3878, 11133,
   -3878, -3878,  1172,   902,  2648,   141,   169, -3878,  2768, 47579,
    2275,   160, -3878, -3878, -3878, -3878, -3878, -3878,   856, -3878,
    2649, -3878,  2655,  1969,  2637, 11133,   187,  2637,  3303,  2488,
    2488, 15571,  2878,  2674, 11767,   864, 11767,   864,  2637,  2637,
    2637, -3878, 15571,  2675, 15571, 15571, -3878,  2845,   237,  2645,
    1031, 47579, -3878,  2315,  1077, -3878,   807, 36545,   149, 23646,
   39610,  2630, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
    3779, 23646,  2763,  2765,  2767, -3878, 29800, -3878, -3878, -3878,
   -3878, 29800,    14, -3878, -3878, -3878, -3878, -3878,  2742, -3878,
   -3878, -3878,  2683, -3878, 36545,  2683, -3878, -3878,  2683, -3878,
   -3878,  2683,   828,  3320, -3878,   880,   906,  3482,  2684, -3878,
   -3878, -3878, 23646, -3878,  3089,    -5, 23646,  2490,  2693, -3878,
   -3878, -3878, -3878, -3878,  2518,  2789, -3878,  3309, -3878, 11133,
    -136, -3878, 36545, 36545, 23646, 23646,   400, -3878,  2228,  2694,
   -3878, -3878, -3878, -3878, -3878,  3501, 17473,  2695, 36545,  1018,
   -3878, -3878, -3878, -3878, -3878,  1349,   237, -3878,  2697, -3878,
   38384, -3878,   237,   807,  2698,  2701, -3878, -3878,  3065,   814,
   -3878,  2708,  2709, -3878,  2705,  2711,  2713, 43901, 11133, -3878,
     943, -3878, -3878,   807, -3878, -3878,  8597,  -136,  3141, -3878,
     237,  2716, 47579, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,   -72, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,   624, -3878, -3878, -3878,
   -3878, -3878,  2927,  2538,  1837,  3141,   624,   230, 23646,   624,
     624, -3878, -3878,  2339,  2754, -3878, -3878, -3878, -3878, -3878,
   47579,  2014,  2876, -3878,  2723, -3878, -3878, 23646, -3878,  2724,
   -3878,  3156,  3313,  2538, -3878, -3878, -3878,   807,   807,  3047,
   -3878,  -136,  2857,  2860,  2862,  2881,  2882,  2894, -3878, -3878,
    -136,  -136, -3878, -3878,   807, -3878,   895, -3878, -3878, -3878,
   -3878,  -136,  -136,  -136,  -136,  2527,  -136,  -136,  1663, -3878,
   -3878,   807,   807, -3878,   140, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878,   993, -3878,  3005, -3878,  2415,   807,  3324,  3015,
     807,   807,  3324,   807,  3019,  3028,   807,   807,  2840,  3271,
     807,  3158,  2870,  2797,  3168,   807,  3032, -3878,  2874,  3287,
     807,   807,   807,   807,   807,  3324,  3035,  3373,   807, -3878,
     807,  3036,  3038,   163,  3042,  3044,   807,   807,   807,   807,
     215, 47579,   807,  3051,   807, -3878, -3878,  6023, -3878, -3878,
   -3878, -3878, -3878, -3878,   -57, 21791, -3878, -3878, -3878, -3878,
     152, -3878,  2996, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878,  2801, -3878, -3878, 11133,  2807,
    2527,  -136,  2527,  2527,  -136,  -136,   736,  -136,  2527,  2527,
    -136,  -136,  -136,  -136,  -136,  -136,  -136,  2527,  2527,  -136,
     858,  -136,  2527,  4092, -3878, -3878, -3878, -3878,   199,   807,
     807,   807,   807, -3878,  2287, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, 39610,  3170,  2669,  1135, 39610, -3878, 47579,
   -3878,  1876, 47579,  2814,  -108,  2848,   939,   939, -3878, 23646,
   23646, 23646, 47579,  2858, -3878, 31028, -3878, -3878,  1288, -3878,
    2809, 13035, -3878,  2821, -3878, 11133, -3878, -3878, -3878,  1544,
   11133, 11133,  3304,  1360, -3878, 38997, -3878, -3878, -3878, 11133,
   38997,  1360, 11133, -3878,  2827, -3878,  3226,  3227, -3878, -3878,
   -3878, -3878, 11133, 11133, -3878, 11133, 11133, -3878, 11133, 11133,
   11133, 11133, 11133, -3878, -3878, 15571, -3878,  2825,  2833, -3878,
   -3878, -3878,  2834, -3878, 11133, -3878, -3878, -3878, -3878, -3878,
   -3878, 11133, -3878, 11133, -3878, 11133, 11133, -3878, 11133, 11133,
   -3878, -3878, -3878, 13669, 11133, 11133,  2836, -3878, -3878, 11133,
   11133, 11133, -3878, 11133,  1183, 11133,  1421, 11133,  1930, 11133,
   -3878, 11133, -3878, -3878, -3878, -3878, 11133,   381,  2518,  2527,
    2837, -3878,  1691, -3878, -3878,  2161, -3878,  1172,  2841, -3878,
   -3878,  1739, -3878, -3878, 39610, 11133, -3878, -3878, -3878, -3878,
   -3878, -3878, 15571,   384,  2843, 15571, -3878,  3303,  3495,  3495,
    2134, 11133,   187,  3303, 11133,  2849,  2854, -3878, 11133, 47579,
   -3878, -3878, -3878, -3878, 39610, -3878, -3878, -3878, -3878,   149,
   -3878,  2320, -3878,  2490, -3878,  3316,  2859, -3878, -3878, -3878,
   -3878, -3878, -3878, 47579, -3878,  2919, -3878, -3878, -3878, 22409,
   22409, -3878, 22409, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,  2538,  2228, -3878,  2861,
   -3878, -3878,  2501,  2931,  2864,  3212, -3878, -3878, -3878, 47579,
   15571, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
    3442,  2865,  2877,  3334,  2879,   237, -3878,  2954, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,   752, -3878, -3878,  2883,
    2883, 19323, -3878, -3878, -3878, 47579,  3339, -3878,  3314,  3326,
   22409, 22409, 22409,  1185, -3878,    63, -3878,   197,  3281,  2538,
   -3878,  3329, 40223, -3878, 31641, -3878, -3878, -3878, -3878,  1485,
    2974,  2979,  1316, -3878, -3878,  3279,  3111, -3878, -3878, -3878,
   -3878,   237, -3878,  2444,  8597,  2896, 27955, -3878, 15571,  1705,
   -3878,   237, -3878, -3878,   736, -3878,   182, -3878, 35319, 35319,
   -3878,  3172, -3878, -3878, -3878, -3878,  2684,   230, -3878, -3878,
    3377, -3878,  3380, -3878,  2907,  3388, -3878,  3159, -3878,  1198,
    3297,  3299, -3878,  3177,  1095,  3177,  1198,  1198, 24878,  1288,
    2660, -3878,  2527,  3232, -3878, -3878, -3878, 38384, 35932, -3878,
   -3878, -3878, -3878,  3451, -3878,  3452,   936, -3878, -3878,  2327,
     992, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,  1247,  2327,  2327,  1578,
   -3878,   166, -3878, -3878, -3878, -3878,  3390, -3878, 25494,   116,
   -3878,   238, -3878, 25494, -3878,   195,   195, -3878, 44514, 25494,
     116,   736,  2527, 25494,  2527, 45127,   116,  -136,  -136,  2267,
     807,  2527, -3878, -3878,  3310, 47579,  3311, 25494, 25494, -3878,
   39610, 47579, -3878,   807,   150,  2527, 45740,   736,   736, 25494,
     116, 24878,  2654, -3878,  -136,   116, -3878, -3878, -3878, -3878,
   23646,   116,   116,  2590,  3045,  3083,  3163, -3878, -3878, -3878,
    2527, 45127, -3878, -3878,  5956, -3878, -3878, -3878, 18707, 47579,
     318,   201, -3878,  2924,    43,  1102,  3007,   284,  2936,  2937,
   46353,   237,  2527, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  -136,  2518,  2327,  2327,  2427, -3878,  3200,
    3374,   807, -3878,  2414, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  3033, -3878,  3558,  3133,  2955, -3878, -3878,
     851, -3878, -3878,  1171, 23646, 18091, -3878,  3206, -3878,  2620,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  2956,
    1288,  2684,  1498,  2684,  2968, -3878, 11767,  1487, -3878,   237,
   11133,   237,  1617, -3878,  2965,  2965,  2966, -3878,  2973,  2965,
    3368,  2966,  3375,  2986,  2987,  1529,  2988,  2990,  1559, -3878,
   11133, 11133,  1580,   410,  1584,   569,  1019,  1070,   448, -3878,
    1592,  3091, -3878, -3878,  1602,  1612,  1622,  1633,  1074,  1657,
    1709, 11767,  1668,   897,   475, -3878,  1697,  1080,  1084,  1701,
   11133,  1703, 11133,  1712, 11133,  1731,  1756,  1766,  2992,  2992,
     142, -3878,  2981, -3878, -3878, -3878,  2995, -3878, -3878,  2045,
    2161, -3878, -3878,  2997, -3878, -3878,  3001,   237,  3002, -3878,
   -3878, 11133, -3878,   941, -3878, -3878, 15571,   506,  3009, -3878,
     237, -3878, -3878,  3014,  1559, -3878,   292, -3878, -3878, -3878,
   -3878,   281,  3369, 29800, -3878,  1720, -3878, 36545,  3004, -3878,
    3006,  3064,  3068,  3069,  3008, 11133, -3878, -3878,  3262, 23646,
   -3878,  3411, -3878, -3878, -3878, -3878,  3018,  3037, -3878, -3878,
   -3878,  3303,  3382,  3263, -3878, -3878,  2518, 47579, 36545, -3878,
    2597, 24878, -3878,  3041, -3878,  3041,  1306,  3050,  1732, -3878,
   -3878, -3878,  3025,  2007,  1764, -3878, 17473,  3282, 36545,  3462,
    3464,  3477, -3878,  2684,  2684,   830,  3085,  3434, -3878, -3878,
   -3878, -3878, 46966, -3878, -3878, -3878, -3878,  1350, -3878,  3052,
    3053,   198,  3252, -3878, -3878, -3878, -3878,   807, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878,  2538, -3878, -3878, -3878, -3878,
   -3878,  2538, -3878,   624,  -136,  -136,  1542,  -136,  3522,  3559,
    -168,   902, -3878,  1154, -3878, -3878, -3878,  3438,  1198,  3177,
    3177,  3444,  3328,  1213,  3066, -3878,   807, -3878,  1385, -3878,
    2597, -3878, -3878, 11133, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878,   993, -3878, -3878, -3878, -3878, -3878,  3070,  3446,
    3449,   195, -3878, 25494, -3878, -3878, 25494, 25494, -3878, -3878,
     458, 45127, -3878, -3878, -3878, -3878, -3878, -3878,  3071, -3878,
   -3878,  2518, -3878, -3878, 35932,  -136, -3878, 25494,  3071, -3878,
   -3878,   181, -3878,  3093,  -136, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, 45127,  3072, -3878,   344, -3878,
   -3878,  1973, -3878, 45127, -3878, -3878, -3878, 45127, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  3090,  2719,  2218, -3878,  3096,  3099, -3878,
   -3878, -3878, -3878, 47579, -3878, -3878, 23646, -3878, -3878, -3878,
    5640, 47579,  3323, -3878, 11133, 11133,  3338, 47579,  3361, -3878,
    3658, 47579,  3718, 45127, -3878,  3107, -3878,  3109, -3878,  1767,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878,  3113, 47579,  2327,
    1905, -3878, -3878,  -136,  1171, -3878, -3878, -3878, -3878,  3381,
    3383, 47579, -3878, -3878, -3878, -3878,  3258, -3878, 23646, -3878,
    3283, -3878,  3119,    55,  5764, -3878,  3123,  3124,  3126, 31028,
    2684,  3384, -3878, -3878,  3495, -3878,   237, 11133,   312, -3878,
   -3878,   212,  3400, -3878,   835, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878,  3128,  3495,  3495,
   -3878, -3878, 11133, -3878,  3716,  3296, 11133, 11133, -3878, 11133,
   -3878,   965,  3136,  3162, -3878, -3878, -3878, -3878, 11133, -3878,
   -3878,  3495, -3878, 11133, -3878, -3878, 11133, -3878, 11133, 11133,
   -3878,  1775, -3878,  1794, -3878,  1852, -3878, -3878, -3878,  2518,
    3140,  3513, -3878, -3878, -3878,  2518,  3325, -3878, -3878,  2518,
    2527,  2438, -3878, -3878,  1051, 47579, -3878, -3878,  1782, -3878,
   -3878, 11133, -3878, 40223, -3878, -3878, -3878,  3502,  3764, -3878,
    3363, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, 47579,  1107,
    3155, 32254, 36545, 36545, 36545, 14303,   237,  3642, -3878, -3878,
   -3878,  3411,  3529, -3878,   790, -3878, 47579,  3160,  1251, -3878,
    1789, -3878, -3878,  3161, -3878,  2045,  3164, -3878,   807, 14303,
    2883,  3283, -3878, -3878,  1306, 24878, 31641, -3878, -3878, 47579,
   -3878,  3604,  2273, 36545, 36545, 36545,  2538,  3592,  2931,  2931,
   -3878, 28570, -3878, -3878,  3319, -3878, -3878, 32867, -3878, -3878,
   -3878, -3878, -3878,  8597, 27955, 43901, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  -136,  3643,  3409,  1739,  2375, -3878,  1288,
   -3878,  1198, -3878,  3553,  3557,  1198, -3878, -3878, -3878, 24878,
    2684, 14303, -3878,  2045,   237,  3173,   344, -3878,  -134, 11133,
   25494, -3878, -3878, -3878,  3176, -3878, -3878,  3687,  3688, -3878,
   25494,  2141, 47579, -3878,  3003, -3878, -3878, -3878,  3270, -3878,
    5640, -3878, 24878, -3878, -3878, -3878, -3878, -3878, 47579, -3878,
   23646, -3878, 18707, -3878,  3180, -3878,  2965,  2965,  2965, -3878,
   -3878, -3878,  2966, -3878,  2973,  3414, -3878,  2973,  2973, -3878,
   -3878, -3878, -3878, -3878,   212,   301, -3878, -3878,   212, -3878,
   -3878, -3878,   122,  1499,  2973, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878,  2965,  2966,  2966, -3878, -3878,   212,  2965, -3878,
    2965,  2717, -3878,   392,   117,  2965,  2965,  2965,  3192,  3185,
   -3878,   237,  3495,  3746, -3878, -3878,  3340,  -136,  3691, -3878,
    1822, -3878,  3194, -3878, 46353, -3878,  2527,  1247, -3878, -3878,
   -3878, -3878,  3341,  1345, -3878,  3372,  3205,  3207, -3878, -3878,
    -136,  3210,  3211,  6023, -3878, -3878, -3878,  3818, -3878, 47579,
   47579, 47579,  2809, -3878,  3580,  1246,   237,  3213,  3214,  3216,
    3217,  3819,   177, -3878,  3821, 38997, -3878, -3878, -3878,  3224,
    1832, -3878,  3225,  3228,  1863, -3878,   316,  3233,  1865,  1104,
    1843,  3530,  3605, -3878,  3457, -3878,  1872,  1284,  1874,  1949,
    1984,  2006, -3878, -3878, -3878, -3878, -3878,  3238, -3878, -3878,
     385, -3878,  3231,   208,   902, -3878, -3878,  1853, -3878, -3878,
   -3878,  3701,  3600, -3878,  3676, -3878, -3878, -3878,  -146,  -146,
    -146,  1705,   237,  1866, -3878, -3878, -3878, -3878,  3649, -3878,
   -3878,  3247,  3309, 47579, -3878,  3263, -3878,  2438, 24878, 14303,
    3254,  3246, -3878,     9, -3878, -3878,  3249, -3878, -3878, 36545,
    2273,  2273,  2273, -3878,  3842,  3682, -3878, -3878, 39610,  3260,
   -3878, -3878,  3562, -3878, -3878, -3878, -3878, -3878,  -136,  3739,
   -3878, -3878, -3878,  2723,  2595,  3312,  1198,  1198,  3030,  3327,
   11133, 11133,  3267, -3878,  3384, -3878, -3878,   746,  2438, 11133,
   -3878,  2518,  3263, -3878,  2040,  3268,  3284, 47579,  3286,  3288,
   -3878,  2917,   318, -3878, -3878, -3878, 23646,  2717,   116, -3878,
   -3878,  3071,   752,  3289, -3878, 47579,  3596, -3878, -3878, -3878,
   -3878,  1473, -3878,  3292,  1473,  1473, -3878,  2198, -3878,  3315,
     212, -3878, -3878,  3321, -3878, -3878, -3878,  1473,  3293,   212,
   -3878, -3878, -3878, -3878,  1473, -3878, 39610,  1875,  -136,  2618,
   -3878,  3330, -3878,  3813,  1327,  3684, -3878,  2717, -3878,  3685,
    3581, -3878,   212, -3878, -3878,  3904, -3878,   212,  3904,  1473,
    3582, -3878,  1473, 47579, -3878, -3878, -3878, -3878, -3878, -3878,
   47579, -3878,  1222, -3878, -3878, -3878,  1893,  -136, -3878, -3878,
   -3878,  3322,  3318, -3878, -3878, -3878,  1102, -3878, 47579,  5640,
   -3878, -3878, -3878,  3206, -3878,  1230,  1917,   344,  3317,  1919,
    1924, 35319, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, 38997, -3878,  3904, -3878,  3583, -3878, -3878, -3878, 11133,
   -3878, -3878, -3878, 11133, -3878, -3878,  3615,  3776, -3878, -3878,
   -3878, -3878, -3878, -3878,  3331, -3878,  2527,   197,   197, -3878,
   -3878, -3878, -3878, -3878,  3575,   778,  3343,  3343,  3343, -3878,
   14303,  3704,  3416, -3878, -3878,  3336,  3378, -3878, -3878,   208,
   -3878, -3878, -3878, -3878,  2273, 11133, -3878,  3384,  2267, -3878,
   28570, -3878, -3878,  -136,  1051, -3878,  3376, -3878, -3878, -3878,
    3379,   237,   237, 47579,  3580, -3878,   920,   208,   344, -3878,
    1927, -3878, 47579, 47579,  1937, 47579, 47579,  2763,  2765,  2767,
     858,   858, -3878, -3878, -3878, -3878, -3878, -3878,  3734, -3878,
   -3878,  1944, -3878,    96,  3607, -3878, -3878, -3878, -3878,  1473,
   -3878,   316, -3878, -3878, -3878, -3878, -3878,   316, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  3619,  3385,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878,  3342, -3878, -3878,  3463, -3878, 53709, -3878, -3878,
    1267,  3371, -3878, -3878, -3878, -3878,  1575, 47579, 23646,  3338,
    3527, -3878,  3003, -3878,     9,    55,  3283, -3878,   261, 47579,
   -3878,  3622,   217,   923, -3878, -3878, -3878,  3351,  3352,   344,
    2044, -3878, -3878, -3878,  3359, -3878, -3878, -3878,  3447,  3453,
   -3878, -3878,  3454, -3878, -3878,   170,  1901, -3878, -3878, -3878,
   -3878,  3401, 23646, 15571,  3467, 47579,  1647,  2192, -3878,  1404,
     344, 11133,  2538, 35932, -3878, -3878, -3878, -3878, 11133,  3366,
   11133,  3367,  1947, -3878, -3878, -3878,   195,   195, -3878,   920,
   -3878, -3878, -3878,  1957,  1967,   261,  1976,  1980, -3878, -3878,
   -3878,   318,  3370, -3878, 47579, -3878, -3878, -3878,    83, -3878,
   -3878,  1985, -3878,  2000, -3878, -3878, 11133,  3851,  3397, 47579,
     172, -3878, 54935, 54935, 47579, -3878, -3878, -3878, -3878,  4839,
   -3878, -3878,   -21, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878,  3973, -3878,  3365, -3878, -3878,  1267,
    3391, -3878,  1058, -3878,  2007, -3878, -3878,  5640,  3820,   284,
   -3878, -3878, -3878, -3878, -3878,  3392,  2007,  -136,   807, -3878,
     261, -3878, -3878, -3878,   344,  3398,  3625, -3878,   217, -3878,
   -3878, -3878,   923, -3878, -3878, -3878, 11133, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878,   153,  3644,  2527,  2527,  2527,  2527,
    1901, -3878, 24878,  2660, -3878,  2518, -3878,  2019, -3878, -3878,
   -3878,  3466,   807,  3897,  3899,   807,   807,   807,   807,  3402,
    2192, -3878,  3878, -3878, -3878, 11133, -3878, -3878,   237,  3630,
   -3878,  3964,   902,   237, 47579,   237, 47579, -3878,  3850,  3850,
   -3878,  3616,   261, -3878,   217,   923, -3878,  3263, -3878,   824,
     824,   212,   316,   212,   237, 11133, -3878, 11133,  3436, -3878,
   -3878,  3856, 47579, -3878, -3878, -3878, -3878, 11133, -3878, 53709,
   53709, -3878, -3878, -3878, -3878,  4017, -3878,  3417,     9,  3988,
    3680,  3990, -3878,  3221, -3878, -3878,  3658,  5640, -3878, -3878,
   -3878,  2527,   292, -3878, -3878, -3878,  1488,   292, -3878,   292,
   -3878,   344, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  3420,
   -3878,   807, -3878,  3424, -3878, -3878, 47579,  3426, -3878,  -136,
     807,   807,  1194,  1194,  2518, 39610,  3531, -3878, -3878,   807,
     344,  4043, -3878,    91,  3793, -3878,  2055,  2069,  1452, -3878,
   -3878, -3878, -3878, -3878, -3878,  2080, -3878,  4056, -3878,   978,
    3698,  3700, -3878, -3878, -3878,   237,   237, -3878,    50, -3878,
   -3878,  3831,  3918, 11133,   237, 50644,  3432, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   54322, 11133, -3878,   -21,  3973, -3878, -3878,  3699, -3878,  3702,
   -3878, -3878, -3878,  3941, 53709, -3878,  3936, -3878,     9, -3878,
   -3878, -3878, -3878, -3878, -3878, 24878, 14303,  2267, -3878,  3467,
   -3878,  3461, -3878, -3878,   596, -3878,  -136,  -136, -3878, -3878,
   -3878, -3878, -3878,  2086, -3878, 39610, -3878, -3878,  4030,  4031,
    3931,  4035,    91, -3878,   -87, -3878, -3878, -3878,  4037, -3878,
    4047,  3471,  3472, -3878, -3878, -3878, -3878,  3512,  3971,  3492,
   11133, 53709, -3878,  3954, -3878,  3884,   237,  3826,  3473, -3878,
    3468,   237,  3989, 54935, 54935, -3878, -3878, -3878, -3878,  3966,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  2090, -3878,
   14937, -3878, -3878, -3878, -3878, -3878, 39610, -3878,  3531, -3878,
    3481,   316,   316,  4069,   316, -3878,  4070,  4071,   -87, -3878,
   -3878, -3878, 46353, 46353,   824,   824, -3878,    72, -3878,   237,
   51257,  4067, 47579, -3878,  3572, -3878, -3878, 11133,  3983, 40836,
   51870,  3488, -3878, -3878, -3878,  3667, -3878,  3221,  3671, -3878,
    3461, -3878,  3498, -3878,  3303,  2192, -3878, -3878,  3774, -3878,
   -3878,   316, -3878,   316,   316, -3878,  3504,  2099, -3878, -3878,
   11133, -3878,  3984,  3588, -3878,  3505, -3878, 53709,   237, 53709,
   -3878, -3878,  3933,  3507,  1795, -3878,  3506, -3878, -3878, 53709,
    3922,  3964, -3878, 14937,  3515, -3878, -3878,  3517,  3511, -3878,
   -3878, -3878, -3878, -3878,   237,  4097, 53709, 47579, 48805,  3995,
   52483,  3965, 47579,  5640,  3968,  3969, -3878, 53709, -3878,  4104,
    3793, -3878, -3878, -3878,  3774,  3608, -3878, 49418, -3878,  2592,
    3714,  3550, -3878, -3878,  4038,  1953, -3878, -3878,   316,  3943,
   -3878, 53709, 53709, -3878, -3878, -3878, -3878, 33480, -3878, -3878,
   -3878, -3878, -3878,  1185, -3878,  3804,  3536, 50031, 53096, -3878,
   -3878, -3878, 30415, -3878, -3878, -3878,  3979, -3878, 11133, -3878,
      44, 19939,  3692, 33480, -3878, -3878,   237, -3878, -3878, -3878,
   -3878, 39610,  2114, -3878, -3878, 24878, -3878, -3878, -3878, -3878,
   23028,  3538, -3878,   807, -3878, 24878, -3878, -3878, 14303, -3878,
   -3878
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2601,  1081,  2532,     0,     0,     0,     0,     0,     0,
    2534,   123,    63,  1704,  1818,  1819,  1608,  1636,     2,     0,
    1081,   269,   173,     0,    75,  1645,     0,  1870,     0,     0,
    1081,   483,     0,  1864,     0,     0,  1081,  1648,  1854,   246,
     173,  2534,     0,  1127,  2339,  1742,     0,     0,     0,  1725,
       0,  2415,  1693,     0,     0,     0,     0,     3,     8,    19,
       0,    39,    24,    29,    14,    18,    13,    52,    46,    26,
      37,    10,    54,    55,    16,    43,    11,    12,    15,    35,
      42,    36,    38,    50,  1118,    22,    23,    30,    44,    59,
      20,    56,    53,    21,  1820,    25,    45,    40,    32,    60,
      33,    51,    34,    58,    28,    47,    27,     9,    17,    48,
      49,    41,    61,    31,    57,     0,   929,     0,     0,  1006,
       0,     0,     0,     0,   173,     0,   909,  2599,  2600,  2601,
    1083,  1082,     0,  2534,  1975,  1066,  1092,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  1989,  2046,  2048,  2047,  2049,
    2050,  1990,  1991,  2051,  2052,  2053,  2055,  2054,  2056,  1992,
    1993,  2057,  2058,  2059,  2060,  1994,  1995,  2061,  2063,  2062,
    1996,  2064,  2065,  2066,  2069,  2068,  2067,  1997,  2070,  1998,
    2071,  2072,  2073,  2074,  2075,  2076,  2077,  2079,  2078,  1999,
    2080,  2081,  2082,  2083,  2084,  2086,  2085,  2087,  2088,  2089,
    2000,  2090,  2091,  2092,  2093,  2094,  2095,  2096,  2097,  2098,
    2001,  2099,  2100,  2101,  2121,  2002,  2102,  2105,  2104,  2103,
    2106,  2107,  2108,  2110,  2109,  2111,  2112,  2003,  2113,  2114,
    2115,  2116,  2117,  2119,  2118,  2123,  2124,  2125,  2004,  2005,
    2120,  2122,  2319,  2126,  2128,  2127,  2129,  2131,  2130,  2006,
    2132,  2007,  2008,  2133,  2134,  1972,  2135,  1973,  2136,  2138,
    2139,  2140,  2145,  2009,  2137,  2141,  2142,  2143,  2144,  2146,
    2010,  2147,  2148,  2149,  2150,  2151,  2152,  2153,  2154,  2155,
    2156,  2178,  2167,  2169,  2160,  2162,  2163,  2165,  2161,  2168,
    2166,  2172,  2171,  2173,  2174,  2175,  2176,  2177,  2170,  2158,
    2164,  2159,  2179,  2180,  2157,  2181,  2182,  2183,  2184,  2185,
    2186,  2187,  2188,  2189,  2190,  2191,  2193,  2192,  2194,  2195,
    2196,  2197,  2198,  2199,  2201,  2200,  2202,  2203,  2204,  2206,
    2205,  2208,  2209,  2011,  2207,  2210,  2211,  2212,  2213,  2214,
    2215,  2012,  2013,  2014,  2216,  2217,  2015,  2218,  2220,  2219,
    2221,  2222,  2223,  2224,  2225,  2226,  2227,  2016,  2017,  2228,
    2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,  2237,  2238,
    2239,  2240,  2241,  2243,  2242,  2244,  2245,  2246,  2247,  2248,
    2249,  2250,  2018,  2251,  2019,  2252,  2253,  2020,  2254,  2021,
    2255,  2256,  2257,  2258,  2022,  2259,  2260,  2261,  2263,  2264,
    2262,  2265,  2023,  2266,  2267,  2268,  2024,  2270,  2269,  2271,
    2025,  2273,  2274,  2026,  2272,  2028,  2275,  2276,  2027,  2029,
    2277,  2278,  2279,  2280,  2281,  2283,  2282,  2284,  2285,  2286,
    2030,  2287,  2288,  2289,  2290,  2031,  2291,  2292,  2293,  2294,
    2295,  2297,  2296,  2298,  2299,  2300,  2301,  2303,  2305,  2304,
    2302,  2306,  2307,  2308,  2309,  2312,  2313,  2314,  2315,  2310,
    2311,  2032,  2316,  2317,  2318,  2320,  2321,  2323,  2322,  2033,
    2034,  2324,  2325,  2037,  2326,  2327,  2330,  2328,  2329,  2332,
    2331,  2333,  2335,  2334,  2035,  2336,  2036,  2337,  2338,   192,
    1978,   175,  1979,  1988,     0,  2407,  2406,  1050,  1067,  2535,
    2536,   578,   859,     0,     0,   860,     0,   577,   858,   173,
    2601,   128,     0,   574,   575,     0,     0,     0,  1718,     0,
    1634,  1634,  1634,     0,     0,  1634,  1634,     0,  1637,  1634,
     173,  1634,     0,    68,  1827,   270,     0,  2443,     0,     0,
       0,  1971,     0,  1651,     0,  1871,  1872,     0,  1879,     0,
    1880,  1874,  2404,     0,     0,     0,     0,     0,   173,  1084,
       0,  1702,     0,   236,   245,   247,   248,   244,  2436,  2536,
    2547,  1119,  1125,  1137,     0,  1798,   248,  1037,  1021,  1037,
    1726,  1723,     0,     0,  1702,  1873,  2658,     0,     0,     0,
    2654,     0,  2659,     0,  1127,     0,     0,     1,     5,     0,
       0,  2116,  2005,  2220,  1811,  1809,  1966,     0,   900,   930,
       0,   905,     0,   903,  1984,  1983,  1982,     0,   916,   915,
     913,     0,   447,     0,     0,     0,  2610,   907,  1064,  2533,
       0,   194,     0,    77,     0,     0,     0,  2539,     0,     0,
       0,     0,   127,     0,     0,     0,   124,  1152,  1152,  2601,
    2603,  2605,   578,   576,     0,     0,     0,  1722,  1721,  1720,
       0,  1718,  2039,  1989,  2050,     0,  1939,     0,     0,     0,
    1406,     0,  1994,     0,  2064,  2066,  1999,     0,     0,  1159,
    1159,   731,     0,     0,     0,  2088,  2089,  1945,     0,     0,
       0,  1936,  1946,  2005,  2128,  2129,     0,  1938,  2134,     0,
       0,     0,     0,  2151,  1943,     0,     0,  2188,  2190,     0,
       0,  2194,  2195,  2196,  2197,  1922,  1214,     0,   731,  1935,
    1942,  2213,  1928,  2221,  2226,  2227,     0,  2236,     0,     0,
    2258,     0,  2264,  2262,  2268,     0,     0,  2294,     0,     0,
     731,  1921,  2312,  2313,  2314,  2315,     0,  1937,  2032,  1944,
       0,  2326,  1159,   731,   731,     0,     0,     0,  2333,  2335,
    2338,     0,     0,     0,  2571,  1213,     0,  1371,     0,  1288,
    1400,  1171,  1177,  1191,     0,  1206,  1224,  1225,  1227,  1326,
    1226,  1232,  1231,  1609,  1932,  1230,  1229,  1933,  1934,  1223,
    1956,  1978,  1955,     0,     0,     0,     0,     0,     0,     0,
       0,  1638,     0,     0,  1620,  1634,    70,     0,     0,     0,
    1968,  1515,  2418,  2419,     0,    76,  1653,  1654,  1652,  1005,
       0,  1869,     0,  1883,     0,  1079,   493,   484,     0,  1793,
    1792,     0,  1865,  2548,     0,     0,  1055,  1656,  1703,     0,
    1655,  1860,     0,  1858,  1855,  1857,   237,     0,     0,   267,
       0,  2542,  2539,  2549,  2584,  2579,  2578,  2581,  2582,  1143,
    2583,  1142,  2580,  2577,  1152,  1138,  1140,  1141,   775,     0,
       0,  2359,  2360,  2201,  2221,  2361,  2310,     0,     0,  2381,
    2340,  2345,  2341,     0,     0,   775,  1806,     0,     0,  1806,
       0,  1550,  1796,  1799,     0,  2363,  1774,   856,   855,   854,
    2364,  1792,     0,  1750,  1762,     0,  1727,  1767,     0,  2365,
       0,  1795,     0,  1550,  1806,     0,  1743,     0,     0,     0,
       0,   243,  1042,  1041,  1017,  1038,  1039,     0,     0,  1020,
    1022,  1023,  1019,     0,  2671,  2416,  1005,  1927,  1926,  1976,
    2655,  1925,  2663,  2665,  2651,  2653,  2660,  1121,     0,  2553,
       6,    62,     0,     0,  1824,  2608,  2609,  2607,   791,     0,
    1159,  1985,  2602,   176,   914,     0,   448,   176,     0,     0,
       0,     0,     0,   449,   450,   382,   918,     0,   898,   911,
       0,     0,   910,  2610,     0,     0,  1094,  1096,  1095,  1112,
     196,   193,   174,     0,  1052,  1627,  1629,  1069,  2538,     0,
       0,  2540,  2544,  1212,  1211,     0,   121,   126,     0,     0,
       0,  2510,   125,  2504,  2606,  1152,  1152,  1152,  2598,     0,
    2586,  2593,  2594,  2597,  2596,  2595,  2592,     0,  2585,  2588,
    2589,  2591,  2590,  2610,  2604,     0,   861,   861,   861,     0,
    1705,  1708,  1712,  1716,  1719,     0,     0,  1520,  1245,  1520,
    1520,  1520,  1407,     0,     0,     0,     0,     0,     0,     0,
       0,  1520,     0,  1282,  1255,     0,  1283,     0,     0,     0,
    1947,     0,     0,     0,  2571,     0,     0,     0,     0,  1376,
       0,     0,     0,  2571,     0,     0,     0,     0,     0,  1402,
    1404,  1955,  1520,     0,     0,  1520,     0,     0,     0,     0,
       0,  1164,   771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1520,  1520,     0,     0,
    1520,  1296,  1949,     0,     0,     0,  1948,     0,     0,     0,
    1941,  1940,  1923,     0,  1299,  1301,  1300,     0,  1520,  1520,
       0,     0,     0,  1235,  1234,  1236,     0,     0,     0,     0,
       0,     0,  1210,  1209,  1208,  1207,     0,     0,     0,  1215,
       0,  1216,  1217,     0,  1218,  1219,  1220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1237,     0,     0,     0,
    1924,  1335,     0,  1635,  1615,  1622,  1617,     0,  1638,  1618,
    1626,   462,   461,  1643,  1644,  1624,  1639,  1640,     0,  1623,
    2502,  1619,     0,  1610,     0,    69,     0,  1850,     0,     0,
       0,  1846,  1848,  1847,     0,     0,  1851,     0,  1849,  1828,
    1832,  1838,  1829,     0,     0,   268,   271,   273,     0,   276,
    2453,  2468,  2469,  2465,  2470,  2488,  2471,  2475,     0,  2467,
    2459,     0,  2474,     0,  2463,  2472,     0,  2457,     0,  2473,
    2478,  2489,  2461,  2466,  2444,     0,  2451,  2455,  1516,  1517,
       0,  2417,     0,  1967,     0,     0,  1102,  1884,  1885,  1881,
    1515,  2405,  2408,     0,   494,     0,     0,   505,     0,     0,
      65,    66,     0,  1086,     0,  1085,  1089,     0,     0,     0,
    1659,  1649,  1658,  1441,  1861,  1862,     0,   235,   260,   255,
     263,   257,   259,   258,   264,   265,   266,   261,   256,   262,
     249,     0,  2453,     0,  2437,     0,  2543,     0,  2545,  2562,
    1126,  2550,  1149,  1128,  1148,     0,  1139,   774,     0,   777,
     779,  1678,  1679,   778,   787,     0,   776,     0,     0,     0,
    2366,     0,   783,   785,   784,  2376,   782,     0,     0,  2350,
    2371,  1802,     0,     0,  1773,     0,   578,     0,     0,     0,
       0,     0,     0,  1744,     0,     0,   621,     0,  1766,  1551,
    1800,  1801,  1806,     0,     0,  1806,     0,  1779,  1796,     0,
    1806,  1739,     0,     0,  1731,  1736,  1732,     0,  1738,  1737,
    1740,  1728,  1729,  1802,  1755,  1780,  1796,  1765,  1772,     0,
    1754,  1761,     0,  1770,  1796,  1796,  1806,  1806,  1043,     0,
    1026,  1027,     0,     0,  1724,  1444,     0,     0,  2652,  2666,
    2650,  2661,  2662,  2649,  1122,  2554,  1120,  2555,     0,     7,
       4,  1823,  1813,  1814,  1815,  1816,  1817,  1812,  1810,  1825,
    1826,   792,   791,   569,   572,   571,     0,     0,  1987,     0,
     906,     0,   436,   904,     0,     0,   414,   393,   414,   451,
       0,     0,   791,   921,     0,     0,   908,  1065,     0,     0,
     482,  1112,  1098,  1114,     0,   197,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    78,    79,   101,  1054,  1053,     0,  1051,  1077,  1076,
    1074,     0,  1075,  1073,  1068,  1070,  1071,  2537,  2541,   579,
     791,   424,     0,   385,     0,     0,     0,     0,     0,   578,
       0,     0,  2587,   110,   862,     0,     0,     0,  1710,  1631,
    1441,  1633,  1966,     0,     0,     0,  1714,     0,     0,  1521,
    1520,     0,  1385,     0,     0,     0,     0,  1408,     0,     0,
       0,     0,     0,     0,     0,  1356,     0,  1385,  1160,     0,
     732,  1306,     0,     0,     0,     0,     0,     0,  1491,  1492,
    1493,  1494,  1502,  1495,  1496,  1497,  1504,  1509,  1498,  1499,
    1505,  1506,  1507,  1500,  1508,  1503,  1501,  1510,     0,  1490,
       0,     0,  1514,  1511,  1513,  1512,     0,  1377,  1369,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1520,     0,     0,     0,  1520,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1318,     0,     0,     0,     0,     0,  1520,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1278,
       0,  1958,  1957,     0,     0,     0,   824,     0,  1239,     0,
    1238,  1453,     0,  2556,  2572,     0,  2366,  1372,  1374,     0,
    1162,  1161,  1163,  1174,  1167,  1172,  1165,  1169,     0,  1221,
    2045,  1175,     0,     0,  1203,  2571,  1529,  1204,  1189,  1194,
    1195,     0,  1192,  1193,     0,  1197,     0,  1196,  1200,  1201,
    1202,  1205,     0,     0,     0,     0,  1228,  1233,  1401,  1152,
    1959,     0,  1612,  1625,  1794,  1641,  1680,     0,  1007,     0,
       0,    71,    73,  1843,  1840,  1839,  1841,  1845,  1844,  1842,
       0,  1852,  2088,  2312,  2315,   280,     0,   253,   252,   254,
     277,     0,     0,  2454,  2452,  2486,  2485,  2490,     0,  2487,
    2483,  2476,  2511,  2480,     0,  2511,  2482,  2481,  2511,  2477,
    2484,  2511,  2449,     0,  1519,  2124,  2205,     0,  1522,  2421,
    1646,  2670,     0,  1882,     0,     0,     0,  1080,     0,  1152,
     492,   491,   490,   489,     0,   507,   487,   495,    67,     0,
       0,  1866,     0,     0,     0,     0,  1057,  1657,     0,     0,
    1630,  1442,  1863,  1859,  1856,     0,     0,  2452,     0,  2449,
    2546,  2564,  2563,  2551,  1152,  1541,  1153,  1153,  1955,  2383,
       0,  2378,  2377,     0,     0,     0,  2396,  2379,     0,     0,
    2344,  2384,  2385,  2388,     0,     0,     0,     0,     0,  2382,
    2310,  2346,  2347,     0,  2352,  2342,     0,     0,  1804,  1807,
    1808,     0,     0,  1788,  1782,  1781,  1777,  1783,  1778,  1791,
    1790,  1789,  1752,  1751,  1561,  1562,  1560,  1554,  1555,  1559,
    1558,  1747,  1797,  1787,  1785,  1775,  1806,  1786,  1784,  1733,
    1734,  1735,     0,  1550,     0,  1804,  1806,  1796,     0,  1806,
    1806,  1769,  1771,     0,  1029,  1040,  1025,  1024,  1462,  1461,
       0,  1415,     0,  1417,  1414,  1413,  1412,     0,  1461,  2656,
    2664,  2668,     0,  1550,  2561,  2559,   570,  1680,  1680,     0,
    1986,     0,     0,     0,     0,     0,     0,     0,   177,   186,
       0,     0,   391,   392,  1680,   390,   437,   438,   441,   442,
     443,     0,     0,     0,     0,     0,     0,     0,     0,   130,
     444,  1680,  1680,   387,   415,   416,   419,   420,   421,   422,
     423,   383,     0,   388,     0,   919,  1003,  1680,  1003,     0,
    1680,  1680,  1003,  1680,     0,     0,  1680,  1680,     0,     0,
    1680,     0,     0,  1003,     0,  1680,     0,   990,     0,     0,
    1680,  1680,  1680,  1680,  1680,  1003,     0,     0,  1680,   482,
    1680,     0,     0,  1013,     0,     0,  1680,  1680,  1680,  1680,
       0,     0,  1680,     0,  1680,   937,   989,   582,   608,   609,
     899,   936,   938,   950,   478,     0,   968,   992,   993,   991,
       0,   923,   925,  2611,  2612,  2613,  1101,  1093,  1100,  1097,
    1112,  1110,  1099,   851,   850,     0,  1113,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1628,  1078,  1072,   122,   791,  1680,
    1680,  1680,  1680,   389,   425,   426,   429,   430,   431,   432,
     435,   433,   434,     0,     0,   401,     0,     0,  2505,     0,
    2644,     0,     0,     0,   175,   580,     0,     0,   863,     0,
       0,     0,     0,     0,  1706,     0,  1969,  1713,  1444,  1717,
    1716,     0,  1302,     0,  1349,     0,  1351,  1352,  1353,     0,
       0,     0,     0,     0,  1303,     0,  1253,  1304,  1305,     0,
       0,     0,     0,  1355,     0,   733,     0,     0,  1256,  1257,
    1250,  1242,     0,     0,  1328,     0,     0,  1258,     0,     0,
       0,     0,     0,  1329,  1403,     0,  1405,  1959,     0,  1361,
    1310,  1263,     0,  1359,     0,  1264,  1330,  1331,  1332,  1312,
    1313,     0,  1334,     0,  1314,     0,     0,  1317,     0,     0,
    1266,  1365,  1363,     0,     0,     0,     0,  1367,  1268,     0,
       0,     0,  1267,     0,     0,     0,     0,     0,     0,     0,
    1270,     0,  1251,  1364,  1366,  1320,     0,     0,     0,     0,
       0,  1279,     0,  2565,  1452,  2573,  1453,     0,     0,  2567,
    2557,  2562,  2570,  1243,     0,     0,  1960,  1168,  1173,  1166,
    1170,  2571,     0,     0,     0,     0,  1187,  1186,     0,     0,
       0,  2571,  1529,  1190,     0,     0,  1345,  1346,  1398,     0,
    1616,  1613,  1642,  1681,     0,  2503,  1009,  1008,  1621,  1007,
      74,     0,  1837,  1853,  1830,     0,   272,   281,   274,   278,
     279,   275,  2479,     0,  2460,     0,  2464,  2458,  2462,     0,
       0,  2450,     0,  2456,  2431,  2425,  2432,  2434,  2428,  2433,
    2435,  2426,  2427,  2422,  2429,  1523,  1552,     0,  1103,  1105,
    1106,  1104,  1112,     0,     0,  2411,  2412,  2410,  2409,   497,
       0,  1586,  1587,  1572,  1573,  1571,  1574,   506,  1575,  1585,
       0,   518,     0,     0,     0,  1868,  1867,     0,  1087,  1090,
    1091,  1062,  1061,  1063,  1056,  1058,  1059,   562,  1663,     0,
       0,     0,  1669,  1650,  1660,     0,     0,   250,     0,     0,
       0,     0,     0,     0,  1147,  1444,  1601,  1144,  1132,  1552,
    1542,  1131,  1154,  1150,     0,   790,   789,   788,   786,     0,
       0,     0,     0,  2390,  2391,     0,     0,  2367,  2368,  2369,
    2374,  2373,  2349,  2350,     0,  2351,     0,  2402,  2403,  2400,
    2401,  2399,  2372,  1803,     0,  1756,     0,  1776,     0,     0,
    1749,     0,  1768,  1730,  1758,  1748,  1522,  1796,  1745,  1746,
       0,  1049,     0,  1045,  1044,     0,  1018,  1031,  1461,  1444,
       0,     0,  1438,  1463,     0,  1463,  1444,  1444,     0,  1444,
    1441,  1458,     0,     0,  2667,  1543,  2560,     0,     0,   902,
     180,   183,   181,     0,   182,     0,     0,   446,   445,     0,
    1794,   439,   134,   133,   135,   136,  1569,  1570,  1566,  1567,
    1565,  1568,   138,   137,   132,   917,     0,     0,     0,  1794,
     417,   394,   395,   398,   399,   400,     0,  1004,   892,  1081,
     972,     0,   654,   892,   847,   852,   852,   970,     0,     0,
    1081,     0,     0,     0,     0,     0,  1081,     0,     0,     0,
    1680,     0,   983,   932,     0,     0,     0,     0,     0,   984,
       0,     0,   933,  1680,     0,     0,     0,     0,     0,     0,
    1081,     0,     0,   480,     0,  1081,   482,  1016,  1015,  1014,
       0,  1081,  1081,     0,     0,     0,     0,   614,   615,   613,
       0,     0,   606,   583,   791,   934,   479,   935,   653,     0,
    1010,   650,   656,  1962,     0,     0,     0,   144,  2615,     0,
    1482,   198,   102,   100,    82,  1974,    86,    88,    81,   106,
    1579,  1580,  1578,  1576,  1577,   107,    84,    85,    87,    91,
      90,    92,    93,    96,    97,    94,    89,    95,    83,    98,
     108,   109,    80,     0,     0,     0,     0,  1794,   427,     0,
       0,  1680,   384,   402,   403,   406,   407,   408,   409,   410,
     413,   411,   412,     0,  2506,  2508,     0,     0,   378,   377,
       0,   139,  2638,     0,     0,   653,   111,   478,   581,   584,
     885,   887,   886,   877,   876,   112,   115,   118,  1632,  1716,
    1444,  1522,  1967,  1522,     0,  1715,     0,     0,  1350,  1386,
       0,  1409,     0,  1247,   745,   745,   729,  1394,   725,   745,
    1390,   729,  1392,     0,     0,     0,     0,     0,  1357,  1354,
       0,     0,     0,     0,     0,  1380,     0,     0,     0,  1252,
       0,  1340,  1362,  1360,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1368,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     813,   819,   822,   823,   825,   817,     0,  1322,  1240,  1152,
    2574,  2576,  1123,     0,  2566,  2568,   894,  1373,     0,  1184,
    1180,     0,  1178,  1528,  1199,  1198,     0,     0,     0,  1188,
    1153,  1336,  1152,     0,  1399,  1961,   994,   460,   620,  1611,
      72,  1833,     0,     0,  2515,     0,  2514,     0,  2498,  2501,
    1966,     0,     0,     0,     0,     0,  2420,  1553,  1690,     0,
    1112,  1116,  1977,  1875,  2413,  2414,     0,   498,   499,   501,
    1153,   515,   493,     0,   485,   488,     0,   497,     0,  1060,
    1137,     0,  1682,  1667,  1674,  1668,     0,     0,     0,  1666,
    1951,  1950,  1957,  2549,     0,  1488,     0,     0,     0,     0,
       0,     0,  2552,  1522,  1522,  1595,     0,     0,  1129,  1134,
    1130,  1133,     0,  1151,  1158,  1157,  1952,  1959,  2380,     0,
       0,     0,     0,  2395,  2389,  2386,  2387,     0,  2348,  2370,
    2354,  2353,  2356,  2358,  1805,  1550,  1764,  1763,  1557,  1556,
    1741,  1550,  1760,  1806,     0,     0,     0,     0,     0,  1033,
       0,  2556,  1456,     0,  1440,  1439,  1464,     0,  1444,  1463,
    1463,     0,  1420,  1419,  1694,  1697,     0,  1418,  1515,  1446,
    1137,  2657,  2669,     0,   619,   618,   185,   184,   190,   191,
    1583,  1581,  1582,   452,   463,  1584,   464,   440,   131,   453,
     454,   418,     0,   396,   920,   655,   893,   955,     0,     0,
       0,   852,   649,   892,   861,   853,   892,   892,   999,  1000,
       0,     0,   593,   590,   974,   602,   953,   944,   954,   965,
     967,     0,   592,   616,     0,     0,   604,     0,   939,   981,
     982,  1007,   587,     0,     0,   629,   630,   628,   610,   617,
    1001,  1002,   588,   589,   976,     0,  1537,  1539,  1547,   595,
     594,     0,   591,     0,   952,   987,   960,     0,   627,   625,
     622,   624,   623,   626,   605,   597,   596,   599,   598,   601,
     600,   603,   949,     0,  1003,  1003,   969,     0,   637,   638,
     640,   641,  1965,     0,  1012,   971,     0,   642,   651,   643,
       0,     0,     0,   154,     0,     0,   922,     0,   147,   145,
     156,     0,     0,     0,  1485,     0,  1486,  1483,  1484,     0,
     103,   105,   459,   458,   457,   456,   428,     0,     0,     0,
    1794,   404,  2507,     0,     0,  2645,   381,   379,   380,     0,
       0,   200,   635,   636,   634,   633,     0,   467,     0,   465,
       0,   477,     0,  1886,   791,   585,     0,     0,     0,     0,
    1522,  1541,  1970,  1709,     0,  1280,  1410,     0,     0,   746,
    1387,   799,     0,  1396,     0,  1397,   727,   726,  1389,  1391,
    1395,  1393,  1246,  1254,  1327,  1249,  1248,     0,     0,     0,
    1286,  1308,     0,  1287,     0,  1378,     0,     0,  1260,     0,
    1262,     0,     0,  1342,  1311,  1333,  1289,  1315,     0,  1265,
    1241,     0,  1290,     0,  1295,  1293,     0,  1269,     0,     0,
    1276,     0,  1274,     0,  1275,     0,  1277,  1319,  1321,     0,
       0,   824,   810,   811,   812,     0,   814,   816,   818,     0,
       0,  1454,  2575,  1124,     0,     0,  1375,  1176,     0,  1185,
    1182,     0,  1179,  1154,  1347,  1337,  1614,   996,   995,  1835,
       0,  1831,   289,   284,   292,   286,   288,   287,   293,   294,
     295,   296,   290,   285,   291,   283,   282,  2512,     0,  2523,
       0,     0,     0,     0,     0,     0,  1524,     0,  1647,  1107,
    1112,  1116,     0,  1108,  1886,   502,     0,     0,     0,   522,
       0,   520,   496,     0,  1088,  1152,  1664,  1676,     0,  1684,
       0,     0,  1661,  1671,     0,     0,     0,  1670,   482,     0,
     251,     0,  2442,     0,     0,     0,  1552,  1530,     0,     0,
    1607,     0,  1602,  1145,     0,  1156,  1155,     0,  2398,  2397,
    2393,  2392,  2394,     0,     0,     0,  1757,  1759,  1753,  1048,
    1047,  1046,  1030,     0,     0,  1035,  2562,  1515,  1448,  1444,
    1416,  1444,  1427,     0,     0,  1444,  1423,  1421,  1425,     0,
    1522,     0,  1480,  1152,  1954,  1544,  1547,   397,   957,     0,
     892,   848,   849,   861,     0,   861,   861,     0,     0,   943,
       0,  1069,     0,   948,   787,   611,   980,   979,     0,   612,
       0,   941,     0,  1548,  1549,  1540,   481,   940,   962,   946,
    1852,   973,   653,  1011,   829,   721,   670,   661,   745,   664,
     663,   707,   729,   675,   725,   723,   693,   725,   725,   700,
     699,   717,   703,   683,   799,   799,   682,   720,   799,   704,
     702,   706,     0,   708,   725,   713,   701,   705,   722,   698,
     695,   719,   745,   729,   729,   679,   718,   799,     0,   711,
     745,   749,   681,   799,   806,     0,     0,   745,   747,  1964,
     155,   143,     0,     0,   924,   926,     0,     0,   927,  2617,
       0,  2619,     0,  1115,     0,    99,     0,     0,   386,   455,
     405,  2509,     0,   211,  1152,     0,     0,   201,   203,   204,
       0,     0,     0,   580,  1888,  1887,   466,   565,   586,     0,
       0,     0,  1716,  1711,  1563,     0,  1411,     0,     0,     0,
       0,   793,   804,   802,   796,     0,   800,   801,  1388,     0,
       0,  1358,     0,     0,     0,  1381,     0,     0,     0,     0,
       0,     0,     0,  1244,     0,  1338,     0,     0,     0,     0,
       0,     0,  1273,  1271,  1272,   808,  1324,     0,   821,   815,
     813,   820,     0,  1552,  2556,   895,  1181,     0,  1348,   998,
     997,     0,     0,  2513,     0,  2448,  2500,  2499,  2516,  2516,
    2516,  1689,  1688,     0,  1687,  1691,  1109,  1117,     0,   500,
     503,     0,   495,     0,   519,     0,   486,   563,     0,     0,
       0,  1685,  1673,  2553,  1662,  1665,  1959,  1443,  1489,     0,
    2439,  2440,  2438,  1136,     0,  1525,  1606,  1603,     0,  1596,
    1598,  1600,     0,  1953,  2375,  2355,  2357,  1032,     0,     0,
    1028,  1449,  1447,  1457,     0,  1412,  1444,  1444,     0,  1412,
       0,     0,     0,  1696,  1541,  1698,  1445,  1477,  1459,     0,
    1546,     0,     0,   956,     0,     0,     0,     0,     0,     0,
     986,     0,  1010,   945,   966,   988,     0,   749,  1081,  1538,
     961,   963,  1057,     0,   639,     0,   833,   669,   662,   680,
     678,   734,   724,     0,   734,   734,   689,   707,   684,     0,
     799,   697,   688,   709,   712,   714,   716,   734,     0,   799,
     677,   676,   686,   673,   734,   757,     0,     0,     0,     0,
     753,     0,   827,     0,     0,   760,   657,   750,   752,     0,
       0,   710,   799,   666,   807,   806,   668,   799,   806,   734,
       0,   748,   734,     0,   141,   146,   157,   158,   912,  2616,
       0,  2614,     0,  1111,  1487,   104,     0,     0,   214,   212,
     213,     0,   207,   209,   204,  2632,     0,  2639,     0,     0,
    2637,   468,   470,   478,   566,     0,     0,  1547,   890,     0,
       0,     0,  1707,  1281,   743,   741,   744,   742,   795,   794,
     798,     0,   797,   806,   730,     0,  1284,  1285,  1309,     0,
    1379,  1370,  1307,     0,  1261,  1339,     0,     0,  1316,  1291,
    1294,  1292,  1297,  1298,     0,  1323,     0,  1144,  1144,   631,
    2569,  1183,  1836,  1834,     0,     0,  2521,  2521,  2521,  2430,
       0,     0,     0,  1152,   508,     0,   525,   524,   521,  1552,
    1675,  1677,  1683,  1672,  2441,     0,  1526,  1541,   780,  1599,
       0,  1146,  1034,     0,     0,  1428,     0,  1432,  1437,  1433,
       0,  1424,  1422,     0,  1563,  1481,     0,  1552,  1547,   959,
       0,   652,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   985,  1929,   975,   482,   977,   942,     0,   947,
     607,     0,   832,     0,   837,   738,   739,   740,   690,   735,
     737,     0,   692,   660,   685,   715,   691,     0,   687,   674,
     763,   764,   766,   765,   762,   772,   755,   773,     0,     0,
     767,   768,   769,   761,   751,   759,   754,   665,   667,   671,
     672,   658,     0,   659,  1963,   148,   928,   317,  2618,  2626,
       0,  2628,  2621,   129,  2636,  2646,   211,     0,     0,   152,
       0,   202,   787,   205,  2553,  1886,     0,   473,   864,     0,
     889,     0,   866,   868,  1564,   805,   803,     0,  1382,  1547,
       0,  1341,  1343,   809,     0,  1455,   632,  2524,     0,     0,
    2520,  2518,     0,  2519,  2517,  2491,     0,  2446,  2447,  2445,
    1686,     0,     0,     0,   516,     0,     0,   550,   564,  1534,
    1547,     0,  1552,     0,  1604,  1597,  1036,  1450,     0,     0,
       0,     0,     0,  1695,  1469,  1470,     0,     0,  1475,  1479,
    1460,  1545,   958,     0,     0,   864,     0,     0,  1931,  1930,
     951,  1010,     0,   830,     0,   834,   835,   836,     0,   828,
     736,     0,   896,     0,   756,   758,     0,   150,   343,     0,
     329,   315,     0,     0,     0,   319,   159,   162,   160,     0,
     161,   167,     0,   168,   169,   170,   171,   172,   163,   341,
     342,   166,   164,   165,     0,  1980,     0,  1981,  1127,     0,
       0,  2624,     0,  2620,  2549,   178,   208,     0,     0,   144,
     153,  2640,   770,   471,   469,     0,  2549,     0,  1680,   113,
     865,   881,   880,   870,  1547,     0,     0,   116,   867,   883,
     874,   119,   869,   882,   872,   728,     0,  1384,  1259,  1325,
    2497,  2496,  2495,  2492,     0,     0,     0,     0,     0,     0,
    2522,  2526,     0,  1441,  1153,     0,   509,     0,   512,   514,
     528,     0,  1680,     0,     0,  1680,  1680,  1680,  1680,   543,
     551,   553,     0,  1535,  1536,     0,  1531,  1533,  1527,  1588,
     781,  1889,  2556,  1429,     0,  1434,     0,  1426,  1465,  1465,
    1476,     0,   864,   644,   866,   868,   978,     0,   831,     0,
       0,   799,     0,   799,   149,     0,   142,     0,     0,   328,
     331,     0,     0,   334,   324,   323,   325,     0,   318,   317,
     317,   371,   322,   368,   367,   360,  2627,     0,  2553,     0,
       0,     0,  2622,  2647,   210,  1152,   156,     0,   475,   474,
     879,     0,   994,   871,   888,   891,     0,   994,   875,   994,
     873,  1547,  2493,  2527,  2530,  2528,  2529,  2531,  2525,  1692,
    1700,     0,  1876,     0,   517,   510,     0,     0,   526,     0,
    1680,  1680,     0,     0,     0,     0,     0,   523,   552,  1680,
    1547,     0,  1135,     0,  1897,  1451,     0,     0,     0,  1473,
    1471,   648,   647,   645,   646,     0,   843,     0,   842,     0,
     839,   838,   694,   897,   696,   151,   344,   355,   358,   350,
     330,     0,     0,     0,   320,   317,     0,   304,   302,   303,
     309,   310,   311,   312,   313,   314,   305,   308,   306,   307,
     317,     0,   219,     0,     0,  2625,  2623,     0,  2629,     0,
     188,   187,   179,     0,   317,  2633,     0,  2641,  2553,   878,
     114,   884,   117,   120,  1383,     0,     0,   780,   504,   516,
     513,   536,   529,   532,     0,   561,     0,     0,   557,   558,
     556,   554,   547,     0,   545,     0,  1532,  1589,     0,     0,
       0,     0,  1890,  1892,     0,  1605,  1431,  1436,     0,  1466,
       0,     0,     0,   964,   845,   846,   844,     0,     0,     0,
       0,   317,   351,     0,   326,     0,   335,     0,     0,   217,
     374,   372,   215,   362,   362,  2630,  2631,   189,  2648,     0,
     158,   178,   476,  1699,  1701,  1877,   511,   536,     0,   534,
       0,   530,   527,   531,   559,   560,     0,   544,     0,   555,
       0,     0,     0,     0,     0,  1891,     0,     0,  1898,  1900,
    1468,  1467,  1482,     0,     0,     0,   352,   358,   348,   356,
     317,     0,     0,   316,     0,   370,   218,     0,     0,     0,
     317,     0,   361,   363,   365,     0,   140,  2642,  1903,   533,
       0,   541,   537,   539,   542,   550,   549,   546,  1591,  1895,
    1896,     0,  1893,     0,     0,  1899,     0,     0,   841,   840,
       0,   349,     0,     0,   347,   327,   332,   317,   375,   317,
     229,   228,     0,   221,   297,   369,     0,   220,  2634,   317,
       0,  1889,   535,     0,     0,   548,  1594,     0,  1592,  1894,
    1902,  1901,  1474,  1472,   353,     0,   317,     0,   317,     0,
     317,     0,     0,     0,     0,     0,   216,   317,  2643,     0,
    1897,   540,   538,  1590,     0,     0,   345,   317,   333,   338,
       0,     0,   224,   298,   299,     0,   226,  2635,     0,  1905,
    1593,   317,   317,   334,   337,   376,   373,     0,   300,   222,
     223,   234,   233,     0,  1904,     0,  1909,   317,   317,   339,
     242,   240,   317,   230,   238,   232,     0,   239,     0,   227,
       0,     0,  1916,     0,   225,   241,   301,  1907,  1908,  1906,
    1911,     0,     0,  1913,  1914,     0,  1878,   231,  1915,  1910,
       0,  1917,  1919,     0,  1912,     0,  1152,  1918,     0,  1153,
    1920
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3878, -3878, -3878, -3878, -3878,   192, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878,  1881, -3878, -3878, -3878, -3878, -3878,
    2081, -3878,   757, -1816, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878,   758,  1681,  3528, -3878,   492,
   -3878,   171, -3878, -3878, -3878, -2932,    46,  -141, -3878, -3878,
     403,    42,  3219,  -138, -3144, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878,   500,   508, -3878, -3878,   334, -3878,
   -3878, -1118, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  -315,
    -264,  1491, -3878, -3878, -3878,  4161, -3878,  3632, -3878, -1734,
    2384, -3878, -3878, -3878, -3878, -3878,  2449, -1670, -3878, -3878,
   -3878,  1429, -3878, -3878, -3878, -3878,  -365,   354, -3878,   356,
   -3878,   357, -3878,   358, -3878,   359,   360,   361,   363, -3878,
     365, -3878, -3878,  -254, -3878, -3878, -3878, -3878,   367, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,  -132, -3878, -3878,    13,
   -3878, -3878,  -130,   371, -3878,   -85,   373, -3878,   375, -3878,
      -3, -3878,     0, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,  3229, -3878, -3878, -3878,
   -2264, -3878, -3878, -2376,  2766, -3878, -1785, -3878, -3878, -1921,
   -3878, -3878, -1673,  -564, -3878, -3878,  1469,  -248, -3878, -1351,
   -1913, -1864, -3878, -3878, -3878, -2022, -2017, -1372, -1246, -2237,
   -3878, -3878, -3878,   366, -3878, -3878, -2576,  2191,  2764, -3878,
   -1974, -3878, -3878,  1248, -3878, -3878,  1426,   718,  1425, -3878,
    1020,  2957, -1213, -3878, -3878, -3878, -3878, -3878, -3878,    78,
     332,   -12, -3878, -3302,   723, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3877, -3878, -3878, -3878,  -173, -3878, -3878,
     -84, -3878, -3878,  -129, -3878,   183, -2309, -3878, -3878, -3878,
   -3878,  2721, -1299, -3878,  3741, -3878,  -557,   825,  2220, -2412,
   -1392, -3878,  -887,  -886, -2498, -3878, -3878, -3878, -2007,  1195,
    1605, -3878,   921,  2216, -1904, -3878,  1684, -3878, -3878,   942,
   -3878, -2763, -3878, -3878, -3878,   903, -3878,   907, -3878, -3878,
   -3878, -1158,   869, -2552,  1613,  -618, -3878,   452, -2439, -2514,
   -3878,   676, -3878,   627, -3563, -2613, -3878,  -569, -2100, -2405,
      18, -3878, -3878,   640, -3124,  1810, -3878, -3878, -3878, -3199,
   -2453,  1539, -3878, -3878,  1113, -3878, -1510,  1111, -3878, -3878,
   -3878,  1121, -3878,   196, -3878, -3878, -3878, -3878, -3011, -3878,
   -3878, -1464, -2040, -3878, -3878,  4272,  4274, -1007, -2715, -3603,
     200,   191, -3878, -3878, -3878,  2744, -1223,   269,   258,   263,
    2165,  -903,   414, -2400, -3878,   470, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  2254, -1948, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -2432, -2434, -3878, -3878,  1725, -3878, -3878, -3878,
   -1954, -1423, -1421, -1901,  -463, -2180, -3315, -3878, -3878, -3878,
   -3878, -3878, -3878,  2884, -3878, -3878, -3878, -3878, -3878,  3722,
   -3878,  2885, -3878, -3878, -3878, -3878, -3878, -3878, -3878,   698,
    1936, -3878, -3878, -3878, -3878, -3878, -3878,   985,  2782, -3878,
   -3878, -3878,     2, -3878, -3878, -3878, -3878,  2495, -3878, -3878,
   -3878, -3878,  2831, -3878, -3878, -3878, -3878, -3878, -3878,  1513,
   -3878,  1981, -3878, -1442, -3878, -3878,  1094,  -946,  1933,  3723,
    2070, -3878, -3878,  -586, -3878, -3878, -3878, -1662, -2408, -3878,
    3455,  -988, -2577,  2485,  -645, -1823,  1138,  -406,  3594, -3878,
   -1106, -1049, -3878, -3878,  -637, -3878, -3878, -3878,  -619, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
    1551, -3878, -3878, -3878, -3878, -1174, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  1340, -3878,  2163, -3878,  -499, -3878,  3235,
   -3878, -3878, -3878, -2303, -1900,  1867,  1036, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -1532, -3878, -2392, -3878,
   -3878, -3878, -3878, -3878,  2082, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -1736, -3878, -1956,   240, -3878,   388, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878,   -20,   917,   -19, -2496, -1060,
    1627, -3878, -3878, -1243,  3272, -2335, -3878, -3878, -3878,  2063,
   -3878, -3878, -3878, -3878, -3878,  1004, -2964,  2899, -3878, -3878,
   -3168,  -869, -2252,  -848, -3878, -2361,   557, -1791, -1769,  -426,
   -1419, -2413, -3878, -3878, -3878, -3878,  -116, -3878, -3878, -3878,
     572,  1956, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  -556,  -786, -3878, -3878,  2213,  2621, -3878,
    3145, -3878, -1027,  3395, -3878, -3878,  3396, -3878, -3878, -3878,
   -3878,  3076,  3054,  2024, -3878, -3878, -2367, -3878, -3878,  1982,
   -3878,   826,  -858, -1786,  1115, -3878, -3878,  1118, -3231, -3878,
   -3878,  3406, -3878, -3878, -3878,  1061, -3878,   107,  3777,  3412,
   -3878, -3878, -3878, -3878, -3878, -3878,  2811, -1014,  3705, -3878,
   -3878, -3878, -3878, -3878, -3878,  2465, -3878, -3878, -3878, -3878,
   -3878, -3878,  2998,  3795,  -571, -1266, -3878,  -595,  2969,  2466,
    -837, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878,  2644,  1044, -3878, -3878,
   -3878,  3092, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,  1173,
     -22, -3878,   120,   -50, -3878,    56, -3878, -3878, -3878, -3878,
   -3878,  -117, -3878, -3878,  -120, -3878,  -943, -1354,   767, -1212,
   -2037, -3878,  1162,  3073, -2551,  -677, -1110, -1128, -1946,    27,
   -3878, -3878,  3430,  1935,   101,   604,  -475,    -6, -2710,  -110,
    -534, -3878, -2544, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878,  1996, -3878, -3878, -3878,  1136, -3878,  3837, -3878,  2726,
    1139,  3839, -3878, -3878, -1317,  2556,  2011,  2010, -3878, -3878,
    2020, -2314, -3878, -3878,   132, -3878,  2628, -3878, -3878, -3878,
   -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,  2589,  3571,  3100, -3878,  2647, -3878, -3878,
   -3878, -3878, -3878,   379, -3878,   811, -3878, -2531,  2890,   512,
   -3878,  1218,  -713,  -934, -3878, -3878,   377, -3878, -3878,  1273,
    3859,  3577, -3878, -3878, -3878, -3878, -3878, -2758,  -843, -3878,
   -3427, -2835, -1649, -3878, -3878, -2168, -3029, -3878, -3878, -1017,
   -3878, -3878, -3878, -3878, -2054, -3878, -3878, -3878,   134,  3923,
    3924, -3878, -3878,   630, -3878,   511, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878,   433,   763, -3878, -3878,  3789, -3878, -3878,
   -3878, -3878,  3790, -3878, -3878, -3878, -3878, -3878,  3791, -3878,
   -3878, -3878, -3878, -3878,  1848, -3878, -3878, -3878, -3878, -3878,
   -3878, -3878, -3878
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   599,  1440,    57,    58,    59,    60,    61,  1290,
      62,   806,  1215,  1741,  1742,    63,   542,    64,   993,  1511,
    1512,  3049,  3050,  1513,    65,  2125,  3086,  4142,  3087,  4147,
    3088,  4149,  1530,   510,   511,  1968,  1969,  1018,  3070,  3036,
    3855,  3040,  3967,  4106,  4009,  2051,  3408,  3856,  3857,  3976,
     537,  2123,  1460,  4133,  1948,  4242,  1949,    66,   631,   991,
    1484,  1485,  3426,  3427,  3689,  3428,  3681,  3682,  3683,  3684,
    4370,  4215,  4312,  4371,  4443,  4477,  4483,  4412,  4492,  4493,
    4494,  4481,   847,  4495,    67,   565,   566,   849,  1320,  1755,
    1321,    68,    69,   536,  1235,  1236,  1237,  1238,  2301,  1756,
    2296,  2297,  3205,  4413,  4479,  4498,  4216,  4217,  4113,  4218,
    3979,  4219,  4117,  4220,  3982,  4221,  4222,  4223,  4224,  4362,
    4225,  4112,  4405,  4212,  4213,  4364,  4459,  4474,  4226,  3989,
    4107,  4299,  3990,  4108,  4357,  4208,  4358,  4400,  4455,  4209,
    4300,  4403,  4303,  4227,  4233,  4372,  4228,  4234,  4229,  3994,
    4124,  4232,  4122,  4231,  4368,  4367,  4439,  2650,  3069,   618,
     619,   642,  2115,   620,  1007,   964,  1462,  1981,  1982,  2501,
    2502,  2632,  2633,  2634,  1973,  1974,  1975,  2103,  2104,  2105,
    1955,  1956,  1957,  1466,  1952,  1953,   621,   965,   975,  1976,
    1977,  1978,  2638,  2107,  2108,  2109,  2110,  1203,  1204,  2923,
    2656,  3079,  3874,  3436,  4016,  4248,  3080,  3081,  2576,  2991,
    2061,    70,   554,   827,  1287,  2352,  1288,  2354,  2806,  2807,
    2808,  1800,  1801,  3754,  1805,  2351,  3914,  4259,  4057,  4058,
    2810,  4056,  2814,  3230,  3231,  3523,  3756,  3917,  4264,  4167,
    4332,  4262,  4328,  4263,  4330,  4424,  4382,  4383,  4177,  4273,
    4274,  4336,  4385,  4069,  4070,  4071,  2372,  2820,  3759,  3695,
    2097,  1452,  1453,   512,   513,   514,   639,  2657,  2036,  2658,
    2659,  3013,  2038,  2039,  2777,  1375,  3004,  2978,  3737,  3076,
    3017,  3018,  3019,  3020,  3021,  3027,  2942,  2511,  2512,  2581,
    3030,  3872,  3613,  3628,  3392,  3393,  3394,  3395,  3396,  3397,
    3398,  3105,  3106,  3103,  1066,  3818,  3819,  3820,  3099,  3100,
    3662,  3646,  3647,  3648,  3873,   769,  3836,  3455,  1343,  1344,
    3924,  1354,  1355,  2396,  1841,  2397,  1456,  3456,  3457,  3458,
    3656,  3160,  3734,  3166,  3167,  3168,  2740,  2741,  2742,  2743,
    2744,  2240,  3649,  3029,  3606,  3811,  3814,  3959,  4200,  2513,
    2943,  2514,  2946,   915,   515,  2515,  2516,  1544,  1545,  4019,
    4027,  4031,  4020,  4032,  4028,  4021,  4022,  4023,  4034,  4030,
    2663,  3696,  3697,  2935,  3176,  3961,    71,  1472,   958,   967,
     963,   983,   626,  1473,   976,  2052,  2587,  3668,   608,  2040,
    3598,  3321,  3602,  2041,  2957,  2042,  3308,  3583,  2043,  3338,
    3600,  3808,  2958,  2959,  2044,  2045,  2046,  3320,  3330,  3951,
    3186,  3187,  3188,  2517,   125,  2288,  3025,  2560,    72,  1418,
      73,   929,   930,   931,  2446,  2447,  2889,  3285,  3560,   924,
     925,   926,  1914,  2444,    74,   634,  1517,    75,  1298,  2364,
    2365,  2366,    76,   984,    77,    78,   635,  1524,  1525,  1526,
      79,  1283,   132,    80,   835,  1293,  1295,  1296,    81,   630,
     985,   986,   987,   988,  2057,    82,  1792,  2328,  2329,  2330,
    2331,  1481,  2589,  1482,  1483,  2066,  3223,    83,    84,   596,
    2248,   571,   853,   572,   573,  1835,  2387,  3738,   864,   865,
     866,  2848,  1333,  1334,  1335,  2392,  2853,  1063,   770,   771,
     772,   773,  1157,  1158,  3650,   774,  1167,  1702,   775,   776,
     777,   778,   779,   780,  1729,  3132,  3133,  3475,  2275,  2276,
    2277,   781,  2162,  3117,  2176,   782,  1150,  1687,  1618,  3467,
    3125,  3719,  3888,  1561,  2145,  2693,  2773,  2242,  1088,  1089,
    1053,  2152,  1567,  1921,  1922,  1923,  1924,  1925,  3571,  3570,
    3572,  3928,  3776,  3930,  3780,  2457,  1820,  1821,  1926,  1927,
    2890,  3774,  4082,  2243,  2244,  2245,  3493,  2891,  3289,  2909,
    2910,  3787,  2448,  1928,  2897,  4189,  3937,  3938,  4292,  4291,
    3939,  3785,  3786,  3576,  3577,  3045,  3046,  3047,  2834,  1608,
    1609,  1616,  1270,  1271,  1562,  2326,  2795,  3767,  3921,  2266,
    3545,  3919,  4076,  2049,  2986,  2987,  2389,  2390,  2913,  3305,
    3335,  1378,  3739,  2797,  1887,  1888,  3702,  4482,  2745,  2605,
    2924,  2348,  2349,  4182,  4340,  4427,  4428,  3260,  3261,  3549,
    3550,  2391,  2845,  3262,  3768,  4081,    85,   519,    86,  1739,
    2281,  2776,  1212,  2293,   995,  1300,  1548,  1549,   794,   532,
    1205,  1206,  1207,    87,   543,  2327,    88,   561,  1818,   819,
     839,  1301,  1302,  2373,  2821,  2828,  2374,  2833,  3533,  2823,
    3236,  3237,  2283,  2284,  2824,  3239,  3530,  3513,  3514,  3218,
    3751,    89,   584,  3300,  2904,  2905,  4159,  4160,   840,    90,
     518,  1040,  2671,  1554,  2133,  1041,  1042,  2136,   660,   661,
      91,   933,   581,  1400,  1401,  1402,  1903,    92,   575,   916,
    2875,  2881,  1882,   831,  1208,  1382,   919,  1383,  1868,  2425,
    1364,    93,   954,   953,  1447,    94,   604,  1448,    95,   807,
    1229,  1751,  2781,  3191,  3501,  1230,  1231,  2294,    96,   562,
     844,   845,  1305,  1823,    97,   556,   832,  1811,    98,   547,
      99,   100,   823,  3224,  4257,  4378,   551,  1794,  1279,  3437,
    4184,  4282,  4283,  4285,  4348,  4349,  4421,  4486,  4509,  4502,
    4512,  4513,  4516,  4521,  4522,   784,   940,   785,  3802,   786,
     787,   788,  2829,  2830,  3306,   789,  2831,   790,  2936,   996,
    1551,   540,   490,  2594,   615,   941,  2803,   792,  3996,   961,
    1011,   492,   493,   101,   574,   880,  1359,  1349,  1358,  1861,
    2413,  1865,  2415,  2416,  3274,  2871,  3275,  2872,   920,  1857,
    1862,  2873,  1866,  2867,   883,  1850,  1851,  1852,  1853,  2864,
    1847,  2422,   102,   824,   497,  1281,  1282,  2337,   103,   583,
     104,  1272,  1788,  1789,  2323,  2794,  2324,   105,   850,  1324,
     106,   809,  1264,  2312,  1265,  1764,  1266,  1267,  1778,  1772,
    1781,  1775,  4044,  3904,  3905,  2791,  1211,  1012,  1013,  2304,
    2785,  2786,  3746,  3907,  3505,  4050,  4051,   107,   133,   500,
     637,  1002,  1327,   108,   109,   110,   111,  1330,  1435,  2383,
    1436,  2249,  1437,  1438,  1935,  1833,  1683,  1684,  3174,  1147,
    1148,  2252,  2749,  2750,   867,   646,  1028,  1020,   126,   127,
     128,   649,   650,   129,   981,   982,  2588,  3042,  3410,  3671,
    3672,  3861,  4004,  4000,  4001,  3998,  4003,  1022,  3868,  4319,
    4447,  1023,  1024,  3071,  3870,  4137,  4321,  4419,  1025,  2647,
    3423,  4005,  4244,   112,   942,   593,  1433,  1428,  1430,  1931,
    2464,   113,   114
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     491,  1005,  1019,  1027,   918,   878,   914,  1442,   947,  1671,
    1331,  1449,   617,   533,  2393,  1345,  1348,   541,  2134,  2065,
     783,  1758,   534,  1889,  1623,  1360,   555,  1670,  1090,  1556,
    1546,  1547,   553,   567,  2250,  2347,   570,  1795,   560,  2062,
     567,  1863,  2972,  1379,  1407,  2553,  1048,   585,   489,  2047,
     539,  2048,  1373,  2619,  1693,  2694,  3288,  1587,  1645,  1757,
    2696,  1701,  2827,  2915,  2902,  1379,  2925,  2878,  2879,  2504,
    3575,  1454,  1455,  1803,  2796,  3247,   962,  1408,   994,   997,
    2037,  3083,  2510,  2755,  2925,  2925,  2295,  2519,   606,   977,
    1959,  2523,  2377,  2639,  1979,  1035,  1979,  2443,  2640,  2582,
    2869,  2882,  2538,  2968,  3404,   135,  3763,  2973,  1268,  2779,
     609,  1958,   491,  2944,  2549,   491,   616,   622,  2505,  1703,
    1704,   605,  1896,  1707,  1708,  1709,  1710,  3444,  1712,  1713,
    1715,  1717,  1718,  1719,  1720,  1721,  1185,  2850,  3580,  3110,
    1906,   498,  1143,  1144,  1145,  3494,  2893,  1424,  1909,  1910,
    3654,  2467,  2468,  1936,  2903,  1186,  2116,  1152,  1153,  2111,
     611,   552,  3162,   613,  1971,  3616,  3621,   559,  2479,  3622,
    1268,  3101,  3171,  2388,  2492,  3108,  1152,  1153,  1798,  1735,
    2106,  3623,  2557,  2628,  1779,  2497,  2498,  4043,  3632,  2500,
    1971,  2751,  2461,  2150,  3653,  4301,   636,  1384,  3709,  2286,
    3595,  2518,  2636,  2843,  2521,  2522,  -472,  2524,  4099,  1412,
    2527,  2528,  2925,  2925,  2531,  3898,  1960,  4301,  1776,  2540,
    1980,   812,  1980,  1809,  2544,  2545,  2546,  2547,  2548,  3314,
    2584,  2286,  2552,  3451,  2554,   885,   869,  2933,  2673,  4278,
    2563,  2564,  2565,  2566,  1269,  3452,  2570,  3085,  2572,  3107,
    4279,  2637,  3581,  1152,  1153,  1187,  3209,  3061,  4119,  3453,
    2929,  2930,  2938,   627,   628,  1404,   115,  3391,  3163,  1210,
     885,   869, -2558,  3270,  1064,  2334,  3434,  3804, -1966,  2593,
    3790,  2596,  2597,  2481,   545,  2112,  3955,  2607,  2608,  1579,
    2428,  4017,   927, -1794,  1451,  3745,  2616,  2617,  3761,  2938,
    1294,  2621, -1518,  1987,  1152,  1153,  1269,  3252,  1451,  4507,
    1152,  1153,  1879,  2623,  2624,  2625,  2626,   548,  2558,  1451,
    1409, -2494,  3451,  1518,  1277,  -901,  3023,   657,  2019,  2975,
    1152,  1153,  1015,  2153,  3452,  4017,  3091,  1431,  3093,  -567,
    2876,  2653,  4093,   134,  1152,  1153,  1134,  2265,  3453,  2567,
    -568,   937,  1152,  1153,  1130,  2237,  1274,  1152,  1153,   885,
    3617,  4110, -2343,  1284,  3333, -1994,  1285,  1954,  1854, -1518,
    1536,  1537,  1538,  2299,  1880,  2053,  2022,   117,  1152,  1153,
    1152,  1153, -2558,  2846,  4329,   130,   658,  4333,  3054,  3055,
    1152,  1153,  1008,  1954,   641,  3032,  1586,  2385,  3899,   922,
    1152,  1153,  1416,  2976,  1539,  3162,  1467,  1468,  3286,   134,
    1090,  2335,  3235,  3451,  2738,  1389,  3038,  4120,   136,  1380,
    2063,  3824,  1070,  2939,  4346,  3452,  1152,  1153,  1477,  3447,
    3828,  3039,   815,  1514,  1540,  1289,   549,  1519,  1855,  3453,
    2739,  1520,  3033,   568,  4134,  2064,  1533,  4013,  2746,  1972,
     885,   869,  1521,  3847,   499,  1152,  1153,  4347,  3849,  3242,
    1152,  1153,  4280,  3287,  1152,  1153,  4018,  3189,  1381,  2847,
    3334,  1377,   131,  1425,  2300,  1972,  2947,  2214,   923,  1612,
    3956,  1417,  1613,  1929,   928,  2844,  1535,  1152,  1153,  4192,
    2054,  1152,  1153,  1858,  3435,  1201,  3582,  3024,   616,  2901,
     622,  4508,  3303,  4422,  2977, -1518,  3292,  1071,  3256,  3257,
    4018,  3163,  1286,  1154,  1152,  1153,  1155,   797,   659,  3910,
    4111,   622,  1152,  1153,  1278,   938,  1698,   623,  1131,  3880,
     632,  1918,   810,  2568, -2343, -2131,   616,  1432,   820,  2537,
    2410,  1152,  1153,  3313,  1413,  1891,  3315,  3316,  1894,   814,
    1198,   833,  1706,  1898,  1458,  1881,  1759,  1570,  1571,  3324,
    2429,  1188,  1580, -2153,  2012,  1454,  1455,  3597,   879,  1727,
    1405,  2361,   813,  2950,  4247,  2574,   934,  2954,  1611,  1911,
    1912,  3957,  2994,  1522,  1959,  1329,  4121,  1625,  2504,  3448,
    1934,  2970,  2971,  3164,   951,  2287,  2238,  3317,  3586,  1638,
    1639,  1640,  1979,  2984,   616,  1958,   966,  1644,  2336,  1154,
    3784,  2639,  1155,   546,  1758,  2585,  2640,   616,   606,   491,
    3941,  1152,  1153,  3012,   606,  3026,   992,  2287,   606,   606,
     645,  2503,  2582,  1006,   966,  4281,  4096,  2505,   616,  2940,
    1777,  2436,  1856,  1454,  1455,  2037,  2925,  1385,  1036,  1037,
    1038,   978,  1757,  2151,  1043,  4207,  1738,   989,  3527,  3740,
    1154,   911,  2267,  1155,   805,  4100,  1154,   979,  3307,  1155,
    3449,  2911,  3438,  2270,  1515,  1414,  2273,  4356,  1523,  3902,
    1780,  3508,  3509,  3510,  3420,   825,  1154, -1994,  2264,  1155,
    1200,  -472,   836,  1919,  1152,  1153,  3172,  1920,  1415,  1091,
    1154,  4236, -1518,  1155,  1152,  1153,  3056,  2282,  1154,  2582,
    1960,  1155,  2892,  1154,  2931,   935,  1155,  3624,  2117,  2559,
    2636,  4037,  3540,  3541,  3542,  1016,  3578,  1797,  1980,  2851,
    2094,  2953,  2111,  2955,  1154,   851,  1154,  1155,  1799,  1155,
    2966,  1202,  1816,  2641,  2965,  3927,  1154,  3098,  4012,  1155,
    1810,  3710,  4077,  2106,  2979,  3443,  1154,  2974,  1156,  1155,
    1149,  2990,  1151,  1346,  2635,  3165,  3271,  1351,  1356,  2637,
    3090,  3432,  2499,  3006,  3008,  3010,  2253,  1156, -2494,  3011,
    1376,  1516,  1154,  1033,  2877,  1155,  3454, -1518,  1194,   491,
    1196,  3327,   966,   491,   616,  4195,   491,   616,  2932,  1936,
    3610,  3051,  1239,  3922,  1152,  1153, -2494,  2927,  1273,  1872,
    -901,  1154,  2362,  1843,  1155,  2941,  1154,  1908,   606,  1155,
    1154,  4322,  3419,  1155,  -567,  4026,  2126,   550,   616,   606,
     980,  3630,  3631,   606,  3609,  -568,  3164,  1195,  1152,  1153,
    3898,  1199,  1441,  1154,  1209,  3059,  1155,  1154, -1994,  2127,
    1155,  1280,  1895,  2600,  1156,  3053,  4144, -2131,  2112,  1152,
    1153,   939,  1297, -2271,  1132,  1390,  1303,   616,  3629,  2642,
    1154,   616,   616,  1155,  4196,  3454,  3634,  3534,  1154,  3450,
    4464,  1155,  1017,  3659,   616, -2153,  1362,  1938,  3594,  3190,
    2801, -1794,  1152,  1153,  1516,  3618,  3389,  1154,  1516,  3565,
    1155,  3312,  4202,  3569,  4204,  1156,  3601,  3607,  3608,  4331,
    3585,  1156,   644,  1152,  1153,  3107,  2160,  2601,  3107,  3107,
    2215,  1614, -2610,  2361,  1615,  1678,  1679,   606,  2908,  1291,
   -1478,  1156,  2827,   803,  3318,  3107,  1984,  4010, -1821,  1232,
    1152,  1153,  3124,  3293,  3294,  1156,   616,  3183,  1450,  3633,
   -1794,  2186,  3447,  1156,  3652,  3655,  3657,  3658,  1156,  3554,
    2161,   834,  1341,  1152,  1153,  3574,  3454, -1478,  2239,  1152,
    1153,  3258,  1678,  2180,   998,   687,  3066,  1154,   606,  1156,
    1155,  1156,  2122,  4254,  2660,  2399,  2363,  3227,  3564,  4241,
    3651,  1156,  3568,  2218,  2219,  2235,  2236,  4017,  1152,  1153,
    1169,  1156,   829,  3319,  3543,  2414,  2141,  3471,  3764,  1187,
     535,  3434,  4276,  2602,  1722,  2760,  2761,  1971, -2131,  2504,
    2309,  3326,  3098,  3899,  1954,  4324,  3835,  1156,  3788,   606,
    2257, -2423,  1516,  1552,  2432,  1152,  1153,  3331,  2639,   692,
    1688,  3121,  3122,  2640, -1821,  3337, -2153,  3232, -1794,  3339,
    1154,  2945,  2945,  1155,  1950,  1379,  1156, -2424,  2918,  2430,
    1154,  1156,  1543,  1155,  2466,  1156,  1550,  1091,  2505,  2435,
    3281,  2159,  2438,  2439,  1889,  1889,  2166,  1726,  1377,  3128,
    3129,  1091,  3067,  3143,  2274,  1379,  1152,  1153,  1156,  4201,
    1152,  1153,  1156,  1201,  2603,  3412,  1152,  1153,  4295,  1122,
    1152,  1153,  3250,  2167,  3934,  2272,  3145,  3146,  1959,  4129,
    2510,   494,  3448,  2295,  2538,  1156,   544,  3875,  3561,  4130,
    1152,  1153,  1954,  1156,  1760,  3034,  2675,  1979,  3900,  1958,
    2173,  1672,  1126,   837,  1941,   704,  2711,  3180,  3181,  2815,
     651,  3935,  1156, -2423,   616,  2661,  1341,  2636,  1942,  1759,
    2503,  2047,  1201,  2048,  2340,  1000,  2759,  2178,  1021,  1029,
    1154,  1152,  1153,  1155,  2362, -2558,  1152,  1153,  3889, -2424,
    1420,  2883,  4018,  2919,  3777,  3778,   557,  1347,  4197,  1808,
    2403,   616,  2037,  2289,  1123, -2271,  1730,  1848,  1932,   841,
     579,   606,  3323,  3460,  1154,  1172,  2637,  1155,   955,  1152,
    1153,  1189,  3848,  2285,  1951,  3850,   606,  3259,  2764,  2765,
    2380,  1454,  1455,  2258,  3920,  1154,   720,  1127,  1155,  1954,
    1954,  1723,  1156,  1806,  1732,  3964,  4327,  1091,   616,  3435,
    1363,  2310,  1001,  4241,  1960,  1152,  1153,  2179,   580, -1822,
    2305,  1971,  2250,  1671,  2758,  1724,  4132,  4185,  1154,  2450,
    1201,  1155, -1821,  1980,  2768,  2111,  1152,  1153,  4139,   911,
    3886,  2641,  4114,  4115,  1784,  3035,  1787,  1807,   606,  1154,
    4198,   830,  1155,   999,  3537, -2558,  2106,   606,  2357,  2358,
    1034, -1821,  2635,   616,  1342,  1152,  1153,  3932,  3901,  3072,
     838,  2811,   606,   606,  2379,  1156,  1154,  4529,   842,  1155,
    4199,  1303,  1972,  2604,  3902,  1156,  3472,  1559,  1152,  1153,
    2182,  2341,  1943,  3997,   569,  1188,  1152,  1153,   911,  1154,
    2194,  1830,  1155,  1152,  1153,  1154,  1303,  4131,  1155,  1838,
    1671,   582,  1839, -1478,  2229,  4296,  1152,  1153,  2363,  1202,
    3884,   616,  2898,  4398,  4399, -1822, -2271,  1201,  2906,  1940,
    1961,  1859,   879,  2899,  1154,  3713,  2099,  1155,  3221,  1849,
    1559,   491,   491,   491,   606,   491,   606,  2311,  1152,  1153,
   -1794,  1890,  2730,   843,  2582,  2342,  1791,  1892,   491,  3492,
     616,  2112,  2451,   491,  1152,  1153,  3877,  2642,  1190,  1944,
    3485,  1154,  3903,  2684,  1155, -1821,  2582,  1876,  1202,  1878,
    2662,  2452,  3450,   606,  1268,  1156,   629,  3073,  1725,  1873,
    1874,  1875,  2453,  1877,  1945,   597,   911,  1421,  2259,  2685,
    2201,  2381,   956,  1671,   594,   749,  1893,  2404,  3997,  3997,
    1560,  1897,  1201,  3068,  2260, -1794,  1907,  1152,  1153,  1156,
    1559,  2988,  1154, -1821,  1954,  1155,  1154,  3840,   957,  1155,
     598,  1307,  1154,   616,  2205,  1155,  1154,  3521,  1962,  1155,
    1156,  3841,   600,  1869,   616,  1152,  1153,  2686,  1342,   606,
    2687,  2920,  2058,   606,  1946,  2206,  1154,  2945,  2688,  1155,
   -1518,  1152,  1153,  1575,  1366,  4151, -2423,  1152,  1153,  1181,
    1182,  1183,  1184,  1156,  1476,  2454,  1202,  1152,  1153,  1152,
    1153,  3522,  2055,  1152,  1153,   612,  2060,  3936,  2208,  1954,
     606,  1016, -2424,   911,  1156, -1716, -2423,  1154,  4080,  1681,
    1155,    13,  1154,  2643,  4180,  1155,  1972,  2480,  3144,   616,
     564,   491,   491,  1559,  2124,   491, -1518,   564,  2385,  2126,
    1269,  1156, -2424,  1367,  1542,  1152,  1153,  1043,  2900,  2140,
     607,  2537,  2921, -1822,  2454,  1154,  2209,  2311,  1155, -1716,
    1152,  1153,  2127,  1630,  1156,  2135,  1970,  4015,  1947, -1518,
    1156, -1518,  1201,  1368,  3678,  3997,  3997,  3297,  2142,  2120,
    2121,  2503, -1822,  3679,  2386,  2213,   595, -1518,  4186,  3074,
    4187,  1154, -1518,  1202,  1155,   610,  1152,  1153,   911,  1156,
    1152,  1153,  1971,  4373,  4373,   624, -1518,  2455,  1152,  1153,
    2732,  3885,  1154, -1518,  2231,  1155,   980,   577,  1152,  1153,
   -1518,   625,  1091,  2187,  1758,  3051,  1963,    25,  1152,  1153,
    2290,  2100, -1518,  1152,  1153,  1964,  1156,  1201,  1152,  1153,
    2246,  1154,  1965, -1518,  1155,  3842,  2763,   117, -1518,  1152,
    1153,  3126,  1559,    43,  4288,  3488,  1634, -1518,  3092,  3490,
    3179,  2278,  1757,  2698,  1154,  3302,  1918,  1155,  1017,  2279,
    4079,  3997,  1154,  1152,  1153,  1155,  2456,  2705,  1202,  1154,
    2644,  1682,  1155,  2256,  1152,  1153,  3997,  1156,  2641,   578,
    3859,  1156,  1154,  1671,  3075,  1155, -1822,  1156,  2367,  4289,
    3997,  1156,  3127,  2689,  2101,   255,  3138,   257, -2610,  2635,
    2720,  3238,  3148,  1152,  1153,  3504,  3149,  1152,  1153,  1152,
    1153,  1156,  1932,  3680,  1154,  2280, -1518,  1155,  1152,  1153,
    2398,   616,  2861,   606,   616,  3859,  3723,  1966,   911,  1535,
    1154,  1539,   633,  1155, -1822,   606,   636,  1152,  1153, -1518,
    1239,  1831,  3918,  2862,  2155,  1239,  1918,  3997, -1518,  2925,
    2925,  2922,  1156,  3948,  3949,  3500,  3499,  1156,   616,  3997,
    3997,  1541,  1152,  1153,  2367,  1658,  2230,  4339,  2801,  2774,
    3940,  2154,  1152,  1153,  1369,   816,   606,  2863, -1518,  3290,
     606,  1152,  1153,  1154,  1003,  1004,  1155,  2156,  1189,  1048,
    1156,  3298,  2247,   911,  3678,  1954,   616,   616,   606,   606,
    1152,  1153,  3789,  3679,  2642,    55,  3997,   969,  1202,  2332,
    1091,  1154,   616,  1280,  1155,  4290,  3997,   632,  1919,  1493,
    1494,  3950,  1967,   640,   616,    37,  1156,  1154, -1518,   638,
    1155,  1297,  2360,  1154,  2690,  2250,  1155,   878,  1844,  1391,
    2158,   879,  3860,  1154,  2102,  1154,  1155,  1156,  1155,  1154,
    3876, -1518,  1155,  3997,    43,  3997,  2427,   970,  1152,  1153,
    2181,  2168,   817,  1845,  1832,  3997,  4444,  3703,  1392,  1152,
    1153,  1152,  1153,  1202,  2648,  4060,  1156,  1972,  1152,  1153,
    1152,  1153,  3997,   652,  3997,  4445,  3997,  3999,  2369,  2370,
    2169,  1154,   606,  3997,  1155,  2649,  4061, -1518,  2181,  1156,
     654,  2356,  2691,  3997,  2449,  3729,  1154,  1156,  1919,  1155,
    1370,   606,  1920,  2177,  1156,   507,  1393,  3997,  3997,  1971,
    1394,  2190,   655,  1201,   808,  2437,  3241,  1156,  2191,   656,
    2692,  1371,   818,  3997,  3997,  3894,  1152,  1153,  3997,   798,
     971,  2195,  1154,  3680,  2460,  1155,  1154,  3815,  1863,  1155,
    2964, -1518,  2157,  1189,  1154,  1152,  1153,  1155,  2423,  1156,
    1509,  1510, -1518, -1518,  1154,   643,  -206,  1155,    52,  2099,
    2278,  1372,   793,  2199,  1154,  1156,  2262,  1155,  3267,  1154,
    1331, -1518,  1155, -1518,  1154,  3831,   801,  1155,  2874,  2200,
    1152,  1153,   811,  2629,  1766,  1154,  3276,  2645,  1155,  3273,
    2174,  1189,  3277,  4073,  4074,   822, -1518, -1518,  3832,   826,
   -1518, -1518,  1152,  1153,   828,  2569,    55,  1379,   495,  1154,
    1846,   496,  1155,  1379,  3445,   846,  4075,   848,  1156,  2583,
    1154,   838,  2470,  1155,  3562,  1346,  3278,   949,  3301,   950,
    1346,  2477,  2478,  3816,   952,  3833,  1152,  1153,  3462,  3463,
    1152,  1153,  2482,  2483,  2484,  2485,  1156,  2493,  2494,  1154,
    2486,   495,  1155,  1154,   496,  1154,  1155,  2631,  1155,  1395,
    2204,  3477,  1156,   814,  1154,  1767, -1716,  1155,  1156,   959,
    1768,   586,  2680,  3817,  3625,  2952,  2207,  3626,  1156,   911,
    1156,  4045,  2210,  1154,  1156,  1169,  1155,   616,   980,  2450,
     968,   616,  2222,  2646,  2241,  1010,   491,  1671,  3095,  2734,
     558,  2982,  2983,   606,   606,   606,  2669,  2274,  1154,  2672,
   -1716,  1155,  1954,  1769,  2487,   990,  2674,   587,  1154,  2183,
    1189,  1155,   885,   869,  2756,  1009,  1156,  1154,  1770,   616,
    1155,  2766,  1937,   115,   616,  1396,  2665,  2666,  2667,  1759,
    3114,  1156,  2488,   972,  2651,  3097,  1154,  2184,  1628,  1155,
    1045,  1671,  2595,   854,  2778,  2595,  2595,  1014,  2595,  1202,
    1046,  2595,  2595,  2595,  2595,  2595,  2595,  2595,  4250,  2906,
    2595,  1189,  2595,  4252,  1047,  4253,  3611,  1156,  1518,  3614,
    3615,  1156,  2196,  1189,  1671,  2197,  1189,  4046,  4047,  1156,
     588,  3120,  4048,  4049,  1972,  3123,  3627,  1049,  1397,  1156,
    2198,  1189,  2988,  3130,  1154,  1050,   973,  1155,   974,  1156,
    2489,  4163,  4141,  3134,  1156,  1154,  1051,  1154,  1155,  1156,
    1155,  1054,  2451,  3135,  1154,  1055,  1154,  1155,   616,  1155,
    1156,  2202,  1189,  3136,  2100,  4154,  4155,  4156,  4157,  1056,
    1201,  2452,  3178,   939,  3137,  1276,  4062,  1057,  1694,  1058,
    1169,  1059,  2453,  2775,  1156,  1060,  4169,  1197,   616,  4172,
    4173,  4174,  4175,  1061,  3234,  1156,  4164,  2306,  3139,  2507,
    2307,  1152,  1153,  2308,  2495,  2496,   855,  2784,  4063,  3142,
    1172,  1062,  1154,  2790,  2790,  1155,  2790,  1065,  3588,  3589,
    1067,  2490,  1519,  1068,  1156,  1193,  1520,  1069,  1156,  1072,
    1156,  1154,  2748,  1189,  1155,   885,   869,  1521,  3147,  1156,
    1398,  1102,  3150,  2809,  3152,  1073,  2789,  2789,  1074,  2789,
    3140,  1189,  3664,  3154,  1192, -1794,  1075,  1889,  1156,  1076,
    4249,  3207,  3208,  1121,  1077,  2454,  1154,  2398,  1346,  1155,
    1078,  2099,  3156,  3244,  3245,  2832,  1135,  1136,   119,  2835,
    1399,   856,  1079,  1156,  2790,  2790,  2790,  1292,  1154,  3803,
    3529,  1155,  1080,  1156,  4266,  4267,  2855,  3157,  2857,  1563,
    1564,  1565,  1156,  4275,  1268,  3248,  3249,  3158,  3415,  3416,
    1671,  1576,  1081,  2534,  1082,  4270,  3482,  2789,  2789,  2789,
     879,  1156,  1154,  3496,  1189,  1155,  1154,  4064,  3238,  1155,
    3524,  3525,  1890,  1890,  1214,  3483,   911,  3803,  3092,  1085,
    2778,  1086,  1631,  2250,  1275,  1635,   943,   944,  1971,   945,
   -1794,   946,  1092,  2063,  2341,  1003,  1004,  1093,  1174,  1175,
     563,  1695,  1672,  3669,  3670,  1094,  1654,  1655,  1522,   589,
    1659,   616,   616,  3706,  3715,  1172,  1168,  2455,  2064,  1156,
   -1518,  1095,  4088,  4089,  3724,  1189,  -653,  1096,  1673,  1674,
    1156,   590,  1156,  3484,  3741,  1189,  2507,  1097,  2099,  1156,
    1098,  1156,  1099,  2854,  3718,  1304,  3722,  3749,  3750,  2508,
    4065,  2099,  2583,  3728,  1326,  3730,  1202,  2583,  2342,  1100,
     115,  2937,  2949,  2583,  1954,   591,  1103,  2583,  4066,  2960,
    2491,  4162,  2951,  3720,  3863,  2496, -1518,  1104,  2961,  2960,
    1269,  2583,  2583,  1105,   616,  2960,  2456,  3699,  3700,  1106,
    2981,  4067,  1107,  2583,   255,  1672,   257,  1156,  3878,  3879,
    3882,  3879,  2985,  1523,   606,  3883,  3879,  2993,  3942,  3525,
    1306, -1518,  1108,  2996,  2997,  2960,  1156, -1794,  3945,  3879,
    1109,  1169,  2583,  3022,   592,  3953,  3954, -1518,  4087,  3249,
    3731,  1110, -1518,  1329,  3048,  1111,  2631,  2995,  4091,  3879,
    1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,  4092,  3879,
    -653,  1156,   116, -1518,  2920,  1112,   502,  4094,  3879,   854,
   -1518,  4095,  3879,  1174,  1175,  3732,  4101,  4102,  1113,  2536,
    1114,   117, -1518,  1156,  1169,  1115,  1493,  1494,  2962,  2963,
    3470,  4103,  4102, -1518,  1116,  2341,  2100,  3733, -1518,  1117,
    2063,  1954,  1201,  1118,  2486,  1990,  1991, -1518,   606,  2583,
    4165,  4166,  1119,   666,  1954,  2992,  1696,  1156,  1120,  4029,
    4033,  1156,  1124,   857,   858,  2064,   860,  2998,   862,  2999,
    1332,  3791,  1697,  1170,  1337,  4038,  1159,  1160,  -791,  -791,
    1993,  3077,  3497,   863,  3794,  2921,  4286,  3249,  -791,  1125,
    2450,   118,  1128,  1971,  1996,  1129,  2367,  1171,  1133,  2342,
    4287,  3249,  1997,  1137,  2368,   878,  4530,  1138,  2487,  2101,
    3000,  4293,  3525,   911,  1161,  1139, -1518,  4337,  4338,  1140,
     119,  4379,  4380,  1972,  3052,  1162,  1999,  2343,  3797,  4068,
    4433,  3414,   855,  3001,  1141,   687,  2488,  4472,  4473, -1518,
    1451,  1142,  3635,  2099,  2000,  4519,  4520,  1191, -1518,  3895,
    3896,  1661,  1662,  4268,  4269,  1177,  1178,  1179,  1180,  1181,
    1182,  1183,  1184,  2100,  1163,  1338,  1172,  1509,  1510,  1201,
    3002,  2486,   120,  2005,  2989,  1164,  2100,  1239, -1518,  3685,
    -653,   616,  1201,  3546,  3547,  3636,  1003,  1004,  1357,  3637,
    2507,  3638,   691,   606,  1361,  2344,  3747,  3748,  1365,   692,
    2509,  1377,  1165,  2508,  2489,  4029,  1387,   856,   911,  4033,
    1169,  2809,   616,  3908,  3909,  1672,  -653,  1386,  1388,  1172,
    2369,  2370, -1794,  2451,  1403,  1406,  3220,   697, -1518,  1410,
    1091,  1411,   616,  1592,  1419,  2487,  1422,  3639,  2440,  2441,
    2442,  2631,  2452,  1423,  1426,  2009,  3266,  1427,  1429,  2101,
    1434, -1518,  2010,  2453,  1346,  1439,  1451,  1457,  2371,  2102,
    1173,  1459,  1461,  2488,  2811,  1464,  1166,  1465,  2507,  2011,
    1469,  4029,  4033,  1990,  1991,  1470,  2345,  1471,  3962,  1474,
    1475,  1478,  1479,  3711,  3962,  2490,  1480,  1527,  1202,  3943,
    3944,  1169,  3946,  3947,  2922,   704,  1954, -1518,  1528,  1529,
    2143,  1532,   121,  1534,  -653,  1535,  -791,  -791,  1993,   505,
     502,  1553,  1555,  1187,  1174,  1175,  -791,  1559,  1566,  2627,
    1617,  1578,  1996,  1581,  1671,  1627,  1628,  1176,  2013,  1629,
    1997,  2489,  1652,  1669,  1596,   911,  2454,  2583,  1680,  1705,
    2583,  2583,  4161,  1689,  2063,  2960,  2014,  1734,   911,  1711,
    1731, -1518,   666,  3265,  1999,  1736,  1737,  1740,   616,  3775,
     715,  2583,  1743, -1518,  1744,  1745,  1746,  -826,  1451,  2064,
    2188,   718,  2000,   122,  2192,   719,   720,  1747,  1972,  2960,
    1748, -1518,  2534, -1518,  1749,  3279,  3280,  2960,  3282,  1750,
    1761,  2960,  -653,  2203,  1762,  1763,  3822,  3823,  2216,  2102,
    2018,  2005,  4230,  1765,  1771,  1172, -1518, -1518,  2020,  3826,
   -1518, -1518,  2490,  3003,  1169,  1202,  3829,  3343,  2100,  1773,
     606,  1774,  2063,  1782,  1201,  3399,  1783,  3797,  1202,  1793,
    1796,   491,  1804,  1812,   687,  3409,   123,  2960, -1005,  1597,
    1813,  3851,  1814,  1600,  3853,  1819,  3060,  2064,  2455,  1815,
    1601,  1822,  3418,  3344,  1825,  1826,  1177,  1178,  1179,  1180,
    1181,  1182,  1183,  1184,  1828,  3429,  3325,  1829,  1003,  1004,
    1834,  1840,   606,  2009,  3640,  3329,  1864,  1871,  2026,  3405,
    2010,  3641,  1867,  3442,   124,  2346,  1172,  1899,  1900,  1901,
    1902,   691,  1904,  1913,  2491,  1916,  1930,  2011,   692,   857,
     858,   859,   860,   861,   862,  3431,  1939,  1985,  3913,  2050,
    2654,  1179,  1180,  1181,  1182,  1183,  1184,  2456,  3642,   863,
    -653,  2792,  1516,  2793,  2068,  2450,   697,  1671,  1602,  2067,
    2114,  2069,  2070,  2071,  2027,  2028,  2029,  2072,  2073,  2074,
    2075,  2030,   795,   796,  2076,  4161,   799,   800,  2077,  2078,
     802,  3551,   804,  1174,  1175,  2079,  2013,  2031,  2093,  4203,
    2032,  1331,  2486,   741,  3421,  3005,  2080,  3798,  2081,  3495,
    3799,  2082,  2083,  1331,  2014,  2084,  2085,  2855,  2086,  2087,
     747,  2088,  2535,  4360,  1604,   749,  2089,  1216,   750,  3643,
     911,  2839,  2840,  2841,   704,  2090,  2034,   520,  2536,  3923,
    2486,  2091,  2784,  3007,  2092,  1273,   616,   616,   616,  1172,
    2095,  2113,  2132,   505,  2119,  2129,  2130,  2131,  2138,  2144,
    2809,  2491,  2146,  2172,  2251,  2147,  2487,  1169,  2018,  2148,
    2164,  2163,  2165,  2170,  1174,  1175,  2020,  2185,  3644,  2832,
    3536,  3800,  3801,  3538,  2171,  2255,  2175,   616,   616,   616,
    2181,  2220,  3084,  2189,  2488,   616,   521,  2221,  2451,   715,
    2193,  2775,  2291,  2211,  2487,  1184,  2212,  2217,   879,   879,
    1202,  2232,  2233,  2234,   719,   720, -1344,  2452,  2302, -1222,
    2486,  4384,  1217,  3009,  2854,  2261,   522,   501,  2453,  4438,
    2325,  4440,  2488,  1672,  3645,  1941,  -653,  1179,  1180,  1181,
    1182,  1183,  1184,  4256,  2583,  2271,  2026,  1218,  1070,  1942,
    1122,  1219,  1126,  2303,  2583,  2333,  2960,  2350,  4457,   523,
    2353,  1605,  2489,  2339,  2375,  2402,  1672,  2378,  2400,  3131,
    2424,  2401,  2960,  1241,   606,  2394,  2583,  1607,  2431,  2445,
    2405,  2406,  2463,  2407,  2487,  1346,  4072,  2426,  1220,  2408,
    4240,  2409,  2458,  4487,  4488,  2459,  2462,  1174,  1175,  2465,
    2489,  2476,  2027,  2028,  2029,  2471,  1221,   524,  2472,  2030,
    2473,  2454,  2488,  1671,  4384,   502,  1177,  1178,  1179,  1180,
    1181,  1182,  1183,  1184,  3557,  2031,  2469,  1671,  2032,  2474,
    2475,  4514,  1671,  2506,  3779,  2507,  2529,  1671,  4389,  4390,
    2520,  4392,  2530,  2490,  2525,  4523,  2532,  2533,  3048,  -857,
    4514,  2542,  4126,  2526,  1242,  4523,  2539,  2541,  2543,  2551,
    2550,  2555,  1172,  3192,  2034,  2556,  1213,  2561,  1222,  2562,
    2586,  2590,  3193,  3698,  3698,  3698,  2571,  2592,  3769,  1169,
    2489,  2490,  3194,  2630,  2652,  1243,  2670,  2674,  4429,   616,
    4430,  4431,  2678,  2683,  3195,  3196,  3197,   503,  2699,  1244,
    2700,  2701,   741,  2279,  2712,  2713,  3798,  2725,  2747,  3799,
    3198,  2782,  2754,  1943,  2762,  2787,  2802,  2804,  2655,   747,
    2771,  2805,  1245,  2455,   749,  1246,  2772,   750,  2812,  2816,
    4245,  2783,   -64,  2799,  2836,  2813,  4243,   525,  1247,  4072,
    1178,  1179,  1180,  1181,  1182,  1183,  1184,  1799,  3666,  2817,
    2818,  1152,  1153,  2822,  2837,  2838,  2386,  3757,  2385,  2859,
    1248,  2490,  1672,  1848,  2860,  4484,  2398,  1849,  2870,  1986,
    2880,  3690,  2884,   616,  1987,  2885,  1988,  4499,  1989,  2886,
    3800,  3801,   616,  2887,  2894,  1249,  2895,  2888,  1990,  1991,
    1944,  1250,  2456,  2896,  2912,  1308,  1223,  2916,  2917,  2934,
    2967,  2969,  3031,  3037,  1309,  1224,  3041,  3043,   526,  3057,
    1174,  1175,  1003,  1004,  1310,  1945,  3058,  3063,  3062,  1992,
    1225,  3698,  3064,  1993,  1994,  3065,  1311,  1312,  1313,  1995,
     606,  2019,  1251,  2139,  3089,  3098,  3102,  1996,  1226,  3812,
    3807,  1346,  1314,  3104,  3109,  1997,  1588,  1589,  1590,  1591,
    1592,  3111,  2491,  3169,  1998,  1240,  1241,  3112,  3113,  3115,
    3212,  3116,  3159,  3805,  3213,  3214,  3217,  3170,  3173,  1999,
     616,   527,  3222,  3177,  1172,  1946,   528,  2314,  3215,  3175,
    3182,  1227,  3210,  1451,  3211,  3185,  1284,  2000,  3229,  3225,
    2491,  3253,  3251,  3254,   529,  2001,  2002,  3854,   504,  3772,
    3551,  2315,  2003,  3246,  3858,  4526,  3255,  3263,  3272,  3226,
    2004,  1228,  3264,  3240,  -931,  2316,  2005,  3283,   505,   530,
    3284,  3243,  3429,  3268,  3269,  3291,  2317,  2006,  3923,  3199,
     495,  3295,  3296,   496,   531,  1890,  3310,  1242,  3299,  3311,
    3309,  3328,  3403,  3322,  3332,   616,  3200,  2007,  1593,  1594,
    1595,  1596,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    3340,   506,  3400,  -573,  1252,  3406,   507,  3341,  1243,  1947,
    2491,  3342,  3407,  1322,  1241,  2318,  2319,  3411,  3413,  3834,
    4243,  3414,  1244,  3417,  1254,  3424,  2008,  3425,  2009,  3430,
    3433,  2367,  1255,  3439,  3440,  2010,  3441,  1932,  3459,  3461,
    1256,   508,  3465,  2320,   616,  1245,  3466,  3473,  1246,   509,
    3474,  3486,  2011,  2238,  2012,  1987,  3164,  2835,  3864,  3502,
    3506,  1247,  1174,  1175,  3515,  3517,  3698,  3698,  1257,  3698,
    3698,  3520,  3526,  3539,  3544,  2012,  3528,  3552,  3558,  3559,
    3566,  1258,  1259,  1248,  3567,  3579,  3587,  3590,  3591,  3596,
    3605,  3612,  1216,  1346,  4072,  1242,  1597,  3201,  1598,  1599,
    1600,  1315,  3660,  3663,  2584,  3673,  3665,  1601,  1249,  3667,
    2321,  2013,  3677,  3202,  1250,  3686,  3687,  3694,  1316,  3688,
    4496,  3691,  3692,  3701,  3704,  3705,  1243,  3706,  3707,  2014,
    4308,  1260,  3708,  2015,  3712,  3714,  3716,  3726,  3725,  3717,
    1244,  4007,   606,  3736,  3721,  4308,  4496,  1154,  3727,  3735,
    1155,  3742,  3743,  3698,  3926,  1251,  3744,  3753,  3750,  4318,
    1261,  4528,  2322,  1245,  3752,  3762,  1246,  3267,  3765,  3766,
    3771,  2016,  3770,  3203,  3773,  4008,  2017,  3783,  3792,  1247,
   -1430,  3813,  1262,  2018,  1263,  1602,   606,  1217,  2019,  4059,
    3204,  2020,  3838,  3651,  3793, -1435,  3795,   616,  3796,  3825,
    3810,  1248,  3821,  3827,  1177,  1178,  1179,  1180,  1181,  1182,
    1183,  1184,  1218,  3839,  3843,  3845,  1219,  3654,  3846,  4053,
    3852,  3887,  2021,  3891,  3892,  3897,  1249,  3881,  4098,   791,
    3866,  3906,  1250,  3865,  3911,  3912,  2022,  2023,  2024,  2025,
    1603,  1604,  3893,  4109,  3929,  1317,  3915,  3931,  4116,  3952,
    3916,  3958,   718,  1220,  3715,  3966,  4011,   791,  3965,  4002,
    4025,  2026,  4035,  4052,  4036,  1588,  1589,  1590,  1591,  1592,
    4039,  1221,  4040,  1251,  4055,  4308,  4084,  4086,  4041,  4042,
    4097,  4105,  -346,  4123,  4125,  4416,  4135,  1252,  4146,  2598,
    2599,  1253,  2606,  4168,  4153,  2609,  2610,  2611,  2612,  2613,
    2614,  2615,  4128,  4138,  2618,  1318,  2620,  1254,  4170,  4145,
    4171,  4179,  4176,  4181,  4183,  1255,  4188,  2027,  2028,  2029,
    3026,  4207,  1319,  1256,  2030,  4210,  1672,  -364,  4235,  4237,
    4238,  4239,  4255,  1222,  4448,  4258,  4261,  4277,  4284,  4272,
    2031,  4294,  4297,  2032,  4298,  4271,  4304,  4305,  4309,  4315,
    4317,  1257,  4316,  4308,  4320,  4308,  4341,  4342,  2835,  4343,
    2835,  4344,  4467,  4350,  1258,  1259,  2033,  1593,  1594,  1595,
    1596,  4327,  4308,  4351,  4354,   791,  4355,  4356,  1605,  2034,
     791,  4352,  4353,  4361,  4363,  4365,  4211, -2325,  4369,  4366,
    4375,  4388,  1156,  1606,  1607,  4391,  4393,  4394,  4140,  4404,
    4407,  4409,  4308,  4308,  4417,  1252,  4418,  4504,  4420,  1323,
    4423,   791,  4426,  4435,  1260,  4432,  4436,  4437,  4441,  4442,
    4449,   821,  4446,  4454,  4460,  1254,  4452,   791,  4453,  4456,
    4468,  4462,  4475,  1255,  4465,  4466,  4471,  4476,  4478,  -931,
    4059,  1256,  4500,  1261,  4485,  2778,  4501,  4505,  4515,   616,
    4525,  4118,  2780,  3675,  2622,  3676,  1026,  2928,  3869,  4376,
    4136,  1223,  4246,  4377,  3867,  1262,  1463,  1263,  4517,  1257,
    1224,   791,   791,   791,   791,  1597,  3871,  1598,  1599,  1600,
    4006,  4480,  1258,  1259,   791,  1225,  1601,   576,   921,  2376,
    2298,  3977,  3206,  3978,  3980,  3981,  3983,  3984,  3985,  4489,
    3986,  4302,  3987,  1226,  3988,  4401,  4386,  4402,  3991,  4374,
    3992,  4314,  3993,  4313,  1983,  2575,  2035,  1531,  3228,  3336,
    3755,  4014,  3233,  1802,  4260,  4054,  3519,  4326,  3758,  1672,
    4451,  2098,  1260,  4178,  4387,   653,  4425,  2573,  3693,  3422,
    3082,  2580,  3592,  3604,  1052,  3028,  1227,  3661,  3619,   616,
    4265,  3960,  3620,  3806,  3844,  4325,  3830,  2914,  3161,  3489,
    3491,  1261,  3487,   516,  1602,   517,  4194,  4191,  2128,  4143,
    4150,  4148,  2664,  4024,  4193,  1084,  1228,  3963,  2577,  3016,
    3809,   932,  2819,  1262,  1915,  1263,  3593,  1917,  2096,  2359,
    2059,  1101,  3219,  2800,  1487,  3516,  2842,  2753,   948,  2384,
    1336,  3498,  1626,  3184,  2697,  3563,  2907,  4090,  2752,  4190,
     616,  3674,  4396,  1577,  4397,  2769,  3599,  1933,  4470,  1603,
    1604,  3933,  3925,  1733,  2849,  2668,  3048,  3048,  1443,  1444,
    1790,  2798,  2825,  1817,  3760,  3532,  4406,  3531,  1146,  1445,
    3573,   936,  4323,  4414,  2137,  1446,  1044,  4334,  4335,  2433,
     917,  2434,  1905,  1883,  1488,  1489,  1490,  1491,  1492,  1493,
    1494,  1495,  1496,  1497,  3603,  1498,  1499,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,  2292,  1507,  1508,  3518,  1824,  4450,
    4469,  4518,  4345,  4524,  4395,  4527,  3837,  3535,  1837,  2868,
    3555,   881,  2254,   882,  3556,  2865,  2412,  2866,  2382,  2858,
     791,  1325,  1827,  4152,  2338,  2118,  3503,  4158,   852,  1328,
    2313,  4458,  4127,   647,   648,  3862,  4463,  1030,  1031,  1032,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4497,     0,     0,     0,   791,   791,  1605,     0,     0,
       0,     0,     0,     0,   791,   791,   791,   791,   791,   791,
     791,     0,  1606,  1607,     0,  1672,     0,  4497,   791,   791,
       0,   791,   791,     0,     0,   616,   791,   791,     0,  1672,
     791,   791,   791,   791,  1672,   791,   791,     0,     0,  1672,
    1509,  1510,     0,   791,   791,     0,   791,   791,   791,   791,
     791,     0,     0,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,     0,   791,     0,     0,   791,   791,
       0,     0,     0,   791,     0,     0,     0,   791,   791,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     791,   791,   791,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,  1486,     0,   791,   791,   791,     0,
     791,     0,     0,     0,     0,     0,     0,   791,   791,   791,
       0,   791,   791,   791,   791,   791,     0,   791,   791,   791,
     791,   791,   791,   791,   791,     0,     0,     0,   791,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
    1558,     0,     0,     0,     0,     0,     0,     0,  1568,  1569,
       0,     0,  1572,  1573,  1574,     0,     0,     0,     0,     0,
       0,     0,  1582,  1583,     0,  1584,  1585,     0,     0,     0,
    1610,     0,     0,     0,  1619,  1620,  1621,  1622,     0,  1624,
       0,     0,     0,     0,     0,     0,     0,  1632,  1633,     0,
    1636,  1637,     0,     0,     0,     0,     0,  1641,  1642,  1643,
       0,     0,  1646,  1647,  1648,  1649,  1650,  1651,     0,  1653,
       0,     0,  1656,  1657,     0,     0,     0,  1660,     0,     0,
       0,  1663,  1667,  1668,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1675,  1676,  1677,     0,     0,     0,
       0,     0,     0,  1685,     0,     0,     0,     0,     0,     0,
    1690,  1691,  1692,     0,     0,     1,     0,     2,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     3,     0,     0,   791,     4,     0,     0,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       5,     6,     0,   791,     0,     0,     0,     0,     7,     0,
       0,     0,     8,     9,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    10,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    11,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     1,     0,     2,     0,     0,     0,    12,     0,
       0,     0,     0,     0,     0,     0,     0,    13,    14,    15,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
      16,    17,     0,     0,     0,     0,     0,     5,     6,     0,
       0,     0,     0,    18,     0,     7,     0,     0,     0,     8,
       9,     0,     0,     0,     0,     0,     0,    19,     0,     0,
       0,     0,     0,     0,     0,    10,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    20,     0,     0,     0,  1836,
       0,     0,     0,    11,     0,     0,     0,     0,     0,  1842,
      21,     0,    22,     0,     0,     0,     0,    23,     0,     0,
      24,     0,     0,     0,     0,    12,     0,  1870,     0,     0,
       0,     0,     0,     0,    13,    14,    15,     0,     0,     0,
       0,     0,     0,    25,     0,    26,     0,    16,    17,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,     0,     0,   791,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
      28,     0,     0,     0,    29,     0,     0,     0,     0,     0,
       0,     0,    20,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    21,     0,    22,
       0,     0,     0,     0,    23,     0,     0,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      25,     0,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,     0,     0,     0,   791,   791,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,     0,   791,
      30,    29,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,     0,     0,
      32,   791,     0,     0,   791,     0,   791,     0,     0,     0,
       0,    33,   791,     0,   791,   791,     0,     0,     0,     0,
    2149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    34,     0,     0,    35,     0,    36,     0,
       0,    37,     0,     0,    38,    39,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,    41,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,    30,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,    45,    31,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    32,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,    47,     0,     0,  2224,  2226,
    2228,     0,    48,     0,     0,     0,     0,     0,     0,     0,
      34,     0,     0,    35,     0,    36,     0,     0,    37,     0,
       0,    38,    39,     0,     0,     0,     0,     0,   791,     0,
       0,    40,     0,    41,     0,     0,   791,     0,     0,  2263,
       0,    42,     0,     0,     0,    49,     0,    43,  2268,     0,
    2269,     0,     0,     0,     0,    44,     0,    50,     0,     0,
      45,    51,    46,     0,    52,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,     0,    54,     0,    48,
       0,     0,     0,   829,   884,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   885,   869,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   886,
       0,     0,    49,  2355,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,    51,     0,
       0,    52,   887,     0,   888,     0,    53,     0,     0,     0,
       0,     0,     0,     0,   889,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2411,     0,    54,     0,     0,     0,     0,     0,
    2421,     0,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1794,   890,     0,     0,     0,     0,   891,     0,
       0,   892,     0,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     893,     0,   894,     0,     0,     0,     0,     0,     0,   895,
       0,   896,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   897,   898,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,   791,     0,     0,   899,     0,
     791,   791,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,   791,     0,     0,     0,     0,     0,     0,   900,
       0,     0,   791,   791,     0,   791,   791,     0,   791,   791,
     791,   791,   791,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,   791,     0,     0,     0,     0,     0,
       0,   791,   901,   791,     0,   791,   791,     0,   791,   791,
       0,     0,     0,   791,   791,   791,     0,     0,     0,   791,
     791,   791,     0,   791,     0,   791,     0,   791,     0,   791,
       0,   791,  2591,     0,     0,     0,   791,     0,     0,     0,
       0,     0,  3345,  3346,     0,     0,     0,     0,  3347,     0,
    3348,     0,  3349,  3350,     0,   791,     0,     0,     0,     0,
       0,     0,   791,     0,     0,   791,     0,   902,     0,  3351,
       0,   791,     0,     0,   791,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   903,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   904,   905,     0,  2677,   906,   907,     0,  2679,
       0,     0,     0,     0,  2681,  2682,     0,  3352,     0,     0,
    3353,     0,     0,  2695,     0,     0,     0,   908,  3354,     0,
       0,     0,     0,     0,     0,     0,  2702,  2703,     0,  2704,
     791,     0,  2706,  2707,  2708,  2709,  2710,  3355,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2714,  1990,
    1991,     0,     0,     0,  3356,  2715,     0,  2716,     0,  2717,
    2718,     0,  2719,   909,     0,     0,     0,  2722,  2723,  2724,
       0,     0,     0,  2726,  2727,  2728,   910,  2729,     0,  2731,
    3357,  2733,  3358,  2735,  1993,  2736,     0,     0,     0,     0,
    2737,     0,     0,     0,     0,  3359,  3360,     0,  1996,     0,
       0,     0,     0,     0,   791,     0,  1997, -2362,   791,  2757,
       0,   911,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2767,     0,     0,  2770,   912,
    1999,     0,     0,     0,     0,     0,  3361,     0,     0,     0,
       0,     0,     0,     0,  1451,     0,     0,     0,  2000,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3362,     0,     0,  2926,
       0,     0,     0,     0,     0,  3363,  3364,  2005,  3365,     0,
       0,     0,     0,     0,     0,     0, -2362,  2926,  2926,     0,
       0,     0,   913,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3366,  3367,  3368,     0,     0,     0,
       0,     0,  3014,     0,     0,     0,     0,  1987,     0,  1988,
       0,     0,     0,  3369,  3370,  3371,     0,     0,     0,     0,
    3372,  1990,  1991,  3373,     0,     0,     0,     0,     0,  2009,
       0,     0,     0,     0,     0,     0,  2010,     0,     0,     0,
    3374,  3375,     0,     0,     0,     0,     0,     0,  2421,     0,
       0,     0,  1992,  2011,     0,     0,  1993,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1996,     0,     0,  3376,  3377,     0,     0,     0,  1997,     0,
       0,     0,     0,     0,     0,     0,     0,  1998,  1990,  1991,
       0,     0,     0,     0,     0,  2926,  2926,     0,  3378,     0,
       0,     0,  1999,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2013,     0,     0,     0,  1451,     0,     0,     0,
    2000,  -791,  -791,  1993,     0,     0,     0,     0,  2001,     0,
    2014,  -791,     0,     0,     0,  3015,     0,  1996,     0,     0,
       0,     0,     0,  2004,     0,  1997,   791,     0,     0,  2005,
     791,     0,  3379,     0,     0,     0,  3380,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3381,  1999,
     791,   791,     0,     0,     0,     0,     0,     0,     0,     0,
    2007,     0,     0,  1451,  2018,     0,     0,  2000,     0,     0,
       0,   791,  2020,     0,     0,     0,     0,     0,     0,     0,
     791,     0,   791,     0,   791,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2005,     0,     0,     0,
       0,  2009,     0,     0,     0,     0,  3382,     0,  2010,  3383,
       0,   791,  3384,  3385,  3386,  3387,   791,     0,     0,     0,
       0,     0,     0,     0,     0,  2011,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2026,     0,     0,   791,     0,     0,  2012,     0,
       0,     0,     0,     0,  3388,  3389,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2009,     0,
       0,     0,     0,     0,     0,  2010,     0,     0,     0,  3390,
       0,     0,     0,     0,  2013,     0,     0,     0,     0,     0,
    3094,     0,  2011,     0,  3096,     0,     0,     0,  2027,  2028,
    2029,     0,  2014,     0,     0,  2030,  2015,     0,     0,     0,
       0,     0,     0,     0,  3118,  3119,     0,     0,     0,     0,
       0,  2031,     0,     0,  2032,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3141,     0,     0,     0,     0,
       0,     0,     0,     0,  3151,     0,  3153,     0,  3155,  2017,
       0,  2013,     0,     0,     0,     0,  2018,     0,     0,     0,
    2034,     0,     0,   791,  2020,     0,     0,     0,     0,  2014,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3216,
    2023,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2018,     0,     0,     0,     0,     0,     0,
       0,  2020,     0,     0,  2026,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,   791,     0,     0,     0,     0,
    2027,  2028,  2029,     0,     0,     0,     0,  2030,     0,     0,
       0,  2026,     0,     0,     0,     0,     0,     0,     0,  2926,
       0,     0,     0,  2031,     0,     0,  2032,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3304,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,  2034,     0,     0,     0,     0,  2027,  2028,  2029,
       0,     0,     0,     0,  2030,     0,     0,     0,     0,     0,
       0,     0,   791,     0,     0,     0,   791,   791,     0,   791,
    2031,     0,     0,  2032,     0,     0,     0,     0,   791,     0,
       0,     0,     0,   791,     0,     0,   791,     0,   791,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2034,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3401,  3402,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3446,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3464,     0,     0,     0,
    3468,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,  3476,     0,     0,     0,     0,  3478,     0,   791,
    3479,     0,  3480,  3481,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3512,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2421,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3512,     0,     0,     0,     0,
       0,     0,     0,  3584,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     791,   791,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,   791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3781,  3782,     0,     0,     0,     0,
       0,     0,     0,  3304,     0,     0,     0,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3995,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3304,     0,     0,     0,  3890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   791,  3512,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,   791,  3304,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,  3995,  3995,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4078,     0,     0,     0,     0,
       0,     0,  4083,     0,  4085,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   791,     0,  3995,
    3995,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4251,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3304,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   791,     0,  3995,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3995,   791,     0,     0,     0,     0,     0,     0,     0,  3304,
       0,     0,     0,     0,  3995,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4205,
       0,  4206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     791,  3995,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3995,  3995,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3995,     0,     0,     0,     0,     0,     0,   791,     0,     0,
    3995,     0,     0,     0,     0,     0,     0,  4306,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4311,     0,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,  3995,     0,  3995,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3995,
    3512,     0,     0,   791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3995,     0,  3995,     0,
    3995,     0,     0,     0,     0,     0,     0,  3995,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3995,     0,     0,
       0,     0,     0,     0,  4359,     0,     0,     0,     0,     0,
       0,  3995,  3995,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3995,  3995,     0,
       0,     0,  3995,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
       0,  4408,     0,     0,     0,     0,     0,     0,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,  4434,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,  1664,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,   688,   201,   202,     0,   203,     0,     0,
       0,   204,  4506,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,  3512,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,  1665,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
    1666,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,  2417,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
    2418,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,  2419,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,   717,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,  2420,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,   764,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
    2223,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,   717,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,  2225,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,   701,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,   717,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,  2227,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,   701,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,   717,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,     0,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,   688,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
       0,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
     665,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,   688,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,   717,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,  1083,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,  1699,     0,   143,     0,     0,     0,  1700,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
       0,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,     0,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,     0,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,  2676,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,   717,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,     0,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,  2721,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,   717,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,     0,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,  3511,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
       0,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
     665,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,   688,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
    4381,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,     0,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,   764,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
       0,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,     0,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,     0,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,  1714,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,     0,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,     0,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,  1716,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,     0,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,   666,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,  1752,     0,     0,     0,     0,   199,   200,
     687,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,  1753,   456,   457,  1754,     0,     0,     0,     0,
       0,   459,   460,     0,     0,   747,   461,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   488,     0,     0,     0,   137,     0,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
     767,   768,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,  2508,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,   502,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,  2063,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,  2064,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,  3078,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,  2019,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,  -478,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,   505,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     488,     0,   137,     0,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   145,  2579,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,  2508,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,   502,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,  2063,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,  2064,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,   505,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   488,     0,   137,     0,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,  2579,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,  2367,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   488,     0,   137,     0,   138,   139,   140,   141,
     142,     0,     0,   143,  2826,     0,     0,   144,     0,     0,
     145,   768,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   488,     0,
       0,     0,   137,     0,   138,   139,   140,   141,   142,     0,
    4510,   143,     0,     0,     0,   144,  4511,   768,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   488,     0,     0,     0,
     137,     0,   138,   139,   140,   141,   142,  1087,     0,   143,
       0,     0,     0,   144,     0,   768,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
    1299,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,     0,   137,     0,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,   538,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     488,     0,     0,     0,   137,     0,   138,   139,   140,   141,
     142,  2578,     0,   143,     0,     0,     0,   144,     0,  2579,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   488,     0,
       0,     0,     0,   137,  2788,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,   538,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,     0,   488,     0,     0,
       0,   137,     0,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,  4511,   768,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,     0,   488,     0,   137,     0,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,   538,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   601,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   602,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   603,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
       0,   488,     0,   137,     0,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,   145,
     538,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,     0,   488,     0,   137,
       0,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,   768,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,     0,   488,     0,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  2579,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   868,   869,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
     870,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   871,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   872,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   873,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   874,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   875,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   876,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,   877,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,   614,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     134,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  1350,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,  1686,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   868,   869,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,   870,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   871,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   872,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   873,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   874,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   875,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,   877,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,  3548,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,  1233,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  1234,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,  1234,   146,   147,
     148,   149,   150,     0,     0,  -366,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,  3968,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
    3969,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,     0,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,  3970,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,  3971,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,  3972,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,  3973,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,  -321,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,  3974,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,  -321,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,  3975,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,  -321,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,  4503,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,  2139,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,  2856,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,  3507,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,  3553,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,  2486,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,  2487,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,  2488,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,  2489,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,  1003,  1004,     0,   333,   334,     0,     0,  2490,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,  4490,   563,  4491,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,  2491,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,  1339,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,  1340,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,  1341,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,   614,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
    1342,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   134,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,  1352,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,  1353,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,   614,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,   134,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,  1884,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,  1885,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,  1886,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,  1339,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,  1340,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   239,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,   614,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,   134,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,   960,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,   614,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     134,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,   137,   488,   138,   139,   140,   141,   142,
    1374,     0,   143,     0,     0,     0,   144,     0,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,   614,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,   134,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,   937,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
     938,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   939,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,  2395,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,   614,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,   134,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
    1339,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,   614,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   134,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,  2852,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   134,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,  4410,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,  4411,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,   563,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   239,
     240,  1039,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,   870,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,  1860,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,  2056,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,   870,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,  2948,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,  2956,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
    2980,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,  3044,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,   134,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,  1785,   237,     0,     0,   238,     0,     0,     0,   239,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
    1786,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,     0,     0,  -366,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,  3968,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
    3969,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
    -336,  -336,   214,     0,  -336,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,  3970,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,  3971,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,  3972,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,  3973,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,  -321,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,  3974,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,  -321,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,  3975,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,  -321,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,     0,
       0,   146,   147,   148,   149,   150,     0,     0,  -366,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,     0,     0,     0,     0,   161,
    3968,     0,   162,   163,     0,   164,     0,     0,     0,     0,
     167,   168,   169,  3969,   171,   172,     0,   173,   174,     0,
     175,   176,     0,   178,     0,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,     0,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,     0,     0,     0,   211,
     212,   213,     0,  -357,     0,   214,     0,  -357,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,     0,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,  3970,   235,   236,   237,     0,
       0,     0,     0,     0,     0,     0,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,     0,   250,     0,     0,     0,     0,     0,
     253,     0,     0,     0,   254,   255,   256,   257,  3971,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,     0,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,  3972,     0,     0,   269,     0,     0,
       0,   271,     0,     0,   272,  3973,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,  -321,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,     0,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,  3974,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   344,   345,
       0,     0,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,     0,     0,     0,     0,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,     0,     0,   383,     0,   385,  -321,     0,   386,     0,
       0,     0,   388,     0,     0,   390,   391,   392,  3975,   393,
       0,     0,     0,   395,   396,   397,   398,   399,   400,   401,
       0,   403,   404,     0,   405,     0,     0,     0,     0,   407,
     408,   409,     0,     0,     0,     0,   411,     0,     0,     0,
     412,     0,     0,   414,     0,   416,     0,   417,     0,     0,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,     0,   431,   432,   433,   434,     0,     0,     0,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,     0,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,     0,     0,     0,     0,   471,     0,     0,   472,
       0,     0,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,  -357,     0,  -321,     0,     0,     0,   483,
       0,     0,   485,     0,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,     0,     0,   146,   147,   148,   149,   150,     0,
       0,  -366,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,     0,     0,
       0,     0,   161,  3968,     0,   162,   163,     0,   164,     0,
       0,     0,     0,   167,   168,   169,  3969,   171,   172,     0,
     173,   174,     0,   175,   176,     0,   178,     0,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,     0,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,     0,
       0,     0,   211,   212,   213,     0,  -354,     0,   214,     0,
    -354,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,     0,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,  3970,   235,
     236,   237,     0,     0,     0,     0,     0,     0,     0,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,     0,   250,     0,     0,
       0,     0,     0,   253,     0,     0,     0,   254,   255,   256,
     257,  3971,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,     0,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,  3972,     0,     0,
     269,     0,     0,     0,   271,     0,     0,   272,  3973,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
    -321,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,     0,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,  3974,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,     0,     0,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,     0,     0,     0,     0,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,     0,     0,   383,     0,   385,  -321,
       0,   386,     0,     0,     0,   388,     0,     0,   390,   391,
     392,  3975,   393,     0,     0,     0,   395,   396,   397,   398,
     399,   400,   401,     0,   403,   404,     0,   405,     0,     0,
       0,     0,   407,   408,   409,     0,     0,     0,     0,   411,
       0,     0,     0,   412,     0,     0,   414,     0,   416,     0,
     417,     0,     0,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,     0,   431,   432,   433,   434,     0,
       0,     0,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,     0,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,     0,     0,     0,     0,   471,
       0,     0,   472,     0,     0,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,  -354,     0,  -321,     0,
       0,     0,   483,     0,     0,   485,     0,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,     0,     0,   146,   147,   148,
     149,   150,     0,     0,  -366,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,     0,     0,     0,     0,   161,  3968,     0,   162,   163,
       0,   164,     0,     0,     0,     0,   167,   168,   169,  3969,
     171,   172,     0,   173,   174,     0,   175,   176,     0,   178,
       0,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,     0,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
       0,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,     0,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,  4307,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,     0,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,  3970,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,     0,
     250,     0,     0,     0,     0,     0,   253,     0,     0,     0,
     254,   255,   256,   257,  3971,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,     0,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
    3972,     0,     0,   269,     0,     0,     0,   271,     0,     0,
     272,  3973,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,  -321,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,     0,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,  3974,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,     0,     0,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,     0,
       0,     0,     0,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,     0,     0,   383,
       0,   385,  -321,     0,   386,     0,     0,     0,   388,     0,
       0,   390,   391,   392,  3975,   393,     0,     0,     0,   395,
     396,   397,   398,   399,   400,   401,     0,   403,   404,     0,
     405,     0,     0,     0,     0,   407,   408,   409,     0,     0,
       0,     0,   411,     0,     0,     0,   412,     0,     0,   414,
       0,   416,     0,   417,     0,     0,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,     0,   431,   432,
     433,   434,     0,     0,     0,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,     0,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,     0,     0,
       0,     0,   471,     0,     0,   472,     0,     0,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,  -321,     0,     0,     0,   483,     0,     0,   485,     0,
     487,     0,   137,   488,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,     0,     0,
     146,   147,   148,   149,   150,     0,     0,  -366,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,     0,     0,     0,     0,   161,  3968,
       0,   162,   163,     0,   164,     0,     0,     0,     0,   167,
     168,   169,  3969,   171,   172,     0,   173,   174,     0,   175,
     176,     0,   178,     0,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,     0,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,     0,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,  -359,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,     0,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,  3970,   235,   236,   237,     0,     0,
       0,     0,     0,     0,     0,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,     0,   250,     0,     0,     0,     0,     0,   253,
       0,     0,     0,   254,   255,   256,   257,  3971,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
       0,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,  3972,     0,     0,   269,     0,     0,     0,
     271,     0,     0,   272,  3973,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,  -321,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,     0,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,  3974,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,     0,
       0,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,     0,     0,     0,     0,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
       0,     0,   383,     0,   385,  -321,     0,   386,     0,     0,
       0,   388,     0,     0,   390,   391,   392,  3975,   393,     0,
       0,     0,   395,   396,   397,   398,   399,   400,   401,     0,
     403,   404,     0,   405,     0,     0,     0,     0,   407,   408,
     409,     0,     0,     0,     0,   411,     0,     0,     0,   412,
       0,     0,   414,     0,   416,     0,   417,     0,     0,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
       0,   431,   432,   433,   434,     0,     0,     0,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
       0,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,     0,     0,     0,     0,   471,     0,     0,   472,     0,
       0,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,  -321,     0,     0,     0,   483,     0,
       0,   485,     0,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,     0,     0,   146,   147,   148,   149,   150,     0,     0,
    -366,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,     0,     0,     0,
       0,   161,  3968,     0,   162,   163,     0,   164,     0,     0,
       0,     0,   167,   168,   169,  3969,   171,   172,     0,   173,
     174,     0,   175,   176,     0,   178,     0,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,     0,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,     0,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,     0,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,  4415,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,     0,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,  3970,   235,   236,
     237,     0,     0,     0,     0,     0,     0,     0,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,     0,   250,     0,     0,     0,
       0,     0,   253,     0,     0,     0,   254,   255,   256,   257,
    3971,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,     0,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,  3972,     0,     0,   269,
       0,     0,     0,   271,     0,     0,   272,  3973,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,  -321,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,     0,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,  3974,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,     0,     0,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,     0,     0,     0,     0,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,     0,     0,   383,     0,   385,  -321,     0,
     386,     0,     0,     0,   388,     0,     0,   390,   391,   392,
    3975,   393,     0,     0,     0,   395,   396,   397,   398,   399,
     400,   401,     0,   403,   404,     0,   405,     0,     0,     0,
       0,   407,   408,   409,     0,     0,     0,     0,   411,     0,
       0,     0,   412,     0,     0,   414,     0,   416,     0,   417,
       0,     0,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,     0,   431,   432,   433,   434,     0,     0,
       0,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,     0,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,     0,     0,     0,     0,   471,     0,
       0,   472,     0,     0,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,  -321,     0,     0,
       0,   483,     0,     0,   485,     0,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,     0,     0,   146,   147,   148,   149,
     150,     0,     0,  -366,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
       0,     0,     0,     0,   161,  3968,     0,   162,   163,     0,
     164,     0,     0,     0,     0,   167,   168,   169,  3969,   171,
     172,     0,   173,   174,     0,   175,   176,     0,   178,     0,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,     0,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,     0,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,     0,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,  4461,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,     0,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
    3970,   235,   236,   237,     0,     0,     0,     0,     0,     0,
       0,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,     0,   250,
       0,     0,     0,     0,     0,   253,     0,     0,     0,   254,
     255,   256,   257,  3971,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,     0,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,  3972,
       0,     0,   269,     0,     0,     0,   271,     0,     0,   272,
    3973,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,  -321,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,     0,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
    3974,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,     0,     0,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,     0,     0,
       0,     0,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,     0,     0,   383,     0,
     385,  -321,     0,   386,     0,     0,     0,   388,     0,     0,
     390,   391,   392,  3975,   393,     0,     0,     0,   395,   396,
     397,   398,   399,   400,   401,     0,   403,   404,     0,   405,
       0,     0,     0,     0,   407,   408,   409,     0,     0,     0,
       0,   411,     0,     0,     0,   412,     0,     0,   414,     0,
     416,     0,   417,     0,     0,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,     0,   431,   432,   433,
     434,     0,     0,     0,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,     0,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,     0,     0,     0,
       0,   471,     0,     0,   472,     0,     0,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
    -321,     0,     0,     0,   483,     0,     0,   485,     0,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,     0,     0,   146,
     147,   148,   149,   150,     0,     0,  -366,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,     0,     0,     0,     0,   161,  3968,     0,
     162,   163,     0,   164,     0,     0,     0,     0,   167,   168,
     169,  3969,   171,   172,     0,   173,   174,     0,   175,   176,
       0,   178,     0,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,     0,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,     0,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,     0,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,  -340,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,     0,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,  3970,   235,   236,   237,     0,     0,     0,
       0,     0,     0,     0,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,     0,   250,     0,     0,     0,     0,     0,   253,     0,
       0,     0,   254,   255,   256,   257,  3971,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,     0,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,  3972,     0,     0,   269,     0,     0,     0,   271,
       0,     0,   272,  3973,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,  -321,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
       0,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,  3974,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   344,   345,     0,     0,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,     0,     0,     0,     0,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,     0,
       0,   383,     0,   385,  -321,     0,   386,     0,     0,     0,
     388,     0,     0,   390,   391,   392,  3975,   393,     0,     0,
       0,   395,   396,   397,   398,   399,   400,   401,     0,   403,
     404,     0,   405,     0,     0,     0,     0,   407,   408,   409,
       0,     0,     0,     0,   411,     0,     0,     0,   412,     0,
       0,   414,     0,   416,     0,   417,     0,     0,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,     0,
     431,   432,   433,   434,     0,     0,     0,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,     0,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
       0,     0,     0,     0,   471,     0,     0,   472,     0,     0,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,  -321,     0,     0,     0,   483,     0,     0,
     485,     0,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
       0,     0,   146,   147,   148,   149,   150,     0,     0,  -366,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,     0,     0,     0,     0,
     161,  3968,     0,   162,   163,     0,   164,     0,     0,     0,
       0,   167,   168,   169,  3969,   171,   172,     0,   173,   174,
       0,   175,   176,     0,   178,     0,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,     0,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,     0,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,     0,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,     0,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,     0,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,  3970,   235,   236,   237,
       0,     0,     0,     0,     0,     0,     0,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,     0,   250,     0,     0,     0,     0,
       0,   253,     0,     0,     0,   254,   255,   256,   257,  3971,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,     0,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,  3972,     0,     0,   269,     0,
       0,     0,   271,     0,     0,   272,  3973,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,  -321,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,     0,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,  3974,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,     0,     0,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,     0,     0,     0,     0,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,     0,     0,   383,     0,   385,  -321,     0,   386,
       0,     0,     0,   388,     0,     0,   390,   391,   392,  3975,
     393,     0,     0,     0,   395,   396,   397,   398,   399,   400,
     401,     0,   403,   404,     0,   405,     0,     0,     0,     0,
     407,   408,   409,     0,     0,     0,     0,   411,     0,     0,
       0,   412,     0,     0,   414,     0,   416,     0,   417,     0,
       0,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,     0,   431,   432,   433,   434,     0,     0,     0,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,     0,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,     0,     0,     0,     0,   471,     0,     0,
     472,     0,     0,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,  -321,     0,     0,     0,
     483,     0,     0,   485,     0,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,     0,     0,   146,   147,   148,   149,   150,
       0,     0,  -366,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,     0,
       0,     0,     0,   161,  3968,     0,   162,   163,     0,   164,
       0,     0,     0,     0,   167,   168,   169,  3969,   171,   172,
       0,   173,   174,     0,   175,   176,     0,   178,     0,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
       0,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
       0,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,     0,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,     0,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,  3970,
     235,   236,   237,     0,     0,     0,     0,     0,     0,     0,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,     0,   250,     0,
       0,     0,     0,     0,   253,     0,     0,     0,   254,   255,
     256,   257,  3971,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,     0,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,  3972,     0,
       0,   269,     0,     0,     0,   271,     0,     0,   272,  3973,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,  -321,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,     0,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,  3974,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   344,   345,     0,     0,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,     0,     0,     0,
       0,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,     0,     0,   383,     0,   385,
    -321,     0,   386,     0,     0,     0,   388,     0,     0,   390,
     391,   392,  3975,   393,     0,     0,     0,   395,   396,   397,
     398,   399,   400,   401,     0,   403,   404,     0,   405,     0,
       0,     0,     0,   407,   408,   409,     0,     0,     0,     0,
     411,     0,     0,     0,   412,     0,     0,   414,     0,   416,
       0,   417,     0,     0,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,     0,   431,   432,   433,   434,
       0,     0,     0,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,  4310,     0,     0,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,  -321,
       0,     0,     0,   483,     0,     0,   485,     0,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,     0,     0,     0,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,     0,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
       0,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,     0,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,     0,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,     0,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,     0,   488
};

static const yytype_int16 yycheck[] =
{
       6,   638,   647,   648,   575,   574,   575,   953,   594,  1137,
     853,   954,   122,    19,  1837,   873,   874,    23,  1550,  1483,
     519,  1233,    20,  1377,  1084,   883,    32,  1137,   705,  1043,
    1037,  1038,    30,    39,  1683,  1804,    42,  1280,    36,  1481,
      46,  1358,  2540,   891,   913,  2019,   665,    53,     6,  1472,
      23,  1472,   889,  2090,  1160,  2155,  2891,  1074,  1107,  1233,
    2160,  1167,  2371,  2468,  2456,   913,  2479,  2428,  2429,  1982,
    3301,   958,   958,  1286,  2326,  2833,   610,   914,   634,   635,
    1472,  2657,  1986,  2251,  2497,  2498,  1756,  1988,    94,   623,
    1462,  1992,  1826,  2115,  1466,   652,  1468,  1913,  2115,  2045,
    2414,  2436,  2003,  2535,  3036,     4,  3533,  2541,    19,  2289,
     116,  1462,   118,  2513,  2015,   121,   122,   123,  1982,  1168,
    1169,    94,  1388,  1172,  1173,  1174,  1175,  3091,  1177,  1178,
    1179,  1180,  1181,  1182,  1183,  1184,   773,  2389,  3306,  2691,
    1406,     9,   761,   762,   763,  3174,  2449,   933,  1414,  1415,
      33,  1937,  1938,  1452,  2457,   774,    46,    16,    17,  1531,
     118,    29,    20,   121,    24,  3364,  3365,    35,  1954,  3368,
      19,  2685,  2749,  1835,  1965,  2689,    16,    17,    70,  1206,
    1531,    59,    19,  2104,   104,  1971,  1972,    17,  3387,  1974,
      24,  2245,  1928,   145,  3393,   145,    17,    67,    21,    50,
    3324,  1987,  2115,   140,  1990,  1991,   151,  1993,   125,    70,
    1996,  1997,  2625,  2626,  2000,    62,  1462,   145,    64,  2005,
    1466,    65,  1468,    29,  2010,  2011,  2012,  2013,  2014,  2944,
      78,    50,  2018,    21,  2020,    58,    59,  2501,  2138,   148,
    2026,  2027,  2028,  2029,   155,    33,  2032,  2659,  2034,  2688,
     159,  2115,   386,    16,    17,    68,  2787,  2633,   279,    47,
    2497,  2498,    61,   129,   132,   212,    11,  3030,   126,   803,
      58,    59,   263,    75,   680,   280,   221,  3592,   367,  2070,
    3582,  2072,  2073,  1956,    82,  1531,   190,  2078,  2079,   358,
     362,    74,   416,   153,   120,   441,  2087,  2088,  3529,    61,
     834,  2092,   151,    11,    16,    17,   155,  2838,   120,   265,
      16,    17,   274,  2099,  2100,  2101,  2102,   106,   155,   120,
     915,   151,    21,    57,    80,   151,     8,   221,   385,   179,
      16,    17,    10,    19,    33,    74,  2671,   247,  2673,   151,
     158,   449,  3945,   545,    16,    17,   752,   160,    47,   134,
     151,    35,    16,    17,    35,    19,   819,    16,    17,    58,
      59,   189,   244,   264,    20,   155,   267,   227,   199,   280,
    1015,  1016,  1017,   359,   336,   122,   433,   122,    16,    17,
      16,    17,   373,   186,  4261,   269,   280,  4264,  2625,  2626,
      16,    17,   640,   227,   504,   352,  1073,   189,   245,   430,
      16,    17,   517,   253,   162,    20,   970,   971,   576,   545,
    1087,   416,  2820,    21,    33,    67,   132,   438,   225,   189,
     225,  3620,   545,   185,   511,    33,    16,    17,   984,   117,
    3629,   147,   542,   171,   192,   637,   225,   171,   269,    47,
      59,   175,   399,    40,  4007,   250,  1010,  3874,  2239,   309,
      58,    59,   186,  3652,   611,    16,    17,   544,  3657,  2826,
      16,    17,   371,   631,    16,    17,   249,   186,   238,   272,
     126,   263,   356,   936,   460,   309,  2516,   189,   509,   107,
     384,   596,   110,  1426,   608,  2385,   632,    16,    17,  4092,
     237,    16,    17,  1351,   439,   355,   630,   179,   504,  2455,
     506,   457,  2910,  4380,   354,   416,  2898,   630,  2843,  2844,
     249,   126,   413,   372,    16,    17,   375,   523,   412,  3750,
     348,   527,    16,    17,   280,   209,  1163,   124,   209,  3697,
     638,   468,   538,   318,   416,   155,   542,   447,   544,  2003,
    1857,    16,    17,  2943,   405,  1382,  2946,  2947,  1385,   638,
     798,   557,  1171,  1390,   960,   517,  1233,  1056,  1057,  2964,
     632,   374,   631,   155,   272,  1452,  1452,  3330,   574,  1188,
     517,   171,   416,  2519,  4137,   632,   582,  2523,  1077,  1416,
    1417,   485,  2556,   317,  1956,   576,   607,  1086,  2501,   277,
    1438,  2537,  2538,   451,   600,   446,   260,   139,  3313,  1098,
    1099,  1100,  1974,  2549,   610,  1956,   612,  1106,   613,   372,
    3574,  2633,   375,   411,  1826,   463,  2633,   623,   624,   625,
    3788,    16,    17,  2571,   630,   424,   632,   446,   634,   635,
     375,  1982,  2578,   639,   640,   544,  3951,  2501,   644,   401,
     486,  1907,   473,  1530,  1530,  2037,  3059,   517,   654,   655,
     656,   624,  1826,   605,   660,   605,  1212,   630,  3235,  3494,
     372,   521,  1711,   375,   532,   582,   372,   625,  2932,   375,
     358,  2462,  3084,  1722,   412,   536,  1725,   605,   412,   526,
     600,  3212,  3213,  3214,  3060,   553,   372,   477,  1705,   375,
     800,   636,   560,   630,    16,    17,  2750,   634,   559,   705,
     372,  4128,   613,   375,    16,    17,  2627,  1734,   372,  2655,
    1956,   375,  2448,   372,  2499,   583,   375,   595,   608,   556,
    2633,  3889,  3253,  3254,  3255,   403,  3303,  1283,  1974,  2391,
    1516,  2522,  2104,  2524,   372,   556,   372,   375,   630,   375,
    2531,   601,  1298,  2115,  2530,  3774,   372,   630,  3872,   375,
     556,   574,  3920,  2104,  2545,  3090,   372,  2543,   617,   375,
     766,  2552,   768,   873,  2115,   623,   568,   877,   878,  2633,
    2670,  3080,   632,  2564,  2565,  2566,   635,   617,   608,  2570,
     890,   632,   372,   649,   602,   375,   574,   636,   794,   795,
     796,  2971,   798,   799,   800,  4097,   802,   803,   632,  2098,
    3352,  2592,   808,  3767,    16,    17,   636,  2480,   814,  1366,
     636,   372,   412,  1347,   375,   577,   372,  1412,   824,   375,
     372,  4248,  3059,   375,   636,   608,   565,   616,   834,   835,
     508,  3383,  3384,   839,  3348,   636,   451,   795,    16,    17,
      62,   799,   952,   372,   802,  2631,   375,   372,   638,   588,
     375,   824,  1386,   117,   617,  2624,  4024,   477,  2104,    16,
      17,   545,   835,   155,   545,   517,   839,   873,  3382,  2115,
     372,   877,   878,   375,    50,   574,  3390,  3244,   372,   567,
    4443,   375,   560,  3397,   890,   477,   262,  1456,  3322,   608,
    2332,   153,    16,    17,   632,   594,   595,   372,   632,  3291,
     375,  2941,  4101,  3295,  4103,   617,  3338,  3346,  3347,   313,
    3310,   617,   509,    16,    17,  3354,   588,   181,  3357,  3358,
     632,   549,   600,   171,   552,   631,   632,   933,  2460,   828,
     184,   617,  3241,   530,   476,  3374,  1470,  3869,   125,   807,
      16,    17,   373,  2899,  2900,   617,   952,  2770,   954,  3388,
     153,  1628,   117,   617,  3393,  3394,  3395,  3396,   617,  3273,
     632,   558,   155,    16,    17,  3300,   574,   221,   632,    16,
      17,   141,   631,   632,    55,   117,   125,   372,   984,   617,
     375,   617,  1539,  4151,    45,  1843,   586,  2810,  3291,  4133,
     598,   617,  3295,   631,   632,   631,   632,    74,    16,    17,
     136,   617,    33,  2951,  3256,  1863,   632,    42,  3539,    68,
      98,   221,  4180,   277,    31,   631,   632,    24,   638,  2932,
     192,  2967,   630,   245,   227,  4256,  3639,   617,  3579,  1035,
     174,   151,   632,  1039,  1903,    16,    17,  2985,  3060,   181,
    1150,   631,   632,  3060,   231,  2993,   638,  2816,   153,  2997,
     372,  2515,  2516,   375,   421,  1903,   617,   151,   122,  1896,
     372,   617,  1035,   375,  1933,   617,  1039,  1073,  2932,  1906,
    2886,   632,  1909,  1910,  2428,  2429,   632,  1187,   263,   631,
     632,  1087,   231,   186,  1729,  1933,    16,    17,   617,  4100,
      16,    17,   617,   355,   358,  3043,    16,    17,   120,   545,
      16,    17,  2836,   632,   184,  1724,   631,   632,  2480,    51,
    3014,   302,   277,  2783,  3015,   617,   391,  3693,  3286,    61,
      16,    17,   227,   617,  1234,    23,  2140,  2499,   350,  2480,
     632,  1137,   545,   123,    74,   277,  2185,   631,   632,  2352,
     510,   221,   617,   263,  1150,   206,   155,  3060,    88,  1826,
    2501,  2574,   355,  2574,  1799,   354,  2262,   632,   647,   648,
     372,    16,    17,   375,   412,   263,    16,    17,  3719,   263,
     366,  2437,   249,   237,  3566,  3567,   462,   186,   354,  1289,
     366,  1187,  2574,  1739,   630,   477,  1192,   244,   373,   302,
     486,  1197,  2961,   358,   372,   331,  3060,   375,   319,    16,
      17,   632,  3655,  1737,   571,  3658,  1212,   377,  2268,  2269,
     192,  2098,  2098,   357,  3765,   372,   358,   630,   375,   227,
     227,   238,   617,   206,  1197,  3838,   630,  1233,  1234,   439,
     606,   403,   431,  4377,  2480,    16,    17,   632,   539,   125,
    1774,    24,  2891,  2371,  2261,   262,  4004,  4082,   372,    95,
     355,   375,   439,  2499,  2271,  2627,    16,    17,  4016,   521,
    3713,  2633,  3972,  3973,  1270,   163,  1272,   250,  1274,   372,
     446,   302,   375,   354,  3248,   373,  2627,  1283,  1812,  1813,
     650,   468,  2633,  1289,   477,    16,    17,  3783,   510,   118,
     280,  2340,  1298,  1299,  1828,   617,   372,  4528,   411,   375,
     476,  1274,   309,   567,   526,   617,   341,    12,    16,    17,
     632,   117,   252,  3857,    41,   374,    16,    17,   521,   372,
     632,  1327,   375,    16,    17,   372,  1299,   269,   375,  1335,
    2458,   391,  1338,   587,   189,   357,    16,    17,   586,   601,
    3701,  1347,   247,  4354,  4355,   231,   638,   355,  2458,  1459,
     103,  1357,  1358,   258,   372,  3455,    74,   375,  2800,   416,
      12,  1367,  1368,  1369,  1370,  1371,  1372,   539,    16,    17,
     153,  1377,   189,   486,  3320,   181,  1275,  1383,  1384,  3170,
    1386,  2627,   228,  1389,    16,    17,  3695,  2633,   784,   329,
    3159,   372,   614,    33,   375,   582,  3342,  1370,   601,  1372,
     461,   247,   567,  1409,    19,   617,   133,   236,   425,  1367,
    1368,  1369,   258,  1371,   354,     0,   521,   613,   562,    59,
     632,   403,   543,  2551,   468,   567,  1384,   613,  3972,  3973,
     135,  1389,   355,   582,   578,   153,  1409,    16,    17,   617,
      12,  2551,   372,   630,   227,   375,   372,   120,   569,   375,
     151,   847,   372,  1459,   632,   375,   372,   206,   211,   375,
     617,   134,   398,  1362,  1470,    16,    17,   107,   477,  1475,
     110,   277,  1478,  1479,   414,   632,   372,  2941,   118,   375,
      95,    16,    17,   135,   103,  4036,   606,    16,    17,   625,
     626,   627,   628,   617,   983,   341,   601,    16,    17,    16,
      17,   250,  1475,    16,    17,   202,  1479,   587,   632,   227,
    1516,   403,   606,   521,   617,   588,   636,   372,  3923,   468,
     375,   125,   372,   388,  4075,   375,   309,   632,   631,  1535,
      39,  1537,  1538,    12,  1540,  1541,   151,    46,   189,   565,
     155,   617,   636,   162,  1033,    16,    17,  1553,   453,  1555,
     155,  3015,   358,   439,   341,   372,   632,   539,   375,   632,
      16,    17,   588,   135,   617,   638,  1465,  3876,   508,   184,
     617,   186,   355,   192,   229,  4119,  4120,   364,   631,  1537,
    1538,  2932,   468,   238,   235,   632,   630,   202,  4084,   418,
    4086,   372,   207,   601,   375,   155,    16,    17,   521,   617,
      16,    17,    24,  4313,  4314,   539,   221,   453,    16,    17,
     189,  3711,   372,   228,   632,   375,   508,   486,    16,    17,
     235,   162,  1628,  1629,  2836,  3416,   379,   231,    16,    17,
    1740,   349,   247,    16,    17,   388,   617,   355,    16,    17,
     468,   372,   395,   258,   375,   318,  2265,   122,   263,    16,
      17,   632,    12,   468,   202,  3165,   135,   272,  2672,  3169,
    2766,   630,  2836,  2162,   372,  2908,   468,   375,   560,   638,
    3922,  4215,   372,    16,    17,   375,   522,  2176,   601,   372,
     545,   630,   375,  1689,    16,    17,  4230,   617,  3060,   558,
     468,   617,   372,  2821,   523,   375,   582,   617,   468,   247,
    4244,   617,   632,   343,   422,   217,   632,   219,   600,  3060,
    2209,  2821,   632,    16,    17,   608,   632,    16,    17,    16,
      17,   617,   373,   378,   372,  1731,   341,   375,    16,    17,
    1840,  1737,   416,  1739,  1740,   468,   632,   490,   521,   632,
     372,   162,   556,   375,   630,  1751,    17,    16,    17,   364,
    1756,    12,  3759,   437,   588,  1761,   468,  4301,   373,  4172,
    4173,   567,   617,  3800,  3801,  3188,  3187,   617,  1774,  4313,
    4314,   192,    16,    17,   468,   135,   631,  4275,  3220,  2278,
    3787,   631,    16,    17,   403,   123,  1792,   471,   403,   635,
    1796,    16,    17,   372,   351,   352,   375,   631,   632,  2418,
     617,   588,   630,   521,   229,   227,  1812,  1813,  1814,  1815,
      16,    17,  3581,   238,  3060,   630,  4360,     6,   601,  1792,
    1826,   372,  1828,  1796,   375,   373,  4370,   638,   630,   287,
     288,  3805,   585,   202,  1840,   439,   617,   372,   453,   220,
     375,  1814,  1815,   372,   484,  3494,   375,  2416,   363,    12,
     631,  1857,   630,   372,   572,   372,   375,   617,   375,   372,
     630,   476,   375,  4407,   468,  4409,  1872,    56,    16,    17,
     624,   631,   210,   388,   135,  4419,    81,   631,    41,    16,
      17,    16,    17,   601,     8,   238,   617,   309,    16,    17,
      16,    17,  4436,   539,  4438,   100,  4440,   630,   592,   593,
     631,   372,  1908,  4447,   375,    29,   259,   522,   624,   617,
     225,  1810,   552,  4457,  1920,   631,   372,   617,   630,   375,
     539,  1927,   634,   631,   617,   542,    89,  4471,  4472,    24,
      93,   631,   225,   355,   130,  1908,   630,   617,   631,   225,
     580,   560,   280,  4487,  4488,  3736,    16,    17,  4492,   202,
     139,   631,   372,   378,  1927,   375,   372,   484,  3275,   375,
    2529,   576,   631,   632,   372,    16,    17,   375,  1867,   617,
     428,   429,   587,   588,   372,   506,   631,   375,   582,    74,
     630,   600,   220,   631,   372,   617,    17,   375,   638,   372,
    2833,   606,   375,   608,   372,   120,   527,   375,  2424,   631,
      16,    17,   367,  2113,   456,   372,  2875,  2117,   375,  2867,
     631,   632,  2881,   609,   610,   235,   631,   632,   143,    46,
     635,   636,    16,    17,   189,  2031,   630,  2875,   536,   372,
     545,   539,   375,  2881,  3094,   593,   632,   476,   617,  2045,
     372,   280,  1941,   375,  3287,  2155,  2883,   631,  2906,   636,
    2160,  1950,  1951,   580,   155,   180,    16,    17,  3118,  3119,
      16,    17,  1961,  1962,  1963,  1964,   617,  1966,  1967,   372,
     117,   536,   375,   372,   539,   372,   375,   172,   375,   242,
     631,  3141,   617,   638,   372,   537,   588,   375,   617,   583,
     542,    30,   548,   620,   595,  2521,   631,   598,   617,   521,
     617,   200,   631,   372,   617,   136,   375,  2113,   508,    95,
     369,  2117,   631,  2119,   631,     6,  2122,  3245,   631,   189,
     585,  2547,  2548,  2129,  2130,  2131,  2132,  2772,   372,  2135,
     632,   375,   227,   585,   181,   630,   638,    76,   372,   631,
     632,   375,    58,    59,  2254,   185,   617,   372,   600,  2155,
     375,    17,    68,    11,  2160,   318,  2129,  2130,  2131,  2836,
     631,   617,   209,   352,  2122,   548,   372,   631,   632,   375,
     630,  3299,  2071,    12,  2284,  2074,  2075,   439,  2077,   601,
     630,  2080,  2081,  2082,  2083,  2084,  2085,  2086,  4142,  3299,
    2089,   632,  2091,  4147,   630,  4149,  3354,   617,    57,  3357,
    3358,   617,   631,   632,  3332,   631,   632,   306,   307,   617,
     149,   631,   311,   312,   309,   631,  3374,   630,   381,   617,
     631,   632,  3332,   631,   372,   630,   415,   375,   417,   617,
     277,  4054,  4018,   631,   617,   372,   630,   372,   375,   617,
     375,   630,   228,   631,   372,   630,   372,   375,  2254,   375,
     617,   631,   632,   631,   349,  4046,  4047,  4048,  4049,   630,
     355,   247,  2761,   545,   631,    48,    74,   630,   174,   630,
     136,   630,   258,  2279,   617,   630,  4062,   364,  2284,  4065,
    4066,  4067,  4068,   630,  2818,   617,  4055,  1775,   631,    71,
    1778,    16,    17,  1781,   631,   632,   135,  2303,   106,   631,
     331,   630,   372,  2309,  2310,   375,  2312,   630,  3315,  3316,
     630,   358,   171,   630,   617,   166,   175,   630,   617,   630,
     617,   372,   631,   632,   375,    58,    59,   186,   631,   617,
     493,   718,   631,  2339,   631,   630,  2309,  2310,   630,  2312,
     631,   632,  3402,   631,   638,   153,   630,  3701,   617,   630,
    4141,   631,   632,   740,   630,   341,   372,  2467,  2468,   375,
     630,    74,   631,   631,   632,  2371,   753,   754,   221,  2375,
     533,   210,   630,   617,  2380,  2381,  2382,   274,   372,  3591,
    3238,   375,   630,   617,  4170,  4171,  2392,   631,  2394,  1049,
    1050,  1051,   617,  4179,    19,   631,   632,   631,   631,   632,
    3528,  1061,   630,   185,   630,  4174,   631,  2380,  2381,  2382,
    2416,   617,   372,   631,   632,   375,   372,   225,  3528,   375,
     631,   632,  2428,  2429,   588,   631,   521,  3639,  3442,   630,
    2540,   630,  1092,  4082,   491,  1095,   588,   589,    24,   591,
     153,   593,   630,   225,   117,   351,   352,   630,   479,   480,
     497,   357,  2458,   631,   632,   630,  1116,  1117,   317,   398,
    1120,  2467,  2468,   631,   632,   331,    31,   453,   250,   617,
      95,   630,  3936,  3937,   631,   632,    61,   630,  1138,  1139,
     617,   420,   617,   631,   631,   632,    71,   630,    74,   617,
     630,   617,   630,  2392,   631,    48,   631,   631,   632,    84,
     308,    74,  2508,   631,   462,   631,   601,  2513,   181,   630,
      11,  2509,  2518,  2519,   227,   454,   630,  2523,   326,  2525,
     567,  4053,  2520,  3466,   631,   632,   151,   630,  2526,  2535,
     155,  2537,  2538,   630,  2540,  2541,   522,  3440,  3441,   630,
    2546,   349,   630,  2549,   217,  2551,   219,   617,   631,   632,
     631,   632,  2550,   412,  2560,   631,   632,  2555,   631,   632,
     632,   186,   630,  2561,  2562,  2571,   617,   153,   631,   632,
     630,   136,  2578,  2579,   513,   631,   632,   202,   631,   632,
     631,   630,   207,   576,  2590,   630,   172,  2560,   631,   632,
     621,   622,   623,   624,   625,   626,   627,   628,   631,   632,
     185,   617,   103,   228,   277,   630,   191,   631,   632,    12,
     235,   631,   632,   479,   480,   631,   631,   632,   630,   401,
     630,   122,   247,   617,   136,   630,   287,   288,  2527,  2528,
    3129,   631,   632,   258,   630,   117,   349,   631,   263,   630,
     225,   227,   355,   630,   117,    25,    26,   272,  2654,  2655,
     631,   632,   630,    35,   227,  2554,   562,   617,   630,  3882,
    3883,   617,   630,   502,   503,   250,   505,    77,   507,    79,
     625,   631,   578,   238,   476,   631,   155,   156,    58,    59,
      60,  2654,  3181,   522,  3587,   358,   631,   632,    68,   630,
      95,   192,   630,    24,    74,   630,   468,   262,   630,   181,
     631,   632,    82,   630,   476,  3274,  4529,   630,   181,   422,
     120,   631,   632,   521,   193,   630,   341,   631,   632,   630,
     221,   631,   632,   309,  2623,   204,   106,   209,   110,   537,
     631,   632,   135,   143,   630,   117,   209,   145,   146,   364,
     120,   630,    25,    74,   124,   631,   632,   630,   373,  3737,
    3738,  1124,  1125,  4172,  4173,   621,   622,   623,   624,   625,
     626,   627,   628,   349,   243,   638,   331,   428,   429,   355,
     180,   117,   273,   153,   120,   254,   349,  2783,   403,  3424,
      61,  2787,   355,  3258,  3259,    68,   351,   352,   638,    72,
      71,    74,   174,  2799,   161,   277,  3509,  3510,   630,   181,
     385,   263,   281,    84,   277,  4028,   517,   210,   521,  4032,
     136,  2817,  2818,  3747,  3748,  2821,   401,   186,   536,   331,
     592,   593,   153,   228,   161,   517,  2799,   209,   453,   274,
    2836,   152,  2838,   115,   632,   181,    83,   120,   499,   500,
     501,   172,   247,   632,   632,   225,  2852,   365,   532,   422,
     631,   476,   232,   258,  2964,   151,   120,   106,   630,   572,
     425,   637,     6,   209,  3913,   630,   345,   105,    71,   249,
       4,  4094,  4095,    25,    26,   632,   358,   388,  3821,   467,
     600,   238,   632,  3452,  3827,   358,   385,    55,   601,  3792,
    3793,   136,  3795,  3796,   567,   277,   227,   522,   431,   166,
    1560,   106,   403,   218,   185,   632,    58,    59,    60,   494,
     191,   632,   638,    68,   479,   480,    68,    12,   605,   632,
     135,   631,    74,   631,  4052,     9,   632,   492,   308,   638,
      82,   277,   631,   631,   216,   521,   341,  2943,   631,   630,
    2946,  2947,  4052,   638,   225,  2951,   326,   632,   521,   262,
     638,   576,    35,  2852,   106,   153,   632,   637,  2964,   364,
     342,  2967,   274,   588,   274,   274,   274,   250,   120,   250,
    1630,   353,   124,   474,  1634,   357,   358,    48,   309,  2985,
     274,   606,   185,   608,   274,  2884,  2885,  2993,  2887,   632,
     632,  2997,   577,   238,   155,   402,  3614,  3615,  1658,   572,
     380,   153,  4120,   456,   370,   331,   631,   632,   388,  3627,
     635,   636,   358,   423,   136,   601,  3634,  3023,   349,   536,
    3026,   364,   225,   364,   355,  3031,   632,   110,   601,   269,
     632,  3037,   386,   632,   117,  3041,   537,  3043,   539,   321,
     556,  3659,   632,   325,  3662,   385,   632,   250,   453,   556,
     332,    12,  3058,  3026,   632,   155,   621,   622,   623,   624,
     625,   626,   627,   628,   364,  3071,  2965,   364,   351,   352,
     632,    68,  3078,   225,   357,  2974,   632,   625,   458,  3037,
     232,   364,   238,  3089,   585,   567,   331,   241,   534,   176,
     186,   174,   632,   581,   567,   489,   389,   249,   181,   502,
     503,   504,   505,   506,   507,  3078,   131,   169,  3753,   364,
     262,   623,   624,   625,   626,   627,   628,   522,   401,   522,
     401,  2310,   632,  2312,   632,    95,   209,  4255,   410,   631,
     587,   155,   155,   155,   514,   515,   516,   155,   155,   155,
     155,   521,   521,   522,   155,  4255,   525,   526,   155,   155,
     529,  3261,   531,   479,   480,   155,   308,   537,   632,  4102,
     540,  4004,   117,   545,  3063,   120,   155,   549,   155,  3175,
     552,   155,   155,  4016,   326,   155,   155,  3183,   155,   155,
     562,   155,   385,  4301,   466,   567,   155,    33,   570,   472,
     521,  2380,  2381,  2382,   277,   155,   576,   103,   401,  3768,
     117,   155,  3208,   120,   155,  3211,  3212,  3213,  3214,   331,
     583,   612,   632,   494,   192,   364,   364,   364,   189,   631,
    3226,   567,   631,   189,   576,   631,   181,   136,   380,   631,
     625,   631,   631,   631,   479,   480,   388,   630,   521,  3245,
    3246,   623,   624,  3249,   631,   477,   632,  3253,  3254,  3255,
     624,   632,   632,   631,   209,  3261,   162,   632,   228,   342,
     631,  3267,   632,   631,   181,   628,   631,   631,  3274,  3275,
     601,   631,   631,   631,   357,   358,   631,   247,   536,   630,
     117,  4330,   128,   120,  3183,   630,   192,   103,   258,  4407,
     606,  4409,   209,  3299,   577,    74,   577,   623,   624,   625,
     626,   627,   628,  4161,  3310,   630,   458,   153,   545,    88,
     545,   157,   545,   630,  3320,   226,  3322,   528,  4436,   225,
      11,   603,   277,   630,   630,   260,  3332,   632,   630,   238,
     189,   630,  3338,    13,  3340,   638,  3342,   619,   411,   585,
     632,   632,   186,   638,   181,  3455,  3917,   631,   194,   638,
     129,   638,   476,  4471,  4472,   632,   632,   479,   480,    46,
     277,   467,   514,   515,   516,   508,   212,   273,   508,   521,
     508,   341,   209,  4501,  4423,   191,   621,   622,   623,   624,
     625,   626,   627,   628,  3283,   537,   339,  4515,   540,   508,
     508,  4501,  4520,   388,   364,    71,   556,  4525,  4341,  4342,
     385,  4344,   131,   358,   385,  4515,   248,   537,  3414,   225,
    4520,   537,  3998,   385,    94,  4525,   248,   385,   131,    46,
     385,   385,   331,    54,   576,   387,   805,   385,   274,   385,
     434,   630,    63,  3439,  3440,  3441,   385,   630,  3548,   136,
     277,   358,    73,   273,   630,   125,   588,   638,  4391,  3455,
    4393,  4394,   631,   149,    85,    86,    87,   273,   631,   139,
     234,   234,   545,   638,   631,   631,   549,   631,   631,   552,
     101,   155,   631,   252,   631,   556,   545,   613,   630,   562,
     631,   269,   162,   453,   567,   165,   632,   570,    46,   155,
    4135,   632,   398,   632,   155,   630,  4133,   403,   178,  4070,
     622,   623,   624,   625,   626,   627,   628,   630,  3407,   630,
     556,    16,    17,   630,   200,   189,   235,  3523,   189,   545,
     200,   358,  3528,   244,   545,  4468,  3636,   416,   632,     6,
     358,  3430,   155,  3539,    11,   155,    13,  4483,    15,   632,
     623,   624,  3548,   155,   247,   225,   247,   388,    25,    26,
     329,   231,   522,   376,   322,    54,   402,   106,   106,   169,
     250,   250,   638,   556,    63,   411,   630,   630,   474,   369,
     479,   480,   351,   352,    73,   354,   202,    19,   545,    56,
     426,  3587,   449,    60,    61,   630,    85,    86,    87,    66,
    3596,   385,   272,   625,   638,   630,   630,    74,   444,  3605,
    3598,  3711,   101,   630,   236,    82,   111,   112,   113,   114,
     115,   236,   567,   632,    91,    12,    13,   631,   631,   631,
     556,   631,   630,  3596,   556,   556,   364,   632,   631,   106,
    3636,   537,   221,   631,   331,   414,   542,   155,   630,   638,
     631,   487,   638,   120,   638,   631,   264,   124,   385,   631,
     567,   189,   370,   189,   560,   132,   133,  3663,   474,  3558,
    3770,   179,   139,   638,  3670,  4523,   189,   582,   416,   632,
     147,   517,   238,   632,   151,   193,   153,   155,   494,   585,
     121,   631,  3688,   631,   631,   247,   204,   164,  4257,   320,
     536,   247,   364,   539,   600,  3701,   250,    94,   632,   250,
     630,   608,   364,   632,   632,  3711,   337,   184,   213,   214,
     215,   216,   621,   622,   623,   624,   625,   626,   627,   628,
     630,   537,   399,   539,   404,   364,   542,   631,   125,   508,
     567,   632,    74,    12,    13,   253,   254,    19,   631,  3638,
    4377,   632,   139,   630,   424,   364,   223,   364,   225,   491,
     631,   468,   432,   630,   630,   232,   630,   373,   358,   631,
     440,   577,    46,   281,  3770,   162,   470,   631,   165,   585,
     608,   631,   249,   260,   272,    11,   451,  3783,  3677,   416,
     625,   178,   479,   480,   142,   256,  3792,  3793,   468,  3795,
    3796,   631,   631,   189,   202,   272,   632,   478,   155,   390,
     247,   481,   482,   200,   247,   632,   630,   120,   120,   539,
     630,   397,    33,  3923,  4385,    94,   321,   448,   323,   324,
     325,   320,   630,   638,    78,   631,   486,   332,   225,   138,
     348,   308,   491,   464,   231,   463,   631,    19,   337,   632,
    4477,   631,   631,   263,   631,   631,   125,   631,   631,   326,
    4215,   531,    33,   330,    33,   631,   631,   252,   328,   631,
     139,  3867,  3868,   632,   631,  4230,  4503,   372,   411,   631,
     375,   170,   272,  3879,  3773,   272,   200,   630,   632,  4244,
     560,  4526,   400,   162,   235,   631,   165,   638,    46,   207,
     328,   368,   632,   524,   155,  3868,   373,   630,   630,   178,
     588,   305,   582,   380,   584,   410,  3912,   128,   385,  3915,
     541,   388,   582,   598,   630,   588,   630,  3923,   630,   598,
     631,   200,   630,   630,   621,   622,   623,   624,   625,   626,
     627,   628,   153,   120,   250,   250,   157,    33,   357,  3912,
     358,   358,   419,   328,   168,   370,   225,   630,  3954,   519,
     632,   608,   231,   631,   250,   539,   433,   434,   435,   436,
     465,   466,   631,  3969,   588,   464,   630,   588,  3974,   235,
     592,   364,   353,   194,   632,   512,   449,   547,   593,   608,
     358,   458,   631,   582,   632,   111,   112,   113,   114,   115,
     631,   212,   545,   272,   527,  4360,   630,   630,   545,   545,
     630,   150,   605,    30,   639,  4370,   186,   404,   383,  2074,
    2075,   408,  2077,   547,   370,  2080,  2081,  2082,  2083,  2084,
    2085,  2086,   631,   631,  2089,   524,  2091,   424,   131,   631,
     131,   153,   630,   403,    70,   432,   186,   514,   515,   516,
     424,   605,   541,   440,   521,   189,  4052,    30,   631,    61,
     370,    61,   632,   274,  4419,   631,   630,    14,   265,   528,
     537,     5,   364,   540,   364,  4175,   235,   149,   636,   370,
     129,   468,   370,  4438,   138,  4440,    46,    46,  4084,   148,
    4086,    46,  4447,    46,   481,   482,   563,   213,   214,   215,
     216,   630,  4457,    46,   582,   665,   125,   605,   603,   576,
     670,   630,   630,   149,   220,   279,  4112,   639,   119,   636,
     144,   630,   617,   618,   619,    46,    46,    46,  4017,    52,
     548,   138,  4487,  4488,   636,   404,   459,  4492,   457,   408,
     632,   701,   358,   149,   531,   631,   548,   632,   205,   632,
     218,   547,   636,   632,   149,   424,   631,   717,   631,    52,
      46,   186,   438,   432,   186,   186,   548,   607,   120,   636,
    4166,   440,   358,   560,   221,  4275,   630,   188,   476,  4175,
     632,  3979,  2291,  3416,  2093,  3417,   648,  2496,  3686,  4320,
    4009,   402,  4136,  4321,  3684,   582,   967,   584,  4503,   468,
     411,   761,   762,   763,   764,   321,  3688,   323,   324,   325,
    3866,  4465,   481,   482,   774,   426,   332,    46,   576,  1825,
    1761,  3857,  2783,  3857,  3857,  3857,  3857,  3857,  3857,  4473,
    3857,  4208,  3857,   444,  3857,  4357,  4336,  4357,  3857,  4314,
    3857,  4234,  3857,  4233,  1468,  2044,  1472,  1008,  2812,  2991,
    3522,  3875,  2817,  1286,  4166,  3913,  3226,  4259,  3525,  4255,
    4423,  1530,   531,  4070,  4338,   514,  4385,  2037,  3433,  3064,
    2655,  2045,  3320,  3342,   670,  2581,   487,  3398,  3365,  4275,
    4169,  3819,  3365,  3597,  3647,  4257,  3636,  2467,  2739,  3166,
    3169,   560,  3161,    11,   410,    11,  4095,  4091,  1544,  4020,
    4032,  4028,  2127,  3879,  4094,   701,   517,  3827,  2044,  2574,
    3602,   579,  2366,   582,  1419,   584,  3321,  1423,  1526,  1814,
    1479,   717,  2799,  2332,   222,  3221,  2383,  2247,   595,  1834,
     865,  3183,  1087,  2772,  2161,  3289,  2459,  3939,  2246,  4089,
    4336,  3414,  4352,  1061,  4353,  2272,  3332,  1438,  4454,   465,
     466,  3784,  3770,  1198,  2388,  2132,  4352,  4353,   953,   953,
    1274,  2327,  2370,  1299,  3528,  3240,  4362,  3239,   764,   953,
    3299,   584,  4255,  4369,  1553,   953,   661,  4266,  4267,  1904,
     575,  1905,  1403,  1375,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,  3340,   293,   294,   295,   296,   297,
     298,   299,   300,   301,  1750,   303,   304,  3224,  1306,  4421,
    4450,  4511,  4282,  4520,  4348,  4525,  3639,  3245,  1335,  2413,
    3274,   574,  1686,   574,  3275,  2405,  1860,  2406,  1829,  2399,
     990,   850,  1322,  4044,  1796,  1535,  3208,  4050,   569,   852,
    1783,  4437,  3999,   510,   510,  3672,  4442,   648,   648,   648,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4477,    -1,    -1,    -1,  1045,  1046,   603,    -1,    -1,
      -1,    -1,    -1,    -1,  1054,  1055,  1056,  1057,  1058,  1059,
    1060,    -1,   618,   619,    -1,  4501,    -1,  4503,  1068,  1069,
      -1,  1071,  1072,    -1,    -1,  4511,  1076,  1077,    -1,  4515,
    1080,  1081,  1082,  1083,  4520,  1085,  1086,    -1,    -1,  4525,
     428,   429,    -1,  1093,  1094,    -1,  1096,  1097,  1098,  1099,
    1100,    -1,    -1,  1103,  1104,  1105,  1106,  1107,  1108,  1109,
    1110,  1111,  1112,  1113,    -1,  1115,    -1,    -1,  1118,  1119,
      -1,    -1,    -1,  1123,    -1,    -1,    -1,  1127,  1128,  1129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1140,  1141,  1142,    -1,    -1,    -1,    -1,    -1,    -1,  1149,
      -1,    -1,    -1,    -1,   990,    -1,  1156,  1157,  1158,    -1,
    1160,    -1,    -1,    -1,    -1,    -1,    -1,  1167,  1168,  1169,
      -1,  1171,  1172,  1173,  1174,  1175,    -1,  1177,  1178,  1179,
    1180,  1181,  1182,  1183,  1184,    -1,    -1,    -1,  1188,  1189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1045,
    1046,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1054,  1055,
      -1,    -1,  1058,  1059,  1060,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1068,  1069,    -1,  1071,  1072,    -1,    -1,    -1,
    1076,    -1,    -1,    -1,  1080,  1081,  1082,  1083,    -1,  1085,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1093,  1094,    -1,
    1096,  1097,    -1,    -1,    -1,    -1,    -1,  1103,  1104,  1105,
      -1,    -1,  1108,  1109,  1110,  1111,  1112,  1113,    -1,  1115,
      -1,    -1,  1118,  1119,    -1,    -1,    -1,  1123,    -1,    -1,
      -1,  1127,  1128,  1129,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1140,  1141,  1142,    -1,    -1,    -1,
      -1,    -1,    -1,  1149,    -1,    -1,    -1,    -1,    -1,    -1,
    1156,  1157,  1158,    -1,    -1,    13,    -1,    15,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1335,    -1,    -1,    -1,    -1,
      -1,    -1,    30,    -1,    -1,  1345,    34,    -1,    -1,    -1,
      -1,    -1,    -1,  1189,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    -1,  1363,    -1,    -1,    -1,    -1,    56,    -1,
      -1,    -1,    60,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,    15,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,   126,   127,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    -1,    -1,    -1,
     138,   139,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,
      -1,    -1,    -1,   151,    -1,    56,    -1,    -1,    -1,    60,
      61,    -1,    -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,  1335,
      -1,    -1,    -1,    94,    -1,    -1,    -1,    -1,    -1,  1345,
     198,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,
     208,    -1,    -1,    -1,    -1,   116,    -1,  1363,    -1,    -1,
      -1,    -1,    -1,    -1,   125,   126,   127,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,   233,    -1,   138,   139,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   251,    -1,    -1,  1566,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,    -1,    -1,
     268,    -1,    -1,    -1,   272,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     251,    -1,    -1,    -1,  1664,  1665,  1666,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   268,    -1,  1679,
     368,   272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1705,    -1,    -1,    -1,    -1,
     398,  1711,    -1,    -1,  1714,    -1,  1716,    -1,    -1,    -1,
      -1,   409,  1722,    -1,  1724,  1725,    -1,    -1,    -1,    -1,
    1566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   431,    -1,    -1,   434,    -1,   436,    -1,
      -1,   439,    -1,    -1,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   452,    -1,   454,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   462,    -1,    -1,   368,    -1,    -1,
     468,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   476,    -1,
      -1,    -1,    -1,   481,   385,   483,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   398,    -1,  1809,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,
      -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,  1664,  1665,
    1666,    -1,   520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     431,    -1,    -1,   434,    -1,   436,    -1,    -1,   439,    -1,
      -1,   442,   443,    -1,    -1,    -1,    -1,    -1,  1858,    -1,
      -1,   452,    -1,   454,    -1,    -1,  1866,    -1,    -1,  1705,
      -1,   462,    -1,    -1,    -1,   563,    -1,   468,  1714,    -1,
    1716,    -1,    -1,    -1,    -1,   476,    -1,   575,    -1,    -1,
     481,   579,   483,    -1,   582,    -1,    -1,    -1,    -1,   587,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   513,    -1,    -1,    -1,    -1,   615,    -1,   520,
      -1,    -1,    -1,    33,    34,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,   563,  1809,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,   579,    -1,
      -1,   582,    92,    -1,    94,    -1,   587,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1858,    -1,   615,    -1,    -1,    -1,    -1,    -1,
    1866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   630,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,   153,    -1,    -1,    -1,    -1,   158,    -1,
      -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,  2068,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2141,    -1,    -1,    -1,  2145,    -1,    -1,   248,    -1,
    2150,  2151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2159,
      -1,    -1,  2162,    -1,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,  2172,  2173,    -1,  2175,  2176,    -1,  2178,  2179,
    2180,  2181,  2182,    -1,    -1,  2185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2194,    -1,    -1,    -1,    -1,    -1,
      -1,  2201,   302,  2203,    -1,  2205,  2206,    -1,  2208,  2209,
      -1,    -1,    -1,  2213,  2214,  2215,    -1,    -1,    -1,  2219,
    2220,  2221,    -1,  2223,    -1,  2225,    -1,  2227,    -1,  2229,
      -1,  2231,  2068,    -1,    -1,    -1,  2236,    -1,    -1,    -1,
      -1,    -1,    32,    33,    -1,    -1,    -1,    -1,    38,    -1,
      40,    -1,    42,    43,    -1,  2255,    -1,    -1,    -1,    -1,
      -1,    -1,  2262,    -1,    -1,  2265,    -1,   367,    -1,    59,
      -1,  2271,    -1,    -1,  2274,    -1,    -1,    -1,  2278,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   402,   403,    -1,  2141,   406,   407,    -1,  2145,
      -1,    -1,    -1,    -1,  2150,  2151,    -1,   107,    -1,    -1,
     110,    -1,    -1,  2159,    -1,    -1,    -1,   427,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2172,  2173,    -1,  2175,
    2340,    -1,  2178,  2179,  2180,  2181,  2182,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2194,    25,
      26,    -1,    -1,    -1,   154,  2201,    -1,  2203,    -1,  2205,
    2206,    -1,  2208,   473,    -1,    -1,    -1,  2213,  2214,  2215,
      -1,    -1,    -1,  2219,  2220,  2221,   486,  2223,    -1,  2225,
     180,  2227,   182,  2229,    60,  2231,    -1,    -1,    -1,    -1,
    2236,    -1,    -1,    -1,    -1,   195,   196,    -1,    74,    -1,
      -1,    -1,    -1,    -1,  2414,    -1,    82,   517,  2418,  2255,
      -1,   521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2271,    -1,    -1,  2274,   539,
     106,    -1,    -1,    -1,    -1,    -1,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,   124,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   266,    -1,    -1,  2479,
      -1,    -1,    -1,    -1,    -1,   275,   276,   153,   278,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   596,  2497,  2498,    -1,
      -1,    -1,   602,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   314,   315,   316,    -1,    -1,    -1,
      -1,    -1,     6,    -1,    -1,    -1,    -1,    11,    -1,    13,
      -1,    -1,    -1,   333,   334,   335,    -1,    -1,    -1,    -1,
     340,    25,    26,   343,    -1,    -1,    -1,    -1,    -1,   225,
      -1,    -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
     360,   361,    -1,    -1,    -1,    -1,    -1,    -1,  2414,    -1,
      -1,    -1,    56,   249,    -1,    -1,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    -1,    -1,   393,   394,    -1,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    25,    26,
      -1,    -1,    -1,    -1,    -1,  2625,  2626,    -1,   418,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   308,    -1,    -1,    -1,   120,    -1,    -1,    -1,
     124,    58,    59,    60,    -1,    -1,    -1,    -1,   132,    -1,
     326,    68,    -1,    -1,    -1,   139,    -1,    74,    -1,    -1,
      -1,    -1,    -1,   147,    -1,    82,  2676,    -1,    -1,   153,
    2680,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   488,   106,
    2700,  2701,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     184,    -1,    -1,   120,   380,    -1,    -1,   124,    -1,    -1,
      -1,  2721,   388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2730,    -1,  2732,    -1,  2734,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,
      -1,   225,    -1,    -1,    -1,    -1,   546,    -1,   232,   549,
      -1,  2761,   552,   553,   554,   555,  2766,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   249,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   458,    -1,    -1,  2795,    -1,    -1,   272,    -1,
      -1,    -1,    -1,    -1,   594,   595,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,
      -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,   619,
      -1,    -1,    -1,    -1,   308,    -1,    -1,    -1,    -1,    -1,
    2676,    -1,   249,    -1,  2680,    -1,    -1,    -1,   514,   515,
     516,    -1,   326,    -1,    -1,   521,   330,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2700,  2701,    -1,    -1,    -1,    -1,
      -1,   537,    -1,    -1,   540,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2721,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2730,    -1,  2732,    -1,  2734,   373,
      -1,   308,    -1,    -1,    -1,    -1,   380,    -1,    -1,    -1,
     576,    -1,    -1,  2913,   388,    -1,    -1,    -1,    -1,   326,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,
     434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   380,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   388,    -1,    -1,   458,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3034,  3035,    -1,    -1,    -1,    -1,
     514,   515,   516,    -1,    -1,    -1,    -1,   521,    -1,    -1,
      -1,   458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3059,
      -1,    -1,    -1,   537,    -1,    -1,   540,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2913,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3097,    -1,    -1,
      -1,    -1,   576,    -1,    -1,    -1,    -1,   514,   515,   516,
      -1,    -1,    -1,    -1,   521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3122,    -1,    -1,    -1,  3126,  3127,    -1,  3129,
     537,    -1,    -1,   540,    -1,    -1,    -1,    -1,  3138,    -1,
      -1,    -1,    -1,  3143,    -1,    -1,  3146,    -1,  3148,  3149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3034,  3035,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3239,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3097,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3273,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3122,    -1,    -1,    -1,
    3126,  3127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3301,  3138,    -1,    -1,    -1,    -1,  3143,    -1,  3309,
    3146,    -1,  3148,  3149,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3239,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3273,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3301,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3309,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3529,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3570,  3571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3579,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3529,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3719,
      -1,    -1,    -1,  3723,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3570,  3571,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3579,    -1,    -1,    -1,    -1,    -1,    -1,
    3750,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3765,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3857,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3719,    -1,    -1,    -1,  3723,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3913,  3750,    -1,    -1,    -1,    -1,    -1,
      -1,  3921,    -1,    -1,    -1,    -1,    -1,    -1,  3928,  3765,
    3930,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3966,    -1,    -1,    -1,
      -1,    -1,  3972,  3973,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4036,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4075,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3921,    -1,    -1,    -1,    -1,
      -1,    -1,  3928,    -1,  3930,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4105,    -1,  4107,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4117,    -1,  4119,
    4120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4146,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4036,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4213,    -1,  4215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4230,  4231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4075,
      -1,    -1,    -1,    -1,  4244,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4105,
      -1,  4107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4300,  4301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4313,  4314,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4360,    -1,    -1,    -1,    -1,    -1,    -1,  4367,    -1,    -1,
    4370,    -1,    -1,    -1,    -1,    -1,    -1,  4213,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4231,    -1,    -1,    -1,    -1,
    4400,    -1,    -1,    -1,    -1,    -1,    -1,  4407,    -1,  4409,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4419,
    4256,    -1,    -1,  4423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4436,    -1,  4438,    -1,
    4440,    -1,    -1,    -1,    -1,    -1,    -1,  4447,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4457,    -1,    -1,
      -1,    -1,    -1,    -1,  4300,    -1,    -1,    -1,    -1,    -1,
      -1,  4471,  4472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4487,  4488,    -1,
      -1,    -1,  4492,    -1,    -1,    -1,    -1,    -1,  4498,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4528,    -1,
      -1,  4367,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,  4400,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    44,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,  4498,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,  4528,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,   255,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
     557,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
     189,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    35,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
     637,   638,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,   191,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,   225,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,   250,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,   262,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,   468,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   638,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,   191,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,   225,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,   250,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,   638,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,   468,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,   631,    -1,    -1,    18,    -1,    -1,
      21,   638,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,    -1,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
     631,    14,    -1,    -1,    -1,    18,   637,   638,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,   630,    -1,    14,
      -1,    -1,    -1,    18,    -1,   638,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,   638,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,   630,    -1,    14,    -1,    -1,    -1,    18,    -1,   638,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,    -1,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,    -1,     5,   625,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,   638,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,   637,   638,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,    -1,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,    -1,   619,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   638,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
      -1,   619,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     638,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,   638,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,    -1,   619,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   638,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,   261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,   545,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,   261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,   545,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    -1,   637,    23,    24,
      25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,
      55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    -1,
      75,    -1,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,    -1,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
      -1,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
      -1,   206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,   246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,    -1,    -1,
     435,    -1,   437,   438,    -1,   440,    -1,    -1,    -1,   444,
      -1,    -1,   447,   448,   449,   450,   451,    -1,    -1,    -1,
     455,   456,   457,   458,   459,   460,   461,    -1,   463,   464,
      -1,   466,    -1,    -1,    -1,    -1,   471,   472,   473,    -1,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,    -1,
     485,    -1,   487,    -1,   489,    -1,    -1,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,    -1,   514,
     515,   516,   517,    -1,    -1,    -1,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,    -1,
      -1,    -1,    -1,   578,    -1,    -1,   581,    -1,    -1,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,   607,    -1,    -1,    -1,   611,    -1,    -1,   614,
      -1,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,   632,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,     5,   619,     7,     8,
       9,    10,    11,   625,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,     5,
     619,     7,     8,     9,    10,    11,   625,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,     5,   619,     7,     8,     9,    10,    11,   625,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,     5,   619,     7,     8,     9,
      10,    11,   625,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,    -1,    -1,   358,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,   496,   497,   498,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,   567,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,     5,   619,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,   155,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
     477,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,     5,   619,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,   545,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,     5,   619,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,   567,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,     5,   619,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,   545,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
       5,   619,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    99,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      12,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,   261,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,   545,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,     5,   619,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    35,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,     5,
     619,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,   545,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,     5,   619,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,   261,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,     5,   619,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,   261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,   545,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,     5,   619,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,     5,   619,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,   167,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,    -1,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,     5,   619,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,   497,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,    -1,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,     5,   619,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
       5,   619,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,     5,   619,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,     5,
     619,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,     5,   619,     7,     8,     9,    10,    11,    12,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,     5,   619,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,     5,   619,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,   401,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,     5,   619,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,   545,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,     5,   619,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,    -1,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,     5,   619,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
       5,   619,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,
      25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,
      55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    -1,
      75,    -1,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,
     145,   146,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
      -1,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
      -1,   206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,   246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,    -1,    -1,
     435,    -1,   437,   438,    -1,   440,    -1,    -1,    -1,   444,
      -1,    -1,   447,   448,   449,   450,   451,    -1,    -1,    -1,
     455,   456,   457,   458,   459,   460,   461,    -1,   463,   464,
      -1,   466,    -1,    -1,    -1,    -1,   471,   472,   473,    -1,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,    -1,
     485,    -1,   487,    -1,   489,    -1,    -1,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,    -1,   514,
     515,   516,   517,    -1,    -1,    -1,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,    -1,
      -1,    -1,    -1,   578,    -1,    -1,   581,    -1,    -1,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,   607,    -1,    -1,    -1,   611,    -1,    -1,   614,
      -1,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    -1,
      -1,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    -1,    75,    -1,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    -1,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,    -1,   145,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,    -1,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,   177,   178,   179,   180,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,    -1,   206,    -1,    -1,    -1,    -1,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,   246,    -1,    -1,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,   279,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,    -1,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,   381,
      -1,    -1,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,    -1,    -1,   435,    -1,   437,   438,    -1,   440,    -1,
      -1,    -1,   444,    -1,    -1,   447,   448,   449,   450,   451,
      -1,    -1,    -1,   455,   456,   457,   458,   459,   460,   461,
      -1,   463,   464,    -1,   466,    -1,    -1,    -1,    -1,   471,
     472,   473,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,    -1,   485,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,    -1,   514,   515,   516,   517,    -1,    -1,    -1,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,    -1,    -1,    -1,    -1,   578,    -1,    -1,   581,
      -1,    -1,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,   605,    -1,   607,    -1,    -1,    -1,   611,
      -1,    -1,   614,    -1,   616,    -1,     5,   619,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    -1,    -1,    23,    24,    25,    26,    27,    -1,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    -1,    75,    -1,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    -1,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,    -1,
      -1,    -1,   141,   142,   143,    -1,   145,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,    -1,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,   177,   178,
     179,   180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,    -1,   206,    -1,    -1,
      -1,    -1,    -1,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,   246,    -1,    -1,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
     279,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   380,   381,    -1,    -1,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,    -1,    -1,   435,    -1,   437,   438,
      -1,   440,    -1,    -1,    -1,   444,    -1,    -1,   447,   448,
     449,   450,   451,    -1,    -1,    -1,   455,   456,   457,   458,
     459,   460,   461,    -1,   463,   464,    -1,   466,    -1,    -1,
      -1,    -1,   471,   472,   473,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,    -1,   485,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,    -1,   514,   515,   516,   517,    -1,
      -1,    -1,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,    -1,    -1,    -1,    -1,   578,
      -1,    -1,   581,    -1,    -1,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,   605,    -1,   607,    -1,
      -1,    -1,   611,    -1,    -1,   614,    -1,   616,    -1,     5,
     619,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,    -1,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
     246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   380,   381,    -1,    -1,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,    -1,
      -1,    -1,    -1,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,    -1,    -1,   435,
      -1,   437,   438,    -1,   440,    -1,    -1,    -1,   444,    -1,
      -1,   447,   448,   449,   450,   451,    -1,    -1,    -1,   455,
     456,   457,   458,   459,   460,   461,    -1,   463,   464,    -1,
     466,    -1,    -1,    -1,    -1,   471,   472,   473,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,    -1,   485,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,    -1,   514,   515,
     516,   517,    -1,    -1,    -1,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,    -1,    -1,
      -1,    -1,   578,    -1,    -1,   581,    -1,    -1,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,   607,    -1,    -1,    -1,   611,    -1,    -1,   614,    -1,
     616,    -1,     5,   619,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,
      23,    24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,
      -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    -1,    75,    -1,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    -1,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,    -1,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,    -1,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,   177,   178,   179,   180,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,    -1,   206,    -1,    -1,    -1,    -1,    -1,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,   246,    -1,    -1,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,    -1,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,   381,    -1,
      -1,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
      -1,    -1,   435,    -1,   437,   438,    -1,   440,    -1,    -1,
      -1,   444,    -1,    -1,   447,   448,   449,   450,   451,    -1,
      -1,    -1,   455,   456,   457,   458,   459,   460,   461,    -1,
     463,   464,    -1,   466,    -1,    -1,    -1,    -1,   471,   472,
     473,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,    -1,   485,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
      -1,   514,   515,   516,   517,    -1,    -1,    -1,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
      -1,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,    -1,    -1,    -1,    -1,   578,    -1,    -1,   581,    -1,
      -1,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,   607,    -1,    -1,    -1,   611,    -1,
      -1,   614,    -1,   616,    -1,     5,   619,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    -1,    -1,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,    -1,
      -1,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    -1,    75,    -1,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    -1,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,    -1,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,   177,   178,   179,
     180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,    -1,   206,    -1,    -1,    -1,
      -1,    -1,   212,    -1,    -1,    -1,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,   246,    -1,    -1,   249,
      -1,    -1,    -1,   253,    -1,    -1,   256,   257,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,   279,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     380,   381,    -1,    -1,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,    -1,    -1,   435,    -1,   437,   438,    -1,
     440,    -1,    -1,    -1,   444,    -1,    -1,   447,   448,   449,
     450,   451,    -1,    -1,    -1,   455,   456,   457,   458,   459,
     460,   461,    -1,   463,   464,    -1,   466,    -1,    -1,    -1,
      -1,   471,   472,   473,    -1,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,    -1,   485,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,    -1,   514,   515,   516,   517,    -1,    -1,
      -1,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,    -1,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,    -1,    -1,    -1,    -1,   578,    -1,
      -1,   581,    -1,    -1,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,   607,    -1,    -1,
      -1,   611,    -1,    -1,   614,    -1,   616,    -1,     5,   619,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,    -1,
      57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    -1,    75,    -1,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,    -1,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,    -1,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
     177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,   206,
      -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,   246,
      -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   380,   381,    -1,    -1,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,    -1,   