/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.servlet;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class C3P0StatusServlet
extends HttpServlet {
    static /* synthetic */ Class class$com$mchange$v2$c3p0$ComboPooledDataSource;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$PoolBackedDataSource;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            DateFormat df = DateFormat.getDateTimeInstance();
            String titleStr = "C3P0 Status - " + df.format(new Date());
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = fact.newDocumentBuilder();
            Document doc = db.newDocument();
            Element htmlElem = doc.createElement("html");
            Element headElem = doc.createElement("head");
            Element titleElem = doc.createElement("title");
            titleElem.appendChild(doc.createTextNode(titleStr));
            Element bodyElem = doc.createElement("body");
            Element h1Elem = doc.createElement("h1");
            h1Elem.appendChild(doc.createTextNode(titleStr));
            Element h3Elem = doc.createElement("h3");
            h3Elem.appendChild(doc.createTextNode("PooledDataSources"));
            Element pdsDlElem = doc.createElement("dl");
            pdsDlElem.setAttribute("class", "PooledDataSources");
            Iterator ii = C3P0Registry.getPooledDataSources().iterator();
            while (ii.hasNext()) {
                PooledDataSource pds = (PooledDataSource)ii.next();
                StatusReporter sr = this.findStatusReporter(pds, doc);
                pdsDlElem.appendChild(sr.reportDtElem());
                pdsDlElem.appendChild(sr.reportDdElem());
            }
            headElem.appendChild(titleElem);
            htmlElem.appendChild(headElem);
            bodyElem.appendChild(h1Elem);
            bodyElem.appendChild(h3Elem);
            bodyElem.appendChild(pdsDlElem);
            htmlElem.appendChild(bodyElem);
            res.setContentType("application/xhtml+xml");
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult result = new StreamResult((OutputStream)res.getOutputStream());
            transformer.transform(src, result);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private StatusReporter findStatusReporter(PooledDataSource pds, Document doc) {
        if (pds.getClass() == (class$com$mchange$v2$c3p0$ComboPooledDataSource == null ? (class$com$mchange$v2$c3p0$ComboPooledDataSource = C3P0StatusServlet.class$("com.mchange.v2.c3p0.ComboPooledDataSource")) : class$com$mchange$v2$c3p0$ComboPooledDataSource)) {
            return new CpdsStatusReporter((ComboPooledDataSource)pds, doc);
        }
        if (pds.getClass() == (class$com$mchange$v2$c3p0$PoolBackedDataSource == null ? (class$com$mchange$v2$c3p0$PoolBackedDataSource = C3P0StatusServlet.class$("com.mchange.v2.c3p0.PoolBackedDataSource")) : class$com$mchange$v2$c3p0$PoolBackedDataSource)) {
            return new PbdsStatusReporter((PoolBackedDataSource)pds, doc);
        }
        return new UnknownPdsStatusReporter(pds, doc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PbdsStatusReporter
    extends UnknownPdsStatusReporter {
        PoolBackedDataSource pbds;

        PbdsStatusReporter(PoolBackedDataSource pbds, Document doc) {
            super("PoolBackedDataSource", pbds, doc);
            this.pbds = pbds;
        }
    }

    private class CpdsStatusReporter
    extends UnknownPdsStatusReporter {
        ComboPooledDataSource cpds;

        CpdsStatusReporter(ComboPooledDataSource cpds, Document doc) {
            super("ComboPooledDataSource", cpds, doc);
            this.cpds = cpds;
        }
    }

    private class UnknownPdsStatusReporter
    implements StatusReporter {
        String shortTypeName;
        PooledDataSource pds;
        Document doc;

        UnknownPdsStatusReporter(String shortTypeName, PooledDataSource pds, Document doc) {
            this.shortTypeName = shortTypeName;
            this.pds = pds;
            this.doc = doc;
        }

        UnknownPdsStatusReporter(PooledDataSource pds, Document doc) {
            this(pds.getClass().getName(), pds, doc);
        }

        public Element reportDtElem() {
            StringBuffer sb = new StringBuffer(255);
            sb.append(this.shortTypeName);
            sb.append(" [ dataSourceName: ");
            sb.append(this.pds.getDataSourceName());
            sb.append("; identityToken: ");
            sb.append(this.pds.getIdentityToken());
            sb.append(" ]");
            Element dtElem = this.doc.createElement("dt");
            dtElem.appendChild(this.doc.createTextNode(sb.toString()));
            return dtElem;
        }

        public Element reportDdElem() {
            Element ddElem = this.doc.createElement("dd");
            return ddElem;
        }
    }

    private static interface StatusReporter {
        public Element reportDtElem();

        public Element reportDdElem();
    }
}

