/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.holders.SynchronizedIntHolder;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool = C3P0PooledConnectionPool.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool);
    ResourcePool rp;
    ConnectionEventListener cl = new ConnectionEventListenerImpl();
    ConnectionTester connectionTester;
    GooGooStatementCache scache;
    int checkoutTimeout;
    AsynchronousRunner sharedTaskRunner;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(ConnectionPoolDataSource cpds, DbAuth auth, int min, int max, int inc, int acq_retry_attempts, int acq_retry_delay, boolean break_after_acq_failure, int checkoutTimeout, int idleConnectionTestPeriod, int maxIdleTime, boolean testConnectionOnCheckout, boolean testConnectionOnCheckin, int maxStatements, int maxStatementsPerConnection, ConnectionTester connectionTester, String testQuery, ResourcePoolFactory fact, ThreadPoolAsynchronousRunner taskRunner) throws SQLException {
        try {
            this.scache = maxStatements > 0 && maxStatementsPerConnection > 0 ? new DoubleMaxStatementCache(taskRunner, maxStatements, maxStatementsPerConnection) : (maxStatementsPerConnection > 0 ? new PerConnectionMaxOnlyStatementCache(taskRunner, maxStatementsPerConnection) : (maxStatements > 0 ? new GlobalMaxOnlyStatementCache(taskRunner, maxStatements) : null));
            this.connectionTester = connectionTester;
            this.checkoutTimeout = checkoutTimeout;
            this.sharedTaskRunner = taskRunner;
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                SynchronizedIntHolder totalOpenedCounter = new SynchronizedIntHolder();
                SynchronizedIntHolder connectionCounter = new SynchronizedIntHolder();
                SynchronizedIntHolder failedCloseCounter = new SynchronizedIntHolder();
                private final /* synthetic */ DbAuth val$auth;
                private final /* synthetic */ ConnectionPoolDataSource val$cpds;
                private final /* synthetic */ boolean val$testConnectionOnCheckout;
                private final /* synthetic */ boolean val$testConnectionOnCheckin;
                private final /* synthetic */ String val$testQuery;
                private final /* synthetic */ ConnectionTester val$connectionTester;

                PooledConnectionResourcePoolManager(DbAuth val$auth, ConnectionPoolDataSource val$cpds, boolean val$testConnectionOnCheckout, boolean val$testConnectionOnCheckin, String val$testQuery, ConnectionTester val$connectionTester) {
                    this.val$auth = val$auth;
                    this.val$cpds = val$cpds;
                    this.val$testConnectionOnCheckout = val$testConnectionOnCheckout;
                    this.val$testConnectionOnCheckin = val$testConnectionOnCheckin;
                    this.val$testQuery = val$testQuery;
                    this.val$connectionTester = val$connectionTester;
                }

                public Object acquireResource() throws Exception {
                    PooledConnection out = this.val$auth.equals(C3P0ImplUtils.NULL_AUTH) ? this.val$cpds.getPooledConnection() : this.val$cpds.getPooledConnection(this.val$auth.getUser(), this.val$auth.getPassword());
                    this.connectionCounter.increment();
                    this.totalOpenedCounter.increment();
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (out instanceof C3P0PooledConnection) {
                                ((C3P0PooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else if (out instanceof NewPooledConnection) {
                                ((NewPooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        out.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        PooledConnection pooledConnection = out;
                        Object var5_4 = null;
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. " + "Currently open Connections: " + this.connectionCounter.getValue() + "; Failed close count: " + this.failedCloseCounter.getValue() + "; Total processed by this pool: " + this.totalOpenedCounter.getValue());
                        }
                        return pooledConnection;
                    }
                    catch (Exception e) {
                        try {
                            block13: {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.warning("A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.");
                                }
                                try {
                                    this.destroyResource(out);
                                }
                                catch (Exception e2) {
                                    if (!logger.isLoggable(MLevel.WARNING)) break block13;
                                    logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", e2);
                                }
                            }
                            throw e;
                        }
                        catch (Throwable throwable) {
                            block14: {
                                Object var5_5 = null;
                                if (!logger.isLoggable(MLevel.FINEST)) break block14;
                                logger.finest(this + ".acquireResource() returning. " + "Currently open Connections: " + this.connectionCounter.getValue() + "; Failed close count: " + this.failedCloseCounter.getValue() + "; Total processed by this pool: " + this.totalOpenedCounter.getValue());
                            }
                            throw throwable;
                        }
                    }
                }

                public void refurbishResourceOnCheckout(Object resc) throws Exception {
                    if (this.val$testConnectionOnCheckout) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            this.finerLoggingTestPooledConnection(resc, "CHECKOUT");
                        } else {
                            this.testPooledConnection(resc);
                        }
                    }
                }

                public void refurbishResourceOnCheckin(Object resc) throws Exception {
                    if (this.val$testConnectionOnCheckin) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            this.finerLoggingTestPooledConnection(resc, "CHECKIN");
                        } else {
                            this.testPooledConnection(resc);
                        }
                    }
                }

                public void refurbishIdleResource(Object resc) throws Exception {
                    if (logger.isLoggable(MLevel.FINER)) {
                        this.finerLoggingTestPooledConnection(resc, "IDLE CHECK");
                    } else {
                        this.testPooledConnection(resc);
                    }
                }

                private void finerLoggingTestPooledConnection(Object resc, String testImpetus) throws Exception {
                    logger.finer("Testing PooledConnection [" + resc + "] on " + testImpetus + ".");
                    try {
                        this.testPooledConnection(resc);
                        logger.finer("Test of PooledConnection [" + resc + "] on " + testImpetus + " has SUCCEEDED.");
                    }
                    catch (Exception e) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + resc + "] on " + testImpetus + " has FAILED.", e);
                        e.fillInStackTrace();
                        throw e;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                private void testPooledConnection(Object resc) throws Exception {
                    void var3_5;
                    SQLException rootCause;
                    Connection conn;
                    PooledConnection pc;
                    block11: {
                        int status;
                        pc = (PooledConnection)resc;
                        conn = null;
                        rootCause = null;
                        try {
                            pc.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                            conn = pc.getConnection();
                            if (this.val$testQuery == null) {
                                status = this.val$connectionTester.activeCheckConnection(conn);
                                break block11;
                            }
                            if (this.val$connectionTester instanceof QueryConnectionTester) {
                                status = ((QueryConnectionTester)this.val$connectionTester).activeCheckConnection(conn, this.val$testQuery);
                                break block11;
                            }
                            logger.warning("[c3p0] testQuery '" + this.val$testQuery + "' ignored. Please set a ConnectionTester that implements " + "com.mchange.v2.c3p0.advanced.QueryConnectionTester, or use the " + "DefaultConnectionTester, to test with the testQuery.");
                            status = this.val$connectionTester.activeCheckConnection(conn);
                        }
                        catch (SQLException e) {
                            try {
                                logger.log(MLevel.FINE, "A Connection test failed with an Exception.", e);
                                status = -1;
                                rootCause = e;
                            }
                            catch (Throwable throwable) {
                                ConnectionUtils.attemptClose(conn);
                                pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                throw throwable;
                            }
                            ConnectionUtils.attemptClose(conn);
                            pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        }
                    }
                    ConnectionUtils.attemptClose(conn);
                    pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    switch (var3_5) {
                        case 0: {
                            break;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            SQLException throwMe = rootCause == null ? new SQLException("Connection is invalid") : SqlUtils.toSQLException("Connection is invalid", rootCause);
                            throw throwMe;
                        }
                        default: {
                            throw new Error("Bad Connection Tester (" + this.val$connectionTester + ") " + "returned invalid status (" + (int)var3_5 + ").");
                        }
                    }
                }

                public void destroyResource(Object resc) throws Exception {
                    try {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Preparing to destroy PooledConnection: " + resc);
                        }
                        ((PooledConnection)resc).close();
                        this.connectionCounter.decrement();
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Successfully destroyed PooledConnection: " + resc + ". Currently open Connections: " + this.connectionCounter.getValue() + "; Failed close count: " + this.failedCloseCounter.getValue() + "; Total processed by this pool: " + this.totalOpenedCounter.getValue());
                        }
                    }
                    catch (Exception e) {
                        this.failedCloseCounter.increment();
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Failed to destroy PooledConnection: " + resc + ". Currently open Connections: " + this.connectionCounter.getValue() + "; Failed close count: " + this.failedCloseCounter.getValue() + "; Total processed by this pool: " + this.totalOpenedCounter.getValue());
                        }
                        throw e;
                    }
                }
            }
            PooledConnectionResourcePoolManager manager = new PooledConnectionResourcePoolManager(auth, cpds, testConnectionOnCheckout, testConnectionOnCheckin, testQuery, connectionTester);
            ResourcePoolFactory resourcePoolFactory = fact;
            synchronized (resourcePoolFactory) {
                fact.setMin(min);
                fact.setMax(max);
                fact.setIncrement(inc);
                fact.setIdleResourceTestPeriod(idleConnectionTestPeriod * 1000);
                fact.setResourceMaxAge(maxIdleTime * 1000);
                fact.setAcquisitionRetryAttempts(acq_retry_attempts);
                fact.setAcquisitionRetryDelay(acq_retry_delay);
                fact.setBreakOnAcquisitionFailure(break_after_acq_failure);
                fact.setAgeIsAbsolute(false);
                this.rp = fact.createPool(manager);
            }
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource(this.checkoutTimeout);
        }
        catch (TimeoutException e) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", e);
        }
        catch (CannotAcquireResourceException e) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", e);
        }
        catch (Exception e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void checkinPooledConnection(PooledConnection pcon) throws SQLException {
        try {
            this.rp.checkinResource(pcon);
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean close_outstanding_connections) throws SQLException {
        Exception throwMe = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException e) {
            throwMe = e;
        }
        try {
            this.rp.close(close_outstanding_connections);
        }
        catch (ResourcePoolException e) {
            if (throwMe != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", throwMe);
            }
            throwMe = e;
        }
        if (throwMe != null) {
            throw SqlUtils.toSQLException(throwMe);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBusyConnections() throws SQLException {
        try {
            ResourcePool resourcePool = this.rp;
            synchronized (resourcePool) {
                return this.rp.getAwaitingCheckinCount() - this.rp.getExcludedCount();
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent evt) {
            this.doCheckinResource(evt);
        }

        private void doCheckinResource(ConnectionEvent evt) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(evt.getSource());
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", e);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            PooledConnection pc;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int status = (pc = (PooledConnection)evt.getSource()) instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pc).getConnectionStatus() : (pc instanceof NewPooledConnection ? ((NewPooledConnection)pc).getConnectionStatus() : -1);
            int final_status = status;
            this.doMarkPoolStatus(pc, final_status);
        }

        private void doMarkPoolStatus(PooledConnection pc, int status) {
            try {
                switch (status) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pc);
                        break;
                    }
                    case -8: {
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + status + ").");
                    }
                }
            }
            catch (ResourcePoolException e) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", e);
            }
        }
    }
}

