/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Consumer;

public class BufferHelper {
    private static boolean PRE_JAVA_9 = System.getProperty("java.specification.version", "9").startsWith("1.");
    private static Method directByteBufferCleanerMethod;
    private static Method cleanerCleanMethod;
    private static Method attachmentMethod;
    private static Object theUnsafe;

    static void lookupCleanMethodPrivileged() {
        if (PRE_JAVA_9) {
            try {
                cleanerCleanMethod = Class.forName("sun.misc.Cleaner").getDeclaredMethod("clean", new Class[0]);
                cleanerCleanMethod.setAccessible(true);
                Class<?> directByteBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                directByteBufferCleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
                attachmentMethod = directByteBufferClass.getMethod("attachment", new Class[0]);
                attachmentMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new RuntimeException("You need to grant classgraph RuntimePermission(\"accessClassInPackage.sun.misc\") and ReflectPermission(\"suppressAccessChecks\")", e);
            }
            catch (LinkageError | ReflectiveOperationException e) {}
        } else {
            try {
                Class<?> unsafeClass;
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    throw new RuntimeException("Could not get class sun.misc.Unsafe", e);
                }
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                theUnsafe = theUnsafeField.get(null);
                cleanerCleanMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                cleanerCleanMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new RuntimeException("You need to grant classgraph RuntimePermission(\"accessClassInPackage.sun.misc\") and ReflectPermission(\"suppressAccessChecks\")", e);
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
                // empty catch block
            }
        }
    }

    private static boolean closeDirectByteBufferPrivileged(ByteBuffer byteBuffer, Consumer<String> log) {
        if (!byteBuffer.isDirect()) {
            return true;
        }
        try {
            if (PRE_JAVA_9) {
                if (attachmentMethod == null) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, attachmentMethod == null");
                    }
                    return false;
                }
                if (attachmentMethod.invoke((Object)byteBuffer, new Object[0]) != null) {
                    return false;
                }
                if (directByteBufferCleanerMethod == null) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, cleanerMethod == null");
                    }
                    return false;
                }
                try {
                    directByteBufferCleanerMethod.setAccessible(true);
                }
                catch (Exception e) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, cleanerMethod.setAccessible(true) failed");
                    }
                    return false;
                }
                Object cleanerInstance = directByteBufferCleanerMethod.invoke((Object)byteBuffer, new Object[0]);
                if (cleanerInstance == null) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, cleaner == null");
                    }
                    return false;
                }
                if (cleanerCleanMethod == null) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, cleanMethod == null");
                    }
                    return false;
                }
                try {
                    cleanerCleanMethod.invoke(cleanerInstance, new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    if (log != null) {
                        log.accept("Could not unmap ByteBuffer, cleanMethod.invoke(cleaner) failed: " + String.valueOf(e));
                    }
                    return false;
                }
            }
            if (theUnsafe == null) {
                if (log != null) {
                    log.accept("Could not unmap ByteBuffer, theUnsafe == null");
                }
                return false;
            }
            if (cleanerCleanMethod == null) {
                if (log != null) {
                    log.accept("Could not unmap ByteBuffer, cleanMethod == null");
                }
                return false;
            }
            try {
                cleanerCleanMethod.invoke(theUnsafe, byteBuffer);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            if (log != null) {
                log.accept("Could not unmap ByteBuffer: " + String.valueOf(e));
            }
            return false;
        }
    }

    public static boolean closeDirectByteBuffer(ByteBuffer byteBuffer) {
        return BufferHelper.closeDirectByteBuffer(byteBuffer, null);
    }

    public static boolean closeDirectByteBuffer(final ByteBuffer byteBuffer, final Consumer<String> log) {
        if (byteBuffer != null && byteBuffer.isDirect()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return BufferHelper.closeDirectByteBufferPrivileged(byteBuffer, log);
                }
            });
        }
        return false;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BufferHelper.lookupCleanMethodPrivileged();
                return null;
            }
        });
    }
}

