/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.apache.maven.cli.transfer.FileSizeFormat;
import org.apache.maven.cli.transfer.TransferResourceIdentifier;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

@Deprecated
public class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    private final Map<TransferResourceIdentifier, TransferResourceAndSize> transfers = new LinkedHashMap<TransferResourceIdentifier, TransferResourceAndSize>();
    private final FileSizeFormat format = new FileSizeFormat();
    private final StringBuilder buffer = new StringBuilder(128);
    private final boolean printResourceNames;
    private int lastLength;

    public ConsoleMavenTransferListener(MessageBuilderFactory messageBuilderFactory, PrintStream out, boolean printResourceNames) {
        this(messageBuilderFactory, new PrintWriter(out), printResourceNames);
    }

    public ConsoleMavenTransferListener(MessageBuilderFactory messageBuilderFactory, PrintWriter out, boolean printResourceNames) {
        super(messageBuilderFactory, out);
        this.printResourceNames = printResourceNames;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        this.overridePreviousTransfer(event);
        super.transferInitiated(event);
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.overridePreviousTransfer(event);
        super.transferCorrupted(event);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.transfers.put(new TransferResourceIdentifier(resource), new TransferResourceAndSize(resource, event.getTransferredBytes()));
        this.buffer.append("Progress (").append(this.transfers.size()).append("): ");
        Iterator<TransferResourceAndSize> entries = this.transfers.values().iterator();
        while (entries.hasNext()) {
            TransferResourceAndSize entry = entries.next();
            long complete = Math.max(0L, entry.transferredBytes);
            long total = Math.max(complete, entry.resource.getContentLength());
            String resourceName = entry.resource.getResourceName();
            if (this.printResourceNames) {
                int idx = resourceName.lastIndexOf(47);
                if (idx < 0) {
                    this.buffer.append(resourceName);
                } else {
                    this.buffer.append(resourceName, idx + 1, resourceName.length());
                }
                this.buffer.append(" (");
            }
            this.format.formatProgress(this.buffer, complete, total);
            if (this.printResourceNames) {
                this.buffer.append(")");
            }
            if (!entries.hasNext()) continue;
            this.buffer.append(" | ");
        }
        int pad = this.lastLength - this.buffer.length();
        this.lastLength = this.buffer.length();
        this.pad(this.buffer, pad);
        this.buffer.append('\r');
        this.out.print(this.buffer);
        this.out.flush();
        this.buffer.setLength(0);
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        this.transfers.remove(new TransferResourceIdentifier(event.getResource()));
        this.overridePreviousTransfer(event);
        super.transferSucceeded(event);
    }

    public void transferFailed(TransferEvent event) {
        this.transfers.remove(new TransferResourceIdentifier(event.getResource()));
        this.overridePreviousTransfer(event);
        super.transferFailed(event);
    }

    private void overridePreviousTransfer(TransferEvent event) {
        if (this.lastLength > 0) {
            this.pad(this.buffer, this.lastLength);
            this.buffer.append('\r');
            this.out.print(this.buffer);
            this.out.flush();
            this.lastLength = 0;
            this.buffer.setLength(0);
        }
    }

    private record TransferResourceAndSize(TransferResource resource, long transferredBytes) {
    }
}

