/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.resolver.ArtifactDescriptorUtils;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.building.ModelSource3;
import org.apache.maven.model.locator.ModelLocator;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.CycleDetectedException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectRealmCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectBuilder
implements ProjectBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelBuilder modelBuilder;
    private final ProjectBuildingHelper projectBuildingHelper;
    private final MavenRepositorySystem repositorySystem;
    private final RepositorySystem repoSystem;
    private final ProjectDependenciesResolver dependencyResolver;
    private final RootLocator rootLocator;
    private final LifecycleBindingsInjector lifecycleBindingsInjector;

    @Inject
    public DefaultProjectBuilder(ModelBuilder modelBuilder, ProjectBuildingHelper projectBuildingHelper, MavenRepositorySystem repositorySystem, RepositorySystem repoSystem, ProjectDependenciesResolver dependencyResolver, RootLocator rootLocator, LifecycleBindingsInjector lifecycleBindingsInjector) {
        this.modelBuilder = modelBuilder;
        this.projectBuildingHelper = projectBuildingHelper;
        this.repositorySystem = repositorySystem;
        this.repoSystem = repoSystem;
        this.dependencyResolver = dependencyResolver;
        this.rootLocator = rootLocator;
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
    }

    @Override
    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request);){
            Path path = pomFile.toPath();
            ProjectBuildingResult projectBuildingResult = bs.build(path, org.apache.maven.api.services.ModelSource.fromPath((Path)path));
            return projectBuildingResult;
        }
    }

    @Override
    @Deprecated
    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(DefaultProjectBuilder.toSource(modelSource), request);
    }

    @Deprecated
    static org.apache.maven.api.services.ModelSource toSource(ModelSource modelSource) {
        if (modelSource instanceof FileModelSource) {
            FileModelSource fms = (FileModelSource)modelSource;
            return org.apache.maven.api.services.ModelSource.fromPath((Path)fms.getPath());
        }
        return new WrapModelSource(modelSource);
    }

    @Override
    public ProjectBuildingResult build(org.apache.maven.api.services.ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request);){
            ProjectBuildingResult projectBuildingResult = bs.build(null, modelSource);
            return projectBuildingResult;
        }
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(artifact, false, request);
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request);){
            ProjectBuildingResult projectBuildingResult = bs.build(artifact, allowStubModel);
            return projectBuildingResult;
        }
    }

    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request);){
            List<ProjectBuildingResult> list = bs.build(pomFiles, recursive);
            return list;
        }
    }

    private List<String> getProfileIds(List<org.apache.maven.api.model.Profile> profiles) {
        return profiles.stream().map(org.apache.maven.api.model.Profile::getId).collect(Collectors.toList());
    }

    private static org.apache.maven.api.services.ModelSource createStubModelSource(Artifact artifact) {
        String xml = "<?xml version='1.0'?><project><modelVersion>4.0.0</modelVersion><groupId>" + artifact.getGroupId() + "</groupId><artifactId>" + artifact.getArtifactId() + "</artifactId><version>" + artifact.getBaseVersion() + "</version><packaging>" + artifact.getType() + "</packaging></project>";
        return new StubModelSource(xml, artifact);
    }

    static String getGroupId(org.apache.maven.api.model.Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    static String getVersion(org.apache.maven.api.model.Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private static Map<String, String> toMap(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        }
        return null;
    }

    private org.apache.maven.api.model.Model injectLifecycleBindings(org.apache.maven.api.model.Model model, ModelBuilderRequest request, ModelProblemCollector problems, MavenProject project, ProjectBuildingRequest projectBuildingRequest) {
        Model model3 = new Model(model);
        List<ArtifactRepository> remoteRepositories = projectBuildingRequest.getRemoteRepositories();
        List<ArtifactRepository> pluginRepositories = projectBuildingRequest.getPluginArtifactRepositories();
        try {
            pluginRepositories = this.projectBuildingHelper.createArtifactRepositories(model3.getPluginRepositories(), pluginRepositories, projectBuildingRequest);
        }
        catch (Exception e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid plugin repository: " + e.getMessage(), e);
        }
        project.setPluginArtifactRepositories(pluginRepositories);
        if (request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT) {
            try {
                ProjectRealmCache.CacheRecord record = this.projectBuildingHelper.createProjectRealm(project, model3, projectBuildingRequest);
                project.setClassRealm(record.getRealm());
                project.setExtensionDependencyFilter(record.getExtensionArtifactFilter());
            }
            catch (PluginManagerException | PluginResolutionException | PluginVersionResolutionException e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Unresolvable build extension: " + e.getMessage(), e);
            }
            this.projectBuildingHelper.selectProjectRealm(project);
        }
        try {
            remoteRepositories = this.projectBuildingHelper.createArtifactRepositories(model3.getRepositories(), remoteRepositories, projectBuildingRequest);
        }
        catch (Exception e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid artifact repository: " + e.getMessage(), e);
        }
        project.setRemoteArtifactRepositories(remoteRepositories);
        if (projectBuildingRequest.isProcessPlugins()) {
            return this.lifecycleBindingsInjector.injectLifecycleBindings(model3.getDelegate(), request, problems);
        }
        return model3.getDelegate();
    }

    class BuildSession
    implements AutoCloseable {
        private final ProjectBuildingRequest request;
        private final RepositorySystemSession session;
        private final ModelBuilder.ModelBuilderSession modelBuilderSession;
        private final Map<String, MavenProject> projectIndex = new ConcurrentHashMap<String, MavenProject>(256);

        BuildSession(ProjectBuildingRequest request) {
            this.request = request;
            this.session = RepositoryUtils.overlay(request.getLocalRepository(), request.getRepositorySession(), DefaultProjectBuilder.this.repoSystem);
            InternalSession iSession = InternalSession.from((RepositorySystemSession)this.session);
            this.modelBuilderSession = DefaultProjectBuilder.this.modelBuilder.newSession();
            iSession.getData().replace(SessionData.key(ModelBuilder.ModelBuilderSession.class), null, (Object)this.modelBuilderSession);
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectBuildingResult build(Path pomFile, org.apache.maven.api.services.ModelSource modelSource) throws ProjectBuildingException {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                MavenProject project = this.request.getProject();
                List modelProblems = null;
                ModelBuilderException error = null;
                if (project == null) {
                    ModelBuilderResult result;
                    project = new MavenProject();
                    project.setFile(pomFile != null ? pomFile.toFile() : null);
                    ModelBuilderRequest.ModelBuilderRequestBuilder builder = this.getModelBuildingRequest();
                    ModelBuilderRequest.RequestType type = pomFile != null && this.request.isProcessPlugins() && this.request.getValidationLevel() == 40 ? ModelBuilderRequest.RequestType.BUILD_EFFECTIVE : ModelBuilderRequest.RequestType.CONSUMER_PARENT;
                    MavenProject theProject = project;
                    ModelBuilderRequest request = builder.source(modelSource).requestType(type).locationTracking(true).lifecycleBindingsInjector((m, r, p) -> DefaultProjectBuilder.this.injectLifecycleBindings(m, r, p, theProject, this.request)).build();
                    if (pomFile != null) {
                        project.setRootDirectory(DefaultProjectBuilder.this.rootLocator.findRoot(pomFile.getParent()));
                    }
                    try {
                        result = this.modelBuilderSession.build(request);
                    }
                    catch (ModelBuilderException e) {
                        result = e.getResult();
                        if (result == null || result.getEffectiveModel() == null) {
                            throw new ProjectBuildingException(e.getModelId(), e.getMessage(), pomFile != null ? pomFile.toFile() : null, e);
                        }
                        error = e;
                    }
                    modelProblems = result.getProblems();
                    this.initProject(project, result);
                }
                DependencyResolutionResult resolutionResult = null;
                if (this.request.isResolveDependencies()) {
                    DefaultProjectBuilder.this.projectBuildingHelper.selectProjectRealm(project);
                    resolutionResult = this.resolveDependencies(project);
                }
                DefaultProjectBuildingResult result = new DefaultProjectBuildingResult(project, this.convert(modelProblems), resolutionResult);
                if (error != null) {
                    ProjectBuildingException e = new ProjectBuildingException(List.of(result));
                    e.initCause(error);
                    throw e;
                }
                DefaultProjectBuildingResult defaultProjectBuildingResult = result;
                return defaultProjectBuildingResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        ProjectBuildingResult build(Artifact artifact, boolean allowStubModel) throws ProjectBuildingException {
            boolean localProject;
            org.eclipse.aether.artifact.Artifact pomArtifact = RepositoryUtils.toArtifact(artifact);
            pomArtifact = ArtifactDescriptorUtils.toPomArtifact((org.eclipse.aether.artifact.Artifact)pomArtifact);
            try {
                ArtifactRequest pomRequest = new ArtifactRequest();
                pomRequest.setArtifact(pomArtifact);
                pomRequest.setRepositories(RepositoryUtils.toRepos(this.request.getRemoteRepositories()));
                ArtifactResult pomResult = DefaultProjectBuilder.this.repoSystem.resolveArtifact(this.session, pomRequest);
                pomArtifact = pomResult.getArtifact();
                localProject = pomResult.getRepository() instanceof WorkspaceRepository;
            }
            catch (ArtifactResolutionException e) {
                if (((ArtifactResult)e.getResults().get(0)).isMissing() && allowStubModel) {
                    return this.build(null, DefaultProjectBuilder.createStubModelSource(artifact));
                }
                throw new ProjectBuildingException(artifact.getId(), "Error resolving project artifact: " + e.getMessage(), e);
            }
            Path pomFile = pomArtifact.getPath();
            if (!artifact.isResolved() && "pom".equals(artifact.getType())) {
                artifact.selectVersion(pomArtifact.getVersion());
                artifact.setFile(pomFile.toFile());
                artifact.setResolved(true);
            }
            if (localProject) {
                return this.build(pomFile, org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile));
            }
            return this.build(null, org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile, (String)(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())));
        }

        List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive) throws ProjectBuildingException {
            List<ProjectBuildingResult> results = this.doBuild(pomFiles, recursive);
            if (results.stream().flatMap(r -> r.getProblems().stream()).anyMatch(p -> p.getSeverity() != ModelProblem.Severity.WARNING)) {
                org.apache.maven.model.building.ModelProblem cycle = results.stream().flatMap(r -> r.getProblems().stream()).filter(p -> p.getException() instanceof CycleDetectedException).findAny().orElse(null);
                if (cycle != null) {
                    throw new RuntimeException(new ProjectCycleException("The projects in the reactor contain a cyclic reference: " + cycle.getMessage(), (CycleDetectedException)cycle.getException()));
                }
                throw new ProjectBuildingException(results);
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ProjectBuildingResult> doBuild(List<File> pomFiles, boolean recursive) {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                List<ProjectBuildingResult> list = pomFiles.stream().map(pomFile -> this.build((File)pomFile, recursive)).flatMap(Collection::stream).collect(Collectors.toList());
                return list;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        private List<ProjectBuildingResult> build(File pomFile, boolean recursive) {
            ModelBuilderResult result;
            block5: {
                try {
                    ModelTransformer injector = (m, r, p) -> {
                        MavenProject project = this.projectIndex.computeIfAbsent(m.getId(), f -> new MavenProject());
                        return DefaultProjectBuilder.this.injectLifecycleBindings(m, r, p, project, this.request);
                    };
                    ModelBuilderRequest modelBuildingRequest = this.getModelBuildingRequest().source(org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile.toPath())).requestType(ModelBuilderRequest.RequestType.BUILD_PROJECT).locationTracking(true).recursive(recursive).lifecycleBindingsInjector(injector).build();
                    result = this.modelBuilderSession.build(modelBuildingRequest);
                }
                catch (ModelBuilderException e) {
                    result = e.getResult();
                    if (result != null && result.getEffectiveModel() != null) break block5;
                    return List.of(new DefaultProjectBuildingResult(e.getModelId(), pomFile, this.convert(e.getProblems())));
                }
            }
            ArrayList<ProjectBuildingResult> results = new ArrayList<ProjectBuildingResult>();
            List<ModelBuilderResult> allModels = this.results(result).toList();
            for (ModelBuilderResult r2 : allModels) {
                ArrayList<ModelProblem> problems = new ArrayList<ModelProblem>(r2.getProblems());
                this.results(r2).filter(c -> c != r2).flatMap(c -> c.getProblems().stream()).forEach(problems::remove);
                if (r2.getEffectiveModel() != null) {
                    File pom = r2.getSource().getPath().toFile();
                    MavenProject project = this.projectIndex.get(r2.getEffectiveModel().getId());
                    Path rootDirectory = DefaultProjectBuilder.this.rootLocator.findRoot(pom.getParentFile().toPath());
                    project.setRootDirectory(rootDirectory);
                    project.setFile(pom);
                    project.setExecutionRoot(pom.equals(pomFile));
                    this.initProject(project, r2);
                    project.setCollectedProjects(this.results(r2).filter(cr -> cr != r2 && cr.getEffectiveModel() != null).map(cr -> this.projectIndex.get(cr.getEffectiveModel().getId())).collect(Collectors.toList()));
                    DependencyResolutionResult resolutionResult = null;
                    if (this.request.isResolveDependencies()) {
                        resolutionResult = this.resolveDependencies(project);
                    }
                    results.add(new DefaultProjectBuildingResult(project, this.convert(problems), resolutionResult));
                    continue;
                }
                results.add(new DefaultProjectBuildingResult(null, this.convert(problems), null));
            }
            return results;
        }

        private Stream<ModelBuilderResult> results(ModelBuilderResult result) {
            return Stream.concat(result.getChildren().stream().flatMap(this::results), Stream.of(result));
        }

        private List<org.apache.maven.model.building.ModelProblem> convert(List<ModelProblem> problems) {
            if (problems == null) {
                return null;
            }
            return problems.stream().map(p -> BuildSession.convert(p)).toList();
        }

        private static org.apache.maven.model.building.ModelProblem convert(ModelProblem p) {
            return new DefaultModelProblem(p.getMessage(), ModelProblem.Severity.valueOf((String)p.getSeverity().name()), ModelProblem.Version.valueOf((String)p.getVersion().name()), p.getSource(), p.getLineNumber(), p.getColumnNumber(), p.getModelId(), p.getException());
        }

        private void initProject(MavenProject project, ModelBuilderResult result) {
            ArtifactRepository repo;
            org.apache.maven.api.model.DeploymentRepository r;
            project.setModel(new Model(result.getEffectiveModel()));
            project.setOriginalModel(new Model(result.getFileModel()));
            this.initParent(project, result);
            Artifact projectArtifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            project.setArtifact(projectArtifact);
            if (project.getFile() != null) {
                Build build = project.getBuild().getDelegate();
                project.addScriptSourceRoot(build.getScriptSourceDirectory());
                project.addCompileSourceRoot(build.getSourceDirectory());
                project.addTestCompileSourceRoot(build.getTestSourceDirectory());
            }
            project.setActiveProfiles(Stream.concat(result.getActivePomProfiles().stream(), result.getActiveExternalProfiles().stream()).map(Profile::new).toList());
            project.setInjectedProfileIds("external", DefaultProjectBuilder.this.getProfileIds(result.getActiveExternalProfiles()));
            project.setInjectedProfileIds(result.getEffectiveModel().getId(), DefaultProjectBuilder.this.getProfileIds(result.getActivePomProfiles()));
            project.setProjectBuildingRequest(this.request);
            HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
            for (Object plugin : project.getModel().getDelegate().getBuild().getPlugins()) {
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(new Plugin((org.apache.maven.api.model.Plugin)plugin));
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
            project.setPluginArtifacts(pluginArtifacts);
            HashSet<Artifact> reportArtifacts = new HashSet<Artifact>();
            for (ReportPlugin report : project.getModel().getDelegate().getReporting().getPlugins()) {
                org.apache.maven.api.model.Plugin pp = org.apache.maven.api.model.Plugin.newBuilder().groupId(report.getGroupId()).artifactId(report.getArtifactId()).version(report.getVersion()).build();
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(new Plugin(pp));
                if (artifact == null) continue;
                reportArtifacts.add(artifact);
            }
            project.setReportArtifacts(reportArtifacts);
            HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
            List extensions = project.getModel().getDelegate().getBuild().getExtensions();
            if (extensions != null) {
                for (Extension ext : extensions) {
                    String version = ext.getVersion() == null || ext.getVersion().isEmpty() ? "RELEASE" : ext.getVersion();
                    Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(ext.getGroupId(), ext.getArtifactId(), version, null, "jar");
                    if (artifact == null) continue;
                    extensionArtifacts.add(artifact);
                }
            }
            project.setExtensionArtifacts(extensionArtifacts);
            Map<String, Artifact> map = Collections.emptyMap();
            DependencyManagement dependencyManagement = project.getModel().getDelegate().getDependencyManagement();
            if (dependencyManagement != null && dependencyManagement.getDependencies() != null && !dependencyManagement.getDependencies().isEmpty()) {
                map = new LazyMap<String, Artifact>(() -> {
                    HashMap<String, Artifact> tmp = new HashMap<String, Artifact>();
                    for (Dependency d : dependencyManagement.getDependencies()) {
                        Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createDependencyArtifact(new org.apache.maven.model.Dependency(d));
                        if (artifact == null) continue;
                        tmp.put(d.getManagementKey(), artifact);
                    }
                    return Collections.unmodifiableMap(tmp);
                });
            }
            project.setManagedVersionMap(map);
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null) {
                try {
                    r = project.getModel().getDelegate().getDistributionManagement().getRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)new DeploymentRepository(r));
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), List.of(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), List.of(repo));
                        project.setReleaseArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create release distribution repository for " + project.getId(), e);
                }
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getSnapshotRepository() != null) {
                try {
                    r = project.getModel().getDelegate().getDistributionManagement().getSnapshotRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)new DeploymentRepository(r));
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), List.of(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), List.of(repo));
                        project.setSnapshotArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create snapshot distribution repository for " + project.getId(), e);
                }
            }
        }

        private void initParent(MavenProject project, ModelBuilderResult result) {
            org.apache.maven.api.model.Model parentModel = result.getParentModel();
            if (parentModel != null) {
                MavenProject parent;
                block11: {
                    String parentGroupId = DefaultProjectBuilder.getGroupId(parentModel);
                    String parentVersion = DefaultProjectBuilder.getVersion(parentModel);
                    project.setParentArtifact(DefaultProjectBuilder.this.repositorySystem.createProjectArtifact(parentGroupId, parentModel.getArtifactId(), parentVersion));
                    parent = this.projectIndex.get(parentModel.getId());
                    if (parent == null) {
                        this.request.setRemoteRepositories(project.getRemoteArtifactRepositories());
                        Path parentPomFile = parentModel.getPomFile();
                        if (parentPomFile != null) {
                            project.setParentFile(parentPomFile.toFile());
                            try {
                                parent = this.build(parentPomFile, org.apache.maven.api.services.ModelSource.fromPath((Path)parentPomFile)).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                    break block11;
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        } else {
                            Artifact parentArtifact = project.getParentArtifact();
                            try {
                                parent = this.build(parentArtifact, false).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        }
                    }
                }
                project.setParent(parent);
                if (project.getParentFile() == null && parent != null) {
                    project.setParentFile(parent.getFile());
                }
            }
        }

        private ModelBuilderRequest.ModelBuilderRequestBuilder getModelBuildingRequest() {
            ModelBuilderRequest.ModelBuilderRequestBuilder modelBuildingRequest = ModelBuilderRequest.builder();
            InternalSession internalSession = InternalSession.from((RepositorySystemSession)this.session);
            modelBuildingRequest.session((Session)internalSession);
            modelBuildingRequest.requestType(ModelBuilderRequest.RequestType.BUILD_PROJECT);
            modelBuildingRequest.profiles(this.request.getProfiles() != null ? this.request.getProfiles().stream().map(Profile::getDelegate).toList() : null);
            modelBuildingRequest.activeProfileIds(this.request.getActiveProfileIds());
            modelBuildingRequest.inactiveProfileIds(this.request.getInactiveProfileIds());
            modelBuildingRequest.systemProperties(DefaultProjectBuilder.toMap(this.request.getSystemProperties()));
            modelBuildingRequest.userProperties(DefaultProjectBuilder.toMap(this.request.getUserProperties()));
            modelBuildingRequest.repositoryMerging(ModelBuilderRequest.RepositoryMerging.valueOf((String)this.request.getRepositoryMerging().name()));
            modelBuildingRequest.repositories(this.request.getRemoteRepositories().stream().map(r -> internalSession.getRemoteRepository(RepositoryUtils.toRepo(r))).toList());
            return modelBuildingRequest;
        }

        private DependencyResolutionResult resolveDependencies(MavenProject project) {
            DependencyResolutionResult resolutionResult;
            try {
                DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, this.session);
                resolutionResult = DefaultProjectBuilder.this.dependencyResolver.resolve(resolution);
            }
            catch (DependencyResolutionException e) {
                resolutionResult = e.getResult();
            }
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (resolutionResult.getDependencyGraph() != null) {
                RepositoryUtils.toArtifacts(artifacts, resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
                LocalRepositoryManager lrm = this.session.getLocalRepositoryManager();
                for (Artifact artifact : artifacts) {
                    if (artifact.isResolved()) continue;
                    String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact(artifact));
                    artifact.setFile(lrm.getRepository().getBasePath().resolve(path).toFile());
                }
            }
            project.setResolvedArtifacts(artifacts);
            project.setArtifacts(artifacts);
            return resolutionResult;
        }
    }

    private static class WrapModelSource
    implements org.apache.maven.api.services.ModelSource {
        private final ModelSource modelSource;

        WrapModelSource(ModelSource modelSource) {
            this.modelSource = modelSource;
        }

        public org.apache.maven.api.services.ModelSource resolve(final ModelSource.ModelLocator modelLocator, String relative) {
            ModelSource modelSource = this.modelSource;
            if (modelSource instanceof ModelSource3) {
                ModelSource3 ms = (ModelSource3)modelSource;
                return DefaultProjectBuilder.toSource((ModelSource)ms.getRelatedSource(new ModelLocator(){

                    public File locatePom(File projectDirectory) {
                        return null;
                    }

                    public Path locatePom(Path projectDirectory) {
                        return null;
                    }

                    public Path locateExistingPom(Path project) {
                        return modelLocator.locateExistingPom(project);
                    }
                }, relative));
            }
            return null;
        }

        public Path getPath() {
            return null;
        }

        public InputStream openStream() throws IOException {
            return this.modelSource.getInputStream();
        }

        public String getLocation() {
            return this.modelSource.getLocation();
        }

        public Source resolve(String relative) {
            ModelSource modelSource = this.modelSource;
            if (modelSource instanceof ModelSource2) {
                ModelSource2 ms = (ModelSource2)modelSource;
                return DefaultProjectBuilder.toSource((ModelSource)ms.getRelatedSource(relative));
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrapModelSource that = (WrapModelSource)o;
            return Objects.equals(this.modelSource, that.modelSource);
        }

        public int hashCode() {
            return Objects.hashCode(this.modelSource);
        }
    }

    private static class StubModelSource
    implements org.apache.maven.api.services.ModelSource {
        private final String xml;
        private final Artifact artifact;

        StubModelSource(String xml, Artifact artifact) {
            this.xml = xml;
            this.artifact = artifact;
        }

        public org.apache.maven.api.services.ModelSource resolve(ModelSource.ModelLocator modelLocator, String relative) {
            return null;
        }

        public Path getPath() {
            return null;
        }

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(this.xml.getBytes(StandardCharsets.UTF_8));
        }

        public String getLocation() {
            return this.artifact.getId();
        }

        public Source resolve(String relative) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StubModelSource that = (StubModelSource)o;
            return Objects.equals(this.xml, that.xml) && Objects.equals(this.artifact, that.artifact);
        }

        public int hashCode() {
            return Objects.hash(this.xml, this.artifact);
        }
    }

    static class LazyMap<K, V>
    extends AbstractMap<K, V> {
        private final Supplier<Map<K, V>> supplier;
        private volatile Map<K, V> delegate;

        LazyMap(Supplier<Map<K, V>> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.delegate == null) {
                LazyMap lazyMap = this;
                synchronized (lazyMap) {
                    if (this.delegate == null) {
                        this.delegate = this.supplier.get();
                    }
                }
            }
            return this.delegate.entrySet();
        }
    }
}

