/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Path;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.RootLocator;

@Named
@Singleton
public class ProfileActivationFilePathInterpolator {
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;
    private final Interpolator interpolator;

    @Inject
    public ProfileActivationFilePathInterpolator(PathTranslator pathTranslator, RootLocator rootLocator, Interpolator interpolator) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
        this.interpolator = interpolator;
    }

    public String interpolate(String path, ProfileActivationContext context) throws InterpolatorException {
        if (path == null) {
            return null;
        }
        Path basedir = context.getModel().getProjectDirectory();
        String absolutePath = this.interpolator.interpolate(path, s -> {
            if ("basedir".equals(s) || "project.basedir".equals(s)) {
                return basedir != null ? basedir.toFile().getAbsolutePath() : null;
            }
            if ("project.rootDirectory".equals(s)) {
                Path root = this.rootLocator.findMandatoryRoot(basedir);
                return root.toFile().getAbsolutePath();
            }
            String r = (String)context.getModel().getProperties().get(s);
            if (r == null) {
                r = context.getUserProperties().get(s);
            }
            if (r == null) {
                r = context.getSystemProperties().get(s);
            }
            return r;
        });
        return this.pathTranslator.alignToBaseDirectory(absolutePath, basedir);
    }
}

