/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Resource
extends FileSet
implements Serializable,
InputLocationTracker {
    final String targetPath;
    final String filtering;
    final String mergeId;

    protected Resource(Builder builder) {
        super(builder);
        String string = builder.targetPath != null ? builder.targetPath : (this.targetPath = builder.base != null ? builder.base.targetPath : null);
        String string2 = builder.filtering != null ? builder.filtering : (this.filtering = builder.base != null ? builder.base.filtering : null);
        this.mergeId = builder.mergeId != null ? builder.mergeId : (builder.base != null ? builder.base.mergeId : null);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getFiltering() {
        return this.filtering;
    }

    public String getMergeId() {
        return this.mergeId;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Resource.newBuilder(this);
    }

    @Override
    @Nonnull
    public Resource withIncludes(Collection<String> includes) {
        return ((Builder)Resource.newBuilder(this, true).includes((Collection)includes)).build();
    }

    @Override
    @Nonnull
    public Resource withExcludes(Collection<String> excludes) {
        return ((Builder)Resource.newBuilder(this, true).excludes((Collection)excludes)).build();
    }

    @Override
    @Nonnull
    public Resource withDirectory(String directory) {
        return Resource.newBuilder(this, true).directory(directory).build();
    }

    @Nonnull
    public Resource withTargetPath(String targetPath) {
        return Resource.newBuilder(this, true).targetPath(targetPath).build();
    }

    @Nonnull
    public Resource withFiltering(String filtering) {
        return Resource.newBuilder(this, true).filtering(filtering).build();
    }

    @Nonnull
    public Resource withMergeId(String mergeId) {
        return Resource.newBuilder(this, true).mergeId(mergeId).build();
    }

    @Nonnull
    public static Resource newInstance() {
        return Resource.newInstance(true);
    }

    @Nonnull
    public static Resource newInstance(boolean withDefaults) {
        return Resource.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Resource.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Resource from) {
        return Resource.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Resource from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isFiltering() {
        return this.getFiltering() != null ? Boolean.parseBoolean(this.getFiltering()) : false;
    }

    @Override
    public String toString() {
        return "Resource {targetPath: " + this.getTargetPath() + ", filtering: " + this.isFiltering() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends FileSet.Builder {
        Resource base;
        String targetPath;
        String filtering;
        String mergeId;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Resource base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.targetPath = base.targetPath;
                this.filtering = base.filtering;
                this.mergeId = base.mergeId;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Override
        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Nonnull
        public Builder filtering(String filtering) {
            this.filtering = filtering;
            return this;
        }

        @Nonnull
        public Builder mergeId(String mergeId) {
            this.mergeId = mergeId;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Resource build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes || this.directory != null && this.directory != this.base.directory || this.targetPath != null && this.targetPath != this.base.targetPath || this.filtering != null && this.filtering != this.base.filtering || this.mergeId != null && this.mergeId != this.base.mergeId)) {
                return this.base;
            }
            return new Resource(this);
        }
    }
}

