/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.model.ModelCache;
import org.apache.maven.api.services.model.ModelCacheFactory;
import org.apache.maven.internal.impl.model.DefaultModelCacheFactory;
import org.apache.maven.project.SnapshotModelCache;
import org.mvndaemon.mvnd.common.Environment;

@Singleton
@Named
@Priority(value=10)
public class SnapshotModelCacheFactory
implements ModelCacheFactory {
    private final ModelCacheFactory factory;
    private final ModelCache globalCache;

    @Inject
    public SnapshotModelCacheFactory(DefaultModelCacheFactory factory) {
        this.factory = factory;
        this.globalCache = factory.newInstance();
    }

    public ModelCache newInstance() {
        boolean noModelCache = Boolean.parseBoolean(Environment.MVND_NO_MODEL_CACHE.asOptional().orElse(Environment.MVND_NO_MODEL_CACHE.getDefault()));
        ModelCache reactorCache = this.factory.newInstance();
        ModelCache globalCache = noModelCache ? reactorCache : this.globalCache;
        return new SnapshotModelCache(globalCache, reactorCache);
    }
}

