/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.builder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.mvndaemon.mvnd.builder.DependencyGraph;

class ReactorBuildQueue {
    private final DependencyGraph<MavenProject> graph;
    private final Set<MavenProject> rootProjects;
    private final Set<MavenProject> projects;
    private final Set<MavenProject> blockedProjects;
    private final Set<MavenProject> finishedProjects;

    public ReactorBuildQueue(Collection<MavenProject> projects, DependencyGraph<MavenProject> graph) {
        this.graph = graph;
        this.projects = new HashSet<MavenProject>();
        this.rootProjects = new HashSet<MavenProject>();
        this.blockedProjects = new HashSet<MavenProject>();
        this.finishedProjects = new HashSet<MavenProject>();
        projects.forEach(project -> {
            this.projects.add((MavenProject)project);
            if (this.graph.isRoot((MavenProject)project)) {
                this.rootProjects.add((MavenProject)project);
            } else {
                this.blockedProjects.add((MavenProject)project);
            }
        });
    }

    public Set<MavenProject> onProjectFinish(MavenProject project) {
        this.finishedProjects.add(project);
        HashSet<MavenProject> downstreamProjects = new HashSet<MavenProject>();
        this.getDownstreamProjects(project).filter(successor -> this.blockedProjects.contains(successor) && this.isProjectReady((MavenProject)successor)).forEach(successor -> {
            this.blockedProjects.remove(successor);
            downstreamProjects.add((MavenProject)successor);
        });
        return downstreamProjects;
    }

    public Stream<MavenProject> getDownstreamProjects(MavenProject project) {
        return this.graph.getDownstreamProjects(project);
    }

    private boolean isProjectReady(MavenProject project) {
        return this.graph.getUpstreamProjects(project).allMatch(this.finishedProjects::contains);
    }

    public boolean isEmpty() {
        return this.blockedProjects.isEmpty();
    }

    public Set<MavenProject> getRootProjects() {
        return this.rootProjects;
    }

    public int getBlockedCount() {
        return this.blockedProjects.size();
    }

    public int getFinishedCount() {
        return this.finishedProjects.size();
    }

    public int getReadyCount() {
        return this.projects.size() - this.blockedProjects.size() - this.finishedProjects.size();
    }

    public Set<MavenProject> getReadyProjects() {
        HashSet<MavenProject> projects = new HashSet<MavenProject>(this.projects);
        projects.removeAll(this.blockedProjects);
        projects.removeAll(this.finishedProjects);
        return projects;
    }
}

