/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

                          uitextmode.h  -  description
                             -------------------
    begin                : Thu Mar 13 2003
    copyright            : (C) 2003 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef UITEXTMODE_H
#define UITEXTMODE_H

class MController;
class MUITextModePriv;
typedef bool (MUITextModePriv::*tComHandler)(char * arg);
typedef set<int> intSet;
typedef set<DWORD> dwordSet;
typedef set<void*> ptrSet;
typedef vector<int> intVec;
typedef vector<DWORD> dwordVec;

class MUITextModePriv {
public:
	struct ComEntry;
	//
	MUITextModePriv(MController*);
	virtual ~MUITextModePriv();
	// basic functionality
	virtual bool attach()          = 0;
	virtual bool init()            = 0;
	virtual void detach()          = 0;
	virtual void ui_loop()         = 0;
	virtual void stop(bool bForce) = 0;

	virtual bool execute_command(ComEntry *command, LPSTR word);

	virtual bool vcom_color(char * arg)  = 0;
	virtual bool vcom_system(char * arg);
	virtual bool on_realtime();
	virtual bool is_set_permitted(const CString& sProp) { return true; }
	//
	enum SetMode {
		SET_SET,
		SET_ADD,
		SET_REMOVE
	};
	bool set_helper(MPropertyContainer* pPC, SetMode mode, char * arg);
	bool stop_help(LPCSTR szCom,bool bDelPart, char * arg);
	//
	int m_nCounter;
	dwordVec m_vecConnIDs;
	dwordVec m_vecTransIDs;
	dwordVec m_vecSearchIDs;
	dwordVec m_vecResIDs;
	MController* m_pController;
	std::queue<CString> m_command_queue;
	// terminal output
	MPrintf* m_pOutput;
	// couple of properties
	int m_nMaxResultsDispl;
	bool m_bShowGroups;
	char m_szStartUpScript[1024];
	bool m_bUseColor;
	char m_szColorScheme[1024];
	// command support
	struct ComEntry {
		char*			name;     // User printable name of the function.
		tComHandler 	handler;  // Function to call to do the job.
		char*			doc_short; // Documentation for this function.
		char*			doc_long;
	};
	struct VarEntry{
		char*			name;     // User printable name of the function.
		char*			doc_short; // Documentation for this function.
		char*			doc_long;
	};
	static ComEntry commands[];
	static VarEntry variables[];
	ComEntry* find_command(char*);
	bool execute_line (const CString& sLine);
	// commands
	bool com_help(char * arg);
	bool com_exit(char * arg);
	bool com_leave(char * arg);
	// search
	bool com_find(char * arg);
	bool com_list(char * arg);
	bool com_ls(char * arg);
	bool com_edit(char * arg);
	bool com_delete(char * arg);
	bool com_erase(char * arg);
	bool com_clear(char * arg);
	bool com_results(char * arg);
	// retrive
	bool com_get(char * arg);
	// rename file
	bool com_move(char * arg);
	// stop transfers
	bool com_stop(char * arg);
	bool com_kill(char * arg);
	// info
	bool com_info(char * arg);
	bool com_hosts(char * arg);
	// connections
	bool com_open(char * arg);
	bool com_close(char * arg);
	// misc
	bool com_load(char * arg);   // script
	//bool com_system(char * arg); // execute a shell command
	bool com_set(char * arg);    // envinroment management
	bool com_set_add(char * arg);
	bool com_set_remove(char * arg);
	bool com_color(char * arg); // termUI colors
	// shared files
	bool com_scan(char * arg);
	bool com_library(char * arg);
	//
	bool com_system(char * arg);
	bool com_version(char * arg);
};

#endif
