//////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004-2023 musikcube team
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//    * Neither the name of the author nor the names of other contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////

#include <string>
#include <algorithm>
#include "HttpDataStreamFactory.h"
#include "HttpDataStream.h"

HttpDataStreamFactory::HttpDataStreamFactory() {

}

HttpDataStreamFactory::~HttpDataStreamFactory() {

}

bool HttpDataStreamFactory::CanRead(const char *uri) {
    std::string str(uri);
    std::transform(str.begin(), str.end(), str.begin(), ::tolower);
    return
        str.find("http://") == 0 ||
        str.find("https://") == 0 ||
        str.find(HttpDataStream::kRemoteTrackHost) == 0;
}

IDataStream* HttpDataStreamFactory::Open(const char *uri, OpenFlags flags) {
    HttpDataStream* stream = new HttpDataStream();

    if (stream->Open(uri, flags)) {
        return stream;
    }

    delete stream;
    return nullptr;
}

void HttpDataStreamFactory::Release() {
    delete this;
}