#include "muscle.h"
#include "m3alnparams.h"
#include "alpha.h"

// src/blosum/matrices/blosumNN.sij 
// Converted to C syntax by blosum_qij_reformat.py

static float Blosum90_sij[20][20] = 
	{
//               A        C        D        E        F        G        H        I        K        L        M        N        P        Q        R        S        T        V        W        Y
/* A */	{   2.4589f, -0.5791f, -1.2842f, -0.5835f, -1.5274f, -0.2256f, -1.1141f, -1.0715f, -0.5906f, -1.1639f, -0.8653f, -1.0729f, -0.4899f, -0.6505f, -0.9127f,  0.5388f, -0.0974f, -0.3333f, -1.8179f, -1.4333f, },  // A
/* C */	{  -0.5791f,  4.4354f, -2.5059f, -2.7657f, -1.3489f, -2.1964f, -2.3692f, -0.9409f, -2.2130f, -1.2340f, -1.2273f, -1.7992f, -2.1193f, -2.0465f, -2.2776f, -0.9330f, -0.8669f, -0.7661f, -1.9966f, -1.7734f, },  // C
/* D */	{  -1.2842f, -2.5059f,  3.3032f,  0.6879f, -2.3403f, -1.0448f, -0.8725f, -2.5425f, -0.6875f, -2.5478f, -2.2113f,  0.6051f, -1.3225f, -0.5430f, -1.2599f, -0.5214f, -0.9187f, -2.2779f, -3.1127f, -2.2261f, },  // D
/* E */	{  -0.5835f, -2.7657f,  0.6879f,  2.9838f, -2.2869f, -1.5270f, -0.3723f, -2.0742f,  0.1075f, -2.0756f, -1.4679f, -0.4120f, -0.9187f,  0.8730f, -0.4505f, -0.3961f, -0.7053f, -1.5823f, -2.3028f, -1.8715f, },  // E
/* F */	{  -1.5274f, -1.3489f, -2.3403f, -2.2869f,  3.3949f, -2.3434f, -0.9690f, -0.3710f, -1.8681f,  0.0712f, -0.3020f, -2.0772f, -2.2348f, -1.8327f, -1.9312f, -1.5851f, -1.3564f, -0.7927f, -0.0260f,  1.4708f, },  // F
/* G */	{  -0.2256f, -2.1964f, -1.0448f, -1.5270f, -2.3434f,  3.0524f, -1.5770f, -2.7233f, -1.2254f, -2.4480f, -2.0748f, -0.5825f, -1.7418f, -1.3926f, -1.6056f, -0.5136f, -1.3202f, -2.3056f, -2.0953f, -2.4043f, },  // G
/* H */	{  -1.1141f, -2.3692f, -0.8725f, -0.3723f, -0.9690f, -1.5770f,  4.2144f, -2.1063f, -0.5559f, -1.7894f, -1.2982f,  0.1271f, -1.3236f,  0.3194f, -0.2003f, -0.7508f, -1.0836f, -2.0007f, -1.3793f,  0.7015f, },  // H
/* I */	{  -1.0715f, -0.9409f, -2.5425f, -2.0742f, -0.3710f, -2.7233f, -2.1063f,  2.4918f, -1.8158f,  0.6693f,  0.5654f, -2.1252f, -1.9392f, -1.8354f, -1.8892f, -1.5892f, -0.6887f,  1.3072f, -1.8135f, -1.0627f, },  // I
/* K */	{  -0.5906f, -2.2130f, -0.6875f,  0.1075f, -1.8681f, -1.2254f, -0.5559f, -1.8158f,  2.8894f, -1.6500f, -0.9886f, -0.1638f, -0.8518f,  0.5704f,  1.1110f, -0.4502f, -0.5552f, -1.6064f, -2.5150f, -1.5304f, },  // K
/* L */	{  -1.1639f, -1.2340f, -2.5478f, -2.0756f,  0.0712f, -2.4480f, -1.7894f,  0.6693f, -1.6500f,  2.3310f,  1.0545f, -2.1566f, -1.8773f, -1.4162f, -1.6163f, -1.5610f, -0.9788f,  0.1801f, -1.4234f, -0.9748f, },  // L
/* M */	{  -0.8653f, -1.2273f, -2.2113f, -1.4679f, -0.3020f, -2.0748f, -1.2982f,  0.5654f, -0.9886f,  1.0545f,  3.5033f, -1.5546f, -1.6615f, -0.2351f, -1.1107f, -1.1874f, -0.5585f,  0.1856f, -1.0211f, -1.0579f, },  // M
/* N */	{  -1.0729f, -1.7992f,  0.6051f, -0.4120f, -2.0772f, -0.5825f,  0.1271f, -2.1252f, -0.1638f, -2.1566f, -1.5546f,  3.3690f, -1.5115f, -0.1442f, -0.4878f,  0.1334f, -0.2412f, -1.9515f, -2.4875f, -1.4750f, },  // N
/* P */	{  -0.4899f, -2.1193f, -1.3225f, -0.9187f, -2.2348f, -1.7418f, -1.3236f, -1.9392f, -0.8518f, -1.8773f, -1.6615f, -1.5115f,  4.0079f, -1.0391f, -1.2887f, -0.7522f, -1.0572f, -1.6302f, -2.5189f, -2.2306f, },  // P
/* Q */	{  -0.6505f, -2.0465f, -0.5430f,  0.8730f, -1.8327f, -1.3926f,  0.3194f, -1.8354f,  0.5704f, -1.4162f, -0.2351f, -0.1442f, -1.0391f,  3.3200f,  0.3322f, -0.3460f, -0.5746f, -1.5197f, -1.5100f, -1.3158f, },  // Q
/* R */	{  -0.9127f, -2.2776f, -1.2599f, -0.4505f, -1.9312f, -1.6056f, -0.2003f, -1.8892f,  1.1110f, -1.6163f, -1.1107f, -0.4878f, -1.2887f,  0.3322f,  3.2411f, -0.6732f, -0.9286f, -1.6601f, -2.0064f, -1.4646f, },  // R
/* S */	{   0.5388f, -0.9330f, -0.5214f, -0.3961f, -1.5851f, -0.5136f, -0.7508f, -1.5892f, -0.4502f, -1.5610f, -1.1874f,  0.1334f, -0.7522f, -0.3460f, -0.6732f,  2.5830f,  0.7037f, -1.1539f, -2.1183f, -1.2807f, },  // S
/* T */	{  -0.0974f, -0.8669f, -0.9187f, -0.7053f, -1.3564f, -1.3202f, -1.0836f, -0.6887f, -0.5552f, -0.9788f, -0.5585f, -0.2412f, -1.0572f, -0.5746f, -0.9286f,  0.7037f,  2.8597f, -0.3146f, -2.1387f, -1.2497f, },  // T
/* V */	{  -0.3333f, -0.7661f, -2.2779f, -1.5823f, -0.7927f, -2.3056f, -2.0007f,  1.3072f, -1.6064f,  0.1801f,  0.1856f, -1.9515f, -1.6302f, -1.5197f, -1.6601f, -1.1539f, -0.3146f,  2.4104f, -1.7381f, -1.3054f, },  // V
/* W */	{  -1.8179f, -1.9966f, -3.1127f, -2.3028f, -0.0260f, -2.0953f, -1.3793f, -1.8135f, -2.5150f, -1.4234f, -1.0211f, -2.4875f, -2.5189f, -1.5100f, -2.0064f, -2.1183f, -2.1387f, -1.7381f,  5.4153f,  0.8274f, },  // W
/* Y */	{  -1.4333f, -1.7734f, -2.2261f, -1.8715f,  1.4708f, -2.4043f,  0.7015f, -1.0627f, -1.5304f, -0.9748f, -1.0579f, -1.4750f, -2.2306f, -1.3158f, -1.4646f, -1.2807f, -1.2497f, -1.3054f,  0.8274f,  3.7665f, },  // Y
	};

static float Blosum80_sij[20][20] = 
	{
//               A        C        D        E        F        G        H        I        K        L        M        N        P        Q        R        S        T        V        W        Y
/* A */	{   2.2549f, -0.4505f, -1.1491f, -0.5081f, -1.3335f, -0.0632f, -0.9590f, -0.8802f, -0.4681f, -0.9869f, -0.6769f, -0.9711f, -0.3750f, -0.5233f, -0.8486f,  0.6179f, -0.0297f, -0.2078f, -1.6930f, -1.1968f, },  // A
/* C */	{  -0.4505f,  4.3717f, -2.2250f, -2.4769f, -1.3410f, -1.8780f, -2.1758f, -0.7830f, -2.0520f, -1.0213f, -1.0017f, -1.7351f, -1.8934f, -1.7606f, -2.1048f, -0.7956f, -0.7328f, -0.6564f, -1.7263f, -1.6993f, },  // C
/* D */	{  -1.1491f, -2.2250f,  3.1869f,  0.7098f, -2.0927f, -0.8872f, -0.7505f, -2.2240f, -0.5630f, -2.3425f, -1.9888f,  0.6640f, -1.1443f, -0.3897f, -1.0690f, -0.3695f, -0.7110f, -2.0309f, -2.7881f, -2.0280f, },  // D
/* E */	{  -0.5081f, -2.4769f,  0.7098f,  2.8063f, -2.0060f, -1.3242f, -0.1500f, -1.9200f,  0.2569f, -1.8597f, -1.2224f, -0.3020f, -0.7824f,  0.9309f, -0.2656f, -0.2429f, -0.5447f, -1.4368f, -2.0540f, -1.5870f, },  // E
/* F */	{  -1.3335f, -1.3410f, -2.0927f, -2.0060f,  3.2457f, -2.0070f, -0.8063f, -0.2506f, -1.8226f,  0.1561f, -0.1627f, -1.8747f, -2.0761f, -1.8102f, -1.7995f, -1.4379f, -1.1675f, -0.6240f,  0.1235f,  1.4752f, },  // F
/* G */	{  -0.0632f, -1.8780f, -0.8872f, -1.3242f, -2.0070f,  2.9786f, -1.3690f, -2.4387f, -1.0486f, -2.2478f, -1.8056f, -0.3941f, -1.5257f, -1.2359f, -1.4057f, -0.3505f, -1.0226f, -1.9945f, -1.9192f, -2.1233f, },  // G
/* H */	{  -0.9590f, -2.1758f, -0.7505f, -0.1500f, -0.8063f, -1.3690f,  4.0063f, -1.9549f, -0.4342f, -1.6698f, -1.2106f,  0.1690f, -1.2527f,  0.3957f, -0.1116f, -0.5964f, -0.8901f, -1.7912f, -1.3576f,  0.8634f, },  // H
/* I */	{  -0.8802f, -0.7830f, -2.2240f, -1.9200f, -0.2506f, -2.4387f, -1.9549f,  2.2832f, -1.6742f,  0.7355f,  0.5969f, -1.9557f, -1.8070f, -1.6940f, -1.7401f, -1.3997f, -0.5135f,  1.3195f, -1.5431f, -0.8908f, },  // I
/* K */	{  -0.4681f, -2.0520f, -0.5630f,  0.2569f, -1.8226f, -1.0486f, -0.4342f, -1.6742f,  2.6612f, -1.4866f, -0.9040f, -0.0917f, -0.7449f,  0.6079f,  1.1323f, -0.2860f, -0.4428f, -1.4336f, -2.0503f, -1.2916f, },  // K
/* L */	{  -0.9869f, -1.0213f, -2.3425f, -1.8597f,  0.1561f, -2.2478f, -1.6698f,  0.7355f, -1.4866f,  2.1580f,  1.0859f, -2.0018f, -1.7221f, -1.2972f, -1.4626f, -1.4403f, -0.8343f,  0.2875f, -1.1884f, -0.7846f, },  // L
/* M */	{  -0.6769f, -1.0017f, -1.9888f, -1.2224f, -0.1627f, -1.8056f, -1.2106f,  0.5969f, -0.9040f,  1.0859f,  3.1511f, -1.3899f, -1.4662f, -0.1737f, -0.9832f, -1.0045f, -0.3998f,  0.2918f, -0.8348f, -0.8627f, },  // M
/* N */	{  -0.9711f, -1.7351f,  0.6640f, -0.3020f, -1.8747f, -0.3941f,  0.1690f, -1.9557f, -0.0917f, -2.0018f, -1.3899f,  3.1639f, -1.3296f, -0.0616f, -0.3714f,  0.2208f, -0.1392f, -1.7514f, -2.1759f, -1.3789f, },  // N
/* P */	{  -0.3750f, -1.8934f, -1.1443f, -0.7824f, -2.0761f, -1.5257f, -1.2527f, -1.8070f, -0.7449f, -1.7221f, -1.4662f, -1.3296f,  3.9217f, -0.8943f, -1.1662f, -0.6177f, -0.8356f, -1.4335f, -2.4898f, -1.9571f, },  // P
/* Q */	{  -0.5233f, -1.7606f, -0.3897f,  0.9309f, -1.8102f, -1.2359f,  0.3957f, -1.6940f,  0.6079f, -1.2972f, -0.1737f, -0.0616f, -0.8943f,  3.0600f,  0.4795f, -0.2193f, -0.4652f, -1.2830f, -1.2937f, -1.1145f, },  // Q
/* R */	{  -0.8486f, -2.1048f, -1.0690f, -0.2656f, -1.7995f, -1.4057f, -0.1116f, -1.7401f,  1.1323f, -1.4626f, -0.9832f, -0.3714f, -1.1662f,  0.4795f,  3.0434f, -0.5259f, -0.7409f, -1.4993f, -1.7649f, -1.2592f, },  // R
/* S */	{   0.6179f, -0.7956f, -0.3695f, -0.2429f, -1.4379f, -0.3505f, -0.5964f, -1.3997f, -0.2860f, -1.4403f, -1.0045f,  0.2208f, -0.6177f, -0.2193f, -0.5259f,  2.3521f,  0.7334f, -1.0184f, -1.8848f, -1.1140f, },  // S
/* T */	{  -0.0297f, -0.7328f, -0.7110f, -0.5447f, -1.1675f, -1.0226f, -0.8901f, -0.5135f, -0.4428f, -0.8343f, -0.3998f, -0.1392f, -0.8356f, -0.4652f, -0.7409f,  0.7334f,  2.6335f, -0.1657f, -1.8105f, -1.0757f, },  // T
/* V */	{  -0.2078f, -0.6564f, -2.0309f, -1.4368f, -0.6240f, -1.9945f, -1.7912f,  1.3195f, -1.4336f,  0.2875f,  0.2918f, -1.7514f, -1.4335f, -1.2830f, -1.4993f, -1.0184f, -0.1657f,  2.1965f, -1.5472f, -1.0314f, },  // V
/* W */	{  -1.6930f, -1.7263f, -2.7881f, -2.0540f,  0.1235f, -1.9192f, -1.3576f, -1.5431f, -2.0503f, -1.1884f, -0.8348f, -2.1759f, -2.4898f, -1.2937f, -1.7649f, -1.8848f, -1.8105f, -1.5472f,  5.3769f,  1.0258f, },  // W
/* Y */	{  -1.1968f, -1.6993f, -2.0280f, -1.5870f,  1.4752f, -2.1233f,  0.8634f, -0.8908f, -1.2916f, -0.7846f, -0.8627f, -1.3789f, -1.9571f, -1.1145f, -1.2592f, -1.1140f, -1.0757f, -1.0314f,  1.0258f,  3.6081f, },  // Y
	};

static float Blosum70_sij[20][20] = 
	{
//               A        C        D        E        F        G        H        I        K        L        M        N        P        Q        R        S        T        V        W        Y
/* A */	{   2.1182f, -0.3012f, -1.0015f, -0.4840f, -1.2444f,  0.0161f, -0.9118f, -0.7728f, -0.4300f, -0.8838f, -0.5820f, -0.8703f, -0.3484f, -0.4705f, -0.8006f,  0.6152f, -0.0265f, -0.1480f, -1.4500f, -1.0524f, },  // A
/* C */	{  -0.3012f,  4.3424f, -1.8824f, -2.1803f, -1.1577f, -1.5743f, -1.8981f, -0.6644f, -1.8061f, -0.8426f, -0.8810f, -1.6142f, -1.6450f, -1.5464f, -1.9015f, -0.5330f, -0.6058f, -0.5630f, -1.2857f, -1.3782f, },  // C
/* D */	{  -1.0015f, -1.8824f,  3.0475f,  0.7470f, -1.8906f, -0.7611f, -0.6674f, -1.9277f, -0.4483f, -2.1309f, -1.7439f,  0.6789f, -0.9867f, -0.2872f, -0.9405f, -0.2197f, -0.5823f, -1.8166f, -2.3899f, -1.8314f, },  // D
/* E */	{  -0.4840f, -2.1803f,  0.7470f,  2.6503f, -1.8484f, -1.1808f, -0.0565f, -1.8005f,  0.3488f, -1.6923f, -1.1554f, -0.2023f, -0.6873f,  0.9221f, -0.1339f, -0.1107f, -0.4374f, -1.3522f, -1.7818f, -1.3085f, },  // E
/* F */	{  -1.2444f, -1.1577f, -1.8906f, -1.8484f,  3.1179f, -1.7525f, -0.7018f, -0.1537f, -1.6894f,  0.1910f, -0.0848f, -1.7303f, -1.9608f, -1.6770f, -1.6022f, -1.3070f, -1.0841f, -0.4867f,  0.3993f,  1.4425f, },  // F
/* G */	{   0.0161f, -1.5743f, -0.7611f, -1.1808f, -1.7525f,  2.8967f, -1.2445f, -2.1562f, -0.8955f, -2.0541f, -1.5797f, -0.2837f, -1.3082f, -1.0751f, -1.2724f, -0.2604f, -0.8994f, -1.7840f, -1.5324f, -1.8470f, },  // G
/* H */	{  -0.9118f, -1.8981f, -0.6674f, -0.0565f, -0.7018f, -1.2445f,  3.8707f, -1.8420f, -0.3685f, -1.6003f, -1.0341f,  0.2326f, -1.1545f,  0.3148f, -0.1184f, -0.4850f, -0.8384f, -1.6818f, -1.1513f,  0.9240f, },  // H
/* I */	{  -0.7728f, -0.6644f, -1.9277f, -1.8005f, -0.1537f, -2.1562f, -1.8420f,  2.1379f, -1.4973f,  0.7676f,  0.6012f, -1.7802f, -1.6226f, -1.5801f, -1.6237f, -1.2982f, -0.4243f,  1.2795f, -1.3229f, -0.7052f, },  // I
/* K */	{  -0.4300f, -1.8061f, -0.4483f,  0.3488f, -1.6894f, -0.8955f, -0.3685f, -1.4973f,  2.4549f, -1.3323f, -0.7697f, -0.0869f, -0.6020f,  0.6565f,  1.1095f, -0.2007f, -0.3606f, -1.2630f, -1.7463f, -1.1106f, },  // K
/* L */	{  -0.8838f, -0.8426f, -2.1309f, -1.6923f,  0.1910f, -2.0541f, -1.6003f,  0.7676f, -1.3323f,  2.0253f,  1.0570f, -1.8873f, -1.6001f, -1.2010f, -1.3365f, -1.3053f, -0.7541f,  0.3625f, -0.9977f, -0.6187f, },  // L
/* M */	{  -0.5820f, -0.8810f, -1.7439f, -1.1554f, -0.0848f, -1.5797f, -1.0341f,  0.6012f, -0.7697f,  1.0570f,  2.9254f, -1.2320f, -1.3495f, -0.1958f, -0.8726f, -0.8550f, -0.3692f,  0.3105f, -0.9404f, -0.6584f, },  // M
/* N */	{  -0.8703f, -1.6142f,  0.6789f, -0.2023f, -1.7303f, -0.2837f,  0.2326f, -1.7802f, -0.0869f, -1.8873f, -1.2320f,  3.0098f, -1.2356f, -0.0327f, -0.3035f,  0.2478f, -0.0665f, -1.5704f, -1.9329f, -1.2313f, },  // N
/* P */	{  -0.3484f, -1.6450f, -0.9867f, -0.6873f, -1.9608f, -1.3082f, -1.1545f, -1.6226f, -0.6020f, -1.6001f, -1.3495f, -1.2356f,  3.8155f, -0.7825f, -1.0782f, -0.4811f, -0.6937f, -1.2813f, -2.0558f, -1.6777f, },  // P
/* Q */	{  -0.4705f, -1.5464f, -0.2872f,  0.9221f, -1.6770f, -1.0751f,  0.3148f, -1.5801f,  0.6565f, -1.2010f, -0.1958f, -0.0327f, -0.7825f,  2.8756f,  0.5239f, -0.1297f, -0.3703f, -1.1931f, -1.0925f, -0.9500f, },  // Q
/* R */	{  -0.8006f, -1.9015f, -0.9405f, -0.1339f, -1.6022f, -1.2724f, -0.1184f, -1.6237f,  1.1095f, -1.3365f, -0.8726f, -0.3035f, -1.0782f,  0.5239f,  2.8998f, -0.4355f, -0.6342f, -1.3456f, -1.5751f, -0.9969f, },  // R
/* S */	{   0.6152f, -0.5330f, -0.2197f, -0.1107f, -1.3070f, -0.2604f, -0.4850f, -1.2982f, -0.2007f, -1.3053f, -0.8550f,  0.2478f, -0.4811f, -0.1297f, -0.4355f,  2.1503f,  0.7161f, -0.9429f, -1.6030f, -0.9246f, },  // S
/* T */	{  -0.0265f, -0.6058f, -0.5823f, -0.4374f, -1.0841f, -0.8994f, -0.8384f, -0.4243f, -0.3606f, -0.7541f, -0.3692f, -0.0665f, -0.6937f, -0.3703f, -0.6342f,  0.7161f,  2.4657f, -0.0916f, -1.5127f, -0.9404f, },  // T
/* V */	{  -0.1480f, -0.5630f, -1.8166f, -1.3522f, -0.4867f, -1.7840f, -1.6818f,  1.2795f, -1.2630f,  0.3625f,  0.3105f, -1.5704f, -1.2813f, -1.1931f, -1.3456f, -0.9429f, -0.0916f,  2.0474f, -1.4133f, -0.7746f, },  // V
/* W */	{  -1.4500f, -1.2857f, -2.3899f, -1.7818f,  0.3993f, -1.5324f, -1.1513f, -1.3229f, -1.7463f, -0.9977f, -0.9404f, -1.9329f, -2.0558f, -1.0925f, -1.5751f, -1.6030f, -1.5127f, -1.4133f,  5.2998f,  1.0221f, },  // W
/* Y */	{  -1.0524f, -1.3782f, -1.8314f, -1.3085f,  1.4425f, -1.8470f,  0.9240f, -0.7052f, -1.1106f, -0.6187f, -0.6584f, -1.2313f, -1.6777f, -0.9500f, -0.9969f, -0.9246f, -0.9404f, -0.7746f,  1.0221f,  3.4566f, },  // Y
	};

static float Blosum62_sij[20][20] = 
	{
//               A        C        D        E        F        G        H        I        K        L        M        N        P        Q        R        S        T        V        W        Y
/* A */	{   1.9646f, -0.2043f, -0.8767f, -0.4319f, -1.1050f,  0.0798f, -0.8126f, -0.6609f, -0.3670f, -0.7323f, -0.4676f, -0.7654f, -0.4071f, -0.4020f, -0.7068f,  0.5579f, -0.0227f, -0.0947f, -1.2634f, -0.8820f, },  // A
/* C */	{  -0.2043f,  4.2911f, -1.7300f, -1.8062f, -1.1877f, -1.2502f, -1.4939f, -0.6138f, -1.5182f, -0.6387f, -0.7099f, -1.3299f, -1.3976f, -1.4509f, -1.6946f, -0.4375f, -0.4333f, -0.4038f, -1.1521f, -1.2036f, },  // C
/* D */	{  -0.8767f, -1.7300f,  2.8871f,  0.7552f, -1.7419f, -0.6568f, -0.5595f, -1.5606f, -0.3509f, -1.8028f, -1.5293f,  0.6358f, -0.7401f, -0.1567f, -0.8029f, -0.1305f, -0.5254f, -1.5713f, -2.1072f, -1.5325f, },  // D
/* E */	{  -0.4319f, -1.8062f,  0.7552f,  2.4514f, -1.5962f, -1.0551f, -0.0588f, -1.5972f,  0.3877f, -1.4232f, -0.9990f, -0.1340f, -0.5581f,  0.9273f, -0.0577f, -0.0735f, -0.4316f, -1.2211f, -1.4177f, -1.0102f, },  // E
/* F */	{  -1.1050f, -1.1877f, -1.7419f, -1.5962f,  3.0230f, -1.5537f, -0.6171f, -0.0804f, -1.5393f,  0.2074f,  0.0063f, -1.4970f, -1.7986f, -1.5822f, -1.3932f, -1.1845f, -1.0538f, -0.4245f,  0.4588f,  1.4696f, },  // F
/* G */	{   0.0798f, -1.2502f, -0.6568f, -1.0551f, -1.5537f,  2.7816f, -1.0204f, -1.8624f, -0.7640f, -1.8135f, -1.3383f, -0.2114f, -1.0668f, -0.8926f, -1.1521f, -0.1462f, -0.7877f, -1.5694f, -1.2457f, -1.5199f, },  // G
/* H */	{  -0.8126f, -1.4939f, -0.5595f, -0.0588f, -0.6171f, -1.0204f,  3.7555f, -1.6158f, -0.3605f, -1.3934f, -0.7756f,  0.2892f, -1.0805f,  0.2240f, -0.1249f, -0.4408f, -0.8429f, -1.5587f, -1.1711f,  0.8463f, },  // H
/* I */	{  -0.6609f, -0.6138f, -1.5606f, -1.5972f, -0.0804f, -1.8624f, -1.6158f,  1.9993f, -1.3351f,  0.7608f,  0.5634f, -1.6085f, -1.3783f, -1.3848f, -1.4951f, -1.1741f, -0.3588f,  1.2735f, -1.2903f, -0.6657f, },  // I
/* K */	{  -0.3670f, -1.5182f, -0.3509f,  0.3877f, -1.5393f, -0.7640f, -0.3605f, -1.3351f,  2.2523f, -1.2234f, -0.6774f, -0.0895f, -0.5068f,  0.6363f,  1.0544f, -0.1017f, -0.3348f, -1.1312f, -1.4782f, -0.9100f, },  // K
/* L */	{  -0.7323f, -0.6387f, -1.8028f, -1.4232f,  0.2074f, -1.8135f, -1.3934f,  0.7608f, -1.2234f,  1.9247f,  0.9959f, -1.6895f, -1.4300f, -1.0670f, -1.0773f, -1.2213f, -0.5987f,  0.3942f, -0.8159f, -0.5310f, },  // L
/* M */	{  -0.4676f, -0.7099f, -1.5293f, -0.9990f,  0.0063f, -1.3383f, -0.7756f,  0.5634f, -0.6774f,  0.9959f,  2.6963f, -1.0754f, -1.2382f, -0.2105f, -0.6836f, -0.7404f, -0.3331f,  0.3436f, -0.7124f, -0.4974f, },  // M
/* N */	{  -0.7654f, -1.3299f,  0.6358f, -0.1340f, -1.4970f, -0.2114f,  0.2892f, -1.6085f, -0.0895f, -1.6895f, -1.0754f,  2.8266f, -1.0002f,  0.0008f, -0.2199f,  0.3005f, -0.0230f, -1.4382f, -1.8480f, -1.0409f, },  // N
/* P */	{  -0.4071f, -1.3976f, -0.7401f, -0.5581f, -1.7986f, -1.0668f, -1.0805f, -1.3783f, -0.5068f, -1.4300f, -1.2382f, -1.0002f,  3.6823f, -0.6410f, -1.0543f, -0.4045f, -0.5376f, -1.1744f, -1.8271f, -1.4599f, },  // P
/* Q */	{  -0.4020f, -1.4509f, -0.1567f,  0.9273f, -1.5822f, -0.8926f,  0.2240f, -1.3848f,  0.6363f, -1.0670f, -0.2105f,  0.0008f, -0.6410f,  2.6426f,  0.4914f, -0.0506f, -0.3377f, -1.0992f, -0.9732f, -0.7105f, },  // Q
/* R */	{  -0.7068f, -1.6946f, -0.8029f, -0.0577f, -1.3932f, -1.1521f, -0.1249f, -1.4951f,  1.0544f, -1.0773f, -0.6836f, -0.2199f, -1.0543f,  0.4914f,  2.7367f, -0.3824f, -0.5612f, -1.2513f, -1.3397f, -0.8469f, },  // R
/* S */	{   0.5579f, -0.4375f, -0.1305f, -0.0735f, -1.1845f, -0.1462f, -0.4408f, -1.1741f, -0.1017f, -1.2213f, -0.7404f,  0.3005f, -0.4045f, -0.0506f, -0.3824f,  1.9422f,  0.6906f, -0.8231f, -1.3759f, -0.8429f, },  // S
/* T */	{  -0.0227f, -0.4333f, -0.5254f, -0.4316f, -1.0538f, -0.7877f, -0.8429f, -0.3588f, -0.3348f, -0.5987f, -0.3331f, -0.0230f, -0.5376f, -0.3377f, -0.5612f,  0.6906f,  2.2727f, -0.0278f, -1.2145f, -0.8030f, },  // T
/* V */	{  -0.0947f, -0.4038f, -1.5713f, -1.2211f, -0.4245f, -1.5694f, -1.5587f,  1.2735f, -1.1312f,  0.3942f,  0.3436f, -1.4382f, -1.1744f, -1.0992f, -1.2513f, -0.8231f, -0.0278f,  1.8845f, -1.4171f, -0.6038f, },  // V
/* W */	{  -1.2634f, -1.1521f, -2.1072f, -1.4177f,  0.4588f, -1.2457f, -1.1711f, -1.2903f, -1.4782f, -0.8159f, -0.7124f, -1.8480f, -1.8271f, -0.9732f, -1.3397f, -1.3759f, -1.2145f, -1.4171f,  5.2520f,  1.0771f, },  // W
/* Y */	{  -0.8820f, -1.2036f, -1.5325f, -1.0102f,  1.4696f, -1.5199f,  0.8463f, -0.6657f, -0.9100f, -0.5310f, -0.4974f, -1.0409f, -1.4599f, -0.7105f, -0.8469f, -0.8429f, -0.8030f, -0.6038f,  1.0771f,  3.2975f, },  // Y
	};

void GetSubstMx_Letter_Blosum(uint PctId, float Mx[20][20])
	{
#define X(x)										\
	case x:											\
	for (unsigned i = 0; i < 20; ++i)				\
		for (unsigned j = 0; j < 20; ++j)			\
			Mx[i][j] = Blosum##x##_sij[i][j];		\
	return;

	switch (PctId)
		{
		X(90);
		X(70);
		X(80);
		X(62);
		}
#undef X
	Die("SetSubstMx_Letter_Blosum(%u)", PctId);
	}

void GetGapParams_Blosum(uint PctId, uint n, float *ptrGapOpen, float *ptrCenter)
	{
#define X(p, i, G, C)	if (PctId == p && i == n) { *ptrGapOpen = float(G); *ptrCenter = float(C); return; }

	X(90, 0,  -7.3333335,         1.2)
	X(90, 1,  -8.1662216,   1.0788642)
	X(90, 2,  -6.7398319,   1.0459337)
	X(90, 3,  -7.0647068,   1.2546233)

	X(80, 0,  -6.6666665,  0.99999994)
	X(80, 1,  -7.2274466,  0.91091353)
	X(80, 2,  -7.6157303,  0.86217165)
	X(80, 3,  -7.1673636,  0.85966408)

	X(70, 0,  -6.2208495,  0.88161403)
	X(70, 1,  -7.3177958,  0.70952064)
	X(70, 2,  -7.1693735,  0.93325645)
	X(70, 3,  -6.7926803,  0.71609467)

	X(62, 0,          -6,  0.79999995)
	X(62, 1,  -5.6413326,  0.71837389)
	X(62, 2,  -6.6825562,  0.59377569)
	X(62, 3,   -5.574501,  0.66151822)

#undef X
	Die("GetGapParams_Blosum(%u, %u)", PctId, n);
	}

float GetBlosumScoreChars(byte a, byte b)
	{
	uint ia = g_CharToLetterAmino[a];
	uint ib = g_CharToLetterAmino[b];
	if (ia >= 20 || ib >= 20)
		return 0;
	return Blosum62_sij[ia][ib];
	}
