
#include <string.h>

#include "common.h"
#include "prog_config.h"
#include "cipher.h"
#include "passfile.h"


/*
 * Given a name, sets up the cipher in the given config structure
 */
int
conf_cipher(struct config *conf, char *cipher_name, char *digest_name)
{
   char *cipher_name_buf;
   char *digest_name_buf;
   struct cipher *cipher;

   /* Are the given names viable ? */
   if ( strlen(cipher_name) >= CIPHER_TYPE_MAXLEN - 5 ) {
      ERROR("Proposed cipher name is too long");
      }

   if ( strlen(digest_name) >= CIPHER_TYPE_MAXLEN - 1 ) {
      ERROR("Proposed digest name is too long");
      }

   cipher_name_buf = XMALLOC(char, CIPHER_TYPE_MAXLEN); 
   digest_name_buf = XMALLOC(char, CIPHER_TYPE_MAXLEN); 
   strcpy(cipher_name_buf, cipher_name);
   strcpy(digest_name_buf, digest_name);

   /* Create a cipher */
   cipher               = XMALLOC(struct cipher, 1);
   cipher->type         = cipher_type(cipher_name_buf);
   cipher->name         = cipher_name_buf;
   cipher->digest_name  = digest_name_buf;
   cipher->digest_type  = digest_type(digest_name_buf);

   if (0 == cipher->type) {
      ERROR_1("Unsupported cipher type (%s), run openssl to get"
              " a list of -cbc ciphers available", cipher_name_buf);
      }

   if (0 == cipher->digest_type) {
      ERROR_1("Unsupported digest type (%s), run openssl to get"
              " a list of digests available", digest_name_buf);
      }
   /* Set the cipher as part of the config */
   cipher_new(cipher, cipher->type);
   conf->cipher = cipher;

   /* See if we are running unattended and get the key/iv from a file */
   if (conf->noprompt) {
      ASSERT( restore_key_iv(conf));
      }
   else { 
      /* Generate a key and iv */
      ASSERT( cipher_key_iv(conf)); 

      /* Save to file for later use if needed */
      if (conf->addkey) {
         ASSERT( save_key_iv(conf));
         }
      }

   OK;
}
