
/* $Id: bzip_vars.c,v 1.4 2004/12/05 14:59:13 alien-science Exp $ */

#include <stdlib.h>
#include <string.h>
#include <bzlib.h>

/****
  Finds the header that the bzlib puts on each block 
****/

#define LARGE_LEN (1024 * 1024 * 2)
char compress_first[] = "I am a teapot and I don't like cheese";
char compress_next[]  = "Bloop, I am lost in space and can't find bananas";
char out_first[200];
char out_next[200];
char the_header[200];
   
void 
compress_it (bz_stream *strm, char *to_compress, size_t in_len, 
                              char *out, size_t out_len)
{
   int res;
   /* Initialise the stream */
   strm->bzalloc = NULL;
   strm->bzfree  = NULL;
   strm->opaque  = NULL;

   res = BZ2_bzCompressInit(strm, 1, 0, 0);

   if (BZ_OK != res) {
      fprintf(stderr, "Failure to init libbzip2, code:0x%x\n", res);
      exit(1);
      }

   strm->avail_in  = in_len;
   strm->next_in   = to_compress;
   strm->next_out  = out;
   strm->avail_out = out_len;

   res = 0;
   while (BZ_STREAM_END != res) {

      res = BZ2_bzCompress(strm, BZ_FINISH);

      if (!(BZ_FINISH_OK == res || BZ_STREAM_END == res)) {
         fprintf(stderr, "Failure during compression, code: 0x%x\n", res);
         exit(1);
         }
      }

   BZ2_bzCompressEnd(strm); 
}


int main (int argc, char *argv[])
{
   int i;
   int header_len;
   char header_str[256];
   char *compress_large, *out_large;
   char *p;
   bz_stream strm;

   compress_large = malloc(LARGE_LEN);
   out_large      = malloc(LARGE_LEN);

   /* Compress sets of data */
   compress_it(&strm, compress_first, strlen(compress_first), out_first, 200);
   compress_it(&strm, compress_next, strlen(compress_next), out_next, 200);
   compress_it(&strm, compress_large, LARGE_LEN, out_large, LARGE_LEN);

   strcpy(header_str, "{");
   p = header_str + 1;
   for (i = 0; out_first[i] == out_next[i] &&
               out_first[i] == out_large[i]; i++) {
      if (i > 0 ) p += sprintf(p,",");

      p += sprintf(p,"0x%02x", (unsigned char) out_first[i]);
      }

   header_len = i;
   p = '\0';
   strcat(header_str, "}");

   /* Report the values in a configure script friendly format */
   printf("COMPRESS_HEADER=%s\n", header_str);
   printf("COMPRESS_HEADER_LEN=%d\n", header_len);

   exit(0);
}


