
/* $Id: common.h,v 1.4 2004/11/28 14:33:43 alien-science Exp $ */

#ifndef COMMON_H
#define COMMON_H

#include <stdlib.h>

#define XMALLOC(type, num)                                  \
        ((type *) xmalloc ((num) * sizeof(type)))            

#define XFREE(stale)                            do {        \
        if (stale) { free (stale);  stale = 0; }            \
                                                } while (0)  
#define XBURN(stale, len)                       do {        \
        if (stale) { burn(stale, len); XFREE(stale); }      \
                                                } while (0)  

/***  Error macros ***/

/* Errors causing a return */
#define ERROR(mess)                                         \
         fprintf(stderr, "[error] ");                       \
         fprintf(stderr, mess);                             \
         fprintf(stderr, "\n");                             \
         return -1                        

#define ERROR_1(format, arg)                                \
         fprintf(stderr, "[error] ");                       \
         fprintf(stderr, format, arg);                      \
         fprintf(stderr, "\n");                             \
         return -1                        

#define PERROR(message)                                      \
         fprintf(stderr, "[error] ");                        \
         perror(message);                                    \
         return -1

/* Errors breaking out of a loop (require a 'ret' variable) */
#define LERROR(mess)                                         \
         fprintf(stderr, "[error] ");                        \
         fprintf(stderr, mess);                              \
         fprintf(stderr, "\n");                              \
         ret = -1; break                        

#define LERROR_1(format, arg)                                \
         fprintf(stderr, "[error] ");                        \
         fprintf(stderr, format, arg);                       \
         fprintf(stderr, "\n");                              \
         ret = -1; break                        


/*** Debug/verbose **/

extern int g_verbose;

#define VERBOSE(mess)                                       \
         if (g_verbose) {                                   \
            fprintf(stderr, "[verbose] ");                  \
            fprintf(stderr, mess);                          \
            fprintf(stderr, "\n");                          \
            }

#define VERBOSE_1(format, arg)                              \
         if (g_verbose) {                                   \
             fprintf(stderr, "[verbose] ");                 \
             fprintf(stderr, format, arg);                  \
             fprintf(stderr, "\n");                         \
             }

#define VERBOSE_2(format, arg1, arg2)                       \
         if (g_verbose) {                                   \
             fprintf(stderr, "[verbose] ");                 \
             fprintf(stderr, format, arg1, arg2);           \
             fprintf(stderr, "\n");                         \
             }

#define WARNING(mess)                                       \
         fprintf(stderr, "[warning] ");                     \
         fprintf(stderr, mess);                             \
         fprintf(stderr, "\n");


#undef  OK
#define OK  return 0 

#define ASSERT(call)                            do {        \
        if (-1 == (call)) { return -1; }                    \
                                                } while (0)  

/* ASSERT for use in loops */
#define LASSERT(call)                                       \
         if (-1 == (ret = (-1 == (call)) ? -1 : ret))       \
            break

/* Immortal macros */
#define MIN(a, b) ((a) < (b)) ?  (a) : (b)

/* Error functions that exit */
extern void sysfatal    (char *);
extern void fatal       (char *);

/* Memory */
extern void *xmalloc    (size_t);
extern void burn        (void *, size_t);
extern void for_burning (void **, size_t);

#endif
