
/* $Id: common.c,v 1.5 2004/12/05 16:03:07 alien-science Exp $ */

#include <string.h>
#include <stdio.h>

#include "common.h"
#include "stdarg.h"

#define INCINERATOR_SIZE 16

static struct { void **ptr; size_t len; } 
   Incinerator[INCINERATOR_SIZE] = { 
      {0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},
      {0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0}};


/******************* Memory functions *****************************************/

void
incinerate()
{
   int i;

   for (i = 0; i < INCINERATOR_SIZE; i++) {
      if (0 != Incinerator[i].ptr && 0 != *(Incinerator[i].ptr)) {
         XBURN(*(Incinerator[i].ptr), Incinerator[i].len);
         }
      }
}

void *
xmalloc (size_t num)
{
   void *new = malloc(num);
   if (!new)
      sysfatal("Memory exhausted");

   return new;
}

void 
burn (void *ptr, size_t len)
{
   if (0 != ptr) {
      memset(ptr, 0, len);
      }
}

void
for_burning (void **ptr, size_t len)
{
   int i;

   /* Add to the incinerator */
   for (i = 0 ; i < INCINERATOR_SIZE; i++) {
      if (0 == Incinerator[i].ptr) {
         Incinerator[i].len = len;
         Incinerator[i].ptr = ptr;
         break;
         }
      }

   /* See if this was successful */
   if (i >= INCINERATOR_SIZE) {
      fatal("Ran out of room in incinerator");
      }
}

/******************* Die functions *******************************************/

void
sysfatal(char *mess)
{
   incinerate();
   perror(mess);
   exit(1);
}

void
fatal(char *mess)
{
   incinerate();
   puts(mess);
   exit(1);
}

