// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
//===========================================================================

#include "mtl/utils.h"
#include "mtl/matrix.h"
#include "matrix_test.h"

// matrix_attr.h is generated by make_and_test.pl and defines
// NUMTYPE, SHAPE, STORAGE, ORIEN, and TESTNAME
// you can create your own for testing purposes
#include "matrix_attr.h"


template <class Matrix>
inline bool const_oned_test(const Matrix& A, std::string test_name)
{
  typedef typename mtl::matrix_traits<Matrix>::value_type T;
  typedef typename mtl::matrix_traits<Matrix>::size_type Int;
  {
    /* read it out */
    T c = T(0);
    for (Int i = 0; i < A.noneds(); ++i) {
      for (typename Matrix::OneDRef::const_iterator j = A[i].begin();
	   j != A[i].end(); ++j) {
	c = c + T(1);
	if (*j != c) {
	  std::cerr << "**** FAILED: (const oned) "
	       << test_name.c_str() << " ****" << std::endl;
	  return false;
	}
      }
    }
  }
  return true;
}

template <class Matrix>
inline bool oned_test(Matrix& A, std::string test_name)
{
  typedef typename mtl::matrix_traits<Matrix>::value_type T;
  typedef typename mtl::matrix_traits<Matrix>::size_type Int;

  {
    /* read it out */
    T c = T(0);
    for (Int i = 0; i < A.noneds(); ++i) {
      for (typename Matrix::OneDRef::iterator j = A[i].begin();
	   j != A[i].end(); ++j) {
	c = c + T(1);
	if (*j != c) {
	  std::cerr << "**** FAILED: (oned) "
	       << test_name.c_str() << " ****" << std::endl;
	  return false;
	}
      }
    }
  }
  bool ret = const_oned_test(A, test_name);
  if (ret) {
    std::cout << test_name.c_str() << " passed oned_test" << std::endl;
    return true;
  } else
    return false;
}


template <class Matrix>
void
do_test(Matrix& A, std::string test_name)
{
  using namespace mtl;

  typedef typename mtl::matrix_traits<Matrix>::value_type T;
  typedef typename mtl::matrix_traits<Matrix>::size_type Int;

  iterator_fill(A);

  oned_test(A, test_name);
}


int
main(int argc, char* argv[])
{
  if (argc < 5) {
    std::cerr << "matrix_test <M> <N> <SUB> <SUPER>" << std::endl;
    return -1;
  }

  using namespace mtl;
  using std::string;

  const int M = atoi(argv[1]);
  const int N = atoi(argv[2]);
  const int SUB = atoi(argv[3]);
  const int SUP = atoi(argv[4]);

  std::cout << "M: " << M << " N: " << N 
       << " SUB: " << SUB << " SUPER: " << SUP << std::endl;

  typedef matrix<NUMTYPE, SHAPE, STORAGE, ORIEN>::type Matrix;

  string test_name = TESTNAME;
  Matrix* a = 0;

  create_and_run(M, N, SUB, SUP, test_name, a, Matrix::shape());

  return 0;
}
