: # *-*-perl-*-*
    eval 'exec perl -S  $0 "$@"'
    if $running_under_some_shell;

# This scripty runs through all the combinations of MTL
# matrix types, compiles the test suite for each, and runs the
# test suite for a bunch of different sizes of the matrix.
# This takes a considerably long time to run, since there
# are literally thousands of combinations of MTL matrices.
# There are actually a total of XXXX tests that are run.


# particular headaches were handling the angle brackets
# necessary to put in the templated type arguments



use Getopt::Std;



#fills some arrays and vars
$elts="double:complex<double>";
$r_s="compressed<>:array<linked_list>:array< compressed<> >:array<sparse_pair>:array<tree>:array< dense<> >:dense<>";
$b_s="triangle<unit_lower>:triangle<lower>:symmetric<lower>:diagonal<>:symmetric<upper>:triangle<upper>:triangle<unit_upper>:banded<>";
$b_sh="packed<>:array< dense<> >:banded<>:banded_view<>";
$o="row_major:column_major";


$test_sep = "\n";
$build_sep = "\n\n";


sub run_matrix_test {

  if ($quick_algorithms) {
      $test_programs = `cat qtest`;
  } else {
      $test_programs = `cat alltests`;
  }

  @test_programs = split(/\s/,$test_programs);
  
  foreach $program (@test_programs) {
    
    `rm -f $program $program.exe`;
    $make_result = `make -s $program 2>&1`;

    $warn_count = 0;
    $string = $make_result;
    $warn_count++ while $string =~ /[^_]warning/ig;
    
    $err_count = 0;
    $string = $make_result;
    $err_count++ while $string =~ /error/ig;
    
    if (-f "$program" || -f "$program.exe") {
      $build_result = "SUCCESS";
    } else {
      $build_result = "FAILURE";
    }
    
    $build_header = "%BUILD: NUMTYPE SHAPE STORAGE ORIEN TESTNAME WARN ERR
%NUMTYPE: $n
%SHAPE: $shape
%STORAGE: $s
%ORIEN: $o
%TESTNAME: $program
%WARN: $warn_count
%ERR: $err_count
%RESULT: $build_result
";

    print OUTF $build_header;

    if ($warn_count != 0 || $err_count != 0 || ($build_result eq "FAILURE")) {
      print OUTF $make_result;
    }

    print OUTF $build_sep;
    
    if (-f "$program" || -f "$program.exe") {
      
      local $m, $nn, $sub, $sup;
      
      for ($m = 10; $m < 50; $m += 7) {
	for ($nn = 10; $nn < 50; $nn += 7) {
	  $sub = $m - 1;
	  $sup = $nn - 1;
	  while ($sub >= 0 && $sup >= 0) {
	    
	    $test_header = "%TEST: M N SUB SUPER
%M: $m
%N: $nn
%SUB: $sub
%SUPER: $sup
";

	    $test_result = `$program $m $nn $sub $sup 2>&1`;

	    print OUTF $test_header;

	    if ($test_result =~ /seg/i ||
		$test_result =~ /abort/i ||
		$test_result =~ /bus/i ||
		$test_result =~ /fail/i) {
	      print OUTF  "%RESULT: FAILURE\n";
	      print OUTF $test_result;
	    } else {	
	      print OUTF  "%RESULT: SUCCESS\n";
	    }

	    print OUTF $test_sep;

	    $sup = $sup - $sup * (1/2) - 1;
	    $sub = $sub - $sub * (1/2) - 1;
	  }
	}
      }
    }
  }
}


sub rect_dense {
# rectangle dense matrices
foreach $s  (@RECT_STORAGE){
  foreach $o (@ORIENS){
    foreach $n (@MTLNUMS){

      $shape = "rectangle<>";

      @tmp=split(/</,$s);
      @tmp1=split(/</,$n);
      @tmp2=split(/>/,$tmp[1]);
      $name=$tmp[0]."_".$tmp2[0]."_".$o."_".$tmp1[0];
      $name =~ s/ /_/;
      
      open(HF,">matrix_attr.h");
      printf(HF "/* generated by make_and_test.pl */\n\n");
      printf(HF "#ifndef MATRIX_ATTR_H\n");
      printf(HF "#define MATRIX_ATTR_H\n");
      printf(HF "#define NUMTYPE $n\n");
      printf(HF "#define SHAPE rectangle<>\n");
      printf(HF "#define STORAGE $s\n");
      printf(HF "#define ORIEN $o\n");
      printf(HF "#define TESTNAME \"$name\"\n\n");
      printf(HF "#endif /* MATRIX_ATTR_H */\n");
      close HF;

      run_matrix_test;
    }
  }
}
}

sub banded_and_diagonal {
# banded and diagonal dense matrices
foreach $o (@ORIENS){
  foreach $n (@MTLNUMS){
    foreach $s (@BANDED_STORAGE){
      foreach $shape (@BANDED_SHAPES){
	@tmp1=split(/</,$n);
	@tmp=split(/</,$shape);
	@tmp2=split(/>/,$tmp[1]);
	$name=$tmp[0]."_".$tmp2[0];
	@tmp=split(/</,$s);
	@tmp2=split(/>/,$tmp[1]);
	$name=$name.$tmp[0]."_".$tmp2[0].$o."_".$tmp1[0];
	$name =~ s/ /_/;
	$name =~ s/__/_/;

 	open(HF,">matrix_attr.h");
 	printf(HF "/* generated by make_and_test.pl */\n\n");
 	printf(HF "#ifndef MATRIX_ATTR_H\n");
 	printf(HF "#define MATRIX_ATTR_H\n\n");
 	printf(HF "#define NUMTYPE $n\n");
 	printf(HF "#define SHAPE $shape\n");
 	printf(HF "#define STORAGE $s\n");
 	printf(HF "#define ORIEN $o\n");
 	printf(HF "#define TESTNAME \"$name\"\n\n");
 	printf(HF "#endif /* MATRIX_ATTR_H */\n");
 	close HF;


	run_matrix_test;
      }
    }
  }
}
}


open(OUTF,">make_and_test_results.txt");

#$info_string = "%CONFIG: ARCH OS COMPILER FLAGS
#%%ARCH: @ARGV[0]
#%%OS: @ARGV[1]
#%%COMPILER: @ARGV[2]
#%%FLAGS: @ARGV[3..$#ARGV] 
#";


#printf(OUTF "$info_string\n\n");


$opt_d = ".";
getopts('qQd:p');
chdir "$opt_d";


@MTLNUMS=split(/:/,$elts);
@RECT_STORAGE=split(/:/,$r_s);
@BANDED_SHAPES=split(/:/,$b_s);
@BANDED_STORAGE=split(/:/,$b_sh);
@ORIENS=split(/:/,$o);

$quick_types = 0;
$quick_algorithms = 0;

if ($opt_p) {
  $quick_types = 0;
  $quick_algorithms = 1;
  
  rect_dense;
  banded_and_diagonal;
  
  $quick_types = 1;
  $quick_algorithms = 0;
  
  if ($quick_types) {
    $#MTLNUMS=0;
    $#RECT_STORAGE=0;
    $#BANDED_SHAPES=0;
    $#BANDED_STORAGE=0;
    $#ORIENS=0;
  }
  
  rect_dense;
  banded_and_diagonal;
  
} else {
  $quick_types = $opt_q;
  $quick_algorithms = $opt_Q;
  
  if ($quick_types) {
    $#MTLNUMS=0;
    $#RECT_STORAGE=0;
    $#BANDED_SHAPES=0;
    $#BANDED_STORAGE=0;
    $#ORIENS=0;
  }
  
  rect_dense;
  banded_and_diagonal;
}

close(OUTF);

