/**
 *     AUTHOR: Jose Angel Caso Sanchez, 2004   ( altomaltes@gmail.com )
 *
 *     Copyright (C) 2014, 2012 JACS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *     FILE: fet_db.c
 *     DATE: ene 2012
 *
 *  DESCRIPCION: MSP 430 V2 FET device satabase.
 *
 *
 *  Original file and project:
 *
 *  MSPDebug - debugging tool for MSP430 MCUs
 *   Copyright (C) 2009, 2010 Daniel Beer
 *
 */


#include <string.h>
#include "fet_db.h"
#include "util.h"

#define ETWPID_EMPTY   0x00
#define ETWPID_WDT_A   0x0A
#define ETWPID_APOOL   0x1E
#define ETWPID_USCI0   0x28
#define ETWPID_USCI1   0x29
#define ETWPID_USCI2   0x2A
#define ETWPID_USCI3   0x2B
#define ETWPID_USCIA0  0x2C
#define ETWPID_USCIA1  0x2D
#define ETWPID_USCI    0x2E
#define ETWPID_USCIB0  0x30
#define ETWPID_USCIB1  0x31
#define ETWPID_USB     0x40
#define ETWPID_AES128  0x60
#define ETWPID_TMR0_A3 0x74
#define ETWPID_TMR0_D3 0x75
#define ETWPID_TMR3_A2 0x88
#define ETWPID_TMR2_A2 0x8C
#define ETWPID_RTC     0x8A
#define ETWPID_TMR1_A2 0x8D
#define ETWPID_TA3_0   0x8E
#define ETWPID_TA3_1   0x8F
#define ETWPID_TMR0_A5 0x91
#define ETWPID_TB3_0   0x97
#define ETWPID_TB3_1   0x98
#define ETWPID_TB3_2   0x99
#define ETWPID_TMR0_B7 0x9D
#define ETWPID_COMP_B  0xA8
#define ETWPID_LCDB    0xB0
#define ETWPID_CCS     0xB5
#define ETWPID_DAC12   0xC0
#define ETWPID_SD24B   0xD5
#define ETWPID_ADC10_A 0xD6
#define ETWPID_ADC11_A 0xD7
#define ETWPID_ADC12_A 0xD8


static const struct fet_db_record fet_db[] =
{{        .name= "Prototype_MSP430F11x1"    /* database IDX 1*/
,  .msg28_data= { 0xF1, 0x12   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0x43         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0x00         /* SELF0  (off:  8)*/
		, 0x08         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x01, 0x01 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0xEF,   0xFF, 0xEF, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x00, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x00, 0x00              /* off: 36 Vcc 2 : 0 */
		, 0x00, 0x00              /* off: 38 Vcc 3 : 0 */
		, 0x00, 0x00              /* off: 40 Vcc 4 : 0 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x01                    /* Identification number.*/
, .string     = "Prototype_MSP430F11x1"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0xEF00, .infoEnd = 0xEFFF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0000        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F11x1"    /* database IDX 2*/
,  .msg28_data= { 0xF1, 0x12   /* ID     (off:  0)*/
		, 0x10         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0x00         /* SELF0  (off:  8)*/
		, 0x00         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x02, 0x02 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x00, 0x00              /* off: 36 Vcc 2 : 0 */
		, 0x00, 0x00              /* off: 38 Vcc 3 : 0 */
		, 0x00, 0x00              /* off: 40 Vcc 4 : 0 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x02                    /* Identification number.*/
, .string     = "MSP430F11x1"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F133"    /* database IDX 3*/
,  .msg28_data= { 0xF1, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x03, 0x03 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x03                    /* Identification number.*/
, .string     = "MSP430F133"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F135"    /* database IDX 4*/
,  .msg28_data= { 0xF1, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x04, 0x04 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x04                    /* Identification number.*/
, .string     = "MSP430F135"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F147"    /* database IDX 5*/
,  .msg28_data= { 0xF1, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x05, 0x05 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x05                    /* Identification number.*/
, .string     = "MSP430F147"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F148"    /* database IDX 6*/
,  .msg28_data= { 0xF1, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x06, 0x06 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x06                    /* Identification number.*/
, .string     = "MSP430F148"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F149"    /* database IDX 7*/
,  .msg28_data= { 0xF1, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x07, 0x07 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x07                    /* Identification number.*/
, .string     = "MSP430F149"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "Preliminary_MSP430F413"    /* database IDX 8*/
,  .msg28_data= { 0xF4, 0x03   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x08, 0x08 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x08                    /* Identification number.*/
, .string     = "Preliminary_MSP430F413"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F41x"    /* database IDX 9*/
,  .msg28_data= { 0xF4, 0x13   /* ID     (off:  0)*/
		, 0x02         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x09, 0x09 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x09                    /* Identification number.*/
, .string     = "MSP430F41x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F11x1A"    /* database IDX A*/
,  .msg28_data= { 0xF1, 0x12   /* ID     (off:  0)*/
		, 0x13         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0x00         /* SELF0  (off:  8)*/
		, 0x00         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0A, 0x0A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0A                    /* Identification number.*/
, .string     = "MSP430F11x1A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F12x"    /* database IDX B*/
,  .msg28_data= { 0xF1, 0x23   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0B, 0x0B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0B                    /* Identification number.*/
, .string     = "MSP430F12x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F43x"    /* database IDX C*/
,  .msg28_data= { 0xF4, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0C, 0x0C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0C                    /* Identification number.*/
, .string     = "MSP430F43x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F43x"    /* database IDX D*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0D, 0x0C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0D                    /* Identification number.*/
, .string     = "MSP430F43x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F44x"    /* database IDX E*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x00         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0E, 0x0D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0E                    /* Identification number.*/
, .string     = "MSP430F44x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "Preliminary_MSP430F12x2"    /* database IDX F*/
,  .msg28_data= { 0x12, 0x32   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x0F, 0x0E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x0F                    /* Identification number.*/
, .string     = "Preliminary_MSP430F12x2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F11x2"    /* database IDX 10*/
,  .msg28_data= { 0x11, 0x32   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x10, 0x0F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x10                    /* Identification number.*/
, .string     = "MSP430F11x2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F12x2/F11x2"    /* database IDX 11*/
,  .msg28_data= { 0x12, 0x32   /* ID     (off:  0)*/
		, 0x10         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x11, 0x10 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x11                    /* Identification number.*/
, .string     = "MSP430F12x2/F11x2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "Preliminary_MSP430F16x"    /* database IDX 12*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0x40         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x12, 0x11 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x02, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x03, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x12                    /* Identification number.*/
, .string     = "Preliminary_MSP430F16x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 3             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0002        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE423_P"    /* database IDX 13*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x13, 0x12 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x13                    /* Identification number.*/
, .string     = "MSP430FE423_P"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE425_P"    /* database IDX 14*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x14, 0x13 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x14                    /* Identification number.*/
, .string     = "MSP430FE425_P"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE427_P"    /* database IDX 15*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x15, 0x14 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x15                    /* Identification number.*/
, .string     = "MSP430FE427_P"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE423_N"    /* database IDX 16*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x10         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x16, 0x12 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x16                    /* Identification number.*/
, .string     = "MSP430FE423_N"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE425_N"    /* database IDX 17*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x10         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x17, 0x13 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x17                    /* Identification number.*/
, .string     = "MSP430FE425_N"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE427_N"    /* database IDX 18*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0x10         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x18, 0x14 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x18                    /* Identification number.*/
, .string     = "MSP430FE427_N"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE423"    /* database IDX 19*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x19, 0x12 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x19                    /* Identification number.*/
, .string     = "MSP430FE423"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE425"    /* database IDX 1A*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1A, 0x13 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1A                    /* Identification number.*/
, .string     = "MSP430FE425"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE427"    /* database IDX 1B*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1B, 0x14 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1B                    /* Identification number.*/
, .string     = "MSP430FE427"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F423"    /* database IDX 1C*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1C, 0x15 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1C                    /* Identification number.*/
, .string     = "MSP430F423"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F425"    /* database IDX 1D*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1D, 0x16 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1D                    /* Identification number.*/
, .string     = "MSP430F425"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F427"    /* database IDX 1E*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1E, 0x17 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1E                    /* Identification number.*/
, .string     = "MSP430F427"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FW42x/F41x"    /* database IDX 1F*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x57         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x1F, 0x18 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x1F                    /* Identification number.*/
, .string     = "MSP430FW42x/F41x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4230"    /* database IDX 20*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x20, 0x19 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x20                    /* Identification number.*/
, .string     = "MSP430F4230"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4250"    /* database IDX 21*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x21, 0x1A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x21                    /* Identification number.*/
, .string     = "MSP430F4250"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F42x0"    /* database IDX 22*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x22, 0x1B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x22                    /* Identification number.*/
, .string     = "MSP430F42x0"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F155"    /* database IDX 23*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x23, 0x1C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x23                    /* Identification number.*/
, .string     = "MSP430F155"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F156"    /* database IDX 24*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x24, 0x1D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xA0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x24                    /* Identification number.*/
, .string     = "MSP430F156"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xA000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F157"    /* database IDX 25*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x25, 0x1E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x25                    /* Identification number.*/
, .string     = "MSP430F157"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F167"    /* database IDX 26*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x26, 0x1F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x26                    /* Identification number.*/
, .string     = "MSP430F167"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F168"    /* database IDX 27*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x27, 0x20 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x27                    /* Identification number.*/
, .string     = "MSP430F168"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F169"    /* database IDX 28*/
,  .msg28_data= { 0xF1, 0x69   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x28, 0x21 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x28                    /* Identification number.*/
, .string     = "MSP430F169"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F1610"    /* database IDX 29*/
,  .msg28_data= { 0xF1, 0x6C   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x03         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x29, 0x22 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x24
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x24  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x29                    /* Identification number.*/
, .string     = "MSP430F1610"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x24FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F1611"    /* database IDX 2A*/
,  .msg28_data= { 0xF1, 0x6C   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2A, 0x23 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x38
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x38  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2A                    /* Identification number.*/
, .string     = "MSP430F1611"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x38FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F1612"    /* database IDX 2B*/
,  .msg28_data= { 0xF1, 0x6C   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2B, 0x24 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x25,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x24
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x24  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2B                    /* Identification number.*/
, .string     = "MSP430F1612"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2500, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x24FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F169"    /* database IDX 2C*/
,  .msg28_data= { 0xF1, 0x6C   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x07         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2C, 0x21 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2C                    /* Identification number.*/
, .string     = "MSP430F169"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG43x_F43x"    /* database IDX 2D*/
,  .msg28_data= { 0xF4, 0x39   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2D, 0x25 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2D                    /* Identification number.*/
, .string     = "MSP430FG43x_F43x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG4619"    /* database IDX 2E*/
,  .msg28_data= { 0xF4, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2E, 0x26 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2E                    /* Identification number.*/
, .string     = "MSP430FG4619"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F21x1"    /* database IDX 2F*/
,  .msg28_data= { 0xF2, 0x13   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x01         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x2F, 0x27 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x2F                    /* Identification number.*/
, .string     = "MSP430F21x1"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "TMS430FCAS001"    /* database IDX 30*/
,  .msg28_data= { 0xAF, 0x13   /* ID     (off:  0)*/
		, 0x90         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x30, 0x28 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x10,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0x7F, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x05,   0xFF, 0x0C              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x29, 0x00              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x9A, 0x0B              /* off: 32 Vcc 0 : 2970 */
		, 0x7C, 0x15              /* off: 34 Vcc 1 : 5500 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x02, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x37, 0x00  /* SET */
		, 0x17, 0x00  /* SET */
		, 0x00, 0x00 }

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x00, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x02, 0x00  /* SET */
		, 0x08, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x30                    /* Identification number.*/
, .string     = "TMS430FCAS001"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x107F /* INFO Memory range */
, .ramStart   = 0x0500, .ramEnd  = 0x0CFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0B9A, .vccMaxOp= 0x157C /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 0             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 2             /*  Breakpoint Modes*/
, .nBreakRdWr    = 8
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "TMS430FCAS003"    /* database IDX 31*/
,  .msg28_data= { 0xAF, 0x12   /* ID     (off:  0)*/
		, 0x50         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x31, 0x29 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0x7F, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x05,   0xFF, 0x07              /* off: 12 RAM  */
		, 0x00, 0x00,   0x00, 0x00              /* off: 16 RAM2 */

		, 0x00, 0x00              /* off: 20  Breakpoints */
		, 0x00, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x29, 0x00              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x3F, 0x0C              /* off: 32 Vcc 0 : 3135 */
		, 0x82, 0x14              /* off: 34 Vcc 1 : 5250 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x02, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x37, 0x00  /* SET */
		, 0x17, 0x00  /* SET */
		, 0x00, 0x00 }

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x00, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x31                    /* Identification number.*/
, .string     = "TMS430FCAS003"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x107F /* INFO Memory range */
, .ramStart   = 0x0500, .ramEnd  = 0x07FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0C3F, .vccMaxOp= 0x1482 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 0             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 0             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0000        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "TMS430ROMSHUTTLE"    /* database IDX 32*/
,  .msg28_data= { 0xA0, 0x54   /* ID     (off:  0)*/
		, 0x49         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x32, 0x2A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0x7F, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x05,   0xFF, 0x07              /* off: 12 RAM  */
		, 0x00, 0x00,   0x00, 0x00              /* off: 16 RAM2 */

		, 0x00, 0x00              /* off: 20  Breakpoints */
		, 0x00, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x29, 0x00              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x3F, 0x0C              /* off: 32 Vcc 0 : 3135 */
		, 0x82, 0x14              /* off: 34 Vcc 1 : 5250 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x02, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x37, 0x00  /* SET */
		, 0x17, 0x00  /* SET */
		, 0x00, 0x00 }

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x00, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x32                    /* Identification number.*/
, .string     = "TMS430ROMSHUTTLE"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x107F /* INFO Memory range */
, .ramStart   = 0x0500, .ramEnd  = 0x07FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0C3F, .vccMaxOp= 0x1482 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 0             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 0             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0000        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "TMS430EMU"    /* database IDX 33*/
,  .msg28_data= { 0xAE, 0x10   /* ID     (off:  0)*/
		, 0x00         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x33, 0x2B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x10,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0x7F, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x05,   0xFF, 0x0C              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x29, 0x00              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x9A, 0x0B              /* off: 32 Vcc 0 : 2970 */
		, 0x7C, 0x15              /* off: 34 Vcc 1 : 5500 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x02, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x37, 0x00  /* SET */
		, 0x17, 0x00  /* SET */
		, 0x00, 0x00 }

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x00, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x02, 0x00  /* SET */
		, 0x08, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x33                    /* Identification number.*/
, .string     = "TMS430EMU"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x107F /* INFO Memory range */
, .ramStart   = 0x0500, .ramEnd  = 0x0CFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0B9A, .vccMaxOp= 0x157C /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 0             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 2             /*  Breakpoint Modes*/
, .nBreakRdWr    = 8
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F20x3"    /* database IDX 34*/
,  .msg28_data= { 0xF2, 0x01   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x03         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x34, 0x2C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF8,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0x7F, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x34                    /* Identification number.*/
, .string     = "MSP430F20x3"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF800, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x027F /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "F20x2_G2x2x_G2x3x"    /* database IDX 35*/
,  .msg28_data= { 0xF2, 0x01   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x35, 0x2D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF8,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0x7F, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x35                    /* Identification number.*/
, .string     = "F20x2_G2x2x_G2x3x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF800, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x027F /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "F20x1_G2x0x_G2x1x"    /* database IDX 36*/
,  .msg28_data= { 0xF2, 0x01   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x01         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x36, 0x2E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF8,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0x7F, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x36                    /* Identification number.*/
, .string     = "F20x1_G2x0x_G2x1x"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF800, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x027F /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2234"    /* database IDX 37*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x37, 0x2F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x37                    /* Identification number.*/
, .string     = "MSP430F2234"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2254"    /* database IDX 38*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x38, 0x30 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x38                    /* Identification number.*/
, .string     = "MSP430F2254"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2274"    /* database IDX 39*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x39, 0x31 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x39                    /* Identification number.*/
, .string     = "MSP430F2274"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG4618"    /* database IDX 3A*/
,  .msg28_data= { 0xF4, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3A, 0x32 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3A                    /* Identification number.*/
, .string     = "MSP430FG4618"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2330"    /* database IDX 3B*/
,  .msg28_data= { 0xF2, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3B, 0x33 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3B                    /* Identification number.*/
, .string     = "MSP430F2330"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2350"    /* database IDX 3C*/
,  .msg28_data= { 0xF2, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3C, 0x34 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3C                    /* Identification number.*/
, .string     = "MSP430F2350"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2370"    /* database IDX 3D*/
,  .msg28_data= { 0xF2, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3D, 0x35 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3D                    /* Identification number.*/
, .string     = "MSP430F2370"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2232"    /* database IDX 3E*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3E, 0x36 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3E                    /* Identification number.*/
, .string     = "MSP430F2232"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2252"    /* database IDX 3F*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x3F, 0x37 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x3F                    /* Identification number.*/
, .string     = "MSP430F2252"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2272"    /* database IDX 40*/
,  .msg28_data= { 0xF2, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x40, 0x38 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x40                    /* Identification number.*/
, .string     = "MSP430F2272"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2619"    /* database IDX 41*/
,  .msg28_data= { 0xF2, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x41, 0x39 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x41                    /* Identification number.*/
, .string     = "MSP430F2619"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2618"    /* database IDX 42*/
,  .msg28_data= { 0xF2, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x42, 0x3A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x42                    /* Identification number.*/
, .string     = "MSP430F2618"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2419"    /* database IDX 43*/
,  .msg28_data= { 0xF2, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x43, 0x3B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x43                    /* Identification number.*/
, .string     = "MSP430F2419"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2418"    /* database IDX 44*/
,  .msg28_data= { 0xF2, 0x6F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x44, 0x3C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x44                    /* Identification number.*/
, .string     = "MSP430F2418"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE423A"    /* database IDX 45*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x45, 0x3D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x45                    /* Identification number.*/
, .string     = "MSP430FE423A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE425A"    /* database IDX 46*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x46, 0x3E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x46                    /* Identification number.*/
, .string     = "MSP430FE425A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE427A"    /* database IDX 47*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x47, 0x3F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x47                    /* Identification number.*/
, .string     = "MSP430FE427A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F423A"    /* database IDX 48*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x48, 0x40 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x48                    /* Identification number.*/
, .string     = "MSP430F423A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F425A"    /* database IDX 49*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x49, 0x41 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x49                    /* Identification number.*/
, .string     = "MSP430F425A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F427A"    /* database IDX 4A*/
,  .msg28_data= { 0x42, 0x7A   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4A, 0x42 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4A                    /* Identification number.*/
, .string     = "MSP430F427A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4783"    /* database IDX 4B*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x07         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4B, 0x43 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4B                    /* Identification number.*/
, .string     = "MSP430F4783"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4784"    /* database IDX 4C*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x03         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4C, 0x44 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4C                    /* Identification number.*/
, .string     = "MSP430F4784"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4793"    /* database IDX 4D*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4D, 0x45 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x0B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4D                    /* Identification number.*/
, .string     = "MSP430F4793"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x0BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4794"    /* database IDX 4E*/
,  .msg28_data= { 0xF4, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4E, 0x46 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x0B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4E                    /* Identification number.*/
, .string     = "MSP430F4794"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x0BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F249"    /* database IDX 4F*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x4F, 0x47 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x4F                    /* Identification number.*/
, .string     = "MSP430F249"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F248"    /* database IDX 50*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x50, 0x48 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x50                    /* Identification number.*/
, .string     = "MSP430F248"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F247"    /* database IDX 51*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x51, 0x49 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x51                    /* Identification number.*/
, .string     = "MSP430F247"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F235"    /* database IDX 52*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x03         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x52, 0x4A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x52                    /* Identification number.*/
, .string     = "MSP430F235"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2491"    /* database IDX 53*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x53, 0x4B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x53                    /* Identification number.*/
, .string     = "MSP430F2491"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2481"    /* database IDX 54*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x54, 0x4C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x54                    /* Identification number.*/
, .string     = "MSP430F2481"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2471"    /* database IDX 55*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x55, 0x4D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x55                    /* Identification number.*/
, .string     = "MSP430F2471"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F233"    /* database IDX 56*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x07         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x56, 0x4E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x56                    /* Identification number.*/
, .string     = "MSP430F233"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2410"    /* database IDX 57*/
,  .msg28_data= { 0xF2, 0x49   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x08         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x57, 0x4F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x01, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x57                    /* Identification number.*/
, .string     = "MSP430F2410"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 1             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2132"    /* database IDX 58*/
,  .msg28_data= { 0xF2, 0x13   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x58, 0x50 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x58                    /* Identification number.*/
, .string     = "MSP430F2132"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2122"    /* database IDX 59*/
,  .msg28_data= { 0xF2, 0x13   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x59, 0x51 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x59                    /* Identification number.*/
, .string     = "MSP430F2122"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F2112"    /* database IDX 5A*/
,  .msg28_data= { 0xF2, 0x13   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x02         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x03 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5A, 0x52 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xF8,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5A                    /* Identification number.*/
, .string     = "MSP430F2112"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xF800, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "XMS430F5438"    /* database IDX 5B*/
,  .msg28_data= { 0x54, 0x38   /* ID     (off:  0)*/
		, 0x01         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5B, 0x53 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5B                    /* Identification number.*/
, .string     = "XMS430F5438"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x45BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5438"    /* database IDX 5C*/
,  .msg28_data= { 0x54, 0x38   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5C, 0x54 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5C                    /* Identification number.*/
, .string     = "MSP430F5438"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x45BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5436"    /* database IDX 5D*/
,  .msg28_data= { 0x54, 0x36   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5D, 0x55 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5D                    /* Identification number.*/
, .string     = "MSP430F5436"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x35BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5419"    /* database IDX 5E*/
,  .msg28_data= { 0x54, 0x19   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5E, 0x56 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5E                    /* Identification number.*/
, .string     = "MSP430F5419"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x25BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE4232"    /* database IDX 5F*/
,  .msg28_data= { 0x42, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x12         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x5F, 0x57 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x5F                    /* Identification number.*/
, .string     = "MSP430FE4232"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE42x2"    /* database IDX 60*/
,  .msg28_data= { 0x42, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x11         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x60, 0x58 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x60                    /* Identification number.*/
, .string     = "MSP430FE42x2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5437"    /* database IDX 61*/
,  .msg28_data= { 0x54, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x61, 0x59 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x61                    /* Identification number.*/
, .string     = "MSP430F5437"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x45BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5435"    /* database IDX 62*/
,  .msg28_data= { 0x54, 0x35   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x62, 0x5A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x62                    /* Identification number.*/
, .string     = "MSP430F5435"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x35BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5418"    /* database IDX 63*/
,  .msg28_data= { 0x54, 0x18   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x63, 0x5B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x63                    /* Identification number.*/
, .string     = "MSP430F5418"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x25BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG4250"    /* database IDX 64*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x64, 0x5C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x64                    /* Identification number.*/
, .string     = "MSP430FG4250"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG42x0"    /* database IDX 65*/
,  .msg28_data= { 0xF4, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x65, 0x5D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x65                    /* Identification number.*/
, .string     = "MSP430FG42x0"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FE4272"    /* database IDX 66*/
,  .msg28_data= { 0x42, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x45         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x10         /* FUSES  (off: 16)*/
		, 0x1F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x66, 0x5E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x05              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x8C, 0x0A              /* off: 32 Vcc 0 : 2700 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xD3, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x66                    /* Identification number.*/
, .string     = "MSP430FE4272"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x05FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0A8C, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG477"    /* database IDX 67*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x67, 0x5F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x67                    /* Identification number.*/
, .string     = "MSP430FG477"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG478"    /* database IDX 68*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x68, 0x60 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x68                    /* Identification number.*/
, .string     = "MSP430FG478"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FG479"    /* database IDX 69*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x69, 0x61 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x69                    /* Identification number.*/
, .string     = "MSP430FG479"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F477"    /* database IDX 6A*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6A, 0x62 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6A                    /* Identification number.*/
, .string     = "MSP430F477"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F478"    /* database IDX 6B*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6B, 0x63 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6B                    /* Identification number.*/
, .string     = "MSP430F478"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F479"    /* database IDX 6C*/
,  .msg28_data= { 0xF4, 0x79   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x47         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x07 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6C, 0x64 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6C                    /* Identification number.*/
, .string     = "MSP430F479"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47197"    /* database IDX 6D*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6D, 0x65 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6D                    /* Identification number.*/
, .string     = "MSP430F47197"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47187"    /* database IDX 6E*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6E, 0x66 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6E                    /* Identification number.*/
, .string     = "MSP430F47187"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47177"    /* database IDX 6F*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x02         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x6F, 0x67 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0x9F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x6F                    /* Identification number.*/
, .string     = "MSP430F47177"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x19FFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47167"    /* database IDX 70*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x03         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x70, 0x68 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0x8F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x70                    /* Identification number.*/
, .string     = "MSP430F47167"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x18FFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47196"    /* database IDX 71*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x04         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x71, 0x69 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x71                    /* Identification number.*/
, .string     = "MSP430F47196"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47186"    /* database IDX 72*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x05         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x72, 0x6A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0xFF, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x72                    /* Identification number.*/
, .string     = "MSP430F47186"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x1FFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47176"    /* database IDX 73*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x06         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x73, 0x6B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x31,   0xFF, 0x9F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x30
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x30  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x73                    /* Identification number.*/
, .string     = "MSP430F47176"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x3100, .mainEnd = 0x19FFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x30FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F47166"    /* database IDX 74*/
,  .msg28_data= { 0xF4, 0x7F   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x07         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x74, 0x6C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x21,   0xFF, 0x8F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x03, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xA4, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x11
		, 0x00, 0x00
		, 0x00, 0x20
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x08, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x11
		, 0x00, 0x00
		, 0xFF, 0x20  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x74                    /* Identification number.*/
, .string     = "MSP430F47166"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x2100, .mainEnd = 0x18FFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x1100, .ram2End = 0x20FF /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00A4 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 8             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 0
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0003        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4152"    /* database IDX 75*/
,  .msg28_data= { 0x41, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x01 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x75, 0x6D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x75                    /* Identification number.*/
, .string     = "MSP430F4152"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F4132"    /* database IDX 76*/
,  .msg28_data= { 0x41, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x01         /* FUSES  (off: 16)*/
		, 0x01 }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x76, 0x6E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0x8C, 0x0A              /* off: 36 Vcc 2 : 2700 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x76                    /* Identification number.*/
, .string     = "MSP430F4132"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F6137"    /* database IDX 77*/
,  .msg28_data= { 0x61, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x77, 0x6F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_LCDB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x77                    /* Identification number.*/
, .string     = "CC430F6137"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F6135"    /* database IDX 78*/
,  .msg28_data= { 0x61, 0x35   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x78, 0x70 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_LCDB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x78                    /* Identification number.*/
, .string     = "CC430F6135"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F6127"    /* database IDX 79*/
,  .msg28_data= { 0x61, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x79, 0x71 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_LCDB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x79                    /* Identification number.*/
, .string     = "CC430F6127"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F6126"    /* database IDX 7A*/
,  .msg28_data= { 0x61, 0x26   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7A, 0x72 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_LCDB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7A                    /* Identification number.*/
, .string     = "CC430F6126"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F6125"    /* database IDX 7B*/
,  .msg28_data= { 0x61, 0x25   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7B, 0x73 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_LCDB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7B                    /* Identification number.*/
, .string     = "CC430F6125"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F5137"    /* database IDX 7C*/
,  .msg28_data= { 0x51, 0x37   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7C, 0x74 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7C                    /* Identification number.*/
, .string     = "CC430F5137"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F5135"    /* database IDX 7D*/
,  .msg28_data= { 0x51, 0x35   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7D, 0x75 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7D                    /* Identification number.*/
, .string     = "CC430F5135"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "CC430F5133"    /* database IDX 7E*/
,  .msg28_data= { 0x51, 0x33   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7E, 0x76 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_AES128
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7E                    /* Identification number.*/
, .string     = "CC430F5133"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5513"    /* database IDX 7F*/
,  .msg28_data= { 0x55, 0x13   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x7F, 0x77 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x7F                    /* Identification number.*/
, .string     = "MSP430F5513"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5514"    /* database IDX 80*/
,  .msg28_data= { 0x55, 0x14   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x80, 0x78 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x80                    /* Identification number.*/
, .string     = "MSP430F5514"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5515"    /* database IDX 81*/
,  .msg28_data= { 0x55, 0x15   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x81, 0x79 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x81                    /* Identification number.*/
, .string     = "MSP430F5515"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5517"    /* database IDX 82*/
,  .msg28_data= { 0x55, 0x17   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x82, 0x7A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x82                    /* Identification number.*/
, .string     = "MSP430F5517"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5519"    /* database IDX 83*/
,  .msg28_data= { 0x55, 0x19   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x83, 0x7B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x83                    /* Identification number.*/
, .string     = "MSP430F5519"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5521"    /* database IDX 84*/
,  .msg28_data= { 0x55, 0x21   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x84, 0x7C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x84                    /* Identification number.*/
, .string     = "MSP430F5521"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5522"    /* database IDX 85*/
,  .msg28_data= { 0x55, 0x22   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x85, 0x7D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x85                    /* Identification number.*/
, .string     = "MSP430F5522"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5524"    /* database IDX 86*/
,  .msg28_data= { 0x55, 0x24   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x86, 0x7E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x86                    /* Identification number.*/
, .string     = "MSP430F5524"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5525"    /* database IDX 87*/
,  .msg28_data= { 0x55, 0x25   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x87, 0x7F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x87                    /* Identification number.*/
, .string     = "MSP430F5525"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5526"    /* database IDX 88*/
,  .msg28_data= { 0x55, 0x26   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x88, 0x80 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x88                    /* Identification number.*/
, .string     = "MSP430F5526"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5527"    /* database IDX 89*/
,  .msg28_data= { 0x55, 0x27   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x89, 0x81 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x89                    /* Identification number.*/
, .string     = "MSP430F5527"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5528"    /* database IDX 8A*/
,  .msg28_data= { 0x55, 0x28   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8A, 0x82 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8A                    /* Identification number.*/
, .string     = "MSP430F5528"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5529"    /* database IDX 8B*/
,  .msg28_data= { 0x55, 0x29   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8B, 0x83 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8B                    /* Identification number.*/
, .string     = "MSP430F5529"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5438A"    /* database IDX 8C*/
,  .msg28_data= { 0x05, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8C, 0x84 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8C                    /* Identification number.*/
, .string     = "MSP430F5438A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x45BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5436A"    /* database IDX 8D*/
,  .msg28_data= { 0x03, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8D, 0x85 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8D                    /* Identification number.*/
, .string     = "MSP430F5436A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x35BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5419A"    /* database IDX 8E*/
,  .msg28_data= { 0x01, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8E, 0x86 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8E                    /* Identification number.*/
, .string     = "MSP430F5419A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x25BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5437A"    /* database IDX 8F*/
,  .msg28_data= { 0x04, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x8F, 0x87 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x8F                    /* Identification number.*/
, .string     = "MSP430F5437A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x45BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5435A"    /* database IDX 90*/
,  .msg28_data= { 0x02, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x90, 0x88 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x90                    /* Identification number.*/
, .string     = "MSP430F5435A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x35BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5418A"    /* database IDX 91*/
,  .msg28_data= { 0x00, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x91, 0x89 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x5C,   0xFF, 0x5B, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x5B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TMR0_B7
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x91                    /* Identification number.*/
, .string     = "MSP430F5418A"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x5C00, .mainEnd = 0x25BFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x5BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5510"    /* database IDX 92*/
,  .msg28_data= { 0x31, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x92, 0x8A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x92                    /* Identification number.*/
, .string     = "MSP430F5510"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5131"    /* database IDX 93*/
,  .msg28_data= { 0x26, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x93, 0x8B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x93                    /* Identification number.*/
, .string     = "MSP430F5131"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5132"    /* database IDX 94*/
,  .msg28_data= { 0x28, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x94, 0x8C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x94                    /* Identification number.*/
, .string     = "MSP430F5132"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5151"    /* database IDX 95*/
,  .msg28_data= { 0x2A, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x95, 0x8D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x95                    /* Identification number.*/
, .string     = "MSP430F5151"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5152"    /* database IDX 96*/
,  .msg28_data= { 0x2C, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x96, 0x8E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x96                    /* Identification number.*/
, .string     = "MSP430F5152"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5171"    /* database IDX 97*/
,  .msg28_data= { 0x2E, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x97, 0x8F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x97                    /* Identification number.*/
, .string     = "MSP430F5171"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5172"    /* database IDX 98*/
,  .msg28_data= { 0x30, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x98, 0x90 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_EMPTY
		, ETWPID_TA3_0  , ETWPID_TMR0_A3
		, ETWPID_TMR0_D3, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x98                    /* Identification number.*/
, .string     = "MSP430F5172"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5630"    /* database IDX 99*/
,  .msg28_data= { 0x3C, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x99, 0x91 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x99                    /* Identification number.*/
, .string     = "MSP430F5630"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5631"    /* database IDX 9A*/
,  .msg28_data= { 0x3E, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9A, 0x92 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9A                    /* Identification number.*/
, .string     = "MSP430F5631"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5632"    /* database IDX 9B*/
,  .msg28_data= { 0x40, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9B, 0x93 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9B                    /* Identification number.*/
, .string     = "MSP430F5632"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5633"    /* database IDX 9C*/
,  .msg28_data= { 0x42, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9C, 0x94 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9C                    /* Identification number.*/
, .string     = "MSP430F5633"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5634"    /* database IDX 9D*/
,  .msg28_data= { 0x44, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9D, 0x95 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9D                    /* Identification number.*/
, .string     = "MSP430F5634"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5635"    /* database IDX 9E*/
,  .msg28_data= { 0x0E, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9E, 0x96 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9E                    /* Identification number.*/
, .string     = "MSP430F5635"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5636"    /* database IDX 9F*/
,  .msg28_data= { 0x10, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0x9F, 0x97 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0x9F                    /* Identification number.*/
, .string     = "MSP430F5636"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5637"    /* database IDX A0*/
,  .msg28_data= { 0x12, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA0, 0x98 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA0                    /* Identification number.*/
, .string     = "MSP430F5637"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5638"    /* database IDX A1*/
,  .msg28_data= { 0x14, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA1, 0x99 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA1                    /* Identification number.*/
, .string     = "MSP430F5638"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6630"    /* database IDX A2*/
,  .msg28_data= { 0x46, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA2, 0x9A /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA2                    /* Identification number.*/
, .string     = "MSP430F6630"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6631"    /* database IDX A3*/
,  .msg28_data= { 0x48, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA3, 0x9B /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA3                    /* Identification number.*/
, .string     = "MSP430F6631"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6632"    /* database IDX A4*/
,  .msg28_data= { 0x4A, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA4, 0x9C /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_EMPTY
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA4                    /* Identification number.*/
, .string     = "MSP430F6632"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6633"    /* database IDX A5*/
,  .msg28_data= { 0x4C, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA5, 0x9D /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA5                    /* Identification number.*/
, .string     = "MSP430F6633"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6634"    /* database IDX A6*/
,  .msg28_data= { 0x4E, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA6, 0x9E /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA6                    /* Identification number.*/
, .string     = "MSP430F6634"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6635"    /* database IDX A7*/
,  .msg28_data= { 0x16, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA7, 0x9F /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA7                    /* Identification number.*/
, .string     = "MSP430F6635"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6636"    /* database IDX A8*/
,  .msg28_data= { 0x18, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA8, 0xA0 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA8                    /* Identification number.*/
, .string     = "MSP430F6636"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x27FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6637"    /* database IDX A9*/
,  .msg28_data= { 0x1A, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xA9, 0xA1 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x03, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xA9                    /* Identification number.*/
, .string     = "MSP430F6637"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x37FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6638"    /* database IDX AA*/
,  .msg28_data= { 0x1C, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAA, 0xA2 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAA                    /* Identification number.*/
, .string     = "MSP430F6638"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FR5739"    /* database IDX AB*/
,  .msg28_data= { 0x03, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAB, 0xA3 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC2,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x18, 0x00, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x00, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x00, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TA3_1
		, ETWPID_TA3_0  , ETWPID_TB3_2
		, ETWPID_TB3_1  , ETWPID_TB3_0
		, ETWPID_USCIA0 , ETWPID_USCIA1
		, ETWPID_USCIB0 , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x01, 0x01  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAB                    /* Identification number.*/
, .string     = "MSP430FR5739"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC200, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x18FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 1             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430L092"    /* database IDX AC*/
,  .msg28_data= { 0x92, 0xC0   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAC, 0xA4 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x1C,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0xFF              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x04, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x17, 0x04              /* off: 26  Id devices */
		, 0x90, 0x00, 0xAF, 0x00  /* off: 28 LCD MEM */

		, 0x84, 0x03              /* off: 32 Vcc 0 : 900 */
		, 0x08, 0x07              /* off: 34 Vcc 1 : 1800 */
		, 0x00, 0x00              /* off: 36 Vcc 2 : 0 */
		, 0x00, 0x00              /* off: 38 Vcc 3 : 0 */
		, 0x00, 0x00              /* off: 40 Vcc 4 : 0 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x00, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x00, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TA3_1
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_CCS    , ETWPID_APOOL
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAC                    /* Identification number.*/
, .string     = "MSP430L092"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1C00, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x0000, .infoEnd = 0x0000 /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0xFFFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x00AF /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0384, .vccMaxOp= 0x0708 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0004        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6700"    /* database IDX AD*/
,  .msg28_data= { 0x54, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAD, 0xA5 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAD                    /* Identification number.*/
, .string     = "MSP430F6700"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6701"    /* database IDX AE*/
,  .msg28_data= { 0x55, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAE, 0xA6 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAE                    /* Identification number.*/
, .string     = "MSP430F6701"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6702"    /* database IDX AF*/
,  .msg28_data= { 0x56, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xAF, 0xA7 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xAF                    /* Identification number.*/
, .string     = "MSP430F6702"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6703"    /* database IDX B0*/
,  .msg28_data= { 0x57, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB0, 0xA8 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0x3F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB0                    /* Identification number.*/
, .string     = "MSP430F6703"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0x13FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6720"    /* database IDX B1*/
,  .msg28_data= { 0x58, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB1, 0xA9 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB1                    /* Identification number.*/
, .string     = "MSP430F6720"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6721"    /* database IDX B2*/
,  .msg28_data= { 0x59, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB2, 0xAA /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB2                    /* Identification number.*/
, .string     = "MSP430F6721"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6722"    /* database IDX B3*/
,  .msg28_data= { 0x60, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB3, 0xAB /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB3                    /* Identification number.*/
, .string     = "MSP430F6722"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6723"    /* database IDX B4*/
,  .msg28_data= { 0x61, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB4, 0xAC /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0x3F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB4                    /* Identification number.*/
, .string     = "MSP430F6723"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0x13FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6730"    /* database IDX B5*/
,  .msg28_data= { 0x62, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB5, 0xAD /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x1F              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB5                    /* Identification number.*/
, .string     = "MSP430F6730"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x1FFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6731"    /* database IDX B6*/
,  .msg28_data= { 0x63, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB6, 0xAE /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB6                    /* Identification number.*/
, .string     = "MSP430F6731"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6732"    /* database IDX B7*/
,  .msg28_data= { 0x64, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB7, 0xAF /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x2B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB7                    /* Identification number.*/
, .string     = "MSP430F6732"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x2BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6733"    /* database IDX B8*/
,  .msg28_data= { 0x65, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB8, 0xB0 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x40,   0xFF, 0x3F, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x23              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x07, 0x24              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR3_A2
		, ETWPID_TMR1_A2, ETWPID_TMR2_A2
		, ETWPID_TA3_0  , ETWPID_EMPTY
		, ETWPID_USCI   , ETWPID_USCIA0
		, ETWPID_USCIA1 , ETWPID_USCIB0
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_SD24B  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB8                    /* Identification number.*/
, .string     = "MSP430F6733"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4000, .mainEnd = 0x13FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x23FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5509"    /* database IDX B9*/
,  .msg28_data= { 0x3A, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xB9, 0xB1 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xA0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xB9                    /* Identification number.*/
, .string     = "MSP430F5509"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xA000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5508"    /* database IDX BA*/
,  .msg28_data= { 0x39, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBA, 0xB2 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBA                    /* Identification number.*/
, .string     = "MSP430F5508"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5507"    /* database IDX BB*/
,  .msg28_data= { 0x38, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBB, 0xB3 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBB                    /* Identification number.*/
, .string     = "MSP430F5507"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5506"    /* database IDX BC*/
,  .msg28_data= { 0x37, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBC, 0xB4 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xA0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBC                    /* Identification number.*/
, .string     = "MSP430F5506"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xA000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5505"    /* database IDX BD*/
,  .msg28_data= { 0x36, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBD, 0xB5 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBD                    /* Identification number.*/
, .string     = "MSP430F5505"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5504"    /* database IDX BE*/
,  .msg28_data= { 0x35, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBE, 0xB6 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBE                    /* Identification number.*/
, .string     = "MSP430F5504"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5503"    /* database IDX BF*/
,  .msg28_data= { 0x34, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xBF, 0xB7 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xBF                    /* Identification number.*/
, .string     = "MSP430F5503"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5502"    /* database IDX C0*/
,  .msg28_data= { 0x33, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC0, 0xB8 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xA0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC0                    /* Identification number.*/
, .string     = "MSP430F5502"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xA000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5501"    /* database IDX C1*/
,  .msg28_data= { 0x32, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC1, 0xB9 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC1                    /* Identification number.*/
, .string     = "MSP430F5501"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5500"    /* database IDX C2*/
,  .msg28_data= { 0x3B, 0x80   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC2, 0xBA /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC2                    /* Identification number.*/
, .string     = "MSP430F5500"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F12x2/F11x2"    /* database IDX C3*/
,  .msg28_data= { 0x12, 0x32   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC3, 0xBB /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x00, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x00, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC3                    /* Identification number.*/
, .string     = "MSP430F12x2/F11x2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 0             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5310"    /* database IDX C4*/
,  .msg28_data= { 0x15, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC4, 0xBC /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC4                    /* Identification number.*/
, .string     = "MSP430F5310"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5309"    /* database IDX C5*/
,  .msg28_data= { 0x14, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC5, 0xBD /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xA0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC5                    /* Identification number.*/
, .string     = "MSP430F5309"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xA000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5308"    /* database IDX C6*/
,  .msg28_data= { 0x13, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC6, 0xBE /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC6                    /* Identification number.*/
, .string     = "MSP430F5308"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5304"    /* database IDX C7*/
,  .msg28_data= { 0x12, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC7, 0xBF /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x03, 0x00              /* off: 16 RAM2 */

		, 0x03, 0x00              /* off: 20  Breakpoints */
		, 0x05, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x01, 0x00, 0x04, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC10_A
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC7                    /* Identification number.*/
, .string     = "MSP430F5304"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 3             /* Number of breakpoints.*/
, .nRegTrigger   = 1             /* Number of CPU Register Trigger.*/
, .nCombinations = 4             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 1             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0005        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430AFE253"    /* database IDX C8*/
,  .msg28_data= { 0x02, 0x53   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0x00         /* FUSES  (off: 16)*/
		, 0x0F }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC8, 0xC0 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xC0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x03              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xF3, 0x00  /* SET */
		, 0xDF, 0x00  /* SET */
		, 0xC0, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC8                    /* Identification number.*/
, .string     = "MSP430AFE253"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xC000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x03FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5329"    /* database IDX C9*/
,  .msg28_data= { 0x1B, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xC9, 0xC1 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xC9                    /* Identification number.*/
, .string     = "MSP430F5329"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5328"    /* database IDX CA*/
,  .msg28_data= { 0x1A, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCA, 0xC2 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCA                    /* Identification number.*/
, .string     = "MSP430F5328"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5327"    /* database IDX CB*/
,  .msg28_data= { 0x19, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCB, 0xC3 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCB                    /* Identification number.*/
, .string     = "MSP430F5327"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5326"    /* database IDX CC*/
,  .msg28_data= { 0x18, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCC, 0xC4 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCC                    /* Identification number.*/
, .string     = "MSP430F5326"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5325"    /* database IDX CD*/
,  .msg28_data= { 0x17, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCD, 0xC5 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCD                    /* Identification number.*/
, .string     = "MSP430F5325"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5324"    /* database IDX CE*/
,  .msg28_data= { 0x16, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCE, 0xC6 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCE                    /* Identification number.*/
, .string     = "MSP430F5324"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430G2xx2"    /* database IDX CF*/
,  .msg28_data= { 0x24, 0x52   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xCF, 0xC7 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0xE0,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x40, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x02              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x33, 0x00  /* SET */
		, 0x1F, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x00, 0x00, 0x00, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xCF                    /* Identification number.*/
, .string     = "MSP430G2xx2"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0xE000, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x02FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x0000, .bslEnd  = 0x0000 /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5342"    /* database IDX D0*/
,  .msg28_data= { 0x1E, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD0, 0xC8 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x02, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x43              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD0                    /* Identification number.*/
, .string     = "MSP430F5342"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x243FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x43FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5341"    /* database IDX D1*/
,  .msg28_data= { 0x1D, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD1, 0xC9 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0xC3, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x3B              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD1                    /* Identification number.*/
, .string     = "MSP430F5341"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x1C3FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x3BFF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5340"    /* database IDX D2*/
,  .msg28_data= { 0x1C, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD2, 0xCA /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x44,   0xFF, 0x43, 0x01, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x33              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x1F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x20, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_USCI2  , ETWPID_USCI3
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD2                    /* Identification number.*/
, .string     = "MSP430F5340"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x4400, .mainEnd = 0x143FF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x33FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430FW429"    /* database IDX D3*/
,  .msg28_data= { 0xF4, 0x29   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0x57         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD3, 0xCB /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x11,   0xFF, 0xFF, 0x00, 0x00  /* off: 0 ROM  */
		, 0x00, 0x10,   0xFF, 0x10, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x02,   0xFF, 0x09              /* off: 12 RAM  */
		, 0x00, 0x00,   0x02, 0x00              /* off: 16 RAM2 */

		, 0x02, 0x00              /* off: 20  Breakpoints */
		, 0x01, 0x00              /* off: 22  Emulation */
		, 0x01, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0xD7, 0x60              /* off: 26  Id devices */
		, 0x90, 0x00, 0x9C, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x00, 0x00              /* off: 42  Has test Vpp*/
		, 0x01, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x33, 0x00  /* SET */
		, 0x13, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x0C, 0xFF, 0x0F, 0x00  /* off: 0 info org, len, banks */
		, 0x02, 0x00, 0x00, 0x02, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x01, 0x00, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD3                    /* Identification number.*/
, .string     = "MSP430FW429"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x1100, .mainEnd = 0xFFFF /* MAIN Memory range */
, .infoStart  = 0x1000, .infoEnd = 0x10FF /* INFO Memory range */
, .ramStart   = 0x0200, .ramEnd  = 0x09FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0x0000 /*  RAM Memory range.*/
, .lcdStart   = 0x0090, .lcdEnd  = 0x009C /*  LCD Memory range.*/
, .bslStart   = 0x0C00, .bslEnd  = 0x0FFF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 0             /* Device has TEST/VPP.*/

, .nBreakpoints  = 2             /* Number of breakpoints.*/
, .nRegTrigger   = 0             /* Number of CPU Register Trigger.*/
, .nCombinations = 2             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 0             /*  Breakpoint Modes*/
, .nBreakRdWr    = 0
, .nBreakRdDma   = 0
, .TrigerMask    = 0             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 0             /* Register Trigger modes*/
, .nStateStorage = 0             /* MSP430 has Stage Storage*/
, .nCycleCount   = 0             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 0             /* Cycle couter modes*/
, .nSequencer    = 0             /* Msp430 has Sequencer*/
, .clockControl  = 1             /* Clock control level.*/

, .emulation     = 0x0001        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6659"    /* database IDX D4*/
,  .msg28_data= { 0x2B, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD4, 0xCC /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x08, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD4                    /* Identification number.*/
, .string     = "MSP430F6659"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x87FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6658"    /* database IDX D5*/
,  .msg28_data= { 0x2C, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD5, 0xCD /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x06, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x80
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x80
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD5                    /* Identification number.*/
, .string     = "MSP430F6658"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x67FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x8000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6459"    /* database IDX D6*/
,  .msg28_data= { 0x2D, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD6, 0xCE /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x08, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD6                    /* Identification number.*/
, .string     = "MSP430F6459"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x87FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6458"    /* database IDX D7*/
,  .msg28_data= { 0x2E, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD7, 0xCF /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x06, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x80
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x80
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD7                    /* Identification number.*/
, .string     = "MSP430F6458"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x67FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x8000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F6457"    /* database IDX D8*/
,  .msg28_data= { 0x2F, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD8, 0xD0 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x04, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_EMPTY
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_LCDB   , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD8                    /* Identification number.*/
, .string     = "MSP430F6457"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x47FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5659"    /* database IDX D9*/
,  .msg28_data= { 0x30, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xD9, 0xD1 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x08, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58, 0x1B              /* off: 40 Vcc 4 : 7000 */

		, 0x01, 0x00              /* off: 42  Has test Vpp*/
		, 0x03, 0x00              /* off: 44 3-> Default clock control */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0xFF
		, 0x00, 0x00
		, 0x00, 0x00
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */
		, 0xFF, 0x00  /* SET */}

,   .msg2b_len=  0x4A
,  .msg2b_data= { 0x00, 0x10, 0xFF, 0x17, 0x00  /* off: 0 info org, len, banks */
		, 0x04, 0x02, 0x00, 0x0A, 0x00  /* off: 5 ram  org, len, banks */

		, 0x40, 0x00  /* off: 10 BYTE FLAGS ?? */

		, ETWPID_WDT_A  , ETWPID_TMR0_A5
		, ETWPID_TA3_0  , ETWPID_TA3_1
		, ETWPID_TMR0_B7, ETWPID_USB
		, ETWPID_USCI0  , ETWPID_USCI1
		, ETWPID_EMPTY  , ETWPID_EMPTY
		, ETWPID_RTC    , ETWPID_ADC12_A
		, ETWPID_COMP_B , ETWPID_DAC12
		, ETWPID_EMPTY  , ETWPID_EMPTY

		, 0x00, 0x01, 0x00, 0x00  /* off: 28 BYTE FLAGS ?? */

		, 0x00, 0x1C
		, 0xFF, 0x23  /* SET */
		, 0x00, 0x00
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x02, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x01, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x0F, 0x00  /* SET */
		, 0xFF, 0xFF  /* SET */
		, 0x0F, 0x00  /* SET */
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00
		, 0x00, 0x00 }


#ifdef MSP430_STORED_INFO

, .endian     = 0xAA55                    /* The value 0xaa55. */
, .id         = 0xD9                    /* Identification number.*/
, .string     = "MSP430F5659"
, .cpuArch    = 0x0000                    /* The MSP430 architecture (non-X, X or Xv2).*/
, .coreIpId   = 0x0000                    /* The CoreIP ID.*/
, .deviceIdPtr= 0x24263F                    /* The Device-ID Pointer.*/

, .mainStart  = 0x8000, .mainEnd = 0x87FFF /* MAIN Memory range */
, .infoStart  = 0x1800, .infoEnd = 0x19FF /* INFO Memory range */
, .ramStart   = 0x1C00, .ramEnd  = 0x63FF /*  RAM Memory range.*/
, .ram2Start  = 0x0000, .ram2End = 0xFFFF /*  RAM Memory range.*/
, .lcdStart   = 0x0000, .lcdEnd  = 0x0000 /*  LCD Memory range.*/
, .bslStart   = 0x1000, .bslEnd  = 0x17FF /*  BSL Memory range.*/
, .vccMinOp   = 0x0708, .vccMaxOp= 0x0E10 /* Vcc range during operation [mVolts].*/

, .hasFramMemory = 0             /*  FRAM Memory type */
, .hasTestVpp    = 1             /* Device has TEST/VPP.*/

, .nBreakpoints  = 8             /* Number of breakpoints.*/
, .nRegTrigger   = 2             /* Number of CPU Register Trigger.*/
, .nCombinations = 10             /* Number of EEM Trigger Combinations.*/
, .nBreakOps     = 1             /*  Breakpoint Modes*/
, .nBreakRdWr    = 1
, .nBreakRdDma   = 1
, .TrigerMask    = 1             /* Trigger Mask for Breakpoint */
, .nRegTriggerMod= 1             /* Register Trigger modes*/
, .nStateStorage = 1             /* MSP430 has Stage Storage*/
, .nCycleCount   = 2             /* Number of cycle counters of MSP430*/
, .nCycleCountOps= 1             /* Cycle couter modes*/
, .nSequencer    = 1             /* Msp430 has Sequencer*/
, .clockControl  = 2             /* Clock control level.*/

, .emulation     = 0x0007        /* Emulation level.*/
, .jtagId        = 0x0000        /* The JTAG ID - value returned on an instruction shift.*/
, .eemVersion    = 0x2800        /* The EEM Version Number.*/

#endif

},
{        .name= "MSP430F5658"    /* database IDX DA*/
,  .msg28_data= { 0x31, 0x81   /* ID     (off:  0)*/
		, 0xFF         /* REV    (off:  2)*/
		, 0xFF         /* FAB    (off:  3)*/
		, 0x00, 0x00, 0x00, 0x00
		, 0xFF         /* SELF0  (off:  8)*/
		, 0xFF         /* SELF1  (off:  9)*/
		, 0x00, 0x00, 0x00
		, 0xFF         /* CONF   (off: 13)*/
		, 0x00, 0x00
		, 0xFF         /* FUSES  (off: 16)*/
		, 0xFF }       /* F PATT (off: 17)*/

, .msg29_params={ 0x00, 0xDA, 0xD2 /*, 0x4A */ }
,   .msg29_data={ 0x00, 0x80,   0xFF, 0x7F, 0x06, 0x00  /* off: 0 ROM  */
		, 0x00, 0x18,   0xFF, 0x19, 0x80, 0x00  /* off: 6 INFO */
		, 0x00, 0x1C,   0xFF, 0x63              /* off: 12 RAM  */
		, 0x00, 0x00,   0x08, 0x00              /* off: 16 RAM2 */

		, 0x08, 0x00              /* off: 20  Breakpoints */
		, 0x07, 0x00              /* off: 22  Emulation */
		, 0x02, 0x00              /* off: 24  GCC (0200 -> extended )*/
		, 0x0F, 0x04              /* off: 26  Id devices */
		, 0x00, 0x00, 0x00, 0x00  /* off: 28 LCD MEM */

		, 0x08, 0x07              /* off: 32 Vcc 0 : 1800 */
		, 0x10, 0x0E              /* off: 34 Vcc 1 : 3600 */
		, 0xC4, 0x09              /* off: 36 Vcc 2 : 2500 */
		, 0x70, 0x17              /* off: 38 Vcc 3 : 6000 */
		, 0x58,