/* -*- Mode: C; c-basic-offset:4 ; indent-tabs-mode:nil ; -*- */
/*
 *  (C) 2011 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */
/* automatically generated
 *   by:   ./maint/genparams
 *   on:   Thu Aug  8 10:42:45 2013
 *   from: src/util/param/params.yml (md5sum beb0b9bdce83b3cf4840f2fc8442faa0)
 *
 * DO NOT EDIT!!!
 */

#if !defined(MPICH_PARAM_VALS_H_INCLUDED)
#define MPICH_PARAM_VALS_H_INCLUDED

/* parameter categories */
enum MPIR_Param_category_id_t {
    MPIR_PARAM_CATEGORY_ID_collective,
    MPIR_PARAM_CATEGORY_ID_communicator,
    MPIR_PARAM_CATEGORY_ID_pt2pt,
    MPIR_PARAM_CATEGORY_ID_rma,
    MPIR_PARAM_CATEGORY_ID_intranode,
    MPIR_PARAM_CATEGORY_ID_developer,
    MPIR_PARAM_CATEGORY_ID_memory,
    MPIR_PARAM_CATEGORY_ID_error_handling,
    MPIR_PARAM_CATEGORY_ID_debugger,
    MPIR_PARAM_CATEGORY_ID_checkpointing,
    MPIR_PARAM_CATEGORY_ID_fault_tolerance,
    MPIR_PARAM_CATEGORY_ID_threads,
    MPIR_PARAM_CATEGORY_ID_ch3,
    MPIR_PARAM_CATEGORY_ID_nemesis,
    MPIR_PARAM_CATEGORY_ID_sockets,
    MPIR_PARAM_CATEGORY_ID_process_manager,
    MPIR_PARAM_NUM_CATEGORIES
};

struct MPIR_Param_category_t {
    const enum MPIR_Param_category_id_t id;
    const char *name;
    const char *description;
};

/* array of category info for runtime usage */
extern struct MPIR_Param_category_t MPIR_Param_categories[MPIR_PARAM_NUM_CATEGORIES];

/* parameter values */
enum MPIR_Param_id_t {
    MPIR_PARAM_ID_ALLTOALL_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_ALLTOALL_MEDIUM_MSG_SIZE,
    MPIR_PARAM_ID_ALLTOALL_THROTTLE,
    MPIR_PARAM_ID_REDSCAT_COMMUTATIVE_LONG_MSG_SIZE,
    MPIR_PARAM_ID_BCAST_MIN_PROCS,
    MPIR_PARAM_ID_BCAST_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_BCAST_LONG_MSG_SIZE,
    MPIR_PARAM_ID_ALLGATHER_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_ALLGATHER_LONG_MSG_SIZE,
    MPIR_PARAM_ID_REDUCE_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_ALLREDUCE_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_GATHER_VSMALL_MSG_SIZE,
    MPIR_PARAM_ID_GATHER_INTER_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_GATHERV_INTER_SSEND_MIN_PROCS,
    MPIR_PARAM_ID_SCATTER_INTER_SHORT_MSG_SIZE,
    MPIR_PARAM_ID_ALLGATHERV_PIPELINE_MSG_SIZE,
    MPIR_PARAM_ID_ENABLE_SMP_COLLECTIVES,
    MPIR_PARAM_ID_ENABLE_SMP_BARRIER,
    MPIR_PARAM_ID_ENABLE_SMP_BCAST,
    MPIR_PARAM_ID_MAX_SMP_BCAST_MSG_SIZE,
    MPIR_PARAM_ID_ENABLE_SMP_REDUCE,
    MPIR_PARAM_ID_MAX_SMP_REDUCE_MSG_SIZE,
    MPIR_PARAM_ID_ENABLE_SMP_ALLREDUCE,
    MPIR_PARAM_ID_MAX_SMP_ALLREDUCE_MSG_SIZE,
    MPIR_PARAM_ID_COMM_SPLIT_USE_QSORT,
    MPIR_PARAM_ID_DEBUG_HOLD,
    MPIR_PARAM_ID_PROCTABLE_SIZE,
    MPIR_PARAM_ID_PROCTABLE_PRINT,
    MPIR_PARAM_ID_ENABLE_COLL_FT_RET,
    MPIR_PARAM_ID_ABORT_ON_LEAKED_HANDLES,
    MPIR_PARAM_ID_CTXID_EAGER_SIZE,
    MPIR_PARAM_ID_ASYNC_PROGRESS,
    MPIR_PARAM_ID_DEFAULT_THREAD_LEVEL,
    MPIR_PARAM_ID_MEMDUMP,
    MPIR_PARAM_ID_ERROR_CHECKING,
    MPIR_PARAM_ID_PRINT_ERROR_STACK,
    MPIR_PARAM_ID_CHOP_ERROR_STACK,
    MPIR_PARAM_ID_CH3_RMA_ACC_IMMED,
    MPIR_PARAM_ID_CH3_RMA_NREQUEST_THRESHOLD,
    MPIR_PARAM_ID_CH3_RMA_NREQUEST_NEW_THRESHOLD,
    MPIR_PARAM_ID_CH3_RMA_LOCK_IMMED,
    MPIR_PARAM_ID_CH3_RMA_MERGE_LOCK_OP_UNLOCK,
    MPIR_PARAM_ID_CH3_NOLOCAL,
    MPIR_PARAM_ID_CH3_ODD_EVEN_CLIQUES,
    MPIR_PARAM_ID_CH3_INTERFACE_HOSTNAME,
    MPIR_PARAM_ID_CH3_EAGER_MAX_MSG_SIZE,
    MPIR_PARAM_ID_CH3_PORT_RANGE,
    MPIR_PARAM_ID_NEMESIS_POLLS_BEFORE_YIELD,
    MPIR_PARAM_ID_NEMESIS_LMT_DMA_THRESHOLD,
    MPIR_PARAM_ID_NEMESIS_NETMOD,
    MPIR_PARAM_ID_NEMESIS_SHM_EAGER_MAX_SZ,
    MPIR_PARAM_ID_NEMESIS_SHM_READY_EAGER_MAX_SZ,
    MPIR_PARAM_ID_NEMESIS_ENABLE_CKPOINT,
    MPIR_PARAM_ID_NEMESIS_TCP_NETWORK_IFACE,
    MPIR_PARAM_ID_NEMESIS_TCP_HOST_LOOKUP_RETRIES,
    MPIR_PARAM_ID_NEMESIS_PORTALS_COMM_OVERRIDES,
    MPIR_PARAM_ID_NAMESERV_FILE_PUBDIR,
    MPIR_PARAM_NUM_PARAMS
};

/* initializes parameter values from the environment */
int MPIR_Param_init_params(void);

int MPIR_Param_finalize(void);

enum MPIR_Param_type_t {
    MPIR_PARAM_TYPE_INVALID = 0,
    MPIR_PARAM_TYPE_INT,
    MPIR_PARAM_TYPE_DOUBLE,
    MPIR_PARAM_TYPE_BOOLEAN,
    MPIR_PARAM_TYPE_STRING,
    MPIR_PARAM_TYPE_RANGE
};

typedef struct MPIR_Param_param_range_val {
    int low;
    int high;
} MPIR_Param_param_range_val_t;

/* used to represent default values */
struct MPIR_Param_param_default_val_t {
    const enum MPIR_Param_type_t type;

    /* not a union b/c of initialization portability issues */
    const int i_val; /* also used for booleans */
    const double d_val;
    const char *s_val;
    const MPIR_Param_param_range_val_t r_val;
};

struct MPIR_Param_t {
    const enum MPIR_Param_id_t id;
    const char *name;
    const char *description;
    const struct MPIR_Param_param_default_val_t default_val;
    void *val_p; /* ptr to the actual value */
};

/* array of parameter info for runtime usage */
extern struct MPIR_Param_t MPIR_Param_params[MPIR_PARAM_NUM_PARAMS];

/* extern declarations for each parameter
 * (definitions in src/util/param/param_vals.c) */
extern int MPIR_PARAM_ALLTOALL_SHORT_MSG_SIZE;
extern int MPIR_PARAM_ALLTOALL_MEDIUM_MSG_SIZE;
extern int MPIR_PARAM_ALLTOALL_THROTTLE;
extern int MPIR_PARAM_REDSCAT_COMMUTATIVE_LONG_MSG_SIZE;
extern int MPIR_PARAM_BCAST_MIN_PROCS;
extern int MPIR_PARAM_BCAST_SHORT_MSG_SIZE;
extern int MPIR_PARAM_BCAST_LONG_MSG_SIZE;
extern int MPIR_PARAM_ALLGATHER_SHORT_MSG_SIZE;
extern int MPIR_PARAM_ALLGATHER_LONG_MSG_SIZE;
extern int MPIR_PARAM_REDUCE_SHORT_MSG_SIZE;
extern int MPIR_PARAM_ALLREDUCE_SHORT_MSG_SIZE;
extern int MPIR_PARAM_GATHER_VSMALL_MSG_SIZE;
extern int MPIR_PARAM_GATHER_INTER_SHORT_MSG_SIZE;
extern int MPIR_PARAM_GATHERV_INTER_SSEND_MIN_PROCS;
extern int MPIR_PARAM_SCATTER_INTER_SHORT_MSG_SIZE;
extern int MPIR_PARAM_ALLGATHERV_PIPELINE_MSG_SIZE;
extern int MPIR_PARAM_ENABLE_SMP_COLLECTIVES;
extern int MPIR_PARAM_ENABLE_SMP_BARRIER;
extern int MPIR_PARAM_ENABLE_SMP_BCAST;
extern int MPIR_PARAM_MAX_SMP_BCAST_MSG_SIZE;
extern int MPIR_PARAM_ENABLE_SMP_REDUCE;
extern int MPIR_PARAM_MAX_SMP_REDUCE_MSG_SIZE;
extern int MPIR_PARAM_ENABLE_SMP_ALLREDUCE;
extern int MPIR_PARAM_MAX_SMP_ALLREDUCE_MSG_SIZE;
extern int MPIR_PARAM_COMM_SPLIT_USE_QSORT;
extern int MPIR_PARAM_DEBUG_HOLD;
extern int MPIR_PARAM_PROCTABLE_SIZE;
extern int MPIR_PARAM_PROCTABLE_PRINT;
extern int MPIR_PARAM_ENABLE_COLL_FT_RET;
extern int MPIR_PARAM_ABORT_ON_LEAKED_HANDLES;
extern int MPIR_PARAM_CTXID_EAGER_SIZE;
extern int MPIR_PARAM_ASYNC_PROGRESS;
extern char * MPIR_PARAM_DEFAULT_THREAD_LEVEL;
extern int MPIR_PARAM_MEMDUMP;
extern int MPIR_PARAM_ERROR_CHECKING;
extern int MPIR_PARAM_PRINT_ERROR_STACK;
extern int MPIR_PARAM_CHOP_ERROR_STACK;
extern int MPIR_PARAM_CH3_RMA_ACC_IMMED;
extern int MPIR_PARAM_CH3_RMA_NREQUEST_THRESHOLD;
extern int MPIR_PARAM_CH3_RMA_NREQUEST_NEW_THRESHOLD;
extern int MPIR_PARAM_CH3_RMA_LOCK_IMMED;
extern int MPIR_PARAM_CH3_RMA_MERGE_LOCK_OP_UNLOCK;
extern int MPIR_PARAM_CH3_NOLOCAL;
extern int MPIR_PARAM_CH3_ODD_EVEN_CLIQUES;
extern char * MPIR_PARAM_CH3_INTERFACE_HOSTNAME;
extern int MPIR_PARAM_CH3_EAGER_MAX_MSG_SIZE;
extern MPIR_Param_param_range_val_t MPIR_PARAM_CH3_PORT_RANGE;
extern int MPIR_PARAM_NEMESIS_POLLS_BEFORE_YIELD;
extern int MPIR_PARAM_NEMESIS_LMT_DMA_THRESHOLD;
extern char * MPIR_PARAM_NEMESIS_NETMOD;
extern int MPIR_PARAM_NEMESIS_SHM_EAGER_MAX_SZ;
extern int MPIR_PARAM_NEMESIS_SHM_READY_EAGER_MAX_SZ;
extern int MPIR_PARAM_NEMESIS_ENABLE_CKPOINT;
extern char * MPIR_PARAM_NEMESIS_TCP_NETWORK_IFACE;
extern int MPIR_PARAM_NEMESIS_TCP_HOST_LOOKUP_RETRIES;
extern int MPIR_PARAM_NEMESIS_PORTALS_COMM_OVERRIDES;
extern char * MPIR_PARAM_NAMESERV_FILE_PUBDIR;

/* TODO: this should be defined elsewhere */
#define MPIR_Param_assert MPIU_Assert

/* arbitrary, simplifies interaction with external interfaces like MPI_T_ */
#define MPIR_PARAM_MAX_STRLEN (4096)

/* helper macros for safely getting the default value of a parameter */
#define MPIR_PARAM_GET_DEFAULT_INT(p_suffix_,out_ptr_)                                               \
    do {                                                                                               \
        MPIR_Param_assert(MPIR_PARAM_TYPE_INT == MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.type); \
        *(out_ptr_) = MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.i_val;                      \
    } while (0)
#define MPIR_PARAM_GET_DEFAULT_DOUBLE(p_suffix_,out_ptr_)                                               \
    do {                                                                                               \
        MPIR_Param_assert(MPIR_PARAM_TYPE_DOUBLE == MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.type); \
        *(out_ptr_) = MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.d_val;                      \
    } while (0)
#define MPIR_PARAM_GET_DEFAULT_BOOLEAN(p_suffix_,out_ptr_)                                               \
    do {                                                                                               \
        MPIR_Param_assert(MPIR_PARAM_TYPE_BOOLEAN == MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.type); \
        *(out_ptr_) = MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.i_val;                      \
    } while (0)
#define MPIR_PARAM_GET_DEFAULT_STRING(p_suffix_,out_ptr_)                                               \
    do {                                                                                               \
        MPIR_Param_assert(MPIR_PARAM_TYPE_STRING == MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.type); \
        *(out_ptr_) = MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.s_val;                      \
    } while (0)
#define MPIR_PARAM_GET_DEFAULT_RANGE(p_suffix_,out_ptr_)                                               \
    do {                                                                                               \
        MPIR_Param_assert(MPIR_PARAM_TYPE_RANGE == MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.type); \
        *(out_ptr_) = MPIR_Param_params[MPIR_PARAM_ID_##p_suffix_].default_val.r_val;                      \
    } while (0)

#endif /* MPICH_PARAM_VALS_H_INCLUDED */
