// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2017 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `General_Category=Symbol`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v10.0.0
  Emoji v5.0 (UTR51)
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x000024,
    0x00002B,
    0x00005E,
    0x000060,
    0x00007C,
    0x00007E,
    0x0000AC,
    0x0000B4,
    0x0000B8,
    0x0000D7,
    0x0000F7,
    0x0002ED,
    0x000375,
    0x0003F6,
    0x000482,
    0x00060B,
    0x0006DE,
    0x0006E9,
    0x0007F6,
    0x000AF1,
    0x000B70,
    0x000C7F,
    0x000D4F,
    0x000D79,
    0x000E3F,
    0x000F13,
    0x000F34,
    0x000F36,
    0x000F38,
    0x0017DB,
    0x001940,
    0x001FBD,
    0x002044,
    0x002052,
    0x002114,
    0x002125,
    0x002127,
    0x002129,
    0x00212E,
    0x00214F,
    0x003004,
    0x003020,
    0x003250,
    0x00AB5B,
    0x00FB29,
    0x00FE62,
    0x00FE69,
    0x00FF04,
    0x00FF0B,
    0x00FF3E,
    0x00FF40,
    0x00FF5C,
    0x00FF5E,
    0x0101A0,
    0x010AC8,
    0x01173F,
    0x016B45,
    0x01BC9C,
    0x01D245,
    0x01D6C1,
    0x01D6DB,
    0x01D6FB,
    0x01D715,
    0x01D735,
    0x01D74F,
    0x01D76F,
    0x01D789,
    0x01D7A9,
    0x01D7C3,
    0x01F9C0
  ],
  ranges: [
    [0x00003C, 0x00003E],
    [0x0000A2, 0x0000A6],
    [0x0000A8, 0x0000A9],
    [0x0000AE, 0x0000B1],
    [0x0002C2, 0x0002C5],
    [0x0002D2, 0x0002DF],
    [0x0002E5, 0x0002EB],
    [0x0002EF, 0x0002FF],
    [0x000384, 0x000385],
    [0x00058D, 0x00058F],
    [0x000606, 0x000608],
    [0x00060E, 0x00060F],
    [0x0006FD, 0x0006FE],
    [0x0009F2, 0x0009F3],
    [0x0009FA, 0x0009FB],
    [0x000BF3, 0x000BFA],
    [0x000F01, 0x000F03],
    [0x000F15, 0x000F17],
    [0x000F1A, 0x000F1F],
    [0x000FBE, 0x000FC5],
    [0x000FC7, 0x000FCC],
    [0x000FCE, 0x000FCF],
    [0x000FD5, 0x000FD8],
    [0x00109E, 0x00109F],
    [0x001390, 0x001399],
    [0x0019DE, 0x0019FF],
    [0x001B61, 0x001B6A],
    [0x001B74, 0x001B7C],
    [0x001FBF, 0x001FC1],
    [0x001FCD, 0x001FCF],
    [0x001FDD, 0x001FDF],
    [0x001FED, 0x001FEF],
    [0x001FFD, 0x001FFE],
    [0x00207A, 0x00207C],
    [0x00208A, 0x00208C],
    [0x0020A0, 0x0020BF],
    [0x002100, 0x002101],
    [0x002103, 0x002106],
    [0x002108, 0x002109],
    [0x002116, 0x002118],
    [0x00211E, 0x002123],
    [0x00213A, 0x00213B],
    [0x002140, 0x002144],
    [0x00214A, 0x00214D],
    [0x00218A, 0x00218B],
    [0x002190, 0x002307],
    [0x00230C, 0x002328],
    [0x00232B, 0x002426],
    [0x002440, 0x00244A],
    [0x00249C, 0x0024E9],
    [0x002500, 0x002767],
    [0x002794, 0x0027C4],
    [0x0027C7, 0x0027E5],
    [0x0027F0, 0x002982],
    [0x002999, 0x0029D7],
    [0x0029DC, 0x0029FB],
    [0x0029FE, 0x002B73],
    [0x002B76, 0x002B95],
    [0x002B98, 0x002BB9],
    [0x002BBD, 0x002BC8],
    [0x002BCA, 0x002BD2],
    [0x002BEC, 0x002BEF],
    [0x002CE5, 0x002CEA],
    [0x002E80, 0x002E99],
    [0x002E9B, 0x002EF3],
    [0x002F00, 0x002FD5],
    [0x002FF0, 0x002FFB],
    [0x003012, 0x003013],
    [0x003036, 0x003037],
    [0x00303E, 0x00303F],
    [0x00309B, 0x00309C],
    [0x003190, 0x003191],
    [0x003196, 0x00319F],
    [0x0031C0, 0x0031E3],
    [0x003200, 0x00321E],
    [0x00322A, 0x003247],
    [0x003260, 0x00327F],
    [0x00328A, 0x0032B0],
    [0x0032C0, 0x0032FE],
    [0x003300, 0x0033FF],
    [0x004DC0, 0x004DFF],
    [0x00A490, 0x00A4C6],
    [0x00A700, 0x00A716],
    [0x00A720, 0x00A721],
    [0x00A789, 0x00A78A],
    [0x00A828, 0x00A82B],
    [0x00A836, 0x00A839],
    [0x00AA77, 0x00AA79],
    [0x00FBB2, 0x00FBC1],
    [0x00FDFC, 0x00FDFD],
    [0x00FE64, 0x00FE66],
    [0x00FF1C, 0x00FF1E],
    [0x00FFE0, 0x00FFE6],
    [0x00FFE8, 0x00FFEE],
    [0x00FFFC, 0x00FFFD],
    [0x010137, 0x01013F],
    [0x010179, 0x010189],
    [0x01018C, 0x01018E],
    [0x010190, 0x01019B],
    [0x0101D0, 0x0101FC],
    [0x010877, 0x010878],
    [0x016B3C, 0x016B3F],
    [0x01D000, 0x01D0F5],
    [0x01D100, 0x01D126],
    [0x01D129, 0x01D164],
    [0x01D16A, 0x01D16C],
    [0x01D183, 0x01D184],
    [0x01D18C, 0x01D1A9],
    [0x01D1AE, 0x01D1E8],
    [0x01D200, 0x01D241],
    [0x01D300, 0x01D356],
    [0x01D800, 0x01D9FF],
    [0x01DA37, 0x01DA3A],
    [0x01DA6D, 0x01DA74],
    [0x01DA76, 0x01DA83],
    [0x01DA85, 0x01DA86],
    [0x01EEF0, 0x01EEF1],
    [0x01F000, 0x01F02B],
    [0x01F030, 0x01F093],
    [0x01F0A0, 0x01F0AE],
    [0x01F0B1, 0x01F0BF],
    [0x01F0C1, 0x01F0CF],
    [0x01F0D1, 0x01F0F5],
    [0x01F110, 0x01F12E],
    [0x01F130, 0x01F16B],
    [0x01F170, 0x01F1AC],
    [0x01F1E6, 0x01F202],
    [0x01F210, 0x01F23B],
    [0x01F240, 0x01F248],
    [0x01F250, 0x01F251],
    [0x01F260, 0x01F265],
    [0x01F300, 0x01F6D4],
    [0x01F6E0, 0x01F6EC],
    [0x01F6F0, 0x01F6F8],
    [0x01F700, 0x01F773],
    [0x01F780, 0x01F7D4],
    [0x01F800, 0x01F80B],
    [0x01F810, 0x01F847],
    [0x01F850, 0x01F859],
    [0x01F860, 0x01F887],
    [0x01F890, 0x01F8AD],
    [0x01F900, 0x01F90B],
    [0x01F910, 0x01F93E],
    [0x01F940, 0x01F94C],
    [0x01F950, 0x01F96B],
    [0x01F980, 0x01F997],
    [0x01F9D0, 0x01F9E6]
  ]
});
testPropertyEscapes(
  /^\p{General_Category=Symbol}+$/u,
  matchSymbols,
  "\\p{General_Category=Symbol}"
);
testPropertyEscapes(
  /^\p{General_Category=S}+$/u,
  matchSymbols,
  "\\p{General_Category=S}"
);
testPropertyEscapes(
  /^\p{gc=Symbol}+$/u,
  matchSymbols,
  "\\p{gc=Symbol}"
);
testPropertyEscapes(
  /^\p{gc=S}+$/u,
  matchSymbols,
  "\\p{gc=S}"
);
testPropertyEscapes(
  /^\p{Symbol}+$/u,
  matchSymbols,
  "\\p{Symbol}"
);
testPropertyEscapes(
  /^\p{S}+$/u,
  matchSymbols,
  "\\p{S}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x00005F,
    0x00007D,
    0x0000A7,
    0x0000AD,
    0x0002EC,
    0x0002EE,
    0x000F14,
    0x000F35,
    0x000F37,
    0x000FC6,
    0x000FCD,
    0x001FBE,
    0x002102,
    0x002107,
    0x002115,
    0x002124,
    0x002126,
    0x002128,
    0x00214E,
    0x002BC9,
    0x002E9A,
    0x0032FF,
    0x00FE63,
    0x00FF3F,
    0x00FF5D,
    0x00FFE7,
    0x01018F,
    0x01DA75,
    0x01DA84,
    0x01F0C0,
    0x01F0D0,
    0x01F12F,
    0x01F93F
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000023],
    [0x000025, 0x00002A],
    [0x00002C, 0x00003B],
    [0x00003F, 0x00005D],
    [0x000061, 0x00007B],
    [0x00007F, 0x0000A1],
    [0x0000AA, 0x0000AB],
    [0x0000B2, 0x0000B3],
    [0x0000B5, 0x0000B7],
    [0x0000B9, 0x0000D6],
    [0x0000D8, 0x0000F6],
    [0x0000F8, 0x0002C1],
    [0x0002C6, 0x0002D1],
    [0x0002E0, 0x0002E4],
    [0x000300, 0x000374],
    [0x000376, 0x000383],
    [0x000386, 0x0003F5],
    [0x0003F7, 0x000481],
    [0x000483, 0x00058C],
    [0x000590, 0x000605],
    [0x000609, 0x00060A],
    [0x00060C, 0x00060D],
    [0x000610, 0x0006DD],
    [0x0006DF, 0x0006E8],
    [0x0006EA, 0x0006FC],
    [0x0006FF, 0x0007F5],
    [0x0007F7, 0x0009F1],
    [0x0009F4, 0x0009F9],
    [0x0009FC, 0x000AF0],
    [0x000AF2, 0x000B6F],
    [0x000B71, 0x000BF2],
    [0x000BFB, 0x000C7E],
    [0x000C80, 0x000D4E],
    [0x000D50, 0x000D78],
    [0x000D7A, 0x000E3E],
    [0x000E40, 0x000F00],
    [0x000F04, 0x000F12],
    [0x000F18, 0x000F19],
    [0x000F20, 0x000F33],
    [0x000F39, 0x000FBD],
    [0x000FD0, 0x000FD4],
    [0x000FD9, 0x00109D],
    [0x0010A0, 0x00138F],
    [0x00139A, 0x0017DA],
    [0x0017DC, 0x00193F],
    [0x001941, 0x0019DD],
    [0x001A00, 0x001B60],
    [0x001B6B, 0x001B73],
    [0x001B7D, 0x001FBC],
    [0x001FC2, 0x001FCC],
    [0x001FD0, 0x001FDC],
    [0x001FE0, 0x001FEC],
    [0x001FF0, 0x001FFC],
    [0x001FFF, 0x002043],
    [0x002045, 0x002051],
    [0x002053, 0x002079],
    [0x00207D, 0x002089],
    [0x00208D, 0x00209F],
    [0x0020C0, 0x0020FF],
    [0x00210A, 0x002113],
    [0x002119, 0x00211D],
    [0x00212A, 0x00212D],
    [0x00212F, 0x002139],
    [0x00213C, 0x00213F],
    [0x002145, 0x002149],
    [0x002150, 0x002189],
    [0x00218C, 0x00218F],
    [0x002308, 0x00230B],
    [0x002329, 0x00232A],
    [0x002427, 0x00243F],
    [0x00244B, 0x00249B],
    [0x0024EA, 0x0024FF],
    [0x002768, 0x002793],
    [0x0027C5, 0x0027C6],
    [0x0027E6, 0x0027EF],
    [0x002983, 0x002998],
    [0x0029D8, 0x0029DB],
    [0x0029FC, 0x0029FD],
    [0x002B74, 0x002B75],
    [0x002B96, 0x002B97],
    [0x002BBA, 0x002BBC],
    [0x002BD3, 0x002BEB],
    [0x002BF0, 0x002CE4],
    [0x002CEB, 0x002E7F],
    [0x002EF4, 0x002EFF],
    [0x002FD6, 0x002FEF],
    [0x002FFC, 0x003003],
    [0x003005, 0x003011],
    [0x003014, 0x00301F],
    [0x003021, 0x003035],
    [0x003038, 0x00303D],
    [0x003040, 0x00309A],
    [0x00309D, 0x00318F],
    [0x003192, 0x003195],
    [0x0031A0, 0x0031BF],
    [0x0031E4, 0x0031FF],
    [0x00321F, 0x003229],
    [0x003248, 0x00324F],
    [0x003251, 0x00325F],
    [0x003280, 0x003289],
    [0x0032B1, 0x0032BF],
    [0x003400, 0x004DBF],
    [0x004E00, 0x00A48F],
    [0x00A4C7, 0x00A6FF],
    [0x00A717, 0x00A71F],
    [0x00A722, 0x00A788],
    [0x00A78B, 0x00A827],
    [0x00A82C, 0x00A835],
    [0x00A83A, 0x00AA76],
    [0x00AA7A, 0x00AB5A],
    [0x00AB5C, 0x00DBFF],
    [0x00E000, 0x00FB28],
    [0x00FB2A, 0x00FBB1],
    [0x00FBC2, 0x00FDFB],
    [0x00FDFE, 0x00FE61],
    [0x00FE67, 0x00FE68],
    [0x00FE6A, 0x00FF03],
    [0x00FF05, 0x00FF0A],
    [0x00FF0C, 0x00FF1B],
    [0x00FF1F, 0x00FF3D],
    [0x00FF41, 0x00FF5B],
    [0x00FF5F, 0x00FFDF],
    [0x00FFEF, 0x00FFFB],
    [0x00FFFE, 0x010136],
    [0x010140, 0x010178],
    [0x01018A, 0x01018B],
    [0x01019C, 0x01019F],
    [0x0101A1, 0x0101CF],
    [0x0101FD, 0x010876],
    [0x010879, 0x010AC7],
    [0x010AC9, 0x01173E],
    [0x011740, 0x016B3B],
    [0x016B40, 0x016B44],
    [0x016B46, 0x01BC9B],
    [0x01BC9D, 0x01CFFF],
    [0x01D0F6, 0x01D0FF],
    [0x01D127, 0x01D128],
    [0x01D165, 0x01D169],
    [0x01D16D, 0x01D182],
    [0x01D185, 0x01D18B],
    [0x01D1AA, 0x01D1AD],
    [0x01D1E9, 0x01D1FF],
    [0x01D242, 0x01D244],
    [0x01D246, 0x01D2FF],
    [0x01D357, 0x01D6C0],
    [0x01D6C2, 0x01D6DA],
    [0x01D6DC, 0x01D6FA],
    [0x01D6FC, 0x01D714],
    [0x01D716, 0x01D734],
    [0x01D736, 0x01D74E],
    [0x01D750, 0x01D76E],
    [0x01D770, 0x01D788],
    [0x01D78A, 0x01D7A8],
    [0x01D7AA, 0x01D7C2],
    [0x01D7C4, 0x01D7FF],
    [0x01DA00, 0x01DA36],
    [0x01DA3B, 0x01DA6C],
    [0x01DA87, 0x01EEEF],
    [0x01EEF2, 0x01EFFF],
    [0x01F02C, 0x01F02F],
    [0x01F094, 0x01F09F],
    [0x01F0AF, 0x01F0B0],
    [0x01F0F6, 0x01F10F],
    [0x01F16C, 0x01F16F],
    [0x01F1AD, 0x01F1E5],
    [0x01F203, 0x01F20F],
    [0x01F23C, 0x01F23F],
    [0x01F249, 0x01F24F],
    [0x01F252, 0x01F25F],
    [0x01F266, 0x01F2FF],
    [0x01F6D5, 0x01F6DF],
    [0x01F6ED, 0x01F6EF],
    [0x01F6F9, 0x01F6FF],
    [0x01F774, 0x01F77F],
    [0x01F7D5, 0x01F7FF],
    [0x01F80C, 0x01F80F],
    [0x01F848, 0x01F84F],
    [0x01F85A, 0x01F85F],
    [0x01F888, 0x01F88F],
    [0x01F8AE, 0x01F8FF],
    [0x01F90C, 0x01F90F],
    [0x01F94D, 0x01F94F],
    [0x01F96C, 0x01F97F],
    [0x01F998, 0x01F9BF],
    [0x01F9C1, 0x01F9CF],
    [0x01F9E7, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{General_Category=Symbol}+$/u,
  nonMatchSymbols,
  "\\P{General_Category=Symbol}"
);
testPropertyEscapes(
  /^\P{General_Category=S}+$/u,
  nonMatchSymbols,
  "\\P{General_Category=S}"
);
testPropertyEscapes(
  /^\P{gc=Symbol}+$/u,
  nonMatchSymbols,
  "\\P{gc=Symbol}"
);
testPropertyEscapes(
  /^\P{gc=S}+$/u,
  nonMatchSymbols,
  "\\P{gc=S}"
);
testPropertyEscapes(
  /^\P{Symbol}+$/u,
  nonMatchSymbols,
  "\\P{Symbol}"
);
testPropertyEscapes(
  /^\P{S}+$/u,
  nonMatchSymbols,
  "\\P{S}"
);

reportCompare(0, 0);
