# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: misc.tcl,v 1.14 2006/01/28 19:16:59 jfontain Exp $


package provide miscellaneous [lindex {$Revision: 1.14 $} 1]


proc minimum {a b} {return [expr {$a < $b? $a: $b}]}
proc maximum {a b} {return [expr {$a > $b? $a: $b}]}

proc ldelete {listName value} {
    upvar 1 $listName list

    set index [lsearch -exact $list $value]
    if {$index < 0} {
        error "\"$value\" is not in list"
    }
    set list [lreplace $list $index $index]
}

proc static {localName args} {
    set global [uplevel 1 namespace which -command [lindex [info level -1] 0]]:$localName
    uplevel 1 upvar #0 $global $localName
    if {![info exists $global]} {
        switch [llength $args] {
            0 return                                                                                  ;# no initialization requested
            1 {set $global [lindex $args 0]}
            default {error {usage: static name ?value?}}
        }
    }                                                                                                    ;# else already initialized
}

proc formattedTime {seconds} {
    set string {}
    set interval [expr {$seconds / 86400}]                                                                                   ;# days
    if {$interval > 0} {
        append string ${interval}d
        set seconds [expr {$seconds % 86400}]
    }
    set interval [expr {$seconds / 3600}]                                                                                   ;# hours
    if {$interval > 0} {
        append string ${interval}h
        set seconds [expr {$seconds % 3600}]
    }
    set interval [expr {$seconds / 60}]                                                                                   ;# minutes
    if {$interval > 0} {
        append string ${interval}m
        set seconds [expr {$seconds % 60}]
    }
    append string ${seconds}s
    return $string
}
