Name: moomps
Version: 5.8
Release: 1%{?dist}
Summary: Powerful modular monitoring service
Group: Applications/System
License: GPL
Source0: http://download.sourceforge.net/moodss/moomps-5.8.tar.bz2
URL: http://moodss.sourceforge.net/
BuildRoot: %_tmppath/%name-%version-%release-root-%(%__id_u -n)
BuildRequires: tcl >= 8.4.7
Requires(pre): fedora-usermgmt >= 0.8
Requires(preun): /sbin/chkconfig, /sbin/service
Requires(post): /sbin/chkconfig
Requires(postun): /sbin/service
Requires: moodss >= 21.2, tclx >= 8.3

%description
moomps (Modular Object Oriented Multi-Purpose Service) is a modular
monitoring daemon used along with the moodss GUI package also
included in the distribution. It can send alert emails or execute
scripts when predefined thresholds are crossed, and archive data
history over time in a database (MySQL or ODBC). Uses dashboard
files created by moodss in order to load any number of modules.
Distributed monitoring is also possible with data exchange between
moomps and moodss application instances.

%prep
%setup -q

%build
make LIBDIR=%_libdir TCLLIBDIR=%_libdir

%install
rm -rf $RPM_BUILD_ROOT
make ROOTDIR=$RPM_BUILD_ROOT LIBDIR=%_libdir TCLLIBDIR=%_libdir install

%pre
# if not present, add moomps user (even when upgrading):
if ! %_sbindir/usermod -l moomps moomps 2>/dev/null; then
    %_sbindir/fedora-useradd 23 -r -d /srv/moomps\
        -c 'service companion to moodss' -s '/sbin/nologin' moomps
fi

%preun
if [ $1 -eq 0 ]; then                                             # uninstalling
    chkconfig --del moomps
    # ignore error when daemon is not running:
    service moomps stop >/dev/null || :
fi

%post
# fix moodss modules path (useful on x86_64 architecture):
sed\
    -e 's,lappend auto_path /usr/lib/moodss,lappend auto_path %_libdir/moodss,'\
    -i %_sbindir/moomps
if [ $1 -eq 1 ]; then                                               # installing
    chkconfig --add moomps
fi

%postun
if [ $1 -ne 0 ]; then                                                # upgrading
    service moomps try-restart >/dev/null || :
fi

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc documentation/COPYRIGHT documentation/moomps*.htm
%_mandir/man1/moomps.*
%_sbindir/moomps
%_initrddir/moomps
%dir %attr(0755,moomps,root) %_sysconfdir/moomps
/srv/moomps
%dir %attr(0755,moomps,root) /srv/moomps
# secure rc file as it may contain a database password:
%config(noreplace) %attr(0600,moomps,root) %_sysconfdir/moomps/rc


%changelog
* Sun Nov 12 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.8-1
- 5.8 upstream release
- pass library directories to make also at install stage

* Tue Nov 7 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.7-3
- made package architecture dependant since for example Tcl
  packages are under /usr/lib on i386 and /usr/lib64 on x86_64

* Sat Nov 4 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.7-2
- properly support 64 bit architecture by passing library
  directories to make

* Sat Oct 1 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.7-1
- 5.7 upstream release

* Fri Sep 8 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.6-2
- rebuild for Fedora Extras 6

* Sat Mar 18 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.6-1
- 5.6 upstream release

* Mon Mar 6 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.5-1
- 5.5 upstream release
- in post installation stage, fix moodss modules path
- use fedora-useradd instead of useradd

* Wed Feb 15 2006 Jean-Luc Fontaine <jfontain@free.fr> 5.4-2
- rebuild for Fedora Extras 5

* Fri Nov 11 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.4-1
- 5.4 upstream release

* Fri Aug 19 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.3-1
- 5.3 upstream release

* Sat Jul 30 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.2-2
- increased release number to match FC-3 release

* Sun Jun 26 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.2-1
- 5.2 source release

* Tue Jun 7 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.1-6
- at build time, only require tcl 8.4.7

* Tue Jun 7 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.1-4
- used sourceforge link for source

* Sun Jun 5 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.1-2
- in pre installation script, create a system account with a better comment

* Sun May 22 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.1-1
- 5.1 source release

* Sat May 21 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.0-5
- made /srv/moomps the home directory instead of /etc/moomps

* Fri May 20 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.0-4
- in files, added dashboard (data) directory in /srv hierarchy

* Sun May 15 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.0-3
- moved files section right before change log
- in post uninstallation, no longer delete moomps user and PID files,
  blocked standard output and use try-restart command instead of
  condrestart in service command
- added requirements for pre and post scriptlets
- removed erroneous comment about home directory non existence for
  moomps user
- in build stage, used SMP flags with make
- removed manual page redundant marking as documentation
- in pre-uninstallation, removed echoed help message and blocked
  standard output
- made rc file belong to root group
- made initialization script LSB compliant, closer in style to
  template from fedora rpm tools package and properly manage PID file
- in scriptlets, use more appropriate integer comparisons for numbers

* Sun May 15 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.0-2
- require Tcl 8.4.8 with bug fixes for 64 bit architecture
- appended distribution to release
- removed all epochs as they are out of style as of FC-4
- require recent tclx

* Sun May 1 2005 Jean-Luc Fontaine <jfontain@free.fr> 5.0-1
- 5.0 source release
- initialization script no longer tagged as configuration file
- use specific build requirements for fedora distribution
- improved description.

* Tue Feb 22 2005 Jean-Luc Fontaine <jfontain@free.fr> 4.6-0.fdr.1
- 4.5 release
- in statistics table, added standard deviation column

* Sun Jan 2 2005 Jean-Luc Fontaine <jfontain@free.fr> 4.5-0.fdr.1
- 4.5 version

* Fri Dec 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.4-0.fdr.1
- 4.4 release

* Sun Nov 14 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.3-0.fdr.1
- 4.3 release

* Sun Oct 31 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.2.2-0.fdr.1
- removed program variable in init moomps script as rpmlint reported
  incoherent-subsys error
- capitalized summary

* Sat Oct 30 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.2.1-0.fdr.1
- restored compatibility with Tcl 8.3 core

* Sat Oct 23 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.2-0.fdr.1
- 4.2 version
- updated summary and description

* Sun Oct 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.1-0.fdr.1
- 4.1 version

* Tue Aug 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 4.0-0.fdr.1
- 4.0 version

* Sun May 30 2004 Jean-Luc Fontaine <jfontain@free.fr> 3.2-0.fdr.1
- 3.2 version

* Sun Apr 25 2004 Jean-Luc Fontaine <jfontain@free.fr> 3.1-0.fdr.1
- 3.1 version

* Sun Mar 14 2004 Jean-Luc Fontaine <jfontain@free.fr> 3.0-0.fdr.1
- 3.0 version

* Thu Feb 12 2004 Jean-Luc Fontaine <jfontain@free.fr> 2.20-0.fdr.1
- 2.20 version

* Sun Feb 8 2004 Jean-Luc Fontaine <jfontain@free.fr> 2.19-0.fdr.1
- 2.19 version

* Sun Jan 11 2004 Jean-Luc Fontaine <jfontain@free.fr> 2.18-0.fdr.2
- in build requirements, work around tcl-devel and tk-devel packages non
  existence in RH 8.0 and 9

* Sun Jan 11 2004 Jean-Luc Fontaine <jfontain@free.fr> 2.18-0.fdr.1
- 2.18 version

* Sun Dec 28 2003 Jean-Luc Fontaine <jfontain@free.fr> 2.17-0.fdr.1
- 2.17 version

* Wed Dec 24 2003 Jean-Luc Fontaine <jfontain@free.fr> 2.16-0.fdr.1
- 2.16 version

* Sat Nov 22 2003 Jean-Luc Fontaine <jfontain@free.fr> 2.15-0.fdr.1
- 2.15 version

* Sat Nov 15 2003 Jean-Luc Fontaine <jfontain@free.fr> 2.14-0.fdr.2
- require moodss (needed for its modules)
- conditional restart of daemon when upgrading

* Tue Nov 11 2003 Jean-Luc Fontaine <jfontain@free.fr> 2.14-0.fdr.1
- moved here from moodss spec file
