#!/bin/bash
# copyright (C) 1997-2003 Jean-Luc Fontaine (mailto:jfontain@free.fr)
#
# moomps: This starts and stops moomps
#   (placed in /etc/rc.d/init.d/ on a Red Hat system).
#
# chkconfig: - 90 10
# description: moomps (Modular Object Oriented Multi-Purpose Service)\
#              uses moodss configuration (save) files to send email\
#              alerts, update the system log when thresholds occur and\
#              archive data in a SQL file based database or server.
#
# processname: $SBINDIR/moomps
# config: $MOOMPSRCFILE
# pidfile: $PIDFILE

PATH=/sbin:/bin:/usr/bin:/usr/sbin
. /etc/init.d/functions

[ -f $SBINDIR/moomps ] || exit 1
[ -d `dirname $MOOMPSRCFILE` ] || exit 1
[ -d $DATADIR/moomps ] || exit 1

return=0
lockfile=$LOCKFILE
pidfile=$PIDFILE


start(){
    echo -n $"Starting moomps: "
    touch $pidfile
    chown moomps $pidfile
    # load all configuration files from directory and use process ID file:
    daemon --user moomps $SBINDIR/moomps --pid-file $pidfile -r $MOOMPSRCFILE $DATADIR/moomps
    return=$?
    echo
    [ $return -eq 0 ] && touch $lockfile
    return $return
}

stop(){
    echo -n $"Stopping moomps: "
    killproc moomps
    return=$?
    echo
    [ $return -eq 0 ] && rm -f $pidfile $lockfile
    return $return
}

restart(){
    stop
    start
}


case "$1" in
    start|stop|restart)
        $1
        ;;
    reload|force-reload)
        restart
        ;;
    status)
        status moomps
        ;;
    condrestart|try-restart)
        [ ! -f $lockfile ] || restart
        ;;
    *)
        echo $"Usage: $0 {start|stop|status|restart|try-restart|reload|force-reload}"
        return=2
esac

exit $return
