# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: modpython.tcl,v 1.10 2006/01/28 19:16:59 jfontain Exp $


namespace eval module::python {                       ;# indentation removed in some places since Python is quite sensitive about it

variable utilityFunctions {

import string

def columnstring(dictionary, index):
    "return a Tcl array compatible initialization list for column data"
    pairs = ''
    for (key, value) in dictionary.items():
        # embedded quotes allowed in message but must be escaped:
        pairs = pairs + ' ' + str(index) + ',' + str(key) + ' "' + string.replace(str(value), '"', '\\"') + '"'
    return pairs

def liststring(list):
    "return a Tcl list from a python list (values must contain alphanumeric characters only)"
    string = ''
    for index in range(len(list)):
        string = string + ' ' + str(list[index])
    return string

def viewsstring(list):
    "return a Tcl array compatible initialization list for views data"
    pairs = ''
    for index in range(len(list)):
        pairs = pairs + ' {'
        for (key, value) in list[index].items():
            pairs = pairs + ' ' + str(key)
            if key == 'swap':                                                                                       # simple boolean
                pairs = pairs + ' ' + str(value)
            elif key == 'sort':
                for (column, direction) in value.items():
                    pairs = pairs + ' {' + str(column) + ' ' + str(direction) + '}'
                    break                                                                                    # keep first entry only
            else:                                                                                                     # indices list
                pairs = pairs + ' {' + liststring(value) + '}'
        pairs = pairs + '}'
    return pairs

def dictionarystring(dictionary):
    "return a Tcl array compatible initialization list from a python dictionary"
    "(keys and values must contain alphanumeric characters only)"
    pairs = ''
    for (key, value) in dictionary.items():
        pairs = pairs + ' ' + str(key) + ' ' + str(value)
    return pairs

def formstring(dictionary):
    "return a Tcl array compatible initialization list from module form dictionary"
    pairs = ''
    for (key, value) in dictionary.items():
        if key == 'columns':
            for index in range(len(value)):
                pairs = pairs + columnstring(value[index], index)
        elif re.match('^(indexColumns|indices|pollTimes)$', key):
            pairs = pairs + ' ' + key + ' {' + liststring(value) + '}'
        elif key == 'sort':
            for (column, direction) in value.items():
                pairs = pairs + ' sort {' + str(column) + ' ' + str(direction) + '}'
                break                                                                                        # keep first entry only
        elif key == 'switches':
            pairs = pairs + ' ' + key + ' {' + dictionarystring(value) + '}'
        elif key == 'views':
            pairs = pairs + ' ' + key + ' {' + viewsstring(value) + '}'
        else:
            # embedded quotes allowed in value but must be escaped:
            pairs = pairs + ' "' + str(key) + '" "' + string.replace(str(value), '"', '\\"') + '"'
    return pairs

def datastring(list):
    "return a Tcl array compatible initialization list from module data list of lists"
    pairs = ''
    if type(list) == type([]):                                                                                               # array
        rows = xrange(len(list))
    else:                                                                     # also support dictionaries (patch from Daniel Savard)
        rows = list.keys()
    for row in rows:
        # empty rows are handled properly since their length is zero:
        for column in range(len(list[row])):
            pairs = pairs + ' ' + str(row) + ',' + str(column) + ' "' + string.replace(str(list[row][column]), '"', '\\"') + '"'
    return pairs

}

}
