# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: highlght.tcl,v 1.4 2006/01/28 19:16:59 jfontain Exp $


class highlighter {

    proc highlighter {this {parentPath .}} {
        # for the highlighting frame, use 4 border frames to make it hollow, with toplevel objects to make sure paths are unique
        foreach side {left top right bottom} {
            set line [new toplevel $parentPath -background {} -highlightthickness 1 -highlightbackground black]
            wm withdraw $widget::($line,path)
            wm overrideredirect $widget::($line,path) 1
            set ($this,$side) $line
        }
    }

    proc ~highlighter {this} {
        foreach side {left top right bottom} {
            delete $($this,$side)
        }
    }

    proc show {this x y width height} {
        set path $widget::($($this,left),path)
        $path configure -width 1 -height $height
        wm geometry $path +$x+$y
        wm deiconify $path
        set path $widget::($($this,top),path)
        $path configure -width $width -height 1
        wm geometry $path +$x+$y
        wm deiconify $path
        set path $widget::($($this,right),path)
        $path configure -width 1 -height $height
        wm geometry $path +[expr {$x + $width}]+$y
        wm deiconify $path
        set path $widget::($($this,bottom),path)
        $path configure -width [expr {$width + 1}] -height 1          ;# extend width by 1 pixel to fill hole in bottom right corner
        wm geometry $path +$x+[expr {$y + $height}]
        wm deiconify $path
        update idletasks
    }

    proc hide {this} {
        foreach side {left top right bottom} {
            wm withdraw $widget::($($this,$side),path)
        }
    }

}
