# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: global.tcl,v 2.235 2006/11/12 16:53:25 jfontain Exp $


namespace eval global {                                                                     ;# gather miscellaneous global data here
    variable withGUI [expr {![catch {package present Tk}]}] ;# note: also used by source.tcl for pre-processing with scissors symbol
    variable debug 0
    variable 32BitIntegerMinimum -2147483648
    variable 32BitIntegerMaximum 2147483647
    variable 32BitUnsignedIntegerMaximum 4294967295
    variable 64BitIntegerMinimum -9223372036854775808
    variable 64BitIntegerMaximum 9223372036854775807
    variable 64BitUnsignedIntegerMaximum 18446744073709551615
if {$withGUI} { ;# >8
    variable applicationName moodss
    variable applicationVersion 21.5
    variable messenger                                                                                   ;# main window message area
    variable scroll                                                                ;# main window scroll composite widget identifier
    variable canvas                                                                                ;# main window canvas widget path
    variable static                                                                            ;# whether main window view is static
    variable windowManager                                                                             ;# main window window manager
    variable fileMenuContextHelper                                             ;# menu context help object for file menu in menu bar
    variable fileMenuContextHelperSaveIndex                                                        ;# save button index in the above
    variable fileDatabaseMenu                                                                                  ;# file database menu
    variable fileDatabaseMenuStartIndex                                                      ;# file database menu start entry index
    variable fileDatabaseStartButton                                                                                   ;# in toolbar
    variable fileDatabaseStartButtonTip
    variable saveFile                                                     ;# current configuration and layout current save file name
    variable xWindowManagerInitialOffset 30
    variable yWindowManagerInitialOffset 20
    variable graphNumberOfIntervals 100
    variable graphMinimumY {}                                           ;# minimum Y axis value: empty for auto scaling, 0 otherwise
    variable graphXAxisLabelsRotation 90
    variable graphLabelsPositions [list right bottom left top]
    variable graphLabelsPosition right
    variable graphPlotBackground black
    variable graphDisplayGrid 0                                                         ;# whether the plot grid lines are displayed
    variable viewerHeight 200
    variable viewerWidth 400
    variable canvasWidth 0; variable canvasHeight 0               ;# user fixed sizes otherwise canvas size is automatically managed
    variable canvasBackground white                                                                      ;# default background color
    variable canvasImage
    variable canvasImageFile {}
    variable canvasImagePosition nw                                                      ;# main (when no pages) image and placement
    variable canvasImageItem                          ;# the image item used for image above (does not exist if image file is empty)
    variable pieLabeler peripheral
    variable viewerColors {#7FFFFF #FFFF7F #FF7F7F #7FFF7F #7F7FFF #FFBF00 #BFBFBF #FF7FFF #FFFFFF}
    variable fileDirectory [pwd]                            ;# latest successfully selected directory for file dialog box operations
    variable readOnly                                       ;# whether moodss was started in read only mode (-r command line option)
    variable automaticallyShowTrace 1                      ;# whether the resident trace module window pops up on any module message
    variable showTrace 0                                                     ;# whether the resident trace module is being displayed
    variable traceGeometry                                                     ;# the resident trace module separate window geometry
    variable iconPadding 2
    variable printDialogCommand
    if {$::tcl_platform(platform) eq "unix"} {
        set printDialogCommand print::printOrSaveCanvas
    } else {                                               ;# windows (using Tkprint library): eventually wait till menu is unmapped
        set printDialogCommand {after idle PrintWindow $global::canvas -margins 0.5,0.5,0.5,0.5 -colordepth 8 -title moodss}
    }
    variable showToolBar 1                                                                      ;# whether the tool bar is displayed
    variable fileSaveHelpTip
    variable pagesWidth 65536                                          ;# set viewport every 64k pixels which allows up to 32k pages
    variable pagesTabPosition bottom                                                                                       ;# or top
    variable traceThresholds 1                                                   ;# whether thresholds are displayed in trace module
    button .temporary
    variable fontFamily [font actual [.temporary cget -font] -family]                             ;# application default font family
    variable fontSize [font actual [.temporary cget -font] -size]                                              ;# and size in points
    if {$fontSize < 12} {set fontSize 12}                 ;# make sure initial font is readable even on very high resolution screens
    destroy .temporary
    variable viewerMessageColor blue
    variable snapDistance; array set snapDistance {window 10 border 10}                                                 ;# in pixels
    variable currentValueTableRows 1000
    variable cellsLabelModuleHeader 1
    variable fileCloseImage
    # in thresholds and formulas test result text widget, trim separators by this amount so that no horizontal scrollbar shows
    variable separatorCut 6
    variable printToFile 0
    variable fileToPrintTo moodss.ps
    variable printCommand {lpr -P%P}
    variable printOrientations {landscape portrait}
    variable printOrientation portrait
    variable printPalettes {color gray monochrome}
    variable printPalette color
    variable printPaperSizes [list\
        {A3 (297 x 420 millimeters)} {A4 (210 x 297 millimeters)} {executive (7 1/2 x 10 inches)} {legal (8 1/2 x 14 inches)}\
        {letter (8 1/2 x 11 inches)}\
    ]
    variable printPaperSize [lindex $printPaperSizes end]                                                   ;# letter is the default
    variable realTimeHistory
    set realTimeHistory(maximumSamples) 15000                                         ;# about 1 megabytes (key: 64, value: 8 bytes)
    set realTimeHistory(cleanPeriod) 300                                                                               ;# in seconds
    variable showSampleDatasets 0                      ;# simulate presence in database of time series samples for predictor testing
    variable spinBoxRepeatMilliseconds 200
} else { ;# >8
    variable applicationName moomps
    variable applicationVersion 5.8
    variable formulasDialog                                                              ;# exists only when dialog box is displayed
} ;# >8
    variable pollTimes {}                                    ;# list of predefined poll times calculated according to loaded modules
    variable pollTime 0                                                                                    ;# current main poll time
    variable fromAddress $::tcl_platform(user)
    variable smtpServers 127.0.0.1
    variable mail
    set mail(subject,default) {%A threshold %l message}
    set mail(body,default) "%l: \"%s\" data value is now \"%v\",\nwhich triggered the \"%T\" threshold of \"%t\"."
    variable mailSubject $mail(subject,default)
    variable mailBody $mail(body,default)
    variable logMessage {"%s" = "%v" (triggered "%T" threshold "%t")}
    variable dataTypes {ascii clock dictionary integer real}                  ;# all the supported data types for tables and viewers
    variable numericDataTypes {integer real}                   ;# subset of the data types above suitable for numerical calculations
    variable traceNumberOfRows 20                                               ;# the preferred number of rows for the trace window
    # list of option, value, option, ... for database storage:
    variable databaseOptions [list -database {} -debuglevel 0 -dsn {} -file {} -host {} -password {} -port {} -user {}]
    variable database 0                                        ;# global and unique (only 1 is necessary) database connection object
    # ATTENTION: do not change single-spaced line below without updating replacement code in makefile
    variable moompsResourceFile /etc/moomps/rc                            ;# by default, can be changed in the preferences interface
    if {![file writable $moompsResourceFile]} {                                                                ;# reset if necessary
        set moompsResourceFile {}
    }
    # regular expression that matches a sensitive module option name that defines a password:
    variable passwordOptionExpression {^-.*passw(d|ord)$}                                               ;# passwd or password ending
    variable rPath {}                                                                               ;# user may not have R installed
    variable noRPath 0           ;# in standalone binary, R is included and set in environment path, so allow ignoring user settings
    variable predictorMaximumProcesses 1
}
