<?php
/**
 * convert ewiki format text to html format
 *
 * @param object $oldentry wiki entry object
 * @param object $oldpage wiki page object
 * @param object $oldwiki wiki instance object
 * @return string html format wiki content
 */
function wiki_ewiki_2_html($oldentry, $oldpage, $oldwiki) {
    global $CFG, $wiki_entry, $moodle_disable_camel_case, $ewiki_plugins, $ewiki_config, $moodle_format;

    $wiki_entry = $oldentry;

    $moodle_disable_camel_case = ($oldwiki->disablecamelcase == 1);

    // Block of dinamic ewiki defines
    wiki_set_define("EWIKI_NAME", $wiki_entry->pagename);
    wiki_set_define("EWIKI_DEFAULT_LANG", current_language());
    if ($moodle_disable_camel_case) {
        wiki_set_define("EWIKI_CHARS_L", "");
        wiki_set_define("EWIKI_CHARS_U", "");
    } else {
        wiki_set_define("EWIKI_CHARS_L", "a-z_µ¤$\337-\377");
        wiki_set_define("EWIKI_CHARS_U", "A-Z0-9\300-\336");
    }

    wiki_set_define("EWIKI_CHARS", wiki_get_define('EWIKI_CHARS_L') . wiki_get_define('EWIKI_CHARS_U'));

    require_once($CFG->dirroot . '/mod/wiki/db/migration/wiki/ewikimoodlelib.php');
    require_once($CFG->dirroot . '/mod/wiki/db/migration/wiki/ewiki/ewiki.php');

    if ($oldwiki->htmlmode == 0) {
        # No HTML
        $ewiki_config["htmlentities"] = array(); // HTML is managed by moodle
        $moodle_format = FORMAT_TEXT;
    }
    if ($oldwiki->htmlmode == 1) {
        # Safe HTML
        include_once($CFG->dirroot . "/mod/wiki/db/migration/wiki/ewiki/plugins/moodle/moodle_rescue_html.php");
        $moodle_format = FORMAT_HTML;
    }
    if ($oldwiki->htmlmode == 2) {
        # HTML Only
        $moodle_format = FORMAT_HTML;
        $ewiki_use_editor = 1;
        $ewiki_config["htmlentities"] = array(); // HTML is allowed
        $ewiki_config["wiki_link_regex"] = "\007 [!~]?(
                    \#?\[[^<>\[\]\n]+\] |
                    \^[-" .
            wiki_get_define('EWIKI_CHARS_U') . wiki_get_define('EWIKI_CHARS_L') . "]{3,} |
                    \b([\w]{3,}:)*([" .
            wiki_get_define('EWIKI_CHARS_U') . "]+[" . wiki_get_define('EWIKI_CHARS_L') . "]+){2,}\#?[\w\d]* |
                    \w[-_.+\w]+@(\w[-_\w]+[.])+\w{2,}   ) \007x";
    }

    $content = ewiki_format($oldpage->content);

    return $content;
}

function wiki_set_define($key, $value) {
    global $ewikidefines;

    $ewikidefines[$key] = $value;
}

function wiki_get_define($key) {
    global $ewikidefines;

    return $ewikidefines[$key];
}

function ewiki_mime_magic($binary_data) {
    $mime_magic_data = array(
        array(0, 2, 0, "\x06\x02", "application/x-alan-adventure-game"),
        array(0, 4, 0, "TADS", "application/x-tads-game"),
        array(0, 2, 0, "\x01\x10", "application/x-executable-file"),
        array(0, 2, 0, "\x01\x11", "application/x-executable-file"),
        array(0, 2, 0, "\x01", "application/x-executable-file"),
        array(0, 5, 0, "Core\001", "application/x-executable-file"),
        array(0, 22, 0, "AMANDA: TAPESTART DATE", "application/x-amanda-header"),
        array(0, 2, 0xfff0, 0xf0ff, "audio/mpeg"),
        array(4, 2, 0, "¯\x11", "video/fli"),
        array(4, 2, 0, "¯\x12", "video/flc"),
        array(0, 4, 0, "MOVI", "video/x-sgi-movie"),
        array(4, 4, 0, "moov", "video/quicktime"),
        array(4, 4, 0, "mdat", "video/quicktime"),
        array(0, 18, 0, "FiLeStArTfIlEsTaRt", "text/x-apple-binscii"),
        array(0, 3, 0, "\x0aGL", "application/data"),
        array(0, 2, 0, "\x76\xff", "application/data"),
        array(0, 6, 0, "NuFile", "application/data"),
        array(0, 6, 0, "N\xf5F\xe9l\xe5", "application/data"),
        array(0, 4, 0, "\x00\x16\x05\x00", "application/data"),
        array(0, 4, 0, "\x07\x16\x05\x00", "application/data"),
        array(257, 6, 0, "ustar\0", "application/x-tar"),
        array(257, 8, 0, "ustar\040\040\0", "application/x-gtar"),
        array(0, 2, 0, "qÇ", "application/x-cpio"),
        array(0, 2, 0, "Çq", "application/x-bcpio"),
        array(0, 6, 0, "070707", "application/x-cpio"),
        array(0, 6, 0, "070701", "application/x-cpio"),
        array(0, 6, 0, "070702", "application/x-cpio"),
        array(0, 2, 0, "ÿm", "application/data"),
        array(0, 2, 0, "ÿe", "application/data"),
        array(0, 5, 0, "=<ar>", "application/x-ar"),
        array(0, 19, 0, "!<arch>\n__________E", "application/x-ar"),
        array(0, 3, 0, "-h-", "application/data"),
        array(0, 7, 0, "!<arch>", "application/x-ar"),
        array(0, 4, 0, "<ar>", "application/x-ar"),
        array(0, 4, 0, ">ra<", "application/x-ar"),
        array(0, 4, 0, "!<ar", "application/x-ar"),
        array(0, 4, 0, "\x00\x03í", "application/data"),
        array(0, 4, 0, "\x00\x03î", "application/data"),
        array(0, 4, 0x8080ffff, 0x81a, "application/x-arc"),
        array(0, 4, 0x8080ffff, 0x91a, "application/x-arc"),
        array(0, 4, 0x8080ffff, 0x21a, "application/x-arc"),
        array(0, 4, 0x8080ffff, 0x31a, "application/x-arc"),
        array(0, 4, 0x8080ffff, 0x41a, "application/x-arc"),
        array(0, 4, 0x8080ffff, 0x61a, "application/x-arc"),
        array(0, 8, 0, "\032archive", "application/data"),
        array(0, 2, 0, "ê`", "application/x-arj"),
        array(0, 4, 0, "HPAK", "application/data"),
        array(0, 8, 0, "\351,\001JAM\   ", "application/data"),
        array(2, 5, 0, "-lh0-", "application/x-lha"),
        array(2, 5, 0, "-lh1-", "application/x-lha"),
        array(2, 5, 0, "-lz4-", "application/x-lha"),
        array(2, 5, 0, "-lz5-", "application/x-lha"),
        array(2, 5, 0, "-lzs-", "application/x-lha"),
        array(2, 5, 0, "-lh\40-", "application/x-lha"),
        array(2, 5, 0, "-lhd-", "application/x-lha"),
        array(2, 5, 0, "-lh2-", "application/x-lha"),
        array(2, 5, 0, "-lh3-", "application/x-lha"),
        array(2, 5, 0, "-lh4-", "application/x-lha"),
        array(2, 5, 0, "-lh5-", "application/x-lha"),
        array(0, 4, 0, "Rar!", "application/x-rar"),
        array(0, 4, 0, "SQSH", "application/data"),
        array(0, 4, 0, "UC2\x1a", "application/data"),
        array(0, 4, 0, "PK\003\004", "application/zip"),
        array(20, 4, 0, "ýÄ§Ü", "application/x-zoo"),
        array(10, 25, 0, "# This is a shell archive", "application/x-shar"),
        array(0, 4, 0, "*STA", "application/data"),
        array(0, 4, 0, "2278", "application/data"),
        array(0, 2, 0, "p\x01", "application/x-executable-file"),
        array(0, 2, 0, "q\x01", "application/x-executable-file"),
        array(0, 5, 0, "\000\004\036\212\200", "application/core"),
        array(0, 4, 0, ".snd", "audio/basic"),
        array(0, 4, 0, "\x00ds.", "audio/basic"),
        array(0, 4, 0, "MThd", "audio/midi"),
        array(0, 4, 0, "CTMF", "audio/x-cmf"),
        array(0, 3, 0, "SBI", "audio/x-sbi"),
        array(0, 19, 0, "Creative Voice File", "audio/x-voc"),
        array(0, 4, 0, "KRTN", "audio/x-multitrack"),
        array(0, 4, 0, "RIFF", "audio/x-wav"),
        array(0, 4, 0, "EMOD", "audio/x-emod"),
        array(0, 4, 0, "ýar.", "audio/x-pn-realaudio"),
        array(0, 3, 0, "MTM", "audio/x-multitrack"),
        array(0, 2, 0, "if", "audio/x-669-mod"),
        array(0, 3, 0, "FAR", "audio/mod"),
        array(0, 5, 0, "MAS_U", "audio/x-multimate-mod"),
        array(0x2c, 4, 0, "SCRM", "audio/x-st3-mod"),
        array(0, 22, 0, "GF1PATCH110\0ID#000002\0", "audio/x-gus-patch"),
        array(0, 22, 0, "GF1PATCH100\0ID#000002\0", "audio/x-gus-patch"),
        array(0, 2, 0, "JN", "audio/x-669-mod"),
        array(0, 4, 0, "UN05", "audio/x-mikmod-uni"),
        array(21, 8, 0, "!SCREAM!", "audio/x-st2-mod"),
        array(1080, 4, 0, "M.K.", "audio/x-protracker-mod"),
        array(1080, 4, 0, "M!K!", "audio/x-protracker-mod"),
        array(1080, 4, 0, "FLT4", "audio/x-startracker-mod"),
        array(1080, 4, 0, "4CHN", "audio/x-fasttracker-mod"),
        array(1080, 4, 0, "6CHN", "audio/x-fasttracker-mod"),
        array(1080, 4, 0, "8CHN", "audio/x-fasttracker-mod"),
        array(1080, 4, 0, "CD81", "audio/x-oktalyzer-mod"),
        array(1080, 4, 0, "OKTA", "audio/x-oktalyzer-mod"),
        array(1080, 4, 0, "16CN", "audio/x-taketracker-mod"),
        array(1080, 4, 0, "32CN", "audio/x-taketracker-mod"),
        array(0, 3, 0, "TOC", "audio/x-toc"),
        array(0, 2, 0, "\x07\x01", "application/x-executable-file"),
        array(0, 2, 0, "\x01\x06", "application/x-executable-file"),
        array(0, 2, 0, "\x06\x01", "application/x-executable-file"),
        array(0, 2, 0, "//", "text/cpp"),
        array(0, 5, 0, "\\1cw ", "application/data"),
        array(0, 4, 0, "\\1cw", "application/data"),
        array(0, 4, 0xffffff00, 0x140185, "application/data"),
        array(0, 4, 0xffffff00, 0xcb0185, "application/data"),
        array(0, 2, 0, "\x01}", "application/x-executable-file"),
        array(0, 2, 0, "\x01", "application/x-executable-file"),
        array(4, 4, 0, "pipe", "application/data"),
        array(4, 4, 0, "prof", "application/data"),
        array(0, 9, 0, "#!/bin/sh", "application/x-sh"),
        array(0, 10, 0, "#! /bin/sh", "application/x-sh"),
        array(0, 11, 0, "#!\   /bin/sh", "application/x-sh"),
        array(0, 10, 0, "#!/bin/csh", "application/x-csh"),
        array(0, 11, 0, "#! /bin/csh", "application/x-csh"),
        array(0, 12, 0, "#!\   /bin/csh", "application/x-csh"),
        array(0, 10, 0, "#!/bin/ksh", "application/x-ksh"),
        array(0, 11, 0, "#! /bin/ksh", "application/x-ksh"),
        array(0, 12, 0, "#!\   /bin/ksh", "application/x-ksh"),
        array(0, 17, 0, "#!/usr/local/tcsh", "application/x-csh"),
        array(0, 21, 0, "#!/usr/local/bin/tcsh", "application/x-csh"),
        array(0, 22, 0, "#! /usr/local/bin/tcsh", "application/x-csh"),
        array(0, 23, 0, "#!\   /usr/local/bin/tcsh", "application/x-csh"),
        array(0, 20, 0, "#!/usr/local/bin/zsh", "application/x-zsh"),
        array(0, 21, 0, "#! /usr/local/bin/zsh", "application/x-zsh"),
        array(0, 22, 0, "#!\   /usr/local/bin/zsh", "application/x-zsh"),
        array(0, 20, 0, "#!/usr/local/bin/ash", "application/x-sh"),
        array(0, 21, 0, "#! /usr/local/bin/ash", "application/x-zsh"),
        array(0, 22, 0, "#!\   /usr/local/bin/ash", "application/x-zsh"),
        array(0, 19, 0, "#!/usr/local/bin/ae", "text/script"),
        array(0, 20, 0, "#! /usr/local/bin/ae", "text/script"),
        array(0, 21, 0, "#!\   /usr/local/bin/ae", "text/script"),
        array(0, 11, 0, "#!/bin/nawk", "application/x-awk"),
        array(0, 12, 0, "#! /bin/nawk", "application/x-awk"),
        array(0, 13, 0, "#!\   /bin/nawk", "application/x-awk"),
        array(0, 15, 0, "#!/usr/bin/nawk", "application/x-awk"),
        array(0, 16, 0, "#! /usr/bin/nawk", "application/x-awk"),
        array(0, 17, 0, "#!\   /usr/bin/nawk", "application/x-awk"),
        array(0, 21, 0, "#!/usr/local/bin/nawk", "application/x-awk"),
        array(0, 22, 0, "#! /usr/local/bin/nawk", "application/x-awk"),
        array(0, 23, 0, "#!\   /usr/local/bin/nawk", "application/x-awk"),
        array(0, 11, 0, "#!/bin/gawk", "application/x-awk"),
        array(0, 12, 0, "#! /bin/gawk", "application/x-awk"),
        array(0, 13, 0, "#!\   /bin/gawk", "application/x-awk"),
        array(0, 15, 0, "#!/usr/bin/gawk", "application/x-awk"),
        array(0, 16, 0, "#! /usr/bin/gawk", "application/x-awk"),
        array(0, 17, 0, "#!\   /usr/bin/gawk", "application/x-awk"),
        array(0, 21, 0, "#!/usr/local/bin/gawk", "application/x-awk"),
        array(0, 22, 0, "#! /usr/local/bin/gawk", "application/x-awk"),
        array(0, 23, 0, "#!\   /usr/local/bin/gawk", "application/x-awk"),
        array(0, 10, 0, "#!/bin/awk", "application/x-awk"),
        array(0, 11, 0, "#! /bin/awk", "application/x-awk"),
        array(0, 12, 0, "#!\   /bin/awk", "application/x-awk"),
        array(0, 14, 0, "#!/usr/bin/awk", "application/x-awk"),
        array(0, 15, 0, "#! /usr/bin/awk", "application/x-awk"),
        array(0, 16, 0, "#!\   /usr/bin/awk", "application/x-awk"),
        array(0, 5, 0, "BEGIN", "application/x-awk"),
        array(0, 11, 0, "#!/bin/perl", "application/x-perl"),
        array(0, 12, 0, "#! /bin/perl", "application/x-perl"),
        array(0, 13, 0, "#!\   /bin/perl", "application/x-perl"),
        array(0, 20, 0, "eval \"exec /bin/perl", "application/x-perl"),
        array(0, 15, 0, "#!/usr/bin/perl", "application/x-perl"),
        array(0, 16, 0, "#! /usr/bin/perl", "application/x-perl"),
        array(0, 17, 0, "#!\   /usr/bin/perl", "application/x-perl"),
        array(0, 24, 0, "eval \"exec /usr/bin/perl", "application/x-perl"),
        array(0, 21, 0, "#!/usr/local/bin/perl", "application/x-perl"),
        array(0, 22, 0, "#! /usr/local/bin/perl", "application/x-perl"),
        array(0, 23, 0, "#!\   /usr/local/bin/perl", "application/x-perl"),
        array(0, 30, 0, "eval \"exec /usr/local/bin/perl", "application/x-perl"),
        array(0, 9, 0, "#!/bin/rc", "text/script"),
        array(0, 10, 0, "#! /bin/rc", "text/script"),
        array(0, 11, 0, "#!\   /bin/rc", "text/script"),
        array(0, 11, 0, "#!/bin/bash", "application/x-sh"),
        array(0, 12, 0, "#! /bin/bash", "application/x-sh"),
        array(0, 13, 0, "#!\   /bin/bash", "application/x-sh"),
        array(0, 21, 0, "#!/usr/local/bin/bash", "application/x-sh"),
        array(0, 22, 0, "#! /usr/local/bin/bash", "application/x-sh"),
        array(0, 23, 0, "#!\   /usr/local/bin/bash", "application/x-sh"),
        array(0, 4, 0, "#! /", "text/script"),
        array(0, 5, 0, "#!\   /", "text/script"),
        array(0, 3, 0, "#!/", "text/script"),
        array(0, 3, 0, "#! ", "text/script"),
        array(0, 2, 0, "\037\235", "application/compress"),
        array(0, 2, 0, "\037\213", "application/x-gzip"),
        array(0, 2, 0, "\037\036", "application/data"),
        array(0, 2, 0, "\x1f\x1f", "application/data"),
        array(0, 2, 0, "\x1fÿ", "application/data"),
        array(0, 2, 0, "\377\037", "application/data"),
        array(0, 2, 0, "Ë\x05", "application/data"),
        array(0, 3, 0, "BZh", "application/x-bzip2"),
        array(0, 2, 0, "ÿv", "application/data"),
        array(0, 2, 0, "þv", "application/data"),
        array(0, 2, 0, "ýv", "application/x-lzh"),
        array(0, 2, 0, "\037\237", "application/data"),
        array(0, 2, 0, "\037\236", "application/data"),
        array(0, 2, 0, "\037\240", "application/data"),
        array(0, 2, 0, "BZ", "application/x-bzip"),
        array(0, 9, 0, "\x89\x4c\x5a\x4f\x00\x0d\x0a\x1a\x0a", "application/data"),
        array(0, 4, 0, "W\x12\x01\x00", "application/core"),
        array(0, 4, 0, "ÎW\x13", "application/x-gdbm"),
        array(0, 4, 0, "\x13WÎ", "application/x-gdbm"),
        array(0, 4, 0, "GDBM", "application/x-gdbm"),
        array(0, 4, 0, "a\x15\x06\x00", "application/x-db"),
        array(0, 4, 0, "b1\x05\x00", "application/x-db"),
        array(0, 23, 0, "=<list>\n<protocol bbn-m", "application/data"),
        array(0, 5, 0, "diff ", "text/x-patch"),
        array(0, 4, 0, "*** ", "text/x-patch"),
        array(0, 8, 0, "Only in ", "text/x-patch"),
        array(0, 23, 0, "Common subdirectories: ", "text/x-patch"),
        array(0, 19, 0, "!<arch>\n________64E", "application/data"),
        array(0, 2, 0, "\x01", "application/x-executable-file"),
        array(0, 2, 0, "\x01", "application/x-object-file"),
        array(0, 3, 0, "\377\377\177", "application/data"),
        array(0, 3, 0, "\377\377\174", "application/data"),
        array(0, 3, 0, "\377\377\176", "application/data"),
        array(0, 3, 0, "\033c\033", "application/data"),
        array(0, 4, 0, "\x00\x12Ö", "image/x11"),
        array(0, 8, 0, "!<PDF>!\n", "application/x-prof"),
        array(0, 2, 0, "\x05\x01", "application/x-locale"),
        array(0, 4, 0, "\177ELF", "application/x-executable-file"),
        array(0, 2, 0, "\x01T", "application/data"),
        array(0, 2, 0, "\x01U", "application/x-executable-file"),
        array(0x438, 2, 0, "ïS", "application/x-linux-ext2fs"),
        array(0, 4, 0, "\366\366\366\366", "application/x-pc-floppy"),
        array(0774, 2, 0, "¾Ú", "application/data"),
        array(0x1FE, 2, 0, "ªU", "application/data"),
        array(0x410, 2, 0, "\x13", "application/x-filesystem"),
        array(0x410, 2, 0, "\x13", "application/x-filesystem"),
        array(0x410, 2, 0, "\x24h", "application/x-filesystem"),
        array(0x410, 2, 0, "\x24x", "application/x-filesystem"),
        array(0, 9, 0, "-rom1fs-\0", "application/x-filesystem"),
        array(0, 4, 0, "\x1b\x03\x136", "application/x-bootable"),
        array(0x18b, 4, 0, "OS/2", "application/x-bootable"),
        array(0, 4, 0, "FONT", "font/x-vfont"),
        array(0, 2, 0, "\x01\x1e", "font/x-vfont"),
        array(0, 2, 0, "\x1e\x01", "font/x-vfont"),
        array(0, 18, 0, "%!PS-AdobeFont-1.0", "font/type1"),
        array(6, 18, 0, "%!PS-AdobeFont-1.0", "font/type1"),
        array(0, 10, 0, "STARTFONT\040", "font/x-bdf"),
        array(0, 4, 0, "\001fcp", "font/x-pcf"),
        array(0, 5, 0, "D1.0\015", "font/x-speedo"),
        array(0, 3, 0, "flf", "font/x-figlet"),
        array(0, 3, 0, "flc", "application/x-font"),
        array(0, 4, 0, "\x19Y\x02\x14", "font/x-libgrx"),
        array(0, 4, 0, "NOFÿ", "font/x-dos"),
        array(7, 4, 0, "AGE\x00", "font/x-dos"),
        array(7, 4, 0, "DIV\x00", "font/x-dos"),
        array(0, 10, 0, "<MakerFile", "application/x-framemaker"),
        array(0, 8, 0, "<MIFFile", "application/x-framemaker"),
        array(0, 16, 0, "<MakerDictionary", "application/x-framemaker"),
        array(0, 16, 0, "<MakerScreenFont", "font/x-framemaker"),
        array(0, 4, 0, "<MML", "application/x-framemaker"),
        array(0, 9, 0, "<BookFile", "application/x-framemaker"),
        array(0, 6, 0, "<Maker", "application/x-framemaker"),
        array(0, 4, 0377777777, 0x860107, "application/x-executable-file"),
        array(0, 4, 0377777777, 0x860108, "application/x-executable-file"),
        array(0, 4, 0377777777, 0x86010b, "application/x-executable-file"),
        array(0, 4, 0377777777, 0x8600cc, "application/x-executable-file"),
        array(7, 22, 0, "\357\020\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0", "application/core"),
        array(0, 4, 0, "LDHi", "application/data"),
        array(0, 13, 0, "GIMP Gradient", "application/x-gimp-gradient"),
        array(0, 8, 0, "gimp xcf", "application/x-gimp-image"),
        array(20, 4, 0, "GPAT", "application/x-gimp-pattern"),
        array(20, 4, 0, "GIMP", "application/x-gimp-brush"),
        array(0, 4, 0, "\336\22\4\225", "application/x-locale"),
        array(0, 4, 0, "\225\4\22\336", "application/x-locale"),
        array(0, 2, 0, "\x01", "application/x-executable-file"),
        array(0, 2, 0, "\x01", "application/x-executable-file"),
        array(0, 5, 0, "\000\001\000\000\000", "font/ttf"),
        array(0, 4, 0, "\x0a\x0f\x08\x0e", "application/data"),
        array(0, 4, 0, "\x0f\x0a\x0e\x08", "application/data"),
        array(0, 4, 0, "\x08\x0e\x0a\x0f", "application/data"),
        array(0, 4, 0, "\x0e\x08\x0f\x0a", "application/data"),
        array(0, 4, 0, "\x06\x01\x10\x02", "application/x-object-file"),
        array(0, 4, 0, "\x07\x01\x10\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x08\x01\x10\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0b\x01\x10\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0e\x01\x10\x02", "application/x-library-file"),
        array(0, 4, 0, "\x0d\x01\x10\x02", "application/x-library-file"),
        array(0, 4, 0, "\x06\x01\x14\x02", "application/x-object-file"),
        array(0, 4, 0, "\x07\x01\x14\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x08\x01\x14\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0b\x01\x14\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0e\x01\x14\x02", "application/x-library-file"),
        array(0, 4, 0, "\x0d\x01\x14\x02", "application/x-object-file"),
        array(0, 4, 0, "\x06\x01\x0b\x02", "application/x-object-file"),
        array(0, 4, 0, "\x07\x01\x0b\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x08\x01\x0b\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0b\x01\x0b\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0e\x01\x0b\x02", "application/x-library-file"),
        array(0, 4, 0, "\x0d\x01\x0b\x02", "application/x-library-file"),
        array(0, 4, 0, "ra<!", "application/x-ar"),
        array(0, 4, 0, "\x02\x08\x01\x06", "application/x-executable-file"),
        array(0, 4, 0, "\x02\x08\x01\x07", "application/x-executable-file"),
        array(0, 4, 0, "\x02\x08\x01\x08", "application/x-executable-file"),
        array(0, 4, 0, "\x08\x01\x0c\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x07\x01\x0c\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0b\x01\x0c\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x06\x01\x0c\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x08\x01\x0a\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x07\x01\x0a\x02", "application/x-executable-file"),
        array(0, 4, 0, "\x0e\x01\x0c\x02", "application/x-library-file"),
        array(0, 4, 0, "\x0d\x01\x0c\x02", "application/x-library-file"),
        array(0, 4, 0, "\x02\x0aÿe", "application/x-library-file"),
        array(0, 4, 0, "\x02\x0cÿe", "application/x-library-file"),
        array(0, 4, 0, "\x02\x08ÿe", "application/x-library-file"),
        array(0, 4, 0, "\x01X!¦", "application/core"),
        array(0, 4, 0, "M§îè", "font/x-hp-windows"),
        array(0, 10, 0, "Bitmapfile", "image/unknown"),
        array(0, 4, 0, "\x02\x0c\x01\x0c", "application/x-lisp"),
        array(0, 8, 0, "msgcat01", "application/x-locale"),
        array(0, 2, 0, "P1", "image/x-portable-bitmap"),
        array(0, 2, 0, "P2", "image/x-portable-graymap"),
        array(0, 2, 0, "P3", "image/x-portable-pixmap"),
        array(0, 2, 0, "P4", "image/x-portable-bitmap"),
        array(0, 2, 0, "P5", "image/x-portable-graymap"),
        array(0, 2, 0, "P6", "image/x-portable-pixmap"),
        array(0, 4, 0, "IIN1", "image/tiff"),
        array(0, 4, 0, "MM\x00\x2a", "image/tiff"),
        array(0, 4, 0, "II\x2a\x00", "image/tiff"),
        array(0, 4, 0, "\x89PNG", "image/x-png"),
        array(1, 3, 0, "PNG", "image/x-png"),
        array(0, 4, 0, "GIF8", "image/gif"),
        array(0, 4, 0, "\361\0\100\273", "image/x-cmu-raster"),
        array(0, 2, 0, "Øÿ", "image/jpeg"),
        array(0, 4, 0, "hsi1", "image/x-jpeg-proprietary"),
        array(0, 2, 0, "BM", "image/x-bmp"),
        array(0, 2, 0, "IC", "image/x-ico"),
        array(0, 4, 0, "j¦Y", "x/x-image-sun-raster"),
        array(0, 2, 0, "Ú\x01", "x/x-image-sgi"),
        array(2048, 7, 0, "PCD_IPI", "x/x-photo-cd-pack-file"),
        array(0, 7, 0, "PCD_OPA", "x/x-photo-cd-overfiew-file"),
        array(0, 2, 0, "\x01H", "application/x-executable-file"),
        array(0, 2, 0, "\x01I", "application/x-executable-file"),
        array(0, 2, 0, "\x01J", "application/x-executable-file"),
        array(0, 2, 0, "\x01R", "application/x-executable-file"),
        array(0, 2, 0, "\x01L", "application/x-executable-file"),
        array(0, 2, 0, "\x046", "font/linux-psf"),
        array(0, 4, 0, "FFIL", "font/ttf"),
        array(65, 4, 0, "FFIL", "font/ttf"),
        array(0, 4, 0, "LWFN", "font/type1"),
        array(65, 4, 0, "LWFN", "font/type1"),
        array(0, 12, 0, "Return-Path:", "message/rfc822"),
        array(0, 5, 0, "Path:", "message/news"),
        array(0, 5, 0, "Xref:", "message/news"),
        array(0, 5, 0, "From:", "message/rfc822"),
        array(0, 7, 0, "Article", "message/news"),
        array(0, 5, 0, "BABYL", "message/x-gnu-rmail"),
        array(0, 9, 0, "Received:", "message/rfc822"),
        array(0, 2, 0, "MZ", "application/x-ms-dos-executable"),
        array(2080, 27, 0, "Microsoft Word 6.0 Document", "text/vnd.ms-word"),
        array(2080, 26, 0, "Documento Microsoft Word 6", "text/vnd.ms-word"),
        array(2112, 9, 0, "MSWordDoc", "text/vnd.ms-word"),
        array(0, 5, 0, "PO^Q`", "text/vnd.ms-word"),
        array(2080, 29, 0, "Microsoft Excel 5.0 Worksheet", "application/vnd.ms-excel"),
        array(2114, 5, 0, "Biff5", "application/vnd.ms-excel"),
        array(1, 3, 0, "WPC", "text/vnd.wordperfect"),
        array(0, 4, 0377777777, 0x7018600, "NetBSD/i386"),
        array(0, 4, 0377777777, 0x7018700, "NetBSD/m68k"),
        array(0, 4, 0377777777, 0x7018800, "NetBSD/m68k4k"),
        array(0, 4, 0377777777, 0x7018900, "NetBSD/ns32532"),
        array(0, 4, 0377777777, 0x7018a00, "NetBSD/sparc"),
        array(0, 4, 0377777777, 0x7018b00, "NetBSD/pmax"),
        array(0, 4, 0377777777, 0x7018c00, "NetBSD/vax"),
        array(0, 4, 0377777777, 0x7018e00, "NetBSD/mips"),
        array(0, 4, 0377777777, 0x7018f00, "NetBSD/arm32"),
        array(0, 16, 0, "StartFontMetrics", "font/x-sunos-news"),
        array(0, 9, 0, "StartFont", "font/x-sunos-news"),
        array(0, 4, 0, "D)z\x13", "font/x-sunos-news"),
        array(0, 4, 0, "G)z\x13", "font/x-sunos-news"),
        array(0, 4, 0, "P)z\x13", "font/x-sunos-news"),
        array(0, 4, 0, "Q)z\x13", "font/x-sunos-news"),
        array(8, 4, 0, "E+z\x13", "font/x-sunos-news"),
        array(8, 4, 0, "H+z\x13", "font/x-sunos-news"),
        array(0, 2, 0, "%!", "application/postscript"),
        array(0, 3, 0, "\004%!", "application/postscript"),
        array(0, 3, 0, "\033E\033", "image/x-pcl-hp"),
        array(0, 14, 0, "<!DOCTYPE HTML", "text/html"),
        array(0, 14, 0, "<!doctype html", "text/html"),
        array(0, 5, 0, "<HEAD", "text/html"),
        array(0, 5, 0, "<head", "text/html"),
        array(0, 6, 0, "<TITLE", "text/html"),
        array(0, 6, 0, "<title", "text/html"),
        array(0, 5, 0, "<html", "text/html"),
        array(0, 5, 0, "<HTML", "text/html"),
        array(0, 2, 0, "\367\203", "font/x-tex"),
        array(0, 2, 0, "\367\131", "font/x-tex"),
        array(0, 2, 0, "\367\312", "font/x-tex"),
        array(2, 2, 0, "\000\021", "font/x-tex-tfm"),
        array(2, 2, 0, "\000\022", "font/x-tex-tfm"),
        array('>2', 2, 0, "º¾", "application/java"),
        array(8, 4, 0, "AIFF", "audio/x-aiff"),
        array(8, 4, 0, "AIFC", "audio/x-aiff"),
        array(8, 4, 0, "8SVX", "audio/x-aiff"),
        array('>8', 4, 0, "WAVE", "audio/x-wav"),
        array('>8', 3, 0, "AVI", "video/x-msvideo"),
        array(0, 3, 0, "ID3", "audio/mpeg"),
        array(0, 4, 0, "OggS", "audio/x-ogg"),
        array(0, 6, 0, "/* XPM", "image/x-xpm"),
        array(16, 2, 0, "==", "image/x-3ds"),
        array(0, 11, 0, "#!/bin/tcsh", "application/x-shellscript"),
        array(0, 12, 0, "#! /bin/tcsh", "application/x-shellscript"),
        array(0, 18, 0, "#! /usr/local/tcsh", "application/x-shellscript"),
        array('>8', 6, 0, "debian", "application/x-debian-package"),
        array('>2', 2, 0, "Ûî", "application/x-rpm"),
        array(2, 5, 0, "-lh -", "application/x-lha"),
        array(2, 5, 0, "-lh6-", "application/x-lha"),
        array(2, 5, 0, "-lh7-", "application/x-lha"),
        array(0, 15, 0, "<MakerScreenFon", "application/x-frame"),
        array(0, 5, 0, "<Book", "application/x-frame"),
        array(0, 3, 0, "<h1", "text/html"),
        array(0, 3, 0, "<H1", "text/html"),
        array(0, 14, 0, "<!doctype HTML", "text/html"),
        array(0, 2, 0, "MM", "image/tiff"),
        array(0, 2, 0, "II", "image/tiff"),
        array(0, 6, 0, "GIF94z", "image/unknown"),
        array(0, 6, 0, "FGF95a", "image/unknown"),
        array(0, 3, 0, "PBF", "image/unknown"),
        array(0, 3, 0, "GIF", "image/gif"),
        array(0, 4, 0, "\376\067\0\043", "application/msword"),
        array(0, 6, 0, "\320\317\021\340\241\261", "application/msword"),
        array(0, 6, 0, "\333\245-\0\0\0", "application/msword"),
        array(0, 2, 0, "\x02÷", "application/x-dvi"),
        array(0, 2, 0, "¯\x11", "video/fli"),
        array(0, 2, 0, "¯\x12", "video/flc"),
        array('>8', 4, 0, "AVI ", "video/avi"),
        array(0, 1, 0, "\x01", "video/unknown"),
        array(0, 1, 0, "\x02", "video/unknown"),
        array(0, 19, 0, "[KDE Desktop Entry]", "application/x-kdelnk"),
        array(0, 18, 0, "\# KDE Config File", "application/x-kdelnk"),
        array(0, 7, 0, "\# xmcd", "text/xmcd"),
        array(0, 4, 0, "\x8aMNG", "video/x-mng"),
        array(0, 4, 0, "ó\x03\x00\x00", "application/x-executable-file"),
        array(0, 4, 0, "ç\x03\x00\x00", "application/x-library-file"),
        array(0, 4, 0, "³\x01\x00\x00", "video/mpeg"),
        array(0, 4, 0, "º\x01\x00\x00", "video/mpeg"),
        array(0, 4, 0, "\x00\x00l", "application/x-apl-workspace"),
        array(0, 4, 0, "\x00\x00ÿm", "application/x-ar"),
        array(0, 4, 0, "\x00\x00ÿe", "application/data"),
        array(0, 4, 0, "\x00\x00\x01\x06", "application/x-executable-file"),
        array(0, 4, 0, "G\x01\x00\x00", "application/x-object-file"),
        array(0, 4, 0, "K\x01\x00\x00", "application/x-executable-file"),
        array(0, 4, 0, "M\x01\x00\x00", "application/x-executable-file"),
        array(0, 4, 0, "O\x01\x00\x00", "application/x-executable-file"),
        array(24, 4, 0, "kê\x00\x00", "application/data"),
        array(24, 4, 0, "lê\x00\x00", "application/data"),
        array(24, 4, 0, "mê\x00\x00", "application/data"),
        array(24, 4, 0, "nê\x00\x00", "application/data"),
        array(0, 4, 0, "\x01\x00\x00", "application/x-object-file"),
        array(0, 4, 0, "\x01\x00\x00", "application/data"),
        array(24, 4, 0, "\x00\x00êl", "application/x-dump"),
        array(24, 4, 0, "\x00\x00êk", "application/x-dump"),
        array(0, 4, 0, "\x00\x00¾1", "text/vnd.ms-word"),
        array(0, 2, 0, "\x00\x00", "audio/mpeg"),
        array('>16', 2, 0, "\x00\x01", "application/x-object"),
        array('>16', 2, 0, "\x00\x02", "application/x-executable"),
        array('>16', 2, 0, "\x00\x03", "application/x-sharedlib"),
        array('>16', 2, 0, "\x00\x04", "application/x-coredump"),
        array(0, 4, 0, "\x00\x00\x00Ì", "application/x-executable-file"),
        array(0, 4, 0, "\x04\x00\x00\x00", "font/x-snf"),
        array(0, 4, 0, "\x00\x00\x00\x04", "font/x-snf"),
        array('>12', 4, 0, "\x01\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x02\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x03\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x04\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x05\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x06\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x07\x00\x00\x00", "audio/basic"),
        array('>12', 4, 0, "\x17\x00\x00\x00", "audio/x-adpcm"),
        array('>12', 4, 0, "\x00\x00\x00\x01", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x02", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x03", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x04", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x05", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x06", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x07", "audio/x-dec-basic"),
        array('>12', 4, 0, "\x00\x00\x00\x17", "audio/x-dec-adpcm")
   );

   $fd = substr($binary_data, 0, 3072);
   foreach ($mime_magic_data as $def) {
      $pos0 = $def[0];
      if ($pos0[0] == ">") {
         $pos0 = substr($pos0, 1);
         if (@strpos($fd, $def[3], $pos0) !== false) {
               return($def[4]);
         }
      } else {
         $part = substr($fd, $pos0, $def[1]);
         $mask = $def[2];
         if ($mask) {
             // if $mask is 0
            $value = 1 * ('0x'.bin2hex($part));
            if (($value & $mask) == $def[3]) {
               return($def[4]);
            }
         } else {
            if ($part == $def[3]) {
               return($def[4]);
            }
         }
      }
   }
}
