# Create entries used by our doxygen filter to expand the arch_page
# macros in the documentation.

class ArchDocPage:
    def __init__(self, doxygen_name, data_structures, files):
        self.doxygen_name = doxygen_name
        self.data_structures = data_structures
        self.files = files

##########################################
# List of all architecture subsections
##########################################
arch_doc_pages = [
    ArchDocPage('arch-block',
        ['WT_BLOCK', 'WT_BLOCK_CKPT', 'WT_BLOCK_DESC', 'WT_BLOCK_HEADER',
         'WT_BM', 'WT_EXTLIST'],
        ['src/include/block.h', 'src/include/block_inline.h',
         'src/block/']),
    ArchDocPage('arch-cache',
        ['WT_CACHE', 'WT_CACHE_POOL'],
        ['src/include/cache.h', 'src/include/cache_inline.h']),
    ArchDocPage('arch-checkpoint',
        ['WT_CONNECTION'],
        ['src/block/block_ckpt.c', 'src/block/block_ckpt_scan.c',
         'src/conn/conn_ckpt.c', 'src/meta/meta_ckpt.c',
         'src/txn/txn_ckpt.c']),
    ArchDocPage('arch-column',
        ['WT_BTREE'],
        ['src/include/btree.h']),
    ArchDocPage('arch-cursor',
        ['WT_CURSOR', 'WT_CURSOR_BACKUP', 'WT_CURSOR_BTREE', 'WT_CURSOR_BULK',
         'WT_CURSOR_DATA_SOURCE', 'WT_CURSOR_DUMP', 'WT_CURSOR_INDEX',
         'WT_CURSOR_LOG', 'WT_CURSOR_METADATA', 'WT_CURSOR_STAT'],
        ['src/include/cursor.h', 'src/include/cursor_inline.h',
         'src/cursor/']),
    ArchDocPage('arch-data-file',
        ['WT_CELL'],
        ['src/include/block.h', 'src/include/btmem.h',
         'src/include/cell.h', 'src/include/cell_inline.h',
         'src/reconcile/rec_col.c', 'src/reconcile/rec_row.c']),
    ArchDocPage('arch-dhandle',
        ['WT_BTREE', 'WT_DHANDLE'],
        ['src/include/btree.h', 'src/include/dhandle.h',
         'src/conn/conn_dhandle.c', 'src/session/session_dhandle.c']),
    ArchDocPage('arch-eviction',
        ['WT_EVICT_ENTRY', 'WT_EVICT_QUEUE'],
        ['src/include/cache.h',
         'src/evict/']),
    ArchDocPage('arch-fs-os',
        ['WT_FILE_SYSTEM'],
        ['src/include/os.h', 'src/include/os_fhandle_inline.h',
         'src/include/os_fs_inline.h', 'src/include/os_fstream_inline.h',
         'src/include/os_windows.h',
         'src/os_posix/', 'src/os_win/']),
    ArchDocPage('arch-hs',
        ['WT_CURSOR_HS'],
        ['src/history/']),
    ArchDocPage('arch-log-file',
        ['WT_LOGSLOT', 'WT_LOG_RECORD', 'WT_LSN'],
        ['src/include/log.h', 'src/log/']),
    ArchDocPage('arch-logging',
        ['WT_CURSOR_LOG', 'WT_LOG', 'WT_LOGSLOT', 'WT_LOG_RECORD', 'WT_LSN'],
        ['src/include/log.h', 'src/include/log_inline.h', 'src/log/']),
    ArchDocPage('arch-metadata',
        [],
        ['src/include/meta.h', 'src/meta/']),
    ArchDocPage('arch-python',
        [],
        ['lang/python/']),
    ArchDocPage('arch-row',
        ['WT_BTREE'],
        ['src/include/btree.h']),
    ArchDocPage('arch-rts',
        [''],
        ['src/txn/']),
    ArchDocPage('arch-schema',
        ['WT_COLGROUP', 'WT_INDEX', 'WT_LSM_TREE', 'WT_TABLE'],
        ['src/include/intpack_inline.h', 'src/include/packing_inline.h',
         'src/include/schema.h',
         'src/lsm/', 'src/packing/', 'src/schema/']),
    ArchDocPage('arch-snapshot',
        ['WT_TXN'],
        ['src/include/txn.h']),
    ArchDocPage('arch-transaction',
        ['WT_TXN', 'WT_TXN_GLOBAL', 'WT_TXN_OP', 'WT_TXN_SHARED'],
        ['src/include/txn.h', 'src/include/txn_inline.h', 'src/txn/']),
]
