#!/usr/local/groundwork/bin/perl --
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use strict;
use Nmap::Scanner;
$ENV{"PATH"} = $ENV{"PATH"}.":/usr/local/groundwork/bin";

my $args = $ARGV[0];
if ($args =~ /^\d+\.\d+\.\d+\.\d+$/) {
	my $scanner = new Nmap::Scanner;
	$scanner->tcp_syn_scan();
	$scanner->add_scan_port('21,25,80,443,3306,8080,22,79,13,11,7,10');
	$scanner->guess_os();
	$scanner->add_target($args);
	$scanner->max_rtt_timeout(200);
	my $results = $scanner->scan();
	my $data = $results->as_xml();
	print $data;
} else {
	# args = host:-:scan_type:-:timeout:-:ports
	my @args = split(/:-:/, $args);
	my $scanner = new Nmap::Scanner;
	if ($args[1] eq 'udp_scan') {
		$scanner->udp_scan();
	} elsif ($args[1] eq 'tcp_connect_scan') {
		$scanner->tcp_connect_scan();
	} else {
		$scanner->tcp_syn_scan();
	}
	if ($args[2] eq 'Insane') {
		$scanner->insane_timing();
	} elsif ($args[2] eq 'Sneaky') {
		$scanner->sneaky_timing();
	} elsif ($args[2] eq 'Paranoid') {
		$scanner->paranoid_timing();
	} elsif ($args[2] eq 'Polite') {
		$scanner->polite_timing();
	} elsif ($args[2] eq 'Aggressive') {
		$scanner->aggressive_timing();
	} else {
		$scanner->normal_timing();
	}
	$scanner->add_scan_port($args[3]);
	$scanner->guess_os();
	$scanner->add_target($args[0]);
	my $results = $scanner->scan();
	my $data = $results->as_xml();
	print $data;
}

