#!/usr/local/groundwork/bin/perl --
# MonArch - Groundwork Monitor Architect
# monarch_tree.cgi
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use lib qq(/usr/local/groundwork/monarch/lib);
use strict;
use CGI;
use MonarchTree;
use MonarchStorProc;
use URI::Escape;
$|++;


#
############################################################################
# Global Declarations
#

my $debug = undef;
my $query = new CGI;
my $top_menu = $query->param('top_menu');
my $ez = $query->param('ez');
my $session_id = $query->param('CGISESSID'); 
my $refresh_left = $query->param('refresh_left'); 
my $auth = StorProc->dbconnect();
my ($userid,$user_acct) = StorProc->get_session($session_id);
my (%auth_add, %auth_modify, %auth_delete) = ();
my ($is_portal, $enable_externals) = 0;
if (-e '/usr/local/groundwork/config/db.properties') { $is_portal = 1 }

if ($is_portal || $auth == 1) {
	unless ($userid) {
		$user_acct = $ENV{'REMOTE_USER'};
		unless ($user_acct) { $user_acct = 'super_user' }
		($userid, $session_id) = StorProc->set_gwm_session($user_acct);
	}
	my ($auth_add, $auth_modify, $auth_delete) = StorProc->auth_matrix($userid,'1');
	%auth_add = %{$auth_add};
	%auth_modify = %{$auth_modify};
	%auth_delete = %{$auth_delete};
	my %where = ('type' => 'config');
	my %objects = StorProc->fetch_list_hash_array('setup',\%where);
	$enable_externals = $objects{'enable_externals'}[2];
} elsif ($userid) {
	my ($auth_add, $auth_modify, $auth_delete) = StorProc->auth_matrix($userid);
	%auth_add = %{$auth_add};
	%auth_modify = %{$auth_modify};
	%auth_delete = %{$auth_delete};
	my %where = ('type' => 'config');
	my %objects = StorProc->fetch_list_hash_array('setup',\%where);
	$enable_externals = $objects{'enable_externals'}[2];
} else {
	use MonarchForms;
	print "Content-type: text/html \n\n";
	print Forms->login_redirect();
}

if ($top_menu && $userid) {
	use CGI::Ajax;
	my @menus = ();
	my %sub_menus = ();
	if ($ez && $top_menu eq 'hosts') {
		if ($is_portal || $auth == 1) {
			@menus = ('new','import','discover','search','hosts');
		} else {
			@menus = ('new');
			if ($auth_add{'ez_import'}) { push @menus, 'import' }
			#if ($auth_add{'ez_discover'}) { push @menus, 'discover' }
			push (@menus, ('search','hosts'));
		}
		$sub_menus{'hosts'} = 1;
	} elsif ($ez && $top_menu eq 'profiles') {
		@menus = ('profiles');
		$sub_menus{'profiles'} = 1;
	} elsif ($top_menu eq 'host_groups') {
		@menus = ('new','modify');
		$sub_menus{'modify'} = 1;
	} elsif ($top_menu eq 'notifications') {
		@menus = ('notifications','time_periods','contacts');
		$sub_menus{'time_periods'} = 1;
		$sub_menus{'contacts'} = 1;
	} elsif ($top_menu eq 'commit') {
		@menus = ('pre_flight_test','commit');
	} elsif ($top_menu eq 'setup') {
		@menus = ('setup');
	} elsif ($top_menu eq 'hosts') {
		my @host_menus = ('host_wizard','clone_host','search_host','hosts','host_groups','parent_child','host_templates','host_extended_info','host_dependencies','host_externals');
		foreach my $menu (@host_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($menu =~ /wizard|clone/ && $auth_add{'hosts'}) { push @menus, $menu }
				elsif ($menu =~ /search|^hosts$/ && $auth_modify{'hosts'}) { push @menus, $menu }
				elsif ($menu eq 'host_groups' && ($auth_add{'hostgroups'} || $auth_modify{'hostgroups'})) { push @menus, $menu }
				elsif ($menu eq 'host_extended_info' && ($auth_add{'extended_host_info_templates'} || $auth_modify{'extended_host_info_templates'})) { push @menus, $menu }
				elsif ($menu eq 'host_externals' && ($auth_add{'externals'} || $auth_modify{'externals'})) { push @menus, $menu }
				elsif ($auth_add{$menu} || $auth_modify{$menu}) { push @menus, $menu }
			}
		}
		unless ($enable_externals) { my $x = pop @menus }
		$sub_menus{'hosts'} = 1;
		$sub_menus{'host_groups'} = 1;
		$sub_menus{'parent_child'} = 1;
		$sub_menus{'host_templates'} = 1;
		$sub_menus{'host_extended_info'} = 1;
		$sub_menus{'host_dependencies'} = 1;
		$sub_menus{'host_externals'} = 1;
	} elsif ($top_menu eq 'services') {
		my @service_menus = ('new_service','clone_service','search_service','services','service_templates','service_dependencies','service_extended_info','service_groups','service_externals');
		foreach my $menu (@service_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($menu =~ /new|clone/ && $auth_add{'services'}) { push @menus, $menu }
				elsif ($menu =~ /search/ && $auth_modify{'services'}) { push @menus, $menu }
				elsif ($menu eq 'service_dependencies' && ($auth_add{'service_dependency_templates'} || $auth_modify{'service_dependency_templates'})) { push @menus, $menu }
				elsif ($menu eq 'service_extended_info' && ($auth_add{'extended_service_info_templates'} || $auth_modify{'extended_service_info_templates'})) { push @menus, $menu }
				elsif ($menu eq 'service_groups' && ($auth_add{'servicegroups'} || $auth_modify{'servicegroups'})) { push @menus, $menu }
				elsif ($menu eq 'service_externals' && ($auth_add{'externals'} || $auth_modify{'externals'})) { push @menus, $menu }
				elsif ($auth_add{$menu} || $auth_modify{$menu}) { push @menus, $menu }
			}
		}
		unless ($enable_externals) { my $x = pop @menus }
		$sub_menus{'services'} = 1;
		$sub_menus{'service_templates'} = 1;
		$sub_menus{'service_dependencies'} = 1;
		$sub_menus{'service_groups'} = 1;
		$sub_menus{'service_extended_info'} = 1;
		$sub_menus{'service_externals'} = 1;
	
	} elsif ($top_menu eq 'profiles') {
		my @profile_menus = ('host_profiles','service_profiles','profile_importer');
		foreach my $menu (@profile_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($auth_add{'profiles'} || $auth_modify{'profiles'}) { push @menus, $menu }
			}
		}
		$sub_menus{'host_profiles'} = 1;
		$sub_menus{'service_profiles'} = 1;
	} elsif ($top_menu eq 'contacts') {
		my @contact_menus = ('contacts','contact_groups','contact_templates');
		foreach my $menu (@contact_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($auth_add{$menu} || $auth_modify{$menu}) { push @menus, $menu }
				elsif ($menu eq 'contact_groups' && ($auth_add{'contactgroups'} || $auth_modify{'contactgroups'})) { push @menus, $menu }
			}
		}	
		$sub_menus{'contacts'} = 1;
		$sub_menus{'contact_groups'} = 1;
		$sub_menus{'contact_templates'} = 1;
	} elsif ($top_menu eq 'commands') {
		my @command_menus = ('new','copy','modify');
		foreach my $menu (@command_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($menu =~ /new|copy/ && $auth_add{'commands'}) { push @menus, $menu }
				elsif ($auth_modify{'commands'}) { push @menus, $menu }
			}
		}	
		$sub_menus{'copy'} = 1;
		$sub_menus{'modify'} = 1;
	} elsif ($top_menu eq 'time_periods') {
		my @time_period_menus = ('new','copy','modify');
		foreach my $menu (@time_period_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($menu =~ /new|copy/ && $auth_add{'time_periods'}) { push @menus, $menu }
				elsif ($auth_modify{'time_periods'}) { push @menus, $menu }
			}
		}	
		$sub_menus{'copy'} = 1;
		$sub_menus{'modify'} = 1;
	} elsif ($top_menu eq 'escalations') {
		my @escalation_menus = ('escalations','escalation_trees');
		foreach my $menu (@escalation_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($menu eq 'escalation_trees' && ($auth_add{'escalations'} || $auth_modify{'escalations'})) { push @menus, $menu }
				elsif ($auth_add{$menu} || $auth_modify{$menu}) { push @menus, $menu }
			}
		}	
		$sub_menus{'escalations'} = 1;
		$sub_menus{'escalation_trees'} = 1;
		
	} elsif ($top_menu eq 'groups') {
		my @group_menus = ('new','groups','macros');
		foreach my $menu (@group_menus) {
			push @menus, $menu;
		}	
		$sub_menus{'groups'} = 1;
	
	} elsif ($top_menu eq 'control') {
		my @control_menus = ('users','user_groups','setup','nagios_cgi_configuration','nagios_main_configuration','nagios_resource_macros',
		'load','pre_flight_test','commit');
		if ($is_portal) {
			@control_menus = ('setup','nagios_cgi_configuration','nagios_main_configuration','nagios_resource_macros',
			'load','pre_flight_test','commit');
		}
		foreach my $menu (@control_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($enable_externals && $auth_add{$menu} && $menu) {}
				if ($auth_add{$menu}) { push @menus, $menu }
			}
		}	
		if ($enable_externals && $auth_add{'commit'}) { push @menus, 'run_externals' }
		$sub_menus{'user_groups'} = 1;
		$sub_menus{'users'} = 1;
	} elsif ($top_menu eq 'tools') {
		my @tool_menus = ('export','host_delete_tool','service_delete_tool');				
		foreach my $menu (@tool_menus) {
			if ($is_portal || $auth == 1) {
				push @menus, $menu;
			} else {
				if ($auth_add{$menu}) { push @menus, $menu }
			}
		}	
	}
	my $detail = Tree->header('Monarch',$refresh_left);
	$detail .= Tree->root_tree(\@menus,\%sub_menus,$top_menu,$session_id,$ez);
	my $url = Tree->get_ajax_url();
	my $pjx = new CGI::Ajax( 'get_tree' => $url );
	print $pjx->build_html($query,$detail);
	print Tree->footer();

} elsif ($query->param('args') && $session_id) {
	my @input = $query->param('args');
	if ($debug) {
		my $now = time;
		open (FILE, "> /tmp/debug.log");
		print FILE "==============================\n$now\n";
		print FILE "arg 0 $input[0]\n";
		print FILE "arg 1 $input[1]\n";
		print FILE "arg 2 $input[2]\n";
		print FILE "arg 3 $input[3]\n";
		print FILE "arg 4 $input[4]\n";
		print FILE "arg 5 $input[5]\n";
		print FILE "arg 6 $input[6]\n";
		print FILE "userid $userid\n";
		print FILE "user_acct $user_acct\n";
		print FILE "debug $debug\n";
		close (FILE);
	}
	$input[3] = uri_unescape($input[3]);
	my @nodes = ();
	my $detail = undef;
	if ($input[1] eq 'hosts') { 
		if ($input[6]) {
			if ($input[2] == 1) {
				$input[4] .= 'view=hosts&name=';
				@nodes = StorProc->fetch_list('hostgroups','name');
				push @nodes, 'unassigned';
			} elsif ($input[2] == 2) {
				if ($input[3] eq 'unassigned') {
					@nodes = StorProc->get_hosts_unassigned();
				} else {
					@nodes = StorProc->get_host_hostgroup($input[3]);
				}
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4],$input[5],$input[6]);
		} else {
			if ($input[2] == 1) {
				$input[4] .= 'view=manage_host&obj=hosts';
				@nodes = StorProc->fetch_list('hostgroups','name');
				push @nodes, 'unassigned';
			} elsif ($input[2] == 2) {
				if ($input[3] eq 'unassigned') {
					@nodes = StorProc->get_hosts_unassigned();
				} else {
					@nodes = StorProc->get_host_hostgroup($input[3]);
				}
			} elsif ($input[2] == 3) {
				my %host = StorProc->fetch_one('hosts','name',$input[3]);
				@nodes = StorProc->get_host_services($host{'host_id'});
				$input[1] = 'host_services';
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4]);
		}
	} elsif ($input[0] eq 'host_groups') {
		$input[1] = 'host_groups';
		$input[4] .= 'view=host_groups&name=';
		@nodes = StorProc->fetch_list('hostgroups','name');
		$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'1',$input[3],$input[4],$input[5],$input[6]);
	} elsif ($input[1] eq 'host_groups') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'hostgroups'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'hostgroups'}) { push @nodes, 'modify' }
			}
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=hostgroups&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=hostgroups&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('hostgroups','name');
		}
		$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
	} elsif ($input[1] eq 'parent_child') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'parent_child'}) { push @nodes, 'new' }
				if ($auth_modify{'parent_child'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=parent_child&obj=parent_child&task=modify&name=';
			@nodes = StorProc->get_parents();
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'host_templates') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'host_templates'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'host_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=host_templates&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=host_templates&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('host_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'host_extended_info') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'extended_host_info_templates'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'extended_host_info_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=extended_host_info_templates&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=extended_host_info_templates&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('extended_host_info_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'host_dependencies') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'host_dependencies'}) { push @nodes, 'new' }
				if ($auth_modify{'host_dependencies'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=host_dependencies&obj=host_dependencies&task=modify&name=';
			@nodes = StorProc->get_host_dep_parents();
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'host_externals') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'externals'}) { push @nodes, 'new' }
				if ($auth_modify{'externals'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=host_externals&obj=host_externals&task=modify&name=';
			my %where = ('type' => 'host');
			my @nodes = StorProc->fetch_list_where('externals','name',\%where);
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'services') {
		$input[4] .= 'view=service&obj=services&obj_view=service_detail&name=';
		my @nodes = StorProc->fetch_list('service_names','name');
		$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'1',$input[3],$input[4]);
	} elsif ($input[1] eq 'service_templates') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'service_templates'}) { push @nodes, 'new' }
				if ($auth_modify{'service_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=service_template&obj=service_templates&task=modify&name=';
			@nodes = StorProc->fetch_list('service_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'service_dependencies') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				# fixed service_dependencies 2007-01-22
				if ($auth_add{'service_dependency_templates'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'service_dependency_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=service_dependency_templates&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=service_dependency_templates&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('service_dependency_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'service_groups') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'servicegroups'}) { push @nodes, 'new' }
				if ($auth_modify{'servicegroups'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=service_group&obj=servicegroups&task=modify&name=';
			@nodes = StorProc->fetch_list('servicegroups','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'service_extended_info') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'extended_service_info_templates'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'extended_service_info_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=extended_service_info_templates&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=extended_service_info_templates&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('extended_service_info_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'service_externals') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'externals'}) { push @nodes, 'new' }
				if ($auth_modify{'externals'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=service_externals&obj=service_externals&task=modify&name=';
			my %where = ('type' => 'service');
			@nodes = StorProc->fetch_list_where('externals','name',\%where);
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'profiles') {
		if ($input[2] == 1) {
			$input[4] .= 'view=profiles&name=';
			@nodes = StorProc->fetch_list('profiles_host','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'1',$input[3],$input[4],$input[5],$input[6]);
		}
	} elsif ($input[1] eq 'host_profiles') {
		if ($input[2] == 1) {
			@nodes = ('new','modify');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=host_profile&obj=profiles&task=modify&name=';
			@nodes = StorProc->fetch_list('profiles_host','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}

	} elsif ($input[1] eq 'service_profiles') {
		if ($input[2] == 1) {
			@nodes = ('new','modify');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=service_profile&obj=profiles&task=modify&name=';
			@nodes = StorProc->fetch_list('profiles_service','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'contacts') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'contacts'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'contacts'}) { push @nodes, 'modify' }
			}
			if ($input[6]) { @nodes = ('new','modify') }
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4],$input[5],$input[6]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=contacts&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				if ($input[6]) { 
					$input[5] = $input[3];
					$input[4] .= 'view=contacts&task=modify&name='; 
				} else {
					$input[4] .= 'view=manage&obj=contacts&task=modify&name=';
				}
			}
			@nodes = StorProc->fetch_list('contacts','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4],$input[5],$input[6]);
		}
	} elsif ($input[1] eq 'contact_groups') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'contactgroups'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'contactgroups'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=contactgroups&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=contactgroups&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('contactgroups','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'contact_templates') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1) {
				@nodes = ('new','copy','modify');
			} else {
				if ($auth_add{'contact_templates'}) { push @nodes, ('new','copy') }
				if ($auth_modify{'contact_templates'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			if ($input[3] eq 'copy') {
				$input[4] .= 'view=design&obj=contact_templates&task=copy&source=';
			} elsif ($input[3] eq 'modify') {
				$input[4] .= 'view=manage&obj=contact_templates&task=modify&name=';
			}
			@nodes = StorProc->fetch_list('contact_templates','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[6] && $input[1] eq 'time_periods') {
		if ($input[2] == 1) {
			@nodes = ('new','modify');
		} elsif ($input[3] eq 'modify') {
			$input[4] .= 'view=time_periods&name=';
			@nodes = StorProc->fetch_list('time_periods','name');
		}
		$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4],$input[5],$input[6]);
	} elsif ($input[0] eq 'time_periods') {
		if ($input[3] eq 'copy') {
			$input[4] .= 'view=design&obj=time_periods&task=copy&source=';
		} elsif ($input[3] eq 'modify') {
			$input[4] .= 'view=manage&obj=time_periods&task=modify&name=';
		}
		@nodes = StorProc->fetch_list('time_periods','name');
		$detail = Tree->child_tree(\@nodes,$input[0],$input[2],'1',$input[3],$input[4]);
	} elsif ($input[0] eq 'commands') {
		if ($input[3] eq 'copy') {
			$input[4] .= 'view=commands&obj=commands&task=copy&source=';
		} elsif ($input[3] eq 'modify') {
			$input[4] .= 'view=commands&obj=commands&task=modify&name=';
		}
		@nodes = StorProc->fetch_list('commands','name');
		$detail = Tree->child_tree(\@nodes,$input[0],$input[2],'1',$input[3],$input[4]);

	} elsif ($input[1] eq 'escalations') {
		if ($input[2] == 1) {
			@nodes = ('host','service');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= "view=escalations&obj=$input[3]\_escalation_templates&";
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'escalations'}) { push @nodes, 'new' }
				if ($auth_modify{'escalations'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4],$input[3]);
		} elsif ($input[2] == 3) {
			my $esc_type = 'host';
			if ($input[4] =~ /obj=service/) { $esc_type = 'service' }
			$input[4] .= "task=modify&name=";
			my %where = ('type' => $esc_type);
			@nodes = StorProc->fetch_list_where('escalation_templates','name',\%where);
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4],$input[5]);
		}
	} elsif ($input[1] eq 'escalation_trees') {
		if ($input[2] == 1) {
			@nodes = ('host','service');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= "view=escalation_trees&obj=escalation_trees&type=$input[3]&";
			if ($is_portal || $auth == 1) {
				@nodes = ('new','modify');
			} else {
				if ($auth_add{'escalations'}) { push @nodes, 'new' }
				if ($auth_modify{'escalations'}) { push @nodes, 'modify' }
			}
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4],$input[3]);
		} elsif ($input[2] == 3) {
			my $esc_type = 'host';
			if ($input[4] =~ /type=service/) { $esc_type = 'service' }
			$input[4] .= "obj_view=detail&task=modify&name=";
			my %where = ('type' => $esc_type);
			@nodes = StorProc->fetch_list_where('escalation_trees','name',\%where);
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'3',$input[3],$input[4],$input[5]);
		}
	} elsif ($input[1] eq 'groups') {
		if ($input[2] == 1) {
			if ($is_portal || $auth == 1 || $user_acct eq 'super_user') {
				@nodes = StorProc->fetch_list('monarch_groups','name');
			} else {
				@nodes = StorProc->get_auth_groups($userid);
			} 
			$detail = Tree->child_tree(\@nodes,$input[0],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= "view=groups&";
			@nodes = ('detail','nagios_cgi','nagios_cfg','resource_cfg','pre_flight_test','build_instance','export');
			$detail = Tree->child_tree(\@nodes,$input[0],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'users') {
		if ($input[2] == 1) {
			@nodes = ('new','modify');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=control&obj=users&task=modify&mod_user=';
			@nodes = StorProc->fetch_list('users','user_acct');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	} elsif ($input[1] eq 'user_groups') {
		if ($input[2] == 1) {
			@nodes = ('new','modify');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		} elsif ($input[2] == 2) {
			$input[4] .= 'view=control&obj=user_groups&task=modify&name=';
			@nodes = StorProc->fetch_list('user_groups','name');
			$detail = Tree->child_tree(\@nodes,$input[1],$input[2],'2',$input[3],$input[4]);
		}
	}

	my $result = StorProc->dbdisconnect();
	if ($debug) {
		my $now = time;
		open (FILE, ">> /tmp/debug.log");
		print FILE "==============================\n$now\n";
		print FILE "$detail\n";
		close (FILE);
	}

	print $detail;
}

my $result = StorProc->dbdisconnect();


