#!/usr/local/groundwork/bin/perl --
# MonArch - Groundwork Monitor Architect
# monarch_scan.cgi
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use lib qq(/usr/local/groundwork/monarch/lib);
use strict;
use CGI;
use Nmap::Scanner;
use MonarchStorProc;

sub get_hosts {
	my $query = new CGI();
	my @input = $query->param('args');
	unless ($input[0]) {
		$input[0] = '/tmp/monarch_discover_test.tmp';
		$input[1] = '172.28.113.209';
		$input[2] = '/usr/local/groundwork/monarch';
	}
	my $ret_info = undef;
	my $data = qx($input[2]/bin/nmap_scan_one $input[1]) || ($ret_info = "Error(s) executing $input[2]/bin/nmap_scan_one $input[1] $!");
	my %host_info = StorProc->process_nmap($data);
	unless ($host_info{'status'} eq 'up') { $host_info{'status'} = 'down (no response from host)' }
	my $line = "$host_info{'name'},$host_info{'alias'},$input[1],$host_info{'os'},$host_info{'status'}";
	my $ret_info = "$host_info{'name'}|$host_info{'alias'}|$input[1]|$host_info{'os'}|$host_info{'status'}";
	open (FILE, ">> $input[0]") or ($ret_info = "$!| $input[0]");
	print FILE "$line\n";
	close FILE;
	print "Content-type: text/html \n\n";
	print $ret_info;
}

&get_hosts;
