#!/usr/local/groundwork/bin/perl --
# MonArch - Groundwork Monitor Architect
# monarch_ajax.cgi
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use lib qq(/usr/local/groundwork/monarch/lib);
use strict;
use CGI;
use MonarchStorProc;

my $query = new CGI();
my @input = $query->param('args');
my $debug = 0;

if ($debug) {
	my $now = time;
	open (FILE, ">> /tmp/debug.log");
	print FILE "==============================\n$now\n";
}

sub get_services {
	use MonarchForms;
	my $connect = StorProc->dbconnect();
	my %services = ();
	if ($input[0]) { %services = StorProc->search_service($input[1]) }
	my $detail = Forms->search_results(\%services,$input[2],'service');
	my $result = StorProc->dbdisconnect();
	print $detail;
}

sub get_ez {
	use MonarchForms;
	my $connect = StorProc->dbconnect();
	my %hosts = ();
	if ($input[0]) { %hosts = StorProc->search($input[1]) }
	my $detail = Forms->search_results(\%hosts,$input[2],'ez');
	my $result = StorProc->dbdisconnect();
	print $detail;
}

sub get_hosts {
	use MonarchForms;
	my $connect = StorProc->dbconnect();
	my $num_hosts = 0;
	my %hosts = ();
	my $max_to_show = 20;
	if ($input[0]) {
		$num_hosts = StorProc->count_match('hosts', $input[0]);
		%hosts     = StorProc->search($input[0], $max_to_show);
	}
	my $num_more = $num_hosts - $max_to_show;
	$num_more = 0 if ($num_more < 0);
	my $detail = Forms->search_results(\%hosts,$input[1],'',$num_more);
	my $result = StorProc->dbdisconnect();
	print $detail;
}


sub process_load {
	my $connect = StorProc->dbconnect();
	use MonarchForms;
	use MonarchLoad;
	my @results = ();
	my $result_str = undef;
	if ($input[1] eq 'end') {
		my $dt = StorProc->datetime();
		@results = ("$dt\:\:completed\:\:Load process ends.");
	} elsif ($input[1] eq 'process_service_escalations') {
		@results = Load->process_service_escalations();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'process_host_escalations') {
		@results = Load->process_host_escalations();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'services') {
		@results = Load->process_services();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'hosts') {
		@results = Load->process_hosts();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'contacts') {
		@results = Load->process_contacts();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'timeperiods') {
		@results = Load->process_timeperiods();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'commands') {
		@results = Load->process_commands();
		print FILE "$input[1]\n" if $debug;
	} elsif ($input[1] eq 'stage') {
		@results = Load->stage_load($input[2]);
		print FILE "$input[1]\n" if $debug;
		print FILE "$input[2]\n" if $debug;
	} elsif ($input[1] eq 'purge') {
		StorProc->purge($input[3],$input[4]);
		my $dt = StorProc->datetime();
		my $message = "Preparing stage";
		if ($input[3] eq 'update' && $input[4]) {
			$message .= " - purging escalations.";
		} elsif ($input[3] eq 'update') {
			$message .= " for update.";
		} elsif ($input[3] eq 'purge_all') {
			$message .= " - purging all.";
		} else {
			$message .= " - purging service related objects.";
		}
		@results = ("$dt\:\:setup\:\:$message");
	}
	foreach my $result (@results) {
		$result_str .= "$result|";
	}
	chop $result_str;
	print FILE "$result_str\n" if $debug;
	print "Content-type: text/html \n\n";
	print $result_str;
	my $result = StorProc->dbdisconnect();
}

print FILE "arg 0 $input[0]\n" if $debug;
print FILE "arg 1 $input[1]\n" if $debug;
print FILE "arg 2 $input[2]\n" if $debug;
print FILE "arg 3 $input[3]\n" if $debug;
print FILE "arg 4 $input[4]\n" if $debug;
close FILE if $debug;

if ($input[0] eq 'service') {
	&get_services;
} elsif ($input[0] eq 'process_load') {
	&process_load;
} elsif ($input[0] eq 'ez') {
	&get_ez;
} else {
	&get_hosts;
}



