-- Copyright 2007-2008 GroundWork Open Source, Inc. (GroundWork)  
-- All rights reserved. This program is free software; you can redistribute it and/or 
-- modify it under the terms of the GNU General Public License version 2 as published 
-- by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY 
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
-- PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with this 
-- program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, 
-- Fifth Floor, Boston, MA 02110-1301, USA.
--
-- MySQL dump 10.10
--
-- Host: localhost    Database: monarch
-- ------------------------------------------------------
-- Server version	5.0.18-pro

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `access_list`
--

DROP TABLE IF EXISTS `access_list`;
CREATE TABLE `access_list` (
  `object` varchar(50) NOT NULL default '',
  `type` varchar(50) NOT NULL default '',
  `usergroup_id` smallint(4) unsigned NOT NULL default '0',
  `access_values` varchar(20) default NULL,
  PRIMARY KEY  (`object`,`type`,`usergroup_id`),
  KEY `usergroup_id` (`usergroup_id`),
  CONSTRAINT `access_list_ibfk_1` FOREIGN KEY (`usergroup_id`) REFERENCES `user_groups` (`usergroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `access_list`
--


/*!40000 ALTER TABLE `access_list` DISABLE KEYS */;
LOCK TABLES `access_list` WRITE;
INSERT INTO `access_list` VALUES ('commands','design_manage',1,'add,modify,delete'),('commit','control',1,'full_control'),('contactgroups','design_manage',1,'add,modify,delete'),('contacts','design_manage',1,'add,modify,delete'),('contact_templates','design_manage',1,'add,modify,delete'),('escalations','design_manage',1,'add,modify,delete'),('export','design_manage',1,'add,modify,delete'),('extended_host_info_templates','design_manage',1,'add,modify,delete'),('extended_service_info_templates','design_manage',1,'add,modify,delete'),('externals','design_manage',1,'add,modify,delete'),('ez_commit','ez',1,'ez_commit'),('ez_discover','ez',1,'ez_discover'),('ez_enabled','ez',1,'ez_enabled'),('ez_hosts','ez',1,'ez_hosts'),('ez_host_groups','ez',1,'ez_host_groups'),('ez_import','ez',1,'ez_import'),('ez_notifications','ez',1,'ez_notifications'),('ez_profiles','ez',1,'ez_profiles'),('ez_setup','ez',1,'ez_setup'),('files','control',1,'full_control'),('hostgroups','design_manage',1,'add,modify,delete'),('hosts','design_manage',1,'add,modify,delete'),('host_delete_tool','tools',1,'add,modify,delete'),('host_dependencies','design_manage',1,'add,modify,delete'),('host_templates','design_manage',1,'add,modify,delete'),('import','discover',1,'full_control'),('load','control',1,'full_control'),('main_ez','ez',1,'main_ez'),('manage','group_macro',1,'manage'),('match_strings','discover',1,'full_control'),('nagios_cgi_configuration','control',1,'full_control'),('nagios_main_configuration','control',1,'full_control'),('nagios_resource_macros','control',1,'full_control'),('nmap','discover',1,'full_control'),('parent_child','design_manage',1,'add,modify,delete'),('pre_flight_test','control',1,'full_control'),('process_stage','discover',1,'full_control'),('profiles','design_manage',1,'add,modify,delete'),('run_external_scripts','control',1,'full_control'),('servicegroups','design_manage',1,'add,modify,delete'),('services','design_manage',1,'add,modify,delete'),('service_delete_tool','tools',1,'add,modify,delete'),('service_dependency_templates','design_manage',1,'add,modify,delete'),('service_templates','design_manage',1,'add,modify,delete'),('setup','control',1,'full_control'),('time_periods','design_manage',1,'add,modify,delete'),('users','control',1,'full_control'),('user_groups','control',1,'full_control');
UNLOCK TABLES;
/*!40000 ALTER TABLE `access_list` ENABLE KEYS */;

--
-- Table structure for table `commands`
--

DROP TABLE IF EXISTS `commands`;
CREATE TABLE `commands` (
  `command_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `type` varchar(50) default NULL,
  `data` text,
  `comment` text,
  PRIMARY KEY  (`command_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `commands`
--


/*!40000 ALTER TABLE `commands` DISABLE KEYS */;
LOCK TABLES `commands` WRITE;
INSERT INTO `commands` VALUES (1,'check_local_load','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_load -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>','# \'check_local_load\' command definition\n'),(2,'check_nntp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nntp -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>','# \'check_nntp\' command definition\n'),(3,'check_telnet','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 23]]>\n </prop>\n</data>','# \'check_telnet\' command definition\n'),(4,'check_ftp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_ftp -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>','# \'check_ftp\' command definition\n'),(5,'host-notify-by-email','notify','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\nHost: $HOSTNAME$\\nState: $HOSTSTATE$\\nAddress: $HOSTADDRESS$\\nInfo: $HOSTOUTPUT$\\n\\nDate/Time: $LONGDATETIME$\\n\" | /bin/mail -s \"Host $HOSTSTATE$ alert for $HOSTNAME$!\" $CONTACTEMAIL$]]>\n </prop>\n</data>','# \'host-notify-by-email\' command definition\n'),(6,'process-service-perfdata','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"$LASTSERVICECHECK$\\t$HOSTNAME$\\t$SERVICEDESC$\\t$SERVICESTATE$\\t$SERVICEATTEMPT$\\t$SERVICESTATETYPE$\\t$SERVICEEXECUTIONTIME$\\t$SERVICELATENCY$\\t$SERVICEOUTPUT$\\t$SERVICEPERFDATA$\\n\" >> /usr/local/groundwork/nagios/var/service-perfdata.out]]>\n </prop>\n</data>','# \'process-service-perfdata\' command definition\n'),(7,'check-host-alive','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_icmp -H $HOSTADDRESS$ -w 3000.0,80% -c 5000.0,100% -n 1]]>\n  </prop>\n</data>','# \'check-host-alive\' command definition\n'),(8,'check_udp','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_udp -H $HOSTADDRESS$ -p $ARG1$]]>\n </prop>\n</data>','# \'check_udp\' command definition\n'),(9,'service-notify-by-epager','notify','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"Service: $SERVICEDESC$\\nHost: $HOSTNAME$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\nInfo: $SERVICEOUTPUT$\\nDate: $LONGDATETIME$\" | /bin/mail -s \"$NOTIFICATIONTYPE$: $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$\" $CONTACTPAGER$]]>\n </prop>\n</data>','# \'notify-by-epager\' command definition\n'),(10,'check_local_procs','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_procs -w $ARG1$ -c $ARG2$ -s $ARG3$]]>\n </prop>\n</data>','# \'check_local_procs\' command definition\n'),(11,'check_http','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_http -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>','# \'check_http\' command definition\n'),(12,'check_pop3','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_pop -H $HOSTADDRESS$]]>\n </prop>\n</data>','# \'check_pop\' command definition\n'),(13,'check_hpjd','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_hpjd -H $HOSTADDRESS$ -C public]]>\n </prop>\n</data>','# \'check_hpjd\' command definition\n'),(14,'service-notify-by-email','notify','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\n\\nService: $SERVICEDESC$\\nHost: $HOSTALIAS$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\n\\nDate/Time: $LONGDATETIME$\\n\\nAdditional Info:\\n\\n$SERVICEOUTPUT$\" | /bin/mail -s \"** $NOTIFICATIONTYPE$ alert - $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$ **\" $CONTACTEMAIL$]]>\n </prop>\n</data>','# \'notify-by-email\' command definition\n'),(15,'check_smtp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_smtp -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>','# \'check_smtp\' command definition\n'),(16,'check_local_users','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_users -w $ARG1$ -c $ARG2$]]>\n </prop>\n</data>','# \'check_local_users\' command definition\n'),(17,'host-notify-by-epager','notify','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"Host \'$HOSTALIAS$\' is $HOSTSTATE$\\nInfo: $HOSTOUTPUT$\\nTime: $LONGDATETIME$\" | /bin/mail -s \"$NOTIFICATIONTYPE$ alert - Host $HOSTNAME$ is $HOSTSTATE$\" $CONTACTPAGER$]]>\n </prop>\n</data>','# \'host-notify-by-epager\' command definition\n'),(18,'check_proc','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_procs -c $ARG1$ -C $ARG2$]]>\n </prop>\n</data>','# \'check_procs\' command definition\n'),(19,'check_ping','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_ping -H $HOSTADDRESS$ -w $ARG1$ -c $ARG2$ -p 5]]>\n </prop>\n</data>','# \'check_ping\' command definition\n'),(20,'check_tcp','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$]]>\n </prop>\n</data>','# \'check_tcp\' command definition\n'),(21,'check_dns','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_dns -t 30 -s $HOSTADDRESS$ -H \"$ARG1$\"]]>\n  </prop>\n</data>','# \'check_dns\' command definition\n'),(22,'check_local_disk','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_disk -w \"$ARG1$\" -c \"$ARG2$\" -p \"$ARG3$\"]]>\n  </prop>\n</data>','# \'check_local_disk\' command definition\n'),(23,'process-host-perfdata','check','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"$LASTHOSTCHECK$\\t$HOSTNAME$\\t$HOSTSTATE$\\t$HOSTATTEMPT$\\t$HOSTSTATETYPE$\\t$HOSTEXECUTIONTIME$\\t$HOSTOUTPUT$\\t$HOSTPERFDATA$\\n\" >> /usr/local/groundwork/nagios/var/host-perfdata.out]]>\n </prop>\n</data>','# \'process-host-perfdata\' command definition\n'),(24,'check_alive','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_icmp -H $HOSTADDRESS$ -w 3000.0,80% -c 5000.0,100% -n 1]]>\n  </prop>\n</data>',NULL),(25,'check_tcp_ssh','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 22]]>\n  </prop>\n</data>',NULL),(26,'check_by_ssh_disk','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_disk -w $ARG1$ -c $ARG2$ -p $ARG3$\"]]>\n  </prop>\n</data>',NULL),(27,'check_by_ssh_load','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_load -w $ARG1$ -c $ARG2$\"]]>\n  </prop>\n</data>',NULL),(28,'check_by_ssh_mem','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_mem.pl -u -w $ARG1$ -c $ARG2$\"]]>\n  </prop>\n</data>',NULL),(29,'check_by_ssh_process_count','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -w $ARG1$ -c $ARG2$\"]]>\n  </prop>\n</data>',NULL),(30,'check_by_ssh_swap','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_swap -w $ARG1$ -c $ARG2$\"]]>\n  </prop>\n</data>',NULL),(31,'check_snmp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_snmp -H $HOSTADDRESS$ -o \"$ARG1$\" -r \"$ARG2$\" -l \"$ARG3$\" -C \'$USER7$\']]>\n  </prop>\n</data>',NULL),(32,'check_snmp_if','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_snmp -H $HOSTADDRESS$ -C \'$USER7$\' -o \"IF-MIB::ifInOctets.$ARG1$,IF-MIB::ifOutOctets.$ARG1$ ,IF-MIB::ifInDiscards.$ARG1$,IF-MIB::ifOutDiscards.$ARG1$,IF-MIB::ifInErrors.$ARG1$,IF-MIB::ifOutErrors.$ARG1$\"]]>\n  </prop>\n</data>',NULL),(33,'check_snmp_bandwidth','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_snmp -H $HOSTADDRESS$ -C \'$USER7$\' -o \"IF-MIB::ifInOctets.$ARG1$,IF-MIB::ifOutOctets.$ARG1$,IF-MIB::ifSpeed.$ARG1$\"]]>\n  </prop>\n</data>',NULL),(34,'check_ifoperstatus','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_ifoperstatus -k \"$ARG1$\" -H $HOSTADDRESS$ -C \"$USER7$\"]]>\n  </prop>\n</data>',NULL),(35,'host-notify-by-sendemail','notify','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"<html><b>+++++ HOST $NOTIFICATIONTYPE$ : $HOSTSTATE$ +++++<br>$LONGDATETIME$</b><br>Host: <b>$HOSTALIAS$ ($HOSTADDRESS$)</b></b><br>Message: <b>$HOSTOUTPUT$</b></html>\" | /usr/local/groundwork/bin/sendEmail -s $USER13$ -q -f $ADMINEMAIL$ -t $CONTACTEMAIL$ -u \"[GW] ++ $HOSTNAME$ : $HOSTSTATE$ ++\"]]>\n  </prop>\n</data>',NULL),(36,'service-notify-by-sendemail','notify','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[/usr/bin/printf \"%b\" \"<html><b>+++++ SERVICE $NOTIFICATIONTYPE$ : $SERVICESTATE$ +++++<br>$LONGDATETIME$</b><br>Host: <b>$HOSTALIAS$ ($HOSTADDRESS$)</b></b><br>Message: <b>$SERVICEOUTPUT$</b></html>\" | /usr/local/groundwork/bin/sendEmail -s $USER13$ -q -f $ADMINEMAIL$ -t $CONTACTEMAIL$ -u \"[GW] ++ $HOSTNAME$ : $SERVICEDESC$ : $SERVICESTATE$ ++\"]]>\n  </prop>\n</data>',NULL),(37,'check_mysql','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_mysql -H $HOSTADDRESS$ -d \"$ARG1$\" -u \"$ARG2$\" -p \"$USER6$\"]]>\n  </prop>\n</data>',NULL),(38,'check_mysql_engine','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_mysql -H $HOSTADDRESS$ -u \"$ARG1$\" -p \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(39,'check_mysql_engine_nopw','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_mysql -H $HOSTADDRESS$ -u \"$ARG1$\"]]>\n  </prop>\n</data>',NULL),(40,'check_local_procs_string','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_procs -w \"$ARG1$\" -c \"$ARG2$\" -a \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(41,'check_local_mem','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_mem.pl -u -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(42,'check_tcp_nsca','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 5667]]>\n  </prop>\n</data>',NULL),(43,'check_nagios','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nagios -F /usr/local/groundwork/nagios/var/status.log -e 5 -C bin/nagios]]>\n  </prop>\n</data>',NULL),(44,'check_nagios_latency','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nagios_latency.pl]]>\n  </prop>\n</data>',NULL),(45,'check_local_procs_arg','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_procs -w \"$ARG1$\" -c \"$ARG2$\" -a \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(46,'check_local_swap','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_swap -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(47,'check_tcp_dns','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 53]]>\n  </prop>\n</data>',NULL),(48,'check_udp_dns','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_udp -H $HOSTADDRESS$ -p 53 -s \"4500 003d 668f 4000 4011 4ce9 c0a8 02f0\"]]>\n  </prop>\n</data>',NULL),(49,'check_dns_expect','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_dns -t 30 -s $HOSTADDRESS$ -H \"$ARG1$\" -a \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(50,'check_tcp_ftp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 21]]>\n  </prop>\n</data>',NULL),(51,'check_tcp_https','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 443]]>\n  </prop>\n</data>',NULL),(52,'check_https','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_http -t 60 -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -S]]>\n  </prop>\n</data>',NULL),(53,'check_tcp_port','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p \"$ARG1$\"]]>\n  </prop>\n</data>',NULL),(54,'check_http_port','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_http -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -p \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(55,'check_tcp_imaps','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 993]]>\n  </prop>\n</data>',NULL),(56,'check_imaps','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_imap -t 60 -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -p 993 -S]]>\n  </prop>\n</data>',NULL),(57,'check_tcp_nntps','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 563]]>\n  </prop>\n</data>',NULL),(58,'check_nntps','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nntp -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -p 563 -S]]>\n  </prop>\n</data>',NULL),(59,'check_tcp_nrpe','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 5666]]>\n  </prop>\n</data>',NULL),(60,'check_nrpe','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$]]>\n  </prop>\n</data>',NULL),(61,'check_tcp_pop3s','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 995]]>\n  </prop>\n</data>',NULL),(62,'check_pop3s','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_pop -t 60 -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -S]]>\n  </prop>\n</data>',NULL),(63,'check_tcp_smtp','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -H $HOSTADDRESS$ -p 25]]>\n  </prop>\n</data>',NULL),(64,'check_nrpe_print_queue','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_printqueue -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(65,'check_nrpe_cpu','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_cpu -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(66,'check_nrpe_disk','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_disk -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(67,'check_nrpe_disk_transfers','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_disktransfers -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(68,'check_nrpe_exchange_mailbox_receiveq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_exchange_mbox_recvq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(69,'check_nrpe_exchange_mailbox_sendq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_exchange_mbox_sendq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(70,'check_nrpe_exchange_mta_workq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_exchange_mta_workq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(71,'check_nrpe_exchange_public_receiveq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_exchange_pub_recvq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(72,'check_nrpe_exchange_public_sendq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_exchange_pub_sendq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(73,'check_nrpe_iis_bytes_received','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_bytes_received -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(74,'check_nrpe_iis_bytes_sent','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_bytes_sent -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(75,'check_nrpe_iis_bytes_total','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_bytes_total -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(76,'check_nrpe_iis_current_connections','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_currentconnections -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(77,'check_nrpe_iis_current_nonanonymous_users','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_curnonanonusers -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(78,'check_nrpe_iis_get_requests','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_get_requests -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(79,'check_nrpe_iis_maximum_connections','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_maximumconnections -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(80,'check_nrpe_iis_post_requests','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_post_requests -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(81,'check_nrpe_iis_private_bytes','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_privatebytes -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(82,'check_nrpe_iis_total_not_found_errors','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_iis_totalnotfounderrors -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(83,'check_nrpe_local_cpu','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_cpu -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(84,'check_nrpe_local_disk','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_disk -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(85,'check_nrpe_local_memory','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mem -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(86,'check_nrpe_local_pagefile','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c check_pagefile_counter -a \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(87,'check_nrpe_mem','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mem -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(88,'check_nrpe_mssql_buffer_cache_hits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_buf_cache_hit -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(89,'check_nrpe_mssql_deadlocks','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_deadlocks -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(90,'check_nrpe_mssql_full_scans','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_fullscans -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(92,'check_nrpe_mssql_lock_wait_time','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_lock_wait_time -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(93,'check_nrpe_mssql_lock_waits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_lock_waits -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(94,'check_nrpe_mssql_log_growths','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_log_growth -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(95,'check_nrpe_mssql_log_used','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_log_used -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(96,'check_nrpe_mssql_memory_grants_pending','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_memgrantspending -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(97,'check_nrpe_memory_pages','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_swapping -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(98,'check_nrpe_mssql_transactions','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_transactions -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(99,'check_nrpe_mssql_users','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $HOSTADDRESS$ -c get_mssql_users -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(148,'check_apache','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_apache.pl -H $HOSTADDRESS$]]>\n  </prop>\n</data>',NULL),(149,'check_nt_cpuload','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v CPULOAD -l \"$ARG1$\"]]>\n  </prop>\n</data>',NULL),(150,'check_nt_useddiskspace','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v USEDDISKSPACE -l $ARG1$ -w $ARG2$ -c $ARG3$]]>\n  </prop>\n</data>',NULL),(151,'check_nt_counter_exchange_mailrq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\MSExchangeIS Mailbox(_Total)\\\\Receive Queue Size\",\"Receive Queue Size is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(152,'check_nt_counter_exchange_mailsq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\MSExchangeIS Mailbox(_Total)\\\\Send Queue Size\",\"Send Queue Size is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(153,'check_nt_counter_exchange_mtawq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\MSExchangeMTA\\\\Work Queue Length\",\"Work Queue Length is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(154,'check_nt_counter_exchange_publicrq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\MSExchangeIS Public(_Total)\\\\Receive Queue Size\",\"Receive Queue Size is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(155,'check_nt_counter_exchange_publicsq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\MSExchangeIS Public(_Total)\\\\Send Queue Size\",\"Send Queue Size is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(156,'check_nt_memuse','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v MEMUSE -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(157,'check_udp_nsclient','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_udp -H $HOSTADDRESS$ -p $USER19$]]>\n  </prop>\n</data>',NULL),(158,'check_ldap','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_ldap -t 60  -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -b \"$ARG3$\" -3]]>\n  </prop>\n</data>',NULL),(159,'check_tcp_ldap','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_tcp -t 60 -H $HOSTADDRESS$ -w 2 -c 4 -p 389]]>\n  </prop>\n</data>',NULL),(160,'check_snmptraps','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_snmptraps.pl $HOSTNAME$ $ARG1$ $ARG2$ $ARG3$]]>\n  </prop>\n</data>',NULL),(161,'check_ssh','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_ssh -H $HOSTADDRESS$ -t 60]]>\n  </prop>\n</data>',NULL),(162,'check_by_ssh_apache','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_apache.pl -H $HOSTADDRESS$\"]]>\n  </prop>\n</data>',NULL),(164,'check_by_ssh_process_proftpd','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -a proftpd:\\ \\(accepting\"]]>\n  </prop>\n</data>',NULL),(165,'check_by_ssh_process_slapd','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -w $ARG1$ -c $ARG2$ -C slapd\"]]>\n  </prop>\n</data>',NULL),(166,'check_by_ssh_mysql','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_mysql -H $HOSTADDRESS$ -d $ARG1$ -u $ARG2$ -p $ARG3$\"]]>\n  </prop>\n</data>',NULL),(167,'check_by_ssh_mysql_engine','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_mysql -H $HOSTADDRESS$ -u $ARG1$ -p $ARG2$\"]]>\n  </prop>\n</data>',NULL),(168,'check_by_ssh_process_args','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -w $ARG1$ -c $ARG2$ -a $ARG3$\"]]>\n  </prop>\n</data>',NULL),(169,'check_sendmail','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_smtp -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -C \"ehlo groundworkopensource.com\" -R \"ENHANCEDSTATUSCODES\" -f nagios@$HOSTADDRESS$]]>\n  </prop>\n</data>',NULL),(170,'check_by_ssh_mailq_sendmail','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"sudo $USER22$/check_mailq -w $ARG1$ -c $ARG2$ -M sendmail\"]]>\n  </prop>\n</data>',NULL),(171,'check_by_ssh_process_crond','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -a crond\"]]>\n  </prop>\n</data>',NULL),(172,'check_by_ssh_process_sendmail_accept','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -a sendmail:\\ accepting\\ con\"]]>\n  </prop>\n</data>',NULL),(173,'check_by_ssh_process_sendmail_qrunner','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -a sendmail:\\ Queue\\ runner\"]]>\n  </prop>\n</data>',NULL),(174,'check_by_ssh_process_xinetd','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -a xinetd\"]]>\n  </prop>\n</data>',NULL),(175,'check_by_ssh_process_cmd','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -w $ARG1$ -c $ARG2$ -C $ARG3$\"]]>\n  </prop>\n</data>',NULL),(176,'check_wmi_cpu','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H \"$USER21$\" -c get_cpu -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(177,'check_wmi_disk','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_disk -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(178,'check_wmi_mem','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mem -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(179,'check_wmi_exchange_mailbox_receiveq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_exchange_mbox_recvq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(180,'check_wmi_exchange_mailbox_sendq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_exchange_mbox_sendq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(181,'check_wmi_service','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -H $USER21$ -t 60 -c get_service -a \"$HOSTADDRESS$\" \"$ARG1$\"]]>\n  </prop>\n</data>',NULL),(182,'check_wmi_exchange_mta_workq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_exchange_mta_workq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(183,'check_wmi_exchange_public_receiveq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_exchange_pub_recvq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(184,'check_wmi_exchange_public_sendq','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_exchange_pub_sendq -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(185,'check_wmi_iis_bytes_received','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_bytes_received -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(186,'check_wmi_iis_bytes_sent','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_bytes_sent -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(187,'check_wmi_iis_bytes_total','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_bytes_total -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(188,'check_wmi_iis_current_connections','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_currentconnections -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(189,'check_wmi_iis_current_nonanonymous_users','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_curnonanonusers -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(190,'check_wmi_iis_get_requests','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_get_requests -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(191,'check_wmi_iis_maximum_connections','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_maximumconnections -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(192,'check_wmi_iis_post_requests','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_post_requests -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(193,'check_wmi_iis_private_bytes','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_privatebytes -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(194,'check_wmi_iis_total_not_found_errors','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_iis_totalnotfounderrors -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(225,'check_citrix','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_ica_master_browser.pl -I $HOSTADDRESS$ -P $HOSTADDRESS$]]>\n  </prop>\n</data>',NULL),(226,'check_wmi_mssql_buffer_cache_hits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_buf_cache_hit -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(227,'check_wmi_mssql_deadlocks','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_deadlocks -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(228,'check_wmi_disk_transfers','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_disktransfers -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(229,'check_wmi_mssql_full_scans','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_fullscans -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(231,'check_wmi_mssql_lock_wait_time','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_lock_wait_time -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(232,'check_wmi_mssql_lock_waits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_lock_waits -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(233,'check_wmi_mssql_log_growths','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_log_growth -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(234,'check_wmi_mssql_log_used','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_log_used -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(235,'check_wmi_mssql_memory_grants_pending','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_memgrantspending -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(236,'check_wmi_memory_pages','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_swapping -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(237,'check_wmi_mssql_transactions','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_transactions -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\" \"$ARG3$\"]]>\n  </prop>\n</data>',NULL),(238,'check_wmi_mssql_users','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -t 60 -H $USER21$ -c get_mssql_users -a \"$HOSTADDRESS$\" \"$ARG1$\" \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(246,'check_nt_counter_disktransfers','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\PhysicalDisk(_Total)\\\\Disk Transfers/sec\",\"PhysicalDisk(_Total) Disk Transfers/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(247,'check_nt_counter_memory_pages','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\Memory\\\\Pages/sec\",\"Pages per Sec is %.f\" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(248,'check_nt_counter_mssql_bufcache_hits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Buffer Manager\\\\Buffer cache hit ratio\",\"SQLServer:Buffer Manager Buffer cache hit ratio is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(249,'check_nt_counter_mssql_deadlocks','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Locks(_Total)\\\\Number of Deadlocks/sec\",\"SQLServer:Locks(_Total) Number of Deadlocks/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(250,'check_nt_counter_mssql_latch_waits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Latches\\\\Latch Waits/sec\",\"SQLServer:Latches Latch Waits/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(251,'check_nt_counter_mssql_lock_wait_time','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Locks(_Total)\\\\Lock Wait Time (ms)\",\"SQLServer:Locks(_Total) Lock Wait Time (ms) is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(252,'check_nt_counter_mssql_lock_waits','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Locks(_Total)\\\\Lock Waits/sec\",\"SQLServer:Locks(_Total) Lock Waits/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(253,'check_nt_counter_mssql_log_growths','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Databases(_Total)\\\\Log Growths\",\"SQLServer:Databases(_Total) Log Growths is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(254,'check_nt_counter_mssql_log_used','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Databases(_Total)\\\\Percent Log Used\",\"SQLServer:Databases(_Total) Percent Log Used is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(255,'check_nt_counter_mssql_memory_grants_pending','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Memory Manager\\\\Memory Grants Pending\",\"SQLServer:Memory Manager Memory Grants Pending is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(256,'check_nt_counter_mssql_transactions','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\SQLServer:Databases(_Total)\\\\Transactions/sec\",\"SQLServer:Databases(_Total) Transactions/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(257,'check_nt_counter_network_interface','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -H $HOSTADDRESS$ -p $USER19$ -s $USER4$ -v COUNTER -l \"\\\\Network Interface(MS TCP Loopback interface)\\\\Bytes Total/sec\",\"Network Interface(MS TCP Loopback interface) Bytes Total/sec is %.f \" -w \"$ARG1$\" -c \"$ARG2$\"]]>\n  </prop>\n</data>',NULL),(258,'check_by_ssh_process_named','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_by_ssh -H $HOSTADDRESS$ -t 60 -l \"$USER17$\" -C \"$USER22$/check_procs -c 1:1 -C named -a /etc/named.conf\"]]>\n  </prop>\n</data>',NULL),(259,'check_syslog','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_syslog_gw.pl -l $ARG1$ -s /tmp/$HOSTNAME$.tmp -x $ARG2$ -a $HOSTADDRESS$]]>\n  </prop>\n</data>',NULL),(260,'check_imap','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_imap -t 60 -H $HOSTADDRESS$ -w \"$ARG1$\" -c \"$ARG2$\" -p 143]]>\n  </prop>\n</data>',NULL),(262,'process_service_perfdata_db','other','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER2$/process_service_perf_db.pl \"$LASTSERVICECHECK$\" \"$HOSTNAME$\" \"$SERVICEDESC$\" \"$SERVICEOUTPUT$\" \"$SERVICEPERFDATA$\"]]>\n  </prop>\n</data>',NULL),(263,'check_snmp_alive','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_snmp -H $HOSTADDRESS$ -o .1.3.6.1.2.1.1.3.0 -l \"Uptime is \" -C \'$USER7$\']]>\n  </prop>\n</data>',NULL),(264,'check_nt','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nt -p $USER19$ -s $USER4$ -H $HOSTADDRESS$ -v CLIENTVERSION]]>\n  </prop>\n</data>',NULL),(265,'check_nrpe_service','check','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER1$/check_nrpe -H $HOSTADDRESS$ -t 60 -c get_service -a \"$HOSTADDRESS$\" \"$ARG1$\"]]>\n  </prop>\n</data>',NULL),(266,'process_service_perfdata_file','other','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"command_line\"><![CDATA[$USER2$/process_service_perf_db_file.pl]]>\n  </prop>\n</data>',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `commands` ENABLE KEYS */;

--
-- Table structure for table `contact_command`
--

DROP TABLE IF EXISTS `contact_command`;
CREATE TABLE `contact_command` (
  `contacttemplate_id` smallint(4) unsigned NOT NULL default '0',
  `type` varchar(50) NOT NULL default '',
  `command_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contacttemplate_id`,`type`,`command_id`),
  KEY `command_id` (`command_id`),
  CONSTRAINT `contact_command_ibfk_1` FOREIGN KEY (`command_id`) REFERENCES `commands` (`command_id`) ON DELETE CASCADE,
  CONSTRAINT `contact_command_ibfk_2` FOREIGN KEY (`contacttemplate_id`) REFERENCES `contact_templates` (`contacttemplate_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contact_command`
--


/*!40000 ALTER TABLE `contact_command` DISABLE KEYS */;
LOCK TABLES `contact_command` WRITE;
INSERT INTO `contact_command` VALUES (1,'host',5),(2,'host',5),(2,'service',9),(1,'service',14),(2,'service',14),(2,'host',17);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contact_command` ENABLE KEYS */;

--
-- Table structure for table `contact_command_overrides`
--

DROP TABLE IF EXISTS `contact_command_overrides`;
CREATE TABLE `contact_command_overrides` (
  `contact_id` smallint(4) unsigned NOT NULL default '0',
  `type` varchar(50) NOT NULL default '',
  `command_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contact_id`,`type`,`command_id`),
  KEY `command_id` (`command_id`),
  CONSTRAINT `contact_command_overrides_ibfk_1` FOREIGN KEY (`command_id`) REFERENCES `commands` (`command_id`) ON DELETE CASCADE,
  CONSTRAINT `contact_command_overrides_ibfk_2` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`contact_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contact_command_overrides`
--


/*!40000 ALTER TABLE `contact_command_overrides` DISABLE KEYS */;
LOCK TABLES `contact_command_overrides` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contact_command_overrides` ENABLE KEYS */;

--
-- Table structure for table `contact_overrides`
--

DROP TABLE IF EXISTS `contact_overrides`;
CREATE TABLE `contact_overrides` (
  `contact_id` smallint(4) unsigned NOT NULL default '0',
  `host_notification_period` smallint(4) unsigned default NULL,
  `service_notification_period` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`contact_id`),
  CONSTRAINT `contact_overrides_ibfk_1` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`contact_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contact_overrides`
--


/*!40000 ALTER TABLE `contact_overrides` DISABLE KEYS */;
LOCK TABLES `contact_overrides` WRITE;
INSERT INTO `contact_overrides` VALUES (1,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"host_notification_options\"><![CDATA[d,r]]>\n  </prop>\n  <prop name=\"service_notification_options\"><![CDATA[c,r]]>\n  </prop>\n</data>'),(2,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"host_notification_options\"><![CDATA[d,u,r]]>\n  </prop>\n  <prop name=\"service_notification_options\"><![CDATA[u,c,w,r]]>\n  </prop>\n</data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `contact_overrides` ENABLE KEYS */;

--
-- Table structure for table `contact_templates`
--

DROP TABLE IF EXISTS `contact_templates`;
CREATE TABLE `contact_templates` (
  `contacttemplate_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `host_notification_period` smallint(4) unsigned default NULL,
  `service_notification_period` smallint(4) unsigned default NULL,
  `data` text,
  `comment` text,
  PRIMARY KEY  (`contacttemplate_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contact_templates`
--


/*!40000 ALTER TABLE `contact_templates` DISABLE KEYS */;
LOCK TABLES `contact_templates` WRITE;
INSERT INTO `contact_templates` VALUES (1,'generic-contact-1',1,1,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"host_notification_options\"><![CDATA[d,r]]>\n  </prop>\n  <prop name=\"service_notification_options\"><![CDATA[c,r]]>\n  </prop>\n </data>',NULL),(2,'generic-contact-2',3,3,'<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"host_notification_options\"><![CDATA[d,u,r]]>\n </prop>\n <prop name=\"service_notification_options\"><![CDATA[u,c,w,r]]>\n </prop>\n</data>',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contact_templates` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_contact`
--

DROP TABLE IF EXISTS `contactgroup_contact`;
CREATE TABLE `contactgroup_contact` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `contact_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`contact_id`),
  KEY `contact_id` (`contact_id`),
  CONSTRAINT `contactgroup_contact_ibfk_1` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`contact_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_contact_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_contact`
--


/*!40000 ALTER TABLE `contactgroup_contact` DISABLE KEYS */;
LOCK TABLES `contactgroup_contact` WRITE;
INSERT INTO `contactgroup_contact` VALUES (1,1),(1,2);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_contact` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_group`
--

DROP TABLE IF EXISTS `contactgroup_group`;
CREATE TABLE `contactgroup_group` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `group_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `contactgroup_group_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_group_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_group`
--


/*!40000 ALTER TABLE `contactgroup_group` DISABLE KEYS */;
LOCK TABLES `contactgroup_group` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_group` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_host`
--

DROP TABLE IF EXISTS `contactgroup_host`;
CREATE TABLE `contactgroup_host` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `contactgroup_host_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_host_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_host`
--


/*!40000 ALTER TABLE `contactgroup_host` DISABLE KEYS */;
LOCK TABLES `contactgroup_host` WRITE;
INSERT INTO `contactgroup_host` VALUES (1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_host` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_host_profile`
--

DROP TABLE IF EXISTS `contactgroup_host_profile`;
CREATE TABLE `contactgroup_host_profile` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`hostprofile_id`),
  KEY `hostprofile_id` (`hostprofile_id`),
  CONSTRAINT `contactgroup_host_profile_ibfk_1` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_host_profile_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_host_profile`
--


/*!40000 ALTER TABLE `contactgroup_host_profile` DISABLE KEYS */;
LOCK TABLES `contactgroup_host_profile` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_host_profile` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_host_template`
--

DROP TABLE IF EXISTS `contactgroup_host_template`;
CREATE TABLE `contactgroup_host_template` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `hosttemplate_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`hosttemplate_id`),
  KEY `hosttemplate_id` (`hosttemplate_id`),
  CONSTRAINT `contactgroup_host_template_ibfk_1` FOREIGN KEY (`hosttemplate_id`) REFERENCES `host_templates` (`hosttemplate_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_host_template_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_host_template`
--


/*!40000 ALTER TABLE `contactgroup_host_template` DISABLE KEYS */;
LOCK TABLES `contactgroup_host_template` WRITE;
INSERT INTO `contactgroup_host_template` VALUES (1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_host_template` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_hostgroup`
--

DROP TABLE IF EXISTS `contactgroup_hostgroup`;
CREATE TABLE `contactgroup_hostgroup` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`hostgroup_id`),
  KEY `hostgroup_id` (`hostgroup_id`),
  CONSTRAINT `contactgroup_hostgroup_ibfk_1` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_hostgroup_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_hostgroup`
--


/*!40000 ALTER TABLE `contactgroup_hostgroup` DISABLE KEYS */;
LOCK TABLES `contactgroup_hostgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_hostgroup` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_service`
--

DROP TABLE IF EXISTS `contactgroup_service`;
CREATE TABLE `contactgroup_service` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `service_id` int(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`service_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `contactgroup_service_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_service_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_service`
--


/*!40000 ALTER TABLE `contactgroup_service` DISABLE KEYS */;
LOCK TABLES `contactgroup_service` WRITE;
INSERT INTO `contactgroup_service` VALUES (1,1),(1,2),(1,3),(1,4);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_service` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_service_name`
--

DROP TABLE IF EXISTS `contactgroup_service_name`;
CREATE TABLE `contactgroup_service_name` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`servicename_id`),
  KEY `servicename_id` (`servicename_id`),
  CONSTRAINT `contactgroup_service_name_ibfk_1` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_service_name_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_service_name`
--


/*!40000 ALTER TABLE `contactgroup_service_name` DISABLE KEYS */;
LOCK TABLES `contactgroup_service_name` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_service_name` ENABLE KEYS */;

--
-- Table structure for table `contactgroup_service_template`
--

DROP TABLE IF EXISTS `contactgroup_service_template`;
CREATE TABLE `contactgroup_service_template` (
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  `servicetemplate_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contactgroup_id`,`servicetemplate_id`),
  KEY `servicetemplate_id` (`servicetemplate_id`),
  CONSTRAINT `contactgroup_service_template_ibfk_1` FOREIGN KEY (`servicetemplate_id`) REFERENCES `service_templates` (`servicetemplate_id`) ON DELETE CASCADE,
  CONSTRAINT `contactgroup_service_template_ibfk_2` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroup_service_template`
--


/*!40000 ALTER TABLE `contactgroup_service_template` DISABLE KEYS */;
LOCK TABLES `contactgroup_service_template` WRITE;
INSERT INTO `contactgroup_service_template` VALUES (1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroup_service_template` ENABLE KEYS */;

--
-- Table structure for table `contactgroups`
--

DROP TABLE IF EXISTS `contactgroups`;
CREATE TABLE `contactgroups` (
  `contactgroup_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `alias` varchar(255) NOT NULL default '',
  `comment` text,
  PRIMARY KEY  (`contactgroup_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contactgroups`
--


/*!40000 ALTER TABLE `contactgroups` DISABLE KEYS */;
LOCK TABLES `contactgroups` WRITE;
INSERT INTO `contactgroups` VALUES (1,'nagiosadmin','Linux Administrators','# \'linux-admins\' contact group definition\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `contactgroups` ENABLE KEYS */;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
CREATE TABLE `contacts` (
  `contact_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `alias` varchar(255) NOT NULL default '',
  `email` text,
  `pager` text,
  `contacttemplate_id` smallint(4) unsigned default NULL,
  `status` tinyint(1) default NULL,
  `comment` text,
  PRIMARY KEY  (`contact_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contacts`
--


/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
LOCK TABLES `contacts` WRITE;
INSERT INTO `contacts` VALUES (1,'jdoe','John Doe','jdoe@localhost',NULL,1,1,'# \'jdoe\' contact definition\n'),(2,'nagiosadmin','Nagios Admin','nagios-admin@localhost','pagenagios-admin@localhost',2,1,'# \'nagios\' contact definition\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;

--
-- Table structure for table `datatype`
--

DROP TABLE IF EXISTS `datatype`;
CREATE TABLE `datatype` (
  `datatype_id` smallint(4) unsigned NOT NULL auto_increment,
  `type` varchar(100) NOT NULL default '',
  `location` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`datatype_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `datatype`
--


/*!40000 ALTER TABLE `datatype` DISABLE KEYS */;
LOCK TABLES `datatype` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `datatype` ENABLE KEYS */;

--
-- Table structure for table `discover_filter`
--

DROP TABLE IF EXISTS `discover_filter`;
CREATE TABLE `discover_filter` (
  `filter_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `type` varchar(50) default NULL,
  `filter` text,
  PRIMARY KEY  (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_filter`
--


/*!40000 ALTER TABLE `discover_filter` DISABLE KEYS */;
LOCK TABLES `discover_filter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_filter` ENABLE KEYS */;

--
-- Table structure for table `discover_group`
--

DROP TABLE IF EXISTS `discover_group`;
CREATE TABLE `discover_group` (
  `group_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` text,
  `config` text,
  `schema_id` smallint(4) unsigned default NULL,
  PRIMARY KEY  (`group_id`),
  KEY `schema_id` (`schema_id`),
  CONSTRAINT `discover_group_ibfk_1` FOREIGN KEY (`schema_id`) REFERENCES `import_schema` (`schema_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_group`
--


/*!40000 ALTER TABLE `discover_group` DISABLE KEYS */;
LOCK TABLES `discover_group` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_group` ENABLE KEYS */;

--
-- Table structure for table `discover_group_filter`
--

DROP TABLE IF EXISTS `discover_group_filter`;
CREATE TABLE `discover_group_filter` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `filter_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`,`filter_id`),
  KEY `filter_id` (`filter_id`),
  CONSTRAINT `discover_group_filter_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `discover_group` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `discover_group_filter_ibfk_2` FOREIGN KEY (`filter_id`) REFERENCES `discover_filter` (`filter_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_group_filter`
--


/*!40000 ALTER TABLE `discover_group_filter` DISABLE KEYS */;
LOCK TABLES `discover_group_filter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_group_filter` ENABLE KEYS */;

--
-- Table structure for table `discover_group_method`
--

DROP TABLE IF EXISTS `discover_group_method`;
CREATE TABLE `discover_group_method` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `method_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`,`method_id`),
  KEY `method_id` (`method_id`),
  CONSTRAINT `discover_group_method_ibfk_1` FOREIGN KEY (`method_id`) REFERENCES `discover_method` (`method_id`) ON DELETE CASCADE,
  CONSTRAINT `discover_group_method_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `discover_group` (`group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_group_method`
--


/*!40000 ALTER TABLE `discover_group_method` DISABLE KEYS */;
LOCK TABLES `discover_group_method` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_group_method` ENABLE KEYS */;

--
-- Table structure for table `discover_method`
--

DROP TABLE IF EXISTS `discover_method`;
CREATE TABLE `discover_method` (
  `method_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` text,
  `config` text,
  `type` varchar(50) default NULL,
  PRIMARY KEY  (`method_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_method`
--


/*!40000 ALTER TABLE `discover_method` DISABLE KEYS */;
LOCK TABLES `discover_method` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_method` ENABLE KEYS */;

--
-- Table structure for table `discover_method_filter`
--

DROP TABLE IF EXISTS `discover_method_filter`;
CREATE TABLE `discover_method_filter` (
  `method_id` smallint(4) unsigned NOT NULL default '0',
  `filter_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`method_id`,`filter_id`),
  KEY `filter_id` (`filter_id`),
  CONSTRAINT `discover_method_filter_ibfk_1` FOREIGN KEY (`method_id`) REFERENCES `discover_method` (`method_id`) ON DELETE CASCADE,
  CONSTRAINT `discover_method_filter_ibfk_2` FOREIGN KEY (`filter_id`) REFERENCES `discover_filter` (`filter_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `discover_method_filter`
--


/*!40000 ALTER TABLE `discover_method_filter` DISABLE KEYS */;
LOCK TABLES `discover_method_filter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `discover_method_filter` ENABLE KEYS */;

--
-- Table structure for table `escalation_templates`
--

DROP TABLE IF EXISTS `escalation_templates`;
CREATE TABLE `escalation_templates` (
  `template_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `type` varchar(50) NOT NULL default '',
  `data` text,
  `comment` text,
  `escalation_period` smallint(4) unsigned default NULL,
  PRIMARY KEY  (`template_id`,`name`,`type`),
  UNIQUE KEY `name` (`name`),
  KEY `escalation_period` (`escalation_period`),
  CONSTRAINT `escalation_templates_ibfk_1` FOREIGN KEY (`escalation_period`) REFERENCES `time_periods` (`timeperiod_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `escalation_templates`
--


/*!40000 ALTER TABLE `escalation_templates` DISABLE KEYS */;
LOCK TABLES `escalation_templates` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `escalation_templates` ENABLE KEYS */;

--
-- Table structure for table `escalation_tree_template`
--

DROP TABLE IF EXISTS `escalation_tree_template`;
CREATE TABLE `escalation_tree_template` (
  `tree_id` smallint(4) unsigned NOT NULL default '0',
  `template_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tree_id`,`template_id`),
  KEY `template_id` (`template_id`),
  CONSTRAINT `escalation_tree_template_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `escalation_templates` (`template_id`) ON DELETE CASCADE,
  CONSTRAINT `escalation_tree_template_ibfk_2` FOREIGN KEY (`tree_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `escalation_tree_template`
--


/*!40000 ALTER TABLE `escalation_tree_template` DISABLE KEYS */;
LOCK TABLES `escalation_tree_template` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `escalation_tree_template` ENABLE KEYS */;

--
-- Table structure for table `escalation_trees`
--

DROP TABLE IF EXISTS `escalation_trees`;
CREATE TABLE `escalation_trees` (
  `tree_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` varchar(100) default NULL,
  `type` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`tree_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `escalation_trees`
--


/*!40000 ALTER TABLE `escalation_trees` DISABLE KEYS */;
LOCK TABLES `escalation_trees` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `escalation_trees` ENABLE KEYS */;

--
-- Table structure for table `extended_host_info_templates`
--

DROP TABLE IF EXISTS `extended_host_info_templates`;
CREATE TABLE `extended_host_info_templates` (
  `hostextinfo_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `data` text,
  `script` varchar(255) default NULL,
  `comment` text,
  PRIMARY KEY  (`hostextinfo_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `extended_host_info_templates`
--


/*!40000 ALTER TABLE `extended_host_info_templates` DISABLE KEYS */;
LOCK TABLES `extended_host_info_templates` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `extended_host_info_templates` ENABLE KEYS */;

--
-- Table structure for table `extended_info_coords`
--

DROP TABLE IF EXISTS `extended_info_coords`;
CREATE TABLE `extended_info_coords` (
  `host_id` int(4) unsigned NOT NULL default '0',
  `data` text,
  PRIMARY KEY  (`host_id`),
  CONSTRAINT `extended_info_coords_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `extended_info_coords`
--


/*!40000 ALTER TABLE `extended_info_coords` DISABLE KEYS */;
LOCK TABLES `extended_info_coords` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `extended_info_coords` ENABLE KEYS */;

--
-- Table structure for table `extended_service_info_templates`
--

DROP TABLE IF EXISTS `extended_service_info_templates`;
CREATE TABLE `extended_service_info_templates` (
  `serviceextinfo_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `data` text,
  `script` varchar(255) default NULL,
  `comment` text,
  PRIMARY KEY  (`serviceextinfo_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `extended_service_info_templates`
--


/*!40000 ALTER TABLE `extended_service_info_templates` DISABLE KEYS */;
LOCK TABLES `extended_service_info_templates` WRITE;
INSERT INTO `extended_service_info_templates` VALUES (1,'number_graph','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"notes_url\"><![CDATA[/graphs/cgi-bin/label_graph.cgi?host=$HOSTNAME$&service=$SERVICENAME$]]>\n  </prop>\n  <prop name=\"icon_image\"><![CDATA[services.gif]]>\n  </prop>\n  <prop name=\"icon_image_alt\"><![CDATA[Service Detail]]>\n  </prop>\n</data>',NULL,NULL),(2,'unix_load_graph','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"notes_url\"><![CDATA[/graphs/cgi-bin/label_graph.cgi?host=$HOSTNAME$&service=$SERVICENAME$]]>\n  </prop>\n  <prop name=\"icon_image\"><![CDATA[services.gif]]>\n  </prop>\n  <prop name=\"icon_image_alt\"><![CDATA[Service Detail]]>\n  </prop>\n</data>',NULL,NULL),(3,'percent_graph','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"notes_url\"><![CDATA[/graphs/cgi-bin/label_graph.cgi?host=$HOSTNAME$&service=$SERVICENAME$]]>\n  </prop>\n  <prop name=\"icon_image\"><![CDATA[services.gif]]>\n  </prop>\n  <prop name=\"icon_image_alt\"><![CDATA[Service Detail]]>\n  </prop>\n</data>',NULL,NULL),(4,'snmp_if','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"notes_url\"><![CDATA[/graphs/cgi-bin/percent_graph.cgi?host=$HOSTNAME$&service=$SERVICENAME$]]>\n  </prop>\n  <prop name=\"icon_image\"><![CDATA[services.gif]]>\n  </prop>\n  <prop name=\"icon_image_alt\"><![CDATA[Service Detail]]>\n  </prop>\n</data>',NULL,NULL),(5,'snmp_ifbandwidth','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"notes_url\"><![CDATA[/graphs/cgi-bin/percent_graph.cgi?host=$HOSTNAME$&service=$SERVICENAME$]]>\n  </prop>\n  <prop name=\"icon_image\"><![CDATA[services.gif]]>\n  </prop>\n  <prop name=\"icon_image_alt\"><![CDATA[Service Detail]]>\n  </prop>\n</data>',NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `extended_service_info_templates` ENABLE KEYS */;

--
-- Table structure for table `external_host`
--

DROP TABLE IF EXISTS `external_host`;
CREATE TABLE `external_host` (
  `external_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  `data` text,
  PRIMARY KEY  (`external_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `external_host_ibfk_1` FOREIGN KEY (`external_id`) REFERENCES `externals` (`external_id`) ON DELETE CASCADE,
  CONSTRAINT `external_host_ibfk_2` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `external_host`
--


/*!40000 ALTER TABLE `external_host` DISABLE KEYS */;
LOCK TABLES `external_host` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `external_host` ENABLE KEYS */;

--
-- Table structure for table `external_host_profile`
--

DROP TABLE IF EXISTS `external_host_profile`;
CREATE TABLE `external_host_profile` (
  `external_id` smallint(4) unsigned NOT NULL default '0',
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`external_id`,`hostprofile_id`),
  KEY `hostprofile_id` (`hostprofile_id`),
  CONSTRAINT `external_host_profile_ibfk_1` FOREIGN KEY (`external_id`) REFERENCES `externals` (`external_id`) ON DELETE CASCADE,
  CONSTRAINT `external_host_profile_ibfk_2` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `external_host_profile`
--


/*!40000 ALTER TABLE `external_host_profile` DISABLE KEYS */;
LOCK TABLES `external_host_profile` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `external_host_profile` ENABLE KEYS */;

--
-- Table structure for table `external_service`
--

DROP TABLE IF EXISTS `external_service`;
CREATE TABLE `external_service` (
  `external_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  `service_id` int(8) unsigned NOT NULL default '0',
  `data` text,
  PRIMARY KEY  (`external_id`,`host_id`,`service_id`),
  KEY `host_id` (`host_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `external_service_ibfk_1` FOREIGN KEY (`external_id`) REFERENCES `externals` (`external_id`) ON DELETE CASCADE,
  CONSTRAINT `external_service_ibfk_2` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `external_service_ibfk_3` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `external_service`
--


/*!40000 ALTER TABLE `external_service` DISABLE KEYS */;
LOCK TABLES `external_service` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `external_service` ENABLE KEYS */;

--
-- Table structure for table `external_service_names`
--

DROP TABLE IF EXISTS `external_service_names`;
CREATE TABLE `external_service_names` (
  `external_id` smallint(4) unsigned NOT NULL default '0',
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`external_id`,`servicename_id`),
  KEY `servicename_id` (`servicename_id`),
  CONSTRAINT `external_service_names_ibfk_1` FOREIGN KEY (`external_id`) REFERENCES `externals` (`external_id`) ON DELETE CASCADE,
  CONSTRAINT `external_service_names_ibfk_2` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `external_service_names`
--


/*!40000 ALTER TABLE `external_service_names` DISABLE KEYS */;
LOCK TABLES `external_service_names` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `external_service_names` ENABLE KEYS */;

--
-- Table structure for table `externals`
--

DROP TABLE IF EXISTS `externals`;
CREATE TABLE `externals` (
  `external_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` varchar(50) default NULL,
  `type` varchar(20) NOT NULL default '',
  `display` text,
  `handler` text,
  PRIMARY KEY  (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `externals`
--


/*!40000 ALTER TABLE `externals` DISABLE KEYS */;
LOCK TABLES `externals` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `externals` ENABLE KEYS */;

--
-- Table structure for table `host_dependencies`
--

DROP TABLE IF EXISTS `host_dependencies`;
CREATE TABLE `host_dependencies` (
  `host_id` int(6) unsigned NOT NULL default '0',
  `parent_id` int(6) unsigned NOT NULL default '0',
  `data` text,
  `comment` text,
  PRIMARY KEY  (`host_id`,`parent_id`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `host_dependencies_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `host_dependencies_ibfk_2` FOREIGN KEY (`parent_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `host_dependencies`
--


/*!40000 ALTER TABLE `host_dependencies` DISABLE KEYS */;
LOCK TABLES `host_dependencies` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `host_dependencies` ENABLE KEYS */;

--
-- Table structure for table `host_overrides`
--

DROP TABLE IF EXISTS `host_overrides`;
CREATE TABLE `host_overrides` (
  `host_id` int(6) unsigned NOT NULL default '0',
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`host_id`),
  CONSTRAINT `host_overrides_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `host_overrides`
--


/*!40000 ALTER TABLE `host_overrides` DISABLE KEYS */;
LOCK TABLES `host_overrides` WRITE;
INSERT INTO `host_overrides` VALUES (1,NULL,3,7,NULL,'<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"max_check_attempts\"><![CDATA[10]]>\n </prop>\n <prop name=\"notification_options\"><![CDATA[d,u,r]]>\n </prop>\n <prop name=\"notification_interval\"><![CDATA[480]]>\n </prop>\n <prop name=\"notification_period\"><![CDATA[3]]>\n </prop>\n</data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `host_overrides` ENABLE KEYS */;

--
-- Table structure for table `host_parent`
--

DROP TABLE IF EXISTS `host_parent`;
CREATE TABLE `host_parent` (
  `host_id` int(6) unsigned NOT NULL default '0',
  `parent_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`host_id`,`parent_id`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `host_parent_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `host_parent_ibfk_2` FOREIGN KEY (`parent_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `host_parent`
--


/*!40000 ALTER TABLE `host_parent` DISABLE KEYS */;
LOCK TABLES `host_parent` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `host_parent` ENABLE KEYS */;

--
-- Table structure for table `host_service`
--

DROP TABLE IF EXISTS `host_service`;
CREATE TABLE `host_service` (
  `host_service_id` smallint(4) unsigned NOT NULL auto_increment,
  `host` varchar(100) NOT NULL default '',
  `service` varchar(100) NOT NULL default '',
  `label` varchar(100) NOT NULL default '',
  `dataname` varchar(100) NOT NULL default '',
  `datatype_id` smallint(4) default '0',
  PRIMARY KEY  (`host_service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `host_service`
--


/*!40000 ALTER TABLE `host_service` DISABLE KEYS */;
LOCK TABLES `host_service` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `host_service` ENABLE KEYS */;

--
-- Table structure for table `host_templates`
--

DROP TABLE IF EXISTS `host_templates`;
CREATE TABLE `host_templates` (
  `hosttemplate_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  `comment` text,
  PRIMARY KEY  (`hosttemplate_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `host_templates`
--


/*!40000 ALTER TABLE `host_templates` DISABLE KEYS */;
LOCK TABLES `host_templates` WRITE;
INSERT INTO `host_templates` VALUES (1,'generic-host',3,3,7,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"flap_detection_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"check_freshness\"><![CDATA[-zero-]]>\n  </prop>\n  <prop name=\"notifications_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"event_handler_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"process_perf_data\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"active_checks_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"passive_checks_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"retain_status_information\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"max_check_attempts\"><![CDATA[3]]>\n  </prop>\n  <prop name=\"notification_options\"><![CDATA[d,u,r]]>\n  </prop>\n  <prop name=\"retain_nonstatus_information\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"obsess_over_host\"><![CDATA[-zero-]]>\n  </prop>\n  <prop name=\"notification_interval\"><![CDATA[60]]>\n  </prop>\n</data>','# Generic host definition template\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `host_templates` ENABLE KEYS */;

--
-- Table structure for table `hostgroup_host`
--

DROP TABLE IF EXISTS `hostgroup_host`;
CREATE TABLE `hostgroup_host` (
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hostgroup_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `hostgroup_host_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `hostgroup_host_ibfk_2` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hostgroup_host`
--


/*!40000 ALTER TABLE `hostgroup_host` DISABLE KEYS */;
LOCK TABLES `hostgroup_host` WRITE;
INSERT INTO `hostgroup_host` VALUES (1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `hostgroup_host` ENABLE KEYS */;

--
-- Table structure for table `hostgroups`
--

DROP TABLE IF EXISTS `hostgroups`;
CREATE TABLE `hostgroups` (
  `hostgroup_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `alias` varchar(255) NOT NULL default '',
  `hostprofile_id` smallint(4) unsigned default NULL,
  `host_escalation_id` smallint(4) unsigned default NULL,
  `service_escalation_id` smallint(4) unsigned default NULL,
  `status` tinyint(1) default NULL,
  `comment` text,
  PRIMARY KEY  (`hostgroup_id`),
  UNIQUE KEY `name` (`name`),
  KEY `hostprofile_id` (`hostprofile_id`),
  KEY `host_escalation_id` (`host_escalation_id`),
  KEY `service_escalation_id` (`service_escalation_id`),
  CONSTRAINT `hostgroups_ibfk_1` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE SET NULL,
  CONSTRAINT `hostgroups_ibfk_2` FOREIGN KEY (`host_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL,
  CONSTRAINT `hostgroups_ibfk_3` FOREIGN KEY (`service_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hostgroups`
--


/*!40000 ALTER TABLE `hostgroups` DISABLE KEYS */;
LOCK TABLES `hostgroups` WRITE;
INSERT INTO `hostgroups` VALUES (1,'Linux Servers','Linux Servers',NULL,NULL,NULL,1,'# \'linux-boxes\' host group definition\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `hostgroups` ENABLE KEYS */;

--
-- Table structure for table `hostprofile_overrides`
--

DROP TABLE IF EXISTS `hostprofile_overrides`;
CREATE TABLE `hostprofile_overrides` (
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`hostprofile_id`),
  CONSTRAINT `hostprofile_overrides_ibfk_1` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hostprofile_overrides`
--


/*!40000 ALTER TABLE `hostprofile_overrides` DISABLE KEYS */;
LOCK TABLES `hostprofile_overrides` WRITE;
INSERT INTO `hostprofile_overrides` VALUES (1,NULL,NULL,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n </data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `hostprofile_overrides` ENABLE KEYS */;

--
-- Table structure for table `hosts`
--

DROP TABLE IF EXISTS `hosts`;
CREATE TABLE `hosts` (
  `host_id` int(6) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `alias` varchar(255) NOT NULL default '',
  `address` varchar(50) NOT NULL default '',
  `os` varchar(50) default NULL,
  `hosttemplate_id` smallint(4) unsigned default NULL,
  `hostextinfo_id` smallint(4) unsigned default NULL,
  `hostprofile_id` smallint(4) unsigned default NULL,
  `host_escalation_id` smallint(4) unsigned default NULL,
  `service_escalation_id` smallint(4) unsigned default NULL,
  `status` tinyint(1) default NULL,
  `comment` text,
  PRIMARY KEY  (`host_id`),
  UNIQUE KEY `name` (`name`),
  KEY `hostextinfo_id` (`hostextinfo_id`),
  KEY `hostprofile_id` (`hostprofile_id`),
  KEY `host_escalation_id` (`host_escalation_id`),
  KEY `service_escalation_id` (`service_escalation_id`),
  CONSTRAINT `hosts_ibfk_1` FOREIGN KEY (`hostextinfo_id`) REFERENCES `extended_host_info_templates` (`hostextinfo_id`) ON DELETE SET NULL,
  CONSTRAINT `hosts_ibfk_2` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE SET NULL,
  CONSTRAINT `hosts_ibfk_3` FOREIGN KEY (`host_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL,
  CONSTRAINT `hosts_ibfk_4` FOREIGN KEY (`service_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hosts`
--


/*!40000 ALTER TABLE `hosts` DISABLE KEYS */;
LOCK TABLES `hosts` WRITE;
INSERT INTO `hosts` VALUES (1,'localhost','Linux Server #1','127.0.0.1','n/a',1,NULL,NULL,NULL,NULL,1,'# \'linux1\' host definition\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `hosts` ENABLE KEYS */;

--
-- Table structure for table `import_column`
--

DROP TABLE IF EXISTS `import_column`;
CREATE TABLE `import_column` (
  `column_id` smallint(4) unsigned NOT NULL auto_increment,
  `schema_id` smallint(4) unsigned default NULL,
  `name` varchar(255) default NULL,
  `position` smallint(4) unsigned default NULL,
  `delimiter` varchar(50) default NULL,
  PRIMARY KEY  (`column_id`),
  KEY `schema_id` (`schema_id`),
  CONSTRAINT `import_column_ibfk_1` FOREIGN KEY (`schema_id`) REFERENCES `import_schema` (`schema_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_column`
--


/*!40000 ALTER TABLE `import_column` DISABLE KEYS */;
LOCK TABLES `import_column` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_column` ENABLE KEYS */;

--
-- Table structure for table `import_hosts`
--

DROP TABLE IF EXISTS `import_hosts`;
CREATE TABLE `import_hosts` (
  `import_hosts_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `alias` varchar(255) default NULL,
  `address` varchar(50) default NULL,
  `hostprofile_id` smallint(4) unsigned default NULL,
  PRIMARY KEY  (`import_hosts_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_hosts`
--


/*!40000 ALTER TABLE `import_hosts` DISABLE KEYS */;
LOCK TABLES `import_hosts` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_hosts` ENABLE KEYS */;

--
-- Table structure for table `import_match`
--

DROP TABLE IF EXISTS `import_match`;
CREATE TABLE `import_match` (
  `match_id` smallint(4) unsigned NOT NULL auto_increment,
  `column_id` smallint(4) unsigned default NULL,
  `name` varchar(255) default NULL,
  `match_order` smallint(4) unsigned default NULL,
  `match_type` varchar(255) default NULL,
  `match_string` varchar(255) default NULL,
  `rule` varchar(255) default NULL,
  `object` varchar(255) default NULL,
  `hostprofile_id` smallint(4) unsigned default NULL,
  `servicename_id` smallint(4) unsigned default NULL,
  `arguments` varchar(255) default NULL,
  PRIMARY KEY  (`match_id`),
  KEY `hostprofile_id` (`hostprofile_id`),
  KEY `column_id` (`column_id`),
  KEY `servicename_id` (`servicename_id`),
  CONSTRAINT `import_match_ibfk_1` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_ibfk_2` FOREIGN KEY (`column_id`) REFERENCES `import_column` (`column_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_ibfk_3` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match`
--


/*!40000 ALTER TABLE `import_match` DISABLE KEYS */;
LOCK TABLES `import_match` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match` ENABLE KEYS */;

--
-- Table structure for table `import_match_contactgroup`
--

DROP TABLE IF EXISTS `import_match_contactgroup`;
CREATE TABLE `import_match_contactgroup` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`contactgroup_id`),
  KEY `contactgroup_id` (`contactgroup_id`),
  CONSTRAINT `import_match_contactgroup_ibfk_1` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_contactgroup_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_contactgroup`
--


/*!40000 ALTER TABLE `import_match_contactgroup` DISABLE KEYS */;
LOCK TABLES `import_match_contactgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_contactgroup` ENABLE KEYS */;

--
-- Table structure for table `import_match_group`
--

DROP TABLE IF EXISTS `import_match_group`;
CREATE TABLE `import_match_group` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `group_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `import_match_group_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_group_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_group`
--


/*!40000 ALTER TABLE `import_match_group` DISABLE KEYS */;
LOCK TABLES `import_match_group` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_group` ENABLE KEYS */;

--
-- Table structure for table `import_match_hostgroup`
--

DROP TABLE IF EXISTS `import_match_hostgroup`;
CREATE TABLE `import_match_hostgroup` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`hostgroup_id`),
  KEY `hostgroup_id` (`hostgroup_id`),
  CONSTRAINT `import_match_hostgroup_ibfk_1` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_hostgroup_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_hostgroup`
--


/*!40000 ALTER TABLE `import_match_hostgroup` DISABLE KEYS */;
LOCK TABLES `import_match_hostgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_hostgroup` ENABLE KEYS */;

--
-- Table structure for table `import_match_parent`
--

DROP TABLE IF EXISTS `import_match_parent`;
CREATE TABLE `import_match_parent` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `parent_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`parent_id`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `import_match_parent_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_parent_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_parent`
--


/*!40000 ALTER TABLE `import_match_parent` DISABLE KEYS */;
LOCK TABLES `import_match_parent` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_parent` ENABLE KEYS */;

--
-- Table structure for table `import_match_servicename`
--

DROP TABLE IF EXISTS `import_match_servicename`;
CREATE TABLE `import_match_servicename` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`servicename_id`),
  KEY `servicename_id` (`servicename_id`),
  CONSTRAINT `import_match_servicename_ibfk_1` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_servicename_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_servicename`
--


/*!40000 ALTER TABLE `import_match_servicename` DISABLE KEYS */;
LOCK TABLES `import_match_servicename` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_servicename` ENABLE KEYS */;

--
-- Table structure for table `import_match_serviceprofile`
--

DROP TABLE IF EXISTS `import_match_serviceprofile`;
CREATE TABLE `import_match_serviceprofile` (
  `match_id` smallint(4) unsigned NOT NULL default '0',
  `serviceprofile_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`match_id`,`serviceprofile_id`),
  KEY `serviceprofile_id` (`serviceprofile_id`),
  CONSTRAINT `import_match_serviceprofile_ibfk_1` FOREIGN KEY (`serviceprofile_id`) REFERENCES `profiles_service` (`serviceprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `import_match_serviceprofile_ibfk_2` FOREIGN KEY (`match_id`) REFERENCES `import_match` (`match_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_match_serviceprofile`
--


/*!40000 ALTER TABLE `import_match_serviceprofile` DISABLE KEYS */;
LOCK TABLES `import_match_serviceprofile` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_match_serviceprofile` ENABLE KEYS */;

--
-- Table structure for table `import_schema`
--

DROP TABLE IF EXISTS `import_schema`;
CREATE TABLE `import_schema` (
  `schema_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `delimiter` varchar(50) default NULL,
  `description` text,
  `type` varchar(255) default NULL,
  `sync_object` varchar(50) default NULL,
  `smart_name` tinyint(1) default '0',
  `hostprofile_id` smallint(4) unsigned default '0',
  `data_source` varchar(255) default NULL,
  PRIMARY KEY  (`schema_id`),
  KEY `hostprofile_id` (`hostprofile_id`),
  CONSTRAINT `import_schema_ibfk_1` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_schema`
--


/*!40000 ALTER TABLE `import_schema` DISABLE KEYS */;
LOCK TABLES `import_schema` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_schema` ENABLE KEYS */;

--
-- Table structure for table `import_services`
--

DROP TABLE IF EXISTS `import_services`;
CREATE TABLE `import_services` (
  `import_services_id` smallint(4) unsigned NOT NULL auto_increment,
  `import_hosts_id` smallint(4) unsigned default NULL,
  `description` varchar(255) default NULL,
  `check_command_id` smallint(4) unsigned default NULL,
  `command_line` varchar(255) default NULL,
  `command_line_trans` varchar(255) default NULL,
  `servicename_id` smallint(4) unsigned default NULL,
  `serviceprofile_id` smallint(4) unsigned default NULL,
  PRIMARY KEY  (`import_services_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `import_services`
--


/*!40000 ALTER TABLE `import_services` DISABLE KEYS */;
LOCK TABLES `import_services` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `import_services` ENABLE KEYS */;

--
-- Table structure for table `monarch_group_child`
--

DROP TABLE IF EXISTS `monarch_group_child`;
CREATE TABLE `monarch_group_child` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `child_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`,`child_id`),
  KEY `child_id` (`child_id`),
  CONSTRAINT `monarch_group_child_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `monarch_group_child_ibfk_2` FOREIGN KEY (`child_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_group_child`
--


/*!40000 ALTER TABLE `monarch_group_child` DISABLE KEYS */;
LOCK TABLES `monarch_group_child` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_group_child` ENABLE KEYS */;

--
-- Table structure for table `monarch_group_host`
--

DROP TABLE IF EXISTS `monarch_group_host`;
CREATE TABLE `monarch_group_host` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `monarch_group_host_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `monarch_group_host_ibfk_2` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_group_host`
--


/*!40000 ALTER TABLE `monarch_group_host` DISABLE KEYS */;
LOCK TABLES `monarch_group_host` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_group_host` ENABLE KEYS */;

--
-- Table structure for table `monarch_group_hostgroup`
--

DROP TABLE IF EXISTS `monarch_group_hostgroup`;
CREATE TABLE `monarch_group_hostgroup` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`,`hostgroup_id`),
  KEY `hostgroup_id` (`hostgroup_id`),
  CONSTRAINT `monarch_group_hostgroup_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `monarch_group_hostgroup_ibfk_2` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_group_hostgroup`
--


/*!40000 ALTER TABLE `monarch_group_hostgroup` DISABLE KEYS */;
LOCK TABLES `monarch_group_hostgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_group_hostgroup` ENABLE KEYS */;

--
-- Table structure for table `monarch_group_macro`
--

DROP TABLE IF EXISTS `monarch_group_macro`;
CREATE TABLE `monarch_group_macro` (
  `group_id` smallint(4) unsigned NOT NULL default '0',
  `macro_id` smallint(4) unsigned NOT NULL default '0',
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`group_id`,`macro_id`),
  KEY `macro_id` (`macro_id`),
  CONSTRAINT `monarch_group_macro_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `monarch_group_macro_ibfk_2` FOREIGN KEY (`macro_id`) REFERENCES `monarch_macros` (`macro_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_group_macro`
--


/*!40000 ALTER TABLE `monarch_group_macro` DISABLE KEYS */;
LOCK TABLES `monarch_group_macro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_group_macro` ENABLE KEYS */;

--
-- Table structure for table `monarch_group_props`
--

DROP TABLE IF EXISTS `monarch_group_props`;
CREATE TABLE `monarch_group_props` (
  `prop_id` smallint(4) unsigned NOT NULL auto_increment,
  `group_id` smallint(4) unsigned default NULL,
  `name` varchar(255) default NULL,
  `type` varchar(20) default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`prop_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `monarch_group_props_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `monarch_groups` (`group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_group_props`
--


/*!40000 ALTER TABLE `monarch_group_props` DISABLE KEYS */;
LOCK TABLES `monarch_group_props` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_group_props` ENABLE KEYS */;

--
-- Table structure for table `monarch_groups`
--

DROP TABLE IF EXISTS `monarch_groups`;
CREATE TABLE `monarch_groups` (
  `group_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `location` text,
  `status` tinyint(1) default '0',
  `data` text,
  PRIMARY KEY  (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_groups`
--


/*!40000 ALTER TABLE `monarch_groups` DISABLE KEYS */;
LOCK TABLES `monarch_groups` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_groups` ENABLE KEYS */;

--
-- Table structure for table `monarch_macros`
--

DROP TABLE IF EXISTS `monarch_macros`;
CREATE TABLE `monarch_macros` (
  `macro_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `value` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  PRIMARY KEY  (`macro_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `monarch_macros`
--


/*!40000 ALTER TABLE `monarch_macros` DISABLE KEYS */;
LOCK TABLES `monarch_macros` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `monarch_macros` ENABLE KEYS */;

--
-- Table structure for table `performanceconfig`
--

DROP TABLE IF EXISTS `performanceconfig`;
CREATE TABLE `performanceconfig` (
  `performanceconfig_id` smallint(4) unsigned NOT NULL auto_increment,
  `host` varchar(100) NOT NULL default '',
  `service` varchar(100) NOT NULL default '',
  `type` varchar(100) NOT NULL default '',
  `enable` tinyint(1) default '0',
  `parseregx_first` tinyint(1) default '0',
  `service_regx` tinyint(1) default '0',
  `label` varchar(100) NOT NULL default '',
  `rrdname` varchar(100) NOT NULL default '',
  `rrdcreatestring` text NOT NULL,
  `rrdupdatestring` text NOT NULL,
  `graphcgi` text NOT NULL default '',
  `perfidstring` varchar(100) NOT NULL default '',
  `parseregx` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`performanceconfig_id`),
  UNIQUE KEY `host` (`host`,`service`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `performanceconfig`
--


/*!40000 ALTER TABLE `performanceconfig` DISABLE KEYS */;
LOCK TABLES `performanceconfig` WRITE;
INSERT INTO `performanceconfig` VALUES (1,'*','Current Load','nagios',1,0,0,'Current Load - 15 Minute Average','/usr/local/groundwork/rrd/$HOST$_Current_Load.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:$LABEL3$:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE3$ 2>&1','/nagios/cgi-bin/label_graph.cgi','',''),(2,'*','Current Users','nagios',1,0,0,'Current Users','/usr/local/groundwork/rrd/$HOST$_Current_Users.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:$LABEL1$:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/label_graph.cgi','',''),(3,'*','Root Partition','nagios',1,0,0,'Disk Utilization','/usr/local/groundwork/rrd/$HOST$_Root_Partition.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:root:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/label_graph.cgi','',''),(4,'*','snmp_if_','nagios',1,1,1,'Interface Statistics','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:in:COUNTER:1800:U:U DS:out:COUNTER:1800:U:U DS:indis:COUNTER:1800:U:U DS:outdis:COUNTER:1800:U:U DS:inerr:COUNTER:1800:U:U  DS:outerr:COUNTER:1800:U:U RRA:AVERAGE:0.5:1:2880 RRA:AVERAGE:0.5:5:4032','$RRDTOOL$ update $RRDNAME$ -t in:out:indis:outdis:inerr:outerr $LASTCHECK$:$VALUE1$:$VALUE2$:$VALUE3$:$VALUE4$:$VALUE5$:$VALUE6$  2>&1','/nagios/cgi-bin/if_graph2.cgi',' ','SNMP OK - (\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)'),(5,'*','snmp_ifbandwidth_','nagios',1,NULL,1,'Interface Bandwidth Utilization','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:in:COUNTER:1800:U:U DS:out:COUNTER:1800:U:U DS:ifspeed:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ -t in:out:ifspeed $LASTCHECK$:$VALUE1$:$VALUE2$:$VALUE3$ 2>&1','/nagios/cgi-bin/if_bandwidth_graph.cgi',' ','SNMP OK - (\\d+)\\s+(\\d+)\\s+(\\d+)'),(6,'*','ssh_memory','nagios',1,NULL,NULL,'Memory Utilization','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:percent:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/percent_graph.cgi',' ','pct:\\s+([\\d\\.]+)'),(7,'*','ssh_swap','nagios',1,1,NULL,'Swap Utilization','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:percent:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/percent_graph.cgi',' ','([\\d\\.]+)% free'),(8,'*','ssh_disk','nagios',1,NULL,1,'Disk Utilization','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:disk:GAUGE:1800:U:U DS:warning:GAUGE:1800:U:U DS:critical:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$:$WARN1$:$CRIT1$ 2>&1','/nagios/cgi-bin/number_graph.cgi',' ',' '),(9,'*','ssh_load','nagios',1,NULL,NULL,'Load Averages','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:load1:GAUGE:1800:U:U DS:load5:GAUGE:1800:U:U DS:load15:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ -t load1:load5:load15 $LASTCHECK$:$VALUE1$:$VALUE2$:$VALUE3$ 2>&1','/nagios/cgi-bin/load_graph.cgi',' ',' '),(10,'*','tcp_ssh','nagios',1,NULL,NULL,'SSH Response Time','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:number:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/number_graph.cgi',' ',' '),(11,'*','ssh_process','nagios',1,1,1,'Process Count','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:number:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/number_graph.cgi',' ','(\\d+) process'),(13,'*','icmp_ping','nagios',1,1,0,'ICMP Ping Response Time','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:rta:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','','',' RTA = ([\\d\\.]+)'),(12,'*','icmp_ping_alive','nagios',1,NULL,NULL,'ICMP Ping Response Time','/usr/local/groundwork/rrd/$HOST$_$SERVICE$.rrd','$RRDTOOL$ create $RRDNAME$ --step 300 --start n-1yr DS:$LABEL1$:GAUGE:1800:U:U RRA:AVERAGE:0.5:1:8640 RRA:AVERAGE:0.5:12:9480','$RRDTOOL$ update $RRDNAME$ $LASTCHECK$:$VALUE1$ 2>&1','/nagios/cgi-bin/label_graph.cgi',' ',' ');
UNLOCK TABLES;
/*!40000 ALTER TABLE `performanceconfig` ENABLE KEYS */;

--
-- Table structure for table `profile_host_profile_service`
--

DROP TABLE IF EXISTS `profile_host_profile_service`;
CREATE TABLE `profile_host_profile_service` (
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  `serviceprofile_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hostprofile_id`,`serviceprofile_id`),
  KEY `serviceprofile_id` (`serviceprofile_id`),
  CONSTRAINT `profile_host_profile_service_ibfk_1` FOREIGN KEY (`serviceprofile_id`) REFERENCES `profiles_service` (`serviceprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `profile_host_profile_service_ibfk_2` FOREIGN KEY (`hostprofile_id`) REFERENCES `profiles_host` (`hostprofile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profile_host_profile_service`
--


/*!40000 ALTER TABLE `profile_host_profile_service` DISABLE KEYS */;
LOCK TABLES `profile_host_profile_service` WRITE;
INSERT INTO `profile_host_profile_service` VALUES (3,2),(2,3),(1,4);
UNLOCK TABLES;
/*!40000 ALTER TABLE `profile_host_profile_service` ENABLE KEYS */;

--
-- Table structure for table `profile_hostgroup`
--

DROP TABLE IF EXISTS `profile_hostgroup`;
CREATE TABLE `profile_hostgroup` (
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hostprofile_id`,`hostgroup_id`),
  KEY `hostgroup_id` (`hostgroup_id`),
  CONSTRAINT `profile_hostgroup_ibfk_1` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profile_hostgroup`
--


/*!40000 ALTER TABLE `profile_hostgroup` DISABLE KEYS */;
LOCK TABLES `profile_hostgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `profile_hostgroup` ENABLE KEYS */;

--
-- Table structure for table `profile_parent`
--

DROP TABLE IF EXISTS `profile_parent`;
CREATE TABLE `profile_parent` (
  `hostprofile_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hostprofile_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `profile_parent_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profile_parent`
--


/*!40000 ALTER TABLE `profile_parent` DISABLE KEYS */;
LOCK TABLES `profile_parent` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `profile_parent` ENABLE KEYS */;

--
-- Table structure for table `profiles_host`
--

DROP TABLE IF EXISTS `profiles_host`;
CREATE TABLE `profiles_host` (
  `hostprofile_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` varchar(255) default NULL,
  `host_template_id` smallint(4) unsigned default NULL,
  `host_extinfo_id` smallint(4) unsigned default NULL,
  `host_escalation_id` smallint(4) unsigned default NULL,
  `service_escalation_id` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`hostprofile_id`),
  UNIQUE KEY `name` (`name`),
  KEY `host_extinfo_id` (`host_extinfo_id`),
  KEY `host_escalation_id` (`host_escalation_id`),
  KEY `service_escalation_id` (`service_escalation_id`),
  CONSTRAINT `profiles_host_ibfk_1` FOREIGN KEY (`host_extinfo_id`) REFERENCES `extended_host_info_templates` (`hostextinfo_id`) ON DELETE SET NULL,
  CONSTRAINT `profiles_host_ibfk_2` FOREIGN KEY (`host_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL,
  CONSTRAINT `profiles_host_ibfk_3` FOREIGN KEY (`service_escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profiles_host`
--


/*!40000 ALTER TABLE `profiles_host` DISABLE KEYS */;
LOCK TABLES `profiles_host` WRITE;
INSERT INTO `profiles_host` VALUES (1,'host-profile-service-ping','Host profile for ping',1,NULL,NULL,NULL,NULL),(2,'host-profile-snmp-network','Host Profile for monitoring network devices using snmp',1,NULL,NULL,NULL,NULL),(3,'host-profile-ssh-unix','Host Profile for monitoring servers using ssh',1,NULL,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"hosts_select\"><![CDATA[checked]]>\n  </prop>\n  <prop name=\"apply_services\"><![CDATA[replace]]>\n  </prop>\n</data>\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `profiles_host` ENABLE KEYS */;

--
-- Table structure for table `profiles_service`
--

DROP TABLE IF EXISTS `profiles_service`;
CREATE TABLE `profiles_service` (
  `serviceprofile_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` varchar(100) default NULL,
  `data` text,
  PRIMARY KEY  (`serviceprofile_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profiles_service`
--


/*!40000 ALTER TABLE `profiles_service` DISABLE KEYS */;
LOCK TABLES `profiles_service` WRITE;
INSERT INTO `profiles_service` VALUES (2,'ssh-unix','SSH UNIX server generic profile','<?xml version=\"1.0\" ?>\n<data>\n</data>'),(3,'snmp-network','network_snmp','<?xml version=\"1.0\" ?>\n<data>\n</data>'),(4,'service-ping','Ping service profile','<?xml version=\"1.0\" ?>\n<data>\n</data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `profiles_service` ENABLE KEYS */;

--
-- Table structure for table `service_dependency`
--

DROP TABLE IF EXISTS `service_dependency`;
CREATE TABLE `service_dependency` (
  `id` int(8) unsigned NOT NULL auto_increment,
  `service_id` int(8) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  `depend_on_host_id` int(6) unsigned NOT NULL default '0',
  `template` smallint(4) unsigned NOT NULL default '0',
  `comment` text,
  PRIMARY KEY  (`id`),
  KEY `service_id` (`service_id`),
  KEY `depend_on_host_id` (`depend_on_host_id`),
  CONSTRAINT `service_dependency_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE,
  CONSTRAINT `service_dependency_ibfk_2` FOREIGN KEY (`depend_on_host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_dependency`
--


/*!40000 ALTER TABLE `service_dependency` DISABLE KEYS */;
LOCK TABLES `service_dependency` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_dependency` ENABLE KEYS */;

--
-- Table structure for table `service_dependency_templates`
--

DROP TABLE IF EXISTS `service_dependency_templates`;
CREATE TABLE `service_dependency_templates` (
  `id` int(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  `data` text,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_dependency_templates`
--


/*!40000 ALTER TABLE `service_dependency_templates` DISABLE KEYS */;
LOCK TABLES `service_dependency_templates` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_dependency_templates` ENABLE KEYS */;

--
-- Table structure for table `service_instance`
--

DROP TABLE IF EXISTS `service_instance`;
CREATE TABLE `service_instance` (
  `instance_id` int(8) unsigned NOT NULL auto_increment,
  `service_id` int(8) unsigned default NULL,
  `name` varchar(255) NOT NULL,
  `status` tinyint(1) default '0',
  `arguments` varchar(255) default NULL,
  PRIMARY KEY  (`instance_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `service_instance_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_instance`
--


/*!40000 ALTER TABLE `service_instance` DISABLE KEYS */;
LOCK TABLES `service_instance` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_instance` ENABLE KEYS */;

--
-- Table structure for table `service_names`
--

DROP TABLE IF EXISTS `service_names`;
CREATE TABLE `service_names` (
  `servicename_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` varchar(100) default NULL,
  `template` smallint(4) unsigned default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `command_line` text,
  `escalation` smallint(4) unsigned default NULL,
  `extinfo` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`servicename_id`),
  UNIQUE KEY `name` (`name`),
  KEY `extinfo` (`extinfo`),
  KEY `escalation` (`escalation`),
  CONSTRAINT `service_names_ibfk_1` FOREIGN KEY (`extinfo`) REFERENCES `extended_service_info_templates` (`serviceextinfo_id`) ON DELETE SET NULL,
  CONSTRAINT `service_names_ibfk_2` FOREIGN KEY (`escalation`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_names`
--


/*!40000 ALTER TABLE `service_names` DISABLE KEYS */;
LOCK TABLES `service_names` WRITE;
INSERT INTO `service_names` VALUES (1,'*','special use',NULL,NULL,NULL,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(2,'Current Load','Current Load',1,1,'check_local_load!5.0,4.0,3.0!10.0,6.0,4.0',NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(3,'Current Users','Current Users',1,16,'check_local_users!20!50',NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(4,'icmp_ping','PING',1,19,'check_ping!100.0,20%!500.0,60%',NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(5,'Root Partition','Root Partition',1,22,'check_local_disk!20%!10%!/',NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(6,'icmp_ping_alive','Ping host to see if it is Alive',1,24,NULL,NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(8,'ssh_disk_root','gwsn-by_ssh_disk',1,26,'check_by_ssh_disk!400!200!/',NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(9,'ssh_load','gwsn-by_ssh_load',1,27,'check_by_ssh_load!5,4,3!10,8,6',NULL,2,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(10,'ssh_memory','gwsn-by_ssh_mem',1,28,'check_by_ssh_mem!80!90',NULL,3,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(11,'ssh_process_count','gwsn-by_ssh_process_count',1,29,'check_by_ssh_process_count!80!100',NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(12,'ssh_swap','ssh_swap',1,30,'check_by_ssh_swap!20%!10%',NULL,3,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(13,'udp_snmp','gwsn-snmp',1,263,NULL,NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(14,'snmp_if_1','gwsn-snmp_if',1,32,'check_snmp_if!1',NULL,5,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(15,'snmp_ifbandwidth_1','SNMP_if_bandwidth',1,33,'check_snmp_bandwidth!1',NULL,5,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(16,'snmp_ifoperstatus_1','SNMP_ifoperstatus',1,34,'check_ifoperstatus!1',NULL,5,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(17,'tcp_http','check http server at host',1,11,'check_http!3!5',NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(20,'local_mysql_engine','gwsn-local_mysql_engine',1,38,'check_mysql_engine!root!d3v3l0p3r',NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(64,'nrpe_disk','check disk on nrpe server',1,66,'check_nrpe_disk!*!80,90',NULL,3,'<?xml version=\"1.0\" ?>\n<data>\n</data>'),(169,'tcp_ssh','Check SSH server running at host',1,161,NULL,NULL,1,'<?xml version=\"1.0\" ?>\n<data>\n</data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_names` ENABLE KEYS */;

--
-- Table structure for table `service_overrides`
--

DROP TABLE IF EXISTS `service_overrides`;
CREATE TABLE `service_overrides` (
  `service_id` int(8) unsigned NOT NULL default '0',
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`service_id`),
  CONSTRAINT `service_overrides_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_overrides`
--


/*!40000 ALTER TABLE `service_overrides` DISABLE KEYS */;
LOCK TABLES `service_overrides` WRITE;
INSERT INTO `service_overrides` VALUES (1,3,3,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"freshness_threshold\"><![CDATA[10]]>\n  </prop>\n  <prop name=\"normal_check_interval\"><![CDATA[5]]>\n  </prop>\n  <prop name=\"retry_check_interval\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"max_check_attempts\"><![CDATA[4]]>\n  </prop>\n  <prop name=\"notification_interval\"><![CDATA[960]]>\n  </prop>\n </data>'),(2,3,3,NULL,'<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"max_check_attempts\"><![CDATA[4]]>\n </prop>\n <prop name=\"retry_check_interval\"><![CDATA[1]]>\n </prop>\n <prop name=\"normal_check_interval\"><![CDATA[5]]>\n </prop>\n <prop name=\"notification_interval\"><![CDATA[960]]>\n </prop>\n</data>'),(3,3,3,NULL,'<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"max_check_attempts\"><![CDATA[4]]>\n </prop>\n <prop name=\"retry_check_interval\"><![CDATA[1]]>\n </prop>\n <prop name=\"normal_check_interval\"><![CDATA[5]]>\n </prop>\n <prop name=\"notification_interval\"><![CDATA[960]]>\n </prop>\n</data>'),(4,3,3,NULL,'<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"max_check_attempts\"><![CDATA[4]]>\n </prop>\n <prop name=\"retry_check_interval\"><![CDATA[1]]>\n </prop>\n <prop name=\"normal_check_interval\"><![CDATA[5]]>\n </prop>\n <prop name=\"notification_interval\"><![CDATA[960]]>\n </prop>\n</data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_overrides` ENABLE KEYS */;

--
-- Table structure for table `service_templates`
--

DROP TABLE IF EXISTS `service_templates`;
CREATE TABLE `service_templates` (
  `servicetemplate_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `parent_id` smallint(4) unsigned default NULL,
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `command_line` text,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  `comment` text,
  PRIMARY KEY  (`servicetemplate_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `service_templates`
--


/*!40000 ALTER TABLE `service_templates` DISABLE KEYS */;
LOCK TABLES `service_templates` WRITE;
INSERT INTO `service_templates` VALUES (1,'generic-service',3,3,3,NULL,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"flap_detection_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"retry_check_interval\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"notifications_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"event_handler_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"process_perf_data\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"active_checks_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"passive_checks_enabled\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"retain_status_information\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"max_check_attempts\"><![CDATA[3]]>\n  </prop>\n  <prop name=\"parallelize_check\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"notification_options\"><![CDATA[u,c,w,r]]>\n  </prop>\n  <prop name=\"retain_nonstatus_information\"><![CDATA[1]]>\n  </prop>\n  <prop name=\"normal_check_interval\"><![CDATA[10]]>\n  </prop>\n  <prop name=\"notification_interval\"><![CDATA[60]]>\n  </prop>\n  <prop name=\"obsess_over_service\"><![CDATA[1]]>\n  </prop>\n</data>','# Generic service definition template - This is NOT a real service, just a template!\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `service_templates` ENABLE KEYS */;

--
-- Table structure for table `servicegroup_service`
--

DROP TABLE IF EXISTS `servicegroup_service`;
CREATE TABLE `servicegroup_service` (
  `servicegroup_id` int(6) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  `service_id` int(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`servicegroup_id`,`host_id`,`service_id`),
  KEY `host_id` (`host_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `servicegroup_service_ibfk_1` FOREIGN KEY (`servicegroup_id`) REFERENCES `servicegroups` (`servicegroup_id`) ON DELETE CASCADE,
  CONSTRAINT `servicegroup_service_ibfk_2` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `servicegroup_service_ibfk_3` FOREIGN KEY (`service_id`) REFERENCES `services` (`service_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicegroup_service`
--


/*!40000 ALTER TABLE `servicegroup_service` DISABLE KEYS */;
LOCK TABLES `servicegroup_service` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `servicegroup_service` ENABLE KEYS */;

--
-- Table structure for table `servicegroups`
--

DROP TABLE IF EXISTS `servicegroups`;
CREATE TABLE `servicegroups` (
  `servicegroup_id` int(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `alias` varchar(255) NOT NULL default '',
  `escalation_id` smallint(4) unsigned default NULL,
  PRIMARY KEY  (`servicegroup_id`),
  UNIQUE KEY `name` (`name`),
  KEY `escalation_id` (`escalation_id`),
  CONSTRAINT `servicegroups_ibfk_1` FOREIGN KEY (`escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicegroups`
--


/*!40000 ALTER TABLE `servicegroups` DISABLE KEYS */;
LOCK TABLES `servicegroups` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `servicegroups` ENABLE KEYS */;

--
-- Table structure for table `servicename_dependency`
--

DROP TABLE IF EXISTS `servicename_dependency`;
CREATE TABLE `servicename_dependency` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  `depend_on_host_id` int(6) unsigned default NULL,
  `template` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `servicename_id` (`servicename_id`),
  KEY `depend_on_host_id` (`depend_on_host_id`),
  CONSTRAINT `servicename_dependency_ibfk_1` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE,
  CONSTRAINT `servicename_dependency_ibfk_2` FOREIGN KEY (`depend_on_host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicename_dependency`
--


/*!40000 ALTER TABLE `servicename_dependency` DISABLE KEYS */;
LOCK TABLES `servicename_dependency` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `servicename_dependency` ENABLE KEYS */;

--
-- Table structure for table `servicename_overrides`
--

DROP TABLE IF EXISTS `servicename_overrides`;
CREATE TABLE `servicename_overrides` (
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  `check_period` smallint(4) unsigned default NULL,
  `notification_period` smallint(4) unsigned default NULL,
  `event_handler` smallint(4) unsigned default NULL,
  `data` text,
  PRIMARY KEY  (`servicename_id`),
  CONSTRAINT `servicename_overrides_ibfk_1` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicename_overrides`
--


/*!40000 ALTER TABLE `servicename_overrides` DISABLE KEYS */;
LOCK TABLES `servicename_overrides` WRITE;
INSERT INTO `servicename_overrides` VALUES (16,NULL,NULL,NULL,'<?xml version=\"1.0\" ?>\n<data>\n </data>');
UNLOCK TABLES;
/*!40000 ALTER TABLE `servicename_overrides` ENABLE KEYS */;

--
-- Table structure for table `serviceprofile`
--

DROP TABLE IF EXISTS `serviceprofile`;
CREATE TABLE `serviceprofile` (
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  `serviceprofile_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`servicename_id`,`serviceprofile_id`),
  KEY `serviceprofile_id` (`serviceprofile_id`),
  CONSTRAINT `serviceprofile_ibfk_1` FOREIGN KEY (`servicename_id`) REFERENCES `service_names` (`servicename_id`) ON DELETE CASCADE,
  CONSTRAINT `serviceprofile_ibfk_2` FOREIGN KEY (`serviceprofile_id`) REFERENCES `profiles_service` (`serviceprofile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `serviceprofile`
--


/*!40000 ALTER TABLE `serviceprofile` DISABLE KEYS */;
LOCK TABLES `serviceprofile` WRITE;
INSERT INTO `serviceprofile` VALUES (8,2),(9,2),(10,2),(11,2),(12,2),(169,2),(13,3),(14,3),(15,3),(16,3),(6,4);
UNLOCK TABLES;
/*!40000 ALTER TABLE `serviceprofile` ENABLE KEYS */;

--
-- Table structure for table `serviceprofile_host`
--

DROP TABLE IF EXISTS `serviceprofile_host`;
CREATE TABLE `serviceprofile_host` (
  `serviceprofile_id` smallint(4) unsigned NOT NULL default '0',
  `host_id` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`serviceprofile_id`,`host_id`),
  KEY `host_id` (`host_id`),
  CONSTRAINT `serviceprofile_host_ibfk_1` FOREIGN KEY (`serviceprofile_id`) REFERENCES `profiles_service` (`serviceprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `serviceprofile_host_ibfk_2` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `serviceprofile_host`
--


/*!40000 ALTER TABLE `serviceprofile_host` DISABLE KEYS */;
LOCK TABLES `serviceprofile_host` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `serviceprofile_host` ENABLE KEYS */;

--
-- Table structure for table `serviceprofile_hostgroup`
--

DROP TABLE IF EXISTS `serviceprofile_hostgroup`;
CREATE TABLE `serviceprofile_hostgroup` (
  `serviceprofile_id` smallint(4) unsigned NOT NULL default '0',
  `hostgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`serviceprofile_id`,`hostgroup_id`),
  KEY `hostgroup_id` (`hostgroup_id`),
  CONSTRAINT `serviceprofile_hostgroup_ibfk_1` FOREIGN KEY (`serviceprofile_id`) REFERENCES `profiles_service` (`serviceprofile_id`) ON DELETE CASCADE,
  CONSTRAINT `serviceprofile_hostgroup_ibfk_2` FOREIGN KEY (`hostgroup_id`) REFERENCES `hostgroups` (`hostgroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `serviceprofile_hostgroup`
--


/*!40000 ALTER TABLE `serviceprofile_hostgroup` DISABLE KEYS */;
LOCK TABLES `serviceprofile_hostgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `serviceprofile_hostgroup` ENABLE KEYS */;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
  `service_id` int(8) unsigned NOT NULL auto_increment,
  `host_id` int(6) unsigned NOT NULL default '0',
  `servicename_id` smallint(4) unsigned NOT NULL default '0',
  `servicetemplate_id` smallint(4) unsigned default NULL,
  `serviceextinfo_id` smallint(4) unsigned default NULL,
  `escalation_id` smallint(4) unsigned default NULL,
  `status` tinyint(1) default NULL,
  `check_command` smallint(4) unsigned default NULL,
  `command_line` text,
  `comment` text,
  PRIMARY KEY  (`service_id`),
  KEY `host_id` (`host_id`),
  KEY `serviceextinfo_id` (`serviceextinfo_id`),
  KEY `escalation_id` (`escalation_id`),
  CONSTRAINT `services_ibfk_1` FOREIGN KEY (`host_id`) REFERENCES `hosts` (`host_id`) ON DELETE CASCADE,
  CONSTRAINT `services_ibfk_2` FOREIGN KEY (`serviceextinfo_id`) REFERENCES `extended_service_info_templates` (`serviceextinfo_id`) ON DELETE SET NULL,
  CONSTRAINT `services_ibfk_3` FOREIGN KEY (`escalation_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `services`
--


/*!40000 ALTER TABLE `services` DISABLE KEYS */;
LOCK TABLES `services` WRITE;
INSERT INTO `services` VALUES (1,1,2,1,NULL,NULL,1,1,'check_local_load!5.0,4.0,3.0!10.0,6.0,4.0','# Define a service to check the load on the local machine.\n'),(2,1,3,1,NULL,NULL,1,16,'check_local_users!20!50','# if > 50 users.\n'),(3,1,4,1,NULL,NULL,1,19,'check_ping!100.0,20%!500.0,60%','# Define a service to \"ping\" the local machine\n'),(4,1,5,1,NULL,NULL,1,22,'check_local_disk!20%!10%!/','# < 10% free space on partition.\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `services` ENABLE KEYS */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` char(32) NOT NULL,
  `a_session` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sessions`
--


/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
LOCK TABLES `sessions` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;

--
-- Table structure for table `setup`
--

DROP TABLE IF EXISTS `setup`;
CREATE TABLE `setup` (
  `name` varchar(255) NOT NULL default '',
  `type` varchar(50) default NULL,
  `value` text,
  PRIMARY KEY  (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `setup`
--


/*!40000 ALTER TABLE `setup` DISABLE KEYS */;
LOCK TABLES `setup` WRITE;
INSERT INTO `setup` VALUES ('accept_passive_host_checks','nagios','1'),('accept_passive_service_checks','nagios','1'),('admin_email','nagios','nagios@localhost'),('admin_pager','nagios','pagenagios@localhost'),('aggregate_status_updates','nagios','1'),('authorized_for_all_hosts','nagios_cgi','nagiosadmin,guest'),('authorized_for_all_host_commands','nagios_cgi','nagiosadmin'),('authorized_for_all_services','nagios_cgi','nagiosadmin,guest'),('authorized_for_all_service_commands','nagios_cgi','nagiosadmin'),('authorized_for_configuration_information','nagios_cgi','nagiosadmin,jdoe'),('authorized_for_system_commands','nagios_cgi','nagiosadmin'),('authorized_for_system_information','nagios_cgi','nagiosadmin,theboss,jdoe'),('auto_reschedule_checks','nagios',NULL),('auto_rescheduling_interval','nagios','30'),('auto_rescheduling_window','nagios','180'),('backup_dir','config','/usr/local/groundwork/monarch/backup'),('cgi_bin','config','0'),('check_external_commands','nagios','1'),('check_for_orphaned_services','nagios','0'),('check_host_freshness','nagios',NULL),('check_service_freshness','nagios',NULL),('commands','file','26'),('command_check_interval','nagios','1'),('command_file','nagios','/usr/local/groundwork/nagios/var/spool/nagios.cmd'),('comment_file','nagios','/usr/local/groundwork/nagios/var/nagioscomment.log'),('contactgroup','monarch_ez','nagiosadmin'),('contactgroups','file','30'),('contacts','file','31'),('contact_template','monarch_ez','generic-contact-2'),('contact_templates','file','29'),('date_format','nagios','us'),('default_statusmap_layout','nagios_cgi','5'),('default_statuswrl_layout','nagios_cgi','2'),('default_user_name','nagios_cgi','nagiosadmin'),('doc_root','config','0'),('downtime_file','nagios','/usr/local/groundwork/nagios/var/nagiosdowntime.log'),('enable_event_handlers','nagios','1'),('enable_externals','config','0'),('enable_flap_detection','nagios',NULL),('enable_groups','config','0'),('enable_notifications','nagios',NULL),('escalations','file','35'),('escalation_templates','file','18'),('event_handler_timeout','nagios','30'),('execute_host_checks','nagios','1'),('execute_service_checks','nagios','1'),('extended_host_info','file','36'),('extended_host_info_templates','file','22'),('extended_service_info','file','21'),('extended_service_info_templates','file','20'),('freshness_check_interval','nagios','60'),('global_host_event_handler','nagios',NULL),('global_service_event_handler','nagios',NULL),('high_host_flap_threshold','nagios','50.0'),('high_service_flap_threshold','nagios','50.0'),('hostgroups','file','33'),('hosts','file','13'),('host_check_timeout','nagios','30'),('host_dependencies','file','23'),('host_down_sound','nagios_cgi',NULL),('host_freshness_check_interval','nagios','60'),('host_inter_check_delay_method','nagios','s'),('host_perfdata_command','nagios',NULL),('host_perfdata_file','nagios',NULL),('host_perfdata_file_mode','nagios','w'),('host_perfdata_file_processing_command','nagios',NULL),('host_perfdata_file_processing_interval','nagios',NULL),('host_perfdata_file_template','nagios',NULL),('host_profile','monarch_ez','host-profile-service-ping'),('host_templates','file','32'),('host_unreachable_sound','nagios_cgi',NULL),('illegal_macro_output_chars','nagios','`~$&|\'\"<>'),('illegal_object_name_chars','nagios','`~!$%^&*|\'\"<>?,()\'='),('interval_length','nagios','60'),('is_portal','config','1'),('lock_file','nagios','/usr/local/groundwork/nagios/var/nagios.lock'),('login_authentication','','none'),('log_archive_path','nagios','/usr/local/groundwork/nagios/var/archives'),('log_event_handlers','nagios','1'),('log_external_commands','nagios','1'),('log_file','nagios','/usr/local/groundwork/nagios/var/nagios.log'),('log_host_retries','nagios','1'),('log_initial_states','nagios',NULL),('log_notifications','nagios','1'),('log_passive_checks','nagios','1'),('log_passive_service_checks','nagios',NULL),('log_rotation_method','nagios','d'),('log_service_retries','nagios','1'),('low_host_flap_threshold','nagios','25.0'),('low_service_flap_threshold','nagios','25.0'),('max_concurrent_checks','nagios',NULL),('check_result_path','nagios','/usr/local/groundwork/nagios/var/checkresults'),('max_host_check_spread','nagios','30'),('max_service_check_spread','nagios','30'),('max_tree_nodes','config','3000'),('misccommands','file','27'),('monarch_home','config','/usr/local/groundwork/monarch'),('monarch_version','config','2.1'),('nagios_bin','config','/usr/local/groundwork/nagios/bin'),('nagios_check_command','nagios_cgi','/usr/local/groundwork/nagios/libexec/check_nagios /usr/local/groundwork/nagios/var/status.log 5 \'/usr/local/groundwork/nagios/bin/nagios\''),('nagios_etc','config','/usr/local/groundwork/nagios/etc'),('nagios_group','nagios','nagios'),('nagios_user','nagios','nagios'),('nagios_version','config','2.x'),('notification_timeout','nagios','30'),('object_cache_file','nagios','/usr/local/groundwork/nagios/var/objects.cache'),('precached_object_file','nagios','/usr/local/groundwork/nagios/var/objects.precache'),('obsess_over_hosts','nagios',NULL),('obsess_over_services','nagios',NULL),('ochp_command','nagios',NULL),('ochp_timeout','nagios','5'),('ocsp_command','nagios',NULL),('ocsp_timeout','nagios','5'),('other_host_inter_check_delay_method','nagios',NULL),('other_service_interleave_factor','nagios',NULL),('other_service_inter_check_delay_method','nagios',NULL),('perfdata_timeout','nagios','60'),('physical_html_path','nagios_cgi','/usr/local/groundwork/nagios/share'),('ping_syntax','nagios_cgi','/bin/ping -n -U -c 5 $HOSTADDRESS$'),('process_performance_data','nagios','1'),('refresh_rate','nagios_cgi','90'),('resource_file','nagios','/usr/local/groundwork/nagios/etc/resource.cfg'),('resource_label1','resource','Plugin directory'),('resource_label10','resource',''),('resource_label11','resource',''),('resource_label12','resource',''),('resource_label13','resource','Sendmail Reply option (-s <smtpmailrelay>) '),('resource_label14','resource',''),('resource_label15','resource',''),('resource_label16','resource',''),('resource_label17','resource',NULL),('resource_label18','resource',NULL),('resource_label19','resource','NSClient TCP Port'),('resource_label2','resource','Eventhandler scripts directory'),('resource_label20','resource',''),('resource_label21','resource','GroundWork Proxy Server IP'),('resource_label22','resource',NULL),('resource_label23','resource',''),('resource_label24','resource',''),('resource_label25','resource',''),('resource_label26','resource',''),('resource_label27','resource',''),('resource_label28','resource',''),('resource_label29','resource',''),('resource_label3','resource','plug-in timeout'),('resource_label30','resource',''),('resource_label31','resource',''),('resource_label32','resource',''),('resource_label4','resource','NSClient password'),('resource_label5','resource',''),('resource_label6','resource',NULL),('resource_label7','resource','SNMP Community string'),('resource_label8','resource',NULL),('resource_label9','resource',''),('retain_state_information','nagios','1'),('retention_update_interval','nagios','60'),('servicegroups','file','15'),('services','file','19'),('service_check_timeout','nagios','60'),('service_critical_sound','nagios_cgi',NULL),('service_dependency','file','17'),('service_dependency_templates','file','16'),('service_interleave_factor','nagios','s'),('service_inter_check_delay_method','nagios','s'),('service_perfdata_command','nagios',NULL),('service_perfdata_file','nagios','/usr/local/groundwork/nagios/eventhandlers/service_perfdata.log'),('service_perfdata_file_mode','nagios','w'),('service_perfdata_file_processing_command','nagios','process_service_perfdata_file'),('service_perfdata_file_processing_interval','nagios','300'),('service_perfdata_file_template','nagios','$LASTSERVICECHECK$\\t$HOSTNAME$\\t$SERVICEDESC$\\t$SERVICEOUTPUT$\\t$SERVICEPERFDATA$'),('service_reaper_frequency','nagios','10'),('service_templates','file','34'),('service_unknown_sound','nagios_cgi',NULL),('service_warning_sound','nagios_cgi',NULL),('session_timeout','','3600'),('show_context_help','nagios_cgi','1'),('sleep_time','nagios','1'),('soft_state_dependencies','nagios',NULL),('state_retention_file','nagios','/usr/local/groundwork/nagios/var/nagiosstatus.sav'),('statusmap_background_image','nagios_cgi','states.png'),('statuswrl_include','nagios_cgi','myworld.wrl'),('status_file','nagios','/usr/local/groundwork/nagios/var/status.log'),('status_update_interval','nagios','15'),('super_user_password','',''),('task','nagios','view_edit'),('temp_file','nagios','/usr/local/groundwork/nagios/var/nagios.tmp'),('time_periods','file','28'),('upload_dir','config','/tmp'),('url_html_path','nagios_cgi','/nagios'),('user1','resource','/usr/local/groundwork/nagios/libexec'),('user10','resource',''),('user11','resource',''),('user12','resource',''),('user13','resource','127.0.0.1'),('user14','resource',''),('user15','resource',''),('user16','resource',''),('user17','resource','nagios'),('user18','resource','/home/nagios'),('user19','resource','1248'),('user2','resource','/usr/local/groundwork/nagios/eventhandlers'),('user20','resource',''),('user21','resource','127.0.0.1'),('user22','resource','libexec'),('user23','resource',''),('user24','resource',''),('user25','resource',''),('user26','resource',''),('user27','resource',''),('user28','resource',''),('user29','resource',''),('user3','resource','60'),('user30','resource',''),('user31','resource',''),('user32','resource',''),('user4','resource','somepassword'),('user5','resource',''),('user6','resource',''),('user7','resource','public'),('user8','resource','itgwrk'),('user9','resource',''),('use_agressive_host_checking','nagios',NULL),('use_authentication','nagios_cgi','1'),('use_regexp_matching','nagios',NULL),('use_retained_program_state','nagios','1'),('use_retained_scheduling_info','nagios','1'),('use_syslog','nagios','0'),('use_true_regexp_matching','nagios',NULL),('perflogbug_workaround_removed','nagios','1');
UNLOCK TABLES;
/*!40000 ALTER TABLE `setup` ENABLE KEYS */;

--
-- Table structure for table `stage_host_hostgroups`
--

DROP TABLE IF EXISTS `stage_host_hostgroups`;
CREATE TABLE `stage_host_hostgroups` (
  `name` varchar(255) NOT NULL default '',
  `user_acct` varchar(50) NOT NULL default '',
  `hostgroup` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`name`,`user_acct`,`hostgroup`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `stage_host_hostgroups`
--


/*!40000 ALTER TABLE `stage_host_hostgroups` DISABLE KEYS */;
LOCK TABLES `stage_host_hostgroups` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `stage_host_hostgroups` ENABLE KEYS */;

--
-- Table structure for table `stage_host_services`
--

DROP TABLE IF EXISTS `stage_host_services`;
CREATE TABLE `stage_host_services` (
  `name` varchar(255) NOT NULL default '',
  `user_acct` varchar(50) NOT NULL default '',
  `host` varchar(50) NOT NULL default '',
  `type` varchar(20) default NULL,
  `status` tinyint(1) default NULL,
  `service_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`name`,`user_acct`,`host`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `stage_host_services`
--


/*!40000 ALTER TABLE `stage_host_services` DISABLE KEYS */;
LOCK TABLES `stage_host_services` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `stage_host_services` ENABLE KEYS */;

--
-- Table structure for table `stage_hosts`
--

DROP TABLE IF EXISTS `stage_hosts`;
CREATE TABLE `stage_hosts` (
  `name` varchar(255) NOT NULL default '',
  `user_acct` varchar(50) NOT NULL default '',
  `type` varchar(20) default NULL,
  `status` tinyint(1) default NULL,
  `alias` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `os` varchar(50) default NULL,
  `hostprofile` varchar(50) default NULL,
  `serviceprofile` varchar(50) default NULL,
  `info` varchar(50) default NULL,
  PRIMARY KEY  (`name`,`user_acct`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `stage_hosts`
--


/*!40000 ALTER TABLE `stage_hosts` DISABLE KEYS */;
LOCK TABLES `stage_hosts` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `stage_hosts` ENABLE KEYS */;

--
-- Table structure for table `stage_other`
--

DROP TABLE IF EXISTS `stage_other`;
CREATE TABLE `stage_other` (
  `name` varchar(255) NOT NULL default '',
  `type` varchar(50) NOT NULL default '',
  `parent` varchar(255) NOT NULL default '',
  `data` text,
  `comment` text,
  PRIMARY KEY  (`name`,`type`,`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `stage_other`
--


/*!40000 ALTER TABLE `stage_other` DISABLE KEYS */;
LOCK TABLES `stage_other` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `stage_other` ENABLE KEYS */;

--
-- Table structure for table `time_periods`
--

DROP TABLE IF EXISTS `time_periods`;
CREATE TABLE `time_periods` (
  `timeperiod_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `alias` varchar(255) NOT NULL default '',
  `data` text,
  `comment` text,
  PRIMARY KEY  (`timeperiod_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `time_periods`
--


/*!40000 ALTER TABLE `time_periods` DISABLE KEYS */;
LOCK TABLES `time_periods` WRITE;
INSERT INTO `time_periods` VALUES (1,'none','No Time Is A Good Time','<?xml version=\"1.0\" ?>\n<data>\n</data>','# \'none\' timeperiod definition\n'),(2,'workhours','\"Normal\" Working Hours','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"monday\"><![CDATA[09:00-17:00]]>\n </prop>\n <prop name=\"friday\"><![CDATA[09:00-17:00]]>\n </prop>\n <prop name=\"tuesday\"><![CDATA[09:00-17:00]]>\n </prop>\n <prop name=\"wednesday\"><![CDATA[09:00-17:00]]>\n </prop>\n <prop name=\"thursday\"><![CDATA[09:00-17:00]]>\n </prop>\n</data>','# \'workhours\' timeperiod definition\n'),(3,'24x7','24 Hours A Day, 7 Days A Week','<?xml version=\"1.0\" ?>\n<data>\n  <prop name=\"sunday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"monday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"friday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"tuesday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"saturday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"wednesday\"><![CDATA[00:00-24:00]]>\n  </prop>\n  <prop name=\"thursday\"><![CDATA[00:00-24:00]]>\n  </prop>\n</data>','###############################################################################\n'),(4,'nonworkhours','Non-Work Hours','<?xml version=\"1.0\" ?>\n<data>\n <prop name=\"sunday\"><![CDATA[00:00-24:00]]>\n </prop>\n <prop name=\"monday\"><![CDATA[00:00-09:00,17:00-24:00]]>\n </prop>\n <prop name=\"friday\"><![CDATA[00:00-09:00,17:00-24:00]]>\n </prop>\n <prop name=\"tuesday\"><![CDATA[00:00-09:00,17:00-24:00]]>\n </prop>\n <prop name=\"saturday\"><![CDATA[00:00-24:00]]>\n </prop>\n <prop name=\"wednesday\"><![CDATA[00:00-09:00,17:00-24:00]]>\n </prop>\n <prop name=\"thursday\"><![CDATA[00:00-09:00,17:00-24:00]]>\n </prop>\n</data>','# \'nonworkhours\' timeperiod definition\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_periods` ENABLE KEYS */;

--
-- Table structure for table `tree_template_contactgroup`
--

DROP TABLE IF EXISTS `tree_template_contactgroup`;
CREATE TABLE `tree_template_contactgroup` (
  `tree_id` smallint(4) unsigned NOT NULL default '0',
  `template_id` smallint(4) unsigned NOT NULL default '0',
  `contactgroup_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tree_id`,`template_id`,`contactgroup_id`),
  KEY `contactgroup_id` (`contactgroup_id`),
  KEY `template_id` (`template_id`),
  CONSTRAINT `tree_template_contactgroup_ibfk_1` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE,
  CONSTRAINT `tree_template_contactgroup_ibfk_2` FOREIGN KEY (`template_id`) REFERENCES `escalation_templates` (`template_id`) ON DELETE CASCADE,
  CONSTRAINT `tree_template_contactgroup_ibfk_3` FOREIGN KEY (`tree_id`) REFERENCES `escalation_trees` (`tree_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tree_template_contactgroup`
--


/*!40000 ALTER TABLE `tree_template_contactgroup` DISABLE KEYS */;
LOCK TABLES `tree_template_contactgroup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `tree_template_contactgroup` ENABLE KEYS */;

--
-- Table structure for table `user_group`
--

DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group` (
  `usergroup_id` smallint(4) unsigned NOT NULL default '0',
  `user_id` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`usergroup_id`,`user_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `user_group_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `user_group_ibfk_2` FOREIGN KEY (`usergroup_id`) REFERENCES `user_groups` (`usergroup_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `user_group`
--


/*!40000 ALTER TABLE `user_group` DISABLE KEYS */;
LOCK TABLES `user_group` WRITE;
INSERT INTO `user_group` VALUES (1,1),(1,2);
UNLOCK TABLES;
/*!40000 ALTER TABLE `user_group` ENABLE KEYS */;

--
-- Table structure for table `user_groups`
--

DROP TABLE IF EXISTS `user_groups`;
CREATE TABLE `user_groups` (
  `usergroup_id` smallint(4) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` varchar(100) default NULL,
  PRIMARY KEY  (`usergroup_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `user_groups`
--


/*!40000 ALTER TABLE `user_groups` DISABLE KEYS */;
LOCK TABLES `user_groups` WRITE;
INSERT INTO `user_groups` VALUES (1,'super_users','System defined group granted complete access.');
UNLOCK TABLES;
/*!40000 ALTER TABLE `user_groups` ENABLE KEYS */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` smallint(4) unsigned NOT NULL auto_increment,
  `user_acct` varchar(20) NOT NULL default '',
  `user_name` varchar(255) NOT NULL default '',
  `password` varchar(20) NOT NULL default '',
  `session` varchar(255) default NULL,
  PRIMARY KEY  (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users`
--


/*!40000 ALTER TABLE `users` DISABLE KEYS */;
LOCK TABLES `users` WRITE;
INSERT INTO `users` VALUES (1,'super_user','Super User Account','Py.Z3VRXrRE3k','4c624a9aa462261d61527a2f10f13d6a'),(2,'admin','admin','','37e6c7e3efc3ed84716764193181dd31');
UNLOCK TABLES;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

