# MonArch - Groundwork Monitor Architect
# MonarchTree.pm
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use strict;
use URI::Escape;
use MonarchInstrument;
package Tree;

my $doc_root_monarch = "/monarch";
my $cgi_dir = '/cgi-bin';
my $form_class = 'row1';
my $form_subclass = '$form_class';
my $global_cell_pad = 3;
my $cgi_exe = 'monarch.cgi';
if (-e "/usr/local/groundwork/config/db.properties") {
	$cgi_dir = '/monarch/cgi-bin';
}
my $debug = 0;

sub header(@) {
	my $title = $_[1];
	my $load_main = undef;
	unless ($_[2]) { $load_main = "\"onload=\"parent.monarch_main.location=\'/monarch/blank.html\'\"" }
	return qq(
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>@{[&$Instrument::show_trace_as_html_comment()]}
<title>$title</title>
<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<link rel="stylesheet" type="text/css" href="$doc_root_monarch/monarch.css" />
<SCRIPT language=javascript1.1 src="$doc_root_monarch/monarch.js"></SCRIPT>
<script src="$doc_root_monarch/nicetitle.js" type="text/javascript"></script>
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
<link rel="StyleSheet" href="$doc_root_monarch/dtree.css" type="text/css" />
</head>
<body bgcolor=#f0f0f0 $load_main >
<!-- generated by: MonarchTree::header() -->);
}

sub get_ajax_url() {
	my $nocache = time;
	return "$cgi_dir/monarch_tree.cgi?nocache=$nocache";
}

sub footer(@) {
	my $debug = $_[1];
	return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
</td>
</tr>
</table>
</body>
</html>);
}

my %obj = (
	'host_wizard' => 'hosts'
	);


my %gif = (
	'search' => 'search.gif',
	'search_host' => 'search.gif',
	'search_service' => 'search.gif',
	'detail' => 'file.gif',
	'detail_child' => 'file.gif',
	'nagios_cgi_child' => 'config.gif',
	'nagios_cfg_child' => 'config.gif',
	'resource_cfg_child' => 'template.gif',
	'pre_flight_test_child' => 'preflight.gif',
	'build_instance_child' => 'build.gif',
	'export_child' => 'export.gif',
	'setup' => 'config.gif',
	'nagios_cgi_configuration' => 'config.gif',
	'nagios_main_configuration' => 'config.gif',
	'nagios_resource_macros' => 'template.gif',
	'load' => 'load.gif',
	'pre_flight_test' => 'preflight.gif',
	'commit' => 'commit.gif',
	'contacts' => 'user.gif',
	'contacts_child' => 'user.gif',
	'contacts_new' => 'user_new.gif',
	'contact_groups' => 'users.gif',
	'contact_groups_child' => 'users.gif',
	'contact_groups_new' => 'users_new.gif',
	'contact_templates' => 'user.gif',
	'contact_templates_child' => 'user.gif',
	'contact_templates_new' => 'user_new.gif',
	'commands' => 'command.gif',
	'commands_new' => 'command.gif',
	'commands_child' => 'command.gif',
	'escalations' => 'paging.gif',
	'escalations_new' => 'paging.gif',
	'escalations_child' => 'paging.gif',
	'escalation_trees_new' => 'paging.gif',
	'escalation_trees_child' => 'paging.gif',
	'notifications_on' => 'paging.gif',
	'notifications_off' => 'paging.gif',
	'escalation_trees' => 'paging.gif',
	'host_groups_new' => 'hostgroup_add.gif',
	'host_groups' => 'hostgroup.gif',
	'groups_child' => 'hostgroup_sm.gif',
	'groups_new' => 'hostgroup_add.gif',
	'groups' => 'hostgroup.gif',
	'macros' => 'template.gif',
	'macros_new' => 'template.gif',
	'macros_child' => 'template.gif',
	'host_groups_child' => 'hostgroup_sm.gif',
	'host_wizard' => 'clone_host.gif',
	'clone_host' => 'clone_host.gif',
	'import' => 'clone_host.gif',
	'discover' => 'clone_host.gif',
	'hosts' => 'server.gif',
	'hosts_child' => 'serversm.gif',
	'host_services' => 'service-blue.gif',
	'host_services_child' => 'service-blue.gif',
	'parent_child' => 'parent_child.gif',
	'parent_child_child' => 'parent_child.gif',
	'parent_child_new' => 'parent_child_add.gif',
	'host_dependencies' => 'parent_child.gif',
	'host_dependencies_child' => 'parent_child.gif',
	'host_dependencies_new' => 'parent_child_add.gif',
	'host_externals' => 'template.gif',
	'host_externals_new' => 'template.gif',
	'host_externals_child' => 'template.gif',
	'host_templates' => 'template.gif',
	'host_templates_new' => 'template.gif',
	'host_templates_child' => 'template.gif',
	'host_extended_info' => 'template.gif',
	'host_extended_info_new' => 'template.gif',
	'host_extended_info_child' => 'template.gif',
	'profiles' => 'profile.gif',
	'profiles_new' => 'profile.gif',
	'profiles_child' => 'profile.gif',
	'host_profiles' => 'profile.gif',
	'host_profiles_new' => 'profile.gif',
	'host_profiles_child' => 'profile.gif',
	'service_profiles' => 'profile.gif',
	'service_profiles_new' => 'profile.gif',
	'service_profiles_child' => 'profile.gif',
	'profile_importer' => 'load.gif',
	'services' => 'service-blue.gif',
	'new_service' => 'service-blue-add.gif',
	'clone_service' => 'service-blue-add.gif',
	'services_child' => 'service-blue.gif',
	'service_templates' => 'template.gif',
	'service_templates_new' => 'template.gif',
	'service_templates_child' => 'template.gif',
	'service_groups' => 'service-group.gif',
	'service_groups_new' => 'service-group-add.gif',
	'service_groups_child' => 'service-group.gif',
	'service_dependencies' => 'template.gif',
	'service_dependencies_new' => 'template.gif',
	'service_dependencies_child' => 'template.gif',
	'run_externals' => 'template.gif',
	'service_externals' => 'template.gif',
	'service_externals_new' => 'template.gif',
	'service_externals_child' => 'template.gif',
	'service_extended_info' => 'template.gif',
	'service_extended_info_new' => 'template.gif',
	'service_extended_info_child' => 'template.gif',
	'profiles' => 'profile.gif',
	'time_periods_new' => 'time.gif',
	'time_periods' => 'time.gif',
	'time_periods_child' => 'time.gif',
	'notifications' => 'paging.gif',
	'pre_flight' => 'preflight.gif',
	'users' => 'user.gif',
	'users_child' => 'user.gif',
	'users_new' => 'user_new.gif',
	'user_groups_new' => 'users_new.gif',
	'user_groups_child' => 'users.gif',
	'user_groups' => 'users.gif',
	'commit' => 'commit.gif',
	'export' => 'export.gif',
	'host_delete_tool' => 'server_delete.gif',
	'service_delete_tool' => 'service_delete.gif',
	'line' => 'empty.gif',
	'plus' => 'nolines_plus.gif',
	'plusbottom' => 'nolines_plus.gif',
	'minus' => 'nolines_minus.gif',
	'minusbottom' => 'nolines_minus.gif',
	'join' => 'empty.gif',
	'joinbottom' => 'empty.gif'
);
my $x = qq(
	'line' => 'line.gif',
	'plus' => 'plus.gif',
	'plusbottom' => 'plusbottom.gif',
	'minus' => 'minus.gif',
	'minusbottom' => 'minusbottom.gif',
	'join' => 'join.gif',
	'joinbottom' => 'joinbottom.gif'
);

sub root_tree(@) {
	my @menus = @{$_[1]};
	my %sub_menus = %{$_[2]};
	my $top_menu = $_[3];
	my $session_id = $_[4];
	my $ez = $_[5];
	my $level = 1;
	my $view = $top_menu;
	$top_menu =~ s/time_periods/time Periods/g;
	$top_menu =~ s/host_groups/host Groups/g;
	my $tree = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<table cellspacing="2" cellpadding="1" width="100%" border=0>
<tr>
<td>
<SCRIPT language="JavaScript">
function get_nodes(img_name, type, level, node, divid, anchor, qstr) {
@{[&$Instrument::show_trace_as_javascript_comment()]}
//	alert(type)
//	alert(level)
//	alert(node)
//	alert(qstr)
	var shortStr = "minus";
	var re = new RegExp(shortStr, "g");
	if (document[img_name].src) {
		if (document[img_name].src.match(re)) {
			var shortStr = "bottom";
			var re = new RegExp(shortStr, "g");
			if (document[img_name].src.match(re)) {
				eval("document[img_name].src = '/monarch/images/$gif{'plusbottom'}");
			} else {
				eval("document[img_name].src = '/monarch/images/$gif{'plus'}'");
			}
			var str = '<table></table>';
			document.getElementById(divid).innerHTML = str;

		} else {
			var shortStr = "bottom";
			var re = new RegExp(shortStr, "g");
			if (document[img_name].src.match(re)) {
				eval("document[img_name].src = '/monarch/images/$gif{'minusbottom'}'");
			} else {		
				eval("document[img_name].src = '/monarch/images/$gif{'minus'}'");
			}	
			get_tree( ['view', type, level, node, qstr, 'sub_type', 'EZ', 'CGISESSID', 'NO_CACHE'], [ divid ] )
			var objDiv = document.getElementById(divid);
			objDiv.scrollTop = objDiv.scrollHeight;

		}
	} else {
		var str = '<table></table>';
		document.getElementById(divid).innerHTML = str;
		eval("document[img_name].src = '/monarch/images/$gif{'plus'}'");
	}
	window.location.href = window.location.href + anchor;
}
</SCRIPT>

<table cellspacing="0" cellpadding="0" width="100%" border=0>
<tr>
<td><b>\u$top_menu</b></td>
<input type=hidden id=view name=view value="$view">
</tr>
</table>
</td>
</tr>);
	my $i = 0;
	my $id = time;
	foreach my $menu (@menus) {
		my $name = $menu;
		$name =~ s/_/ /g;
		$i++;
		my $menu_gif = $menu;
		if ($menu =~ /^copy$|^modify$|^new$/i) { $menu_gif = $view	}
		if ($sub_menus{$menu}) {
			$id++;
			my $plus_image = $gif{'plusbottom'};
			if ($menus[$i]) { $plus_image = $gif{'plus'} }
			my $anchor = "#$level$id";
			$tree .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
<table cellspacing="0" cellpadding="0" width="100%" border=0>
<tr>
<td width=3px rowspan=2><a class=left href="#" onClick="get_nodes('img_name_$level$id','type_$level$id','level_$level$id','node_$level$id','$menu$id','$anchor','qstr_$level$id');">
<img name=img_name_$level$id id=img_name_$level$id src=$doc_root_monarch/images/$plus_image height=18 width=18 border=0></a>
</td>
<td width=10px><img src=$doc_root_monarch/images/$gif{$menu_gif} border=0>
</td>
<td>
<input type=hidden id=level_$level$id name=level_$level$id value="$level">
<input type=hidden id=type_$level$id name=type_$level$id value="$menu">
<input type=hidden id=node_$level$id name=node_$level$id value="$menu">
<input type=hidden id=last_node_$level$id name=last_node_$level$id value="">
<input type=hidden id=sub_type name=sub_type value="">
<input type=hidden id=EZ name=EZ value="$ez">
<input type=hidden id=CGISESSID name=CGISESSID value="$session_id">
<input type=hidden id=qstr_$level$id name=qstr_$level$id value="CGISESSID=$session_id&update_main=1&nocache=$id&top_menu=$top_menu&">
<a class=left href="#$level$id" onClick="get_nodes('img_name_$level$id','type_$level$id','level_$level$id','node_$level$id','$menu$id','$anchor','qstr_$level$id');">&nbsp;\u$name</a>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<tr>
<td>
<div id=$menu$id>
</div>
</td>
</tr>);		
		} else {
			my $monarch_exe = 'monarch.cgi';
			my $obj_view = '';
			my $fill_image = $gif{'joinbottom'};
			if ($menus[$i]) { $fill_image = $gif{'join'} }
			if ($ez) {
				$monarch_exe = 'monarch_ez.cgi';
				$obj_view = "&view=$menu";
				if ($menu eq 'new') { $obj_view = "&view=$view&new=1"; }
			} elsif ($menu =~ /^new/) {
				if ($view eq 'time_periods') {
					$obj_view = '&view=design&obj=time_periods&task=new';
				} elsif ($view eq 'commands') {
					$obj_view = '&view=commands&obj=commands&task=new';
				} elsif ($view eq 'groups') {
					$obj_view = '&view=groups&obj=groups&obj_view=new';
				} elsif ($view eq 'services') {
					$obj_view = '&view=service&obj=services&obj_view=new';
				} else {
					$obj_view = '&obj_view=new';
				}
			} elsif ($menu eq 'clone_service') {
				$obj_view = '&view=service&obj=services&obj_view=clone';
			} elsif ($view eq 'control' || $view eq 'tools') {
				$obj_view = "&view=$view&obj=$menu";
			} else {
				$obj_view = "&view=$menu&obj=$top_menu";
			}
			$tree .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
<table cellspacing="1" cellpadding="1" width="100%" border=0>
<tr>
<td width=20px><img src=$doc_root_monarch/images/$gif{$menu_gif} border=0></td>
<td>
&nbsp;<a class=left href="$cgi_dir/$monarch_exe?update_main=1&CGISESSID=$session_id&top_menu=$view$obj_view" target="monarch_main">\u$name</a>
</td>
</tr>
</table>
</td>
</tr>);
#<td width=3px><img src=$doc_root_monarch/images/$fill_image border=0></td>
		}
	}
	return $tree;
}

sub child_tree(@) {
	my @nodes = @{$_[1]};
	my $type = $_[2];
	my $level = $_[3];
	my $levels = $_[4];
	my $last_node = $_[5];
	my $qstr = $_[6];
	my $sub_type = $_[7];
	my $ez = $_[8];
	use URI::Escape;
	my $id = rand();
	my $i = 0;
	my $next_level = $level + 1;
	my $table = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<table cellspacing="0" cellpadding="0" width="100%" border=0>);
	my $indent = undef;
	for (my $l = 1; $l <= $level; $l++) {
		$indent .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td width=3px><img src=$doc_root_monarch/images/$gif{'line'}></td>);
	}
	if (@nodes) {
		my $obj_view = '';
		if ($type eq 'host_services' && $level == $levels) {
			$last_node = uri_escape($last_node);
			$id++;
			$obj_view = '&name=';
			$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	$indent
	<td width=3px>&nbsp;</td>
	<td width=20px><a class=left href="#$level$id"><img src=$doc_root_monarch/images/$gif{"detail"} border=0></a></td>
	<td>
	<a class=left href="$cgi_dir/monarch.cgi?$qstr$obj_view$last_node" target="monarch_main">&nbsp;Detail</a>
	</td>
	</tr>
	</table>
	</td>
	</tr>);
			$obj_view = "&name=$last_node&obj_view=service_detail&form_service=1&service_name=";
		}
		
		foreach my $node (@nodes) {
			$id++;
			$i++;
			my $name = uri_escape($node);
			my $plus_image = $gif{'plusbottom'};
			if ($nodes[$i]) { $plus_image = $gif{'plus'} }
			my $anchor = "#$level$id";
			my $monarch_exe = 'monarch.cgi';
			if ($ez) { $monarch_exe = 'monarch_ez.cgi' }
			if ($ez && $sub_type eq 'time_periods') { $type = 'time_periods' }
			if ($node eq 'new') {
				if ($ez) {
					$obj_view = "view=$last_node&new=1";
				} elsif ($last_node eq 'host_groups') {
					$obj_view = 'view=design&obj=hostgroups&task=new';
				} elsif ($sub_type eq 'host') {
					$obj_view = "obj_view=new&type=host";
				} elsif ($sub_type eq 'service') {
					$obj_view = "view=$type&obj_view=new&task=new&type=service";
				} elsif ($last_node eq 'service_templates') {
					$obj_view = "view=service_template&obj=service_templates&task=new";
				} elsif ($last_node eq 'service_groups') {
					$obj_view = "view=service_group&obj=service_groups&task=new";
				} elsif ($last_node eq 'service_dependencies') {
					$obj_view = "view=design&obj=service_dependency_templates&task=new";
				} elsif ($last_node eq 'contacts') {
					$obj_view = "view=design&obj=contacts&task=new";
				} elsif ($last_node eq 'users') {
					$obj_view = "view=control&obj=users&task=new";
				} elsif ($last_node eq 'user_groups') {
					$obj_view = "view=control&obj=user_groups&task=new";
				} elsif ($last_node eq 'contact_groups') {
					$obj_view = "view=design&obj=contactgroups&task=new";
				} elsif ($last_node eq 'host_profiles') {
					$obj_view = "view=host_profile&obj=profiles&obj_view=new";
				} elsif ($last_node eq 'service_profiles') {
					$obj_view = "view=service_profile&obj=profiles&obj_view=new";
				} elsif ($last_node eq 'host_extended_info') {
					$obj_view = "view=design&obj=extended_host_info_templates&task=new";
				} elsif ($last_node eq 'service_extended_info') {
					$obj_view = "view=design&obj=extended_service_info_templates&task=new";
				} elsif ($last_node =~ /template|extended_info/) {
					$obj_view = "view=design&obj=$last_node&task=new";
				} else {
					$obj_view = "view=$last_node&obj=$last_node&task=new";
				}
				$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	$indent
	<td width=3px>&nbsp;</td>
	<td width=20px><a class=left href="#$level$id"><img src=$doc_root_monarch/images/$gif{"$type\_new"} border=0></a></td>
	<td>
	<a class=left href="$cgi_dir/$monarch_exe?$qstr$obj_view" target="monarch_main">&nbsp;New</a>
	</td>
	</tr>
	</table>
	</td>
	</tr>);

			} elsif ($level == $levels) {
				my $gif = $gif{"$type\_child"};
				if ($type eq 'groups') { 
					$gif = $gif{"$node\_child"};
					$obj_view = "obj_view=$node&name=$last_node";
					$name = undef;
					$node = "\u$node";
					$node =~ s/_/ /g;
				}
				$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	$indent
	<td width=3px>&nbsp;</td>
	<td width=20px><a class=left href="#$level$id"><img src=$doc_root_monarch/images/$gif border=0></a></td>
	<td>
	<a class=left href="$cgi_dir/$monarch_exe?$qstr$obj_view$name" target="monarch_main">&nbsp;$node</a>
	</td>
	</tr>
	</table>
	</td>
	</tr>);
			} else {
				$node =~ s/copy/Copy/;
				$node =~ s/modify/Modify/;
				my $gif = $gif{"$type\_child"};
				if ($node eq 'copy') { $gif = $gif{"$type\_new"} }
				$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	$indent
	<input type=hidden id=type name=type value=$type>
	<td width=3px><a class=left href="#" onClick="get_nodes('img_name_$level$id','type_$level$id','level_$level$id','node_$level$id','$type$level$id','$anchor','qstr_$level$id');">
	<img name=img_name_$level$id id=img_name_$level$id src=$doc_root_monarch/images/$plus_image height=18 width=18 border=0></a>
	</td>
	<td width=20px><img src=$doc_root_monarch/images/$gif border=0></td>
	<td>
	<input type=hidden id=level_$level$id name=level_$level$id value="$next_level">
	<input type=hidden id=type_$level$id name=type_$level$id value="$type">
	<input type=hidden id=node_$level$id name=node_$level$id value="$name">
	<input type=hidden id=qstr_$level$id name=qstr_$level$id value="$qstr">
	<input type=hidden id=sub_type name=sub_type value="$sub_type">
	<a class=left href="#$level$id" onClick="get_nodes('img_name_$level$id','type_$level$id','level_$level$id','node_$level$id','$type$level$id','$anchor','qstr_$level$id');">&nbsp;$node</a>
	</td>
	</tr>
	</table>
	</td>
	</tr>
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	<td>
	<div id=$type$level$id>
	</div>
	</td>
	</table>
	</td>
	</tr>);
			}
		}
	} elsif ($type eq 'host_services' && $level == $levels) {
		$last_node = uri_escape($last_node);
		$id++;
		my $obj_view = '&name=';
		$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	$indent
	<td width=3px>&nbsp;</td>
	<td width=20px><a class=left href="#$level$id"><img src=$doc_root_monarch/images/$gif{"detail"} border=0></a></td>
	<td>
	<a class=left href="$cgi_dir/monarch.cgi?$qstr$obj_view$last_node" target="monarch_main">&nbsp;Detail</a>
	</td>
	</tr>
	</table>
	</td>
	</tr>);

	} else {
		$table .= qq(
	<tr>
	<td>
	<table cellspacing="0" cellpadding="0" width="100%" border=0>
	<tr>
	<td width=3px>&nbsp;</td>
	<td width=20px>nothing found
	</td>
	</tr>
	</table>
	</td>
	</tr>);
	}
	$table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>);
	return $table;
}

1;
