/*
************************************************************************
*
*   FMText.c - FrameMaker text drawing
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 01/05/27
*   Pathname of SCCS file     : /tmp_mnt/net/sn/homeb/rkoradi/molmol-master/sg/src/fm/SCCS/s.FMText.c
*   SCCS identification       : 1.4
*
************************************************************************
*/

#include "fm_text.h"

#include <sg.h>
#include <sg_map.h>
#include <sg_plot.h>

static BOOL GreekOn = FALSE;
static BOOL Sup;

static void
setGreek(BOOL onOff, BOOL inStr)
{
  if (onOff == GreekOn)
    return;

  if (inStr)
    SgPlotOutputStr("'>\n");

  SgPlotOutputStr("  <Font <FFamily ");

  if (onOff)
    SgPlotOutputStr("Symbol");
  else
    SgPlotOutputStr("Helvetica");

  SgPlotOutputStr(">>\n");

  if (inStr)
    SgPlotOutputStr("  <String `");

  GreekOn = onOff;
}

static void
setSup(void)
{
  SgPlotOutputStr("  <Font <FSupScript Yes>>\n");
  Sup = TRUE;
}

static void
setSub(void)
{
  SgPlotOutputStr("  <Font <FSubScript Yes>>\n");
  Sup = FALSE;
}

static void
setNorm(void)
{
  if (Sup)
    SgPlotOutputStr("  <Font <FSupScript No>>\n");
  else
    SgPlotOutputStr("  <Font <FSubScript No>>\n");
}

static void
showStr(char *str, int n)
{
  char buf[2];
  BOOL greekNext;
  int i;

  if (n == 0)
    return;

  SgPlotOutputStr("  <String `");

  buf[1] = '\0';
  greekNext = FALSE;
  for (i = 0; i < n; i++) {
    if (str[i] == '\\') {
      greekNext = TRUE;
    } else {
      setGreek(greekNext, TRUE);
      buf[0] = str[i];
      SgPlotOutputStr(buf);
      greekNext = FALSE;
    }
  }

  SgPlotOutputStr("'>\n");

  setGreek(greekNext, FALSE);
}

void
SgFMDrawText(float x[2], char *str)
{
  float xm[2];
  int startI, currI;

  SgPlotOutputStr("<TextLine <GroupID 1>\n");

  SgVpMapPoint(xm, x);
  SgPlotOutputStr("  <TLOrigin ");
  SgPlotOutputFloat(xm[0]);
  SgPlotOutputStr(" ");
  SgPlotOutputFloat(xm[1]);
  SgPlotOutputStr(">\n");

  GreekOn = FALSE;

  startI = 0;
  currI = 0;
  for (;;) {
    if (str[currI] == '_' || str[currI] == '^') {
      showStr(str + startI, currI - startI);

      if (str[currI] == '_')
        setSub();
      else
        setSup();

      currI++;

      if (str[currI] == '{') {
        currI++;
        startI = currI;
        while (str[currI] != '}' && str[currI] != '\0')
          currI++;
        showStr(str + startI, currI - startI);
      } else if (str[currI] == '\\') {
        showStr(str + currI, 2);
        currI++;
      } else {
        showStr(str + currI, 1);
      }
      setNorm();

      if (str[currI] != '\0')
        currI++;

      startI = currI;
    } else if (str[currI] == '\0') {
      showStr(str + startI, currI - startI);
      break;
    } else {
      currI++;
    }
  }

  SgPlotOutputStr(">\n");
}

void
SgFMSetFontSize(float size)
{
  float x, y, w, h;

  SgGetViewport(&x, &y, &w, &h);
  SgPlotOutputStr("<Font <FSize ");
  SgPlotOutputFloat(1.5f * size * (0.5f * h));
  SgPlotOutputStr(" in>>\n");
}
