type atom = private int
;;

val make_atom : int -> atom ;; 
external from_atom : atom -> int = "%identity" ;; 
type t = private
  | Bfalse
  | Btrue
  | Batom of atom
  (* begin
       rule Batom (p) -> Bp (p, Btrue, Bfalse)
     end *)
  | Bnot of t
  (* begin
       involutive
       rule Bnot (Bp ((p, x, y))) -> Bp (p, Bnot x, Bnot y)
       rule Bnot (Btrue) -> Bfalse
       rule Bnot (Bfalse) -> Btrue
     end *)
  | Band of t * t
  (* begin
       absorbent (Bfalse)
       neutral (Btrue)
       rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q = 0
         -> Bp (p, Band (x, z), Band (y, w))
       rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q < 0
         -> Bp (p, Band (x, Bp (q, z, w)), Band (y, Bp (q, z, w)))
       rule Band ((Bp ((q, x, y)), Bp ((p, z, w)))) when compare_atom p q < 0
         -> Bp (p, Band (Bp (q, x, y), z), Band (Bp (q, x, y), w))
     end *)
  | Bor of t * t
  (* begin
       neutral (Bfalse)
       absorbent (Btrue)
       rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q = 0
         -> Bp (p, Bor (x, z), Bor (y, w))
       rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q < 0
         -> Bp (p, Bor (x, Bp (q, z, w)), Bor (y, Bp (q, z, w)))
       rule Bor ((Bp ((q, x, y)), Bp ((p, z, w)))) when compare_atom p q < 0
         -> Bp (p, Bor (Bp (q, x, y), z), Bor (Bp (q, x, y), w))
     end *)
  | Bxor of t * t
  (* begin
       neutral (Bfalse)
       rule Bxor ((x, Btrue)) -> Bnot x
       rule Bxor ((Btrue, x)) -> Bnot x
       rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q = 0
         -> Bp (p, Bxor (x, z), Bxor (y, w))
       rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when compare_atom p q < 0
         -> Bp (p, Bxor (x, Bp (q, z, w)), Bxor (y, Bp (q, z, w)))
       rule Bxor ((Bp ((q, x, y)), Bp ((p, z, w)))) when compare_atom p q < 0
         -> Bp (p, Bxor (Bp (q, x, y), z), Bxor (Bp (q, x, y), w))
     end *)
  | Bimplies of t * t
  (* begin
       rule Bimplies ((x, y)) -> Bor (Bnot x, y)
     end *)
  | Bp of atom * t * t
  (* begin
       rule Bp ((_, x, y)) when compare x y = 0 -> x
     end *)
;;

val bfalse : t ;;  val btrue : t ;;  val batom : atom -> t ;; 
val bnot : t -> t ;;  val band : t * t -> t ;;  val bor : t * t -> t ;; 
val bxor : t * t -> t ;;  val bimplies : t * t -> t ;; 
val bp : atom * t * t -> t ;;  val eq_t : t -> t -> bool ;; 
