README.access                           present in mlmmj versions >= 0.8.0
                                        (moderate tag since 1.1.0-RC3)
Access control in mlmmj
=======================

If the file listdir/control/access is present, access control is enabled.

NOTE: the default action is to deny access (reject the mail), so an empty
access control file will cause mlmmj to reject all posts, whereas a non-
existant file will change nothing, and mlmmj will behave as usual.

Each header in the mail is tested against each rule, rule by rule. That is,
all headers are first tested against the first rule, then all headers are
tested against the second rule, and so on.

The first rule to match a header decides which action to take - allow, deny,
discard or moderate the post.

The syntax is quite simple: action[ [!]regexp]
- "Action" can be "allow", "send", "deny", "discard" or "moderate".
- The optional "!" makes the rule a match, if NO header matches the regular
  expression.
- "Regexp" is a POSIX.2 extended regular expression. Matching is done case
  insensitive.

The action "allow" will pass the mail on to the next step in processing. The
mail may still be held for moderation, if it would have been so without access
rules.

The action "send" will send the mail unconditionally. It will not be
moderated, nor subject to subonlypost, nor modnonsubposts.

The action "deny" will not send the mail to the mailing list, but will send a
rejection mail to the sender.

The action "discard" will not send the mail to the list, and will not send a
rejection mail.

The action "moderate" will hold the mail for moderation.

IMPORTANT: if "moderate" is used then don't forget to add people who should
           function as moderators in listdir/control/moderators


The flow through the access system is something like this:

````
               deny       +------+
       +----------------->| deny |
       |                  +------+
       |
       |       discard    +---------+
       |  +-------------->| discard |
       |  |               +---------+
       |  |                   ^
       |  |                   | expire
    +--------+ moderate   +------+           +------+
--->| access |----------->| hold |---------->| send |--->
    +--------+            +------+ confirm   +------+
       |  |                   ^                ^  ^
       |  |                   | yes            |  |
       |  |    allow      +--------------+ no  |  |
       |  +-------------->| moderation * |-----+  |
       |                  +--------------+        |
       |       send                               |
       +------------------------------------------+
````

* modnonsubposts is also processed here, and subonlypost (the flow
  may be to deny or discard for subonlypost without modnonsubposts).


First a simple example. This rule set will reject any mail that is NOT plain
text, or has a subject that contains "BayStar", and allow anything else:

````
 deny !^Content-Type: text/plain
 deny ^Subject:.*BayStar
 allow
````

To allow only text mails, but have the moderators moderate every html mail one
would use this:

````
 allow ^Content-Type: text/plain
 moderate ^Content-Type: text/html
 deny
````

Now on to a more advanced example. Morten can post anything, Mads Martin can
post if the subject does not contain "SCO". Everything else is denied:

````
 allow ^From: Morten
 deny ^Subject:.*SCO
 allow ^From: Mads Martin
 deny
````

The last rule (deny) can be left out, as deny is the default action.

A third example. Deny any mails with "discount", "weightloss", or "bonus" in
the subject. Allow PGP signed and plain text mails. Anything else is denied:

````
 deny ^Subject:.*discount
 deny ^Subject:.*weightloss
 deny ^Subject:.*bonus
 allow ^Content-Type: multipart/signed
 allow ^Content-Type: text/plain
````

