# MinIO S3 Gateway [![Slack](https://slack.min.io/slack?type=svg)](https://slack.min.io)

MinIO S3 Gateway adds MinIO features like MinIO Browser and disk caching to AWS S3 or any other AWS S3 compatible service.

## Run MinIO Gateway for AWS S3
As a prerequisite to run MinIO S3 gateway, you need valid AWS S3 access key and secret key by default. Optionally you can also set custom access/secret key, when you have rotating AWS IAM credentials or AWS credentials through environment variables (i.e. AWS_ACCESS_KEY_ID)

### Using Docker
```
docker run -p 9000:9000 --name minio-s3 \
 -e "MINIO_ACCESS_KEY=aws_s3_access_key" \
 -e "MINIO_SECRET_KEY=aws_s3_secret_key" \
 minio/minio gateway s3
```

### Using Binary
```
export MINIO_ACCESS_KEY=aws_s3_access_key
export MINIO_SECRET_KEY=aws_s3_secret_key
minio gateway s3
```

### Using Binary in EC2
Using IAM rotating credentials for AWS S3
```
export MINIO_ACCESS_KEY=custom_access_key
export MINIO_SECRET_KEY=custom_secret_key
minio gateway s3
```

MinIO gateway will automatically look for list of credential styles in following order, if your backend URL is AWS S3.

- AWS env vars (i.e. AWS_ACCESS_KEY_ID)
- AWS creds file (i.e. AWS_SHARED_CREDENTIALS_FILE or ~/.aws/credentials)
- IAM profile based credentials. (performs an HTTP call to a pre-defined endpoint, only valid inside configured ec2 instances)

## Run MinIO Gateway for AWS S3 compatible services
As a prerequisite to run MinIO S3 gateway on an AWS S3 compatible service, you need valid access key, secret key and service endpoint.

### Using Docker
```
docker run -p 9000:9000 --name minio-s3 \
 -e "MINIO_ACCESS_KEY=access_key" \
 -e "MINIO_SECRET_KEY=secret_key" \
 minio/minio gateway s3 https://s3_compatible_service_endpoint:port
```

### Using Binary
```
export MINIO_ACCESS_KEY=access_key
export MINIO_SECRET_KEY=secret_key
minio gateway s3 https://s3_compatible_service_endpoint:port
```

## MinIO Caching
MinIO edge caching allows storing content closer to the applications. Frequently accessed objects are stored in a local disk based cache. Edge caching with MinIO gateway feature allows

- Dramatic improvements for time to first byte for any object.
- Avoid S3 [data transfer charges](https://aws.amazon.com/s3/pricing/).

Refer [this document](https://docs.min.io/docs/minio-disk-cache-guide.html) to get started with MinIO Caching.

## MinIO Browser
MinIO Gateway comes with an embedded web based object browser. Point your web browser to http://127.0.0.1:9000 to ensure that your server has started successfully.

![Screenshot](https://github.com/minio/minio/blob/master/docs/screenshots/minio-browser-gateway.png?raw=true)

With MinIO S3 gateway, you can use MinIO browser to explore AWS S3 based objects.

### Known limitations

- Bucket notification APIs are not supported.

## Explore Further

- [`mc` command-line interface](https://docs.min.io/docs/minio-client-quickstart-guide)
- [`aws` command-line interface](https://docs.min.io/docs/aws-cli-with-minio)
- [`minio-go` Go SDK](https://docs.min.io/docs/golang-client-quickstart-guide)
