# Minio S3 Gateway [![Slack](https://slack.minio.io/slack?type=svg)](https://slack.minio.io)

Minio S3 Gateway adds Minio features like Minio Browser and disk caching to AWS S3 or any other AWS S3 compatible service.

## Run Minio Gateway for AWS S3

As a prerequisite to run Minio S3 gateway, you need valid AWS S3 access key and secret key.

### Using Docker

```
docker run -p 9000:9000 --name minio-s3 \
 -e "MINIO_ACCESS_KEY=aws_s3_access_key" \
 -e "MINIO_SECRET_KEY=aws_s3_secret_key" \
 minio/minio gateway s3
```

### Using Binary

```
export MINIO_ACCESS_KEY=aws_s3_access_key
export MINIO_SECRET_KEY=aws_s3_secret_key
minio gateway s3
```

## Run Minio Gateway for AWS S3 compatible services

As a prerequisite to run Minio S3 gateway on an AWS S3 compatible service, you need valid access key, secret key and service endpoint.

### Using Docker

```
docker run -p 9000:9000 --name minio-s3 \
 -e "MINIO_ACCESS_KEY=access_key" \
 -e "MINIO_SECRET_KEY=secret_key" \
 minio/minio gateway s3 --address https://s3_compatible_service_endpoint:port
```

### Using Binary

```
export MINIO_ACCESS_KEY=access_key
export MINIO_SECRET_KEY=secret_key
minio gateway s3 --address https://s3_compatible_service_endpoint:port
```

## Minio Caching

Minio edge caching allows storing content closer to the applications. Frequently accessed objects are stored in a local disk based cache. Edge caching with Minio gateway feature allows

- Dramatic improvements for time to first byte for any object.
- Avoid S3 [data transfer charges](https://aws.amazon.com/s3/pricing/).

Refer [this document](https://docs.minio.io/docs/minio-disk-cache-guide.html) to get started with Minio Caching.

## Minio Browser

Minio Gateway comes with an embedded web based object browser. Point your web browser to http://127.0.0.1:9000 to ensure that your server has started successfully.

![Screenshot](https://github.com/minio/minio/blob/master/docs/screenshots/minio-browser-gateway.png?raw=true)

With Minio S3 gateway, you can use Minio browser to explore AWS S3 based objects.

### Known limitations

- Bucket notification APIs are not supported.

## Explore Further

- [`mc` command-line interface](https://docs.minio.io/docs/minio-client-quickstart-guide)
- [`aws` command-line interface](https://docs.minio.io/docs/aws-cli-with-minio)
- [`minio-go` Go SDK](https://docs.minio.io/docs/golang-client-quickstart-guide)
