
#include "mindless.h"

struct playarea {
    struct game *game;
    int card_width, card_height;
    int size;
    int alloced;
    struct table_card **cardlist;
    int pic_type;
    float ratio;
    char *background;
    GdkPixbuf *background_pix;
    int background_type;
    GtkWidget *darea;
    GdkFont *font;
    GdkGC *drag_gc;
    GdkGC *color_gc;
    GtkWidget *popup_menu;
    GtkWidget *opponent_menu;

    /* Information about the card being dragged */
    int drag_cid;
    int box_drawn;
    struct point box;
    struct point click_location;
};

#define PLAYAREA_ART_ONLY	0
#define PLAYAREA_NAME_ONLY	1
#define PLAYAREA_ART_AND_NAME	2

#define PLAYAREA_TILE		0
#define PLAYAREA_CENTER		1

struct playarea *playarea_new (struct game *game);
void playarea_refresh_prefs (struct playarea *zone);
void playarea_repaint (struct playarea *zone);
void playarea_add_card (struct playarea *, struct table_card *);
void playarea_paint_card (struct playarea *zone, struct table_card *tcard);
int playarea_move_card (struct playarea *, int, int, int);
int playarea_remove_card (struct playarea *zone, int cid);
int playarea_dragged_card (struct playarea *zone);
struct table_card *playarea_get_table_card (struct playarea *zone, int cid);
void playarea_reset (struct playarea *zone);
void playarea_all_cards_stop_attacking (struct playarea *zone);
int is_shift_down (void);
