
typedef int SOCKET;

struct timeval;

struct opponent {
    SOCKET socket;
    int tag;
    int protocol;
    int flags;
    char *text;
    struct timeval *last_ping;
};

#define is_server_flag      0x01
#define local_wants_new     0x02
#define opponent_wants_new  0x04

/* Define this to use the crappy Apprentice protocol. */
#define APPRENTICE 1

extern const int default_port;

char *get_ip_address_text (void);
void init_opponent_signals (void);
SOCKET create_socket_and_listen (int port_num);
void close_socket (SOCKET);

struct opponent *accept_new_opponent (SOCKET socket);
struct opponent *call_new_opponent (char *hostname, int port_num);
void opponent_listen (struct game *game);
void opponent_destroy (struct opponent *opponent);

void game_become_client (struct game *game);
void game_become_server (struct game *game);
int game_should_restart (struct game *game);

void send_version_number (struct game *game);
void send_player_setup (struct game *game);
void send_setup_end (struct game *game);
void send_start_new_game (struct game *game);
void send_player_name (struct game *game);
void send_draw_cards (struct game *game, int qty);
void send_starting_message (struct game *game, char *message);
void send_message (struct game *game, char *message);
void send_shuffle (struct game *game);
void send_flip_coin (struct game *game, int res);
void send_roll_die (struct game *game, int res, int size);
void send_game_phase (struct game *game);
void send_game_turn (struct game *game);
void send_player_life (struct game *game);
void send_card_counters (struct game *game, struct table_card *tcard);
void send_card_location (struct game *game, struct table_card *tcard);
void send_card_zone (struct game *game, struct card_move *cmp);
void send_unplay_card (struct game *game, int, int, int, int, int);
void send_card_order_in_zone (struct game *, int, int, int, int);
void send_card_flag (struct game *game, int cid, int flag, int state);
void send_card_controller (struct game *game, struct table_card *tcard, int);
void send_sleight_card (struct game *game, struct table_card *tcard);
void send_random_card (struct game *game, int cid, int znum);
void send_inform_peeking (struct game *game, int, int, int, int);
void send_create_card (struct game *, char *, int, int, char *, int);
void send_show_zone (struct game *, int znum, int quantity);
void send_request_new_game (struct game *, int);
void send_ping (struct game *);
void send_inform_sideboard (struct game *);
void send_peek_at_facedown (struct game *);

/*
 *  Shared by the opponent implementations.
 *  Not exported to the rest of M.A.
 */
struct rcmd_args {
    int pid;
    int cid;
    int lid;
    int value;
    char *name;
    char *text;
    int startpos;
    int qty;
    char *flag;
    int x, y;
    int width, height;
    int face;
    int border;
};

void send_opponents (struct game *, char *, ...);
void run_parsed_command (struct game *, char *, struct rcmd_args *);
void lid_to_tux (int lid, int *pidp, int *zonep);
int tux_to_lid (int pid, int znum);
void process_send_ping (struct game *, int);
void process_return_ping (struct game *, int);
#define isnewline(x) ((x == '\012') || (x == '\015'))
