#define HAND_ZONE	0
#define GRAVEYARD_ZONE	1
#define LIBRARY_ZONE	2
#define REMOVED_ZONE	3
#define SIDEBOARD_ZONE	4
#define NUM_ZONES	5

struct player {
    char *name;
    int life;
    struct deck *deck;
    struct zone *zone[NUM_ZONES];
    GtkWidget *turn_frame;
    GtkWidget *name_label;
    GtkWidget *life_label;
};

struct player *player_new (struct game *game, char *name);
void player_destroy (struct player *me);
void player_set_name (struct player *me, const char *name);
int player_get_life (struct player *me);
void player_set_life (struct player *me, int life);
struct zone *player_get_zone (struct player *me, int znum);
#define player_deck_offset(pid) (1001 + 1000*(pid))
int player_sideboard_offset (struct game *game, int pid);
int player_token_offset (struct game *game, int pid);
void player_make_labels (struct player *me, GtkWidget *player_vbox);
void player_set_turn (struct player *me, int flag);
